/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.scm.ws.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.query.SQLExecutor;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemCollection;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.eas.basedata.framework.util.EntityControlTypeUtil;
import com.kingdee.eas.basedata.master.material.IMaterialGroupStandard;
import com.kingdee.eas.basedata.master.material.MaterialGroupStandardCollection;
import com.kingdee.eas.basedata.master.material.MaterialGroupStandardFactory;
import com.kingdee.eas.basedata.master.material.MaterialGroupStandardTypeEnum;
import com.kingdee.eas.basedata.master.util.StringUtil;
import com.kingdee.eas.basedata.org.CtrlUnitInfo;
import com.kingdee.eas.basedata.org.OrgType;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.common.client.SysContext;
import com.kingdee.eas.scm.im.inv.invconfig.InventoryServerHelper;
import com.kingdee.eas.scm.im.inv.invconfig.SQLDataAccessFacadeFactory;
import com.kingdee.eas.scm.ws.app.AbstractInventoryListServiceFacadeControllerBean;
import com.kingdee.eas.scm.ws.app.WSResource;
import com.kingdee.eas.scm.ws.app.json.JSONUtils;
import com.kingdee.eas.scm.ws.app.model.InventoryListReqModel;
import com.kingdee.eas.scm.ws.app.model.InventoryListRespModel;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.util.LocaleUtils;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import org.apache.log4j.Logger;

public class InventoryListServiceFacadeControllerBean
extends AbstractInventoryListServiceFacadeControllerBean {
    private static Logger logger = Logger.getLogger((String)"com.kingdee.eas.scm.ws.app.InventoryListServiceFacadeControllerBean");
    public static final String INV_DEF_WAREHOUSE = "EgkAAABc3XG76fiu";
    public static final List<String> removeIdList = Arrays.asList("id", "FUnitID", "FMaterialID", "FStoreStatusID", "FBillEntryID", "FStorageOrgUnitID", "FStoreTypeID");
    private InventoryServerHelper util = null;
    private String tempTableName = null;
    InventoryListReqModel reqModel = null;
    private String sql = null;
    private FilterInfo filter = new FilterInfo();
    private List headList = null;
    private Set boolField = new HashSet();

    @Override
    protected String _getData(Context ctx, String reqJSON) throws BOSException {
        InventoryListRespModel resultInfo = new InventoryListRespModel();
        List<Map<String, Object>> mapList = new ArrayList<Map<String, Object>>();
        resultInfo.setStatus(1);
        if (!this.stringNotNull(reqJSON)) {
            resultInfo.setMsg(WSResource.getResource(ctx, "REQ_MODEL_IS_NULL"));
            return JSONUtils.convertObjectToJson(ctx, resultInfo);
        }
        try {
            this.reqModel = (InventoryListReqModel)JSONUtils.convertJsonToObject(ctx, reqJSON, InventoryListReqModel.class);
            if (this.reqModel.getStart() < 0 || this.reqModel.getLen() < 1 || this.reqModel.getLen() > 1000) {
                resultInfo.setMsg(WSResource.getResource(ctx, "START_LEN_ILLEGAL"));
                return JSONUtils.convertObjectToJson(ctx, resultInfo);
            }
            if (null == this.reqModel.getStorageOrgs() || this.reqModel.getStorageOrgs().length < 1) {
                resultInfo.setMsg(WSResource.getResource(ctx, "STORAGEORGS_IS_NULL"));
                return JSONUtils.convertObjectToJson(ctx, resultInfo);
            }
            this.setDefaultGroupStandard(ctx);
            this.util = new InventoryServerHelper(ctx);
            this.sql = this.util.getQuerySQL(ctx);
            this.headList = this.util.getTableHeadKeyList();
            this.boolField = this.util.getBoolPropSet();
            this.createTempTable(ctx);
            int rowCount = this.getTotalCount(ctx);
            if (rowCount > 0) {
                IRowSet rowSet = this.getRowSet(ctx, this.reqModel.getStart(), this.reqModel.getLen());
                mapList = this.dealRows(this.headList, rowSet);
            }
            resultInfo.setStatus(0);
            resultInfo.setCount(rowCount);
            resultInfo.setList(mapList);
        }
        catch (Exception e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
            resultInfo.setStatus(1);
            resultInfo.setMsg(e.getMessage());
        }
        return JSONUtils.convertObjectToJson(ctx, resultInfo);
    }

    private void setDefaultGroupStandard(Context ctx) throws BOSException {
        if (this.stringNotNull(this.reqModel.getGroupStandard())) {
            return;
        }
        CtrlUnitInfo ctrlUnitInfo = (CtrlUnitInfo)ctx.get((Object)OrgType.ControlUnit);
        IMaterialGroupStandard iMaterialGroupStandard = MaterialGroupStandardFactory.getLocalInstance((Context)ctx);
        FilterInfo filterInfoCU = EntityControlTypeUtil.getFilterInfoForControlTypeS4((String)ctrlUnitInfo.getId().toString(), (String)ctrlUnitInfo.getLongNumber());
        EntityViewInfo viewInfo = new EntityViewInfo();
        viewInfo.getSelector().add("standardType");
        viewInfo.getSelector().add("number");
        viewInfo.setFilter(filterInfoCU);
        viewInfo.setFilter(filterInfoCU);
        MaterialGroupStandardCollection groupStandardColl = iMaterialGroupStandard.getMaterialGroupStandardCollection(viewInfo);
        int size = groupStandardColl.size();
        for (int index = 0; index < size; ++index) {
            if (!groupStandardColl.get(index).getStandardType().equals((Object)MaterialGroupStandardTypeEnum.BasicStandard)) continue;
            this.reqModel.setGroupStandard(groupStandardColl.get(index).getNumber());
        }
    }

    private void createTempTable(Context ctx) throws EASBizException, BOSException {
        HashMap<String, String> conditions = new HashMap<String, String>();
        conditions.put("tempTableName", this.tempTableName);
        String createSQL = this.util.getCreateTempTableSQL();
        String finalSQL = this.getFinalSQL();
        String fieldSQL = this.util.getFieldSQL();
        this.tempTableName = SQLDataAccessFacadeFactory.getLocalInstance((Context)ctx).createTempTable(createSQL, finalSQL, fieldSQL, null);
    }

    private int getTotalCount(Context ctx) throws BOSException, SQLException {
        int count = 0;
        String sql = "select count(1) as count from " + this.tempTableName;
        IRowSet rs = new SQLExecutor(ctx, sql.toString()).executeSQL();
        while (rs.next()) {
            count = rs.getInt(1);
        }
        return count;
    }

    private IRowSet getRowSet(Context ctx, int start, int len) throws BOSException {
        StringBuilder querySQL = new StringBuilder();
        querySQL.append(" select * from ").append(this.tempTableName);
        querySQL.append(" ORDER BY ");
        querySQL.append(" FStorageOrgUnitID ASC,FWarehouseID ASC,ID ASC ");
        return SQLDataAccessFacadeFactory.getLocalInstance((Context)ctx).getRowSet(querySQL.toString(), start, len);
    }

    private List<Map<String, Object>> dealRows(List headList, IRowSet rs) throws SQLException {
        ArrayList<Map<String, Object>> resultList = new ArrayList<Map<String, Object>>();
        String key = null;
        HashMap<String, Object> map = null;
        while (rs.next()) {
            map = new HashMap<String, Object>();
            int size = headList.size();
            for (int i = 0; i < size; ++i) {
                key = headList.get(i).toString();
                if (removeIdList.contains(key)) continue;
                if (this.boolField.contains(key)) {
                    map.put(key, rs.getBoolean(key));
                    continue;
                }
                map.put(key, rs.getObject(key));
            }
            resultList.add(map);
        }
        return resultList;
    }

    private String getFilterSQL() {
        int storeType;
        FilterItemInfo templateFilterItemInfo;
        HashSet<String> numberSet;
        if (this.filter == null || null == this.reqModel) {
            return null;
        }
        FilterItemCollection items = this.filter.getFilterItems();
        if (null != this.reqModel.getStorageOrgs() && this.reqModel.getStorageOrgs().length > 0) {
            numberSet = new HashSet<String>(Arrays.asList(this.reqModel.getStorageOrgs()));
            templateFilterItemInfo = new FilterItemInfo("storageOrgUnit.number", numberSet, CompareType.INCLUDE);
            items.addObject((IObjectValue)templateFilterItemInfo);
        }
        if (null != this.reqModel.getWarehouses() && this.reqModel.getWarehouses().length > 0) {
            numberSet = new HashSet<String>(Arrays.asList(this.reqModel.getWarehouses()));
            templateFilterItemInfo = new FilterItemInfo("warehouse.number", numberSet, CompareType.INCLUDE);
            items.addObject((IObjectValue)templateFilterItemInfo);
        }
        if (null != this.reqModel.getLocations() && this.reqModel.getLocations().length > 0) {
            numberSet = new HashSet<String>(Arrays.asList(this.reqModel.getLocations()));
            templateFilterItemInfo = new FilterItemInfo("location.number", numberSet, CompareType.INCLUDE);
            items.addObject((IObjectValue)templateFilterItemInfo);
        }
        String from = null;
        String to = null;
        String strNumber = null;
        from = this.reqModel.getStoreTypeFrom();
        if (this.stringNotNull(from)) {
            templateFilterItemInfo = new FilterItemInfo("storetype.number", (Object)from.trim(), CompareType.GREATER_EQUALS);
            items.add(templateFilterItemInfo);
        }
        if (this.stringNotNull(to = this.reqModel.getStoreTypeTo())) {
            templateFilterItemInfo = new FilterItemInfo("storetype.number", (Object)to.trim(), CompareType.LESS_EQUALS);
            items.add(templateFilterItemInfo);
        }
        if (this.stringNotNull(from = this.reqModel.getMaterialNumFrom())) {
            templateFilterItemInfo = new FilterItemInfo("material.number", (Object)from.trim(), CompareType.GREATER_EQUALS);
            items.add(templateFilterItemInfo);
        }
        if (this.stringNotNull(to = this.reqModel.getMaterialNumTo())) {
            templateFilterItemInfo = new FilterItemInfo("material.number", (Object)to.trim(), CompareType.LESS_EQUALS);
            items.add(templateFilterItemInfo);
        }
        if (this.stringNotNull(strNumber = this.reqModel.getGroupStandard())) {
            templateFilterItemInfo = new FilterItemInfo("groupstandard.number", (Object)strNumber.trim(), CompareType.EQUALS);
            items.add(templateFilterItemInfo);
        }
        from = this.reqModel.getMaterialTypeFrom();
        to = this.reqModel.getMaterialTypeTo();
        if (this.stringNotNull(from)) {
            templateFilterItemInfo = new FilterItemInfo("materialGroup.number", (Object)from.trim(), CompareType.GREATER_EQUALS);
            items.add(templateFilterItemInfo);
        }
        if (this.stringNotNull(to)) {
            templateFilterItemInfo = new FilterItemInfo("materialGroup.number", (Object)to.trim(), CompareType.LESS_EQUALS);
            items.add(templateFilterItemInfo);
        }
        if (this.stringNotNull(from = this.reqModel.getAssisAttrFrom())) {
            templateFilterItemInfo = new FilterItemInfo("assistProperty.number", (Object)from.trim(), CompareType.GREATER_EQUALS);
            items.add(templateFilterItemInfo);
        }
        if (this.stringNotNull(to = this.reqModel.getAssisAttrTo())) {
            templateFilterItemInfo = new FilterItemInfo("assistProperty.number", (Object)to.trim(), CompareType.LESS_EQUALS);
            items.add(templateFilterItemInfo);
        }
        if (this.stringNotNull(from = this.reqModel.getBatchFrom())) {
            templateFilterItemInfo = new FilterItemInfo("inventory.lot", (Object)from.trim(), CompareType.GREATER_EQUALS);
            items.add(templateFilterItemInfo);
        }
        if (this.stringNotNull(to = this.reqModel.getBatchTo())) {
            templateFilterItemInfo = new FilterItemInfo("inventory.lot", (Object)to.trim(), CompareType.LESS_EQUALS);
            items.add(templateFilterItemInfo);
        }
        if (this.stringNotNull(from = this.reqModel.getProjectNumFrom())) {
            templateFilterItemInfo = new FilterItemInfo("project.number", (Object)from.trim(), CompareType.GREATER_EQUALS);
            items.add(templateFilterItemInfo);
        }
        if (this.stringNotNull(to = this.reqModel.getProjectNumTo())) {
            templateFilterItemInfo = new FilterItemInfo("project.number", (Object)to.trim(), CompareType.LESS_EQUALS);
            items.add(templateFilterItemInfo);
        }
        if (this.stringNotNull(from = this.reqModel.getTrackNumFrom())) {
            templateFilterItemInfo = new FilterItemInfo("trackNumber.number", (Object)from.trim(), CompareType.GREATER_EQUALS);
            items.add(templateFilterItemInfo);
        }
        if (this.stringNotNull(to = this.reqModel.getTrackNumTo())) {
            templateFilterItemInfo = new FilterItemInfo("trackNumber.number", (Object)to.trim(), CompareType.LESS_EQUALS);
            items.add(templateFilterItemInfo);
        }
        if ((storeType = this.reqModel.getStoreType()) != 0) {
            templateFilterItemInfo = new FilterItemInfo("materialCost.storeType", (Object)storeType, CompareType.EQUALS);
            items.add(templateFilterItemInfo);
        }
        this.sql = this.filter.toSql();
        if (StringUtil.isEmpty((String)this.sql)) {
            return null;
        }
        this.sql = this.replaceSQL(this.sql);
        return this.sql;
    }

    private String replaceSQL(String sql) {
        String loc = "l2";
        if (SysContext.getSysContext().getLocale() != null) {
            loc = LocaleUtils.getLocaleString((Locale)SysContext.getSysContext().getLocale());
        }
        sql = sql.replaceAll("\\.id", ".FId");
        sql = sql.replaceAll("\\.ID", ".FId");
        sql = sql.replaceAll("\\.name\\s+", ".FName_" + loc + " ");
        sql = sql.replaceAll("\\.name_" + loc, ".FName_" + loc);
        sql = sql.replaceAll("\\.number", ".FNumber");
        sql = sql.replaceAll("\\.longNumber", ".FLongNumber");
        sql = sql.replaceAll("\\.lot", ".FLot");
        sql = sql.replaceAll("\\.helpCode", ".FHelpCode");
        sql = sql.replaceAll("\\.model", ".FModel");
        sql = sql.replaceAll("\\.storeType", ".FStoreType");
        return sql;
    }

    private String getFinalSQL() {
        StringBuilder resultSQL = new StringBuilder(this.sql);
        String filterSQL = this.getFilterSQL();
        if (filterSQL != null) {
            resultSQL.append(" and ").append(filterSQL);
        }
        resultSQL.append(" ORDER BY INVENTORY.FMaterialID ASC, STORAGEORGUNIT.FID ASC,");
        resultSQL.append(" CASE  WHEN INVENTORY.FWarehouseID = '");
        resultSQL.append(INV_DEF_WAREHOUSE);
        resultSQL.append("' THEN NULL ELSE INVENTORY.FWarehouseID END ASC, ");
        resultSQL.append("INVENTORY.FID ASC ");
        return resultSQL.toString();
    }

    private boolean stringNotNull(String str) {
        return null != str && !"".equals(str.trim());
    }
}

