/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.scm.ws.app.importbill;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.eas.basedata.assistant.MeasureUnitInfo;
import com.kingdee.eas.basedata.master.material.MaterialInfo;
import com.kingdee.eas.basedata.master.material.MultiMeasureUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.fi.ap.OtherBillCollection;
import com.kingdee.eas.fi.ap.OtherBillFactory;
import com.kingdee.eas.fi.ap.OtherBillInfo;
import com.kingdee.eas.fi.ap.OtherBillentryInfo;
import com.kingdee.eas.fi.ar.ArApBillBaseInfo;
import com.kingdee.eas.fi.ar.ArApBillEntryBaseInfo;
import com.kingdee.eas.fi.ar.IArApBillBase;
import com.kingdee.eas.scm.im.inv.app.InvAppUtils;
import com.kingdee.eas.scm.ws.app.importbill.ArapBillSupport;
import com.kingdee.eas.scm.ws.app.importbill.ScmbillImportUtils;
import java.math.BigDecimal;
import java.util.List;

public class ApOtherBillSupport
extends ArapBillSupport {
    @Override
    public Class<OtherBillCollection> getInfoClass() {
        return OtherBillCollection.class;
    }

    @Override
    public IArApBillBase getInterface() throws BOSException {
        return OtherBillFactory.getLocalInstance((Context)this.getContext());
    }

    @Override
    public boolean isSupportSubmit() {
        return true;
    }

    @Override
    protected void setDefaultHeadData(ArApBillBaseInfo model, List<String> errorMsg) throws BOSException, EASBizException {
        super.setDefaultHeadData(model, errorMsg);
        OtherBillInfo info = (OtherBillInfo)model;
        info.setIsReversed(false);
        info.setIsReverseBill(false);
        info.setIsTransBill(false);
        info.setIsAllowanceBill(false);
        info.setIsImportBill(false);
        info.setIsExchanged(false);
        info.setIsInitializeBill(false);
    }

    @Override
    protected void setDefaultEntryData(ArApBillEntryBaseInfo entryModel, ArApBillBaseInfo model, List<String> errorMsg) throws BOSException, EASBizException {
        OtherBillentryInfo entryInfo = (OtherBillentryInfo)entryModel;
        entryInfo.setBaseUnit(entryInfo.getMeasureUnit());
        this.setBaseQty(entryInfo, errorMsg);
    }

    @Override
    protected void verifyHeadData(ArApBillBaseInfo model, List<String> errorMsg) throws BOSException, EASBizException {
        super.verifyHeadData(model, errorMsg);
        OtherBillInfo info = (OtherBillInfo)model;
        if (info.isIsSCMBill() && (info.getPurOrg() == null || info.getPurOrg().getNumber() == null)) {
            errorMsg.add(this.getResourceValue("006_PURCHASE_ORG_IS_NULL", new Object[]{info.getNumber()}));
        }
        if (info.getCompany() == null || info.getCompany().getNumber() == null) {
            errorMsg.add(this.getResourceValue("005_COMPANY_IS_NULL", new Object[]{info.getNumber()}));
        }
    }

    @Override
    protected void verifyEntryData(ArApBillEntryBaseInfo entryModel, ArApBillBaseInfo model, List<String> errorMsg) throws BOSException, EASBizException {
        super.verifyEntryData(entryModel, model, errorMsg);
    }

    private void setBaseQty(OtherBillentryInfo entryInfo, List<String> errorMsg) throws BOSException, EASBizException {
        MeasureUnitInfo assistUnit;
        BigDecimal qty;
        MaterialInfo material = entryInfo.getMaterial();
        MeasureUnitInfo unit = entryInfo.getMeasureUnit();
        MeasureUnitInfo baseunit = entryInfo.getBaseUnit();
        MultiMeasureUnitInfo mmu = ScmbillImportUtils.getMultiMeasureUnit(this.getContext(), material, unit, errorMsg);
        MultiMeasureUnitInfo basemmu = ScmbillImportUtils.getMultiMeasureUnit(this.getContext(), material, baseunit, errorMsg);
        if (mmu != null && basemmu != null && (qty = entryInfo.getQuantity()).compareTo(new BigDecimal("0.0")) >= 0) {
            qty = qty.setScale(mmu.getQtyPrecision(), 4);
            entryInfo.setQuantity(qty);
            BigDecimal baseQty = qty.multiply(mmu.getBaseConvsRate()).setScale(basemmu.getQtyPrecision(), 4);
            entryInfo.setBaseQty(baseQty);
        }
        if ((assistUnit = entryInfo.getAssistUnit()) != null) {
            BigDecimal qty2 = entryInfo.getQuantity();
            BigDecimal assisqtyQty = InvAppUtils.getMultiUnitQty((Context)this.getContext(), (MeasureUnitInfo)unit, (MeasureUnitInfo)entryInfo.getAssistUnit(), (MaterialInfo)material, (BigDecimal)qty2);
            entryInfo.setAssistQty(assisqtyQty);
        }
    }
}

