/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.scm.ws.app.importbill;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.BOSObjectFactory;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.AbstractObjectCollection;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.framework.batch.BatchExecuteParamsEntry;
import com.kingdee.bos.framework.batch.BatchExecuteResult;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.basedata.assistant.CurrencyInfo;
import com.kingdee.eas.basedata.master.account.AccountViewInfo;
import com.kingdee.eas.basedata.master.auxacct.AsstActTypeCollection;
import com.kingdee.eas.basedata.master.auxacct.AsstActTypeFactory;
import com.kingdee.eas.basedata.master.auxacct.AsstActTypeInfo;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.basedata.scm.common.RowTypeInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.fi.ar.ArApBillBaseInfo;
import com.kingdee.eas.fi.ar.ArApBillEntryBaseInfo;
import com.kingdee.eas.fi.ar.ArApBillPlanBaseInfo;
import com.kingdee.eas.fi.ar.BillStatusEnum;
import com.kingdee.eas.fi.ar.IArApBillBase;
import com.kingdee.eas.fi.arap.util.ArApBillHelper;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.framework.DataBaseCollection;
import com.kingdee.eas.framework.DataBaseInfo;
import com.kingdee.eas.framework.IDataBase;
import com.kingdee.eas.scm.ws.app.importbill.BillResultInfo;
import com.kingdee.eas.scm.ws.app.importbill.IBillSupport;
import com.kingdee.eas.scm.ws.app.importbill.ScmbillImportUtils;
import com.kingdee.eas.util.ResourceBase;
import com.kingdee.util.BaseException;
import com.kingdee.util.StringUtils;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Locale;

public abstract class ArapBillSupport
implements IBillSupport {
    private Context ctx;
    protected static BigDecimal ZERO = BigDecimal.ZERO;
    protected static final String RESOURCE_FILE = "com.kingdee.eas.scm.ws.WS2ARAPResource";

    @Override
    public boolean isSupportSubmit() {
        return true;
    }

    @Override
    public boolean isSupportAudit() {
        return true;
    }

    @Override
    public void setContext(Context ctx) {
        this.ctx = ctx;
    }

    public Context getContext() {
        return this.ctx;
    }

    @Override
    public Class getInfoClass() {
        return null;
    }

    private List<String> setData(Context ctx, ArApBillBaseInfo info) throws BOSException, EASBizException {
        ArrayList<String> errorMsg = new ArrayList<String>();
        this.dealWithData(ctx, info, errorMsg);
        this.setDefaultData(info, errorMsg);
        this.verifyData(info, errorMsg);
        return errorMsg;
    }

    protected void setDefaultData(ArApBillBaseInfo model, List<String> errorMsg) throws BOSException, EASBizException {
        this.setDefaultHeadData(model, errorMsg);
        AbstractObjectCollection entries = model.getEntries();
        int size = entries.size();
        for (int i = 0; i < size; ++i) {
            ArApBillEntryBaseInfo entryInfo = (ArApBillEntryBaseInfo)entries.getObject(i);
            this.setDefaultEntryData(entryInfo, model, errorMsg);
        }
        this.setDefaultPlanData(model, errorMsg);
    }

    protected void setDefaultPlanData(ArApBillBaseInfo info, List<String> errorMsg) throws BOSException, EASBizException {
        AbstractObjectCollection planCol = info.getPlans();
        if (planCol.size() == 0) {
            ArApBillHelper.generatePlan((Context)this.ctx, (ArApBillBaseInfo)info);
        }
        ArApBillPlanBaseInfo planInfo = null;
        int count = planCol.size();
        for (int i = 0; i < count; ++i) {
            planInfo = (ArApBillPlanBaseInfo)planCol.getObject(i);
            if (planInfo.getRecievePayDate() == null) {
                planInfo.setRecievePayDate(info.getBillDate());
            }
            planInfo.setLockAmount(ZERO);
            planInfo.setLockAmountLoc(ZERO);
            planInfo.setUnLockAmount(planInfo.getRecievePayAmount());
            planInfo.setUnLockAmountLoc(planInfo.getRecievePayAmountLocal());
            planInfo.setVerifyAmount(ZERO);
            planInfo.setVerifyAmountLocal(ZERO);
            planInfo.setUnVerifyAmount(planInfo.getRecievePayAmount());
            planInfo.setUnVerifyAmountLocal(planInfo.getRecievePayAmountLocal());
        }
    }

    protected void setDefaultHeadData(ArApBillBaseInfo info, List<String> errorMsg) throws BOSException, EASBizException {
        if (info.getBizDate() == null) {
            info.setBizDate(new Date());
        }
        if (info.getBillStatus() == null || info.getBillStatus().equals((Object)BillStatusEnum.AUDITED) || info.getBillStatus().equals((Object)BillStatusEnum.DELETED)) {
            info.setBillStatus(BillStatusEnum.SAVE);
        }
        if (info.getId() == null) {
            info.setId(BOSUuid.create((BOSObjectType)info.getBOSType()));
        }
    }

    protected void setDefaultEntryData(ArApBillEntryBaseInfo entryModel, ArApBillBaseInfo model, List<String> errorMsg) throws BOSException, EASBizException {
    }

    protected void dealWithData(Context ctx, ArApBillBaseInfo model, List<String> errorMsg) throws BOSException, EASBizException {
        this.dealWithHeadData(model, errorMsg);
        AbstractObjectCollection entries = model.getEntries();
        int size = entries.size();
        for (int i = 0; i < size; ++i) {
            ArApBillEntryBaseInfo entryInfo = (ArApBillEntryBaseInfo)entries.getObject(i);
            this.dealWithEntryData(entryInfo, model, errorMsg);
        }
        errorMsg = ScmbillImportUtils.setInfoByNumber(ctx, (CoreBaseInfo)model, errorMsg);
    }

    public void setAsstAct(ArApBillBaseInfo model, List<String> errorMsg) throws BOSException {
        DataBaseCollection databaseCol;
        String groupId;
        if (model.getAsstActNumber() == null) {
            return;
        }
        String asstActTypenumber = model.getAsstActType().getNumber();
        EntityViewInfo evi = new EntityViewInfo();
        FilterInfo fi = new FilterInfo();
        evi.setFilter(fi);
        fi.getFilterItems().add(new FilterItemInfo("number", (Object)asstActTypenumber, CompareType.EQUALS));
        AsstActTypeCollection asstActTypeCollection = AsstActTypeFactory.getLocalInstance((Context)this.ctx).getAsstActTypeCollection(evi);
        if (asstActTypeCollection.isEmpty()) {
            return;
        }
        AsstActTypeInfo asstActTypeInfo = asstActTypeCollection.get(0);
        String realtionDataObject = asstActTypeInfo.getRealtionDataObject();
        BOSObjectType bostype = null;
        if ("T_BD_GeneralAsstActType".equals(realtionDataObject)) {
            bostype = BOSObjectType.create((String)"F90B0133");
        } else if ("T_BD_Customer".equals(realtionDataObject)) {
            bostype = BOSObjectType.create((String)"BF0C040E");
        } else if ("T_BD_Supplier".equals(realtionDataObject)) {
            bostype = BOSObjectType.create((String)"37C67DFC");
        } else if ("T_BD_Person".equals(realtionDataObject)) {
            bostype = BOSObjectType.create((String)"80EF7DED");
        }
        if (null == bostype) {
            return;
        }
        String number = model.getAsstActNumber();
        IDataBase iDataBase = (IDataBase)BOSObjectFactory.createBOSObject((Context)this.ctx, (BOSObjectType)bostype);
        String oql = "select id,number,name  where number = '" + number + "'";
        String string = groupId = asstActTypeInfo.getGlAsstActTypeGrp() == null ? null : asstActTypeInfo.getGlAsstActTypeGrp().getId().toString();
        if ("T_BD_GeneralAsstActType".equals(realtionDataObject) && null != groupId) {
            if (number != null) {
                number = number.replaceAll("\\.", "\\!");
            }
            oql = "select id,number,name  where longNumber = '" + number + "' and group = '" + groupId + "'";
        }
        if ((databaseCol = iDataBase.getDataBaseCollection(oql)) != null && databaseCol.size() > 0) {
            DataBaseInfo asstActfo = databaseCol.get(0);
            model.setAsstActNumber(asstActfo.getNumber());
            model.setAsstActName(asstActfo.getName());
            model.setAsstActID(asstActfo.getId().toString());
        } else {
            errorMsg.add(this.getResourceValue("002_ASSTACTTYPE_INCORRECT", new Object[]{number}));
        }
    }

    protected void dealWithHeadData(ArApBillBaseInfo model, List<String> errorMsg) throws BOSException, EASBizException {
        if (model.getAsstActType() != null && model.getAsstActType().getNumber() != null) {
            this.setAsstAct(model, errorMsg);
        }
        model.setCompany((CompanyOrgUnitInfo)ArapBillSupport.getDataBaseInfoByNumber(this.ctx, (DataBaseInfo)model.getCompany()));
    }

    protected void dealWithEntryData(ArApBillEntryBaseInfo entryModel, ArApBillBaseInfo model, List<String> errorMsg) throws BOSException, EASBizException {
        String companyId = null;
        if (null != model.getCompany() && null != model.getCompany().getId()) {
            companyId = model.getCompany().getId().toString();
        }
        AccountViewInfo account = entryModel.getAccount();
        AccountViewInfo oppAccount = entryModel.getOppAccount();
        if (null != account) {
            entryModel.setAccount((AccountViewInfo)ArapBillSupport.getDataBaseInfoByNumber(this.ctx, (DataBaseInfo)account, companyId));
        }
        if (null != oppAccount) {
            entryModel.setOppAccount((AccountViewInfo)ArapBillSupport.getDataBaseInfoByNumber(this.ctx, (DataBaseInfo)oppAccount, companyId));
        }
    }

    public static DataBaseInfo getDataBaseInfoByNumber(Context ctx, DataBaseInfo info) throws BOSException {
        return ArapBillSupport.getDataBaseInfoByNumber(ctx, info, null);
    }

    public static DataBaseInfo getDataBaseInfoByNumber(Context ctx, DataBaseInfo info, String companyId) throws BOSException {
        DataBaseCollection databaseCol;
        if (info == null) {
            return null;
        }
        if (StringUtils.isEmpty((String)info.getNumber())) {
            return null;
        }
        IDataBase iDataBase = (IDataBase)BOSObjectFactory.createBOSObject((Context)ctx, (BOSObjectType)info.getBOSType());
        String oql = ArapBillSupport.getOql(info, info.getNumber());
        if (null != companyId) {
            oql = oql + " and companyID = '" + companyId + "'";
        }
        if ((databaseCol = iDataBase.getDataBaseCollection(oql)) != null && databaseCol.size() > 0) {
            return databaseCol.get(0);
        }
        return null;
    }

    private static String getOql(DataBaseInfo lInfo, String number) {
        StringBuffer sb = new StringBuffer();
        if (lInfo instanceof CurrencyInfo) {
            sb.append("select id,number,name,precision where number='").append(number).append("'");
        } else if (lInfo instanceof RowTypeInfo) {
            sb.append("select id,number,name,isHasMaterialNumber,precision,destinationtype where number='").append(number).append("'");
        } else {
            sb.append("select id,number,name where number='").append(number).append("'");
        }
        return sb.toString();
    }

    protected void verifyData(ArApBillBaseInfo model, List<String> errorMsg) throws BOSException, EASBizException {
        this.verifyBillNumber(model, errorMsg);
        this.verifyHeadData(model, errorMsg);
        AbstractObjectCollection entries = model.getEntries();
        int size = entries.size();
        for (int i = 0; i < size; ++i) {
            ArApBillEntryBaseInfo entryInfo = (ArApBillEntryBaseInfo)entries.getObject(i);
            this.verifyEntryData(entryInfo, model, errorMsg);
        }
    }

    protected void verifyBillNumber(ArApBillBaseInfo model, List<String> errorMsg) throws BOSException, EASBizException {
        boolean isExist;
        String number = model.getNumber();
        if (!StringUtils.isEmpty((String)number) && (isExist = this.getInterface().exists("select id, number where number = '" + number + "'"))) {
            errorMsg.add(this.getResourceValue("001_BILL_NUMBER_DUPLICATE", new Object[]{number}));
        }
    }

    protected void verifyHeadData(ArApBillBaseInfo model, List<String> errorMsg) throws BOSException, EASBizException {
    }

    protected void verifyEntryData(ArApBillEntryBaseInfo entryModel, ArApBillBaseInfo model, List<String> errorMsg) throws BOSException, EASBizException {
    }

    @Override
    public List<BillResultInfo> audit(List<BillResultInfo> results) throws EASBizException, BOSException {
        BatchExecuteResult result = null;
        BatchExecuteParamsEntry[] paramEntries = new BatchExecuteParamsEntry[results.size()];
        BatchExecuteParamsEntry entry = null;
        for (int i = 0; i < results.size(); ++i) {
            BillResultInfo resultInfo = results.get(i);
            if (resultInfo == null || resultInfo.getStatus() != 0) continue;
            String billid = resultInfo.getId();
            entry = new BatchExecuteParamsEntry(new Class[]{IObjectPK.class});
            entry.add((Object)new ObjectUuidPK(billid));
            paramEntries[i] = entry;
        }
        Class[] batchMethod = new Class[]{IObjectPK.class};
        String methodPK = "audit";
        try {
            result = this.getInterface().batchExecute(methodPK, batchMethod, paramEntries);
        }
        catch (BaseException e) {
            throw new BOSException((Throwable)e);
        }
        Object[] objs = result.getReturnValues();
        int size = objs.length;
        for (int i = 0; i < size; ++i) {
            ArrayList<String> errorMsg = new ArrayList<String>();
            BillResultInfo resultInfo = new BillResultInfo();
            if (result.getException(i) == null) {
                resultInfo.setId(result.getReturnValue(i) != null ? result.getReturnValue(i).toString() : null);
                resultInfo.setStatus(0);
            } else {
                errorMsg.add(result.getException(i).getMessage());
                resultInfo.setErrorMsgs(errorMsg);
                resultInfo.setStatus(1);
            }
            results.add(resultInfo);
        }
        return results;
    }

    @Override
    public List<BillResultInfo> save(AbstractObjectCollection col) throws EASBizException, BOSException {
        List<BillResultInfo> results = this.saveOrSubmitData(col, true);
        return results;
    }

    @Override
    public List<BillResultInfo> submit(AbstractObjectCollection col) throws EASBizException, BOSException {
        List<BillResultInfo> results = this.saveOrSubmitData(col, false);
        return results;
    }

    private List<BillResultInfo> saveOrSubmitData(AbstractObjectCollection col, boolean isSave) throws BOSException, EASBizException {
        List<String> errorMsg;
        ArrayList<BillResultInfo> results = new ArrayList<BillResultInfo>();
        ArApBillBaseInfo info = null;
        int size = col.size();
        for (int i = 0; i < size; ++i) {
            info = (ArApBillBaseInfo)col.getObject(i);
            errorMsg = this.setData(this.ctx, info);
            if (errorMsg == null || errorMsg.size() <= 0) continue;
            BillResultInfo result = new BillResultInfo();
            result.setErrorMsgs(errorMsg);
            result.setNumber(info.getNumber());
            result.setStatus(1);
            results.add(result);
            col.removeObject(i);
            --i;
            --size;
        }
        if (col != null && col.size() > 0) {
            BatchExecuteResult result = null;
            BatchExecuteParamsEntry[] paramEntries = new BatchExecuteParamsEntry[col.size()];
            BatchExecuteParamsEntry entry = null;
            int size2 = col.size();
            for (int i = 0; i < size2; ++i) {
                entry = new BatchExecuteParamsEntry(new Class[]{CoreBaseInfo.class});
                entry.add((Object)col.getObject(i));
                paramEntries[i] = entry;
            }
            Class[] batchMethod = new Class[]{CoreBaseInfo.class};
            String methodPK = "submit";
            if (isSave) {
                methodPK = "save";
            }
            try {
                result = this.getInterface().batchExecute(methodPK, batchMethod, paramEntries);
            }
            catch (BaseException e) {
                throw new BOSException((Throwable)e);
            }
            Object[] objs = result.getReturnValues();
            int size3 = objs.length;
            for (int i = 0; i < size3; ++i) {
                info = (ArApBillBaseInfo)col.getObject(i);
                errorMsg = new ArrayList<String>();
                BillResultInfo resultInfo = new BillResultInfo();
                resultInfo.setNumber(info.getNumber());
                if (result.getException(i) == null) {
                    resultInfo.setId(result.getReturnValue(i).toString());
                    resultInfo.setStatus(0);
                } else {
                    errorMsg.add(result.getException(i).getMessage());
                    resultInfo.setErrorMsgs(errorMsg);
                    resultInfo.setStatus(1);
                }
                results.add(resultInfo);
            }
        }
        return results;
    }

    public abstract IArApBillBase getInterface() throws BOSException;

    protected String getResourceValue(String key, Object[] params) {
        return ResourceBase.getString((String)RESOURCE_FILE, (String)key, (Locale)this.ctx.getLocale(), (Object[])params);
    }
}

