/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.scm.ws.app.importbill;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.framework.batch.BatchExecuteParamsEntry;
import com.kingdee.bos.framework.batch.BatchExecuteResult;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.basedata.assistant.MeasureUnitInfo;
import com.kingdee.eas.basedata.master.material.MaterialCompanyInfoInfo;
import com.kingdee.eas.basedata.master.material.MaterialInfo;
import com.kingdee.eas.basedata.master.material.MultiMeasureUnitInfo;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.basedata.scm.common.BillTypeInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.scm.common.ISCMBillBase;
import com.kingdee.eas.scm.common.SCMBillBaseInfo;
import com.kingdee.eas.scm.common.SCMBillEntryBaseInfo;
import com.kingdee.eas.scm.im.inv.MaterialRequestBillCollection;
import com.kingdee.eas.scm.im.inv.MaterialRequestBillEntryInfo;
import com.kingdee.eas.scm.im.inv.MaterialRequestBillFactory;
import com.kingdee.eas.scm.im.inv.MaterialRequestBillInfo;
import com.kingdee.eas.scm.im.inv.app.InvAppUtils;
import com.kingdee.eas.scm.ws.app.importbill.ScmBillSupport;
import com.kingdee.eas.scm.ws.app.importbill.ScmbillImportUtils;
import com.kingdee.util.BaseException;
import java.math.BigDecimal;
import java.util.List;

public class MaterialRequestBillSupport
extends ScmBillSupport {
    @Override
    public boolean isSupportSubmit() {
        return true;
    }

    @Override
    public boolean isSupportAudit() {
        return true;
    }

    @Override
    public BatchExecuteResult getBatchExecuteResult(BatchExecuteParamsEntry[] paramEntries, Class[] batchMethod, String methodPK) throws BaseException {
        return super.getBatchExecuteResult(paramEntries, batchMethod, methodPK);
    }

    @Override
    public Class<MaterialRequestBillCollection> getInfoClass() {
        return MaterialRequestBillCollection.class;
    }

    @Override
    public ISCMBillBase getInterface() throws BOSException {
        return MaterialRequestBillFactory.getLocalInstance((Context)this.getContext());
    }

    @Override
    protected void setDefaultData(SCMBillBaseInfo model, List<String> errorMsg) throws BOSException, EASBizException {
        MaterialRequestBillInfo info = (MaterialRequestBillInfo)model;
        super.setDefaultData((SCMBillBaseInfo)info, errorMsg);
    }

    @Override
    protected void setDefaultHeadData(SCMBillBaseInfo model, List<String> errorMsg) throws BOSException, EASBizException {
        super.setDefaultHeadData(model, errorMsg);
        MaterialRequestBillInfo info = (MaterialRequestBillInfo)model;
        BillTypeInfo billtype = new BillTypeInfo();
        billtype.setId(BOSUuid.read((String)"XlazxwEREADgAAAEwKgSxUY+1VI="));
        info.setBillType(billtype);
    }

    @Override
    protected void setDefaultEntryData(SCMBillEntryBaseInfo entryModel, SCMBillBaseInfo model, List<String> errorMsg) throws BOSException, EASBizException {
        super.setDefaultEntryData(entryModel, model, errorMsg);
        MaterialRequestBillEntryInfo entryInfo = (MaterialRequestBillEntryInfo)entryModel;
        if (entryInfo.getMaterial() != null) {
            entryInfo.setBaseUnit(entryInfo.getMaterial().getBaseUnit());
            this.setBaseQty(entryInfo, errorMsg);
            this.setStandardCost(entryInfo, errorMsg);
        }
    }

    private void setBaseQty(MaterialRequestBillEntryInfo entryInfo, List<String> errorMsg) throws BOSException, EASBizException {
        MaterialInfo material = entryInfo.getMaterial();
        MeasureUnitInfo unit = entryInfo.getUnit();
        MeasureUnitInfo baseunit = entryInfo.getBaseUnit();
        MultiMeasureUnitInfo mmu = ScmbillImportUtils.getMultiMeasureUnit(this.getContext(), material, unit, errorMsg);
        MultiMeasureUnitInfo basemmu = ScmbillImportUtils.getMultiMeasureUnit(this.getContext(), material, baseunit, errorMsg);
        BigDecimal qty = entryInfo.getQty();
        BigDecimal baseQty = this.zero;
        if (qty == null) {
            qty = this.zero;
        }
        if (mmu != null && basemmu != null) {
            qty = qty.setScale(mmu.getQtyPrecision(), 4);
            entryInfo.setQty(qty);
            baseQty = qty.multiply(mmu.getBaseConvsRate()).setScale(basemmu.getQtyPrecision(), 4);
        }
        entryInfo.setBaseQty(baseQty);
        entryInfo.setAssociateQty(qty);
        MeasureUnitInfo assistUnit = entryInfo.getAssistUnit();
        if (assistUnit != null) {
            BigDecimal assisqtyQty = InvAppUtils.getMultiUnitQty((Context)this.getContext(), (MeasureUnitInfo)unit, (MeasureUnitInfo)entryInfo.getAssistUnit(), (MaterialInfo)material, (BigDecimal)qty);
            entryInfo.setAssistQty(assisqtyQty);
        }
    }

    private void setStandardCost(MaterialRequestBillEntryInfo entryInfo, List<String> errorMsg) throws BOSException, EASBizException {
        MaterialInfo material = entryInfo.getMaterial();
        MeasureUnitInfo unit = entryInfo.getUnit();
        CompanyOrgUnitInfo cou = entryInfo.getCompanyOrgUnit();
        MultiMeasureUnitInfo mmu = ScmbillImportUtils.getMultiMeasureUnit(this.getContext(), material, unit, errorMsg);
        MaterialCompanyInfoInfo materialcompanyInfo = ScmbillImportUtils.getMaterialCompanyInfo(this.getContext(), material, cou, errorMsg);
        if (mmu != null && materialcompanyInfo != null && materialcompanyInfo.getStandardCost() != null) {
            BigDecimal qty = entryInfo.getQty();
            BigDecimal unitStandardCost = materialcompanyInfo.getStandardCost().multiply(mmu.getBaseConvsRate());
            entryInfo.setUnitStandardCost(unitStandardCost);
            entryInfo.setStandardCost(unitStandardCost.multiply(qty));
        }
    }
}

