/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.scm.ws.app.importbill;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.framework.batch.BatchExecuteParamsEntry;
import com.kingdee.bos.framework.batch.BatchExecuteResult;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.basedata.assistant.ConvertModeEnum;
import com.kingdee.eas.basedata.assistant.ExchangeRateInfo;
import com.kingdee.eas.basedata.assistant.MeasureUnitInfo;
import com.kingdee.eas.basedata.master.material.MaterialInfo;
import com.kingdee.eas.basedata.master.material.MultiMeasureUnitInfo;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.basedata.org.OrgUnitInfo;
import com.kingdee.eas.basedata.scm.common.BillTypeInfo;
import com.kingdee.eas.basedata.scm.sm.pur.IPurchasePerson;
import com.kingdee.eas.basedata.scm.sm.pur.PurchasePersonCollection;
import com.kingdee.eas.basedata.scm.sm.pur.PurchasePersonFactory;
import com.kingdee.eas.basedata.scm.sm.pur.PurchasePersonInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.common.SysConstant;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.scm.common.ISCMBillBase;
import com.kingdee.eas.scm.common.SCMBillBaseInfo;
import com.kingdee.eas.scm.common.SCMBillEntryBaseInfo;
import com.kingdee.eas.scm.common.app.SCMServerUtils;
import com.kingdee.eas.scm.im.inv.app.InvAppUtils;
import com.kingdee.eas.scm.sm.pur.PurContractCollection;
import com.kingdee.eas.scm.sm.pur.PurContractEntryInfo;
import com.kingdee.eas.scm.sm.pur.PurContractFactory;
import com.kingdee.eas.scm.sm.pur.PurContractInfo;
import com.kingdee.eas.scm.ws.app.importbill.ScmBillSupport;
import com.kingdee.eas.scm.ws.app.importbill.ScmbillImportUtils;
import com.kingdee.util.BaseException;
import java.math.BigDecimal;
import java.util.List;

public class PurConTractBillSupport
extends ScmBillSupport {
    @Override
    public boolean isSupportSubmit() {
        return true;
    }

    @Override
    public boolean isSupportAudit() {
        return true;
    }

    @Override
    public BatchExecuteResult getBatchExecuteResult(BatchExecuteParamsEntry[] paramEntries, Class[] batchMethod, String methodPK) throws BaseException {
        return super.getBatchExecuteResult(paramEntries, batchMethod, methodPK);
    }

    @Override
    public Class<PurContractCollection> getInfoClass() {
        return PurContractCollection.class;
    }

    @Override
    public ISCMBillBase getInterface() throws BOSException {
        return PurContractFactory.getLocalInstance((Context)this.getContext());
    }

    @Override
    protected void dealWithHeadData(SCMBillBaseInfo model, List<String> errorMsg) throws BOSException, EASBizException {
        PurContractInfo info = (PurContractInfo)model;
        if (info.getPurGroup() != null) {
            ScmbillImportUtils.setDataBaseInfo(this.getContext(), (CoreBaseInfo)info, errorMsg, "purchaseGroup", info.getPurGroup());
            if (info.getPurGroup() != null && info.getPurPerson() != null) {
                this.setPurchasePersonByNumber(info, errorMsg);
            }
        }
    }

    @Override
    protected void setDefaultHeadData(SCMBillBaseInfo model, List<String> errorMsg) throws BOSException, EASBizException {
        super.setDefaultHeadData(model, errorMsg);
        PurContractInfo info = (PurContractInfo)model;
        CompanyOrgUnitInfo cou = ScmbillImportUtils.getCompanyInfo(this.getContext(), (OrgUnitInfo)info.getPurOrgUnit(), 3);
        info.setCompanyOrgUnit(cou);
        ObjectUuidPK sourceCurrPK = new ObjectUuidPK(info.getCurrency().getId());
        ObjectUuidPK destCurrPK = new ObjectUuidPK(cou.getBaseCurrency().getId());
        ExchangeRateInfo exchangeRate = SCMServerUtils.getExchangeRate((Context)this.getContext(), (CompanyOrgUnitInfo)cou, (IObjectPK)sourceCurrPK, (IObjectPK)destCurrPK);
        if (exchangeRate != null) {
            if (info.getExchangeRate() == null) {
                info.setExchangeRate(exchangeRate.getConvertRate());
            }
            info.setConvertMode(exchangeRate.getConvertMode());
        } else {
            if (info.getExchangeRate() == null) {
                info.setExchangeRate(new BigDecimal("1.00"));
            }
            info.setConvertMode(ConvertModeEnum.DIRECTEXCHANGERATE);
        }
        info.setIsSysBill(false);
        BillTypeInfo billtype = new BillTypeInfo();
        billtype.setId(BOSUuid.read((String)"510b6503-0105-1000-e000-010bc0a813fd463ED552"));
        info.setBillType(billtype);
    }

    @Override
    protected void setDefaultData(SCMBillBaseInfo model, List<String> errorMsg) throws BOSException, EASBizException {
        super.setDefaultData(model, errorMsg);
        PurContractInfo info = (PurContractInfo)model;
        this.calTotalAmount(info);
    }

    @Override
    protected void setDefaultEntryData(SCMBillEntryBaseInfo entryModel, SCMBillBaseInfo model, List<String> errorMsg) throws BOSException, EASBizException {
        super.setDefaultEntryData(entryModel, model, errorMsg);
        PurContractEntryInfo entryInfo = (PurContractEntryInfo)entryModel;
        PurContractInfo info = (PurContractInfo)model;
        if (entryInfo.getMaterial() != null) {
            entryInfo.setBaseUnit(entryInfo.getMaterial().getBaseUnit());
            entryInfo.setMaterialName(entryInfo.getMaterial().getName());
            entryInfo.setNoNumMaterialModel(entryInfo.getMaterial().getModel());
            this.setBaseQty(entryInfo, errorMsg);
        } else {
            entryInfo.setBaseQty(entryInfo.getQty());
            entryInfo.setBaseUnit(entryInfo.getUnit());
        }
        this.calEntryLocalValue(info, entryInfo);
    }

    private void setPurchasePersonByNumber(PurContractInfo info, List<String> errorMsg) throws BOSException {
        String groupid = info.getPurGroup().getId().toString();
        String number = info.getPurPerson().getNumber();
        IPurchasePerson ipurPerson = PurchasePersonFactory.getLocalInstance((Context)this.getContext());
        EntityViewInfo viewInfo = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("person.number", (Object)number, CompareType.EQUALS));
        filter.getFilterItems().add(new FilterItemInfo("purGroup.id", (Object)groupid, CompareType.EQUALS));
        viewInfo.setFilter(filter);
        PurchasePersonCollection collection = ipurPerson.getPurchasePersonCollection(viewInfo);
        if (collection != null && collection.size() > 0) {
            PurchasePersonInfo personInfo = collection.get(0);
            if (info != null) {
                info.setPurPerson(personInfo.getPerson());
            }
        } else {
            info.setPurPerson(null);
            errorMsg.add(number + " is not a right purchasePerson or" + number + "is not in " + info.getPurGroup().getNumber() + ".");
        }
    }

    private void setBaseQty(PurContractEntryInfo entryInfo, List<String> errorMsg) throws BOSException, EASBizException {
        MaterialInfo material = entryInfo.getMaterial();
        MeasureUnitInfo unit = entryInfo.getUnit();
        MeasureUnitInfo baseunit = entryInfo.getBaseUnit();
        MultiMeasureUnitInfo mmu = ScmbillImportUtils.getMultiMeasureUnit(this.getContext(), material, unit, errorMsg);
        MultiMeasureUnitInfo basemmu = ScmbillImportUtils.getMultiMeasureUnit(this.getContext(), material, baseunit, errorMsg);
        BigDecimal qty = entryInfo.getQty();
        BigDecimal baseQty = this.zero;
        if (qty == null) {
            qty = this.zero;
        }
        if (mmu != null && basemmu != null) {
            qty = qty.setScale(mmu.getQtyPrecision(), 4);
            entryInfo.setQty(qty);
            baseQty = qty.multiply(mmu.getBaseConvsRate()).setScale(basemmu.getQtyPrecision(), 4);
        }
        entryInfo.setQty(qty);
        entryInfo.setBaseQty(baseQty);
        entryInfo.setAssociateQty(qty);
        MeasureUnitInfo assistUnit = entryInfo.getAssistUnit();
        if (assistUnit != null) {
            BigDecimal assisqtyQty = InvAppUtils.getMultiUnitQty((Context)this.getContext(), (MeasureUnitInfo)unit, (MeasureUnitInfo)entryInfo.getAssistUnit(), (MaterialInfo)material, (BigDecimal)qty);
            entryInfo.setAssistQty(assisqtyQty);
        }
    }

    public void calTotalAmount(PurContractInfo purContractInfo) {
        BigDecimal totalAmount = this.zero;
        BigDecimal totalTax = this.zero;
        BigDecimal totalTaxAmount = this.zero;
        BigDecimal localTotalAmount = this.zero;
        BigDecimal localTotalTaxAmount = this.zero;
        int count = purContractInfo.getEntries().size();
        for (int index = 0; index < count; ++index) {
            if (purContractInfo.getEntries().get(index).getAmount() != null) {
                totalAmount = totalAmount.add(purContractInfo.getEntries().get(index).getAmount());
            }
            if (purContractInfo.getEntries().get(index).getTax() != null) {
                totalTax = totalTax.add(purContractInfo.getEntries().get(index).getTax());
            }
            if (purContractInfo.getEntries().get(index).getTaxAmount() != null) {
                totalTaxAmount = totalTaxAmount.add(purContractInfo.getEntries().get(index).getTaxAmount());
            }
            if (purContractInfo.getEntries().get(index).getAmount() != null) {
                localTotalAmount = localTotalAmount.add(purContractInfo.getEntries().get(index).getLocalAmount());
            }
            if (purContractInfo.getEntries().get(index).getTaxAmount() == null) continue;
            localTotalTaxAmount = localTotalTaxAmount.add(purContractInfo.getEntries().get(index).getLocalTaxAmount());
        }
        purContractInfo.setTotalAmount(totalAmount);
        purContractInfo.setTotalTax(totalTax);
        purContractInfo.setTotalTaxAmount(totalTaxAmount);
        purContractInfo.setLocalTotalAmount(localTotalAmount);
        purContractInfo.setLocalTotalTaxAmount(localTotalTaxAmount);
    }

    public void calEntryLocalValue(PurContractInfo purOrderInfo, PurContractEntryInfo entryInfo) {
        BigDecimal entryLocalAmount = this.zero;
        BigDecimal entryLocalTax = this.zero;
        BigDecimal entryLocalTaxAmount = this.zero;
        int currencyPrecision = 2;
        if (purOrderInfo.getCurrency() != null) {
            currencyPrecision = purOrderInfo.getCurrency().getPrecision();
        }
        BigDecimal amount = entryInfo.getAmount();
        BigDecimal tax = entryInfo.getTax();
        BigDecimal taxAmount = entryInfo.getTaxAmount();
        BigDecimal exchangeRate = purOrderInfo.getExchangeRate();
        ConvertModeEnum convertMode = purOrderInfo.getConvertMode();
        if (amount != null && SysConstant.BIGZERO.compareTo(exchangeRate) != 0) {
            if (convertMode != null && convertMode == ConvertModeEnum.DIRECTEXCHANGERATE) {
                entryLocalAmount = amount.multiply(exchangeRate).setScale(currencyPrecision, 4);
                entryLocalTax = tax.multiply(exchangeRate).setScale(currencyPrecision, 4);
                entryLocalTaxAmount = taxAmount.multiply(exchangeRate).setScale(currencyPrecision, 4);
            } else if (SysConstant.BIGZERO.compareTo(exchangeRate) != 0) {
                entryLocalAmount = amount.divide(exchangeRate, currencyPrecision, 4);
                entryLocalTax = tax.divide(exchangeRate, currencyPrecision, 4);
                entryLocalTaxAmount = taxAmount.divide(exchangeRate, currencyPrecision, 4);
            }
        }
        entryInfo.setLocalAmount(entryLocalAmount);
        entryInfo.setLocalTax(entryLocalTax);
        entryInfo.setLocalTaxAmount(entryLocalTaxAmount);
    }
}

