/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.scm.ws.app.importbill;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.framework.batch.BatchExecuteParamsEntry;
import com.kingdee.bos.framework.batch.BatchExecuteResult;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.basedata.assistant.ExchangeRateInfo;
import com.kingdee.eas.basedata.assistant.MeasureUnitInfo;
import com.kingdee.eas.basedata.master.material.MaterialCompanyInfoInfo;
import com.kingdee.eas.basedata.master.material.MaterialInfo;
import com.kingdee.eas.basedata.master.material.MultiMeasureUnitInfo;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.basedata.org.OrgUnitInfo;
import com.kingdee.eas.basedata.scm.common.BillTypeInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.scm.common.ISCMBillBase;
import com.kingdee.eas.scm.common.PurchaseTypeEnum;
import com.kingdee.eas.scm.common.SCMBillBaseInfo;
import com.kingdee.eas.scm.common.SCMBillEntryBaseInfo;
import com.kingdee.eas.scm.common.app.SCMServerUtils;
import com.kingdee.eas.scm.im.inv.PurInWarehsBillCollection;
import com.kingdee.eas.scm.im.inv.PurInWarehsBillFactory;
import com.kingdee.eas.scm.im.inv.PurInWarehsBillInfo;
import com.kingdee.eas.scm.im.inv.PurInWarehsEntryCollection;
import com.kingdee.eas.scm.im.inv.PurInWarehsEntryInfo;
import com.kingdee.eas.scm.im.inv.app.InvAppUtils;
import com.kingdee.eas.scm.ws.app.importbill.ScmBillSupport;
import com.kingdee.eas.scm.ws.app.importbill.ScmbillImportUtils;
import com.kingdee.util.BaseException;
import java.math.BigDecimal;
import java.util.List;

public class PurInWarehsBillSupport
extends ScmBillSupport {
    @Override
    public Class<PurInWarehsBillCollection> getInfoClass() {
        return PurInWarehsBillCollection.class;
    }

    @Override
    public boolean isSupportSubmit() {
        return true;
    }

    @Override
    public boolean isSupportAudit() {
        return true;
    }

    @Override
    public BatchExecuteResult getBatchExecuteResult(BatchExecuteParamsEntry[] paramEntries, Class[] batchMethod, String methodPK) throws BaseException {
        return super.getBatchExecuteResult(paramEntries, batchMethod, methodPK);
    }

    @Override
    public ISCMBillBase getInterface() throws BOSException {
        return PurInWarehsBillFactory.getLocalInstance((Context)this.getContext());
    }

    @Override
    protected void setDefaultData(SCMBillBaseInfo model, List<String> errorMsg) throws BOSException, EASBizException {
        PurInWarehsBillInfo info = (PurInWarehsBillInfo)model;
        PurInWarehsEntryCollection entries = info.getEntry();
        CompanyOrgUnitInfo cou = ScmbillImportUtils.getCompanyInfo(this.getContext(), (OrgUnitInfo)info.getStorageOrgUnit(), 4);
        int size = entries.size();
        for (int i = 0; i < size; ++i) {
            PurInWarehsEntryInfo entryInfo = entries.get(i);
            entryInfo.setStorageOrgUnit(info.getStorageOrgUnit());
            entryInfo.setCompanyOrgUnit(cou);
        }
        super.setDefaultData((SCMBillBaseInfo)info, errorMsg);
    }

    @Override
    protected void setDefaultHeadData(SCMBillBaseInfo model, List<String> errorMsg) throws BOSException, EASBizException {
        super.setDefaultHeadData(model, errorMsg);
        PurInWarehsBillInfo info = (PurInWarehsBillInfo)model;
        info.setPurchaseType(PurchaseTypeEnum.PURCHASE);
        CompanyOrgUnitInfo cou = ScmbillImportUtils.getCompanyInfo(this.getContext(), (OrgUnitInfo)info.getStorageOrgUnit(), 4);
        info.setIsSysBill(false);
        info.setIsCentralBalance(false);
        info.setIsGenBizAP(false);
        BillTypeInfo billtype = new BillTypeInfo();
        billtype.setId(BOSUuid.read((String)"50957179-0105-1000-e000-015fc0a812fd463ED552"));
        info.setBillType(billtype);
        if (cou != null) {
            ObjectUuidPK sourceCurrPK = new ObjectUuidPK(info.getCurrency().getId());
            ObjectUuidPK destCurrPK = new ObjectUuidPK(cou.getBaseCurrency().getId());
            ExchangeRateInfo exchangeRate = SCMServerUtils.getExchangeRate((Context)this.getContext(), (CompanyOrgUnitInfo)cou, (IObjectPK)sourceCurrPK, (IObjectPK)destCurrPK);
            if (info.getExchangeRate() == null) {
                if (exchangeRate != null && exchangeRate.getConvertRate() != null) {
                    info.setExchangeRate(exchangeRate.getConvertRate());
                } else {
                    info.setExchangeRate(new BigDecimal("1.00"));
                }
            }
        }
    }

    @Override
    protected void setDefaultEntryData(SCMBillEntryBaseInfo entryModel, SCMBillBaseInfo model, List<String> errorMsg) throws BOSException, EASBizException {
        PurInWarehsEntryInfo entryInfo = (PurInWarehsEntryInfo)entryModel;
        PurInWarehsBillInfo info = (PurInWarehsBillInfo)model;
        entryInfo.setStorageOrgUnit(info.getStorageOrgUnit());
        entryInfo.setBizDate(info.getBizDate());
        if (entryInfo.getMaterial() != null) {
            entryInfo.setBaseUnit(entryInfo.getMaterial().getBaseUnit());
            this.setBaseQty(entryInfo, errorMsg);
            this.setStandardCost(entryInfo, errorMsg);
        }
        this.setLoclePrice(entryInfo, info);
        entryInfo.setUnWriteOffAmount(entryInfo.getPurchaseCost());
        entryInfo.setReceiveStorageOrgUnit(info.getStorageOrgUnit());
    }

    private void setLoclePrice(PurInWarehsEntryInfo entryInfo, PurInWarehsBillInfo info) {
        BigDecimal amount = this.zero;
        BigDecimal locleAmount = this.zero;
        BigDecimal locleTax = this.zero;
        BigDecimal exchangeRate = info.getExchangeRate();
        int scale = 4;
        if (info.getCurrency() != null) {
            scale = info.getCurrency().getPrecision();
        }
        if (exchangeRate == null) {
            exchangeRate = new BigDecimal("1.00");
        }
        if (entryInfo.getAmount() != null) {
            amount = entryInfo.getAmount();
            locleAmount = amount.multiply(exchangeRate).setScale(scale, 4);
            entryInfo.setLocalAmount(locleAmount);
        }
        if (entryInfo.getTax() != null) {
            locleTax = entryInfo.getTax().multiply(exchangeRate).setScale(scale, 4);
            entryInfo.setLocalTax(locleTax);
        }
        entryInfo.setLocalTaxAmount(locleTax.add(locleAmount));
    }

    private void setBaseQty(PurInWarehsEntryInfo entryInfo, List<String> errorMsg) throws BOSException, EASBizException {
        MaterialInfo material = entryInfo.getMaterial();
        MeasureUnitInfo unit = entryInfo.getUnit();
        MeasureUnitInfo baseunit = entryInfo.getBaseUnit();
        MultiMeasureUnitInfo mmu = ScmbillImportUtils.getMultiMeasureUnit(this.getContext(), material, unit, errorMsg);
        MultiMeasureUnitInfo basemmu = ScmbillImportUtils.getMultiMeasureUnit(this.getContext(), material, baseunit, errorMsg);
        BigDecimal qty = entryInfo.getQty();
        BigDecimal baseQty = this.zero;
        if (qty == null) {
            qty = this.zero;
        }
        if (mmu != null && basemmu != null) {
            qty = qty.setScale(mmu.getQtyPrecision());
            baseQty = qty.multiply(mmu.getBaseConvsRate()).setScale(basemmu.getQtyPrecision(), 4);
        }
        entryInfo.setQty(qty);
        entryInfo.setBaseQty(baseQty);
        entryInfo.setAssociateQty(qty);
        entryInfo.setUnWriteOffQty(qty);
        entryInfo.setAssociateQty(qty);
        entryInfo.setUnWriteOffQty(qty);
        entryInfo.setUnWriteOffBaseQty(baseQty);
        entryInfo.setUnReturnedBaseQty(baseQty);
        entryInfo.setCanDirectReqBaseQty(baseQty);
        entryInfo.setCanDirectReqQty(qty);
        MeasureUnitInfo assistUnit = entryInfo.getAssistUnit();
        if (assistUnit != null) {
            BigDecimal assisqtyQty = InvAppUtils.getMultiUnitQty((Context)this.getContext(), (MeasureUnitInfo)unit, (MeasureUnitInfo)entryInfo.getAssistUnit(), (MaterialInfo)material, (BigDecimal)qty);
            entryInfo.setAssistQty(assisqtyQty);
        }
    }

    private void setStandardCost(PurInWarehsEntryInfo entryInfo, List<String> errorMsg) throws BOSException, EASBizException {
        MaterialInfo material = entryInfo.getMaterial();
        MeasureUnitInfo unit = entryInfo.getUnit();
        CompanyOrgUnitInfo cou = entryInfo.getCompanyOrgUnit();
        MultiMeasureUnitInfo mmu = ScmbillImportUtils.getMultiMeasureUnit(this.getContext(), material, unit, errorMsg);
        MaterialCompanyInfoInfo materialcompanyInfo = ScmbillImportUtils.getMaterialCompanyInfo(this.getContext(), material, cou, errorMsg);
        if (mmu != null && materialcompanyInfo != null && materialcompanyInfo.getStandardCost() != null) {
            BigDecimal qty = entryInfo.getQty();
            BigDecimal unitStandardCost = materialcompanyInfo.getStandardCost().multiply(mmu.getBaseConvsRate());
            entryInfo.setUnitStandardCost(unitStandardCost);
            entryInfo.setStandardCost(unitStandardCost.multiply(qty));
        }
    }

    @Override
    protected void dealWithEntryData(SCMBillEntryBaseInfo entryModel, SCMBillBaseInfo model, List<String> errorMsg) throws BOSException, EASBizException {
        PurInWarehsEntryInfo info = (PurInWarehsEntryInfo)entryModel;
        if (info.getPurchaseGroup() != null && info.getPurchaseOrgUnit() != null && info.getPurchaseOrgUnit().getId() != null) {
            ScmbillImportUtils.setPurchaseGroup(this.getContext(), (CoreBaseInfo)info, errorMsg, "purchaseGroup", info.getPurchaseGroup(), info.getPurchaseOrgUnit().getId().toString());
        }
        if (info.getPurchasePerson() != null && info.getPurchaseGroup() != null && info.getPurchaseGroup().getId() != null) {
            ScmbillImportUtils.setPurchasePerson(this.getContext(), (CoreBaseInfo)info, errorMsg, "purchasePerson", info.getPurchasePerson(), info.getPurchaseGroup().getId().toString());
        }
    }
}

