/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.scm.ws.app.importbill;

import com.google.gson.JsonParseException;
import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.AbstractObjectCollection;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.framework.CoreBillBaseCollection;
import com.kingdee.eas.scm.ws.app.WSResource;
import com.kingdee.eas.scm.ws.app.importbill.ApOtherBillSupport;
import com.kingdee.eas.scm.ws.app.importbill.ArOtherBillSupport;
import com.kingdee.eas.scm.ws.app.importbill.BillResultInfo;
import com.kingdee.eas.scm.ws.app.importbill.BillTypeEnum;
import com.kingdee.eas.scm.ws.app.importbill.IBillSupport;
import com.kingdee.eas.scm.ws.app.importbill.IImportBill;
import com.kingdee.eas.scm.ws.app.importbill.InventoryInitBillSupport;
import com.kingdee.eas.scm.ws.app.importbill.ManufactureRecBillSupport;
import com.kingdee.eas.scm.ws.app.importbill.MaterialReqBillSupport;
import com.kingdee.eas.scm.ws.app.importbill.MaterialRequestBillSupport;
import com.kingdee.eas.scm.ws.app.importbill.MoveInWarehsBillSupport;
import com.kingdee.eas.scm.ws.app.importbill.MoveIssueBillSupport;
import com.kingdee.eas.scm.ws.app.importbill.OtherInWarehsBillSupport;
import com.kingdee.eas.scm.ws.app.importbill.OtherIssueBillSupport;
import com.kingdee.eas.scm.ws.app.importbill.PayRequestBillSupport;
import com.kingdee.eas.scm.ws.app.importbill.PaymentBillSupport;
import com.kingdee.eas.scm.ws.app.importbill.PostRequesitionBillSupport;
import com.kingdee.eas.scm.ws.app.importbill.PurConTractBillSupport;
import com.kingdee.eas.scm.ws.app.importbill.PurInWarehsBillSupport;
import com.kingdee.eas.scm.ws.app.importbill.PurOrderBillSupport;
import com.kingdee.eas.scm.ws.app.importbill.PurReceivalBillSupport;
import com.kingdee.eas.scm.ws.app.importbill.PurRequestBillSupport;
import com.kingdee.eas.scm.ws.app.importbill.ReceivingBillSupport;
import com.kingdee.eas.scm.ws.app.importbill.ResultInfo;
import com.kingdee.eas.scm.ws.app.importbill.SaleContractBillSupport;
import com.kingdee.eas.scm.ws.app.importbill.SaleIssueBillSupport;
import com.kingdee.eas.scm.ws.app.importbill.SaleOrderBillSupport;
import com.kingdee.eas.scm.ws.app.importbill.StockReqBillSupport;
import com.kingdee.eas.scm.ws.app.importbill.StockTransferBillSupport;
import com.kingdee.eas.scm.ws.app.importbill.SubContractOrderBillSupport;
import com.kingdee.eas.scm.ws.app.importbill.SubContractRequestBillSupport;
import com.kingdee.eas.scm.ws.app.importbill.TransferOrderBillSupport;
import com.kingdee.eas.scm.ws.app.json.JSONUtils;
import com.kingdee.util.BOSResourceBundle;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.ResourceBundle;
import org.apache.log4j.Logger;

public class SCMImportBill
implements IImportBill {
    private static Logger logger = Logger.getLogger((String)"com.kingdee.eas.scm.ws.app.importbill.SCMImportBill");
    private static Map<String, Class<IBillSupport>> billClassMap = null;

    @Override
    public String importing(Context ctx, String billType, String billDataJSON, int billStatus) throws BOSException, EASBizException {
        ResultInfo resultInfo = new ResultInfo();
        IBillSupport billSupport = this.getBillSupport(billType);
        if (billSupport == null) {
            String errStr = WSResource.getResource(ctx, "NOT_SUPPORT_AUDITNOT_SUPPORT_BILLTYPE") + billType;
            logger.error((Object)"\u5355\u636e\u7c7b\u578b\u4e0d\u652f\u6301");
            resultInfo.setStatus(1);
            resultInfo.setMsg(errStr);
            return JSONUtils.convertObjectToJson(ctx, resultInfo);
        }
        billSupport.setContext(ctx);
        Object infos = null;
        try {
            infos = JSONUtils.convertJsonToObject(ctx, billDataJSON, billSupport.getInfoClass());
        }
        catch (Exception exp) {
            resultInfo.setStatus(1);
            if (exp.getCause() != null && exp.getCause() instanceof JsonParseException) {
                resultInfo.setMsg(exp.getCause().getMessage());
            } else {
                resultInfo.setMsg(exp.getMessage());
            }
            return JSONUtils.convertObjectToJson(ctx, resultInfo);
        }
        CoreBillBaseCollection objCol = new CoreBillBaseCollection();
        if (infos instanceof AbstractObjectCollection) {
            objCol = (AbstractObjectCollection)infos;
        } else {
            objCol.addObject((IObjectValue)infos);
        }
        if (objCol == null || objCol.size() <= 0) {
            resultInfo.setStatus(1);
            resultInfo.setMsg(WSResource.getResource(ctx, "009_RESOURCE"));
            return JSONUtils.convertObjectToJson(ctx, resultInfo);
        }
        List<BillResultInfo> billErrors = null;
        if (billStatus == 1) {
            billErrors = billSupport.save((AbstractObjectCollection)objCol);
        } else if (billStatus == 2) {
            if (billSupport.isSupportSubmit()) {
                for (int i = 0; i < objCol.size(); ++i) {
                    IObjectValue objectValue = objCol.getObject(i);
                    BOSUuid bosUuid = BOSUuid.create((String)objectValue.getBOSType().toString());
                    objectValue.put("id", (Object)bosUuid);
                }
                billErrors = billSupport.submit((AbstractObjectCollection)objCol);
            } else {
                resultInfo.setStatus(1);
                String errMsg = WSResource.getResource(ctx, "NOT_SUPPORT_SUBMIT");
                resultInfo.setMsg(errMsg);
                logger.error((Object)errMsg);
            }
        } else if (billStatus == 3) {
            if (billSupport.isSupportSubmit() && billSupport.isSupportAudit()) {
                for (int i = 0; i < objCol.size(); ++i) {
                    IObjectValue objectValue = objCol.getObject(i);
                    BOSUuid bosUuid = BOSUuid.create((String)objectValue.getBOSType().toString());
                    objectValue.put("id", (Object)bosUuid);
                }
                billErrors = billSupport.submit((AbstractObjectCollection)objCol);
                billErrors = billSupport.audit(billErrors);
            } else {
                resultInfo.setStatus(1);
                String errMsg = WSResource.getResource(ctx, "NOT_SUPPORT_AUDIT");
                resultInfo.setMsg(errMsg);
                logger.error((Object)errMsg);
            }
        } else {
            resultInfo.setStatus(1);
            String errMsg = WSResource.getResource(ctx, "NOT_SUPPORT_STATUS");
            resultInfo.setMsg(errMsg);
            logger.error((Object)errMsg);
        }
        if (billErrors != null && billErrors.size() > 0) {
            resultInfo.setBillErrors(billErrors);
            if (billErrors.size() == objCol.size()) {
                resultInfo.setStatus(1);
            } else {
                resultInfo.setStatus(2);
            }
        } else {
            resultInfo.setStatus(0);
        }
        return this.processResult(ctx, resultInfo);
    }

    private String processResult(Context ctx, ResultInfo resultInfo) throws BOSException {
        if (resultInfo.getStatus() != 0) {
            BillResultInfo billResult = null;
            int total = resultInfo.getBillErrors().size();
            int size = resultInfo.getBillErrors().size();
            for (int i = 0; i < size; ++i) {
                billResult = resultInfo.getBillErrors().get(i);
                if (billResult.getStatus() != 0) continue;
                resultInfo.getBillErrors().remove(i);
                --i;
                --size;
            }
            if (resultInfo.getBillErrors() != null && resultInfo.getBillErrors().size() == 0) {
                resultInfo.setStatus(0);
            } else if (resultInfo.getBillErrors().size() == total) {
                resultInfo.setStatus(1);
            } else {
                resultInfo.setStatus(2);
            }
        }
        if (resultInfo.getStatus() == 0) {
            resultInfo.getBillErrors().clear();
        }
        return JSONUtils.convertObjectToJson(ctx, resultInfo);
    }

    public IBillSupport getBillSupport(String billType) {
        this.registerBills();
        IBillSupport billSupport = null;
        Class<IBillSupport> billClass = billClassMap.get(billType);
        if (billClass != null) {
            try {
                billSupport = billClass.newInstance();
            }
            catch (InstantiationException e) {
                logger.error((Object)e);
            }
            catch (IllegalAccessException e) {
                logger.error((Object)e);
            }
        }
        return billSupport;
    }

    protected synchronized void registerBills() {
        if (billClassMap != null) {
            return;
        }
        billClassMap = new HashMap<String, Class<IBillSupport>>();
        this.registBill(BillTypeEnum.PURORDER.getNumber(), PurOrderBillSupport.class);
        this.registBill(BillTypeEnum.PURREQUEST.getNumber(), PurRequestBillSupport.class);
        this.registBill(BillTypeEnum.SALEORDER.getNumber(), SaleOrderBillSupport.class);
        this.registBill(BillTypeEnum.TRANSFERBILL.getNumber(), StockTransferBillSupport.class);
        this.registBill(BillTypeEnum.TRANSFERORDER.getNumber(), TransferOrderBillSupport.class);
        this.registBill(BillTypeEnum.PURINWARE.getNumber(), PurInWarehsBillSupport.class);
        this.registBill(BillTypeEnum.SALEISSUE.getNumber(), SaleIssueBillSupport.class);
        this.registBill(BillTypeEnum.OTHERISSUE.getNumber(), OtherIssueBillSupport.class);
        this.registBill(BillTypeEnum.OTHERINWARE.getNumber(), OtherInWarehsBillSupport.class);
        this.registBill(BillTypeEnum.ARBILL.getNumber(), ArOtherBillSupport.class);
        this.registBill(BillTypeEnum.APBILL.getNumber(), ApOtherBillSupport.class);
        this.registBill(BillTypeEnum.PURRECEIVALBILL.getNumber(), PurReceivalBillSupport.class);
        this.registBill(BillTypeEnum.MAUNfAUTURERECBILL.getNumber(), ManufactureRecBillSupport.class);
        this.registBill(BillTypeEnum.MOVEINWAREHSBILL.getNumber(), MoveInWarehsBillSupport.class);
        this.registBill(BillTypeEnum.MATERIALREQUESTBILL.getNumber(), MaterialRequestBillSupport.class);
        this.registBill(BillTypeEnum.MATERIALREQBILL.getNumber(), MaterialReqBillSupport.class);
        this.registBill(BillTypeEnum.MOVEISSUEBILL.getNumber(), MoveIssueBillSupport.class);
        this.registBill(BillTypeEnum.POSTREQUESITION.getNumber(), PostRequesitionBillSupport.class);
        this.registBill(BillTypeEnum.PURCONTRACTION.getNumber(), PurConTractBillSupport.class);
        this.registBill(BillTypeEnum.SALECONTRACTION.getNumber(), SaleContractBillSupport.class);
        this.registBill(BillTypeEnum.INVENTORYINITBILL.getNumber(), InventoryInitBillSupport.class);
        this.registBill(BillTypeEnum.SUBCONTRACTORDERBILL.getNumber(), SubContractOrderBillSupport.class);
        this.registBill(BillTypeEnum.STOCKREQBILL.getNumber(), StockReqBillSupport.class);
        this.registBill(BillTypeEnum.SUBCONTRACTREQUESTBILL.getNumber(), SubContractRequestBillSupport.class);
        this.registBill(BillTypeEnum.PAYREQUEST.getNumber(), PayRequestBillSupport.class);
        this.registBill(BillTypeEnum.PAYMENT_BILL.getNumber(), PaymentBillSupport.class);
        this.registBill(BillTypeEnum.RECEIVING_BILL.getNumber(), ReceivingBillSupport.class);
        this.registeExt();
    }

    protected void registeExt() {
        String resClassName = "com.kingdee.eas.scm.ws.WSimportclasses";
        try {
            ResourceBundle resBundle = BOSResourceBundle.getBundle((String)resClassName, (Locale)new Locale("l1"));
            Enumeration<String> keyIter = resBundle.getKeys();
            while (keyIter.hasMoreElements()) {
                String billType = keyIter.nextElement();
                String className = resBundle.getString(billType);
                if (className == null) continue;
                this.registBill(billType, className);
            }
        }
        catch (Exception e) {
            logger.info((Object)e);
        }
    }

    private void registBill(String billType, Class billClass) {
        if (billClassMap.containsKey(billType)) {
            logger.error((Object)("bill type " + billType + " existed."));
            return;
        }
        billClassMap.put(billType, billClass);
    }

    private void registBill(String billType, String billClassName) {
        if (billClassMap.containsKey(billType)) {
            logger.error((Object)("bill type " + billType + " existed."));
            return;
        }
        Class<IBillSupport> billClass = this.getClass(billClassName);
        if (billClass != null) {
            billClassMap.put(billType, billClass);
        }
    }

    private Class<IBillSupport> getClass(String className) {
        Class<IBillSupport> billClass = null;
        try {
            billClass = Class.forName(className);
        }
        catch (ClassNotFoundException e) {
            logger.error((Object)e);
        }
        return billClass;
    }
}

