/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.scm.ws.app.importbill;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.framework.batch.BatchExecuteParamsEntry;
import com.kingdee.bos.framework.batch.BatchExecuteResult;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.basedata.assistant.MeasureUnitInfo;
import com.kingdee.eas.basedata.master.material.MaterialInfo;
import com.kingdee.eas.basedata.master.material.MultiMeasureUnitInfo;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.basedata.org.OrgUnitInfo;
import com.kingdee.eas.basedata.scm.common.BillTypeInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.scm.common.ISCMBillBase;
import com.kingdee.eas.scm.common.SCMBillBaseInfo;
import com.kingdee.eas.scm.common.SCMBillEntryBaseInfo;
import com.kingdee.eas.scm.im.inv.StockTransferBillCollection;
import com.kingdee.eas.scm.im.inv.StockTransferBillEntryInfo;
import com.kingdee.eas.scm.im.inv.StockTransferBillFactory;
import com.kingdee.eas.scm.im.inv.StockTransferBillInfo;
import com.kingdee.eas.scm.im.inv.app.InvAppUtils;
import com.kingdee.eas.scm.ws.app.importbill.ScmBillSupport;
import com.kingdee.eas.scm.ws.app.importbill.ScmbillImportUtils;
import com.kingdee.util.BaseException;
import java.math.BigDecimal;
import java.util.List;

public class StockTransferBillSupport
extends ScmBillSupport {
    @Override
    public Class<StockTransferBillCollection> getInfoClass() {
        return StockTransferBillCollection.class;
    }

    @Override
    public boolean isSupportSubmit() {
        return true;
    }

    @Override
    public boolean isSupportAudit() {
        return true;
    }

    @Override
    public BatchExecuteResult getBatchExecuteResult(BatchExecuteParamsEntry[] paramEntries, Class[] batchMethod, String methodPK) throws BaseException {
        return super.getBatchExecuteResult(paramEntries, batchMethod, methodPK);
    }

    @Override
    public ISCMBillBase getInterface() throws BOSException {
        return StockTransferBillFactory.getLocalInstance((Context)this.getContext());
    }

    @Override
    protected void setDefaultHeadData(SCMBillBaseInfo model, List<String> errorMsg) throws BOSException, EASBizException {
        StockTransferBillInfo info = (StockTransferBillInfo)model;
        super.setDefaultHeadData((SCMBillBaseInfo)info, errorMsg);
        CompanyOrgUnitInfo isscou = ScmbillImportUtils.getCompanyInfo(this.getContext(), (OrgUnitInfo)info.getIssueStorageOrgUnit(), 4);
        CompanyOrgUnitInfo reccou = ScmbillImportUtils.getCompanyInfo(this.getContext(), (OrgUnitInfo)info.getReceiptStorageOrgUnit(), 4);
        info.setIssueCompanyOrgUnit(isscou);
        info.setReceiptCompanyOrgUnit(reccou);
        info.setIsInitBill(false);
        BillTypeInfo billtype = new BillTypeInfo();
        billtype.setId(BOSUuid.read((String)"50957179-0105-1000-e003-3152c0a812fd463ED552"));
        info.setBillType(billtype);
        info.setIsShipment(false);
        info.setCurrency(isscou.getBaseCurrency());
        info.setExchangeRate(new BigDecimal("1.00"));
    }

    @Override
    protected void setDefaultEntryData(SCMBillEntryBaseInfo entryModel, SCMBillBaseInfo model, List<String> errorMsg) throws BOSException, EASBizException {
        StockTransferBillEntryInfo entryInfo = (StockTransferBillEntryInfo)entryModel;
        StockTransferBillInfo info = (StockTransferBillInfo)model;
        entryInfo.setIssueStorageOrgUnit(info.getIssueStorageOrgUnit());
        entryInfo.setIssueCompanyOrgUnit(info.getIssueCompanyOrgUnit());
        entryInfo.setReceiveCompanyOrgUnit(info.getReceiptCompanyOrgUnit());
        entryInfo.setReceiveStorageOrgUnit(info.getReceiptStorageOrgUnit());
        entryInfo.setBizDate(info.getBizDate());
        if (entryInfo.getMaterial() != null) {
            entryInfo.setBaseUnit(entryInfo.getMaterial().getBaseUnit());
            this.setBaseQty(entryInfo, errorMsg);
        }
        this.setLoclePrice(entryInfo, info);
    }

    private void setLoclePrice(StockTransferBillEntryInfo entryInfo, StockTransferBillInfo info) {
        BigDecimal amount = this.zero;
        BigDecimal locleAmount = this.zero;
        BigDecimal locleTax = this.zero;
        BigDecimal exchangeRate = info.getExchangeRate();
        int scale = 4;
        if (info.getCurrency() != null) {
            scale = info.getCurrency().getPrecision();
        }
        if (exchangeRate == null) {
            exchangeRate = new BigDecimal("1.00");
        }
        if (entryInfo.getAmount() != null) {
            amount = entryInfo.getAmount();
            locleAmount = amount.multiply(exchangeRate).setScale(scale, 4);
            entryInfo.setLocalAmount(locleAmount);
        }
        if (entryInfo.getTax() != null) {
            locleTax = entryInfo.getTax().multiply(exchangeRate).setScale(scale, 4);
            entryInfo.setLocalTax(locleTax);
        }
        entryInfo.setLocalTaxAmount(locleTax.add(locleAmount));
        if (entryInfo.getDiscountAmount() != null) {
            entryInfo.setLocalDiscountAmount(entryInfo.getDiscountAmount().multiply(exchangeRate).setScale(scale, 4));
        }
    }

    private void setBaseQty(StockTransferBillEntryInfo entryInfo, List<String> errorMsg) throws BOSException, EASBizException {
        MaterialInfo material = entryInfo.getMaterial();
        MeasureUnitInfo unit = entryInfo.getUnit();
        MeasureUnitInfo baseunit = entryInfo.getBaseUnit();
        MultiMeasureUnitInfo mmu = ScmbillImportUtils.getMultiMeasureUnit(this.getContext(), material, unit, errorMsg);
        MultiMeasureUnitInfo basemmu = ScmbillImportUtils.getMultiMeasureUnit(this.getContext(), material, baseunit, errorMsg);
        BigDecimal qty = entryInfo.getQty();
        BigDecimal baseQty = this.zero;
        if (qty == null) {
            qty = this.zero;
        }
        if (mmu != null && basemmu != null) {
            qty = qty.setScale(mmu.getQtyPrecision(), 4);
            entryInfo.setQty(qty);
            baseQty = qty.multiply(mmu.getBaseConvsRate()).setScale(basemmu.getQtyPrecision(), 4);
        }
        entryInfo.setQty(qty);
        entryInfo.setBaseQty(baseQty);
        entryInfo.setAssociateQty(qty);
        entryInfo.setUnIssueBaseQty(qty);
        entryInfo.setArAssociateBaseQty(baseQty);
        entryInfo.setApAssociateBaseQty(baseQty);
        MeasureUnitInfo assistUnit = entryInfo.getAssistUnit();
        if (assistUnit != null) {
            BigDecimal assisqtyQty = InvAppUtils.getMultiUnitQty((Context)this.getContext(), (MeasureUnitInfo)unit, (MeasureUnitInfo)entryInfo.getAssistUnit(), (MaterialInfo)material, (BigDecimal)qty);
            entryInfo.setAssistQty(assisqtyQty);
        }
    }
}

