/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.hr.ats.app;

import com.alibaba.fastjson.JSON;
import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectCollection;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.IMetaDataLoader;
import com.kingdee.bos.metadata.MetaDataLoaderFactory;
import com.kingdee.bos.metadata.entity.EntityObjectInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.bos.workflow.ProcessInstInfo;
import com.kingdee.bos.workflow.service.ormrpc.EnactmentServiceFactory;
import com.kingdee.bos.workflow.service.ormrpc.IEnactmentService;
import com.kingdee.eas.base.multiapprove.ApproveResult;
import com.kingdee.eas.base.multiapprove.IMultiApprove;
import com.kingdee.eas.base.multiapprove.MultiApproveFactory;
import com.kingdee.eas.base.multiapprove.MultiApproveInfo;
import com.kingdee.eas.base.permission.UserInfo;
import com.kingdee.eas.basedata.person.PersonInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.framework.CoreBillBaseInfo;
import com.kingdee.eas.framework.ICoreBase;
import com.kingdee.eas.hr.affair.AffairBizException;
import com.kingdee.eas.hr.ats.AtsAcrossStoreSopportInfo;
import com.kingdee.eas.hr.ats.AtsAffairBaseInfo;
import com.kingdee.eas.hr.ats.AtsLeaveBillFactory;
import com.kingdee.eas.hr.ats.AtsLeaveBillInfo;
import com.kingdee.eas.hr.ats.AtsOverTimeBillFactory;
import com.kingdee.eas.hr.ats.AtsOverTimeBillInfo;
import com.kingdee.eas.hr.ats.AtsTripBillEntryFactory;
import com.kingdee.eas.hr.ats.AtsTripBillEntryInfo;
import com.kingdee.eas.hr.ats.AtsTripBillFactory;
import com.kingdee.eas.hr.ats.AtsTripBillInfo;
import com.kingdee.eas.hr.ats.AtsUtil;
import com.kingdee.eas.hr.ats.CanTripBillEntryCollection;
import com.kingdee.eas.hr.ats.CanTripBillEntryFactory;
import com.kingdee.eas.hr.ats.CanTripBillEntryInfo;
import com.kingdee.eas.hr.ats.CanTripBillFactory;
import com.kingdee.eas.hr.ats.CanTripBillInfo;
import com.kingdee.eas.hr.ats.CancelLeaveBillFactory;
import com.kingdee.eas.hr.ats.CancelLeaveBillInfo;
import com.kingdee.eas.hr.ats.FillSignCardFactory;
import com.kingdee.eas.hr.ats.FillSignCardInfo;
import com.kingdee.eas.hr.ats.OperActionEnum;
import com.kingdee.eas.hr.ats.OperTypeEnum;
import com.kingdee.eas.hr.ats.abnormal.AbnormalWebUtil;
import com.kingdee.eas.hr.ats.app.AbstractAtsAffairBaseControllerBean;
import com.kingdee.eas.hr.ats.dataLog.util.DataLogsRecordUtil;
import com.kingdee.eas.hr.ats.lightapp.util.AtsWebUtils;
import com.kingdee.eas.hr.ats.result.AttendCalculateJob;
import com.kingdee.eas.hr.ats.util.AtsBillEntryHandlerUtils;
import com.kingdee.eas.hr.ats.util.AtsDateUtils;
import com.kingdee.eas.hr.ats.util.AtsLeaveBillUtils;
import com.kingdee.eas.hr.ats.util.AtsScheduleShiftUtil;
import com.kingdee.eas.hr.ats.util.AtsWaitCalUtil;
import com.kingdee.eas.hr.ats.util.SHRBillServerUtil;
import com.kingdee.eas.hr.ats.util.common.AtsBillAssist;
import com.kingdee.eas.hr.ats.util.common.AtsCollectionUtile;
import com.kingdee.eas.hr.ats.util.common.AtsEntityUtile;
import com.kingdee.eas.hr.ats.util.common.CoreBaseUtile;
import com.kingdee.eas.hr.ats.util.common.DataSaver;
import com.kingdee.eas.hr.ats.util.common.MutexUtile;
import com.kingdee.eas.hr.ats.util.common.TimeZoneUtile;
import com.kingdee.eas.hr.ats.validator.AtsAcrossStoreBillHelper;
import com.kingdee.eas.hr.ats.validator.BillHelper;
import com.kingdee.eas.hr.ats.validator.CanTripBillHelper;
import com.kingdee.eas.hr.ats.validator.FillsigncardHelper;
import com.kingdee.eas.hr.ats.validator.TripBillHelper;
import com.kingdee.eas.hr.ats.validator.ValidateUtile;
import com.kingdee.eas.hr.base.ApproveTypeEnum;
import com.kingdee.eas.hr.base.HRBillBaseInfo;
import com.kingdee.eas.hr.base.HRBillStateEnum;
import com.kingdee.eas.hr.base.IHRBillBase;
import com.kingdee.eas.hr.base.app.BillExtendBeanProcess;
import com.kingdee.eas.hr.base.app.HRBillBeanBizFactory;
import com.kingdee.eas.hr.base.app.IHRBillBizBean;
import com.kingdee.eas.hr.base.app.PlugInBeanFactory;
import com.kingdee.eas.hr.base.app.PlugInBeanProxy;
import com.kingdee.eas.hr.base.app.util.MetaDataServerUtil;
import com.kingdee.eas.hr.base.util.IReflectMethod;
import com.kingdee.eas.util.ResourceBase;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.shr.base.syssetting.app.osf.OSFAppUtil;
import com.kingdee.util.StringUtils;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import org.apache.log4j.Logger;

public class AtsAffairBaseControllerBean
extends AbstractAtsAffairBaseControllerBean {
    private static Logger logger = Logger.getLogger((String)"com.kingdee.eas.hr.ats.app.AtsAffairBaseControllerBean");
    private IHRBillBizBean bizBean = null;
    private static Map<Class, BillHelper> billHelperMap = new HashMap<Class, BillHelper>();

    public static void registBillHelper(Class billClass, BillHelper billHelper) {
        if (billHelper != null && billClass != null) {
            billHelperMap.put(billClass, billHelper);
        }
    }

    public static Map getAllBillHelper() {
        return Collections.unmodifiableMap(billHelperMap);
    }

    @Override
    protected void _setPassState(Context ctx, BOSUuid billId) throws BOSException, EASBizException {
        this.onBillAudied(ctx, billId);
        this._setState(ctx, billId, HRBillStateEnum.AUDITED);
        AtsWaitCalUtil.atsBillWaitCal(ctx, billId.toString());
    }

    protected void isCanDelete(Context ctx, IObjectPK pk, CoreBillBaseInfo coreBillInfo) throws BOSException, EASBizException {
        super.isCanDelete(ctx, pk, coreBillInfo);
        ValidateUtile.validateWithException(ctx, this.getCoreBillBaseInfo(ctx, pk));
    }

    public void createBackJob(Context ctx, BOSUuid billId) throws BOSException, EASBizException {
        Object backJob;
        String endTime;
        String beginTime;
        String personId;
        String sqltrip = " select * from  T_HR_ATS_TripBill where Fid = '" + billId + "' ";
        IRowSet rowtrip = null;
        rowtrip = DbUtil.executeQuery((Context)ctx, (String)sqltrip);
        if (rowtrip.size() != 0) {
            AtsTripBillInfo tripInfo = AtsTripBillFactory.getLocalInstance(ctx).getAtsTripBillInfo(" where id='" + billId.toString() + "'");
            AtsWaitCalUtil.atsTBWaitCal(ctx, tripInfo);
            AttendCalculateJob backJob2 = new AttendCalculateJob();
            String tripbillId = tripInfo.getId().toString();
            Map<String, String> map = AtsBillEntryHandlerUtils.getEarliestEntryInfo((CoreBaseInfo)tripInfo, OperTypeEnum.tripBill);
            if (AtsScheduleShiftUtil.needCalAttendCalculateJob(ctx, map.get("beginTime"), map.get("endTime"), map.get("personId")).booleanValue()) {
                String personId2 = null;
                String beginTime2 = null;
                String endTime2 = null;
                String billNumber = tripInfo.getNumber();
                backJob2.createTripBillTriggerAttendCalJob(ctx, beginTime2, endTime2, tripbillId, personId2, billNumber);
            }
        }
        String sqlleave = " select * from  T_HR_ATS_LeaveBill where Fid = '" + billId + "' ";
        IRowSet rowleave = null;
        rowleave = DbUtil.executeQuery((Context)ctx, (String)sqlleave);
        if (rowleave.size() != 0) {
            AtsLeaveBillInfo leaveInfo = AtsLeaveBillFactory.getLocalInstance(ctx).getAtsLeaveBillInfo(" where id='" + billId.toString() + "'");
            AtsWaitCalUtil.atsLBWaitCal(ctx, leaveInfo);
            Map<String, String> earliestEntryInfo = AtsBillEntryHandlerUtils.getEarliestEntryInfo((CoreBaseInfo)leaveInfo, OperTypeEnum.leaveBill);
            String personId1 = earliestEntryInfo.get("personId");
            String beginTime1 = earliestEntryInfo.get("beginTime");
            String endTime1 = earliestEntryInfo.get("endTime");
            if (null != personId1 && personId1.length() > 0 && null != beginTime1 && beginTime1.length() > 0 && AtsScheduleShiftUtil.needCalAttendCalculateJob(ctx, beginTime1, endTime1, personId1).booleanValue()) {
                AttendCalculateJob backJob3 = new AttendCalculateJob();
                String leavebillId = leaveInfo.getId().toString();
                String billNumber = leaveInfo.getNumber();
                personId = null;
                beginTime = null;
                endTime = null;
                backJob3.createLeaveBillTriggerAttendCalJob(ctx, beginTime, endTime, leavebillId, personId, billNumber);
            }
        }
        String sqlcanleave = " select * from  T_HR_ATS_CanLeaveBill where Fid = '" + billId + "' ";
        IRowSet rowcanleave = null;
        rowcanleave = DbUtil.executeQuery((Context)ctx, (String)sqlcanleave);
        if (rowcanleave.size() != 0) {
            CancelLeaveBillInfo cancelleaveInfo = CancelLeaveBillFactory.getLocalInstance(ctx).getCancelLeaveBillInfo(" where id='" + billId.toString() + "'");
            AtsWaitCalUtil.atsCBWaitCal(ctx, cancelleaveInfo);
            Map<String, String> earliestEntryInfo = AtsBillEntryHandlerUtils.getEarliestEntryInfo((CoreBaseInfo)cancelleaveInfo, OperTypeEnum.cancelLeaveBill);
            String personId3 = earliestEntryInfo.get("personId");
            String beginTime3 = earliestEntryInfo.get("beginTime");
            String endTime3 = earliestEntryInfo.get("endTime");
            if (null != personId3 && personId3.length() > 0 && null != beginTime3 && beginTime3.length() > 0 && AtsScheduleShiftUtil.needCalAttendCalculateJob(ctx, beginTime3, endTime3, personId3).booleanValue()) {
                backJob = new AttendCalculateJob();
                String canleavebillId = cancelleaveInfo.getId().toString();
                String billNumber = cancelleaveInfo.getNumber();
                ((AttendCalculateJob)backJob).createCancelLeaveBillTriggerAttendCalJob(ctx, beginTime3, endTime3, canleavebillId, personId3, billNumber);
            }
        }
        String sqlovertime = " select * from  T_HR_ATS_OverTimeBill where Fid = '" + billId + "' ";
        IRowSet rowovertime = null;
        rowovertime = DbUtil.executeQuery((Context)ctx, (String)sqlovertime);
        if (rowovertime.size() != 0) {
            Map<String, String> map;
            AtsOverTimeBillInfo overTimeBillInfo = AtsOverTimeBillFactory.getLocalInstance(ctx).getAtsOverTimeBillInfo(" where id='" + billId.toString() + "'");
            AtsWaitCalUtil.atsOTBWaitCal(ctx, overTimeBillInfo);
            if (SHRBillServerUtil.overTimeControl(ctx, overTimeBillInfo.getHrOrgUnit().getId().toString())) {
                try {
                    String serviceName = "calculatePersonOTLimit";
                    HashMap<String, Object> param = new HashMap<String, Object>();
                    param.put("billId", billId);
                    param.put("operator", "approve");
                    backJob = OSFAppUtil.callService((Context)ctx, (String)serviceName, param);
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
            if (AtsScheduleShiftUtil.needCalAttendCalculateJob(ctx, (map = AtsBillEntryHandlerUtils.getEarliestEntryInfo((CoreBaseInfo)overTimeBillInfo, OperTypeEnum.otBill)).get("beginTime"), map.get("endTime"), map.get("personId")).booleanValue()) {
                AttendCalculateJob backJob4 = new AttendCalculateJob();
                String overtimebillId = overTimeBillInfo.getId().toString();
                String billNumber = overTimeBillInfo.getNumber();
                String personId4 = null;
                String beginTime4 = null;
                String endTime4 = null;
                backJob4.createOverTimeBillTriggerAttendCalJob(ctx, beginTime4, endTime4, overtimebillId, personId4, billNumber);
            }
        }
        String sqlfill = " select * from  T_HR_ATS_FillSignCard where Fid = '" + billId + "' ";
        IRowSet rowfill = null;
        rowfill = DbUtil.executeQuery((Context)ctx, (String)sqlfill);
        if (rowfill.size() != 0) {
            FillSignCardInfo fillInfo = FillSignCardFactory.getLocalInstance(ctx).getFillSignCardInfo(" where id='" + billId.toString() + "'");
            AtsWaitCalUtil.atsFSCWaitCal(ctx, fillInfo);
            Map<String, String> earliestEntryInfo = AtsBillEntryHandlerUtils.getEarliestEntryInfo((CoreBaseInfo)fillInfo, OperTypeEnum.signCard);
            personId = earliestEntryInfo.get("personId");
            beginTime = earliestEntryInfo.get("beginTime");
            endTime = earliestEntryInfo.get("endTime");
            if (null != personId && personId.length() > 0 && null != beginTime && beginTime.length() > 0 && AtsScheduleShiftUtil.needCalAttendCalculateJob(ctx, beginTime, endTime, personId).booleanValue()) {
                AttendCalculateJob backJob5 = new AttendCalculateJob();
                String fillId = fillInfo.getId().toString();
                String billNumber = fillInfo.getNumber();
                ArrayList<String> attendList = new ArrayList<String>();
                for (int j = 0; j < fillInfo.getEntries().size(); ++j) {
                    String date = AtsDateUtils.dateLongToString(fillInfo.getEntries().get(j).getAttendDate());
                    attendList.add(date);
                }
                backJob5.createFillSignCardBillTriggerAttendCalJob(ctx, ((Object)attendList).toString(), fillId, personId, billNumber);
            }
        }
        String canTripBillSql = " select * from  T_ATS_CanTripBill where Fid = '" + billId + "'";
        IRowSet rowCanTripBill = null;
        rowCanTripBill = DbUtil.executeQuery((Context)ctx, (String)canTripBillSql);
        if (rowCanTripBill != null && rowCanTripBill.size() != 0) {
            CanTripBillInfo canTripBillInfo = CanTripBillFactory.getLocalInstance(ctx).getCanTripBillInfo((IObjectPK)new ObjectUuidPK(billId));
            AtsWaitCalUtil.atsCanTripBillWaitCal(ctx, canTripBillInfo);
            CanTripBillEntryInfo canTripBillEntryInfo = canTripBillInfo.getEntries().get(0);
            if (AtsScheduleShiftUtil.needCalAttendCalculateJob(ctx, AtsDateUtils.timestampToString(canTripBillEntryInfo.getRealStartTime()), AtsDateUtils.dateLongToString(canTripBillEntryInfo.getRealEndTime()), canTripBillEntryInfo.getPerson().getId().toString()).booleanValue()) {
                AttendCalculateJob backJob6 = new AttendCalculateJob();
                String canTripBillId = canTripBillInfo != null && canTripBillInfo.getId() != null ? canTripBillInfo.getId().toString() : "";
                String billNumber = canTripBillInfo.getNumber();
                CanTripBillEntryCollection canTripBillEntryCollection = CanTripBillEntryFactory.getLocalInstance(ctx).getCanTripBillEntryCollection(" where bill = '" + canTripBillId + "'");
                CanTripBillEntryInfo entryInfo = canTripBillEntryCollection.get(0);
                PersonInfo tmpPerson = entryInfo.getPerson();
                String personId5 = tmpPerson != null && tmpPerson.getId() != null ? tmpPerson.getId().toString() : "";
                String beginTime5 = AtsDateUtils.timestampToString(entryInfo.getRealStartTime());
                String endTime5 = AtsDateUtils.timestampToString(entryInfo.getRealEndTime());
                backJob6.createCanTripBillTriggerAttendCalJob(ctx, beginTime5, endTime5, canTripBillId, personId5, billNumber);
            }
        }
    }

    public void updateBillEnryInfo(Context ctx, BOSUuid billId) throws BOSException, EASBizException {
        String sqltrip = " select bill.*,entry.*  from T_ATS_CanTripBill bill left join  T_ATS_CanTripBillEntry entry on bill.fid = entry.fbillid where bill.Fid = '" + billId + "' ";
        IRowSet rowtrip = null;
        rowtrip = DbUtil.executeQuery((Context)ctx, (String)sqltrip);
        if (rowtrip.size() != 0) {
            try {
                if (rowtrip.next()) {
                    AtsTripBillEntryInfo tripInfo = AtsTripBillEntryFactory.getLocalInstance(ctx).getAtsTripBillEntryInfo(" where id='" + rowtrip.getString("FTripentryBillID") + "'");
                    String tripbillId = tripInfo.getId().toString();
                    AtsLeaveBillUtils.updateAtsTripBillEntryIsCancelTripInfo(ctx, tripbillId, 2);
                }
            }
            catch (SQLException e) {
                e.printStackTrace();
            }
        }
        String sqlleave = " select bill.*,entry.FLeaveEntryBillID as FLeaveEntryBillID  from T_HR_ATS_CanLeaveBill bill left join  T_HR_ATS_CanLeaveBillEntry entry on bill.fid = entry.fbillid where bill.Fid = '" + billId + "' ";
        IRowSet rowleave = null;
        rowleave = DbUtil.executeQuery((Context)ctx, (String)sqlleave);
        if (rowleave.size() != 0) {
            try {
                if (rowleave.next()) {
                    AtsLeaveBillUtils.updateAtsLeaveBillEntryIsCancelLeaveInfo(ctx, rowleave.getString("FLeaveEntryBillID"), 0);
                }
            }
            catch (SQLException e) {
                e.printStackTrace();
            }
        }
    }

    @Override
    protected void _setNoPassState(Context ctx, BOSUuid billId) throws BOSException, EASBizException {
        this._setState(ctx, billId, HRBillStateEnum.AUDITEND);
    }

    @Override
    protected void _setApproveState(Context ctx, BOSUuid billId) throws BOSException, EASBizException {
        this._setState(ctx, billId, HRBillStateEnum.AUDITING);
    }

    @Override
    protected void _setEditState(Context ctx, BOSUuid billId) throws BOSException, EASBizException {
        this._setState(ctx, billId, HRBillStateEnum.SAVED);
    }

    @Override
    protected void _setState(Context ctx, BOSUuid billId, HRBillStateEnum state) throws BOSException, EASBizException {
        ObjectUuidPK pk = new ObjectUuidPK(billId);
        AtsAffairBaseInfo info = (AtsAffairBaseInfo)this._getValue(ctx, "select id, billState,lastUpdateTime,lastUpdateUser  where id = '" + pk.toString() + "'");
        info.setBillState(state);
        info.setLastUpdateTime(new Timestamp(System.currentTimeMillis()));
        SelectorItemCollection selectors = new SelectorItemCollection();
        selectors.add(new SelectorItemInfo("id"));
        selectors.add(new SelectorItemInfo("billState"));
        selectors.add(new SelectorItemInfo("lastUpdateTime"));
        selectors.add(new SelectorItemInfo("lastUpdateUser"));
        info.setLastUpdateTime(new Timestamp(System.currentTimeMillis()));
        info.setLastUpdateUser((UserInfo)ctx.get((Object)"UserInfo"));
        this.updatePartial(ctx, info, selectors);
        if (state.getValue() == 3) {
            this.createBackJob(ctx, billId);
            this.triggerTimeZoneChange(ctx, billId);
        }
        if (state.getValue() == 4 || state.getValue() == 0) {
            this.updateBillEnryInfo(ctx, billId);
        }
    }

    protected void triggerTimeZoneChange(Context ctx, BOSUuid billId) {
        String billIdStr = String.valueOf(billId);
        try {
            Class valueCls = AtsEntityUtile.getEntityObj(ctx, billIdStr).getObjectValueClazzRuntime();
            if (AtsTripBillInfo.class.isAssignableFrom(valueCls)) {
                TimeZoneUtile.triggerAuthenTrip(ctx, billIdStr);
            } else if (CanTripBillInfo.class.isAssignableFrom(valueCls)) {
                TimeZoneUtile.triggerAuthenCanTrip(ctx, billIdStr);
            }
        }
        catch (Exception e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
        }
        System.out.println("triggerTimeZoneChange success");
    }

    @Override
    protected void _batchPassAudit(Context ctx, String[] billIds) throws BOSException, EASBizException {
    }

    @Override
    protected void _setEffectDate(Context ctx, BOSUuid entryId) throws BOSException, EASBizException {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected IObjectPK _submitEffect(Context ctx, CoreBaseInfo model) throws BOSException, EASBizException {
        IObjectPK objectPK = null;
        try {
            this.beforSubmitEffect(ctx, model);
            this.onBillSubmit(ctx, model);
            this.onBillAudied(ctx, model);
            AtsAffairBaseInfo bill = (AtsAffairBaseInfo)model;
            bill.setApproveType(ApproveTypeEnum.DIRECT);
            bill.setBillState(HRBillStateEnum.AUDITED);
            objectPK = super._save(ctx, (IObjectValue)model);
            model.setId(BOSUuid.read((String)objectPK.toString()));
            this.setAudited(ctx, BOSUuid.read((String)objectPK.toString()));
            this.triggerTimeZoneChange(ctx, bill.getId());
        }
        finally {
            this.afterSubmitEffect(ctx, model);
        }
        return objectPK;
    }

    protected void _setAudited(Context ctx, BOSUuid billID) throws BOSException, EASBizException {
        if (billID == null) {
            return;
        }
        HRBillBaseInfo model = this.getHRBillBaseInfo(ctx, (IObjectPK)new ObjectUuidPK(billID));
        if (this.bizBean != null) {
            this.bizBean._personPlanChek(ctx, (IObjectValue)model);
        }
        this.initBizBean(ctx);
        this.updateBillState(ctx, billID, HRBillStateEnum.AUDITED);
        if (this.bizBean != null) {
            this.bizBean._setBillState(ctx, billID, HRBillStateEnum.AUDITED);
        }
        if (ApproveTypeEnum.DIRECT.equals((Object)model.getApproveType())) {
            this.saveMultiApproveInfo(ctx, billID);
        }
    }

    private void saveMultiApproveInfo(Context ctx, BOSUuid billId) throws BOSException, EASBizException {
        IMultiApprove im = MultiApproveFactory.getLocalInstance((Context)ctx);
        MultiApproveInfo info = new MultiApproveInfo();
        info.setIsPass(ApproveResult.PASS);
        info.setOpinion(ResourceBase.getString((String)"com.kingdee.eas.hr.base.BASEAutoGenerateResource", (String)"0_HRBillBaseControllerBean", (Locale)ctx.getLocale()));
        info.setBillId(billId);
        info.setBosTypeStr(billId.getType().toString());
        im.addnew((CoreBaseInfo)info);
    }

    private void initBizBean(Context ctx) throws BOSException, EASBizException {
        if (this.bizBean == null) {
            this.bizBean = this.getBizBean();
            if (this.bizBean != null) {
                BillExtendBeanProcess billExtend = BillExtendBeanProcess.getInstance((String)this.bizBean.getExtendBillName(ctx));
                PlugInBeanProxy plugIn = null;
                IMetaDataLoader loader = MetaDataLoaderFactory.getLocalMetaDataLoader((Context)ctx);
                EntityObjectInfo entity = loader.getEntity(this.getBOSType());
                if (entity != null) {
                    String fullName = entity.getFullName();
                    try {
                        plugIn = PlugInBeanFactory.getPlugIn((Context)ctx, (String)fullName);
                    }
                    catch (Exception e) {
                        throw new BOSException("PlugInBean Get Error:" + e.getMessage(), e.getCause());
                    }
                }
                IReflectMethod[] decorators = null;
                if (plugIn != null && billExtend != null) {
                    decorators = new IReflectMethod[]{plugIn, billExtend};
                } else if (billExtend != null) {
                    decorators = new IReflectMethod[]{billExtend};
                } else if (plugIn != null) {
                    decorators = new IReflectMethod[]{plugIn};
                }
                if (decorators != null) {
                    try {
                        this.bizBean = new HRBillBeanBizFactory(this.bizBean).getBizProxy(decorators);
                    }
                    catch (Throwable e) {
                        throw new BOSException("bizBean:" + this.bizBean.getExtendBillName(ctx) + ";plugin:" + plugIn, e);
                    }
                }
            }
        }
    }

    protected void _abortBizBill(Context ctx, String billId) throws BOSException, EASBizException {
        if (!StringUtils.isEmpty((String)billId)) {
            IHRBillBase iHRBillBase = (IHRBillBase)MetaDataServerUtil.getBizInterface((Context)ctx, (BOSObjectType)BOSUuid.read((String)billId).getType());
            HRBillBaseInfo billInfo = iHRBillBase.getHRBillBaseInfo((IObjectPK)new ObjectUuidPK(billId));
            ValidateUtile.validateWithException(ctx, billInfo);
            if (Arrays.asList(HRBillStateEnum.SUBMITED, HRBillStateEnum.AUDITING, HRBillStateEnum.AUDITEND).contains(billInfo.getBillState())) {
                iHRBillBase.setSaved(BOSUuid.read((String)billId));
                this.abortWorkFlow(ctx, billId);
            } else {
                throw new AffairBizException(AffairBizException.BILLSTATECANTSUPPORT);
            }
        }
    }

    protected void _setSaved(Context ctx, BOSUuid billID) throws BOSException, EASBizException {
        super._setSaved(ctx, billID);
        AtsBillAssist.updateEntriesLastUpdateInfo(ctx, billID == null ? null : billID.toString());
    }

    protected void abortWorkFlow(Context ctx, String billId) throws BOSException {
        IEnactmentService service = EnactmentServiceFactory.createEnactService((Context)ctx);
        ProcessInstInfo[] procInsts = service.getProcessInstanceByHoldedObjectId(billId);
        if (procInsts == null || procInsts.length <= 0) {
            return;
        }
        ProcessInstInfo processInstInfo = null;
        int length = procInsts.length;
        for (int i = 0; i < length; ++i) {
            if (!procInsts[i].getState().startsWith("open")) continue;
            processInstInfo = procInsts[i];
        }
        if (processInstInfo != null) {
            service.abortProcessInst(processInstInfo.getProcInstId().toString());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected IObjectPK _submit(Context ctx, IObjectValue model) throws BOSException, EASBizException {
        IObjectPK pk = null;
        try {
            this.beforeSubmit(ctx, (CoreBaseInfo)model);
            this.onBillSubmit(ctx, (CoreBaseInfo)model);
            pk = super._submit(ctx, model);
        }
        finally {
            this.afterSubmit(ctx, (CoreBaseInfo)model);
        }
        return pk;
    }

    protected void afterSubmitEffect(Context ctx, CoreBaseInfo model) throws BOSException, EASBizException {
        if (!StringUtils.isEmpty((String)model.getString("id"))) {
            MutexUtile.releaseObjIDForUpdate(ctx, model.getString("id"));
        }
        this.confirmUnnormal(ctx, model);
        if (billHelperMap.containsKey(model.getClass())) {
            DataLogsRecordUtil.processFormObjectsLog(model, OperActionEnum.submitEffect, ctx);
        }
    }

    protected void beforSubmitEffect(Context ctx, CoreBaseInfo model) throws BOSException, EASBizException {
        this.storefields(ctx, model);
        ValidateUtile.validateWithException(ctx, model);
        if (!StringUtils.isEmpty((String)model.getString("id"))) {
            MutexUtile.requestObjIDForUpdate(ctx, model.getString("id"));
        }
        if (billHelperMap.containsKey(model.getClass()) && AtsWebUtils.isInWorkFlow(ctx, CoreBaseUtile.getId(model))) {
            AtsWebUtils.abortWorkFlow(ctx, CoreBaseUtile.getId(model));
        }
    }

    protected void confirmUnnormal(Context ctx, CoreBaseInfo model) {
        boolean confirm;
        String abnormalIds = (String)model.remove("abnormalId");
        boolean bl = confirm = model instanceof AtsTripBillInfo || model instanceof FillSignCardInfo || model instanceof AtsLeaveBillInfo;
        if (confirm && org.apache.commons.lang3.StringUtils.isNotBlank((CharSequence)abnormalIds)) {
            if (abnormalIds.charAt(0) == '[') {
                List abList = JSON.parseArray((String)abnormalIds, String.class);
                abnormalIds = AtsUtil.convertListToString(abList);
            }
            AbnormalWebUtil abnormalWebUtil = new AbnormalWebUtil();
            abnormalWebUtil.feedBack(ctx, abnormalIds);
        }
    }

    protected void afterSubmit(Context ctx, CoreBaseInfo model) throws BOSException, EASBizException {
        if (!StringUtils.isEmpty((String)model.getString("id"))) {
            MutexUtile.releaseObjIDForUpdate(ctx, model.getString("id"));
        }
        this.confirmUnnormal(ctx, model);
        if (billHelperMap.containsKey(model.getClass())) {
            DataLogsRecordUtil.processFormObjectsLog(model, OperActionEnum.submit, ctx);
        }
    }

    protected void beforeSubmit(Context ctx, CoreBaseInfo model) throws BOSException, EASBizException {
        this.storefields(ctx, model);
        ValidateUtile.validateWithException(ctx, model);
        model.setInt("billState", 1);
        if (!StringUtils.isEmpty((String)model.getString("id"))) {
            MutexUtile.requestObjIDForUpdate(ctx, model.getString("id"));
        }
    }

    protected void onBillSubmit(Context ctx, CoreBaseInfo model) throws EASBizException, BOSException {
    }

    protected void onBillAudied(Context ctx, Object model) throws EASBizException, BOSException {
    }

    protected void storefields(Context ctx, CoreBaseInfo model) throws EASBizException, BOSException {
        BillHelper billHelper = billHelperMap.get(model.getClass());
        if (billHelper != null) {
            billHelper.storefields(ctx, (AtsAffairBaseInfo)model);
        }
    }

    protected IObjectPK _save(Context ctx, IObjectValue model) throws BOSException, EASBizException {
        IObjectPK iObjectPK;
        this.beforeSave(ctx, (CoreBaseInfo)model);
        boolean savePartial = model.getBoolean("_savePartial");
        IObjectPK iObjectPK2 = iObjectPK = savePartial ? null : super._save(ctx, model);
        if (savePartial) {
            for (String entryField : new String[]{"spts", "entries"}) {
                IObjectCollection entries;
                Object entriesObj = model.get(entryField);
                if (!(entriesObj instanceof IObjectCollection) || (entries = (IObjectCollection)entriesObj).size() <= 0) continue;
                ICoreBase iCoreBase = AtsEntityUtile.getBizInterface(ctx, (CoreBaseInfo)entries.getObject(0));
                iCoreBase.saveBatchData(AtsCollectionUtile.toCoreCollection(entries));
            }
            new DataSaver(ctx).save((CoreBaseInfo)model);
            iObjectPK = new ObjectUuidPK(CoreBaseUtile.getId(model));
        }
        this.afterSave(ctx, (CoreBaseInfo)model);
        return iObjectPK;
    }

    protected void beforeSave(Context ctx, CoreBaseInfo model) throws EASBizException, BOSException {
        this.storefields(ctx, model);
    }

    protected void afterSave(Context ctx, CoreBaseInfo model) throws EASBizException, BOSException {
        this.confirmUnnormal(ctx, model);
        boolean isAddNew = "isAddNew".equals(model.getExtendedProperty("isAddNew"));
        if (billHelperMap.containsKey(model.getClass())) {
            DataLogsRecordUtil.processFormObjectsLog(model, isAddNew ? OperActionEnum.addNew : OperActionEnum.modify, ctx);
        }
    }

    static {
        AtsAffairBaseControllerBean.registBillHelper(AtsTripBillInfo.class, new TripBillHelper());
        AtsAffairBaseControllerBean.registBillHelper(CanTripBillInfo.class, new CanTripBillHelper());
        AtsAffairBaseControllerBean.registBillHelper(FillSignCardInfo.class, new FillsigncardHelper());
        AtsAffairBaseControllerBean.registBillHelper(AtsAcrossStoreSopportInfo.class, new AtsAcrossStoreBillHelper());
    }
}

