/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.hr.ats.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.eas.hr.ats.app.AbstractAtsDataLogFacadeControllerBean;
import com.kingdee.eas.hr.ats.dataLog.service.DataLogService;
import com.kingdee.eas.hr.ats.dataLog.service.impl.AtsBillDataLogServiceImpl;
import com.kingdee.eas.hr.ats.dataLog.service.impl.AtsLimitDataLogServiceImpl;
import com.kingdee.eas.hr.ats.dataLog.service.impl.AtsResultDataLogServiceImpl;
import com.kingdee.eas.hr.ats.dataLog.service.impl.AtsRuleMatchLogServiceImpl;
import com.kingdee.eas.hr.ats.dataLog.service.impl.AtsSumDataLogServiceImpl;
import com.kingdee.eas.hr.ats.dataLog.service.impl.AttendanceLogEntryServiceImpl;
import com.kingdee.eas.hr.ats.dataLog.service.impl.AttendanceLogServiceImpl;
import com.kingdee.eas.hr.ats.dataLog.service.impl.ScheduleShiftDataLogServiceImpl;
import com.kingdee.eas.hr.ats.dataLog.util.AtsCostTimeRelUtils;
import com.kingdee.eas.hr.ats.util.AtsDateUtils;
import java.util.Date;
import org.apache.commons.lang3.StringUtils;
import org.apache.log4j.Logger;

public class AtsDataLogFacadeControllerBean
extends AbstractAtsDataLogFacadeControllerBean {
    private static Logger logger = Logger.getLogger((String)"com.kingdee.eas.hr.ats.app.AtsDataLogFacadeControllerBean");

    @Override
    protected void _deleteDataLogDateAgo(Context ctx, String date, String tableName) throws BOSException {
        try {
            Date preDate = null;
            if (!StringUtils.isEmpty((CharSequence)date)) {
                preDate = AtsDateUtils.stringToShortDate(date);
            }
            preDate = preDate == null ? AtsDateUtils.getPreDay(new Date(), 90) : AtsDateUtils.getPreDay(preDate, 90);
            if (StringUtils.isEmpty((CharSequence)tableName)) {
                this.deleteDataLog(ctx, preDate);
            } else {
                DataLogService service = this.getLogServiceByTableName(tableName);
                if (service != null) {
                    service.deleteDataLogDateAgo(ctx, preDate);
                }
            }
            AtsCostTimeRelUtils.delCostTimeLog(ctx, preDate);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private DataLogService getLogServiceByTableName(String tableName) {
        if (tableName.equalsIgnoreCase("T_HR_ATS_BILLDATALOG")) {
            return new AtsBillDataLogServiceImpl();
        }
        if (tableName.equalsIgnoreCase("T_HR_ATS_LIMITDATALOG")) {
            return new AtsLimitDataLogServiceImpl();
        }
        if (tableName.equalsIgnoreCase("T_HR_ATS_RESULTDATALOG")) {
            return new AtsResultDataLogServiceImpl();
        }
        if (tableName.equalsIgnoreCase("T_HR_ATS_SUMDATALOG")) {
            return new AtsSumDataLogServiceImpl();
        }
        if (tableName.equalsIgnoreCase("T_HR_ATS_ScheduleShiftDataLog")) {
            return new ScheduleShiftDataLogServiceImpl();
        }
        if (tableName.equalsIgnoreCase("T_HR_ATS_AttendanceLog")) {
            return new AttendanceLogServiceImpl();
        }
        if (tableName.equalsIgnoreCase("T_HR_ATS_AttendanceLogEntry")) {
            return new AttendanceLogEntryServiceImpl();
        }
        if (tableName.equalsIgnoreCase("T_HR_ATS_AtsRuleMatchLog")) {
            return new AtsRuleMatchLogServiceImpl();
        }
        return null;
    }

    private void deleteDataLog(Context ctx, Date preDate) {
        DataLogService service = new AtsLimitDataLogServiceImpl();
        service.deleteDataLogDateAgo(ctx, preDate);
        service = new AtsResultDataLogServiceImpl();
        service.deleteDataLogDateAgo(ctx, preDate);
        service = new AtsSumDataLogServiceImpl();
        service.deleteDataLogDateAgo(ctx, preDate);
        service = new AtsBillDataLogServiceImpl();
        service.deleteDataLogDateAgo(ctx, preDate);
        service = new ScheduleShiftDataLogServiceImpl();
        service.deleteDataLogDateAgo(ctx, preDate);
        service = new AttendanceLogServiceImpl();
        service.deleteDataLogDateAgo(ctx, preDate);
        service = new AttendanceLogEntryServiceImpl();
        service.deleteDataLogDateAgo(ctx, preDate);
        service = new AtsRuleMatchLogServiceImpl();
        service.deleteDataLogDateAgo(ctx, preDate);
    }
}

