/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.hr.ats.app.formula;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.db.TempTablePool;
import com.kingdee.bos.metadata.IMetaDataPK;
import com.kingdee.bos.metadata.MetaDataLoaderFactory;
import com.kingdee.bos.metadata.MetaDataPK;
import com.kingdee.bos.metadata.entity.EntityObjectInfo;
import com.kingdee.bos.metadata.entity.PropertyCollection;
import com.kingdee.bos.metadata.entity.PropertyInfo;
import com.kingdee.eas.basedata.org.AdminOrgUnitFactory;
import com.kingdee.eas.basedata.org.PositionFactory;
import com.kingdee.eas.basedata.person.PersonInfo;
import com.kingdee.eas.hr.ats.AtsCalSumBizException;
import com.kingdee.eas.hr.ats.AtsCommonBizException;
import com.kingdee.eas.hr.ats.AtsCommonResEnum;
import com.kingdee.eas.hr.ats.AtsFormulaBizException;
import com.kingdee.eas.hr.ats.AtsLogicCommonResEnum;
import com.kingdee.eas.hr.ats.AtsOverTimeBillResEnum;
import com.kingdee.eas.hr.ats.AtsScheduleShiftResEnum;
import com.kingdee.eas.hr.ats.AtsShiftResEnum;
import com.kingdee.eas.hr.ats.AtsShiftTypeFactory;
import com.kingdee.eas.hr.ats.AttencePolicyInfo;
import com.kingdee.eas.hr.ats.AttendanceFileInfo;
import com.kingdee.eas.hr.ats.AttendancePeriodInfo;
import com.kingdee.eas.hr.ats.AttendanceProjectCollection;
import com.kingdee.eas.hr.ats.AttendanceProjectFactory;
import com.kingdee.eas.hr.ats.AttendanceProjectInfo;
import com.kingdee.eas.hr.ats.OverTimeCompensFactory;
import com.kingdee.eas.hr.ats.app.formula.IResultCalculator;
import com.kingdee.eas.hr.ats.app.formula.ResultCalFunMgr;
import com.kingdee.eas.hr.ats.app.formula.ResultCalFunction;
import com.kingdee.eas.hr.ats.app.formula.ResultCalculatorMgr;
import com.kingdee.eas.hr.ats.app.formula.calculate.data.ColumnAttributes;
import com.kingdee.eas.hr.ats.app.formula.calculate.data.CommonMethod;
import com.kingdee.eas.hr.ats.app.formula.calculate.data.DAFactory;
import com.kingdee.eas.hr.ats.app.formula.calculate.data.DataAccess;
import com.kingdee.eas.hr.ats.app.formula.calculate.data.DataRow;
import com.kingdee.eas.hr.ats.app.formula.calculate.data.DataSet;
import com.kingdee.eas.hr.ats.app.formula.calculate.data.DataTable;
import com.kingdee.eas.hr.ats.app.formula.calculate.data.DataTypes;
import com.kingdee.eas.hr.ats.app.formula.calculate.data.Tools;
import com.kingdee.eas.hr.ats.biz.util.AttendanceSelfDefinedUtil;
import com.kingdee.eas.hr.ats.calcutePrepareData.AtsBatchBillDataCache;
import com.kingdee.eas.hr.ats.calcutePrepareData.AtsBatchPrepareDataCache;
import com.kingdee.eas.hr.ats.calcutePrepareData.AtsGlobalDataCache;
import com.kingdee.eas.hr.ats.decimalPlace.util.DecimalPlaceUtil;
import com.kingdee.eas.hr.ats.util.AtsAttenceTableServerUtil;
import com.kingdee.eas.hr.ats.util.AtsDateUtils;
import com.kingdee.eas.hr.ats.util.AtsScheduleShiftUtil;
import com.kingdee.eas.hr.ats.util.AtsServerCalUtils;
import com.kingdee.eas.hr.ats.util.SQLGenerate;
import com.kingdee.eas.hr.ats.util.common.AtsCollectionUtile;
import com.kingdee.eas.hr.ats.util.common.MLUtile;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.shr.baseconfig.StructureConfigFilterColumnCollection;
import com.kingdee.shr.baseconfig.StructureConfigFilterColumnFactory;
import com.kingdee.shr.baseconfig.StructureConfigInfo;
import com.kingdee.shr.compensation.CalSchemeInfo;
import com.kingdee.shr.compensation.CmpItemCollection;
import com.kingdee.shr.compensation.CmpItemDataType;
import com.kingdee.shr.compensation.CmpItemFactory;
import com.kingdee.shr.compensation.CmpItemInfo;
import com.kingdee.shr.compensation.CmpQueryConfigCollection;
import com.kingdee.shr.compensation.CmpQueryConfigFactory;
import com.kingdee.shr.compensation.app.formula.common.FunctionTools;
import com.kingdee.shr.compensation.secret.SecretUtil;
import com.kingdee.util.StringUtils;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import org.json.JSONArray;
import org.json.JSONObject;

public class ResultCalculator
implements IResultCalculator {
    private int precision = 2;
    private final String mainTableItemKey = "fid";
    private final String mainTableForeignKey = "FProposerID";
    private String mainTableName = "T_HR_ATS_AttendanceResult";
    private final String uid = CommonMethod.getRandomGUID();
    private Context ctx;
    private IRowSet result;
    private String schemeID;
    private String tempTable;
    private String condition;
    private String calFormulas;
    private String calculateStatus;
    private String calFromDate;
    private String calToDate;
    private String month;
    private int status = 0;
    private int finishedPer = 0;
    long estimateTime = 120000L;
    private String calCurrentStrDate = null;
    private int dataSegment = 1;
    private static String atsShiftFlag = null;
    private static String overTimeCompensFlag = null;

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public Map<String, String> combineTableItems(IRowSet da) {
        if (this.finishedPer < 5) {
            this.finishedPer = 5;
        }
        HashMap<String, String> assTable = new HashMap<String, String>();
        try {
            String[] item = null;
            String[] items = null;
            String clm = null;
            String listItems = null;
            String content = null;
            while (da.next()) {
                listItems = da.getString("FListItem");
                if (listItems == null || "".equals(listItems)) continue;
                items = listItems.split(";");
                for (int loop = 0; loop < items.length; ++loop) {
                    String specialKey;
                    item = items[loop].split("~");
                    if (item[1].startsWith("TEMP")) continue;
                    if ("T_HR_ATS_Shift".equalsIgnoreCase(item[1])) {
                        content = da.getString("FContent");
                        atsShiftFlag = content != null && (content.indexOf("[" + MLUtile.getRes(AtsShiftResEnum.ShiftCode, this.ctx) + "]") > 0 || content.indexOf("[" + MLUtile.getRes(AtsShiftResEnum.ShiftName, this.ctx) + "]") > 0 || content.indexOf("[" + MLUtile.getRes(AtsShiftResEnum.ShiftType, this.ctx) + "]") > 0 || content.indexOf("[" + MLUtile.getRes(AtsOverTimeBillResEnum.OTCompens, this.ctx) + "]") > 0) ? "1" : "2";
                    }
                    if ("T_HR_ATS_OverTimeCompens".equalsIgnoreCase(item[1])) {
                        content = da.getString("FContent");
                        overTimeCompensFlag = content != null && content.indexOf("[" + MLUtile.getRes(AtsScheduleShiftResEnum.ScheduleShift, this.ctx)) > -1 ? "1" : "2";
                    }
                    if (assTable.containsKey(specialKey = item[1])) {
                        String columns = (String)assTable.get(specialKey) + ",";
                        if (columns.indexOf(clm = item[1] + "." + item[2] + ",") != -1) continue;
                        columns = columns.substring(0, columns.length() - 1) + ", " + clm.substring(0, clm.length() - 1);
                        assTable.put(specialKey, columns);
                        continue;
                    }
                    if (AtsAttenceTableServerUtil.SpecialTableColunm.isEmpty()) {
                        AtsAttenceTableServerUtil.initStaticTableEnum();
                    }
                    if (AtsAttenceTableServerUtil.SpecialTableColunm.containsKey(item[1].toLowerCase())) {
                        String sKey = item[1] + "_" + item[3];
                        if (assTable.containsKey(sKey)) {
                            String columns = (String)assTable.get(sKey) + ",";
                            if (columns.indexOf(clm = item[1] + "." + item[2] + "." + item[3] + ",") != -1) continue;
                            columns = columns.substring(0, columns.length() - 1) + "," + clm.substring(0, clm.length() - 1);
                            assTable.put(sKey, columns);
                            continue;
                        }
                        assTable.put(item[1] + "_" + item[3], item[1] + "." + item[2] + "." + item[3]);
                        continue;
                    }
                    assTable.put(item[1], item[1] + "." + item[2]);
                }
            }
            if (!assTable.keySet().isEmpty()) return assTable;
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return assTable;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public Map<String, String> getColumnType(IRowSet da) {
        HashMap<String, String> columnType = new HashMap<String, String>();
        try {
            String[] item = null;
            String[] items = null;
            String listItems = null;
            da.beforeFirst();
            while (da.next()) {
                listItems = da.getString("FListItem");
                if (listItems == null || "".equals(listItems)) continue;
                items = listItems.split(";");
                for (int loop = 0; loop < items.length; ++loop) {
                    item = items[loop].split("~");
                    if (item[1].startsWith("TEMP")) continue;
                    String columnKey = item[1] + "_" + item[2];
                    if (AtsAttenceTableServerUtil.SpecialTableColunm.isEmpty()) {
                        AtsAttenceTableServerUtil.initStaticTableEnum();
                    }
                    if (AtsAttenceTableServerUtil.SpecialTableColunm.containsKey(item[1].toLowerCase())) {
                        columnKey = item[1] + "_" + item[2] + "_" + item[3];
                    }
                    columnType.put(columnKey, item[0]);
                }
            }
            if (!columnType.keySet().isEmpty()) return columnType;
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return columnType;
    }

    public void destroyed() {
        if (this.getTempTable() != null) {
            TempTablePool.getInstance((Context)this.ctx).releaseTable(this.getTempTable());
        }
    }

    void estimateTime(int recordCount) {
        this.estimateTime = recordCount < 100 ? 120000L : (recordCount < 500 ? 180000L : (recordCount < 1000 ? 300000L : (recordCount < 5000 ? 600000L : (recordCount < 10000 ? 1200000L : 2400000L))));
    }

    public List<Integer> execCalculate(CalSchemeInfo calScheme, ResultCalFunction calObj, DataSet dataSet, Set secColSet) throws Exception {
        if (this.finishedPer < 20) {
            this.finishedPer = 20;
        }
        this.estimateTime(dataSet.getTables(this.mainTableName).rowCount());
        DataTable mainTable = dataSet.getTables(this.mainTableName);
        StringBuffer rowFilter = new StringBuffer();
        HashMap<String, Object> paras = new HashMap<String, Object>();
        ArrayList<Integer> changeIndex = new ArrayList<Integer>();
        calObj.setCalDate(this.month);
        calObj.setSchemeID(this.schemeID);
        calObj.setPrecision(this.precision);
        calObj.setCalScheme(calScheme);
        calObj.setMainTableRowFilter(this.condition);
        String caltableid = null;
        Object personid = null;
        for (int index = 0; index < mainTable.rowCount(); ++index) {
            ColumnAttributes att;
            int loop;
            rowFilter.setLength(0);
            paras.clear();
            DataRow rw = mainTable.getRows(index);
            for (loop = 0; loop < rw.columnCount(); ++loop) {
                att = rw.getColumns(loop);
                if (att.getName().equalsIgnoreCase("fid")) {
                    rowFilter.append("fid");
                    rowFilter.append("='");
                    rowFilter.append(rw.getValue(loop));
                    rowFilter.append("'");
                }
                if (rw.getValue(loop) != null && secColSet.contains(att.getName().toUpperCase())) {
                    BigDecimal val = SecretUtil.decode((Context)this.ctx, (BigDecimal)((BigDecimal)rw.getValue(loop)), (String)rw.getString("FProposerID"));
                    paras.put((this.mainTableName + "_" + att.getName()).toUpperCase(), val);
                    rw.setValue(loop, (Object)val);
                    continue;
                }
                paras.put((this.mainTableName + "_" + att.getName()).toUpperCase(), rw.getValue(loop));
            }
            for (loop = 0; loop < dataSet.tableCount(); ++loop) {
                DataRow[] data;
                DataTable tb = dataSet.getTables(loop);
                if (this.mainTableName.equals(tb.tablename) || (data = tb.getDataRow(caltableid)) == null || data.length <= 0 || null == data[0]) continue;
                for (int i = 0; i < data[0].columnCount(); ++i) {
                    att = data[0].getColumns(i);
                    Object value = data[0].getValue(i);
                    if ("FGENDER".equalsIgnoreCase(att.getName()) && value != null) {
                        if (value instanceof BigDecimal) {
                            value = ((BigDecimal)value).intValue();
                        }
                        value = !StringUtils.isEmpty((String)String.valueOf(value)) && "1".equalsIgnoreCase(String.valueOf(value)) ? MLUtile.getRes(AtsLogicCommonResEnum.Male, this.ctx) : MLUtile.getRes(AtsLogicCommonResEnum.Female, this.ctx);
                    }
                    paras.put((tb.tablename + "_" + att.getName()).toUpperCase(), value);
                }
            }
            try {
                calObj.setParamMap(paras);
                calObj.getClass().getMethod("calculate", HashMap.class).invoke((Object)calObj, paras);
            }
            catch (Exception e) {
                e.printStackTrace();
                throw new RuntimeException((Throwable)((Object)new AtsCalSumBizException(AtsCalSumBizException.FAILECAL, new Object[]{paras, e.getMessage()})));
            }
            if (!this.hasChanged(rw, paras)) continue;
            changeIndex.add(index);
        }
        return changeIndex;
    }

    public List<Integer> execAtsCalculate(ResultCalFunction calObj, DataSet dataSet, Set secColSet, int simulation, Map<Object, Object> globalMap) {
        DataTable mainTable = dataSet.getTables(this.mainTableName);
        StringBuffer rowFilter = new StringBuffer();
        HashMap<String, Object> paras = new HashMap<String, Object>();
        ArrayList<Integer> changeIndex = new ArrayList<Integer>();
        calObj.setCalDate(this.month);
        calObj.setSchemeID(this.schemeID);
        calObj.setPrecision(this.precision);
        calObj.setMainTableRowFilter(this.condition);
        String caltableid = null;
        String personid = null;
        try {
            for (int index = 0; index < mainTable.rowCount(); ++index) {
                ColumnAttributes att;
                int loop;
                String hasChangeExceptionColName = "";
                rowFilter.setLength(0);
                paras.clear();
                DataRow rw = mainTable.getRows(index);
                for (loop = 0; loop < rw.columnCount(); ++loop) {
                    att = rw.getColumns(loop);
                    if (att.getName().equalsIgnoreCase("fid")) {
                        caltableid = (String)rw.getValue(loop);
                    }
                    if (att.getName().equalsIgnoreCase("FProposerID")) {
                        personid = (String)rw.getValue(loop);
                    }
                    if ("FATTENCEDATE".equalsIgnoreCase(att.getName())) {
                        String datestr = "";
                        if (att.getType() == DataTypes.DATE) {
                            datestr = (String)rw.getValue(loop);
                            calObj.setCalDate(datestr);
                        }
                        paras.put((this.mainTableName + "_" + att.getName()).toUpperCase(), datestr);
                        continue;
                    }
                    paras.put((this.mainTableName + "_" + att.getName()).toUpperCase(), rw.getValue(loop));
                }
                for (loop = 0; loop < dataSet.tableCount(); ++loop) {
                    DataRow[] data;
                    DataTable tb = dataSet.getTables(loop);
                    if (this.mainTableName.equals(tb.tablename)) continue;
                    String dataRowID = caltableid;
                    if (simulation == 1) {
                        dataRowID = personid;
                    }
                    if ((data = tb.getDataRow(dataRowID)) == null || data.length <= 0 || null == data[0]) continue;
                    for (int i = 0; i < data[0].columnCount(); ++i) {
                        att = data[0].getColumns(i);
                        Object value = data[0].getValue(i);
                        String tableName = tb.tablename;
                        String tableAndColumn = tb.tablename + "_" + att.getName();
                        tableAndColumn = tableAndColumn.toUpperCase();
                        if (AtsAttenceTableServerUtil.AllATTENDANCETTableNames.isEmpty()) {
                            AtsAttenceTableServerUtil.initStaticTableEnum();
                        }
                        if (AtsAttenceTableServerUtil.AllATTENDANCETTableNames.contains(tableName)) {
                            String removeDataSegColumn = tableAndColumn.replaceAll("[^A-Z][_0-9]", "");
                            Map<String, String> treeMap = AtsAttenceTableServerUtil.SpecialTableMenu.get(removeDataSegColumn);
                            if (value != null && treeMap != null && treeMap.containsKey(value.toString())) {
                                value = treeMap.get(value.toString());
                            }
                        } else if ("FGENDER".equalsIgnoreCase(att.getName()) && value != null) {
                            if (value instanceof BigDecimal) {
                                value = ((BigDecimal)value).intValue();
                            }
                            value = !StringUtils.isEmpty((String)String.valueOf(value)) && "1".equalsIgnoreCase(String.valueOf(value)) ? MLUtile.getRes(AtsLogicCommonResEnum.Male, this.ctx) : MLUtile.getRes(AtsLogicCommonResEnum.Female, this.ctx);
                        }
                        paras.put(tableAndColumn, value);
                    }
                }
                boolean isEnterException = false;
                try {
                    paras.put("T_HR_ATS_ATTENDANCERESULT_FATTENCEDATE", globalMap.get("T_HR_ATS_ATTENDANCERESULT_FATTENCEDATE"));
                    paras.put("T_HR_ATS_ATTENDANCERESULT_FPROPOSERID", globalMap.get("T_HR_ATS_ATTENDANCERESULT_FPROPOSERID"));
                    paras.put("globalMapKey", globalMap);
                    paras.put("runAtWhere", "");
                    paras.put("successCount", "0.0");
                    calObj.setParamMap(paras);
                    calObj.getClass().getMethod("calculate", HashMap.class).invoke((Object)calObj, paras);
                }
                catch (Exception e) {
                    isEnterException = true;
                    e.printStackTrace();
                    String errorMsg = (String)paras.get("runAtWhere");
                    throw new RuntimeException((Throwable)((Object)new AtsCalSumBizException(AtsCalSumBizException.FAILECAL, new Object[]{"", e.getMessage()})));
                }
                if (!this.hasChanged(rw, paras)) continue;
                changeIndex.add(index);
            }
            paras.clear();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return changeIndex;
    }

    public int getFinishedPer() {
        if (this.finishedPer >= 99) {
            this.finishedPer = 99;
        }
        return this.finishedPer;
    }

    public IRowSet getResult() {
        return this.result;
    }

    @Override
    public int getStatus() {
        return this.status;
    }

    public String getTempTable() {
        return this.tempTable;
    }

    @Override
    public String getUID() {
        return this.uid;
    }

    private boolean hasChanged(DataRow rw, Map paras) {
        Map globalMap = (Map)paras.get("globalMapKey");
        int decimalPlace = DecimalPlaceUtil.getDecimalPlace(this.ctx, globalMap);
        boolean changed = false;
        for (int index = 0; index < rw.columnCount(); ++index) {
            ColumnAttributes att = rw.getColumns(index);
            String paraName = (this.mainTableName + "_" + att.getName()).toUpperCase();
            Object originValue = rw.getValue(index);
            Object calValue = paras.get(paraName);
            if (originValue == null && calValue == null || originValue instanceof Number && calValue instanceof Number && originValue instanceof Number && originValue != null && calValue != null && ((Number)originValue).doubleValue() == ((Number)calValue).doubleValue() || originValue instanceof String && originValue != null && originValue.equals(calValue) || originValue instanceof Timestamp && originValue != null && paras.get(paraName) instanceof String && AtsDateUtils.stringShortToTimestamp(paras.get(paraName).toString()).getTime() == ((Timestamp)originValue).getTime()) continue;
            changed = true;
            if (calValue instanceof Number) {
                rw.setValue(index, (Object)DecimalPlaceUtil.decimalPlaceCtrl(this.ctx, new BigDecimal(calValue.toString()), decimalPlace, RoundingMode.HALF_UP));
                continue;
            }
            rw.setValue(index, calValue);
        }
        return changed;
    }

    public DataSet initCalData(IRowSet da, Map<String, String> assTable, Map<Object, Object> globalMap, String policyPersonResultIds) {
        String[] policyPersonResultIdsArr = policyPersonResultIds.split("_");
        DataSet dataSet = new DataSet();
        try {
            Iterator<String> iter = assTable.keySet().iterator();
            DataAccess DAC = DAFactory.getDataAccess();
            SQLGenerate sqlgen = new SQLGenerate();
            sqlgen.fromTime = this.calFromDate;
            sqlgen.toTime = this.calToDate;
            sqlgen.isShowCodeText = false;
            String sq = null;
            DataTable dt = null;
            while (iter.hasNext()) {
                String tableName = iter.next();
                String columns = assTable.get(tableName);
                if (AtsAttenceTableServerUtil.SpecialTableColunm.isEmpty()) {
                    AtsAttenceTableServerUtil.initStaticTableEnum();
                }
                for (String specialTable : AtsAttenceTableServerUtil.SpecialTableColunm.keySet()) {
                    if (!tableName.toLowerCase(Locale.getDefault()).startsWith(specialTable)) continue;
                    String[] cols = columns.split(",");
                    String tempColumn = "";
                    for (int i = 0; i < cols.length; ++i) {
                        String[] columnComs = cols[i].split("\\.");
                        if (columnComs.length != 3) continue;
                        tempColumn = tempColumn + columnComs[0] + "." + columnComs[1] + " as " + columnComs[1] + "_" + columnComs[2];
                        if (i != cols.length - 1) {
                            tempColumn = tempColumn + ",";
                        }
                        if (i != 0) continue;
                        tableName = columnComs[0];
                        this.setDataSegment(Integer.parseInt(columnComs[2]));
                    }
                    columns = tempColumn;
                    break;
                }
                if (columns.indexOf(this.mainTableName + "." + "fid") == -1) {
                    columns = this.mainTableName + "." + "fid" + ", " + this.mainTableName + "." + "FProposerID" + ", " + columns;
                }
                if (!"T_HR_ATS_AttendanceResultSum".equalsIgnoreCase(this.mainTableName)) {
                    columns = columns + "," + this.mainTableName + ".FAttenceDate";
                }
                SQLGenerate sqlGe = new SQLGenerate();
                String mainTable = this.mainTableName;
                String oldTableName = tableName;
                if (overTimeCompensFlag != null && !"".equals(overTimeCompensFlag)) {
                    tableName = tableName + "%" + overTimeCompensFlag;
                }
                if (atsShiftFlag != null && !"".equals(atsShiftFlag)) {
                    tableName = tableName + "%" + atsShiftFlag;
                }
                sq = sqlGe.combineInfosetSql(mainTable, tableName, columns, this.condition, this.dataSegment, this.calCurrentStrDate);
                this.setDataSegment(1);
                if (overTimeCompensFlag != null && !"".equals(overTimeCompensFlag) || atsShiftFlag != null && !"".equals(atsShiftFlag)) {
                    tableName = oldTableName;
                }
                try {
                    dt = DAC.getDataTable(sq, tableName);
                    if (dt == null) continue;
                    dataSet.addTable(dt);
                }
                catch (Exception e) {
                    e.printStackTrace();
                    throw new RuntimeException((Throwable)((Object)new AtsFormulaBizException(AtsFormulaBizException.PREPAREDATAERRORANDCHECK, new Object[]{sq, e.getMessage()})));
                }
            }
            assTable.clear();
            da.beforeFirst();
            String listItems = null;
            String[] item = null;
            String[] items = null;
            StringBuffer sb = new StringBuffer();
            while (da.next()) {
                listItems = da.getString("FListTable");
                if (listItems == null || "".equals(listItems)) continue;
                items = listItems.split(";");
                for (int loop = 0; loop < items.length; ++loop) {
                    item = items[loop].split("~");
                    String id = "'" + item[1] + "'";
                    if (sb.indexOf(id) != -1) continue;
                    if (sb.length() > 0) {
                        sb.append(",");
                    }
                    sb.append(id);
                }
            }
            if (sb.length() > 0) {
                sb.insert(0, "SELECT FDefine, FSqls, FPeriodFrom, FPeriodTo FROM T_HR_SFormulaTmpTable WHERE fid IN (");
                sb.append(")");
                dt = DAC.getDataTable(sb.toString(), "T_HR_SFormulaTmpTable");
                DataRow[] rows = dt.getAllRows();
                StringBuffer tableName = new StringBuffer();
                for (int index = 0; index < rows.length; ++index) {
                    sb.delete(0, sb.length());
                    sb.append(rows[index].getString("FSqls"));
                    if (sb.toString().toUpperCase().indexOf("WHERE") == -1) {
                        int insertIndex = sb.indexOf("GROUP BY") > -1 ? sb.indexOf("GROUP BY") : (sb.indexOf("ORDER BY") > -1 ? sb.indexOf("ORDER BY") : sb.length());
                        sb.insert(insertIndex, " WHERE 1 = 1 ");
                    }
                    tableName.delete(0, tableName.length());
                    int i = sb.toString().toUpperCase().indexOf("FROM ") + 5;
                    while (sb.charAt(i) != ' ' && sb.charAt(i) != '\r' && sb.charAt(i) != '\t') {
                        tableName.append(sb.charAt(i));
                        ++i;
                    }
                    sb.insert(sb.toString().toUpperCase().indexOf("WHERE") + 6, " (" + this.condition + ") AND ");
                    sq = sb.toString().replaceAll("@YEARFROM", FunctionTools.adustStringDate((String)this.calToDate, (int)rows[index].getInt("FPeriodFrom"), (String)"@YEARFROM")).replaceAll("@MONTHFROM", FunctionTools.adustStringDate((String)this.calToDate, (int)rows[index].getInt("FPeriodFrom"), (String)"@MONTHFROM")).replaceAll("@YEARTO", FunctionTools.adustStringDate((String)this.calToDate, (int)rows[index].getInt("FPeriodTo"), (String)"@YEARTO")).replaceAll("@MONTHTO", FunctionTools.adustStringDate((String)this.calToDate, (int)rows[index].getInt("FPeriodTo"), (String)"@MONTHTO"));
                    sb.delete(0, sb.length());
                    try {
                        DataTable dt1 = DAC.getDataTable(sq, rows[index].getString("FDefine"));
                        if (dt1 == null) continue;
                        dataSet.addTable(dt1);
                        continue;
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                        throw new RuntimeException((Throwable)((Object)new AtsCommonBizException(AtsCommonBizException.TEMPTABLEERRORWITHSQL, new Object[]{sq, e.getMessage()})));
                    }
                }
            }
            if (dataSet.tableCount() == 0 || !dataSet.isExistedTable(this.mainTableName)) {
                // empty if block
            }
            this.addHrDataSet(globalMap, policyPersonResultIdsArr, dataSet);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return dataSet;
    }

    private void addHrDataSet(Map<Object, Object> globalMap, String[] policyPersonResultIdsArr, DataSet dataSet) {
        String preDay = AtsDateUtils.dateShortFormatToStr(AtsDateUtils.getPreDay(new Date()));
        Map personDataMap = (Map)globalMap.get("personDataMap");
        if (null != personDataMap) {
            List dtList = (List)personDataMap.get(policyPersonResultIdsArr[1] + "_" + preDay);
            if (null != dtList && dtList.size() > 0) {
                dtList = (List)personDataMap.get(policyPersonResultIdsArr[1] + "_" + preDay);
            }
            if (null != dtList && dtList.size() > 0) {
                for (int i = 0; i < dtList.size(); ++i) {
                    if (null == dtList.get(i) || ((DataTable)dtList.get((int)i)).datas == null || ((DataTable)dtList.get((int)i)).datas.size() <= 0) continue;
                    ArrayList row = (ArrayList)((DataTable)dtList.get((int)i)).datas.get(0);
                    if (null != row && row.size() == 2) {
                        ((DataTable)dtList.get(i)).deleteColumn(row.size() - 1);
                    }
                    this.addColumnToDt((DataTable)dtList.get(i), policyPersonResultIdsArr[2]);
                    if (null == dtList.get(i)) continue;
                    dataSet.addTable((DataTable)dtList.get(i));
                }
            }
        }
    }

    public String combineInfosetSql(String mainTable, String tableName, String fieldStr, String whereStr) throws BOSException {
        String oql = "select structure.EntityName,structure.parent.*,structure.parent.filterColumn.*,structure.parent.parent.*,structure.parent.parent.parent.*,structure.parent.parent.parent.parent.*,structure.parent.parent.parent.parent.parent.*,structure.filterColumn.* where tableName = '" + tableName + "'";
        CmpQueryConfigCollection configs = CmpQueryConfigFactory.getLocalInstance((Context)this.ctx).getCmpQueryConfigCollection(oql);
        StringBuffer sql = new StringBuffer();
        sql.append("select " + fieldStr + " from " + mainTable);
        this.combineRecurseSql(mainTable, configs.size() == 0 ? null : configs.get(0).getStructure(), sql);
        sql.append(" where " + whereStr);
        return sql.toString();
    }

    private void combineRecurseSql(String mainTable, StructureConfigInfo config, StringBuffer sql) throws BOSException {
        if (config == null) {
            return;
        }
        if (config.getParent() != null) {
            this.combineRecurseSql(mainTable, config.getParent(), sql);
        }
        String oql = "where parent1.id = '" + config.getId().toString() + "'";
        StructureConfigFilterColumnCollection filters = StructureConfigFilterColumnFactory.getLocalInstance((Context)this.ctx).getStructureConfigFilterColumnCollection(oql);
        String entityName = null;
        String parentEntityName = null;
        String tableName = null;
        String parentTableName = null;
        entityName = config.getEntityName();
        tableName = this.getEntityTableName(entityName);
        if (config.getParent() != null) {
            parentEntityName = config.getParent().getEntityName();
            parentTableName = this.getEntityTableName(parentEntityName);
        }
        if (filters != null && filters.size() > 0) {
            sql.append(" left join " + tableName + " on ");
            for (int i = 0; i < filters.size(); ++i) {
                if (i != 0) {
                    sql.append(" and ");
                }
                sql.append(tableName + "." + this.getEntityFieldName(entityName, filters.get(i).getClientColumn()));
                sql.append(" = ");
                if (StringUtils.isEmpty((String)parentTableName)) {
                    sql.append(mainTable + ".FProposerID");
                    continue;
                }
                sql.append(parentTableName + "." + this.getEntityFieldName(parentEntityName, filters.get(i).getParentColumn()));
            }
        }
    }

    private String getEntityTableName(String entityName) {
        EntityObjectInfo entityInfo = MetaDataLoaderFactory.getLocalMetaDataLoader((Context)this.ctx).getEntity((IMetaDataPK)new MetaDataPK(entityName));
        return entityInfo.getTable().getName();
    }

    private String getEntityFieldName(String entityName, String fieldName) {
        EntityObjectInfo entityInfo = MetaDataLoaderFactory.getLocalMetaDataLoader((Context)this.ctx).getEntity((IMetaDataPK)new MetaDataPK(entityName));
        PropertyInfo propertyInfo = null;
        PropertyCollection collection = entityInfo.getInheritedNoDuplicatedProperties();
        int size = collection.size();
        for (int i = 0; i < size && !fieldName.equals((propertyInfo = collection.get(i)).getName()); ++i) {
        }
        if (propertyInfo == null) {
            return null;
        }
        if ("name".equals(propertyInfo.getName())) {
            return "FName" + MLUtile.getMlFlag(this.ctx);
        }
        if ("description".equals(propertyInfo.getName())) {
            return "FDescription" + MLUtile.getMlFlag(this.ctx);
        }
        return propertyInfo.getMappingField().getName();
    }

    public ResultCalFunction initCalInstance(Context ctx, IRowSet da) {
        ResultCalFunction calObj = null;
        try {
            ResultCalFunMgr mgr = new ResultCalFunMgr();
            calObj = mgr.getInstance3(ctx, da);
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new RuntimeException(e.getMessage());
        }
        if (calObj == null) {
            throw new RuntimeException((Throwable)((Object)new AtsFormulaBizException(AtsFormulaBizException.SETERROR)));
        }
        return calObj;
    }

    public Set initSecureCol() throws Exception {
        String sql = "select id, fieldSn, dataType where state = 1";
        CmpItemCollection cmpItemColl = CmpItemFactory.getLocalInstance((Context)this.ctx).getCmpItemCollection(sql);
        CmpItemInfo cmpItemInfo = null;
        CmpItemDataType dataType = null;
        HashSet<String> set = new HashSet<String>();
        for (int i = 0; i < cmpItemColl.size(); ++i) {
            cmpItemInfo = cmpItemColl.get(i);
            dataType = cmpItemInfo.getDataType();
            if (CmpItemDataType.NUMBER.getValue() != dataType.getValue()) continue;
            set.add("S" + cmpItemInfo.getFieldSn());
        }
        return set;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void parentRun(Context ctx, String attendPolicyid, PersonInfo personInfo, Map<Object, Object> globalMap) throws BOSException {
        this.ctx = ctx;
        Tools.getInstance().setCtx(ctx);
        int decimalPlaces = DecimalPlaceUtil.getDecimalPlaces(ctx, globalMap);
        String info = MLUtile.getRes(AtsCommonResEnum.ComputeAndSaveDateSucc, ctx);
        String policyPersonResultIds = attendPolicyid + "_" + personInfo.getId().toString() + "_" + "";
        try {
            IRowSet da = this.getSchemeFormulas(attendPolicyid);
            if (da != null && da.size() > 0) {
                Map<String, String> assTable = this.combineTableItems(da);
                ResultCalFunction calObj = this.initCalInstance(ctx, da);
                DataSet dataSet = this.initCalData(da, assTable, globalMap, policyPersonResultIds);
                HashSet secColSet = new HashSet();
                List<Integer> changeIndex = this.execAtsCalculate(calObj, dataSet, secColSet, 2, globalMap);
                this.saveCalResult(changeIndex, dataSet, secColSet, decimalPlaces);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            info = e.getMessage();
        }
        finally {
            this.destroyed();
            ResultCalculatorMgr.removeTask(this.getUID(), info);
        }
    }

    public void saveCalResult(List<Integer> changeIndex, DataSet dataSet, Set secColSet, int decimalPlaces) {
        if (changeIndex.size() == 0) {
            // empty if block
        }
        try {
            ArrayList<String> sqls = new ArrayList<String>();
            StringBuffer sb = new StringBuffer();
            DataTable mainTable = dataSet.getTables(this.mainTableName);
            for (int index = 0; index < changeIndex.size(); ++index) {
                int i = changeIndex.get(index);
                DataRow rw = mainTable.getRows(i);
                sb.delete(0, sb.length());
                sb.append("UPDATE ");
                sb.append(this.mainTableName);
                sb.append(" SET ");
                if (this.calculateStatus != null && !"".equals(this.calculateStatus)) {
                    sb.append(this.calculateStatus);
                    sb.append(",");
                }
                String attenceDateStr = "";
                if (!"T_HR_ATS_AttendanceResultSum".equalsIgnoreCase(this.mainTableName)) {
                    int attenceDateIndex = rw.getColumns("FATTENCEDATE").getIndex();
                    attenceDateStr = rw.getValue(attenceDateIndex).toString();
                }
                for (int loop = 0; loop < rw.columnCount(); ++loop) {
                    String value;
                    ColumnAttributes att = rw.getColumns(loop);
                    if (att.getType() == DataTypes.FLOAT || att.getType() == DataTypes.INTEGER) {
                        sb.append(att.getName());
                        sb.append("=");
                        BigDecimal ret = BigDecimal.valueOf(0L);
                        Object ovalue = rw.getValue(loop);
                        if (ovalue != null) {
                            if (ovalue instanceof BigDecimal) {
                                ret = ((BigDecimal)ovalue).setScale(decimalPlaces, RoundingMode.HALF_UP);
                            } else if (ovalue instanceof String) {
                                if (ovalue instanceof Number) {
                                    ret = new BigDecimal((String)ovalue);
                                }
                            } else if (ovalue instanceof Integer) {
                                ret = new BigDecimal((Integer)ovalue);
                            } else if (ovalue instanceof Number) {
                                ret = BigDecimal.valueOf(((Number)ovalue).doubleValue());
                            } else {
                                throw new ClassCastException("Not possible to coerce [" + ovalue + "] from class " + ovalue.getClass() + " into a BigDecimal.");
                            }
                        }
                        BigDecimal value2 = ret;
                        if (rw.getValue(loop) != null && secColSet.contains(att.getName().toUpperCase())) {
                            sb.append(SecretUtil.encode((Context)this.ctx, (BigDecimal)value2, (String)rw.getString("FProposerID")).toPlainString());
                        } else if (rw.getValue(loop) == null) {
                            sb.append(new BigDecimal(0));
                        } else {
                            sb.append(value2);
                        }
                        sb.append(",");
                        continue;
                    }
                    if (att.getType() == DataTypes.STRING) {
                        if ("FID".equalsIgnoreCase(att.getName()) || "FPROPOSERID".equalsIgnoreCase(att.getName())) continue;
                        sb.append(att.getName());
                        sb.append("='");
                        sb.append(rw.getValue(loop) == null ? "" : rw.getValue(loop));
                        sb.append("',");
                        continue;
                    }
                    if (att.getType() != DataTypes.DATE || "FATTENCEDATE".equalsIgnoreCase(att.getName())) continue;
                    String string = value = rw.getValue(loop) == null ? "" : rw.getValue(loop).toString();
                    if (value.indexOf(":") == -1 || value.indexOf("-") != -1 && value.indexOf("/") != -1 || value.length() >= 10 || "T_HR_ATS_AttendanceResultSum".equalsIgnoreCase(this.mainTableName)) continue;
                    String timeValue = value.indexOf(".") != -1 ? value.substring(0, value.indexOf(".")) : value;
                    timeValue = timeValue.length() == 5 ? timeValue + ":00" : timeValue;
                    value = attenceDateStr.substring(0, 10) + " " + timeValue;
                    value = "{ts '" + value + "'}";
                    sb.append(att.getName());
                    sb.append("=");
                    sb.append(value);
                    sb.append(",");
                }
                sb.delete(sb.length() - 1, sb.length());
                sb.append(" WHERE ");
                if (this.condition != null) {
                    sb.append(this.condition);
                }
                sqls.add(sb.toString());
            }
            if (sqls.size() > 0) {
                DataAccess DAC = DAFactory.getDataAccess();
                DAC.executeBatch(sqls);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new RuntimeException((Throwable)((Object)new AtsCalSumBizException(AtsCalSumBizException.FAILSAVE, new Object[]{e.getMessage()})));
        }
    }

    public void saveAtsCalResult(List<Integer> changeIndex, DataSet dataSet, Set secColSet) throws Exception {
        if (changeIndex.size() == 0) {
            throw new RuntimeException((Throwable)((Object)new AtsCalSumBizException(AtsCalSumBizException.SUCCESSCALNOCHANGE)));
        }
        ArrayList<String> sqls = new ArrayList<String>();
        StringBuffer sb = new StringBuffer();
        DataTable mainTable = dataSet.getTables(this.mainTableName);
        for (int index = 0; index < changeIndex.size(); ++index) {
            int i = changeIndex.get(index);
            DataRow rw = mainTable.getRows(i);
            sb.delete(0, sb.length());
            sb.append("UPDATE ");
            sb.append(this.mainTableName);
            sb.append(" SET ");
            if (this.calculateStatus != null && !"".equals(this.calculateStatus)) {
                sb.append(this.calculateStatus);
                sb.append(",");
            }
            for (int loop = 0; loop < rw.columnCount(); ++loop) {
                ColumnAttributes att = rw.getColumns(loop);
                if (att.getType() == DataTypes.FLOAT || att.getType() == DataTypes.INTEGER) {
                    sb.append(att.getName());
                    sb.append("=");
                    BigDecimal value = (BigDecimal)rw.getValue(loop);
                    if (rw.getValue(loop) != null && secColSet.contains(att.getName().toUpperCase())) {
                        sb.append(SecretUtil.encode((Context)this.ctx, (BigDecimal)value, (String)rw.getString("FProposerID")).toPlainString());
                    } else if (rw.getValue(loop) == null) {
                        sb.append(new BigDecimal(0));
                    } else {
                        sb.append(new BigDecimal(0));
                    }
                    sb.append(",");
                    continue;
                }
                if (att.getType() != DataTypes.STRING) continue;
                sb.append(att.getName());
                sb.append("='");
                sb.append(rw.getValue(loop) == null ? "" : rw.getValue(loop));
                sb.append("',");
            }
            sb.delete(sb.length() - 1, sb.length());
            sb.append(" WHERE ");
            sb.append(this.mainTableName);
            sb.append(".");
            sb.append("fid");
            sb.append("='");
            sb.append(rw.getString("fid"));
            sb.append("'");
            if (this.condition != null) {
                sb.append(" AND ");
                sb.append(this.condition);
            }
            sqls.add(sb.toString());
        }
        if (this.finishedPer < 50) {
            this.finishedPer = 50;
        }
        try {
            DataAccess DAC = DAFactory.getDataAccess();
            DAC.executeBatch(sqls);
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new RuntimeException((Throwable)((Object)new AtsCalSumBizException(AtsCalSumBizException.FAILSAVE, new Object[]{e.getMessage()})));
        }
    }

    public IRowSet searchSchemeFormulas() throws Exception {
        if (this.finishedPer < 2) {
            this.finishedPer = 2;
        }
        StringBuffer sb = new StringBuffer();
        sb.append("SELECT FID, FName" + MLUtile.getMlFlag(this.ctx) + ", FExpress, FListItem, FListFunc, FListVar, FListTable, FSortSn");
        sb.append(" FROM T_HR_SCalFormula where FCalSchemeID='" + this.schemeID + "'");
        if (this.calFormulas != null && !"".equals(this.calFormulas)) {
            sb.append(" AND FID IN (");
            sb.append(this.calFormulas);
            sb.append(")");
        } else {
            sb.append(" AND FIsCal='1'");
        }
        sb.append(" ORDER BY FSortSn");
        IRowSet da = DbUtil.executeQuery((Context)this.ctx, (String)sb.toString());
        if (da == null || da.size() == 0) {
            throw new RuntimeException((Throwable)((Object)new AtsFormulaBizException(AtsFormulaBizException.LEAKCALFORMULA)));
        }
        return da;
    }

    public IRowSet getSchemeFormulas(String attencePolicyid) throws Exception {
        StringBuffer sb = new StringBuffer();
        sb.append(" SELECT FID, FName" + MLUtile.getMlFlag(this.ctx) + ", FExpress, FListItem, FListFunc, FListVar, FListTable, FSortSn, FContent ");
        sb.append(" FROM T_HR_ATS_CalFormula where FAttencePolicyID='" + attencePolicyid + "' ");
        sb.append(" AND FIsCal='1' ");
        sb.append(" ORDER BY FSortSn");
        IRowSet da = DbUtil.executeQuery((Context)this.ctx, (String)sb.toString());
        if (da == null || da.size() == 0) {
            // empty if block
        }
        return da;
    }

    public IRowSet getOneSchemeFormulas(String attencePolicyid, String formulaId) throws Exception {
        StringBuffer sb = new StringBuffer();
        sb.append(" SELECT FID, FName" + MLUtile.getMlFlag(this.ctx) + ", FExpress, FListItem, FListFunc, FListVar, FListTable, FSortSn ");
        sb.append(" FROM T_HR_ATS_CalFormula where FAttencePolicyID='" + attencePolicyid + "' and fid='" + formulaId + "' ");
        sb.append(" ORDER BY FSortSn");
        IRowSet da = DbUtil.executeQuery((Context)this.ctx, (String)sb.toString());
        if (da == null || da.size() == 0) {
            throw new RuntimeException((Throwable)((Object)new AtsFormulaBizException(AtsFormulaBizException.LEAKATSCALFORMULA)));
        }
        return da;
    }

    @Override
    public void setCalculateStatus(String calculateStatus) {
        this.calculateStatus = calculateStatus;
    }

    @Override
    public void setCalFormulas(String calFormulas) {
        this.calFormulas = calFormulas;
    }

    @Override
    public void setCalFromDate(String calFromDate) {
        this.calFromDate = calFromDate;
    }

    @Override
    public void setCalToDate(String calToDate) {
        this.calToDate = calToDate;
    }

    public void setCtx(Context ctx) {
        this.ctx = ctx;
    }

    @Override
    public void setMainTableName(String mainTableName) {
        this.mainTableName = mainTableName;
    }

    @Override
    public void setMainTableRowFilter(String condition) {
        this.condition = condition;
    }

    @Override
    public void setMonth(String month) {
        this.month = month;
    }

    @Override
    public void setPrecision(int v) {
        this.precision = v;
    }

    @Override
    public void setSchemeID(String schemeID) {
        this.schemeID = schemeID;
    }

    public void setStatus(int status) {
        this.status = status;
    }

    public void setTempTable(String tempTable) {
        this.tempTable = tempTable;
    }

    public void setDataSegment(int dataSegment) {
        this.dataSegment = dataSegment;
    }

    public int getDateSegment() {
        return this.dataSegment;
    }

    public void setCalCurrentStrDate(String currentStrDate) {
        this.calCurrentStrDate = currentStrDate;
    }

    public String getCalCurrentsqlDate() {
        return this.calCurrentStrDate;
    }

    public JSONArray testExecute(Context ctx, String execPersonId, String calSchemeId, String formulaId, JSONArray calData) throws Exception {
        this.ctx = ctx;
        Tools.getInstance().setCtx(ctx);
        this.schemeID = calSchemeId;
        this.calFormulas = "'" + formulaId + "'";
        Object columnName = null;
        CalSchemeInfo calScheme = new CalSchemeInfo();
        IRowSet da = this.getOneSchemeFormulas(calSchemeId, formulaId);
        String policyPersonResultIds = "8r0AAAAGmpUB2lE0_" + execPersonId + "_" + "//5W8xTp1UaogqqlkWuV4/iu0UA=";
        String[] policyPersonResultIdsArr = policyPersonResultIds.split("_");
        ResultCalFunction calObj = this.initCalInstance(ctx, da);
        Date preDate = AtsDateUtils.getPreDay(new Date());
        String attenceDate = AtsDateUtils.dateLongToString(preDate);
        attenceDate = AtsDateUtils.getDateFromLongString(attenceDate);
        String endDate = AtsDateUtils.dateShortToString(new Date());
        StringBuffer sql = new StringBuffer("select FID from " + this.mainTableName);
        sql.append(" where FProposerID = '" + execPersonId + "'");
        if (!"T_HR_ATS_AttendanceResultSum".equals(this.mainTableName)) {
            sql.append(" and FAttenceDate = {ts '" + attenceDate + "'} ");
        }
        String personIds = "'" + execPersonId + "'";
        String calId = "";
        List list = ResultCalculator.find(ctx, sql.toString());
        calId = !list.isEmpty() && list.get(0) != null ? (String)list.get(0) : execPersonId;
        int colIndex = 0;
        DataSet dataSet = new DataSet();
        HashSet<String> calItem = new HashSet<String>();
        ArrayList<ColumnAttributes> columns = new ArrayList<ColumnAttributes>();
        ArrayList datas = new ArrayList();
        ArrayList<Object> row = new ArrayList<Object>();
        ColumnAttributes columnAttributes = new ColumnAttributes();
        columnAttributes.setIndex(colIndex++);
        columnAttributes.setName("FID");
        columnAttributes.setType(DataTypes.STRING);
        columns.add(columnAttributes);
        row.add(calId);
        columnAttributes = new ColumnAttributes();
        columnAttributes.setIndex(colIndex++);
        columnAttributes.setName("FProposerID");
        columnAttributes.setType(DataTypes.STRING);
        columns.add(columnAttributes);
        row.add(execPersonId);
        if (!"T_HR_ATS_AttendanceResultSum".equals(this.mainTableName)) {
            ColumnAttributes attributes = new ColumnAttributes();
            attributes.setIndex(colIndex++);
            attributes.setName("FAttenceDate");
            attributes.setType(DataTypes.STRING);
            columns.add(attributes);
            row.add(attenceDate);
        }
        for (int i = 0; i < calData.length(); ++i) {
            JSONObject data = calData.getJSONObject(i);
            if (!data.has("fieldSn")) continue;
            columnAttributes = new ColumnAttributes();
            columnAttributes.setIndex(colIndex++);
            columnAttributes.setName(data.getString("fieldSn"));
            if (data.has("isNum") && "N".equals(data.get("isNum"))) {
                columnAttributes.setType(DataTypes.STRING);
                row.add(data.getString("value"));
            } else {
                columnAttributes.setType(DataTypes.FLOAT);
                row.add(data.getDouble("value"));
            }
            columns.add(columnAttributes);
            if (!data.has("isCal")) continue;
            calItem.add(data.getString("fieldSn"));
        }
        datas.add(row);
        DataTable mainTable = new DataTable();
        mainTable.tablename = this.mainTableName;
        mainTable.columns = columns;
        mainTable.datas = datas;
        dataSet.addTable(mainTable);
        String infoset = null;
        HashSet<String> tableSet = new HashSet<String>();
        for (int i = 0; i < calData.length(); ++i) {
            if (!calData.getJSONObject(i).has("infoset")) continue;
            infoset = calData.getJSONObject(i).getString("infoset");
            tableSet.add(infoset.split("\\.")[0]);
        }
        if (!tableSet.isEmpty()) {
            for (String tableName : tableSet) {
                colIndex = 0;
                columns = new ArrayList();
                datas = new ArrayList();
                row = new ArrayList();
                columnAttributes = new ColumnAttributes();
                columnAttributes.setIndex(colIndex++);
                columnAttributes.setName("FID");
                columnAttributes.setType(DataTypes.STRING);
                columns.add(columnAttributes);
                row.add(execPersonId);
                for (int i = 0; i < calData.length(); ++i) {
                    JSONObject data = calData.getJSONObject(i);
                    String string = infoset = data.has("infoset") ? data.getString("infoset") : "";
                    if (StringUtils.isEmpty((String)infoset) || !tableName.equals(infoset.split("\\.")[0])) continue;
                    columnAttributes = new ColumnAttributes();
                    columnAttributes.setIndex(colIndex++);
                    String[] infos = infoset.split("\\.");
                    if (infos.length > 2) {
                        columnAttributes.setName(infos[1] + "_" + infos[2]);
                    } else {
                        columnAttributes.setName(infos[1]);
                    }
                    columnAttributes.setType(DataTypes.STRING);
                    columns.add(columnAttributes);
                    row.add(data.getString("value"));
                }
                datas.add(row);
                DataTable infoTable = new DataTable();
                infoTable.tablename = tableName;
                infoTable.columns = columns;
                infoTable.datas = datas;
                dataSet.addTable(infoTable);
            }
        }
        DataAccess DAC = DAFactory.getDataAccess();
        SQLGenerate sqlgen = new SQLGenerate();
        sqlgen.fromTime = this.calFromDate;
        sqlgen.toTime = this.calToDate;
        sqlgen.isShowCodeText = false;
        String sq = null;
        DataTable dt = null;
        String listtable = null;
        String[] tableitem = null;
        String[] tables = null;
        StringBuffer sb = new StringBuffer();
        da.beforeFirst();
        while (da.next()) {
            listtable = da.getString("FListTable");
            if (listtable == null || "".equals(listtable)) continue;
            tables = listtable.split(";");
            for (int loop = 0; loop < tables.length; ++loop) {
                tableitem = tables[loop].split("~");
                String id = "'" + tableitem[1] + "'";
                if (sb.indexOf(id) != -1) continue;
                if (sb.length() > 0) {
                    sb.append(",");
                }
                sb.append(id);
            }
        }
        if (sb.length() > 0) {
            sb.insert(0, "SELECT FDefine, FSqls, FPeriodFrom, FPeriodTo FROM T_HR_SFormulaTmpTable WHERE fid IN (");
            sb.append(")");
            dt = DAC.getDataTable(sb.toString(), "T_HR_SFormulaTmpTable");
            DataRow[] rows = dt.getAllRows();
            StringBuffer tableName = new StringBuffer();
            for (int index = 0; index < rows.length; ++index) {
                sb.delete(0, sb.length());
                sb.append(rows[index].getString("FSqls"));
                if (sb.toString().toUpperCase().indexOf("WHERE") == -1) {
                    int insertIndex = sb.indexOf("GROUP BY") > -1 ? sb.indexOf("GROUP BY") : (sb.indexOf("ORDER BY") > -1 ? sb.indexOf("ORDER BY") : sb.length());
                    sb.insert(insertIndex, " WHERE 1 = 1 ");
                }
                tableName.delete(0, tableName.length());
                int i = sb.toString().toUpperCase().indexOf("FROM ") + 5;
                while (sb.charAt(i) != ' ' && sb.charAt(i) != '\r' && sb.charAt(i) != '\t') {
                    tableName.append(sb.charAt(i));
                    ++i;
                }
                String testcondition = " T_HR_SCmpCalTable.FID = '" + execPersonId + "'";
                sb.insert(sb.toString().toUpperCase().indexOf("WHERE") + 6, " (" + testcondition + ") AND ");
                sq = sb.toString().replaceAll("@YEARFROM", FunctionTools.adustStringDate((String)this.calToDate, (int)rows[index].getInt("FPeriodFrom"), (String)"@YEARFROM")).replaceAll("@MONTHFROM", FunctionTools.adustStringDate((String)this.calToDate, (int)rows[index].getInt("FPeriodFrom"), (String)"@MONTHFROM")).replaceAll("@YEARTO", FunctionTools.adustStringDate((String)this.calToDate, (int)rows[index].getInt("FPeriodTo"), (String)"@YEARTO")).replaceAll("@MONTHTO", FunctionTools.adustStringDate((String)this.calToDate, (int)rows[index].getInt("FPeriodTo"), (String)"@MONTHTO"));
                sb.delete(0, sb.length());
                try {
                    DataTable dt1 = DAC.getDataTable(sq, rows[index].getString("FDefine"));
                    if (dt1 == null) continue;
                    dataSet.addTable(dt1);
                    continue;
                }
                catch (Exception e) {
                    e.printStackTrace();
                    throw new RuntimeException((Throwable)((Object)new AtsCommonBizException(AtsCommonBizException.TEMPTABLEERRORWITHSQL, new Object[]{sq, e.getMessage()})));
                }
            }
        }
        Map globalMap = this.getInitDatas(ctx, personIds, attenceDate, endDate);
        globalMap.put("T_HR_ATS_ATTENDANCERESULT_FATTENCEDATE", attenceDate);
        globalMap.put("T_HR_ATS_ATTENDANCERESULT_FPROPOSERID", execPersonId);
        Map<String, List<DataTable>> personDataMap = AttendanceSelfDefinedUtil.getPersonDataMap(ctx, globalMap, attenceDate, endDate, personIds);
        globalMap.put("personDataMap", personDataMap);
        this.addHrDataSet(globalMap, policyPersonResultIdsArr, dataSet);
        this.execAtsCalculate(calObj, dataSet, new HashSet(), 1, globalMap);
        AttendanceProjectCollection items = AttendanceProjectFactory.getLocalInstance(ctx).getAttendanceProjectCollection();
        HashMap<String, Integer> itemDotMap = new HashMap<String, Integer>();
        for (int i = 0; i < items.size(); ++i) {
            AttendanceProjectInfo item = items.get(i);
            itemDotMap.put("S" + item.getColumnNO(), item.getDecimalDigit());
            if (null == item.getDataType()) continue;
            itemDotMap.put("S" + item.getColumnNO() + "DataType", item.getDataType().getValue());
        }
        JSONArray result = new JSONArray();
        mainTable = dataSet.getTables(this.mainTableName);
        if (mainTable.rowCount() > 0) {
            DataRow rw = mainTable.getRows(0);
            for (String key : calItem) {
                Object admin;
                String value;
                JSONObject cal = new JSONObject();
                cal.put("fieldSn", (Object)key);
                Object v = rw.getValue(key);
                if (v instanceof Number) {
                    Integer dataType = (Integer)itemDotMap.get(key + "DataType");
                    if (null != dataType && dataType == 1) {
                        cal.put("value", (Object)String.valueOf(BigDecimal.valueOf(((Number)v).doubleValue()).intValue()));
                    } else {
                        cal.put("value", (Object)FunctionTools.getRound((int)((Integer)itemDotMap.get(key)), (double)((Number)v).doubleValue()));
                    }
                } else if ("FAdminOrgUnitID".equals(columnName)) {
                    if (v != null && !v.equals("0") && !"".equals(v)) {
                        value = v.toString();
                        admin = AdminOrgUnitFactory.getLocalInstance((Context)ctx).getAdminOrgUnitInfo((IObjectPK)new ObjectUuidPK(value));
                        if (admin != null) {
                            cal.put("value", (Object)admin.getName());
                        } else {
                            cal.put("value", (Object)"");
                        }
                    } else {
                        cal.put("value", (Object)"");
                    }
                } else if ("FPositionID".equals(columnName)) {
                    if (v != null && !v.equals("0") && !"".equals(v)) {
                        value = v.toString();
                        admin = PositionFactory.getLocalInstance((Context)ctx).getPositionInfo((IObjectPK)new ObjectUuidPK(value));
                        if (admin != null) {
                            cal.put("value", (Object)admin.getName());
                        } else {
                            cal.put("value", (Object)"");
                        }
                    } else {
                        cal.put("value", (Object)"");
                    }
                } else if ("FShiftTypeID".equals(columnName)) {
                    if (v != null && !v.equals("0") && !"".equals(v)) {
                        value = v.toString();
                        admin = AtsShiftTypeFactory.getLocalInstance(ctx).getAtsShiftTypeInfo((IObjectPK)new ObjectUuidPK(value));
                        if (admin != null) {
                            cal.put("value", (Object)admin.getName());
                        } else {
                            cal.put("value", (Object)"");
                        }
                    } else {
                        cal.put("value", (Object)"");
                    }
                } else if ("FOtCompensID".equals(columnName)) {
                    if (v != null && !v.equals("0") && !"".equals(v)) {
                        value = v.toString();
                        admin = OverTimeCompensFactory.getLocalInstance(ctx).getOverTimeCompensInfo((IObjectPK)new ObjectUuidPK(value));
                        if (admin != null) {
                            cal.put("value", (Object)admin.getName());
                        } else {
                            cal.put("value", (Object)"");
                        }
                    } else {
                        cal.put("value", (Object)"");
                    }
                } else {
                    cal.put("value", v);
                }
                result.put((Object)cal);
            }
        }
        return result;
    }

    public static List find(Context ctx, String sql) throws BOSException, SQLException {
        ArrayList<Object> list = new ArrayList<Object>();
        IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)sql);
        ResultSetMetaData mt = rs.getMetaData();
        Object[] cols = null;
        while (rs.next()) {
            if (mt.getColumnCount() == 1) {
                list.add(rs.getObject(1));
                continue;
            }
            cols = new Object[mt.getColumnCount()];
            for (int column = 1; column <= mt.getColumnCount(); ++column) {
                cols[column - 1] = rs.getObject(column);
            }
            list.add(cols);
        }
        return list;
    }

    public Map getInitDatas(Context ctx, String personIds, String beginDate, String endDate) throws Exception {
        String[] periodStartAndEnd;
        HashMap<Object, Object> globalMap = new HashMap<Object, Object>();
        HashMap<String, String> commonParams = new HashMap<String, String>();
        Date preDate = AtsDateUtils.getPreDay(AtsDateUtils.getPreDay(new Date()));
        String sattenceDate = AtsDateUtils.dateLongToString(preDate);
        String preAttenceDate = AtsDateUtils.getDateFromLongString(sattenceDate);
        commonParams.put("personIds", personIds);
        commonParams.put("beginDate", preAttenceDate);
        commonParams.put("endDate", endDate);
        AtsGlobalDataCache.initAtsGlobalDataCache(ctx, globalMap, preAttenceDate, endDate);
        AtsBatchPrepareDataCache.initBatchDataCache(ctx, personIds, preAttenceDate, endDate, globalMap);
        AtsBatchBillDataCache.initAtsBatchBillDataCache(ctx, commonParams, globalMap);
        Map<String, Object> attResultInfosMap = AtsServerCalUtils.getDynamicAttendanceResult(ctx, personIds, preAttenceDate, endDate);
        globalMap.put("T_HR_ATS_AttendanceResult", attResultInfosMap);
        globalMap.put("personId", personIds);
        if ((String)globalMap.get("periodBeginDate") == null) {
            globalMap.put("periodBeginDate", AtsDateUtils.dateShortFormatToStr(AtsDateUtils.getMonthFirstDay(AtsDateUtils.stringToShortDate(beginDate))));
        }
        if ((String)globalMap.get("periodEndDate") == null) {
            Date lastDay = AtsDateUtils.getMonthLastDay(endDate);
            globalMap.put("periodEndDate", AtsDateUtils.dateShortFormatToStr(lastDay));
        }
        if (null != (periodStartAndEnd = this.requirePeriodStartAndEnd(globalMap, personIds, beginDate)) && periodStartAndEnd.length >= 2) {
            globalMap.put("periodBeginDate", periodStartAndEnd[0]);
            globalMap.put("periodEndDate", periodStartAndEnd[1]);
            AtsScheduleShiftUtil.getAllScheduleShiftMapByPriority(globalMap, ctx, personIds, periodStartAndEnd[0], periodStartAndEnd[1]);
        }
        if ((String)globalMap.get("resultCal_personids") == null) {
            globalMap.put("resultCal_personids", personIds);
        }
        return globalMap;
    }

    public String[] requirePeriodStartAndEnd(Map globalMap, String personId, String currDateStr) {
        String[] periodStartAndEnd = new String[2];
        if (!AtsCollectionUtile.isEmpty(globalMap)) {
            AttendanceFileInfo attFilefo;
            String key = personId.replaceAll("'", "") + "_" + currDateStr;
            Map attendanceFileInfoMap = (Map)globalMap.get("T_HR_ATS_AttendanceFile");
            Map attendancePolicyInfoMap = (Map)globalMap.get("T_HR_ATS_AttencePolicy");
            Map attendancePeriodInfoMap = (Map)globalMap.get("attendancePeriodInfoListMap");
            String attenceCycleID = "";
            if (attendanceFileInfoMap != null && (attFilefo = (AttendanceFileInfo)attendanceFileInfoMap.get(key)) != null && attFilefo.getAttencePolicy() != null && attFilefo.getAttencePolicy().getId() != null && attendancePolicyInfoMap != null) {
                AttencePolicyInfo poInfo = (AttencePolicyInfo)attendancePolicyInfoMap.get(attFilefo.getAttencePolicy().getId().toString());
                String string = attenceCycleID = poInfo.getAttenceCycle() == null ? "" : poInfo.getAttenceCycle().getId().toString();
            }
            if (attendancePeriodInfoMap != null && org.apache.commons.lang.StringUtils.isNotBlank((String)attenceCycleID)) {
                List periodInfoList = (List)attendancePeriodInfoMap.get(attenceCycleID);
                int size = periodInfoList.size();
                for (int i = 0; i < size; ++i) {
                    Date startDate = ((AttendancePeriodInfo)periodInfoList.get(i)).getStartDate();
                    Date endDate = ((AttendancePeriodInfo)periodInfoList.get(i)).getEndDate();
                    Date currentDate = AtsDateUtils.stringToShortDate(currDateStr);
                    if (currentDate.getTime() < startDate.getTime() || currentDate.getTime() > endDate.getTime()) continue;
                    periodStartAndEnd[0] = AtsDateUtils.dateShortToString(startDate);
                    periodStartAndEnd[1] = AtsDateUtils.dateShortToString(endDate);
                    return periodStartAndEnd;
                }
            }
        }
        return periodStartAndEnd;
    }

    private void addColumnToDt(DataTable dt, String attendResultId) {
        ArrayList columnsList = dt.columns;
        ColumnAttributes columnAttr = new ColumnAttributes();
        columnAttr.setIndex(columnsList.size());
        columnAttr.setName("fid");
        columnAttr.setType(DataTypes.STRING);
        columnsList.add(columnAttr);
        ArrayList row = null;
        if (dt.datas != null && dt.datas.size() > 0) {
            row = (ArrayList)dt.datas.get(0);
            row.add(attendResultId);
        } else {
            ArrayList tempList = new ArrayList();
            ArrayList<String> tempRow = new ArrayList<String>();
            for (int i = 0; i < columnsList.size() - 1; ++i) {
                tempRow.add("");
            }
            tempRow.add(attendResultId);
            tempList.add(tempRow);
            dt.datas = tempList;
        }
    }
}

