/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.hr.ats.biz.util;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.basedata.org.AdminOrgUnitInfo;
import com.kingdee.eas.basedata.org.HROrgUnitInfo;
import com.kingdee.eas.basedata.org.PositionInfo;
import com.kingdee.eas.basedata.person.PersonFactory;
import com.kingdee.eas.basedata.person.PersonInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.hr.ats.AbstractAtsFileBaseInfo;
import com.kingdee.eas.hr.ats.AtsFileResEnum;
import com.kingdee.eas.hr.ats.AtsShiftInfo;
import com.kingdee.eas.hr.ats.AttencePolicyInfo;
import com.kingdee.eas.hr.ats.AttendFileStateEnum;
import com.kingdee.eas.hr.ats.AttendanceFileCollection;
import com.kingdee.eas.hr.ats.AttendanceFileFactory;
import com.kingdee.eas.hr.ats.AttendanceFileInfo;
import com.kingdee.eas.hr.ats.HolidayPolicySetInfo;
import com.kingdee.eas.hr.ats.IsAttendanceEnum;
import com.kingdee.eas.hr.ats.IsAutoShiftEnum;
import com.kingdee.eas.hr.ats.ResourceEnum;
import com.kingdee.eas.hr.ats.biz.util.AtsServerBizUtil;
import com.kingdee.eas.hr.ats.lightapp.util.SHRBillUtil;
import com.kingdee.eas.hr.ats.util.AtsDateUtils;
import com.kingdee.eas.hr.ats.util.common.MLUtile;
import com.kingdee.eas.hr.base.EmpPosOrgRelationFactory;
import com.kingdee.eas.hr.base.EmpPosOrgRelationInfo;
import com.kingdee.eas.hr.emp.PersonPositionInfo;
import com.kingdee.shr.base.bizmanage.PersonBURelationInfo;
import java.util.Date;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;

public class AttendanceFileBaseBiz {
    private static Logger logger = Logger.getLogger(AttendanceFileBaseBiz.class);

    public static AttendanceFileInfo addAttendanceFileAndHisInfo(Context ctx, PersonBURelationInfo personBURelationInfo) throws BOSException, EASBizException {
        AttendanceFileCollection fileColl;
        AttendanceFileInfo info = AttendanceFileBaseBiz.parseJsonToFileInfo(ctx, personBURelationInfo);
        if (info == null) {
            return null;
        }
        boolean isEdit = false;
        boolean isGenerateHis = false;
        boolean isSaveFileInfo = false;
        boolean isUpdateFileInfo = false;
        AbstractAtsFileBaseInfo originInfoDB = null;
        String personid = info.getProposer().getId().toString();
        if (StringUtils.isNotBlank((String)personid) && (fileColl = AttendanceFileFactory.getLocalInstance(ctx).getAttendanceFileCollection(" where proposer.id ='" + personid + "' ")) != null && fileColl.size() > 0) {
            originInfoDB = fileColl.get(0);
            info.setIsDefaultManage(originInfoDB.isIsDefaultManage());
            isEdit = AtsServerBizUtil.attendanceFileCompare(info, (AttendanceFileInfo)originInfoDB);
        }
        if (originInfoDB == null) {
            info.setLEFFDT(AtsDateUtils.stringToShortDate("2099-12-31"));
            info.setIsDefaultManage(true);
            isGenerateHis = true;
            isSaveFileInfo = true;
        } else if (isEdit && info.getAttendFileState().getValue() == "1" && info.getEFFDT().getTime() != originInfoDB.getEFFDT().getTime()) {
            info.setId(BOSUuid.read((String)originInfoDB.getId().toString()));
            info.setLEFFDT(AtsDateUtils.stringToShortDate("2099-12-31"));
            isGenerateHis = true;
            isUpdateFileInfo = true;
        }
        if (isSaveFileInfo) {
            AttendanceFileFactory.getLocalInstance(ctx).save((CoreBaseInfo)info);
            AtsServerBizUtil.updateAttendanceFileHis(ctx, info);
        }
        if (isUpdateFileInfo) {
            String orginFileID = originInfoDB.getId().toString();
            AttendanceFileFactory.getLocalInstance(ctx).update((IObjectPK)new ObjectUuidPK(orginFileID), info);
            AtsServerBizUtil.updateAttendanceFileHis(ctx, info);
        }
        if (isGenerateHis && originInfoDB != null) {
            Date effdtHis = originInfoDB.getEFFDT();
            AtsServerBizUtil.generateHis(ctx, (AttendanceFileInfo)originInfoDB, effdtHis, info.getEFFDT());
        }
        return info;
    }

    public static AttendanceFileInfo parseJsonToFileInfo(Context ctx, PersonBURelationInfo relationInfo) throws EASBizException, BOSException {
        AttendanceFileInfo info = new AttendanceFileInfo();
        String personId = relationInfo.getPerson().getId().toString();
        PersonInfo personInfo = PersonFactory.getLocalInstance((Context)ctx).getPersonInfo((IObjectPK)new ObjectUuidPK(personId));
        String personNumber = personInfo.getNumber();
        String personName = personInfo.getName();
        String hrOrgUnitId = relationInfo.getHrOrgUnit().getId().toString();
        String empposrelationId = relationInfo.getEmpOrgRelation().getId().toString();
        EmpPosOrgRelationInfo empRelationInfo = EmpPosOrgRelationFactory.getLocalInstance((Context)ctx).getEmpPosOrgRelationInfo((IObjectPK)new ObjectUuidPK(empposrelationId));
        String adminOrgUnitId = empRelationInfo.getAdminOrg().getId().toString();
        String policySetKey = hrOrgUnitId + "_" + adminOrgUnitId;
        String positionId = empRelationInfo.getPosition().getId().toString();
        AtsShiftInfo atsShiftInfo = AtsServerBizUtil.getDefaultShift(ctx, personId);
        AttencePolicyInfo attencePolicyInfo = AtsServerBizUtil.getDefaultAttendancePolicy(ctx, personId);
        HolidayPolicySetInfo holidayPolicySetInfo = AtsServerBizUtil.getDefaultHolidayPolicy(ctx, personId);
        if (atsShiftInfo == null) {
            logger.error((Object)MLUtile.getRes((ResourceEnum)AtsFileResEnum.NullShift, ctx, personName));
            info = null;
            return null;
        }
        if (attencePolicyInfo == null) {
            logger.error((Object)MLUtile.getRes((ResourceEnum)AtsFileResEnum.NullAtsPolicy, ctx, personName));
            info = null;
            return null;
        }
        String attendanceNum = personNumber;
        info.setAttendanceNum(attendanceNum);
        info.setIsAttendance(IsAttendanceEnum.yes);
        info.setAttendFileState(AttendFileStateEnum.enable);
        info.setFileType(1);
        PersonPositionInfo personPositionInfo = SHRBillUtil.getAdminOrgUnitAndHrOrgUnit(personId, ctx);
        if (personPositionInfo != null) {
            info.setProposer(personPositionInfo.getPerson());
            info.setAdminOrgUnit(personPositionInfo.getPersonDep());
            info.setPosition(personPositionInfo.getPrimaryPosition());
        }
        HROrgUnitInfo hrOrgUnit = new HROrgUnitInfo();
        hrOrgUnit.setId(BOSUuid.read((String)hrOrgUnitId));
        info.setHrOrgUnit(hrOrgUnit);
        AdminOrgUnitInfo adminInfo = new AdminOrgUnitInfo();
        adminInfo.setId(BOSUuid.read((String)adminOrgUnitId));
        info.setAttAdminOrgUnit(adminInfo);
        PositionInfo position = new PositionInfo();
        position.setId(BOSUuid.read((String)positionId));
        info.setAttPosition(position);
        info.setAtsShift(atsShiftInfo);
        info.setAttencePolicy(attencePolicyInfo);
        info.setEFFDT(relationInfo.getEFFDT());
        PersonInfo perInfo = new PersonInfo();
        perInfo = info.getProposer();
        perInfo.setNumber(personNumber);
        info.setProposer(perInfo);
        info.setIsAutoShift(IsAutoShiftEnum.no);
        info.setManageRelation(relationInfo);
        info.setIsDefaultManage(relationInfo.isUseDefault());
        return info;
    }
}

