/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.hr.ats.calculate;

import com.kingdee.bos.Context;
import com.kingdee.eas.hr.ats.AtsShiftInfo;
import com.kingdee.eas.hr.ats.AtsShiftItemCollection;
import com.kingdee.eas.hr.ats.AtsShiftItemInfo;
import com.kingdee.eas.hr.ats.AtsTripBillEntryInfo;
import com.kingdee.eas.hr.ats.AtsTripLengthCalTypeEnum;
import com.kingdee.eas.hr.ats.AttencePolicyInfo;
import com.kingdee.eas.hr.ats.AttendanceFileInfo;
import com.kingdee.eas.hr.ats.AttendanceTypeEnum;
import com.kingdee.eas.hr.ats.ScheduleShiftInfo;
import com.kingdee.eas.hr.ats.ScheduleShiftItemCollection;
import com.kingdee.eas.hr.ats.calculate.DateInterVal;
import com.kingdee.eas.hr.ats.calculate.state.vo.ShiftTimeVO;
import com.kingdee.eas.hr.ats.calculate.time.model.TimeLabelListModel;
import com.kingdee.eas.hr.ats.calculate.time.model.TimeLabelModel;
import com.kingdee.eas.hr.ats.calculate.time.strategy.context.AtsCalculatorContext;
import com.kingdee.eas.hr.ats.calculate.time.strategy.impl.BaseCalculatorStrategy;
import com.kingdee.eas.hr.ats.calculate.time.util.CalTimeUtil;
import com.kingdee.eas.hr.ats.calculate.time.vo.CalTimeVO;
import com.kingdee.eas.hr.ats.decimalPlace.util.DecimalPlaceUtil;
import com.kingdee.eas.hr.ats.function.AtsCalFunctionUtil;
import com.kingdee.eas.hr.ats.result.AttendanceDynamicResInfo;
import com.kingdee.eas.hr.ats.util.AtsDateUtils;
import com.kingdee.eas.hr.ats.util.FetchCardUtil;
import java.math.BigDecimal;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.lang.StringUtils;

public class AtsCalculateTimeUtil {
    public static final String STANDARDHOUR = "standardHour";
    public static final String SHIFTTIMELIST = "shiftTimeList";

    public static Object[] calTripTime(Context ctx, String personId, String date, Map globalMap, boolean isContailOutShiftTime) {
        Map tripBillEntryMap = (Map)globalMap.get("T_HR_ATS_TripBillEntry");
        List<AtsTripBillEntryInfo> tripBillEntryList = AtsCalculateTimeUtil.tripBillFilter(personId, date, tripBillEntryMap);
        double tripTime = 0.0;
        BigDecimal standardHour = BigDecimal.ZERO;
        if (null != tripBillEntryList) {
            Map<String, Object> scheduleMap;
            AttendanceDynamicResInfo result;
            String person_date_key = personId + "_" + date;
            int decimalPlaces = DecimalPlaceUtil.getDecimalPlaces(ctx, globalMap);
            Map attendanceFileInfoMap = (Map)globalMap.get("T_HR_ATS_AttendanceFile");
            AttendanceFileInfo attendanceFileInfo = (AttendanceFileInfo)attendanceFileInfoMap.get(person_date_key);
            AttencePolicyInfo attencePolicyInfo = null;
            if (null != attendanceFileInfo && null != attendanceFileInfo.getAttencePolicy()) {
                Map attencePolicyMap = (Map)globalMap.get("T_HR_ATS_AttencePolicy");
                attencePolicyInfo = (AttencePolicyInfo)attencePolicyMap.get(attendanceFileInfo.getAttencePolicy().getId().toString());
            }
            AtsShiftInfo shiftInfo = AtsCalculateTimeUtil.getAtsShiftInfo(personId, date, globalMap);
            Timestamp[] OnOffShiftTime = AtsCalculateTimeUtil.getOnOffShiftTime(shiftInfo, date);
            AtsTripBillEntryInfo entryInfo = null;
            Timestamp[] headTailOutTime = AtsCalculateTimeUtil.getHeadTailOutTime(globalMap, personId, date);
            ArrayList<TimeLabelModel> dateInterValList = new ArrayList<TimeLabelModel>();
            for (int i = 0; i < tripBillEntryList.size(); ++i) {
                entryInfo = tripBillEntryList.get(i);
                if (null != attencePolicyInfo && !attencePolicyInfo.isIsCalOutShift()) {
                    if (entryInfo.getRealTripStartTime().getTime() >= OnOffShiftTime[1].getTime() || entryInfo.getRealTripEndTime().getTime() <= OnOffShiftTime[0].getTime()) {
                        tripBillEntryList.remove(i--);
                        continue;
                    }
                } else if (entryInfo.getRealTripStartTime().getTime() >= headTailOutTime[1].getTime() || entryInfo.getRealTripEndTime().getTime() <= headTailOutTime[0].getTime()) {
                    tripBillEntryList.remove(i--);
                    continue;
                }
                if (entryInfo.isIsAllDay()) {
                    dateInterValList.add(new TimeLabelModel(OnOffShiftTime[0], OnOffShiftTime[1], "trip"));
                    continue;
                }
                dateInterValList.add(new TimeLabelModel(entryInfo.getRealTripStartTime(), entryInfo.getRealTripEndTime(), "trip"));
            }
            List<TimeLabelModel> resultList = AtsCalculateTimeUtil.calDateAndSetForTimeLabel(dateInterValList);
            CalTimeVO calTimeVO = null;
            AtsTripLengthCalTypeEnum tripLengthCalType = (AtsTripLengthCalTypeEnum)((Object)globalMap.get("tripLengthCalType"));
            if (null != tripLengthCalType && null != (result = (AttendanceDynamicResInfo)globalMap.get("AttendanceDynamicResInfo")) && null != (calTimeVO = CalTimeUtil.getInOutSideCardCalTimeVO(tripLengthCalType, personId, date, globalMap, result)) && calTimeVO.isCardIntersect()) {
                List<TimeLabelModel> timeLabelModels = calTimeVO.getTimeLabelModels();
                timeLabelModels.addAll(resultList);
                ArrayList<String> labels = new ArrayList<String>();
                labels.add("trip");
                labels.add("card");
                AtsCalculatorContext atsCtx = new AtsCalculatorContext(new BaseCalculatorStrategy());
                List<TimeLabelListModel> timeLabelListModels = atsCtx.executeStrategySegmentMark(timeLabelModels, labels, "");
                if (null != timeLabelListModels && timeLabelListModels.size() > 0) {
                    Iterator<TimeLabelListModel> iter = timeLabelListModels.iterator();
                    resultList = new ArrayList<TimeLabelModel>();
                    while (iter.hasNext()) {
                        TimeLabelListModel timeLabelListModel = iter.next();
                        resultList.add(new TimeLabelModel(timeLabelListModel.getBeginTime(), timeLabelListModel.getEndTime(), timeLabelListModel.getLabels().get(0)));
                    }
                }
            }
            if (null != (scheduleMap = AtsCalculateTimeUtil.getScheduleShiftDetail(shiftInfo, date)) && null != resultList && resultList.size() > 0) {
                List shiftTimeList = (List)scheduleMap.get(SHIFTTIMELIST);
                standardHour = (BigDecimal)scheduleMap.get(STANDARDHOUR);
                if (null != shiftTimeList && shiftTimeList.size() > 0) {
                    tripTime = AtsCalculateTimeUtil.getShiftTime(decimalPlaces, OnOffShiftTime, resultList, shiftTimeList, standardHour);
                    if (null != attencePolicyInfo && attencePolicyInfo.isIsCalOutShift() && isContailOutShiftTime) {
                        double intersectTime = AtsCalculateTimeUtil.getOutShiftTime(globalMap, personId, date, tripBillEntryList, OnOffShiftTime, resultList);
                        tripTime += AtsDateUtils.divide(intersectTime, 3600000.0, decimalPlaces);
                    }
                }
            }
        }
        return new Object[]{tripTime, tripBillEntryList.size(), standardHour};
    }

    public static List<AtsTripBillEntryInfo> tripBillFilter(String personId, String date, Map<String, List<AtsTripBillEntryInfo>> atsTripBillInfosMap) {
        ArrayList<String> keylist = new ArrayList<String>();
        String key = personId + "_" + date;
        String keybef1 = personId + "_" + AtsDateUtils.getPreDay(date, 1);
        String keyaft1 = personId + "_" + AtsDateUtils.getNextDay(date, 1);
        keylist.add(keybef1);
        keylist.add(key);
        keylist.add(keyaft1);
        ArrayList<AtsTripBillEntryInfo> tripBillList = new ArrayList<AtsTripBillEntryInfo>();
        HashMap<String, String> tripKeyMap = new HashMap<String, String>();
        HashSet<String> tripBillSet = new HashSet<String>();
        for (int m = 0; m < keylist.size(); ++m) {
            String innerkey = (String)keylist.get(m);
            List<AtsTripBillEntryInfo> innerList = atsTripBillInfosMap.get(innerkey);
            if (innerList == null) continue;
            for (int j = 0; j < innerList.size(); ++j) {
                String timeKey;
                AtsTripBillEntryInfo entryInfo = innerList.get(j);
                if (tripKeyMap.containsKey(entryInfo.getId().toString()) || tripBillSet.contains(timeKey = AtsDateUtils.timestampToString(entryInfo.getRealTripStartTime()) + AtsDateUtils.timestampToString(entryInfo.getRealTripEndTime()))) continue;
                tripBillList.add(entryInfo);
                tripKeyMap.put(entryInfo.getId().toString(), entryInfo.getId().toString());
                tripBillSet.add(timeKey);
            }
        }
        return tripBillList;
    }

    private static double getOutShiftTime(Map globalMap, String personId, String date, List<AtsTripBillEntryInfo> tripBillEntryList, Timestamp[] OnOffShiftTime, List<TimeLabelModel> resultList) {
        double outShiftTime = 0.0;
        ArrayList<Timestamp> tpCalOutBillList = new ArrayList<Timestamp>();
        for (int i = 0; i < resultList.size(); ++i) {
            tpCalOutBillList.add(resultList.get(i).getBeginTime());
            tpCalOutBillList.add(resultList.get(i).getEndTime());
        }
        Timestamp[] headTailOutTime = AtsCalculateTimeUtil.getHeadTailOutTime(globalMap, personId, date);
        Set<String> calOutDate = FetchCardUtil.getCalOutShiftDate(tripBillEntryList, date, headTailOutTime);
        if (calOutDate.contains(date)) {
            ArrayList<Timestamp> shiftList = new ArrayList<Timestamp>();
            shiftList.add(OnOffShiftTime[0]);
            shiftList.add(OnOffShiftTime[1]);
            outShiftTime = FetchCardUtil.intervalTimeCalOutShift(shiftList, tpCalOutBillList, headTailOutTime);
        }
        return outShiftTime;
    }

    private static double getShiftTime(int decimalPlaces, Timestamp[] OnOffShiftTime, List<TimeLabelModel> resultList, List<ShiftTimeVO> shiftTimeList, BigDecimal standardHour) {
        double mixedValue = 0.0;
        for (int i = 0; i < resultList.size(); ++i) {
            TimeLabelModel dateInterval = resultList.get(i);
            if (dateInterval.getBeginTime().getTime() <= OnOffShiftTime[0].getTime() && dateInterval.getBeginTime().getTime() >= OnOffShiftTime[1].getTime()) {
                mixedValue = standardHour.doubleValue();
                break;
            }
            for (int j = 0; j < shiftTimeList.size(); ++j) {
                double intersectTime;
                if (shiftTimeList.get(j).getAttendanceType().equals((Object)AttendanceTypeEnum.fixedOverTime) || shiftTimeList.get(j).getAttendanceType().equals((Object)AttendanceTypeEnum.fixedOTExcludExcep) || !((intersectTime = AtsCalFunctionUtil.getIntersectTimeMinusRestTime(shiftTimeList.get(j), dateInterval.getBeginTime(), dateInterval.getEndTime())) > 0.0)) continue;
                mixedValue += AtsDateUtils.divide(intersectTime, 60.0, decimalPlaces);
            }
        }
        return mixedValue;
    }

    public static List<TimeLabelModel> calDateAndSetForTimeLabel(List<TimeLabelModel> dateList) {
        HashMap<Timestamp, Timestamp> dateMap = new HashMap<Timestamp, Timestamp>();
        for (TimeLabelModel dateInerval : dateList) {
            Timestamp startTime = dateInerval.getBeginTime();
            Timestamp endTime = dateInerval.getEndTime();
            if (dateMap.size() == 0) {
                dateMap.put(startTime, endTime);
            }
            HashMap<Timestamp, Timestamp> tempTimeMap = new HashMap<Timestamp, Timestamp>();
            Iterator iterator = dateMap.entrySet().iterator();
            while (iterator.hasNext()) {
                Map.Entry entry = iterator.next();
                Timestamp start1 = (Timestamp)entry.getKey();
                Timestamp end1 = (Timestamp)entry.getValue();
                if (startTime.compareTo(end1) >= 0 || endTime.compareTo(start1) <= 0) {
                    tempTimeMap.put(startTime, endTime);
                    continue;
                }
                if (startTime.before(start1) && endTime.before(end1)) {
                    tempTimeMap.put(startTime, end1);
                    iterator.remove();
                    continue;
                }
                if (startTime.before(start1) && endTime.after(end1)) {
                    tempTimeMap.put(startTime, endTime);
                    iterator.remove();
                    continue;
                }
                if (!startTime.before(end1) || !endTime.after(end1)) continue;
                tempTimeMap.put(start1, endTime);
                iterator.remove();
            }
            dateMap.putAll(tempTimeMap);
        }
        ArrayList<TimeLabelModel> resultList = new ArrayList<TimeLabelModel>();
        for (Map.Entry entry : dateMap.entrySet()) {
            resultList.add(new TimeLabelModel((Timestamp)entry.getKey(), (Timestamp)entry.getValue(), "trip"));
        }
        return resultList;
    }

    public static Timestamp[] getOnOffShiftTime(AtsShiftInfo shiftInfo, String attendDate) {
        String shiftEarlyTime = FetchCardUtil.getShiftTime(shiftInfo, attendDate, "1,1");
        String shiftEndTime = "";
        if (shiftInfo.getItems().size() == 1) {
            shiftEndTime = FetchCardUtil.getShiftTime(shiftInfo, attendDate, "1,2");
        } else if (shiftInfo.getItems().size() == 2) {
            shiftEndTime = shiftInfo.getItems().get(1).getAttendanceType().equals((Object)AttendanceTypeEnum.fixedOverTime) || shiftInfo.getItems().get(1).getAttendanceType().equals((Object)AttendanceTypeEnum.fixedOTExcludExcep) ? FetchCardUtil.getShiftTime(shiftInfo, attendDate, "1,2") : FetchCardUtil.getShiftTime(shiftInfo, attendDate, "2,2");
        } else if (shiftInfo.getItems().size() == 3) {
            shiftEndTime = shiftInfo.getItems().get(2).getAttendanceType().equals((Object)AttendanceTypeEnum.fixedOverTime) || shiftInfo.getItems().get(2).getAttendanceType().equals((Object)AttendanceTypeEnum.fixedOTExcludExcep) ? (shiftInfo.getItems().get(1).getAttendanceType().equals((Object)AttendanceTypeEnum.fixedOverTime) || shiftInfo.getItems().get(1).getAttendanceType().equals((Object)AttendanceTypeEnum.fixedOTExcludExcep) ? FetchCardUtil.getShiftTime(shiftInfo, attendDate, "1,2") : FetchCardUtil.getShiftTime(shiftInfo, attendDate, "2,2")) : FetchCardUtil.getShiftTime(shiftInfo, attendDate, "3,2");
        }
        return new Timestamp[]{AtsDateUtils.stringToTimestamp(shiftEarlyTime), AtsDateUtils.stringToTimestamp(shiftEndTime)};
    }

    public static Timestamp[] getHeadTailOutTime(Map globalMap, String personId, String date) {
        String key = personId + "_" + date;
        Map attendanceFileInfoMap = (Map)globalMap.get("T_HR_ATS_AttendanceFile");
        AttendanceFileInfo attendanceFileInfo = (AttendanceFileInfo)attendanceFileInfoMap.get(key);
        if (attendanceFileInfo.getIsAttendance().getValue().equals("1")) {
            return FetchCardUtil.getHeadAndTailOutShiftTime(globalMap, personId, date);
        }
        return FetchCardUtil.getHeadAndTailOutDefTime(globalMap, personId, date);
    }

    public static TimeLabelModel getHeadTailOutTimeLableModel(Map globalMap, String personId, String date) {
        Timestamp[] headTailOutTime = AtsCalculateTimeUtil.getHeadTailOutTime(globalMap, personId, date);
        if (null != headTailOutTime) {
            return new TimeLabelModel(headTailOutTime[0], headTailOutTime[1], "outShift");
        }
        return null;
    }

    public static AtsShiftInfo getAtsShiftInfo(String personId, String date, Map globalMap) {
        List scheduleShiftInfoList;
        Map attendanceFileInfoMap = (Map)globalMap.get("T_HR_ATS_AttendanceFile");
        Map atsShiftInfoMap = (Map)globalMap.get("T_HR_ATS_Shift");
        String key = personId + "_" + date;
        Map scheduleShiftItemMap = (Map)globalMap.get("T_HR_ATS_ScheduleShift");
        ScheduleShiftInfo sheduleshiftinfo = null;
        if (null != scheduleShiftItemMap && scheduleShiftItemMap.size() > 0 && (scheduleShiftInfoList = (List)scheduleShiftItemMap.get(key)) != null && scheduleShiftInfoList.size() > 0) {
            sheduleshiftinfo = (ScheduleShiftInfo)scheduleShiftInfoList.get(0);
        }
        AtsShiftInfo shiftInfo = AtsCalculateTimeUtil.assembleAtsShiftInfo(key, sheduleshiftinfo, attendanceFileInfoMap, atsShiftInfoMap);
        return shiftInfo;
    }

    public static AtsShiftInfo assembleAtsShiftInfo(Object key, ScheduleShiftInfo scheduleshiftinfo, Map<String, AttendanceFileInfo> attendanceFileInfoMap, Map<String, AtsShiftInfo> allShiftInfoMap) {
        AtsShiftInfo shiftInfo;
        block6: {
            ScheduleShiftItemCollection scheduleColl;
            AtsShiftItemCollection shiftColl;
            block7: {
                String shiftId = "";
                if (null != scheduleshiftinfo && scheduleshiftinfo.getDefaultShift() != null) {
                    shiftId = scheduleshiftinfo.getDefaultShift().getId().toString();
                } else {
                    AtsShiftInfo defaultShiftInfo = attendanceFileInfoMap.get(key).getAtsShift();
                    if (defaultShiftInfo != null) {
                        shiftId = defaultShiftInfo.getId().toString();
                    }
                }
                shiftInfo = null;
                if (null == allShiftInfoMap.get(shiftId) || (shiftInfo = (AtsShiftInfo)allShiftInfoMap.get(shiftId).clone()) == null) break block6;
                shiftColl = shiftInfo.getItems();
                scheduleColl = new ScheduleShiftItemCollection();
                if (scheduleshiftinfo != null) {
                    scheduleColl = scheduleshiftinfo.getItems();
                    shiftInfo.setIsElastic(scheduleshiftinfo.isIsElastic());
                    shiftInfo.setElasticType(scheduleshiftinfo.getElasticType());
                    shiftInfo.setElasticDirection(scheduleshiftinfo.getElasticDirection());
                    shiftInfo.setElasticValue(scheduleshiftinfo.getElasticValue());
                    shiftInfo.setStandardHour(scheduleshiftinfo.getStandardHour());
                }
                if (shiftColl.size() != scheduleColl.size()) break block7;
                for (int j = 0; j < scheduleColl.size(); ++j) {
                    shiftColl.get(j).setPreTime(scheduleColl.get(j).getPreTime());
                    shiftColl.get(j).setNextTime(scheduleColl.get(j).getNextTime());
                    shiftColl.get(j).setPreIsPunchCard(scheduleColl.get(j).getPreIsPunchCard());
                    shiftColl.get(j).setNextIsPunchCard(scheduleColl.get(j).getNextIsPunchCard());
                    shiftColl.get(j).setPreTimeDayType(scheduleColl.get(j).getPreTimeDayType());
                    shiftColl.get(j).setNextTimeDayType(scheduleColl.get(j).getNextTimeDayType());
                    shiftColl.get(j).setSegment(scheduleColl.get(j).getSegment());
                    shiftColl.get(j).setPreFloatAdjusted(scheduleColl.get(j).getPreFloatAdjusted());
                    shiftColl.get(j).setNextFloatAdjusted(scheduleColl.get(j).getNextFloatAdjusted());
                    shiftColl.get(j).setRestPreTime(scheduleColl.get(j).getRestPreTime());
                    shiftColl.get(j).setRestNextTime(scheduleColl.get(j).getRestNextTime());
                    shiftColl.get(j).setSegmentInRest(scheduleColl.get(j).getSegmentInRest());
                    shiftColl.get(j).setAttendanceType(scheduleColl.get(j).getAttendanceType());
                }
                break block6;
            }
            if (scheduleColl.size() <= 0) break block6;
            shiftColl = new AtsShiftItemCollection();
            AtsShiftItemInfo shiftItemInfo = null;
            for (int m = 0; m < scheduleColl.size(); ++m) {
                shiftItemInfo = new AtsShiftItemInfo();
                shiftItemInfo.setPreTime(scheduleColl.get(m).getPreTime());
                shiftItemInfo.setNextTime(scheduleColl.get(m).getNextTime());
                shiftItemInfo.setPreIsPunchCard(scheduleColl.get(m).getPreIsPunchCard());
                shiftItemInfo.setNextIsPunchCard(scheduleColl.get(m).getNextIsPunchCard());
                shiftItemInfo.setPreTimeDayType(scheduleColl.get(m).getPreTimeDayType());
                shiftItemInfo.setNextTimeDayType(scheduleColl.get(m).getNextTimeDayType());
                shiftItemInfo.setSegment(scheduleColl.get(m).getSegment());
                shiftItemInfo.setPreFloatAdjusted(scheduleColl.get(m).getPreFloatAdjusted());
                shiftItemInfo.setNextFloatAdjusted(scheduleColl.get(m).getNextFloatAdjusted());
                shiftItemInfo.setRestPreTime(scheduleColl.get(m).getRestPreTime());
                shiftItemInfo.setRestNextTime(scheduleColl.get(m).getRestNextTime());
                shiftItemInfo.setSegmentInRest(scheduleColl.get(m).getSegmentInRest());
                shiftItemInfo.setAttendanceType(scheduleColl.get(m).getAttendanceType());
                shiftColl.add(shiftItemInfo);
            }
        }
        return shiftInfo;
    }

    public static Map<String, Object> getScheduleShiftDetail(AtsShiftInfo shiftInfo, String date) {
        HashMap<String, Object> scheduleMap = new HashMap<String, Object>();
        String oneOnTimeSchedule = FetchCardUtil.getShiftTime(shiftInfo, date, "1,1");
        String oneOffTimeSchedule = FetchCardUtil.getShiftTime(shiftInfo, date, "1,2");
        String twoOnTimeSchedule = FetchCardUtil.getShiftTime(shiftInfo, date, "2,1");
        String twoOffTimeSchedule = FetchCardUtil.getShiftTime(shiftInfo, date, "2,2");
        String threeOnTimeSchedule = FetchCardUtil.getShiftTime(shiftInfo, date, "3,1");
        String threeOffTimeSchedule = FetchCardUtil.getShiftTime(shiftInfo, date, "3,2");
        String oneOnePreRestTime = FetchCardUtil.getShiftRestTime(shiftInfo, date, "1,1");
        String oneOneNextRestTime = FetchCardUtil.getShiftRestTime(shiftInfo, date, "1,2");
        ArrayList<ShiftTimeVO> shiftTimeList = new ArrayList<ShiftTimeVO>();
        int itemSize = 0;
        if (null != shiftInfo && shiftInfo.getItems() != null) {
            AtsShiftItemCollection shiftItems = shiftInfo.getItems();
            itemSize = shiftInfo.getItems().size();
            AtsShiftItemInfo itemInfo = null;
            ShiftTimeVO shiftTime = null;
            for (int i = 0; i < itemSize; ++i) {
                shiftTime = new ShiftTimeVO();
                itemInfo = shiftItems.get(i);
                if (StringUtils.isNotBlank((String)oneOnePreRestTime) && StringUtils.isNotBlank((String)oneOneNextRestTime)) {
                    shiftTime.setBeginRestTime(AtsDateUtils.stringToTimestamp(oneOnePreRestTime));
                    shiftTime.setEndRestTime(AtsDateUtils.stringToTimestamp(oneOneNextRestTime));
                }
                if (null != itemInfo.getSegmentInRest()) {
                    shiftTime.setSegmentInRest(itemInfo.getSegmentInRest());
                }
                if (i == 0) {
                    shiftTime.setBeginTime(AtsDateUtils.stringToTimestamp(oneOnTimeSchedule));
                    shiftTime.setEndTime(AtsDateUtils.stringToTimestamp(oneOffTimeSchedule));
                } else if (i == 1) {
                    shiftTime.setBeginTime(AtsDateUtils.stringToTimestamp(twoOnTimeSchedule));
                    shiftTime.setEndTime(AtsDateUtils.stringToTimestamp(twoOffTimeSchedule));
                } else if (i == 2) {
                    shiftTime.setBeginTime(AtsDateUtils.stringToTimestamp(threeOnTimeSchedule));
                    shiftTime.setEndTime(AtsDateUtils.stringToTimestamp(threeOffTimeSchedule));
                }
                shiftTime.setAttendanceType(itemInfo.getAttendanceType());
                shiftTimeList.add(shiftTime);
            }
        }
        scheduleMap.put(STANDARDHOUR, shiftInfo.getStandardHour());
        scheduleMap.put(SHIFTTIMELIST, shiftTimeList);
        return scheduleMap;
    }

    public static List<AtsTripBillEntryInfo> calDateAndSet(List<AtsTripBillEntryInfo> tripList, Timestamp shiftStartTime, Timestamp shiftEndTime) {
        HashMap<Timestamp, Timestamp> dateMap = new HashMap<Timestamp, Timestamp>();
        for (AtsTripBillEntryInfo entryInfo : tripList) {
            Timestamp startTime = entryInfo.getRealTripStartTime();
            Timestamp endTime = entryInfo.getRealTripEndTime();
            if (((Date)startTime).getTime() >= shiftEndTime.getTime() || ((Date)endTime).getTime() <= shiftStartTime.getTime()) continue;
            if (entryInfo.isIsAllDay()) {
                startTime = shiftStartTime;
                endTime = shiftEndTime;
            }
            if (dateMap.size() == 0) {
                dateMap.put(startTime, endTime);
            }
            HashMap<Date, Date> tempTimeMap = new HashMap<Date, Date>();
            Iterator iterator = dateMap.entrySet().iterator();
            while (iterator.hasNext()) {
                Map.Entry entry = iterator.next();
                Date start1 = (Date)entry.getKey();
                Date end1 = (Date)entry.getValue();
                if (((Date)startTime).compareTo(end1) >= 0 || ((Date)endTime).compareTo(start1) <= 0) {
                    tempTimeMap.put(startTime, endTime);
                    continue;
                }
                if (startTime.before(start1) && endTime.before(end1)) {
                    tempTimeMap.put(startTime, end1);
                    iterator.remove();
                    continue;
                }
                if (startTime.before(start1) && endTime.after(end1)) {
                    tempTimeMap.put(startTime, endTime);
                    iterator.remove();
                    continue;
                }
                if (!startTime.before(end1) || !endTime.after(end1)) continue;
                tempTimeMap.put(start1, endTime);
                iterator.remove();
            }
            dateMap.putAll(tempTimeMap);
        }
        ArrayList<AtsTripBillEntryInfo> resultList = new ArrayList<AtsTripBillEntryInfo>();
        for (Map.Entry entry : dateMap.entrySet()) {
            AtsTripBillEntryInfo info = new AtsTripBillEntryInfo();
            info.setRealTripStartTime(new Timestamp(((Date)entry.getKey()).getTime()));
            info.setRealTripEndTime(new Timestamp(((Date)entry.getValue()).getTime()));
            resultList.add(info);
        }
        return resultList;
    }

    public static List<DateInterVal> calDateAndSet(List<DateInterVal> dateList) {
        HashMap<Date, Date> dateMap = new HashMap<Date, Date>();
        for (DateInterVal dateInerval : dateList) {
            Date startTime = dateInerval.getBeginDate();
            Date endTime = dateInerval.getEndDate();
            if (dateMap.size() == 0) {
                dateMap.put(startTime, endTime);
            }
            HashMap<Date, Date> tempTimeMap = new HashMap<Date, Date>();
            Iterator iterator = dateMap.entrySet().iterator();
            while (iterator.hasNext()) {
                Map.Entry entry = iterator.next();
                Date start1 = (Date)entry.getKey();
                Date end1 = (Date)entry.getValue();
                if (startTime.compareTo(end1) >= 0 || endTime.compareTo(start1) <= 0) {
                    tempTimeMap.put(startTime, endTime);
                    continue;
                }
                if (startTime.before(start1) && endTime.before(end1)) {
                    tempTimeMap.put(startTime, end1);
                    iterator.remove();
                    continue;
                }
                if (startTime.before(start1) && endTime.after(end1)) {
                    tempTimeMap.put(startTime, endTime);
                    iterator.remove();
                    continue;
                }
                if (!startTime.before(end1) || !endTime.after(end1)) continue;
                tempTimeMap.put(start1, endTime);
                iterator.remove();
            }
            dateMap.putAll(tempTimeMap);
        }
        ArrayList<DateInterVal> resultList = new ArrayList<DateInterVal>();
        for (Map.Entry entry : dateMap.entrySet()) {
            resultList.add(new DateInterVal((Date)entry.getKey(), (Date)entry.getValue()));
        }
        return resultList;
    }
}

