/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.hr.ats.calculate.state.util;

import com.kingdee.bos.Context;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.basedata.person.PersonInfo;
import com.kingdee.eas.hr.ats.AtsCommonResEnum;
import com.kingdee.eas.hr.ats.AtsLogProcessEnum;
import com.kingdee.eas.hr.ats.AttencePolicyInfo;
import com.kingdee.eas.hr.ats.AttendanceFileInfo;
import com.kingdee.eas.hr.ats.AttendanceLogEntryInfo;
import com.kingdee.eas.hr.ats.AttendanceLogInfo;
import com.kingdee.eas.hr.ats.calculate.state.CalculateState;
import com.kingdee.eas.hr.ats.calculate.state.factory.CalculateStateFactory;
import com.kingdee.eas.hr.ats.calculate.state.vo.CalculateStatusVO;
import com.kingdee.eas.hr.ats.util.common.AtsCalCommonUtils;
import com.kingdee.eas.hr.ats.util.common.MLUtile;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.Date;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;

public class AtsStateCalLogUtil {
    public static final String ONE = "1";
    public static final String ZERO = "0";

    public static boolean dealExceptionLogs(Context ctx, Map<Object, Object> globalMap, String personDate, String projectClassName, Exception e, BOSUuid logId) {
        try {
            AttendanceFileInfo attendanceFileInfo;
            Map logEntryMap = (Map)globalMap.get("logEntryInfo");
            String errorMsg = AtsStateCalLogUtil.getStackTraceMsg(ctx, e, 2);
            CalculateStatusVO calculateStatusVO = new CalculateStatusVO();
            calculateStatusVO.setCtx(ctx);
            calculateStatusVO.setPersonDate(personDate);
            calculateStatusVO.setProjectClassName(projectClassName);
            calculateStatusVO.setErrorMsg(errorMsg);
            calculateStatusVO.setLogEntryMap(logEntryMap);
            calculateStatusVO.setParamMap(globalMap);
            calculateStatusVO.setLogId(logId);
            Map attendanceFileInfoMap = (Map)globalMap.get("T_HR_ATS_AttendanceFile");
            if (null != attendanceFileInfoMap && null != (attendanceFileInfo = (AttendanceFileInfo)attendanceFileInfoMap.get(personDate)) && null != attendanceFileInfo.getAttencePolicy()) {
                AttencePolicyInfo policyInfo;
                AttencePolicyInfo attencePolicyInfo = attendanceFileInfo.getAttencePolicy();
                Map policyInfoMap = (Map)globalMap.get("T_HR_ATS_AttencePolicy");
                if (null != policyInfoMap && null != (policyInfo = (AttencePolicyInfo)policyInfoMap.get(attencePolicyInfo.getId().toString()))) {
                    AtsLogProcessEnum atsLogProcessEnum = AtsStateCalLogUtil.getAtsLogProcess(personDate, projectClassName, policyInfo);
                    CalculateState calculateState = CalculateStateFactory.getInstance().createCalculateState(atsLogProcessEnum);
                    calculateState.handle(calculateStatusVO);
                    return true;
                }
            }
        }
        catch (Exception e1) {
            e1.printStackTrace();
        }
        return false;
    }

    public static AtsLogProcessEnum getAtsLogProcess(String key, String projectClassName, AttencePolicyInfo policyInfo) {
        AtsLogProcessEnum logProcessEnum = AtsLogProcessEnum.other;
        if (projectClassName.equalsIgnoreCase("com.kingdee.shr.ats.calculate.implement.PrepareDataPro")) {
            logProcessEnum = AtsLogProcessEnum.prepareData;
        } else if (projectClassName.equalsIgnoreCase(policyInfo.getFetchCardExcutor()) || projectClassName.equalsIgnoreCase(AtsCalCommonUtils.setCalServer("com.kingdee.shr.ats.calculate.{0}.FetchCardPro"))) {
            logProcessEnum = AtsLogProcessEnum.fetchCard;
        } else if (projectClassName.equalsIgnoreCase(policyInfo.getExceptionProExcutor()) || projectClassName.equalsIgnoreCase(AtsCalCommonUtils.setCalServer("com.kingdee.shr.ats.calculate.{0}.PunchardExceptionPro"))) {
            logProcessEnum = AtsLogProcessEnum.exception;
        } else if (projectClassName.equalsIgnoreCase(policyInfo.getPunchcardOTBProExcutor()) || projectClassName.equalsIgnoreCase(policyInfo.getNoPunchcardOTBProExcutor()) || projectClassName.equalsIgnoreCase(AtsCalCommonUtils.setCalServer("com.kingdee.shr.ats.calculate.{0}.PunchardOverTimeBillPro")) || projectClassName.equalsIgnoreCase(AtsCalCommonUtils.setCalServer("com.kingdee.shr.ats.calculate.{0}.NoPunchardOverTimeBillPro"))) {
            logProcessEnum = AtsLogProcessEnum.overTime;
        } else if (projectClassName.equalsIgnoreCase(policyInfo.getPunchcardLBProExcutor()) || projectClassName.equalsIgnoreCase(policyInfo.getNoPunchcardLBProExcutor()) || projectClassName.equalsIgnoreCase(AtsCalCommonUtils.setCalServer("com.kingdee.shr.ats.calculate.{0}.PunchardLeaveBillPro")) || projectClassName.equalsIgnoreCase(AtsCalCommonUtils.setCalServer("com.kingdee.shr.ats.calculate.{0}.NoPunchardLeaveBillPro"))) {
            logProcessEnum = AtsLogProcessEnum.leaveBill;
        } else if (projectClassName.equalsIgnoreCase(policyInfo.getPunchcardTBProExcutor()) || projectClassName.equalsIgnoreCase(policyInfo.getNoPunchcardTBProExcutor()) || projectClassName.equalsIgnoreCase(AtsCalCommonUtils.setCalServer("com.kingdee.shr.ats.calculate.{0}.PunchardTripBillPro")) || projectClassName.equalsIgnoreCase(AtsCalCommonUtils.setCalServer("com.kingdee.shr.ats.calculate.{0}.NoPunchardTripBillPro"))) {
            logProcessEnum = AtsLogProcessEnum.tripBill;
        } else if (projectClassName.equalsIgnoreCase(policyInfo.getPunchcardOtherProExcutor()) || projectClassName.equalsIgnoreCase(policyInfo.getNoPunchcardOtherProExcutor()) || projectClassName.equalsIgnoreCase(AtsCalCommonUtils.setCalServer("com.kingdee.shr.ats.calculate.{0}.PunchardOtherPro")) || projectClassName.equalsIgnoreCase(AtsCalCommonUtils.setCalServer("com.kingdee.shr.ats.calculate.{0}.NoPunchardOtherPro"))) {
            logProcessEnum = AtsLogProcessEnum.other;
        } else if (projectClassName.equalsIgnoreCase("com.kingdee.shr.ats.calculate.implement.SaveDataPro")) {
            logProcessEnum = AtsLogProcessEnum.saveData;
        } else if (projectClassName.equalsIgnoreCase("com.kingdee.shr.ats.calculate.implement.FormulaPrepareDataPro")) {
            logProcessEnum = AtsLogProcessEnum.formulaPrepareData;
        } else if (projectClassName.equalsIgnoreCase("com.kingdee.shr.ats.calculate.implement.FormulaCalPro")) {
            logProcessEnum = AtsLogProcessEnum.formulaCal;
        } else if (projectClassName.equalsIgnoreCase("com.kingdee.shr.ats.calculate.implement.FormulaSaveDataPro")) {
            logProcessEnum = AtsLogProcessEnum.formulaSaveData;
        }
        return logProcessEnum;
    }

    public static String genAtsLogProcessStatus(AtsLogProcessEnum logProcessEnum, String status) {
        String processStatus = "";
        int statusEnumSize = AtsLogProcessEnum.getEnumList().size();
        int logProcessValue = logProcessEnum.getValue();
        if (StringUtils.isEmpty((CharSequence)status)) {
            StringBuilder statusStr = new StringBuilder();
            for (int i = 0; i < statusEnumSize; ++i) {
                if (i == logProcessValue) {
                    statusStr.append(ONE);
                    continue;
                }
                statusStr.append(ZERO);
            }
            processStatus = statusStr.toString();
        } else {
            processStatus = status.substring(0, logProcessValue) + ONE + status.substring(logProcessValue + 1);
        }
        return processStatus;
    }

    public static AtsLogProcessEnum getAtsLogProcessEnum(String status) {
        AtsLogProcessEnum atsLogProcessEnum = null;
        try {
            List atsLogEnumList = AtsLogProcessEnum.getEnumList();
            String[] statusList = status.split("");
            if (!StringUtils.isEmpty((CharSequence)status) && status.contains(ONE) && statusList.length == atsLogEnumList.size()) {
                for (int i = 0; i < statusList.length; ++i) {
                    if (!statusList[i].equals(ONE)) continue;
                    return (AtsLogProcessEnum)((Object)atsLogEnumList.get(i));
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return atsLogProcessEnum;
    }

    public static AttendanceLogEntryInfo generateLogEntry(String personId, Date date, String errorMsg, BOSUuid loginfoId, String status) {
        PersonInfo personInfo = new PersonInfo();
        personInfo.setId(BOSUuid.read((String)personId));
        AttendanceLogEntryInfo entryInfo = new AttendanceLogEntryInfo();
        entryInfo.setExcepMsg(errorMsg);
        entryInfo.setAttendDate(date);
        entryInfo.setPerson(personInfo);
        entryInfo.setStatus(status);
        AttendanceLogInfo loginfo = new AttendanceLogInfo();
        loginfo.setId(loginfoId);
        entryInfo.setGroup(loginfo);
        return entryInfo;
    }

    public static AttendanceLogEntryInfo generateLogEntry(String personId, Date date, String errorMsg, String status) {
        PersonInfo personInfo = new PersonInfo();
        personInfo.setId(BOSUuid.read((String)personId));
        AttendanceLogEntryInfo entryInfo = new AttendanceLogEntryInfo();
        entryInfo.setExcepMsg(errorMsg);
        entryInfo.setAttendDate(date);
        entryInfo.setPerson(personInfo);
        entryInfo.setStatus(status);
        return entryInfo;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String getStackTraceInfo(Context ctx, Exception e) {
        StringWriter sw = null;
        PrintWriter pw = null;
        try {
            sw = new StringWriter();
            pw = new PrintWriter(sw);
            e.printStackTrace(pw);
            pw.flush();
            sw.flush();
            String string = sw.toString();
            return string;
        }
        catch (Exception ex) {
            String string = MLUtile.getRes(AtsCommonResEnum.GoError, ctx);
            return string;
        }
        finally {
            if (sw != null) {
                try {
                    sw.close();
                }
                catch (IOException e1) {
                    e1.printStackTrace();
                }
            }
            if (pw != null) {
                pw.close();
            }
        }
    }

    public static String getStackTraceMsg(Context ctx, Exception e, int FexcepMsgLen) {
        String[] excepMsgArry = AtsStateCalLogUtil.getStackTraceInfo(ctx, e).split("\\n");
        String FexcepMsg = "";
        for (int logi = 0; logi < excepMsgArry.length && logi <= FexcepMsgLen; ++logi) {
            FexcepMsg = FexcepMsg + excepMsgArry[logi];
        }
        return FexcepMsg;
    }
}

