/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.hr.ats.calculate.time.dataProcess.impl;

import com.kingdee.eas.hr.ats.AtsShiftInfo;
import com.kingdee.eas.hr.ats.AtsTripBillEntryInfo;
import com.kingdee.eas.hr.ats.calculate.time.dataProcess.impl.TripTimeDataProcessImpl;
import com.kingdee.eas.hr.ats.calculate.time.model.TimeLabelModel;
import com.kingdee.eas.hr.ats.calculate.time.util.TimeRangeUnion;
import com.kingdee.eas.hr.ats.calculate.time.vo.TimeDataVO;
import com.kingdee.eas.hr.ats.util.FetchCardUtil;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class TripOutShiftTimeDataProcessImpl
extends TripTimeDataProcessImpl {
    @Override
    public List<TimeLabelModel> process(TimeDataVO timeDataVO) {
        Map<String, AtsShiftInfo> atsShiftMap;
        List coreBaseInfoList = timeDataVO.getCoreBaseInfoList();
        List<TimeLabelModel> timeLabelModels = new ArrayList<TimeLabelModel>();
        TimeLabelModel headTailOutTime = timeDataVO.getHeadTailOutTime();
        if (null != coreBaseInfoList && coreBaseInfoList.size() > 0 && null != (atsShiftMap = timeDataVO.getAtsShiftMap()) && atsShiftMap.size() > 0) {
            TimeLabelModel timeLabelModel = this.getShiftTime(atsShiftMap.values().iterator().next(), timeDataVO.getDate());
            Set<String> calOutDate = FetchCardUtil.getCalOutShiftDate(coreBaseInfoList, timeDataVO.getDate(), new Timestamp[]{headTailOutTime.getBeginTime(), headTailOutTime.getEndTime()});
            if (calOutDate.contains(timeDataVO.getDate())) {
                for (AtsTripBillEntryInfo atsTripBillEntryInfo : coreBaseInfoList) {
                    if (atsTripBillEntryInfo.isIsAllDay() && null != timeLabelModel) {
                        timeLabelModels.add(new TimeLabelModel(timeLabelModel.getBeginTime(), timeLabelModel.getEndTime(), "trip"));
                        continue;
                    }
                    timeLabelModels.add(new TimeLabelModel(atsTripBillEntryInfo.getRealTripStartTime(), atsTripBillEntryInfo.getRealTripEndTime(), "trip"));
                }
                timeLabelModels = TimeRangeUnion.union(timeLabelModels);
            }
        }
        timeLabelModels.add(headTailOutTime);
        return timeLabelModels;
    }
}

