/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.hr.ats.calculate.time.dataProcess.impl;

import com.kingdee.eas.hr.ats.AtsShiftInfo;
import com.kingdee.eas.hr.ats.AtsShiftItemCollection;
import com.kingdee.eas.hr.ats.AtsTripBillEntryInfo;
import com.kingdee.eas.hr.ats.calculate.time.dataProcess.impl.BaseTimeDataProcess;
import com.kingdee.eas.hr.ats.calculate.time.model.TimeLabelModel;
import com.kingdee.eas.hr.ats.calculate.time.util.TimeRangeUnion;
import com.kingdee.eas.hr.ats.calculate.time.vo.TimeDataVO;
import com.kingdee.eas.hr.ats.util.AtsDateUtils;
import com.kingdee.eas.hr.ats.util.FetchCardUtil;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

public class TripTimeDataProcessImpl
extends BaseTimeDataProcess {
    @Override
    public List<TimeLabelModel> process(TimeDataVO timeDataVO) {
        Map<String, AtsShiftInfo> atsShiftMap;
        List coreBaseInfoList = timeDataVO.getCoreBaseInfoList();
        ArrayList<TimeLabelModel> timeLabelModels = new ArrayList<TimeLabelModel>();
        if (null != coreBaseInfoList && coreBaseInfoList.size() > 0 && null != (atsShiftMap = timeDataVO.getAtsShiftMap()) && atsShiftMap.size() > 0) {
            TimeLabelModel timeLabelModel = this.getShiftTime(atsShiftMap.values().iterator().next(), timeDataVO.getDate());
            for (AtsTripBillEntryInfo atsTripBillEntryInfo : coreBaseInfoList) {
                if (atsTripBillEntryInfo.isIsAllDay() && null != timeLabelModel) {
                    timeLabelModels.add(new TimeLabelModel(timeLabelModel.getBeginTime(), timeLabelModel.getEndTime(), "trip"));
                    continue;
                }
                timeLabelModels.add(new TimeLabelModel(atsTripBillEntryInfo.getRealTripStartTime(), atsTripBillEntryInfo.getRealTripEndTime(), "trip"));
            }
        }
        return TimeRangeUnion.union(timeLabelModels);
    }

    public TimeLabelModel getShiftTime(AtsShiftInfo shiftInfo, String date) {
        if (null != shiftInfo && shiftInfo.getItems() != null) {
            AtsShiftItemCollection shiftItems = shiftInfo.getItems();
            for (int i = 0; i < shiftItems.size(); ++i) {
                if (shiftItems.size() == 1) {
                    String oneOnTimeSchedule = FetchCardUtil.getShiftTime(shiftInfo, date, "1,1");
                    String oneOffTimeSchedule = FetchCardUtil.getShiftTime(shiftInfo, date, "1,2");
                    return new TimeLabelModel(AtsDateUtils.stringToTimestamp(oneOnTimeSchedule), AtsDateUtils.stringToTimestamp(oneOffTimeSchedule), "shift");
                }
                if (shiftItems.size() == 2) {
                    String twoOnTimeSchedule = FetchCardUtil.getShiftTime(shiftInfo, date, "2,1");
                    String twoOffTimeSchedule = FetchCardUtil.getShiftTime(shiftInfo, date, "2,2");
                    return new TimeLabelModel(AtsDateUtils.stringToTimestamp(twoOnTimeSchedule), AtsDateUtils.stringToTimestamp(twoOffTimeSchedule), "shift");
                }
                if (shiftItems.size() != 3) continue;
                String threeOnTimeSchedule = FetchCardUtil.getShiftTime(shiftInfo, date, "3,1");
                String threeOffTimeSchedule = FetchCardUtil.getShiftTime(shiftInfo, date, "3,2");
                return new TimeLabelModel(AtsDateUtils.stringToTimestamp(threeOnTimeSchedule), AtsDateUtils.stringToTimestamp(threeOffTimeSchedule), "shift");
            }
        }
        return null;
    }
}

