/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.hr.ats.calculate.time.strategy.context;

import com.kingdee.eas.hr.ats.calculate.time.model.TimeLabelListModel;
import com.kingdee.eas.hr.ats.calculate.time.model.TimeLabelModel;
import com.kingdee.eas.hr.ats.calculate.time.strategy.CalculatorStrategy;
import com.kingdee.eas.hr.ats.calculate.time.util.TimeSegmentMarkUtil;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang.StringUtils;

public class AtsCalculatorContext {
    private CalculatorStrategy timeStrategy;

    public AtsCalculatorContext(CalculatorStrategy timeStrategy) {
        this.timeStrategy = timeStrategy;
    }

    public double executeStrategy(List<TimeLabelModel> timeLabelModels, List<String> labels, List<String> excludeLabels) {
        this.removeLabelModels(timeLabelModels, labels, excludeLabels);
        return this.timeStrategy.calculate(timeLabelModels, labels, excludeLabels);
    }

    public double executeStrategy(List<TimeLabelModel> timeLabelModels, List<String> labels, String excludeLabel) {
        ArrayList<String> excludeLabels = new ArrayList<String>();
        if (StringUtils.isNotEmpty((String)excludeLabel)) {
            excludeLabels.add(excludeLabel);
        }
        this.removeLabelModels(timeLabelModels, labels, excludeLabels);
        return this.timeStrategy.calculate(timeLabelModels, labels, excludeLabels);
    }

    public double executeStrategy(List<TimeLabelModel> timeLabelModels, String label, String excludeLabel) {
        ArrayList<String> labels = new ArrayList<String>();
        labels.add(label);
        ArrayList<String> excludeLabels = new ArrayList<String>();
        if (StringUtils.isNotEmpty((String)excludeLabel)) {
            excludeLabels.add(excludeLabel);
        }
        this.removeLabelModels(timeLabelModels, labels, excludeLabels);
        return this.timeStrategy.calculate(timeLabelModels, labels, excludeLabels);
    }

    public List<TimeLabelListModel> executeStrategySegmentMark(List<TimeLabelModel> timeLabelModels, List<String> labels, List<String> excludeLabels) {
        this.removeLabelModels(timeLabelModels, labels, excludeLabels);
        return this.timeStrategy.segmentMark(timeLabelModels, labels, excludeLabels);
    }

    public List<TimeLabelListModel> executeStrategySegmentMark(List<TimeLabelModel> timeLabelModels, List<String> labels, String excludeLabel) {
        ArrayList<String> excludeLabels = new ArrayList<String>();
        if (StringUtils.isNotEmpty((String)excludeLabel)) {
            excludeLabels.add(excludeLabel);
        }
        this.removeLabelModels(timeLabelModels, labels, excludeLabels);
        return this.timeStrategy.segmentMark(timeLabelModels, labels, excludeLabels);
    }

    public List<TimeLabelListModel> executeStrategySegmentMark(List<TimeLabelModel> timeLabelModels, String label, String excludeLabel) {
        ArrayList<String> labels = new ArrayList<String>();
        labels.add(label);
        ArrayList<String> excludeLabels = new ArrayList<String>();
        excludeLabels.add(excludeLabel);
        this.removeLabelModels(timeLabelModels, labels, excludeLabels);
        return this.timeStrategy.segmentMark(timeLabelModels, labels, excludeLabels);
    }

    public void removeLabelModels(List<TimeLabelModel> timeLabelModels, List<String> labels, List<String> excludeLabels) {
        ArrayList<String> allLabels = new ArrayList<String>();
        allLabels.addAll(labels);
        allLabels.addAll(excludeLabels);
        TimeSegmentMarkUtil.removeTimeLabel(timeLabelModels, allLabels);
    }
}

