/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.hr.ats.calculate.time.util;

import com.kingdee.eas.hr.ats.calculate.time.model.TimeIntervalModel;
import com.kingdee.eas.hr.ats.calculate.time.model.TimeLabelModel;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;

public class TimeRangeUnion {
    public static TimeLabelModel union(TimeLabelModel timeIntervalModelA, TimeLabelModel timeIntervalModelB) {
        if (timeIntervalModelB.getBeginTime().after(timeIntervalModelA.getEndTime()) || timeIntervalModelB.getEndTime().before(timeIntervalModelA.getBeginTime())) {
            return null;
        }
        Timestamp unionStart = timeIntervalModelA.getBeginTime().before(timeIntervalModelB.getBeginTime()) ? timeIntervalModelA.getBeginTime() : timeIntervalModelB.getBeginTime();
        Timestamp unionEnd = timeIntervalModelA.getEndTime().after(timeIntervalModelB.getEndTime()) ? timeIntervalModelA.getEndTime() : timeIntervalModelB.getEndTime();
        return new TimeLabelModel(unionStart, unionEnd);
    }

    public static List<TimeLabelModel> union(List<TimeLabelModel> timeIntervalModels) {
        if (timeIntervalModels == null || timeIntervalModels.size() <= 1) {
            return timeIntervalModels;
        }
        timeIntervalModels.sort(Comparator.comparing(TimeIntervalModel::getBeginTime));
        ArrayList<TimeLabelModel> mergedPeriods = new ArrayList<TimeLabelModel>();
        Timestamp currentStart = timeIntervalModels.get(0).getBeginTime();
        Timestamp currentEnd = timeIntervalModels.get(0).getEndTime();
        for (TimeLabelModel period : timeIntervalModels) {
            if (period.getBeginTime().after(currentEnd)) {
                mergedPeriods.add(new TimeLabelModel(currentStart, currentEnd));
                currentStart = period.getBeginTime();
                currentEnd = period.getEndTime();
                continue;
            }
            currentEnd = currentEnd.after(period.getEndTime()) ? currentEnd : period.getEndTime();
        }
        mergedPeriods.add(new TimeLabelModel(currentStart, currentEnd));
        return mergedPeriods;
    }

    public static List<TimeLabelModel> union(TimeLabelModel interval, List<TimeLabelModel> intervals) {
        ArrayList<TimeLabelModel> result = new ArrayList<TimeLabelModel>();
        for (TimeLabelModel i : intervals) {
            if (i.getEndTime().before(interval.getBeginTime()) || i.getBeginTime().after(interval.getEndTime())) {
                result.add(i);
                continue;
            }
            Timestamp unionStart = interval.getBeginTime().before(i.getBeginTime()) ? interval.getBeginTime() : i.getBeginTime();
            Timestamp unionEnd = interval.getEndTime().after(i.getEndTime()) ? interval.getEndTime() : i.getEndTime();
            interval = new TimeLabelModel(unionStart, unionEnd);
        }
        result.add(interval);
        return result;
    }
}

