/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.hr.ats.common;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.db.TempTablePool;
import com.kingdee.eas.util.app.ContextUtil;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.util.StringUtils;

public class AtsTempTableUtil {
    public static String createTempTableCal(Context ctx, String sqlSelect, String table_key, String refresh) throws Exception, BOSException {
        return AtsTempTableUtil.createTempTable(ctx, sqlSelect.toString(), table_key);
    }

    public static boolean isTempTableActive(Context ctx, String tempTableName) {
        if (!StringUtils.isEmpty((String)tempTableName)) {
            try {
                IRowSet rowSet = DbUtil.executeQuery((Context)ctx, (String)("SELECT COUNT(1) T_CNT FROM " + tempTableName));
                return !rowSet.next() || rowSet.getInt("T_CNT") != 0;
            }
            catch (Exception e) {
                return false;
            }
        }
        return false;
    }

    public static String createTempTable(Context ctx, String sqlSelect, String table_key) throws Exception, BOSException {
        String tempTableName = null;
        if (ctx.get((Object)table_key) != null) {
            tempTableName = (String)ctx.get((Object)table_key);
        }
        tempTableName = TempTablePool.getInstance((Context)ctx).createTempTableName();
        ctx.put((Object)table_key, (Object)tempTableName);
        String tempSql = "select * into " + tempTableName + " from (" + sqlSelect + ") T ; ";
        DbUtil.execute((Context)ctx, (String)tempSql.toString());
        String dbType = ContextUtil.getDbType((Context)ctx);
        tempSql = !StringUtils.isEmpty((String)dbType) && (dbType.equalsIgnoreCase("Oracle") || dbType.startsWith("Oracle")) ? "CREATE  INDEX " + tempTableName + " ON " + tempTableName + " (FID ASC) ;" : "CREATE  INDEX IX" + tempTableName + " ON " + tempTableName + " (FID ASC) ;";
        DbUtil.execute((Context)ctx, (String)tempSql.toString());
        return tempTableName;
    }

    public static String createTempTable(Context ctx, String sqlSelect) throws Exception, BOSException {
        String tempTableName = TempTablePool.getInstance((Context)ctx).createTempTableName();
        String tempSql = "select * into " + tempTableName + " from (" + sqlSelect + ") T ; ";
        DbUtil.execute((Context)ctx, (String)tempSql.toString());
        String dbType = ContextUtil.getDbType((Context)ctx);
        tempSql = !StringUtils.isEmpty((String)dbType) && (dbType.equalsIgnoreCase("Oracle") || dbType.startsWith("Oracle")) ? "CREATE  INDEX " + tempTableName + " ON " + tempTableName + " (FID ASC) ;" : "CREATE  INDEX IX" + tempTableName + " ON " + tempTableName + " (FID ASC) ;";
        DbUtil.execute((Context)ctx, (String)tempSql.toString());
        return tempTableName;
    }

    public static void releaseTable(Context ctx, String tempTableName) {
        if (!StringUtils.isEmpty((String)tempTableName)) {
            try {
                TempTablePool.getInstance((Context)ctx).releaseTable(tempTableName);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    public static void dropTable(Context ctx, String tempTableName) {
        if (!StringUtils.isEmpty((String)tempTableName)) {
            try {
                DbUtil.execute((Context)ctx, (String)("TRUNCATE TABLE " + tempTableName));
                DbUtil.execute((Context)ctx, (String)("DROP TABLE " + tempTableName));
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    public static String createTempTableSum(Context ctx, String sqlSelect, String table_key, String refresh) throws Exception, BOSException {
        String tempTableName = null;
        if (ctx.get((Object)table_key) != null) {
            tempTableName = (String)ctx.get((Object)table_key);
        }
        if (tempTableName != null) {
            TempTablePool.getInstance((Context)ctx).releaseTable(tempTableName);
        }
        tempTableName = TempTablePool.getInstance((Context)ctx).createTempTableName();
        ctx.put((Object)table_key, (Object)tempTableName);
        String tempSql = "select * into " + tempTableName + " from (" + sqlSelect + ") T ; ";
        DbUtil.execute((Context)ctx, (String)tempSql.toString());
        String dbType = ContextUtil.getDbType((Context)ctx);
        tempSql = !StringUtils.isEmpty((String)dbType) && (dbType.equalsIgnoreCase("Oracle") || dbType.startsWith("Oracle")) ? "CREATE  INDEX " + tempTableName + " ON " + tempTableName + " (FHRORGUNITID,FPROPOSERID,FADMINORGUNITID,FEFFDT,FLEFFDT ASC) ;" : "CREATE  INDEX IX" + tempTableName + " ON " + tempTableName + " (FHRORGUNITID,FPROPOSERID,FADMINORGUNITID,FEFFDT,FLEFFDT ASC) ;";
        DbUtil.execute((Context)ctx, (String)tempSql.toString());
        return tempTableName;
    }

    public static String createTempTableWithIndex(Context ctx, String sqlSelect, String indexColumns) throws Exception, BOSException {
        String tempTableName = TempTablePool.getInstance((Context)ctx).createTempTableName();
        String tempSql = "select * into " + tempTableName + " from (" + sqlSelect + ") T ; ";
        DbUtil.execute((Context)ctx, (String)tempSql.toString());
        String dbType = ContextUtil.getDbType((Context)ctx);
        tempSql = !StringUtils.isEmpty((String)dbType) && (dbType.equalsIgnoreCase("Oracle") || dbType.startsWith("Oracle")) ? "CREATE  INDEX " + tempTableName + " ON " + tempTableName + " (" + indexColumns + " ASC) ;" : "CREATE  INDEX IX" + tempTableName + " ON " + tempTableName + " (" + indexColumns + " ASC) ;";
        DbUtil.execute((Context)ctx, (String)tempSql.toString());
        return tempTableName;
    }

    public static String createTempTableNotIndex(Context ctx, String sqlSelect) throws Exception, BOSException {
        String tempTableName = TempTablePool.getInstance((Context)ctx).createTempTableName();
        String tempSql = "select * into " + tempTableName + " from (" + sqlSelect + ") T ; ";
        DbUtil.execute((Context)ctx, (String)tempSql.toString());
        return tempTableName;
    }
}

