/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.hr.ats.dataLog.control;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.json.JSONUtils;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.hr.ats.dataLog.observer.LogObserver;
import com.kingdee.eas.hr.ats.util.common.ConfigAts;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.commons.lang3.StringUtils;

public abstract class LogControlCenter {
    protected Map<String, List<LogObserver>> observers = new ConcurrentHashMap<String, List<LogObserver>>();
    private static final String LOG_RECORD_SWITCH = "logRecordSwitch";

    private boolean requireLogRecordSwitchFlag() {
        String logRecordType = ConfigAts.getPropertyFromConfig(LOG_RECORD_SWITCH);
        return !StringUtils.isNotEmpty((CharSequence)logRecordType) || !"true".equalsIgnoreCase(logRecordType);
    }

    public void addObserver(LogObserver observer) {
        if (this.requireLogRecordSwitchFlag()) {
            return;
        }
        if (null != observer) {
            observer.setBeanControlCenter(this);
            observer.setCreateTime(new Date());
            String id = observer.getObjectId();
            List<LogObserver> objectlist = this.observers.get(id);
            if (objectlist == null) {
                objectlist = new ArrayList<LogObserver>();
                objectlist.add(observer);
                this.observers.put(id, objectlist);
            } else {
                objectlist.add(observer);
            }
            if (this.hasChanged(observer) && observer.isNeedCheck()) {
                this.notifyObserver(observer);
            }
        }
    }

    public void addObserver(List<LogObserver> observerList) {
        if (null != observerList && observerList.size() > 0) {
            Iterator<LogObserver> iter = observerList.iterator();
            while (iter.hasNext()) {
                this.addObserver(iter.next());
            }
        }
    }

    public void deleteObserver(LogObserver observer) {
        String id;
        List<LogObserver> objectlist;
        if (null != observer && (objectlist = this.observers.get(id = observer.getObjectId())) != null) {
            this.observers.remove(id);
        }
        this.checkObserversMemoryLeak();
    }

    public boolean hasChanged(LogObserver observer) {
        if (null != observer) {
            try {
                String id = observer.getObjectId();
                List<LogObserver> objectlist = this.observers.get(id);
                if (objectlist != null) {
                    LogObserver logObserver2 = null;
                    CoreBaseInfo baseInfo = null;
                    for (LogObserver logObserver2 : objectlist) {
                        baseInfo = logObserver2.getCoreBaseInfo();
                        if (null != baseInfo) {
                            baseInfo.remove("cu");
                            if (logObserver2.isNeedCheck()) {
                                observer.setObjectDesc(JSONUtils.convertObjectToJson((Context)observer.getCtx(), (Object)baseInfo));
                                continue;
                            }
                            if (!StringUtils.isEmpty((CharSequence)observer.getObjectOldDesc())) continue;
                            if (StringUtils.isNotEmpty((CharSequence)logObserver2.getObjectOldDesc())) {
                                observer.setObjectOldDesc(logObserver2.getObjectOldDesc());
                                continue;
                            }
                            observer.setObjectOldDesc(JSONUtils.convertObjectToJson((Context)observer.getCtx(), (Object)baseInfo));
                            continue;
                        }
                        if (logObserver2.isNeedCheck() || !StringUtils.isNotEmpty((CharSequence)logObserver2.getObjectOldDesc()) || !StringUtils.isEmpty((CharSequence)observer.getObjectOldDesc())) continue;
                        observer.setObjectOldDesc(logObserver2.getObjectOldDesc());
                    }
                    return true;
                }
            }
            catch (BOSException e) {
                e.printStackTrace();
            }
        }
        return false;
    }

    public abstract void notifyObserver(LogObserver var1);

    public Map<String, List<LogObserver>> getObservers() {
        return this.observers;
    }

    public void checkObserversMemoryLeak() {
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(new Date());
        calendar.add(10, -2);
        Map<String, List<LogObserver>> observers = this.getObservers();
        try {
            if (!observers.isEmpty()) {
                String key = null;
                LogObserver logObserver2 = null;
                Map.Entry<String, List<LogObserver>> entry = null;
                List<LogObserver> observerList = null;
                Iterator<Map.Entry<String, List<LogObserver>>> iter = observers.entrySet().iterator();
                Iterator<LogObserver> iterList = null;
                while (iter.hasNext()) {
                    entry = iter.next();
                    observerList = entry.getValue();
                    for (LogObserver logObserver2 : observerList) {
                        if (!logObserver2.getCreateTime().before(calendar.getTime())) continue;
                        key = logObserver2.getObjectId();
                        break;
                    }
                    if (key == null || !entry.getKey().equals(key)) continue;
                    iter.remove();
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

