/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.hr.ats.dataLog.factory;

import com.kingdee.eas.hr.ats.OperTypeEnum;
import com.kingdee.eas.hr.ats.dataLog.control.LogControlCenter;
import com.kingdee.eas.hr.ats.dataLog.control.impl.AtsBaseInfoLogControlCenter;
import com.kingdee.eas.hr.ats.dataLog.control.impl.AtsBillLogControlCenter;
import com.kingdee.eas.hr.ats.dataLog.control.impl.AtsLimitLogControlCenter;
import com.kingdee.eas.hr.ats.dataLog.control.impl.AtsResultLogControlCenter;
import com.kingdee.eas.hr.ats.dataLog.control.impl.AtsSumLogControlCenter;
import com.kingdee.eas.hr.ats.dataLog.control.impl.ScheduleShiftLogControlCenter;

public class DataLogControlFactory {
    public LogControlCenter createLogControlCenter(OperTypeEnum operType) {
        if (OperTypeEnum.holidayLimit == operType) {
            return AtsLimitLogControlCenter.getInstance();
        }
        if (OperTypeEnum.baseInfo == operType) {
            return AtsBaseInfoLogControlCenter.getInstance();
        }
        if (OperTypeEnum.atsResult == operType) {
            return AtsResultLogControlCenter.getInstance();
        }
        if (OperTypeEnum.atsResultSum == operType) {
            return AtsSumLogControlCenter.getInstance();
        }
        if (OperTypeEnum.scheduleShift == operType) {
            return ScheduleShiftLogControlCenter.getInstance();
        }
        return AtsBillLogControlCenter.getInstance();
    }

    public static DataLogControlFactory getInstance() {
        return new DataLogControlFactory();
    }
}

