/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.hr.ats.dataLog.service.impl;

import com.kingdee.bos.Context;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.base.permission.UserInfo;
import com.kingdee.eas.hr.ats.AtsBaseInfoDataLogFactory;
import com.kingdee.eas.hr.ats.AtsResultDataLogInfo;
import com.kingdee.eas.hr.ats.DataLogBaseInfo;
import com.kingdee.eas.hr.ats.dataLog.observer.LogObserver;
import com.kingdee.eas.hr.ats.dataLog.observer.impl.AtsBaseInfoDataLogObserver;
import com.kingdee.eas.hr.ats.dataLog.pool.AtsDataLogPool;
import com.kingdee.eas.hr.ats.dataLog.service.DataLogService;
import com.kingdee.eas.hr.ats.dataLog.util.DataLogUtil;
import com.kingdee.shr.base.syssetting.app.filter.HRFilterUtils;
import java.sql.Timestamp;
import java.util.Date;
import org.apache.log4j.Logger;

public class AtsBaseInfoDataLogServiceImpl
implements DataLogService {
    private static Logger logger = Logger.getLogger(AtsBaseInfoDataLogServiceImpl.class);
    public static String ENCODE_CHINESE = "[\u4e00-\u9fa5]*";
    public static String EMPTY_STRING = "";
    public static int LIMIT_FIELD_LEN = 1024;

    @Override
    public void recordLog(final LogObserver observer) {
        Runnable logTask = new Runnable(){

            @Override
            public void run() {
                AtsBaseInfoDataLogServiceImpl.this.saveDataLog(observer);
            }
        };
        AtsDataLogPool.getPool().execute(logTask);
    }

    @Override
    public boolean saveDataLog(LogObserver observer) {
        try {
            DataLogBaseInfo dataLogInfo = this.assembleDataLog(observer);
            if (null != dataLogInfo) {
                AtsBaseInfoDataLogFactory.getLocalInstance(observer.getCtx()).addnew(dataLogInfo);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            logger.error((Object)("save dataLogInfo error, observer objectId:" + observer.getObjectId() + ",error message:" + e.getMessage()));
            return false;
        }
        return true;
    }

    @Override
    public DataLogBaseInfo assembleDataLog(LogObserver observer) {
        if (null == observer.getCtx() || null == observer) {
            return null;
        }
        AtsBaseInfoDataLogObserver logObserver = (AtsBaseInfoDataLogObserver)observer;
        AtsResultDataLogInfo dataLog = new AtsResultDataLogInfo();
        try {
            dataLog.setObjectId(logObserver.getObjectId());
            dataLog.setOperType(logObserver.getOperType());
            dataLog.setOperAction(logObserver.getOperAction());
            String objctOldDesc = logObserver.getObjectOldDesc();
            if (null != objctOldDesc) {
                objctOldDesc = objctOldDesc.substring(0, (objctOldDesc = objctOldDesc.replaceAll(ENCODE_CHINESE, EMPTY_STRING)).length() > LIMIT_FIELD_LEN ? LIMIT_FIELD_LEN : objctOldDesc.length());
            }
            dataLog.setObjectOldDesc(objctOldDesc);
            String objctDesc = logObserver.getObjectDesc();
            if (null != objctDesc) {
                objctDesc = objctDesc.substring(0, (objctDesc = objctDesc.replaceAll(ENCODE_CHINESE, EMPTY_STRING)).length() > LIMIT_FIELD_LEN ? LIMIT_FIELD_LEN : objctDesc.length());
            }
            dataLog.setObjectDesc(objctDesc);
            dataLog.setCreateTime(new Timestamp(System.currentTimeMillis()));
            String creatorId = HRFilterUtils.getCurrentUserId((Context)observer.getCtx());
            UserInfo user = new UserInfo();
            user.setId(BOSUuid.read((String)creatorId));
            dataLog.setCreator(user);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return dataLog;
    }

    @Override
    public boolean deleteDataLogDateAgo(Context ctx, Date date) {
        return DataLogUtil.deleteDataLogDateAgo(ctx, date, "T_ATS_AtsBaseInfoDataLog");
    }
}

