/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.hr.ats.datadump.service.impl;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.eas.hr.ats.DataDumpConfigInfo;
import com.kingdee.eas.hr.ats.datadump.service.IDataDump;
import com.kingdee.eas.hr.ats.datadump.util.DataDumpLog;
import com.kingdee.eas.hr.ats.datadump.util.DataDumpUtil;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Scope;
import org.springframework.stereotype.Component;

@Component(value="CommonDataDumpImpl")
@Scope(value="prototype")
public class CommonDataDumpImpl
implements IDataDump {
    @Autowired
    private DataDumpLog logger;
    protected DataDumpConfigInfo dataDumpConfigInfo;

    @Override
    public DataDumpConfigInfo getDataDumpConfigInfo() {
        return this.dataDumpConfigInfo;
    }

    @Override
    public void setDataDumpConfigInfo(DataDumpConfigInfo dataDumpConfigInfo) {
        this.dataDumpConfigInfo = dataDumpConfigInfo;
    }

    @Override
    public void createDumpTable(Context ctx) throws BOSException {
        this.logger.info(this.dataDumpConfigInfo.getName() + " createDumpTable");
        String tableName = this.dataDumpConfigInfo.getTableName();
        if (this.dataDumpConfigInfo.isIsMultiTable()) {
            Set<String> dumpYearSet = DataDumpUtil.getDumpYearSet(ctx, this.dataDumpConfigInfo);
            for (String dumpYear : dumpYearSet) {
                String dumpYearTableName = this.dataDumpConfigInfo.getDumpTableName() + "_" + dumpYear;
                if (!DataDumpUtil.isTableExists(ctx, dumpYearTableName)) {
                    DataDumpUtil.createDumpTable(ctx, tableName, dumpYearTableName);
                }
                Map<String, Object> fieldUnMatchMap = DataDumpUtil.getFieldUnMatchMap(ctx, tableName, dumpYearTableName);
                DataDumpUtil.addColumn(ctx, dumpYearTableName, fieldUnMatchMap);
                String entryTableName = this.dataDumpConfigInfo.getEntryTableName();
                if (!StringUtils.isNotEmpty((CharSequence)entryTableName) || !StringUtils.isNotEmpty((CharSequence)this.dataDumpConfigInfo.getEntryFilterField())) continue;
                String dumpEntryYearTableName = this.dataDumpConfigInfo.getDumpTableName() + "Entry_" + dumpYear;
                if (!DataDumpUtil.isTableExists(ctx, dumpEntryYearTableName)) {
                    DataDumpUtil.createDumpTable(ctx, entryTableName, dumpEntryYearTableName);
                }
                Map<String, Object> entryFieldUnMatchMap = DataDumpUtil.getFieldUnMatchMap(ctx, entryTableName, dumpEntryYearTableName);
                DataDumpUtil.addColumn(ctx, dumpEntryYearTableName, entryFieldUnMatchMap);
            }
        } else {
            String dumpYearTableName = this.dataDumpConfigInfo.getDumpTableName();
            if (!DataDumpUtil.isTableExists(ctx, dumpYearTableName)) {
                DataDumpUtil.createDumpTable(ctx, tableName, dumpYearTableName);
            }
            Map<String, Object> fieldUnMatchMap = DataDumpUtil.getFieldUnMatchMap(ctx, tableName, dumpYearTableName);
            DataDumpUtil.addColumn(ctx, dumpYearTableName, fieldUnMatchMap);
            String entryTableName = this.dataDumpConfigInfo.getEntryTableName();
            if (StringUtils.isNotEmpty((CharSequence)entryTableName) && StringUtils.isNotEmpty((CharSequence)this.dataDumpConfigInfo.getEntryFilterField())) {
                String dumpEntryYearTableName = this.dataDumpConfigInfo.getDumpTableName() + "Entry";
                if (!DataDumpUtil.isTableExists(ctx, dumpEntryYearTableName)) {
                    DataDumpUtil.createDumpTable(ctx, entryTableName, dumpEntryYearTableName);
                }
                Map<String, Object> entryFieldUnMatchMap = DataDumpUtil.getFieldUnMatchMap(ctx, entryTableName, dumpEntryYearTableName);
                DataDumpUtil.addColumn(ctx, dumpEntryYearTableName, entryFieldUnMatchMap);
            }
        }
    }

    @Override
    public List<String> getDataDumpSql(Context ctx) {
        this.logger.info(this.dataDumpConfigInfo.getName() + " getDataDumpSql");
        ArrayList<String> sqlList = new ArrayList<String>();
        String tableName = this.dataDumpConfigInfo.getTableName();
        String joinSql = this.dataDumpConfigInfo.getJoinSql();
        String filterField = this.dataDumpConfigInfo.getFilterField();
        Set<String> insertColumns = DataDumpUtil.getColumnMapByTableName(ctx, tableName).keySet();
        if (this.dataDumpConfigInfo.isIsMultiTable()) {
            Set<String> dumpYearSet = DataDumpUtil.getDumpYearSet(ctx, this.dataDumpConfigInfo);
            for (String dumpYear : dumpYearSet) {
                String dumpYearTableName = this.dataDumpConfigInfo.getDumpTableName() + "_" + dumpYear;
                String beginDate = dumpYear + "-01-01";
                String endDate = Integer.valueOf(dumpYear) + 1 + "-01-01";
                String whereSql = "where " + filterField + " >= {ts '" + beginDate + "'} and " + filterField + " < {ts '" + endDate + "'}";
                String insertSql = DataDumpUtil.genInsertDumpSQL(ctx, dumpYearTableName, insertColumns, tableName, joinSql, whereSql);
                sqlList.add(insertSql);
            }
        } else {
            String dumpYearTableName = this.dataDumpConfigInfo.getDumpTableName();
            String insertSql = DataDumpUtil.genInsertDumpSQL(ctx, dumpYearTableName, insertColumns, tableName, joinSql, null);
            sqlList.add(insertSql);
        }
        return sqlList;
    }

    @Override
    public List<String> getDeleteSql(Context ctx) {
        this.logger.info(this.dataDumpConfigInfo.getName() + " deleteCurTableData");
        ArrayList<String> sqlList = new ArrayList<String>();
        String tableName = this.dataDumpConfigInfo.getTableName();
        String filterField = this.dataDumpConfigInfo.getFilterField();
        if (this.dataDumpConfigInfo.isIsMultiTable()) {
            Set<String> dumpYearSet = DataDumpUtil.getDumpYearSet(ctx, this.dataDumpConfigInfo);
            for (String dumpYear : dumpYearSet) {
                String beginDate = dumpYear + "-01-01";
                String endDate = Integer.valueOf(dumpYear) + 1 + "-01-01";
                String whereSql = "where " + filterField + " >= {ts '" + beginDate + "'} and " + filterField + " < {ts '" + endDate + "'}";
                String deletetSql = "delete from " + tableName + " " + whereSql;
                sqlList.add(deletetSql);
                String entryTableName = this.dataDumpConfigInfo.getEntryTableName();
                if (!StringUtils.isNotEmpty((CharSequence)entryTableName) || !StringUtils.isNotEmpty((CharSequence)this.dataDumpConfigInfo.getEntryFilterField())) continue;
                String dumpEntryYearTableName = this.dataDumpConfigInfo.getDumpTableName() + "Entry_" + dumpYear;
                String entryWhereSql = "where " + this.dataDumpConfigInfo.getEntryTableName() + "." + this.dataDumpConfigInfo.getEntryFilterField() + "= " + dumpEntryYearTableName + ".FID";
                String deleteEntrySql = "delete from " + this.dataDumpConfigInfo.getEntryTableName() + " " + entryWhereSql;
                sqlList.add(deleteEntrySql);
            }
        } else {
            String deletetSql = "delete from " + tableName;
            sqlList.add(deletetSql);
            String entryTableName = this.dataDumpConfigInfo.getEntryTableName();
            if (StringUtils.isNotEmpty((CharSequence)entryTableName) && StringUtils.isNotEmpty((CharSequence)this.dataDumpConfigInfo.getEntryFilterField())) {
                String dumpEntryYearTableName = this.dataDumpConfigInfo.getDumpTableName() + "Entry";
                String entryWhereSql = "where " + this.dataDumpConfigInfo.getEntryTableName() + "." + this.dataDumpConfigInfo.getEntryFilterField() + "= " + dumpEntryYearTableName + ".FID";
                String deleteEntrySql = "delete from " + this.dataDumpConfigInfo.getEntryTableName() + " " + entryWhereSql;
                sqlList.add(deleteEntrySql);
            }
        }
        return sqlList;
    }

    @Override
    public List<String> getAntiDataDumpSql(Context ctx) {
        this.logger.info(this.dataDumpConfigInfo.getName() + " getDataDumpSql");
        ArrayList<String> sqlList = new ArrayList<String>();
        String tableName = this.dataDumpConfigInfo.getTableName();
        String joinSql = this.dataDumpConfigInfo.getJoinSql();
        String filterField = this.dataDumpConfigInfo.getFilterField();
        Set<String> insertColumns = DataDumpUtil.getColumnMapByTableName(ctx, tableName).keySet();
        if (this.dataDumpConfigInfo.isIsMultiTable()) {
            Set<String> dumpYearSet = DataDumpUtil.getAntiDumpYearSet(ctx, this.dataDumpConfigInfo);
            for (String dumpYear : dumpYearSet) {
                String dumpYearTableName = this.dataDumpConfigInfo.getDumpTableName() + "_" + dumpYear;
                String beginDate = dumpYear + "-01-01";
                String endDate = Integer.valueOf(dumpYear) + 1 + "-01-01";
                String whereSql = "where " + filterField + " >= {ts '" + beginDate + "'} and " + filterField + " < {ts '" + endDate + "'}";
                String antiJoinSql = null;
                if (StringUtils.isNotEmpty((CharSequence)joinSql)) {
                    antiJoinSql = joinSql.replace(tableName, dumpYearTableName);
                }
                String insertSql = DataDumpUtil.genInsertDumpSQL(ctx, tableName, insertColumns, dumpYearTableName, antiJoinSql, whereSql);
                sqlList.add(insertSql);
            }
        } else {
            String dumpYearTableName = this.dataDumpConfigInfo.getDumpTableName();
            String antiJoinSql = null;
            if (StringUtils.isNotEmpty((CharSequence)joinSql)) {
                antiJoinSql = joinSql.replace(tableName, dumpYearTableName);
            }
            String insertSql = DataDumpUtil.genInsertDumpSQL(ctx, tableName, insertColumns, dumpYearTableName, antiJoinSql, null);
            sqlList.add(insertSql);
        }
        return sqlList;
    }

    @Override
    public List<String> getAntiDeleteSql(Context ctx) {
        this.logger.info(this.dataDumpConfigInfo.getName() + " deleteCurTableData");
        ArrayList<String> sqlList = new ArrayList<String>();
        String filterField = this.dataDumpConfigInfo.getFilterField();
        if (this.dataDumpConfigInfo.isIsMultiTable()) {
            Set<String> dumpYearSet = DataDumpUtil.getAntiDumpYearSet(ctx, this.dataDumpConfigInfo);
            for (String dumpYear : dumpYearSet) {
                String dumpYearTableName = this.dataDumpConfigInfo.getDumpTableName() + "_" + dumpYear;
                String beginDate = dumpYear + "-01-01";
                String endDate = Integer.valueOf(dumpYear) + 1 + "-01-01";
                String whereSql = "where " + filterField + " >= {ts '" + beginDate + "'} and " + filterField + " < {ts '" + endDate + "'}";
                String deletetSql = "delete from " + dumpYearTableName + " " + whereSql;
                sqlList.add(deletetSql);
            }
        } else {
            String dumpYearTableName = this.dataDumpConfigInfo.getDumpTableName();
            String deletetSql = "delete from " + dumpYearTableName;
            sqlList.add(deletetSql);
        }
        return sqlList;
    }

    @Override
    public void excuteInsert(Context ctx, List<String> sqlList, Connection conn) throws SQLException {
        DataDumpUtil.executeBatch(ctx, sqlList, conn);
    }

    @Override
    public void excuteDelete(Context ctx, List<String> sqlList, Connection conn) throws SQLException {
        DataDumpUtil.executeBatch(ctx, sqlList, conn);
    }

    @Override
    public void createIndex(Context ctx) {
        if (StringUtils.isEmpty((CharSequence)this.dataDumpConfigInfo.getJoinSql())) {
            try {
                String filterField = this.dataDumpConfigInfo.getFilterField();
                if (this.dataDumpConfigInfo.isIsMultiTable()) {
                    Set<String> dumpYearSet = DataDumpUtil.getAntiDumpYearSet(ctx, this.dataDumpConfigInfo);
                    for (String dumpYear : dumpYearSet) {
                        String dumpYearTableName = this.dataDumpConfigInfo.getDumpTableName() + "_" + dumpYear;
                        DataDumpUtil.createDumpTableIndex(ctx, dumpYearTableName, new String[]{filterField});
                    }
                } else {
                    String dumpYearTableName = this.dataDumpConfigInfo.getDumpTableName();
                    DataDumpUtil.createDumpTableIndex(ctx, dumpYearTableName, new String[]{filterField});
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }
}

