/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.hr.ats.datadump.service.impl;

import com.kingdee.bos.Context;
import com.kingdee.eas.hr.ats.datadump.service.impl.CommonDataDumpImpl;
import com.kingdee.eas.hr.ats.datadump.util.DataDumpLog;
import com.kingdee.eas.hr.ats.datadump.util.DataDumpUtil;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Scope;
import org.springframework.stereotype.Component;

@Component(value="JoinSqlDataDumpImpl")
@Scope(value="prototype")
public class JoinSqlDataDumpImpl
extends CommonDataDumpImpl {
    @Autowired
    private DataDumpLog logger;

    @Override
    public List<String> getDeleteSql(Context ctx) {
        this.logger.info(this.dataDumpConfigInfo.getName() + " deleteCurTableData");
        ArrayList<String> sqlList = new ArrayList<String>();
        String tableName = this.dataDumpConfigInfo.getTableName();
        String joinSql = this.dataDumpConfigInfo.getJoinSql();
        String filterField = this.dataDumpConfigInfo.getFilterField();
        if (this.dataDumpConfigInfo.isIsMultiTable()) {
            Set<String> dumpYearSet = DataDumpUtil.getDumpYearSet(ctx, this.dataDumpConfigInfo);
            for (String dumpYear : dumpYearSet) {
                String beginDate = dumpYear + "-01-01";
                String endDate = Integer.valueOf(dumpYear) + 1 + "-01-01";
                String innerSelectSql = " select " + tableName + ".fid from " + tableName + " " + joinSql + " where " + filterField + " >= {ts '" + beginDate + "'} and " + filterField + " < {ts '" + endDate + "'}";
                String whereSql = "where fid in ( " + innerSelectSql + ")";
                String deletetSql = "delete from " + tableName + " " + whereSql;
                sqlList.add(deletetSql);
            }
        } else {
            String innerSelectSql = " select " + tableName + ".fid from " + tableName + " " + joinSql;
            String whereSql = "where fid in ( " + innerSelectSql + ")";
            String deletetSql = "delete from " + tableName + " " + whereSql;
            sqlList.add(deletetSql);
        }
        return sqlList;
    }

    @Override
    public List<String> getAntiDeleteSql(Context ctx) {
        this.logger.info(this.dataDumpConfigInfo.getName() + " deleteCurTableData");
        ArrayList<String> sqlList = new ArrayList<String>();
        String tableName = this.dataDumpConfigInfo.getTableName();
        String joinSql = this.dataDumpConfigInfo.getJoinSql();
        String filterField = this.dataDumpConfigInfo.getFilterField();
        if (this.dataDumpConfigInfo.isIsMultiTable()) {
            Set<String> dumpYearSet = DataDumpUtil.getAntiDumpYearSet(ctx, this.dataDumpConfigInfo);
            for (String dumpYear : dumpYearSet) {
                String dumpYearTableName = this.dataDumpConfigInfo.getDumpTableName() + "_" + dumpYear;
                String beginDate = dumpYear + "-01-01";
                String endDate = Integer.valueOf(dumpYear) + 1 + "-01-01";
                String antiJoinSql = joinSql.replace(tableName, dumpYearTableName);
                String innerSelectSql = " select " + dumpYearTableName + ".fid from " + dumpYearTableName + " " + antiJoinSql + " where " + filterField + " >= {ts '" + beginDate + "'} and " + filterField + " < {ts '" + endDate + "'}";
                String whereSql = "where fid in ( " + innerSelectSql + ")";
                String deletetSql = "delete from " + dumpYearTableName + " " + whereSql;
                sqlList.add(deletetSql);
            }
        } else {
            String dumpYearTableName = this.dataDumpConfigInfo.getDumpTableName();
            String antiJoinSql = joinSql.replace(tableName, dumpYearTableName);
            String innerSelectSql = " select " + dumpYearTableName + ".fid from " + dumpYearTableName + " " + antiJoinSql;
            String whereSql = "where fid in ( " + innerSelectSql + ")";
            String deletetSql = "delete from " + dumpYearTableName + " " + whereSql;
            sqlList.add(deletetSql);
        }
        return sqlList;
    }
}

