/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.hr.ats.datadump.util;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.SQLDataException;
import com.kingdee.bos.framework.ejb.EJBFactory;
import com.kingdee.bos.workflow.engine.core.Mutex;
import com.kingdee.bos.workflow.exception.AlreadyInProcessQueueException;
import com.kingdee.eas.hr.ats.AtsUtil;
import com.kingdee.eas.hr.ats.DataDumpConfigInfo;
import com.kingdee.eas.hr.ats.datadump.entity.MetaDataColumnProperty;
import com.kingdee.eas.hr.ats.util.AtsDateUtils;
import com.kingdee.eas.hr.ats.util.common.AtsLog;
import com.kingdee.eas.hr.ats.util.common.DbUtile;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.util.db.SQLUtils;
import java.sql.Connection;
import java.sql.Date;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.lang3.StringUtils;
import org.apache.log4j.Logger;

public class DataDumpUtil {
    private static Logger logger = AtsLog.getDataDumpLog();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Map<String, Object> getColumnMapByTableName(Context ctx, String tableName) {
        ResultSet rs;
        HashMap<String, Object> columnMap;
        Connection con;
        Statement sta;
        block14: {
            sta = null;
            con = null;
            columnMap = new HashMap<String, Object>();
            rs = null;
            try {
                con = EJBFactory.getConnection((Context)ctx);
                sta = con.createStatement();
                rs = sta.executeQuery("SELECT TOP 1 * FROM " + tableName);
                ResultSetMetaData rsmd = rs.getMetaData();
                int count = rsmd.getColumnCount();
                if (count <= 0) break block14;
                MetaDataColumnProperty columnProperty = null;
                for (int i = 1; i <= count; ++i) {
                    String columnName = rsmd.getColumnName(i);
                    columnProperty = new MetaDataColumnProperty();
                    columnProperty.setColumnName(columnName);
                    columnProperty.setColumnType(rsmd.getColumnType(i));
                    columnProperty.setColumnTypeName(rsmd.getColumnTypeName(i));
                    columnProperty.setColumnCount(count);
                    columnProperty.setIsNullable(rsmd.isNullable(i));
                    columnProperty.setPrecision(rsmd.getPrecision(i));
                    columnProperty.setScale(rsmd.getScale(i));
                    columnProperty.setTableName(rsmd.getTableName(i));
                    columnProperty.setSchemaName(rsmd.getSchemaName(i));
                    columnMap.put(columnName.toUpperCase(), columnProperty);
                }
            }
            catch (Exception e) {
                try {
                    logger.error((Object)"DataDumpUtil.getColumnMapByTableName Exception", (Throwable)e);
                }
                catch (Throwable throwable) {
                    SQLUtils.cleanup(sta);
                    SQLUtils.cleanup((Connection)con);
                    if (rs != null) {
                        try {
                            rs.close();
                        }
                        catch (SQLException e2) {
                            e2.printStackTrace();
                        }
                    }
                    throw throwable;
                }
                SQLUtils.cleanup((Statement)sta);
                SQLUtils.cleanup((Connection)con);
                if (rs != null) {
                    try {
                        rs.close();
                    }
                    catch (SQLException e3) {
                        e3.printStackTrace();
                    }
                }
            }
        }
        SQLUtils.cleanup((Statement)sta);
        SQLUtils.cleanup((Connection)con);
        if (rs != null) {
            try {
                rs.close();
            }
            catch (SQLException e) {
                e.printStackTrace();
            }
        }
        return columnMap;
    }

    public static Map<String, Object> getFieldUnMatchMap(Context ctx, Map<String, Object> srcColumnMap, String targetTableName) {
        Map<String, Object> targetColumnMap = DataDumpUtil.getColumnMapByTableName(ctx, targetTableName);
        if (targetColumnMap.isEmpty()) {
            return srcColumnMap;
        }
        HashMap<String, Object> fieldUnMatch = new HashMap<String, Object>();
        Set<Map.Entry<String, Object>> srcEntrySet = srcColumnMap.entrySet();
        for (Map.Entry<String, Object> srcEntry : srcEntrySet) {
            String srcColumn = srcEntry.getKey();
            if (targetColumnMap.containsKey(srcColumn)) continue;
            fieldUnMatch.put(srcColumn, srcEntry.getValue());
        }
        return fieldUnMatch;
    }

    public static Map<String, Object> getFieldUnMatchMap(Context ctx, String srcTableName, String targetTableName) {
        Map<String, Object> targetColumnMap = DataDumpUtil.getColumnMapByTableName(ctx, targetTableName);
        Map<String, Object> srcColumnMap = DataDumpUtil.getColumnMapByTableName(ctx, srcTableName);
        if (targetColumnMap.isEmpty()) {
            return srcColumnMap;
        }
        HashMap<String, Object> fieldUnMatchMap = new HashMap<String, Object>();
        Set<Map.Entry<String, Object>> srcEntrySet = srcColumnMap.entrySet();
        for (Map.Entry<String, Object> srcEntry : srcEntrySet) {
            String srcColumn = srcEntry.getKey();
            if (targetColumnMap.containsKey(srcColumn)) continue;
            fieldUnMatchMap.put(srcColumn, srcEntry.getValue());
        }
        return fieldUnMatchMap;
    }

    public static boolean addColumn(Context ctx, String targetTableName, Map<String, Object> fieldMap) throws SQLDataException {
        if (fieldMap.isEmpty()) {
            return true;
        }
        ArrayList<String> columnSql = new ArrayList<String>();
        Set<Map.Entry<String, Object>> srcEntrySet = fieldMap.entrySet();
        block9: for (Map.Entry<String, Object> srcEntry : srcEntrySet) {
            String columnName = srcEntry.getKey();
            MetaDataColumnProperty columnPro = (MetaDataColumnProperty)srcEntry.getValue();
            int precision = columnPro.getPrecision();
            int scale = columnPro.getScale();
            switch (columnPro.getColumnType()) {
                case 12: {
                    columnSql.add("ALTER TABLE " + targetTableName + " ADD " + columnName + " VARCHAR(" + precision + ")");
                    continue block9;
                }
                case 4: {
                    columnSql.add("ALTER TABLE " + targetTableName + " ADD " + columnName + " INT DEFAULT 0");
                    continue block9;
                }
                case -6: {
                    columnSql.add("ALTER TABLE " + targetTableName + " ADD " + columnName + " INT DEFAULT 0");
                    continue block9;
                }
                case 6: {
                    columnSql.add("ALTER TABLE " + targetTableName + " ADD " + columnName + " NUMERIC(" + precision + "," + scale + ")");
                    continue block9;
                }
                case 3: {
                    columnSql.add("ALTER TABLE " + targetTableName + " ADD " + columnName + " NUMERIC(" + precision + "," + scale + ")");
                    continue block9;
                }
                case 91: {
                    columnSql.add("ALTER TABLE " + targetTableName + " ADD " + columnName + " DATETIME ");
                    continue block9;
                }
                case 93: {
                    columnSql.add("ALTER TABLE " + targetTableName + " ADD " + columnName + " DATETIME");
                    continue block9;
                }
            }
            columnSql.add("ALTER TABLE " + targetTableName + " ADD " + columnName + " VARCHAR(" + precision + ")");
        }
        com.kingdee.eas.base.core.util.DbUtil.executeBatch((Context)ctx, columnSql);
        return true;
    }

    public static String genInsertDumpSQL(Context ctx, String targetTableName, Set<String> insertColumns, String srcTableName, String joinSql, String whereSql) {
        Iterator<String> insertIter = insertColumns.iterator();
        StringBuffer columnStr = new StringBuffer();
        StringBuffer selectColumnStr = new StringBuffer();
        while (insertIter.hasNext()) {
            String column = insertIter.next();
            if (!StringUtils.isEmpty((CharSequence)columnStr.toString())) {
                columnStr.append(",");
            }
            columnStr.append(column);
        }
        for (String column : insertColumns) {
            if (!StringUtils.isEmpty((CharSequence)selectColumnStr.toString())) {
                selectColumnStr.append(",");
            }
            selectColumnStr.append(srcTableName).append(".").append(column);
        }
        StringBuffer insertSql = new StringBuffer();
        insertSql.append("INSERT INTO ").append(targetTableName).append("(").append(columnStr.toString()).append(")  SELECT ").append(selectColumnStr.toString()).append(" FROM ").append(srcTableName).append(" ");
        if (StringUtils.isNotEmpty((CharSequence)joinSql)) {
            insertSql.append(joinSql);
        }
        if (StringUtils.isNotEmpty((CharSequence)whereSql)) {
            insertSql.append(" ").append(whereSql).append(" ");
        }
        return insertSql.toString();
    }

    public static boolean isTableExists(Context ctx, String tableName) {
        StringBuilder sqlBuilder = new StringBuilder();
        sqlBuilder.append(" if exists (select * from ksql_usercolumns where ksql_col_tabname= '").append(tableName).append("') ").append(" SELECT top 1 1 from T_HR_ATS_DataDumpConfig ").append(" else ").append(" SELECT top 1 0 from T_HR_ATS_DataDumpConfig; ");
        try {
            IRowSet row = null;
            row = DbUtile.executeQuery(ctx, sqlBuilder.toString());
            while (row.next()) {
                int i = row.getInt(1);
                if (i <= 0) continue;
                return true;
            }
        }
        catch (Exception e) {
            logger.error((Object)"DataDumpUtil.isTableExists Exception", (Throwable)e);
        }
        return false;
    }

    public static void createDumpTable(Context ctx, String srcTableName, String targetTableName) throws BOSException {
        StringBuilder sqlBuilder = new StringBuilder();
        sqlBuilder.append(" if not exists (select * from ksql_usercolumns where ksql_col_tabname= '").append(targetTableName).append("') ").append(" SELECT * INTO ").append(targetTableName).append(" from ").append(srcTableName).append(" where 1 = 2 ; ");
        DbUtile.execute(ctx, sqlBuilder.toString());
    }

    public static Set<String> getDumpYearSet(Context ctx, DataDumpConfigInfo dataDumpConfigInfo) {
        LinkedHashSet<String> dumpYearSet = new LinkedHashSet<String>();
        int yearBeforeNum = dataDumpConfigInfo.getYearBeforeNum();
        String tableName = dataDumpConfigInfo.getTableName();
        String filterField = dataDumpConfigInfo.getFilterField();
        String joinSql = dataDumpConfigInfo.getJoinSql();
        String year = dataDumpConfigInfo.getYear();
        Set<Object> yearSet = new HashSet();
        if (StringUtils.isNotEmpty((CharSequence)year)) {
            yearSet = AtsUtil.toSet(year);
        }
        if (StringUtils.isEmpty((CharSequence)joinSql)) {
            joinSql = "";
        }
        java.util.Date today = new java.util.Date();
        java.util.Date filterDate = AtsDateUtils.getYearFirstDay(AtsDateUtils.dateAdd(today, 1, -(yearBeforeNum - 1)));
        String filterDateStr = AtsDateUtils.dateShortToString(filterDate);
        StringBuilder sqlBuilder = new StringBuilder();
        sqlBuilder.append(" select minDate,maxDate from ").append(" (select max(" + filterField + ") maxDate from " + tableName + " " + joinSql + " where " + filterField + " < {ts '" + filterDateStr + "'}) t1 left join ").append(" (select min(" + filterField + ") minDate from " + tableName + " " + joinSql + " where " + filterField + " < {ts '" + filterDateStr + "'}) t2 on 1=1 ");
        Date maxDate = null;
        Date minDate = null;
        IRowSet row = null;
        try {
            row = DbUtile.executeQuery(ctx, sqlBuilder.toString());
            while (row.next()) {
                maxDate = row.getDate("maxDate");
                minDate = row.getDate("minDate");
            }
        }
        catch (BOSException e) {
            e.printStackTrace();
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
        if (maxDate == null || minDate == null) {
            return dumpYearSet;
        }
        int maxYear = AtsDateUtils.getCurrentYear(maxDate);
        int minYear = AtsDateUtils.getCurrentYear(minDate);
        do {
            if (yearSet != null && yearSet.size() == 0) {
                dumpYearSet.add(String.valueOf(maxYear));
                continue;
            }
            if (yearSet == null || yearSet.size() <= 0 || !yearSet.contains(String.valueOf(maxYear))) continue;
            dumpYearSet.add(String.valueOf(maxYear));
        } while (--maxYear >= minYear);
        return dumpYearSet;
    }

    public static Set<String> getAntiDumpYearSet(Context ctx, DataDumpConfigInfo dataDumpConfigInfo) {
        LinkedHashSet<String> dumpYearSet = new LinkedHashSet<String>();
        int yearBeforeNum = dataDumpConfigInfo.getYearBeforeNum();
        String tableName = dataDumpConfigInfo.getTableName();
        String dumpTableName = dataDumpConfigInfo.getDumpTableName();
        String year = dataDumpConfigInfo.getYear();
        Set<Object> yearSet = new HashSet();
        if (StringUtils.isNotEmpty((CharSequence)year)) {
            yearSet = AtsUtil.toSet(year);
        }
        java.util.Date today = new java.util.Date();
        java.util.Date filterDate = AtsDateUtils.getYearFirstDay(AtsDateUtils.dateAdd(today, 1, -(yearBeforeNum - 1)));
        int filterYear = AtsDateUtils.getCurrentYear(filterDate);
        StringBuilder sqlBuilder = new StringBuilder();
        sqlBuilder.append(" select distinct ksql_col_tabname from ksql_usercolumns where ksql_col_tabname like '").append(dumpTableName).append("%'");
        IRowSet row = null;
        try {
            row = DbUtile.executeQuery(ctx, sqlBuilder.toString());
            while (row.next()) {
                try {
                    String temp = row.getString("ksql_col_tabname");
                    String dumpYear = temp.substring(temp.length() - 4);
                    if (Integer.valueOf(dumpYear) >= filterYear) continue;
                    if (yearSet != null && yearSet.size() == 0) {
                        dumpYearSet.add(dumpYear);
                        continue;
                    }
                    if (yearSet == null || yearSet.size() <= 0 || !yearSet.contains(dumpYear)) continue;
                    dumpYearSet.add(String.valueOf(dumpYear));
                }
                catch (Exception temp) {}
            }
        }
        catch (BOSException e) {
            e.printStackTrace();
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
        return dumpYearSet;
    }

    public static boolean createDumpTableIndex(Context ctx, String tableName, String[] indexColumns) {
        try {
            StringBuilder indexCols = new StringBuilder();
            for (int i = 0; i < indexColumns.length; ++i) {
                if (!StringUtils.isEmpty((CharSequence)indexCols.toString())) {
                    indexCols.append(",");
                }
                indexCols.append(indexColumns[i]);
            }
            String indexName = "I_" + tableName;
            StringBuilder sqlBuilder = new StringBuilder();
            sqlBuilder.append("If not exists (select * from KSQL_INDEXES where KSQL_INDNAME = '").append(indexName).append("') ").append(" CREATE INDEX ").append(indexName).append(" ON ").append(tableName).append("(").append((CharSequence)indexCols).append(")");
            DbUtil.execute((Context)ctx, (String)sqlBuilder.toString());
        }
        catch (Exception e) {
            logger.error((Object)"DataDumpUtil.createDumpTableIndex Exception", (Throwable)e);
            return false;
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void executeBatch(Context ctx, List<String> sqlList, Connection conn) throws SQLException {
        if (sqlList == null || sqlList.size() == 0) {
            return;
        }
        Statement stmt = null;
        try {
            stmt = conn.createStatement();
            for (int i = 0; i < sqlList.size(); ++i) {
                stmt.addBatch(sqlList.get(i));
            }
            stmt.executeBatch();
        }
        finally {
            try {
                if (stmt != null) {
                    stmt.close();
                }
            }
            catch (Exception e2) {
                e2.printStackTrace();
            }
        }
    }

    public static void acquireLock(Context ctx, Set<String> objectIds) {
        HashSet<String> hasLocked = new HashSet<String>();
        boolean acquireLock = true;
        while (acquireLock) {
            for (String id : objectIds) {
                try {
                    if (!Mutex.lock((Context)ctx, (String)id)) continue;
                    hasLocked.add(id);
                }
                catch (AlreadyInProcessQueueException e) {
                    for (String lockId : hasLocked) {
                        Mutex.unlock((Context)ctx, (String)lockId);
                    }
                    try {
                        Thread.sleep(2000L);
                    }
                    catch (InterruptedException e1) {
                        e1.printStackTrace();
                    }
                    break;
                }
            }
            if (hasLocked.size() != objectIds.size()) continue;
            acquireLock = false;
            break;
        }
    }
}

