/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.hr.ats.decimalPlace.util;

import com.kingdee.bos.Context;
import com.kingdee.eas.hr.ats.util.common.MLUtile;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.Map;

public class DecimalPlaceUtil {
    private static final String DECIMALPLACE_KEYID = "s22IjzP0PevgU8gEEaz7maiB8+c=";
    private static final int DEFAULT_DECIMALPLACES = 2;
    private static final int DEFAULT_DECIMALPLACES_CAL = 8;

    public static int getDecimalPlaceSystem(Context ctx) {
        int decimalPlaces = DecimalPlaceUtil.getDefaultDecimalPlaces();
        StringBuffer sb = new StringBuffer();
        sb.append(" SELECT FVALUE" + MLUtile.getMlFlag(ctx) + " VALUE FROM T_BAS_PARAMITEM ITEM ");
        sb.append(" INNER JOIN T_BAS_PARAM PARAM ON PARAM.FID = ITEM.FKEYID ");
        sb.append(" WHERE FKEYID = ? ");
        try {
            IRowSet row = DbUtil.executeQuery((Context)ctx, (String)sb.toString(), (Object[])new Object[]{DECIMALPLACE_KEYID});
            if (row.next()) {
                decimalPlaces = row.getInt("VALUE");
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return decimalPlaces > 8 ? 8 : (decimalPlaces < 0 ? 0 : decimalPlaces);
    }

    public static int getDefaultDecimalPlacesCal() {
        return 8;
    }

    public static int getDefaultDecimalPlaces() {
        return 2;
    }

    public static int getDecimalPlace(Context ctx, Map<String, Object> globalMap) {
        if (null != globalMap && null != globalMap.get("decimalPlaces")) {
            return (Integer)globalMap.get("decimalPlaces");
        }
        return DecimalPlaceUtil.getDecimalPlaceSystem(ctx);
    }

    public static int getDecimalPlaces(Context ctx, Map<Object, Object> globalMap) {
        if (null != globalMap && null != globalMap.get("decimalPlaces")) {
            return (Integer)globalMap.get("decimalPlaces");
        }
        return DecimalPlaceUtil.getDecimalPlaceSystem(ctx);
    }

    public static BigDecimal decimalPlaceCtrl(Context ctx, BigDecimal number, int decimalPlaces, RoundingMode roundingMode) {
        return number.setScale(decimalPlaces, roundingMode);
    }

    public static BigDecimal decimalPlaceCtrl(Context ctx, BigDecimal number, int decimalPlaces) {
        return DecimalPlaceUtil.decimalPlaceCtrl(ctx, number, decimalPlaces, RoundingMode.HALF_UP);
    }

    public static int getNumberDecimalDigits(double number) {
        if (number == (double)((long)number)) {
            return 0;
        }
        int i = 0;
        while (number * Math.pow(10.0, ++i) % 1.0 != 0.0) {
        }
        return i;
    }
}

