/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.hr.ats.formula.limit;

import com.alibaba.fastjson.util.TypeUtils;
import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.query.server.PagingHelper;
import com.kingdee.bos.util.backport.Arrays;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.hr.ats.AttendanceProjectInfo;
import com.kingdee.eas.hr.ats.util.common.AtsCollectionUtile;
import com.kingdee.eas.hr.base.timezone.Date;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.shr.formulaplatform.baseconfig.FormulaCacheService;
import com.kingdee.shr.formulaplatform.formulaexecutor.AbsFormulaExecutor;
import com.kingdee.shr.formulaplatform.formulaexecutor.DefaultFormulaExecutor;
import com.kingdee.shr.formulaplatform.formulaexecutor.FormulaCacheLevel;
import com.kingdee.shr.formulaplatform.formulaexecutor.FormulaCtx;
import com.kingdee.shr.formulaplatform.formulaexecutor.FormulaExecutorUtile;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;

public class LimitFormulaFn {
    private static Logger logger = Logger.getLogger(LimitFormulaFn.class);
    public static final String BASE_DATE = "ats_baseDate";

    public static double getLeaveLength(AbsFormulaExecutor currentFn, Object startDate, Object endDate, String holidayTypeNumber, Object unit, Object ratio) {
        Object[] params = new Object[]{holidayTypeNumber, TypeUtils.castToTimestamp((Object)startDate), TypeUtils.castToTimestamp((Object)endDate)};
        String sql = " select lentry.fpersonId,sum(lDetail.FLeaveLength) sumLen from T_HR_ATS_LeaveBillDetail lDetail join T_HR_ATS_HolidayPolicy hPolicy on lDetail.FPolicyID=hPolicy.fid join T_HR_ATS_LeaveBillEntry lentry on lDetail.FLeavebillEntryID=lentry.fid join T_HR_ATS_HolidayType hType on hPolicy.FHolidayTypeID=hType.fid and hType.fnumber=? where FLeaveDate between ? and ? group by lentry.fpersonId order by lentry.fpersonId";
        FormulaCtx formulaCtx = currentFn.getFormulaCtx();
        FormulaCacheService cacheService = FormulaCacheService.getInstance((DefaultFormulaExecutor)formulaCtx.getCurformulaExecutor());
        Map resMap = cacheService.initTwoFieldData(formulaCtx.getBosCtx(), sql, params, FormulaCacheLevel.GLOBAL, "LimitFormulaFn.getLeaveLength");
        Double res = TypeUtils.castToDouble(resMap.get(String.valueOf(formulaCtx.getCurSchemeDataSorces().get("person.id"))));
        return res == null ? 0.0 : res * TypeUtils.castToDouble((Object)ratio);
    }

    public static double getLastRemainLimit(AbsFormulaExecutor currentFn) {
        FormulaCtx formulaCtx = currentFn.getFormulaCtx();
        Date baseDate = LimitFormulaFn.getBaseDate(currentFn);
        Object holidayPolicy = FormulaExecutorUtile.getFieldVal((Map)formulaCtx.getCurSchemeDataSorces(), null, (String)"HPoli.id");
        Object[] params = new Object[]{baseDate, String.valueOf(holidayPolicy)};
        String sql = " select concat(hLimit.fproposerId,hLimit.fhrOrgUnitID) personHro,FcycleEndDate,hLimit.fRemainLimit from T_HR_ATS_HolidayLimit hLimit  join ( \t\tselect max(fid) fid from T_HR_ATS_HolidayLimit\t\twhere FcycleEndDate<? and FHOLIDAYPOLICYID=?" + LimitFormulaFn.getFilterFromDataSorces(formulaCtx, "fproposerId") + "      group by fproposerId,fhrOrgUnitID ,FcycleEndDate\t\thaving FcycleEndDate=max(FcycleEndDate) ) lastLimit on lastLimit.fid=hLimit.fid where hLimit.fRemainLimit < 0";
        FormulaCacheService cacheService = FormulaCacheService.getInstance((DefaultFormulaExecutor)formulaCtx.getCurformulaExecutor());
        Map resMap = cacheService.initTwoFieldData(formulaCtx.getBosCtx(), sql, params, FormulaCacheLevel.DATA_GROUP, "LimitFormulaFn.getLastRemainLimit" + sql.hashCode());
        String key = MessageFormat.format("{0}{1}", formulaCtx.getCurSchemeDataSorces().get("person.id"), formulaCtx.getCurSchemeDataSorces().get("hROrgUnit.id"));
        Map queryRes = (Map)resMap.get(key);
        java.sql.Date cycleBeginDate = formulaCtx.getCurCalModel().getDate("cycleBeginDate");
        if (queryRes == null || cycleBeginDate == null || queryRes.get("FcycleEndDate") == null) {
            return 0.0;
        }
        Date precycleEndDate = Date.getDate(queryRes.get("FcycleEndDate")).newNextDay();
        if (precycleEndDate.getTime() != cycleBeginDate.getTime()) {
            return 0.0;
        }
        Double res = TypeUtils.castToDouble((Object)String.valueOf(queryRes.get("fRemainLimit")));
        return res == null ? 0.0 : res;
    }

    public static String getFilterFromDataSorces(FormulaCtx formulaCtx, String personField) {
        List datas = formulaCtx.getSchemeDataSorces();
        if (!AtsCollectionUtile.isEmpty(datas)) {
            HashSet<String> persons = new HashSet<String>();
            for (Map data : datas) {
                persons.add(String.valueOf(data.get("person.id")));
            }
            return MessageFormat.format(" and {0} in {1}", personField, AtsCollectionUtile.joinForSqlWithBrackets(persons));
        }
        return "";
    }

    public static java.util.Date getContinueTripTime(AbsFormulaExecutor currentFn, Object baseDate, String tripTypeNumber, Object fetchEndDate) throws EASBizException {
        Boolean isFetchEndDate = TypeUtils.castToBoolean((Object)fetchEndDate);
        if (isFetchEndDate.booleanValue()) {
            return LimitFormulaFn.getContinueTripEndTime(currentFn, baseDate, tripTypeNumber);
        }
        return LimitFormulaFn.getContinueTripStartTime(currentFn, baseDate, tripTypeNumber, 365);
    }

    public static java.util.Date getContinueTripEndTime(AbsFormulaExecutor currentFn, Object baseDate, String tripTypeNumber) {
        Object[] params = new Object[]{tripTypeNumber, TypeUtils.castToTimestamp((Object)baseDate)};
        String sql = " select tripEntry.fpersonId,max(tripEntry.realTripEndTime) from T_HR_ATS_TripBillEntry tripEntry join T_HR_ATS_TripBill tripBill on tripEntry.FBillID=tripBill.fid and tripBill.fbillState=3 join T_HR_ATS_TripType tripType on tripEntry.FTripTypeID=tripType.fid and tripType.fnumber=? where tripEntry.realTripEndTime<? group by lentry.fpersonId order by lentry.fpersonId";
        FormulaCtx formulaCtx = currentFn.getFormulaCtx();
        FormulaCacheService cacheService = FormulaCacheService.getInstance((DefaultFormulaExecutor)formulaCtx.getCurformulaExecutor());
        Map resMap = cacheService.initTwoFieldData(formulaCtx.getBosCtx(), sql, params, FormulaCacheLevel.GLOBAL, "LimitFormulaFn.getContinueTripEndTime");
        java.util.Date res = TypeUtils.castToDate(resMap.get(String.valueOf(formulaCtx.getCurSchemeDataSorces().get("person.id"))));
        return res;
    }

    public static java.util.Date getContinueTripStartTime(AbsFormulaExecutor currentFn, Object baseDate, String tripTypeNumber, int preDay) throws EASBizException {
        String cacheKey;
        baseDate = TypeUtils.castToTimestamp((Object)baseDate);
        Object[] params = new Object[]{tripTypeNumber, baseDate, new Timestamp(((Timestamp)baseDate).getTime() - (long)(preDay * 365 * 24 * 60 * 60 * 1000))};
        FormulaCtx formulaCtx = currentFn.getFormulaCtx();
        FormulaCacheService cacheService = FormulaCacheService.getInstance((DefaultFormulaExecutor)formulaCtx.getCurformulaExecutor());
        HashMap<String, java.util.Date> allData = (HashMap<String, java.util.Date>)cacheService.getValueFromCache(FormulaCacheLevel.GLOBAL, cacheKey = cacheService.generateFunctionKey(params, "LimitFormulaFn.getContinueTripStartTime"));
        if (allData != null) {
            return (java.util.Date)allData.get(String.valueOf(formulaCtx.getCurSchemeDataSorces().get("person.id")));
        }
        String sql = " select tripEntry.fpersonId,tripEntry.frealTripStartTime,tripEntry.frealTripEndTime from T_HR_ATS_TripBillEntry tripEntry join T_HR_ATS_TripBill tripBill on tripEntry.FBillID=tripBill.fid and tripBill.fbillState=3 join T_HR_ATS_TripType tripType on tripEntry.FTripTypeID=tripType.fid and tripType.fnumber=? where tripEntry.frealTripEndTime<? and tripEntry.frealTripStartTime>? order by lentry.fpersonId,tripEntry.frealTripStartTime desc";
        PagingHelper pagingHelper = new PagingHelper();
        int len = 499;
        Context ctx = formulaCtx.getBosCtx();
        allData = new HashMap<String, java.util.Date>();
        try {
            String pageSql;
            IRowSet iRowSet;
            int i = 0;
            while (!LimitFormulaFn.tripStartTimeProcess(iRowSet = DbUtil.executeQuery((Context)ctx, (String)(pageSql = pagingHelper.getPagingSqlNoOptmize(ctx, sql, i * len, len)), (Object[])params), allData)) {
                ++i;
            }
        }
        catch (BOSException e) {
            throw new EASBizException(EASBizException.DBDEADLOCK, (Throwable)e);
        }
        catch (SQLException e) {
            throw new EASBizException(EASBizException.DBDEADLOCK, (Throwable)e);
        }
        cacheService.setValueToCache(FormulaCacheLevel.GLOBAL, cacheKey, allData);
        return (java.util.Date)allData.get(String.valueOf(formulaCtx.getCurSchemeDataSorces().get("person.id")));
    }

    private static boolean tripStartTimeProcess(IRowSet iRowSet, Map<String, java.util.Date> allData) throws SQLException {
        int rowSize = iRowSet.size();
        int onDayLong = 86400000;
        while (iRowSet.next()) {
            java.util.Date nextStartDate = allData.get(iRowSet.getString(1));
            if (nextStartDate == null) {
                allData.put(iRowSet.getString(1), iRowSet.getTimestamp(2));
                continue;
            }
            Timestamp endDate = iRowSet.getTimestamp(3);
            if (nextStartDate.getTime() / (long)onDayLong - ((java.util.Date)endDate).getTime() / (long)onDayLong > 1L) continue;
            allData.put(iRowSet.getString(1), iRowSet.getTimestamp(2));
        }
        return rowSize < 499;
    }

    public static double getOTLength(AbsFormulaExecutor currentFn, Object startDate, Object endDate, String otTypeNumber, String otCompensNumber) {
        FormulaCtx formulaCtx;
        FormulaCacheService cacheService;
        Map resMap;
        Double res;
        Object[] params = new Object[]{otCompensNumber, TypeUtils.castToTimestamp((Object)startDate), TypeUtils.castToTimestamp((Object)endDate), otTypeNumber};
        String sql = " select otEntry.fpersonId,sum(otEntry.FLeaveLength) from T_HR_ATS_OverTimeBillEntry otEntry join T_HR_ATS_OverTimeCompens otCompens on otEntry.FOTCompensID=otCompens.fid and otCompens.fnumber=? join T_HR_ATS_OverTimeType otType on otType.fid=otEntry.FOTTypeID where otEntry.FOTDate>=? and otEntry.FOTDate<=? and otType.fnumber=? group by otEntry.fpersonId order by otEntry.fpersonId";
        if (StringUtils.isBlank((String)otTypeNumber)) {
            sql = sql.replace("and otType.fnumber=?", "");
            params = Arrays.copyOf((Object[])params, (int)(params.length - 1));
        }
        return (res = TypeUtils.castToDouble((resMap = (cacheService = FormulaCacheService.getInstance((DefaultFormulaExecutor)(formulaCtx = currentFn.getFormulaCtx()).getCurformulaExecutor())).initTwoFieldData(formulaCtx.getBosCtx(), sql, params, FormulaCacheLevel.GLOBAL, "LimitFormulaFn.getOTLength")).get(String.valueOf(formulaCtx.getCurSchemeDataSorces().get("person.id"))))) == null ? 0.0 : res;
    }

    public static double getAtsResultDetailTotal(AbsFormulaExecutor currentFn, Object startDate, Object endDate, String project) {
        FormulaCtx formulaCtx = currentFn.getFormulaCtx();
        FormulaCacheService cacheService = FormulaCacheService.getInstance((DefaultFormulaExecutor)formulaCtx.getCurformulaExecutor());
        Object atsPro = cacheService.getValueFromCacheID((Object)project);
        if (atsPro == null) {
            cacheService.initCacheCollection((Object)project);
            atsPro = cacheService.getValueFromCacheID((Object)project);
        }
        Object[] params = new Object[]{TypeUtils.castToTimestamp((Object)startDate), TypeUtils.castToTimestamp((Object)endDate)};
        String sql = " select fproposerid,sum(s{0}) from T_HR_ATS_AttendanceResult where FAttenceDate>=? and FAttenceDate<=? group by fproposerid order by fproposerid";
        sql = MessageFormat.format(sql, ((AttendanceProjectInfo)atsPro).getColumnNO());
        Map resMap = cacheService.initTwoFieldData(formulaCtx.getBosCtx(), sql, params, FormulaCacheLevel.GLOBAL, "LimitFormulaFn.getAtsResultDetailTotal");
        Double res = TypeUtils.castToDouble(resMap.get(String.valueOf(formulaCtx.getCurSchemeDataSorces().get("person.id"))));
        return res == null ? 0.0 : res;
    }

    public static double getAtsResultSumTotal(AbsFormulaExecutor currentFn, Object startDate, Object endDate, String project) {
        FormulaCtx formulaCtx = currentFn.getFormulaCtx();
        FormulaCacheService cacheService = FormulaCacheService.getInstance((DefaultFormulaExecutor)formulaCtx.getCurformulaExecutor());
        Object atsPro = cacheService.getValueFromCacheID((Object)project);
        if (atsPro == null) {
            cacheService.initCacheCollection((Object)project);
            atsPro = cacheService.getValueFromCacheID((Object)project);
        }
        Object[] params = new Object[]{TypeUtils.castToTimestamp((Object)endDate), TypeUtils.castToTimestamp((Object)startDate)};
        String sql = " select fproposerid,sum(s{0}) from T_HR_ATS_AttendanceResultSum atsSum join T_HR_ATS_AttendancePeriod atsPeriod on atsSum.FAttendancePeriodID=atsPeriod.fid where FStartDate<=? and FEndDate>=? group by fproposerid order by fproposerid";
        sql = MessageFormat.format(sql, ((AttendanceProjectInfo)atsPro).getColumnNO());
        Map resMap = cacheService.initTwoFieldData(formulaCtx.getBosCtx(), sql, params, FormulaCacheLevel.GLOBAL, "LimitFormulaFn.getAtsResultSumTotal");
        Double res = TypeUtils.castToDouble(resMap.get(String.valueOf(formulaCtx.getCurSchemeDataSorces().get("person.id"))));
        return res == null ? 0.0 : res;
    }

    public static double getHolidayLimit(AbsFormulaExecutor currentFn, Object startDate, Object endDate, String holidayTypeNumber, String fieldName) {
        Object[] params = new Object[]{holidayTypeNumber, TypeUtils.castToTimestamp((Object)startDate), TypeUtils.castToTimestamp((Object)endDate)};
        String sql = " select hLimit.fproposerId,sum(hLimit.{0}) sumS from T_HR_ATS_HolidayLimit hLimit join T_HR_ATS_HolidayPolicy hPolicy on hLimit.FHolidayPolicyID=hPolicy.fid join T_HR_ATS_HolidayType hType on hType.fid=hPolicy.FHolidayTypeID and hType.fnumber=? where hLimit.FCycleBeginDate=? and hLimit.FCycleEndDate=? group by hLimit.fproposerId";
        sql = MessageFormat.format(sql, fieldName);
        FormulaCtx formulaCtx = currentFn.getFormulaCtx();
        FormulaCacheService cacheService = FormulaCacheService.getInstance((DefaultFormulaExecutor)formulaCtx.getCurformulaExecutor());
        Map resMap = cacheService.initTwoFieldData(formulaCtx.getBosCtx(), sql, params, FormulaCacheLevel.GLOBAL, "LimitFormulaFn.getHolidayLimit");
        Double res = TypeUtils.castToDouble(resMap.get(String.valueOf(formulaCtx.getCurSchemeDataSorces().get("person.id"))));
        return res == null ? 0.0 : res;
    }

    public static double getCurHolidayLimit(AbsFormulaExecutor currentFn, String fieldName) {
        FormulaCtx formulaCtx = currentFn.getFormulaCtx();
        Object holidayPolicy = FormulaExecutorUtile.getFieldVal((Map)formulaCtx.getCurSchemeDataSorces(), null, (String)"HPoli.id");
        Date baseDate = LimitFormulaFn.getBaseDate(currentFn);
        Object[] params = new Object[]{baseDate, baseDate, String.valueOf(holidayPolicy)};
        String cacheFlag = "LimitFormulaFn.getCurHolidayLimit";
        String selectFiled = "fproposerId, max(faddOrSubLimit) faddOrSubLimit, max(fusedLimit) fusedLimit, max(freezeLimit) freezeLimit, max(fpreOverdraftLimit) fpreOverdraftLimit";
        if (!selectFiled.toLowerCase().contains(fieldName.toLowerCase())) {
            selectFiled = MessageFormat.format("fproposerId,max({0}) {1}", fieldName, fieldName);
            cacheFlag = MessageFormat.format("{0}.{1}", cacheFlag, fieldName);
        }
        String sql = " select {0} from T_HR_ATS_HolidayLimit where FCycleBeginDate<=? and FCycleEndDate>=? and FHOLIDAYPOLICYID=?  group by fproposerId ";
        sql = MessageFormat.format(sql, selectFiled);
        FormulaCacheService cacheService = FormulaCacheService.getInstance((DefaultFormulaExecutor)formulaCtx.getCurformulaExecutor());
        Map resMap = cacheService.initTwoFieldData(formulaCtx.getBosCtx(), sql, params, FormulaCacheLevel.GLOBAL, cacheFlag);
        Object res = resMap.get(String.valueOf(formulaCtx.getCurSchemeDataSorces().get("person.id")));
        res = res instanceof Map ? ((Map)res).get(fieldName.toUpperCase()) : res;
        return res == null ? 0.0 : TypeUtils.castToDouble(res);
    }

    public static Date getBaseDate(AbsFormulaExecutor currentFn) {
        Object date = FormulaExecutorUtile.getExecutorConfig((AbsFormulaExecutor)currentFn, (Object)BASE_DATE);
        return Date.getDate((Object)date);
    }

    public static java.util.Date getRealDateWithSameHrOrg(AbsFormulaExecutor currentFn, Object compareDate, boolean isStartDate) {
        String newCacheKey;
        FormulaCtx formulaCtx = currentFn.getFormulaCtx();
        Date baseDate = LimitFormulaFn.getBaseDate(currentFn);
        Object[] params = new Object[]{baseDate, baseDate};
        String sql = " select hFile.fproposerId,hFile.fleffdt,hFile.feffdt from T_HR_ATS_ATSHOLIDAYFILEHIS hFile join (\t\tselect fproposerId,fHrOrgUnitId from T_HR_ATS_ATSHOLIDAYFILEHIS \t\twhere feffdt<=? and fleffdt>=? " + LimitFormulaFn.getFilterFromDataSorces(formulaCtx, "fproposerId") + ") curFile  on curFile.fHrOrgUnitId=hFile.fHrOrgUnitId and curFile.fproposerId = hFile.fproposerId";
        FormulaCacheService cacheService = FormulaCacheService.getInstance((DefaultFormulaExecutor)formulaCtx.getCurformulaExecutor());
        Map<String, java.util.Date[]> realDateMap = (Map<String, java.util.Date[]>)cacheService.getValueFromCache(FormulaCacheLevel.DATA_GROUP, newCacheKey = cacheService.generateFunctionKey(params, "LimitFormulaFn.getRealDateWithSameHrOrg" + sql.hashCode()));
        if (realDateMap == null) {
            HashMap<String, List<java.util.Date[]>> fileDateMap = new HashMap<String, List<java.util.Date[]>>();
            try {
                IRowSet rowSet = DbUtil.executeQuery((Context)formulaCtx.getBosCtx(), (String)sql, (Object[])params);
                while (rowSet.next()) {
                    String personId = rowSet.getString("fproposerId");
                    ArrayList<java.util.Date[]> realDates = (ArrayList<java.util.Date[]>)fileDateMap.get(personId);
                    if (realDates == null) {
                        realDates = new ArrayList<java.util.Date[]>();
                        fileDateMap.put(personId, realDates);
                    }
                    realDates.add(new java.util.Date[]{rowSet.getDate("feffdt"), rowSet.getDate("fleffdt")});
                }
            }
            catch (BOSException e) {
                e.printStackTrace();
            }
            catch (SQLException e) {
                e.printStackTrace();
            }
            realDateMap = LimitFormulaFn.getRealDateMap((java.util.Date)baseDate, fileDateMap);
            cacheService.setValueToCache(FormulaCacheLevel.DATA_GROUP, newCacheKey, realDateMap);
        }
        java.util.Date[] res = (java.util.Date[])realDateMap.get(String.valueOf(formulaCtx.getCurSchemeDataSorces().get("person.id")));
        Date comparObj = Date.getTime((Object)compareDate);
        if (res == null) {
            return comparObj;
        }
        return isStartDate ? (comparObj.after(res[0]) ? comparObj : res[0]) : (comparObj.before(res[1]) ? comparObj : res[1]);
    }

    private static Map<String, java.util.Date[]> getRealDateMap(java.util.Date baseDate, Map<String, List<java.util.Date[]>> realDateMap) {
        Comparator<java.util.Date[]> Comparator2 = new Comparator<java.util.Date[]>(){

            @Override
            public int compare(java.util.Date[] o1, java.util.Date[] o2) {
                long diff = o1[0].getTime() - o2[0].getTime();
                return diff > 0L ? 1 : (diff < 0L ? -1 : 0);
            }
        };
        long baseLong = baseDate.getTime();
        java.util.Date[] realDate = null;
        HashMap<String, java.util.Date[]> resultMap = new HashMap<String, java.util.Date[]>();
        for (Map.Entry<String, List<java.util.Date[]>> realEntry : realDateMap.entrySet()) {
            java.util.Date[] realDateTemp;
            int i;
            List<java.util.Date[]> realDates = realEntry.getValue();
            Collections.sort(realDates, Comparator2);
            int curFileIndex = -1;
            for (i = 0; i < realDates.size(); ++i) {
                realDateTemp = realDates.get(i);
                if (realDateTemp[0].getTime() > baseLong || realDateTemp[1].getTime() < baseLong) continue;
                realDate = realDateTemp;
                curFileIndex = i;
                break;
            }
            if (realDate == null) continue;
            for (i = curFileIndex + 1; i < realDates.size(); ++i) {
                realDateTemp = realDates.get(i);
                if (realDateTemp[0].getTime() != realDate[1].getTime() + 86400000L) continue;
                realDate[1] = realDateTemp[1];
            }
            i = curFileIndex;
            while (--i >= 0) {
                realDateTemp = realDates.get(i);
                if (realDateTemp[1].getTime() + 86400000L != realDate[0].getTime()) continue;
                realDate[0] = realDateTemp[0];
            }
            resultMap.put(realEntry.getKey(), realDate);
        }
        return resultMap;
    }
}

