/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.hr.ats.holidayLimit.generate.manager;

import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectCollection;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.base.permission.UserInfo;
import com.kingdee.eas.framework.CoreBaseCollection;
import com.kingdee.eas.hr.ats.AtsHolidayFileHisCollection;
import com.kingdee.eas.hr.ats.AtsHolidayFileHisFactory;
import com.kingdee.eas.hr.ats.AtsHolidayResEnum;
import com.kingdee.eas.hr.ats.HolidayLimitCollection;
import com.kingdee.eas.hr.ats.HolidayLimitDetailCollection;
import com.kingdee.eas.hr.ats.HolidayLimitDetailFactory;
import com.kingdee.eas.hr.ats.HolidayLimitDetailInfo;
import com.kingdee.eas.hr.ats.HolidayLimitFactory;
import com.kingdee.eas.hr.ats.HolidayLimitInfo;
import com.kingdee.eas.hr.ats.ResourceEnum;
import com.kingdee.eas.hr.ats.common.AtsTempTableUtil;
import com.kingdee.eas.hr.ats.holidayLimit.generate.manager.GenerateHolidayLimitThread;
import com.kingdee.eas.hr.ats.holidayLimit.generate.preparedata.GenHolidayLimitPrepareData;
import com.kingdee.eas.hr.ats.holidayLimit.generate.service.GenHolidayLimitCommon;
import com.kingdee.eas.hr.ats.holidayLimit.generate.service.impl.GenHolidayLimitAddNewServiceImpl;
import com.kingdee.eas.hr.ats.holidayLimit.generate.service.impl.GenHolidayLimitUpdateServiceImpl;
import com.kingdee.eas.hr.ats.holidayLimit.generate.util.AtsParentalLeaveUtil;
import com.kingdee.eas.hr.ats.holidayLimit.generate.util.CommUtil;
import com.kingdee.eas.hr.ats.holidayLimit.generate.util.GenHolidayLimitSQL;
import com.kingdee.eas.hr.ats.holidayLimit.generate.util.GenHolidayLimitUtil;
import com.kingdee.eas.hr.ats.holidayLimit.generate.util.HRTimeWebUtils;
import com.kingdee.eas.hr.ats.util.AtsDateUtils;
import com.kingdee.eas.hr.ats.util.AtsServerCalUtils;
import com.kingdee.eas.hr.ats.util.TranLimitUtil;
import com.kingdee.eas.hr.ats.util.common.AtsCollectionUtile;
import com.kingdee.eas.hr.ats.util.common.DataSaver;
import com.kingdee.eas.hr.ats.util.common.MLUtile;
import com.kingdee.eas.hr.base.EmpPosOrgRelationCollection;
import com.kingdee.eas.hr.base.EmpPosOrgRelationFactory;
import com.kingdee.eas.hr.base.EmpPosOrgRelationInfo;
import com.kingdee.eas.hr.base.HRBizDefineFactory;
import com.kingdee.eas.hr.base.HRBizDefineInfo;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.shr.base.permission.api.auth.SHRUserOrgPermissionApi;
import java.math.BigDecimal;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import org.apache.commons.lang3.StringUtils;
import org.apache.log4j.Logger;

public class GenHolidayLimitManager {
    private static Logger logger = Logger.getLogger(GenHolidayLimitManager.class);
    private static final int PERSONQUERY_PAGECOUNT = 1000;
    private static final int PERSON_PAGECOUNT = 1000;
    private static final int THREAD_PERSON_PER_COUNT = 200;
    private static final int MAX_THREAD_SIZE = 5;
    public static final String GENTYPE = "GENTYPE";

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<String, Object> generateAllHolidayLimit(Context ctx, Map<Object, Object> param) {
        try {
            param.put(GENTYPE, "GENTYPE_ALL");
            String adminOrgTempTable = "";
            Map<Object, Object> personTypeMap = new HashMap();
            try {
                String transaction = (String)param.get("transaction");
                if (StringUtils.isEmpty((CharSequence)transaction)) {
                    String serviceId = (String)param.get("serviceId");
                    UserInfo currentUserInfo = (UserInfo)ctx.get((Object)"UserInfo");
                    String userId = currentUserInfo.getId().toString();
                    String adminOrgUnitSql = SHRUserOrgPermissionApi.getUserAdminRangeSQL((Context)ctx, (String)userId, (String)serviceId);
                    adminOrgUnitSql = "select fid from t_org_admin adminOrgUnit where fid in (" + adminOrgUnitSql + ")";
                    adminOrgTempTable = AtsTempTableUtil.createTempTable(ctx, adminOrgUnitSql);
                    param.put("adminOrgTempTable", adminOrgTempTable);
                }
                String holidayLimitSql = GenHolidayLimitSQL.getGenerateAllHolidayLimitSql(ctx, param);
                logger.error((Object)MLUtile.getRes((ResourceEnum)AtsHolidayResEnum.GenerateLimitSumPerSQL, ctx, "GENTYPE_ALL", holidayLimitSql));
                personTypeMap = this.getPersonMap(ctx, holidayLimitSql);
            }
            finally {
                AtsTempTableUtil.releaseTable(ctx, adminOrgTempTable);
            }
            if (null != personTypeMap && personTypeMap.size() > 0) {
                ArrayList<Object> personList = new ArrayList<Object>(personTypeMap.keySet());
                param.put("PERSONHOLIDAYTYPES", personTypeMap);
                if (!personList.isEmpty()) {
                    return this.doGenerate(ctx, personList, param);
                }
            }
        }
        catch (Exception e) {
            logger.error((Object)"generateAllHolidayLimit error");
            e.printStackTrace();
        }
        return null;
    }

    public Map<String, Object> generateNewHolidayLimit(Context ctx, Map<Object, Object> param) {
        Map<String, Object> result = null;
        try {
            int preDay;
            param.put(GENTYPE, "GENTYPE_NEW");
            if (!param.containsKey("cycleDate")) {
                param.put("cycleDate", AtsDateUtils.dateShortToString(new Date()));
            }
            String holidayLimitSql = GenHolidayLimitSQL.getGenerateNewHolidayLimitSql(ctx, param);
            logger.error((Object)("GENTYPE_NEWbuild limit total person sql: " + holidayLimitSql));
            Map<String, List<String>> personTypeMap = this.getPersonMap(ctx, holidayLimitSql);
            if (null != personTypeMap && personTypeMap.size() > 0) {
                AtsParentalLeaveUtil.updateAddLimitWithParentalLeave(ctx, param, personTypeMap);
                ArrayList<String> personList = new ArrayList<String>(personTypeMap.keySet());
                param.put("PERSONHOLIDAYTYPES", personTypeMap);
                result = this.doGenerate(ctx, personList, param);
            }
            if ((preDay = this.getPreDay(ctx)) > 0) {
                param.put("cycleDate", AtsDateUtils.dateShortToString(AtsDateUtils.dateAdd(new Date(), 3, preDay)));
                holidayLimitSql = GenHolidayLimitSQL.getGenerateNewHolidayLimitSql(ctx, param);
                logger.error((Object)("GENTYPE_NEW commit build next limit total person sql: " + holidayLimitSql));
                personTypeMap = this.getPersonMap(ctx, holidayLimitSql);
                if (null != personTypeMap && personTypeMap.size() > 0) {
                    AtsParentalLeaveUtil.updateAddLimitWithParentalLeave(ctx, param, personTypeMap);
                    ArrayList<String> personList = new ArrayList<String>(personTypeMap.keySet());
                    param.put("PERSONHOLIDAYTYPES", personTypeMap);
                    this.doGenerate(ctx, personList, param);
                }
            }
        }
        catch (Exception e) {
            logger.error((Object)"generateNewHolidayLimit error");
            e.printStackTrace();
        }
        return result;
    }

    public Map<String, Object> generateUpdateHolidayLimit(Context ctx, Map<Object, Object> param) {
        try {
            param.put(GENTYPE, "GENTYPE_UPDATE");
            if (!param.containsKey("cycleDate")) {
                param.put("cycleDate", AtsDateUtils.dateShortToString(new Date()));
            }
            String holidayLimitSql = GenHolidayLimitSQL.getGenerateUpdateHolidayLimitSql(ctx, param);
            logger.error((Object)("GENTYPE_UPDATEgenerate limit total person sql: " + holidayLimitSql));
            Map<String, List<String>> personTypeMap = this.getPersonMap(ctx, holidayLimitSql);
            if (null != personTypeMap && personTypeMap.size() > 0) {
                AtsParentalLeaveUtil.updateAddLimitWithParentalLeave(ctx, param, personTypeMap);
                ArrayList<String> personList = new ArrayList<String>(personTypeMap.keySet());
                param.put("PERSONHOLIDAYTYPES", personTypeMap);
                return this.doGenerate(ctx, personList, param);
            }
        }
        catch (Exception e) {
            logger.error((Object)"generateNewHolidayLimit error");
            e.printStackTrace();
        }
        return null;
    }

    public Map<String, Object> doGenerate(Context ctx, List<String> personList, Map<Object, Object> param) {
        long startTime = System.currentTimeMillis();
        ConcurrentHashMap<String, Object> resultMap = new ConcurrentHashMap();
        try {
            int totalCount = personList.size();
            if (totalCount < 1000) {
                resultMap = (Map)GenHolidayLimitManager.genHolidayLimitProcess(ctx, personList, param);
            } else {
                ArrayList<Future<Object>> futureList = new ArrayList<Future<Object>>();
                ExecutorService fixedThreadPool = Executors.newFixedThreadPool(5);
                double threadPerSize = Math.ceil(totalCount / 5);
                int threadPerSizeInt = (int)threadPerSize;
                int startCount = 0;
                int nowCountSize = threadPerSizeInt;
                boolean out = false;
                while (!out) {
                    if (nowCountSize > totalCount) {
                        nowCountSize = totalCount;
                        out = true;
                    }
                    GenerateHolidayLimitThread callable = new GenerateHolidayLimitThread(ctx, personList.subList(startCount, nowCountSize), param);
                    Future<Object> future = fixedThreadPool.submit(callable);
                    futureList.add(future);
                    startCount += threadPerSizeInt;
                    nowCountSize += threadPerSizeInt;
                }
                for (int i = 0; i < futureList.size(); ++i) {
                    try {
                        Map genResult = (Map)((Future)futureList.get(i)).get();
                        GenHolidayLimitManager.putAllToResultMap(genResult, resultMap);
                        continue;
                    }
                    catch (InterruptedException e) {
                        e.printStackTrace();
                        continue;
                    }
                    catch (ExecutionException e) {
                        e.printStackTrace();
                    }
                }
                fixedThreadPool.shutdown();
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        List errorMsgList = (List)resultMap.get("errorMsgList");
        if (!errorMsgList.isEmpty()) {
            for (int i = 0; i < errorMsgList.size(); ++i) {
                logger.error((Object)("generate leave limit fail:" + (String)errorMsgList.get(i) + ")"));
            }
        }
        logger.error((Object)("generate holiday limit end ,total cost:" + (System.currentTimeMillis() - startTime)));
        return resultMap;
    }

    public static Object genHolidayLimitProcess(Context ctx, List<String> personIdList, Map<Object, Object> param) {
        HashMap<String, Object> resultMap = new HashMap<String, Object>();
        int totalCount = personIdList.size();
        logger.error((Object)("generate limit per thread person count\uff1a" + totalCount));
        if (totalCount > 0) {
            long startTime = System.currentTimeMillis();
            int rows = 200;
            int pages = 0;
            pages = totalCount % rows == 0 ? totalCount / rows : totalCount / rows + 1;
            int inner = 0;
            for (int i = 0; i < pages; ++i) {
                ArrayList<String> outPersonList = new ArrayList<String>();
                for (int j = inner; j < inner + rows; ++j) {
                    if (j >= totalCount) continue;
                    outPersonList.add(personIdList.get(j));
                }
                inner += rows;
                logger.error((Object)("generate limit per thread per batch person count\uff1a" + outPersonList.size()));
                String personIds = AtsServerCalUtils.getPersonIdsNoQuote(outPersonList);
                Map<Object, Object> threadParamMap = GenHolidayLimitManager.assembleThreadMap(param, outPersonList);
                threadParamMap.put("personIds", personIds);
                HashMap<Object, Object> globalMap = new HashMap<Object, Object>();
                GenHolidayLimitPrepareData.prepareData(ctx, threadParamMap, globalMap);
                GenHolidayLimitCommon genHolidayLimitService = null;
                genHolidayLimitService = param.get(GENTYPE).equals("GENTYPE_NEW") ? new GenHolidayLimitAddNewServiceImpl() : new GenHolidayLimitUpdateServiceImpl();
                genHolidayLimitService.initData(ctx, threadParamMap, globalMap);
                Map<String, Object> genResult = genHolidayLimitService.generateHolidayLimit(ctx);
                GenHolidayLimitManager.putAllToResultMap(genResult, resultMap);
                genHolidayLimitService.clearData();
            }
            logger.error((Object)("gererate holiday limit one batch end,cost\uff1a" + (System.currentTimeMillis() - startTime)));
        }
        return resultMap;
    }

    private static Map<Object, Object> assembleThreadMap(Map<Object, Object> param, List<String> outPersonList) {
        HashMap<Object, Object> threadParamMap = new HashMap<Object, Object>();
        HashMap personTypeMap = new HashMap();
        Set<Map.Entry<Object, Object>> paramEntrySet = param.entrySet();
        for (Map.Entry<Object, Object> entry : paramEntrySet) {
            String key = (String)entry.getKey();
            if (key.equals("PERSONHOLIDAYTYPES")) {
                Map ptMap = (Map)entry.getValue();
                Set ptEntrySet = ptMap.entrySet();
                for (Map.Entry ptEntry : ptEntrySet) {
                    String ptKey = (String)ptEntry.getKey();
                    if (!outPersonList.contains(ptKey)) continue;
                    personTypeMap.put(ptKey, ptEntry.getValue());
                }
                threadParamMap.put("PERSONHOLIDAYTYPES", personTypeMap);
                continue;
            }
            threadParamMap.put(key, entry.getValue());
        }
        return threadParamMap;
    }

    public Map<String, List<String>> getPersonMap(Context ctx, String holidayLimitSql) throws Exception {
        long startTime = System.currentTimeMillis();
        HashMap<String, List<String>> personTypeMap = new HashMap<String, List<String>>();
        int totalCount = 0;
        String str = "";
        str = holidayLimitSql.indexOf("order by ") != -1 ? holidayLimitSql.substring(0, holidayLimitSql.indexOf("order by ")) : holidayLimitSql;
        IRowSet rowSet = DbUtil.executeQuery((Context)ctx, (String)("select count(1) from (" + str + "  ) tt "));
        totalCount = GenHolidayLimitUtil.getTotalCount(rowSet);
        int rows_one = 1000;
        int pages_one = 0;
        pages_one = totalCount % rows_one == 0 ? totalCount / rows_one : totalCount / rows_one + 1;
        for (int page = 1; page <= pages_one; ++page) {
            IRowSet rs = GenHolidayLimitUtil.executeQueryToExcelPaging(holidayLimitSql, rows_one, page, totalCount, ctx);
            while (rs.next()) {
                String personId = rs.getString("personId");
                String holidayTypeId = rs.getString("holidayTypeId");
                ArrayList<String> types = (ArrayList<String>)personTypeMap.get(personId);
                if (null == types) {
                    types = new ArrayList<String>();
                    types.add(holidayTypeId);
                    personTypeMap.put(personId, types);
                    continue;
                }
                types.add(holidayTypeId);
            }
        }
        logger.error((Object)("generate holiday limit query person cost\uff1a" + (System.currentTimeMillis() - startTime) + "ms,generate person total count:" + personTypeMap.size()));
        return personTypeMap;
    }

    public static void putAllToResultMap(Map<String, Object> genResult, Map<String, Object> resultMap) {
        if (genResult != null) {
            CoreBaseCollection currLimitColl;
            Integer currentUpdateCnt;
            Integer currentInsertCnt;
            List curErrorMsgList = (List)genResult.get("errorMsgList");
            if (null != curErrorMsgList) {
                ArrayList errorMsgList = (ArrayList)resultMap.get("errorMsgList");
                if (null == errorMsgList) {
                    errorMsgList = new ArrayList();
                    errorMsgList.addAll(curErrorMsgList);
                    resultMap.put("errorMsgList", errorMsgList);
                } else {
                    errorMsgList.addAll(curErrorMsgList);
                }
            }
            if (null != (currentInsertCnt = (Integer)genResult.get("INSERTCOUNT"))) {
                Integer insertCount = (Integer)resultMap.get("INSERTCOUNT");
                if (null == insertCount) {
                    resultMap.put("INSERTCOUNT", currentInsertCnt);
                } else {
                    resultMap.put("INSERTCOUNT", currentInsertCnt + insertCount);
                }
            }
            if (null != (currentUpdateCnt = (Integer)genResult.get("UPDATECOUNT"))) {
                Integer updateCount = (Integer)resultMap.get("UPDATECOUNT");
                if (null == updateCount) {
                    resultMap.put("UPDATECOUNT", currentUpdateCnt);
                } else {
                    resultMap.put("UPDATECOUNT", currentUpdateCnt + updateCount);
                }
            }
            if (null != (currLimitColl = (CoreBaseCollection)genResult.get("UPDATELIMIT"))) {
                CoreBaseCollection updatelimitColl = (CoreBaseCollection)resultMap.get("UPDATELIMIT");
                if (null == updatelimitColl) {
                    updatelimitColl = new CoreBaseCollection();
                    updatelimitColl.addCollection(currLimitColl);
                    resultMap.put("UPDATELIMIT", updatelimitColl);
                } else {
                    updatelimitColl.addCollection(currLimitColl);
                }
            }
        }
    }

    public int getPreDay(Context ctx) {
        int preDay = 0;
        String val = "";
        String keyId = "+yEGqzBSsEOpsWyUnHUQ1qiB8+c=";
        StringBuffer sb = new StringBuffer();
        sb.append(" SELECT FVALUE" + MLUtile.getMlFlag(ctx) + " FROM T_BAS_PARAMITEM ITEM \n");
        sb.append(" inner join T_BAS_Param param on param.fid = item.fkeyid \n");
        sb.append(" where fkeyid ='" + keyId + "' \n");
        try {
            IRowSet row = DbUtil.executeQuery((Context)ctx, (String)sb.toString());
            if (row.next()) {
                val = row.getString("FVALUE" + MLUtile.getMlFlag(ctx));
            }
            preDay = Integer.valueOf(val);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return preDay;
    }

    public void addShiftTotalRemainLimit(HolidayLimitInfo holidayLimitInfo, boolean isUpdateDB, Context ctx) {
        logger.debug((Object)MessageFormat.format("holidayLimitInfo={0}", holidayLimitInfo));
        if (holidayLimitInfo == null) {
            return;
        }
        HolidayLimitCollection holidayLimitCollection = new HolidayLimitCollection();
        holidayLimitCollection.add(holidayLimitInfo);
        this.addShiftTotalRemainLimit(holidayLimitCollection, isUpdateDB, ctx);
    }

    public void addShiftTotalRemainLimit(HolidayLimitCollection holidayLimitCollection, boolean isUpdateDB, Context ctx) {
        logger.debug((Object)MessageFormat.format("holidayLimitCollection={0}", new Object[]{holidayLimitCollection}));
        if (AtsCollectionUtile.isEmpty((IObjectCollection)holidayLimitCollection)) {
            logger.debug((Object)"holidayLimitCollection is empty");
            return;
        }
        List priKeyList = CommUtil.getPriKey((IObjectCollection)holidayLimitCollection, "id");
        if (priKeyList == null || priKeyList.size() == 0) {
            logger.debug((Object)"priKeyList is empty");
            return;
        }
        try {
            int i;
            EntityViewInfo viewInfo = new EntityViewInfo();
            SelectorItemCollection sic = new SelectorItemCollection();
            sic.add(new SelectorItemInfo("id"));
            sic.add(new SelectorItemInfo("changeValue"));
            sic.add(new SelectorItemInfo("changeUnit"));
            sic.add(new SelectorItemInfo("holidayLimit.id"));
            viewInfo.setSelector(sic);
            FilterInfo filterInfo = new FilterInfo();
            filterInfo.getFilterItems().add(new FilterItemInfo("changeType", (Object)4));
            filterInfo.getFilterItems().add(new FilterItemInfo("status", (Object)1));
            filterInfo.getFilterItems().add(new FilterItemInfo("holidayLimitDetailType", (Object)1));
            filterInfo.getFilterItems().add(new FilterItemInfo("holidayLimit.id", new HashSet(priKeyList), CompareType.INCLUDE));
            viewInfo.setFilter(filterInfo);
            HolidayLimitDetailCollection holidayLimitDetailCollection = HolidayLimitDetailFactory.getLocalInstance(ctx).getHolidayLimitDetailCollection(viewInfo);
            logger.debug((Object)MessageFormat.format("viewInfo={0},holidayLimitDetailCollection={1}", new Object[]{viewInfo, holidayLimitDetailCollection}));
            if (AtsCollectionUtile.isEmpty((IObjectCollection)holidayLimitDetailCollection)) {
                return;
            }
            HashMap holidayLimitDetailInfoMap = new HashMap();
            for (i = 0; i < holidayLimitDetailCollection.size(); ++i) {
                HolidayLimitDetailInfo holidayLimitDetailInfo = holidayLimitDetailCollection.get(i);
                if (holidayLimitDetailInfo == null) continue;
                List holidayLimitDetailInfoList = (List)holidayLimitDetailInfoMap.get(holidayLimitDetailInfo.getHolidayLimit().getId());
                if (holidayLimitDetailInfoList == null) {
                    holidayLimitDetailInfoMap.put(holidayLimitDetailInfo.getHolidayLimit().getId(), new ArrayList());
                }
                ((List)holidayLimitDetailInfoMap.get(holidayLimitDetailInfo.getHolidayLimit().getId())).add(holidayLimitDetailInfo);
            }
            for (i = 0; i < holidayLimitCollection.size(); ++i) {
                BOSUuid holidayLimitId;
                HolidayLimitInfo holidayLimitInfo = holidayLimitCollection.get(i);
                if (holidayLimitInfo == null || holidayLimitDetailInfoMap.get(holidayLimitId = holidayLimitInfo.getId()) == null) continue;
                List holidayLimitDetailInfoList = (List)holidayLimitDetailInfoMap.get(holidayLimitId);
                BigDecimal shiftTotalRemainLimit = BigDecimal.ZERO;
                for (HolidayLimitDetailInfo holidayLimitDetailInfo : holidayLimitDetailInfoList) {
                    if (holidayLimitDetailInfo.getChangeValue() == null) {
                        logger.debug((Object)MessageFormat.format("ChangeUnit or ChangeValue is null.holidayLimitDetailInfo={0}", holidayLimitDetailInfo));
                        continue;
                    }
                    shiftTotalRemainLimit = shiftTotalRemainLimit.add(holidayLimitDetailInfo.getChangeValue());
                }
                holidayLimitInfo.setShiftTotalRemainLimit(shiftTotalRemainLimit);
                holidayLimitInfo.setRemainLimit(holidayLimitInfo.getRemainLimit().subtract(shiftTotalRemainLimit));
            }
            if (isUpdateDB) {
                DataSaver dataSaver = new DataSaver();
                dataSaver.setCtx(ctx).save(holidayLimitCollection);
            }
            logger.debug((Object)MessageFormat.format("holidayLimitCollection={0}", new Object[]{holidayLimitCollection}));
        }
        catch (Exception e) {
            logger.error((Object)"catch a exception", (Throwable)e);
        }
    }

    public void transLimitForupdate(Context ctx, Map param) {
        TranLimitUtil tranLimitUtil = new TranLimitUtil();
        if (!param.containsKey("cycleDate")) {
            param.put("cycleDate", AtsDateUtils.dateShortToString(new Date()));
        }
        String holidayLimitSql = GenHolidayLimitSQL.getGenerateUpdateHolidayLimitSql(ctx, param);
        logger.error((Object)("GENTYPE_UPDATEgenerate limit total person sql: " + holidayLimitSql));
        AtsHolidayFileHisCollection fileHisCollection = null;
        try {
            Map<String, List<String>> personTypeMap = this.getPersonMap(ctx, holidayLimitSql);
            HashMap isTransPersonMap = new HashMap();
            if (null != personTypeMap && personTypeMap.size() > 0) {
                ArrayList<String> personList = new ArrayList<String>(personTypeMap.keySet());
                for (int i = 0; i < personList.size(); ++i) {
                    fileHisCollection = AtsHolidayFileHisFactory.getLocalInstance(ctx).getAtsHolidayFileHisCollection("where proposer.id='" + (String)personList.get(i) + "' and attendFileState='1' order by effdt desc");
                    if (fileHisCollection.size() < 2 || fileHisCollection.get(0).getHrOrgUnit().getId().toString().equals(fileHisCollection.get(1).getHrOrgUnit().getId().toString())) continue;
                    String leffectdate = HRTimeWebUtils.dateLongToString(fileHisCollection.get(1).getLEFFDT());
                    String oql = " where person.id='" + (String)personList.get(i) + "'  order by endDateTime desc  ";
                    EmpPosOrgRelationCollection collection = EmpPosOrgRelationFactory.getLocalInstance((Context)ctx).getEmpPosOrgRelationCollection(oql);
                    EmpPosOrgRelationInfo info = collection.get(0);
                    HRBizDefineInfo bizDefineInfo = HRBizDefineFactory.getLocalInstance((Context)ctx).getHRBizDefineInfo((IObjectPK)new ObjectUuidPK(info.getAction().getId().toString()));
                    if (16 == bizDefineInfo.getBizDefineType().getValue()) {
                        String isResEnter = (String)param.get("isResEnter");
                        if (isResEnter.isEmpty() || isResEnter.equals(0) || !isResEnter.equals(1)) continue;
                        isTransPersonMap.put(personList.get(i), leffectdate);
                        continue;
                    }
                    isTransPersonMap.put(personList.get(i), leffectdate);
                }
            }
            for (Map.Entry entry : isTransPersonMap.entrySet()) {
                String personId = (String)entry.getKey();
                String leffect = (String)entry.getValue();
                fileHisCollection = AtsHolidayFileHisFactory.getLocalInstance(ctx).getAtsHolidayFileHisCollection("where proposer.id='" + personId + "' and attendFileState='1' order by effdt desc");
                String hrOrgId = fileHisCollection.get(1).getHrOrgUnit().getId().toString();
                HolidayLimitCollection collection = HolidayLimitFactory.getLocalInstance(ctx).getHolidayLimitCollection(" where  proposer='" + personId + "' and cycleBeginDate <= '" + leffect + "' and delayDate >= '" + leffect + "'and hrOrgUnit.id= '" + hrOrgId + "'");
                if (collection.size() <= 0) continue;
                tranLimitUtil.TranLimit(ctx, collection, personId);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

