/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.hr.ats.holidayLimit.generate.rule.impl;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.eas.hr.ats.AtsHolidayFileHisCollection;
import com.kingdee.eas.hr.ats.AtsHolidayFileHisFactory;
import com.kingdee.eas.hr.ats.AtsHolidayFileHisInfo;
import com.kingdee.eas.hr.ats.AtsHolidayResEnum;
import com.kingdee.eas.hr.ats.AtsUtil;
import com.kingdee.eas.hr.ats.ConvertTypeEnum;
import com.kingdee.eas.hr.ats.CycleTypeEnum;
import com.kingdee.eas.hr.ats.HolidayPeriodUniteEnum;
import com.kingdee.eas.hr.ats.HolidayPolicyCollection;
import com.kingdee.eas.hr.ats.HolidayPolicyInfo;
import com.kingdee.eas.hr.ats.HolidayRlStdTypeEnum;
import com.kingdee.eas.hr.ats.HolidayRuleConditionCollection;
import com.kingdee.eas.hr.ats.HolidayRuleConditionGroupCollection;
import com.kingdee.eas.hr.ats.HolidayRuleInfo;
import com.kingdee.eas.hr.ats.HolidayRuleItemCollection;
import com.kingdee.eas.hr.ats.HolidayRuleItemInfo;
import com.kingdee.eas.hr.ats.HolidayTypeInfo;
import com.kingdee.eas.hr.ats.ValueTypeEnum;
import com.kingdee.eas.hr.ats.decimalPlace.DecimalPlaceContext;
import com.kingdee.eas.hr.ats.decimalPlace.strategy.IDecimalPlaceStrategy;
import com.kingdee.eas.hr.ats.decimalPlace.strategy.impl.DecimalPlaceOperationLimit;
import com.kingdee.eas.hr.ats.decimalPlace.strategy.impl.DecimalPlaceOperationSystem;
import com.kingdee.eas.hr.ats.decimalPlace.util.DecimalPlaceUtil;
import com.kingdee.eas.hr.ats.holidayLimit.generate.manager.GenPiecewiseManager;
import com.kingdee.eas.hr.ats.holidayLimit.generate.preparedata.InitHolidayLimitData;
import com.kingdee.eas.hr.ats.holidayLimit.generate.rule.GenHolidayLimitModel;
import com.kingdee.eas.hr.ats.holidayLimit.generate.rule.GenHolidayLimitRule;
import com.kingdee.eas.hr.ats.holidayLimit.generate.rule.GenPiecewiseBO;
import com.kingdee.eas.hr.ats.holidayLimit.generate.util.GenHolidayLimitUtil;
import com.kingdee.eas.hr.ats.holidayLimit.generate.util.HRTimeWebUtils;
import com.kingdee.eas.hr.ats.holidayLimit.generate.vo.GenHolidayLimitRuleVO;
import com.kingdee.eas.hr.ats.holidayLimit.generate.vo.NextGenerationInfo;
import com.kingdee.eas.hr.ats.pcRule.EmpQueryImpl;
import com.kingdee.eas.hr.ats.pcRule.GridDataEntity;
import com.kingdee.eas.hr.ats.util.AtsDateUtils;
import com.kingdee.eas.hr.ats.util.LoggerAtsJobInst;
import com.kingdee.eas.hr.ats.util.common.AtsCollectionUtile;
import com.kingdee.eas.hr.ats.util.common.MLUtile;
import com.kingdee.eas.hr.base.EmpLaborRelationInfo;
import com.kingdee.eas.hr.base.SqlParam;
import com.kingdee.eas.hr.emp.PersonOtherInfoFactory;
import com.kingdee.eas.hr.emp.PersonOtherInfoInfo;
import com.kingdee.eas.hr.emp.PersonPositionInfo;
import com.kingdee.eas.hr.org.JobGradeCollection;
import com.kingdee.eas.hr.org.JobGradeFactory;
import com.kingdee.util.DateTimeUtils;
import com.kingdee.util.StringUtils;
import com.kingdee.util.UuidException;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.sql.SQLException;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import net.sf.json.JSONObject;
import org.apache.commons.lang3.time.DateUtils;
import org.apache.log4j.Logger;

public class GenHolidayLimitRuleImpl
implements GenHolidayLimitRule {
    private static final int MOUNTHOfYEAR = 12;
    private static final int QUARTEROFYEAR = 4;
    float ppiAdjustGroupVal = 0.0f;
    float ppiAdjustCoValue = 0.0f;
    double otherInfoAdjustSerVal = 0.0;
    float yearCtnFlag = 1.0f;
    double yearCtn2Number = 0.0;
    int defaultDecimalPlacesCal = DecimalPlaceUtil.getDefaultDecimalPlacesCal();
    private static Logger logger = Logger.getLogger(GenHolidayLimitRuleImpl.class);
    private Map<String, HolidayRuleConditionGroupCollection> ruleConditionGroupMap = new HashMap<String, HolidayRuleConditionGroupCollection>();
    private Map<String, HolidayRuleItemCollection> ruleItemCollectionMap = new HashMap<String, HolidayRuleItemCollection>();
    private Map<String, HolidayRuleConditionCollection> ruleConditionMap = new HashMap<String, HolidayRuleConditionCollection>();
    private Map<String, AtsHolidayFileHisCollection> fileHisCollectionMap = new HashMap<String, AtsHolidayFileHisCollection>();
    protected IDecimalPlaceStrategy strategy_system = new DecimalPlaceOperationSystem();
    private IDecimalPlaceStrategy strategy_1 = new DecimalPlaceOperationLimit();

    public Map<String, AtsHolidayFileHisCollection> getFileHisCollectionMap() {
        return this.fileHisCollectionMap;
    }

    public void setFileHisCollectionMap(Map<String, AtsHolidayFileHisCollection> fileHisCollectionMap) {
        this.fileHisCollectionMap = fileHisCollectionMap;
    }

    public GenHolidayLimitRuleImpl(Context ctx) {
        this.ruleConditionGroupMap = InitHolidayLimitData.initPrepareRuleConditionGroupMap(ctx);
        this.ruleItemCollectionMap = InitHolidayLimitData.initPrepareConditionRuleItemsMap(ctx);
        this.ruleConditionMap = InitHolidayLimitData.initPrepareConditionItemsMap(ctx);
    }

    @Override
    public GenHolidayLimitModel getLimitModel(Context ctx, PersonPositionInfo ppi, Date cycleDate, String periodAccordType, HolidayTypeInfo holidayTypeInfo, HolidayPolicyCollection holidayPolicyCollection, HolidayPolicyInfo defaultHolidayPolicyInfo, HolidayRuleInfo holidayRuleInfo, EmpLaborRelationInfo laborInfo, PersonOtherInfoInfo otherInfo, NextGenerationInfo nextGenerationInfo) throws BOSException, UuidException, SQLException {
        GenHolidayLimitModel GenHolidayLimitModel2 = new GenHolidayLimitModel();
        GenHolidayLimitModel2.setCycleDate(cycleDate);
        String cycleDateStr = AtsDateUtils.dateShortToString(cycleDate);
        String cycleDateYearStr = cycleDateStr.substring(0, 4);
        GenHolidayLimitModel2.setYear(Integer.valueOf(cycleDateYearStr));
        HolidayPolicyInfo holidayPolicyInfo = this.getMatchPolicy(holidayTypeInfo, holidayPolicyCollection, defaultHolidayPolicyInfo);
        if (holidayPolicyInfo == null) {
            LoggerAtsJobInst.collectionExceptionInfo(ctx, MLUtile.getRes(AtsHolidayResEnum.GenerateHolidayLimitFail, ctx));
            return null;
        }
        GenHolidayLimitModel2.setHolidayPolicyInfo(holidayPolicyInfo);
        if (InitHolidayLimitData.isYearHoliday(holidayTypeInfo)) {
            this.setHolidayLimitBeginDateAndEndDate(ctx, GenHolidayLimitModel2, ppi, cycleDate, periodAccordType, holidayPolicyInfo, holidayRuleInfo, laborInfo);
        } else if (InitHolidayLimitData.isParentalHoliday(holidayTypeInfo)) {
            this.setParentalHolidayLimitBeginDateAndEndDate(ctx, GenHolidayLimitModel2, ppi, cycleDate, periodAccordType, holidayPolicyInfo, holidayRuleInfo, laborInfo, otherInfo, nextGenerationInfo);
        } else {
            this.setOtherHolidayLimitBeginDateAndEndDate(ctx, GenHolidayLimitModel2, ppi, cycleDate, periodAccordType, holidayPolicyInfo, holidayRuleInfo, laborInfo, otherInfo);
        }
        return this.isValidFirstCalcuteLimit(holidayRuleInfo, ppi, GenHolidayLimitModel2, laborInfo);
    }

    @Override
    public GenHolidayLimitModel calHolidayLimitByRule(Context ctx, GenHolidayLimitModel GenHolidayLimitModel2, PersonPositionInfo ppi, Date cycleDate, String periodAccordType, HolidayPolicyInfo holidayPolicyInfo, HolidayRuleInfo holidayRuleInfo, EmpLaborRelationInfo laborInfo, PersonOtherInfoInfo otherInfo, NextGenerationInfo nextGenerationInfo) throws BOSException, UuidException, SQLException {
        GenHolidayLimitRuleVO holidayLimitRuleVO = this.setIsNeedConvertLimt(ctx, holidayRuleInfo, ppi, GenHolidayLimitModel2, laborInfo, nextGenerationInfo);
        holidayLimitRuleVO.setGenHolidayLimitModel(GenHolidayLimitModel2);
        this.setHolidayLimitYearRange(ctx, holidayLimitRuleVO, ppi, GenHolidayLimitModel2, laborInfo, otherInfo, holidayRuleInfo, nextGenerationInfo);
        GenHolidayLimitModel2.setHolidayPolicyInfo(holidayPolicyInfo);
        BigDecimal standardLimit = this.getStandardLimit(ctx, holidayLimitRuleVO, holidayRuleInfo, ppi, nextGenerationInfo);
        GenHolidayLimitModel2.setStandardLimit(standardLimit);
        return GenHolidayLimitModel2;
    }

    private BigDecimal getStandardLimit(Context ctx, GenHolidayLimitRuleVO holidayLimitRuleVO, HolidayRuleInfo holidayRuleInfo, PersonPositionInfo ppi, NextGenerationInfo nextGenerationInfo) throws BOSException, UuidException, SQLException {
        this.yearCtnFlag = 1.0f;
        this.yearCtn2Number = 0.0;
        HolidayRlStdTypeEnum rlStdType = holidayRuleInfo.getHolidayRlStdType();
        if (holidayRuleInfo.getValueType() == ValueTypeEnum.range) {
            if (rlStdType == HolidayRlStdTypeEnum.servingAge || rlStdType == HolidayRlStdTypeEnum.workingAge || rlStdType == HolidayRlStdTypeEnum.wkSvMax) {
                return this.getWorkOrServerCalVal(ctx, holidayLimitRuleVO, holidayRuleInfo, ppi, rlStdType);
            }
            if (rlStdType == HolidayRlStdTypeEnum.childrenAge) {
                Date calEndDate;
                logger.error((Object)MessageFormat.format("-----Parental leave set calBeginTime and calEndTime.holidayLimitRuleVO={0}", holidayLimitRuleVO));
                if (holidayLimitRuleVO.getConvertType() != 4) {
                    holidayLimitRuleVO.getGenHolidayLimitModel().setCalChildDateCtnBegin(holidayLimitRuleVO.getGenHolidayLimitModel().getChildDateCtn1());
                    holidayLimitRuleVO.getGenHolidayLimitModel().setCalChildDateCtnEnd(holidayLimitRuleVO.getGenHolidayLimitModel().getChildDateCtn2());
                } else if (holidayLimitRuleVO.getConvertType() == 4) {
                    holidayLimitRuleVO.getGenHolidayLimitModel().setCalChildDateCtnBegin(holidayLimitRuleVO.getGenHolidayLimitModel().getChildDateCtn3());
                    holidayLimitRuleVO.getGenHolidayLimitModel().setCalChildDateCtnEnd(holidayLimitRuleVO.getGenHolidayLimitModel().getChildDateCtn3());
                }
                logger.error((Object)MessageFormat.format("-----Parental leave set calBeginTime and calEndTime.holidayLimitRuleVO={0}", holidayLimitRuleVO));
                Date calBeginTime = holidayLimitRuleVO.getGenHolidayLimitModel().getCalChildDateCtnBegin();
                Date calEndTime = holidayLimitRuleVO.getGenHolidayLimitModel().getCycleEndDate();
                if (holidayLimitRuleVO.isConvert()) {
                    if (holidayLimitRuleVO.getServe_ConvertDate() != null && holidayLimitRuleVO.getServe_ConvertDate().after(calBeginTime) && holidayLimitRuleVO.getServe_ConvertDate().before(calEndTime)) {
                        holidayLimitRuleVO.getGenHolidayLimitModel().setCalChildDateCtnBegin(holidayLimitRuleVO.getServe_ConvertDate());
                    }
                } else if (holidayLimitRuleVO.getGenHolidayLimitModel().getLeftEndDate() != null && holidayLimitRuleVO.getGenHolidayLimitModel().getLeftEndDate().after(calBeginTime) && holidayLimitRuleVO.getGenHolidayLimitModel().getLeftEndDate().before(calEndTime)) {
                    holidayLimitRuleVO.getGenHolidayLimitModel().setCalChildDateCtnEnd(holidayLimitRuleVO.getGenHolidayLimitModel().getLeftEndDate());
                }
                logger.error((Object)MessageFormat.format("-----Parental leave set calBeginTime and calEndTime.holidayLimitRuleVO={0}", holidayLimitRuleVO));
                BigDecimal standardVal = this.getHolidayRlStdTypeCalVal(ctx, holidayLimitRuleVO, holidayRuleInfo, ppi, holidayLimitRuleVO.getConvertType(), rlStdType, holidayLimitRuleVO.getChildYearCtn1(), holidayLimitRuleVO.getChildYearCtn2(), holidayLimitRuleVO.getChildYearCtn3(), holidayLimitRuleVO.getChildYearCtn1(), holidayLimitRuleVO.getChildYearCtn2(), holidayLimitRuleVO.getChildYearCtn3(), holidayLimitRuleVO.getStepYear(), holidayLimitRuleVO.isConvert(), holidayLimitRuleVO.getMinChildConvertUnit());
                if (holidayLimitRuleVO.getVal1RuleItem() != null && holidayLimitRuleVO.getVal2RuleItem() == null && (calEndDate = DateUtils.addYears((Date)nextGenerationInfo.getBirthdayDate(), (int)holidayLimitRuleVO.getVal1RuleItem().getNext().intValue())).after(holidayLimitRuleVO.getGenHolidayLimitModel().getCalChildDateCtnBegin()) && calEndDate.before(holidayLimitRuleVO.getGenHolidayLimitModel().getCalChildDateCtnEnd())) {
                    holidayLimitRuleVO.getGenHolidayLimitModel().setCalChildDateCtnEnd(calEndDate);
                }
                return standardVal;
            }
            if (rlStdType == HolidayRlStdTypeEnum.MarriageAge) {
                return this.getHolidayRlStdTypeCalVal(ctx, holidayLimitRuleVO, holidayRuleInfo, ppi, holidayLimitRuleVO.getConvertType(), rlStdType, holidayLimitRuleVO.getWedYearCtn1(), holidayLimitRuleVO.getWedYearCtn2(), holidayLimitRuleVO.getWedYearCtn3(), holidayLimitRuleVO.getWedYearCtn1(), holidayLimitRuleVO.getWedYearCtn2(), holidayLimitRuleVO.getWedYearCtn3(), holidayLimitRuleVO.getStepYear(), holidayLimitRuleVO.isConvert(), holidayLimitRuleVO.getMinWedConvertUnit());
            }
            logger.error((Object)"can't recognized param exception");
            throw new RuntimeException(MessageFormat.format("can't recognized param exception.rlStdType={0}", new Object[]{rlStdType}));
        }
        if (holidayRuleInfo.getValueType() == ValueTypeEnum.fixedValue) {
            if ("4F7rXAuSEFjgUzsFEqwuZ/0tUpg=".equals(holidayRuleInfo.getHolidayType().getId().toString()) && holidayLimitRuleVO != null && holidayLimitRuleVO.getGenHolidayLimitModel() != null) {
                if (holidayLimitRuleVO.getGenHolidayLimitModel().getCycleBeginDate() != null) {
                    holidayLimitRuleVO.getGenHolidayLimitModel().setCalChildDateCtnBegin(holidayLimitRuleVO.getGenHolidayLimitModel().getCycleBeginDate());
                }
                if (holidayLimitRuleVO.getGenHolidayLimitModel().getCycleEndDate() != null) {
                    holidayLimitRuleVO.getGenHolidayLimitModel().setCalChildDateCtnEnd(holidayLimitRuleVO.getGenHolidayLimitModel().getCycleEndDate());
                }
            }
            return this.getHolidayRlStdTypeCalVal(ctx, holidayLimitRuleVO, holidayRuleInfo, ppi, holidayLimitRuleVO.getConvertType(), rlStdType, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f, holidayLimitRuleVO.getStepYear(), holidayLimitRuleVO.isConvert(), holidayLimitRuleVO.getMinChildConvertUnit());
        }
        logger.error((Object)"can't recognized param exception");
        throw new RuntimeException(MessageFormat.format("can't recognized param exception.ValueType={0}", new Object[]{holidayRuleInfo.getValueType()}));
    }

    private BigDecimal getWorkOrServerCalVal(Context ctx, GenHolidayLimitRuleVO holidayLimitRuleVO, HolidayRuleInfo holidayRuleInfo, PersonPositionInfo ppi, HolidayRlStdTypeEnum rlStdType) {
        float work_yearCtn1 = holidayLimitRuleVO.getWork_yearCtn1();
        float work_yearCtn2 = holidayLimitRuleVO.getWork_yearCtn2();
        float work_yearCtn3 = holidayLimitRuleVO.getWork_yearCtn3();
        float serve_yearCtn1 = holidayLimitRuleVO.getServe_yearCtn1();
        float serve_yearCtn2 = holidayLimitRuleVO.getServe_yearCtn2();
        float serve_yearCtn3 = holidayLimitRuleVO.getServe_yearCtn3();
        float serve_yearCtn1Item = serve_yearCtn1;
        float serve_yearCtn2Item = serve_yearCtn2;
        float serve_yearCtn3Item = serve_yearCtn3;
        float work_yearCtn1Item = work_yearCtn1;
        float work_yearCtn2Item = work_yearCtn2;
        float work_yearCtn3Item = work_yearCtn3;
        if (holidayRuleInfo.isIsDeductServeAdjustV()) {
            if (holidayLimitRuleVO.getCalcuteOurAgeStyle() == 0 || holidayLimitRuleVO.getCalcuteOurAgeStyle() == 4) {
                serve_yearCtn1Item = serve_yearCtn1 - this.ppiAdjustGroupVal;
                serve_yearCtn2Item = serve_yearCtn2 - this.ppiAdjustGroupVal;
                serve_yearCtn3Item = serve_yearCtn3 - this.ppiAdjustGroupVal;
            } else if (holidayLimitRuleVO.getCalcuteOurAgeStyle() == 1) {
                serve_yearCtn1Item = serve_yearCtn1 - this.ppiAdjustCoValue;
                serve_yearCtn2Item = serve_yearCtn2 - this.ppiAdjustCoValue;
                serve_yearCtn3Item = serve_yearCtn3 - this.ppiAdjustCoValue;
            }
        }
        if (holidayRuleInfo.isIsDeductWorkAdjustV()) {
            work_yearCtn1Item = (float)((double)work_yearCtn1 - this.otherInfoAdjustSerVal);
            work_yearCtn2Item = (float)((double)work_yearCtn2 - this.otherInfoAdjustSerVal);
            work_yearCtn3Item = (float)((double)work_yearCtn3 - this.otherInfoAdjustSerVal);
        }
        int stepYear = holidayLimitRuleVO.getStepYear();
        boolean isConvert = holidayLimitRuleVO.isConvert();
        float workConvertUnit = holidayLimitRuleVO.getMinWorkConvertUnit();
        float serveConvertUnit = holidayLimitRuleVO.getMinServeConvertUnit();
        if (HolidayRlStdTypeEnum.workingAge == rlStdType) {
            return this.getHolidayRlStdTypeCalVal(ctx, holidayLimitRuleVO, holidayRuleInfo, ppi, holidayLimitRuleVO.getConverWorkType(), rlStdType, work_yearCtn1, work_yearCtn2, work_yearCtn3, work_yearCtn1Item, work_yearCtn2Item, work_yearCtn3Item, stepYear, isConvert, workConvertUnit);
        }
        if (HolidayRlStdTypeEnum.servingAge == rlStdType) {
            return this.getHolidayRlStdTypeCalVal(ctx, holidayLimitRuleVO, holidayRuleInfo, ppi, holidayLimitRuleVO.getConverServeType(), rlStdType, serve_yearCtn1, serve_yearCtn2, serve_yearCtn3, serve_yearCtn1Item, serve_yearCtn2Item, serve_yearCtn3Item, stepYear, false, serveConvertUnit);
        }
        if (HolidayRlStdTypeEnum.wkSvMax == rlStdType) {
            BigDecimal workVal = this.getHolidayRlStdTypeCalVal(ctx, holidayLimitRuleVO, holidayRuleInfo, ppi, holidayLimitRuleVO.getConverWorkType(), HolidayRlStdTypeEnum.workingAge, work_yearCtn1, work_yearCtn2, work_yearCtn3, work_yearCtn1Item, work_yearCtn2Item, work_yearCtn3Item, stepYear, isConvert, workConvertUnit);
            BigDecimal serverVal = this.getHolidayRlStdTypeCalVal(ctx, holidayLimitRuleVO, holidayRuleInfo, ppi, holidayLimitRuleVO.getConverServeType(), HolidayRlStdTypeEnum.servingAge, serve_yearCtn1, serve_yearCtn2, serve_yearCtn3, serve_yearCtn1Item, serve_yearCtn2Item, serve_yearCtn3Item, stepYear, false, serveConvertUnit);
            BigDecimal resultVal = workVal.floatValue() >= serverVal.floatValue() ? workVal : serverVal;
            return resultVal;
        }
        logger.error((Object)"can't recognized param exception");
        throw new RuntimeException(MessageFormat.format("can't recognized param exception.rlStdType={0}", new Object[]{rlStdType}));
    }

    private BigDecimal getHolidayRlStdTypeCalVal(Context ctx, GenHolidayLimitRuleVO holidayLimitRuleVO, HolidayRuleInfo holidayRuleInfo, PersonPositionInfo ppi, int convertType, HolidayRlStdTypeEnum rlStdType, float yearCtn1, float yearCtn2, float yearCtn3, float yearCtn1Item, float yearCtn2Item, float yearCtn3Item, int stepYear, boolean isConvert, float convertUnit) {
        HolidayRuleItemCollection holidayRuleItemCollection = new HolidayRuleItemCollection();
        BigDecimal bd = new BigDecimal(-1.0E9);
        String personId = ppi.getPerson().getId().toString();
        HolidayRuleConditionGroupCollection conditionGroupColl = this.ruleConditionGroupMap.get(holidayRuleInfo.getId().toString());
        if (conditionGroupColl.size() == 0) {
            System.out.println("conditionGroupColl size == 0:" + personId);
        }
        for (int i = 0; i < conditionGroupColl.size(); ++i) {
            HolidayRuleConditionCollection conditionColl = this.ruleConditionMap.get(conditionGroupColl.get(i).getId().toString());
            if (!this.conditionDeal(ctx, conditionColl, personId).booleanValue()) continue;
            if (holidayRuleInfo.getValueType() == ValueTypeEnum.fixedValue && holidayRuleInfo.getFixedValue() != null) {
                return holidayRuleInfo.getFixedValue().setScale(this.defaultDecimalPlacesCal, RoundingMode.HALF_UP);
            }
            bd = new BigDecimal(0.0);
            HolidayRuleItemCollection ruleItemCollection = this.ruleItemCollectionMap.get(conditionGroupColl.get(i).getId().toString());
            for (int j = 0; j < ruleItemCollection.size(); ++j) {
                HolidayRuleItemInfo ruleItemInfo = ruleItemCollection.get(j);
                if (!rlStdType.getValue().equals(ruleItemInfo.getTableNbr())) continue;
                holidayRuleItemCollection.add(ruleItemInfo);
            }
            if (holidayRuleItemCollection.size() < 1) {
                if (rlStdType.equals((Object)HolidayRlStdTypeEnum.servingAge)) {
                    LoggerAtsJobInst.collectionExceptionInfo(ctx, MLUtile.getRes(AtsHolidayResEnum.GenerateLimitWithoutParamServeAge, ctx));
                } else if (rlStdType.equals((Object)HolidayRlStdTypeEnum.workingAge)) {
                    LoggerAtsJobInst.collectionExceptionInfo(ctx, MLUtile.getRes(AtsHolidayResEnum.GenerateLimitWithoutParamWorkAge, ctx));
                } else {
                    LoggerAtsJobInst.collectionExceptionInfo(ctx, MLUtile.getRes(AtsHolidayResEnum.GenerateLimitWithoutParamRule, ctx));
                }
                LoggerAtsJobInst.collectionExceptionInfo(ctx, MLUtile.getRes(AtsHolidayResEnum.GenerateLimitWithoutParamWorkAge, ctx));
                return bd;
            }
            bd = convertType != 4 ? this.getStandardLimitByRule(yearCtn1, yearCtn2, stepYear, holidayRuleItemCollection, holidayLimitRuleVO, isConvert, convertUnit, yearCtn1Item, yearCtn2Item) : this.getStandardLimitByRule(yearCtn3, yearCtn3, stepYear, holidayRuleItemCollection, holidayLimitRuleVO, isConvert, convertUnit, yearCtn3Item, yearCtn3Item);
        }
        bd = bd.setScale(this.defaultDecimalPlacesCal, RoundingMode.HALF_UP);
        return bd;
    }

    private BigDecimal getStandardLimitByRule(float yearCtn1, float yearCtn2, int stepYear, HolidayRuleItemCollection ruleItemCollection, GenHolidayLimitRuleVO holidayLimitRuleVO, boolean isConvert, float minConvertUnit, float yearCtn1Item, float yearCtn2Item) {
        float djustVal2;
        float djustVal1;
        float yearCtn1ItemTemp = 0.0f;
        float yearCtn2ItemTemp = 0.0f;
        float convertCtn = holidayLimitRuleVO.getServe_ConvertVal();
        if (yearCtn1 - yearCtn1Item >= 0.0f) {
            djustVal1 = yearCtn1 - yearCtn1Item;
            djustVal2 = yearCtn2 - yearCtn2Item;
            yearCtn1ItemTemp = yearCtn1Item;
            yearCtn2ItemTemp = yearCtn2Item;
            convertCtn -= djustVal2;
        } else {
            djustVal1 = yearCtn1 - yearCtn1Item;
            djustVal2 = yearCtn2 - yearCtn2Item;
            yearCtn1ItemTemp = yearCtn1Item;
            if (yearCtn1 == 0.0f && djustVal1 != 0.0f) {
                this.yearCtn2Number = yearCtn2;
                yearCtn1ItemTemp = yearCtn1 - djustVal1;
                if ((double)yearCtn1 - Math.floor(yearCtn1) + (double)Math.abs(djustVal1) < 1.0) {
                    this.yearCtnFlag = yearCtn1;
                }
            }
            yearCtn2ItemTemp = yearCtn2Item;
            convertCtn -= djustVal2;
        }
        holidayLimitRuleVO.setServe_ConvertVal(convertCtn);
        HolidayRuleItemInfo val1RuleItem = null;
        HolidayRuleItemInfo val2RuleItem = null;
        boolean val1Existed = false;
        boolean val2Existed = false;
        for (int i = 0; i < ruleItemCollection.size(); ++i) {
            HolidayRuleItemInfo ruleItemInfo = ruleItemCollection.get(i);
            float pre = ruleItemInfo.getPre().floatValue();
            float next = ruleItemInfo.getNext().floatValue();
            if (pre < 0.0f) {
                pre = 0.0f;
            }
            if (next < 0.0f) {
                next = 1000.0f;
            }
            String preCmpType = ruleItemInfo.getPreCmpType();
            String nextCmpType = ruleItemInfo.getNextCmpType();
            if (preCmpType == null || "".equals(preCmpType)) {
                preCmpType = ">=";
            } else if (!">".equals(preCmpType) && !">=".equals(preCmpType)) {
                preCmpType = ">=";
            }
            if (nextCmpType == null || "".equals(nextCmpType)) {
                nextCmpType = "<";
            } else if (!"<".equals(nextCmpType) && !"<=".equals(nextCmpType)) {
                nextCmpType = "<";
            }
            if (">=".equals(preCmpType)) {
                if ("<".equals(nextCmpType)) {
                    if (yearCtn1ItemTemp >= pre && yearCtn1ItemTemp < next && !val1Existed) {
                        val1RuleItem = ruleItemInfo;
                        val1Existed = true;
                    }
                    if (yearCtn2ItemTemp >= pre && yearCtn2ItemTemp < next && !val2Existed) {
                        val2RuleItem = ruleItemInfo;
                        val2Existed = true;
                    }
                } else {
                    if (yearCtn1ItemTemp >= pre && yearCtn1ItemTemp <= next && !val1Existed) {
                        val1RuleItem = ruleItemInfo;
                        val1Existed = true;
                    }
                    if (yearCtn2ItemTemp >= pre && yearCtn2ItemTemp <= next && !val2Existed) {
                        val2RuleItem = ruleItemInfo;
                        val2Existed = true;
                    }
                }
            } else if ("<".equals(nextCmpType)) {
                if (yearCtn1ItemTemp > pre && yearCtn1ItemTemp < next && !val1Existed) {
                    val1RuleItem = ruleItemInfo;
                    val1Existed = true;
                }
                if (yearCtn2ItemTemp > pre && yearCtn2ItemTemp < next && !val2Existed) {
                    val2RuleItem = ruleItemInfo;
                    val2Existed = true;
                }
            } else {
                if (yearCtn1ItemTemp > pre && yearCtn1ItemTemp <= next && !val1Existed) {
                    val1RuleItem = ruleItemInfo;
                    val1Existed = true;
                }
                if (yearCtn2ItemTemp > pre && yearCtn2ItemTemp <= next && !val2Existed) {
                    val2RuleItem = ruleItemInfo;
                    val2Existed = true;
                }
            }
            if (val1Existed && val2Existed) break;
        }
        holidayLimitRuleVO.setVal1RuleItem(val1RuleItem);
        holidayLimitRuleVO.setVal2RuleItem(val2RuleItem);
        return this.calStandardLimitByRule(yearCtn1ItemTemp, yearCtn2ItemTemp, stepYear, ruleItemCollection, holidayLimitRuleVO, isConvert, minConvertUnit);
    }

    private BigDecimal getStandardLimitByRule(float yearCtn1, float yearCtn2, int stepYear, HolidayRuleItemCollection ruleItemCollection, GenHolidayLimitRuleVO holidayLimitRuleVO, boolean isConvert, float minConvertUnit) {
        HolidayRuleItemInfo val1RuleItem = null;
        HolidayRuleItemInfo val2RuleItem = null;
        boolean val1Existed = false;
        boolean val2Existed = false;
        for (int i = 0; i < ruleItemCollection.size(); ++i) {
            HolidayRuleItemInfo ruleItemInfo = ruleItemCollection.get(i);
            float pre = ruleItemInfo.getPre().floatValue();
            float next = ruleItemInfo.getNext().floatValue();
            if (pre < 0.0f) {
                pre = 0.0f;
            }
            if (next < 0.0f) {
                next = 1000.0f;
            }
            String preCmpType = ruleItemInfo.getPreCmpType();
            String nextCmpType = ruleItemInfo.getNextCmpType();
            if (preCmpType == null || "".equals(preCmpType)) {
                preCmpType = ">=";
            } else if (!">".equals(preCmpType) && !">=".equals(preCmpType)) {
                preCmpType = ">=";
            }
            if (nextCmpType == null || "".equals(nextCmpType)) {
                nextCmpType = "<";
            } else if (!"<".equals(nextCmpType) && !"<=".equals(nextCmpType)) {
                nextCmpType = "<";
            }
            if (">=".equals(preCmpType)) {
                if ("<".equals(nextCmpType)) {
                    if (yearCtn1 >= pre && yearCtn1 < next && !val1Existed) {
                        val1RuleItem = ruleItemInfo;
                        val1Existed = true;
                    }
                    if (yearCtn2 >= pre && yearCtn2 < next && !val2Existed) {
                        val2RuleItem = ruleItemInfo;
                        val2Existed = true;
                    }
                } else {
                    if (yearCtn1 >= pre && yearCtn1 <= next && !val1Existed) {
                        val1RuleItem = ruleItemInfo;
                        val1Existed = true;
                    }
                    if (yearCtn2 >= pre && yearCtn2 <= next && !val2Existed) {
                        val2RuleItem = ruleItemInfo;
                        val2Existed = true;
                    }
                }
            } else if ("<".equals(nextCmpType)) {
                if (yearCtn1 > pre && yearCtn1 < next && !val1Existed) {
                    val1RuleItem = ruleItemInfo;
                    val1Existed = true;
                }
                if (yearCtn2 > pre && yearCtn2 < next && !val2Existed) {
                    val2RuleItem = ruleItemInfo;
                    val2Existed = true;
                }
            } else {
                if (yearCtn1 > pre && yearCtn1 <= next && !val1Existed) {
                    val1RuleItem = ruleItemInfo;
                    val1Existed = true;
                }
                if (yearCtn2 > pre && yearCtn2 <= next && !val2Existed) {
                    val2RuleItem = ruleItemInfo;
                    val2Existed = true;
                }
            }
            if (val1Existed && val2Existed) break;
        }
        holidayLimitRuleVO.setVal1RuleItem(val1RuleItem);
        holidayLimitRuleVO.setVal2RuleItem(val2RuleItem);
        return this.calStandardLimitByRule(yearCtn1, yearCtn2, stepYear, ruleItemCollection, holidayLimitRuleVO, isConvert, minConvertUnit);
    }

    public BigDecimal calStandardLimitByRule(float yearCtn1, float yearCtn2, int stepYear, HolidayRuleItemCollection ruleItemCollection, GenHolidayLimitRuleVO holidayLimitRuleVO, boolean isConvert, float minConvertUnit) {
        logger.error((Object)MessageFormat.format("--------holidayLimitRuleVO={0},isConvert={1}", holidayLimitRuleVO, isConvert));
        HolidayRuleItemInfo val1RuleItem = holidayLimitRuleVO.getVal1RuleItem();
        HolidayRuleItemInfo val2RuleItem = holidayLimitRuleVO.getVal2RuleItem();
        float val = 0.0f;
        if (val1RuleItem == null && val2RuleItem == null) {
            logger.error((Object)"---------------not match holiday rule cal");
            holidayLimitRuleVO.getGenHolidayLimitModel().setMatchHolidayRuleCal(false);
            return new BigDecimal(0.0);
        }
        val = isConvert ? this.calConvertStandardLimitByRule(yearCtn1, yearCtn2, stepYear, ruleItemCollection, holidayLimitRuleVO, minConvertUnit) : this.calNoneConvertStandardLimitByRule(yearCtn1, yearCtn2, stepYear, ruleItemCollection, holidayLimitRuleVO, minConvertUnit);
        logger.error((Object)MessageFormat.format("-------stardardLimit={0}", Float.valueOf(val)));
        return BigDecimal.valueOf(val);
    }

    private float calConvertStandardLimitByRule(float yearCtn1, float yearCtn2, int stepYear, HolidayRuleItemCollection ruleItemCollection, GenHolidayLimitRuleVO holidayLimitRuleVO, float minConvertUnit) {
        HolidayRuleItemInfo val1RuleItem = holidayLimitRuleVO.getVal1RuleItem();
        HolidayRuleItemInfo val2RuleItem = holidayLimitRuleVO.getVal2RuleItem();
        String val1RuleItemId = val1RuleItem == null ? "" : val1RuleItem.getId().toString();
        String val2RuleItemId = val2RuleItem == null ? "" : val2RuleItem.getId().toString();
        float tempServerYear = holidayLimitRuleVO.getServe_ConvertVal();
        float val = 0.0f;
        if (val1RuleItemId.equals(val2RuleItemId)) {
            if (val1RuleItem != null && val1RuleItem.getVal() != null) {
                float valf = val1RuleItem.getVal().floatValue();
                valf = (yearCtn2 - tempServerYear + minConvertUnit) / (float)stepYear * valf;
                return valf;
            }
        } else {
            GenPiecewiseBO genPiecewiseBO = this.getGenPiecewiseBO(yearCtn1, yearCtn2, holidayLimitRuleVO);
            ruleItemCollection.sort("val");
            for (int i = 0; i < ruleItemCollection.size(); ++i) {
                HolidayRuleItemInfo ruleItemInfo = ruleItemCollection.get(i);
                float pre = ruleItemInfo.getPre().floatValue();
                float next = ruleItemInfo.getNext().floatValue();
                float valf = ruleItemInfo.getVal().floatValue();
                String nextCmpType = ruleItemInfo.getNextCmpType();
                String preCmpType = ruleItemInfo.getPreCmpType();
                BigDecimal piecewise = null;
                BigDecimal segVal = null;
                boolean isEquals = false;
                String id = null;
                if (val1RuleItemId.equals(ruleItemInfo.getId().toString())) {
                    if (next >= tempServerYear && tempServerYear >= pre) {
                        if (nextCmpType.equals("<")) {
                            piecewise = new BigDecimal((next - tempServerYear) / (float)stepYear * valf);
                            segVal = BigDecimal.valueOf(valf);
                            val += (next - tempServerYear) / (float)stepYear * valf;
                            id = ruleItemInfo.getId().toString();
                        } else {
                            piecewise = new BigDecimal((next - tempServerYear + minConvertUnit) / (float)stepYear * valf);
                            segVal = BigDecimal.valueOf(valf);
                            isEquals = true;
                            val += (next - tempServerYear + minConvertUnit) / (float)stepYear * valf;
                            id = ruleItemInfo.getId().toString();
                        }
                    }
                } else if (yearCtn1 < pre && next < yearCtn2) {
                    if (next >= tempServerYear && tempServerYear >= pre) {
                        if (nextCmpType.equals("<")) {
                            piecewise = new BigDecimal((next - tempServerYear) / (float)stepYear * valf);
                            segVal = BigDecimal.valueOf(valf);
                            val += (next - tempServerYear) / (float)stepYear * valf;
                            id = ruleItemInfo.getId().toString();
                        } else {
                            piecewise = new BigDecimal((next - tempServerYear + minConvertUnit) / (float)stepYear * valf);
                            segVal = BigDecimal.valueOf(valf);
                            isEquals = true;
                            val += (next - tempServerYear + minConvertUnit) / (float)stepYear * valf;
                            id = ruleItemInfo.getId().toString();
                        }
                    } else {
                        piecewise = new BigDecimal((next - pre) / (float)stepYear * valf);
                        segVal = BigDecimal.valueOf(valf);
                        val += (next - pre) / (float)stepYear * valf;
                        id = ruleItemInfo.getId().toString();
                    }
                } else if (val2RuleItemId.equals(ruleItemInfo.getId().toString())) {
                    if (next >= tempServerYear && tempServerYear >= pre) {
                        if (preCmpType.equals(">=")) {
                            piecewise = new BigDecimal((yearCtn2 - tempServerYear + minConvertUnit) / (float)stepYear * valf);
                            segVal = BigDecimal.valueOf(valf);
                            isEquals = true;
                            val = (yearCtn2 - tempServerYear + minConvertUnit) / (float)stepYear * valf;
                            id = ruleItemInfo.getId().toString();
                        } else if (tempServerYear > pre) {
                            piecewise = new BigDecimal((yearCtn2 - tempServerYear + minConvertUnit) / (float)stepYear * valf);
                            segVal = BigDecimal.valueOf(valf);
                            isEquals = true;
                            val = (yearCtn2 - tempServerYear + minConvertUnit) / (float)stepYear * valf;
                            id = ruleItemInfo.getId().toString();
                        } else {
                            piecewise = new BigDecimal((yearCtn2 - tempServerYear) / (float)stepYear * valf);
                            segVal = BigDecimal.valueOf(valf);
                            val = (yearCtn2 - tempServerYear) / (float)stepYear * valf;
                            id = ruleItemInfo.getId().toString();
                        }
                    } else if (preCmpType.equals(">=")) {
                        piecewise = new BigDecimal((yearCtn2 - pre + minConvertUnit) / (float)stepYear * valf);
                        segVal = BigDecimal.valueOf(valf);
                        isEquals = true;
                        val += (yearCtn2 - pre + minConvertUnit) / (float)stepYear * valf;
                        id = ruleItemInfo.getId().toString();
                    } else {
                        piecewise = new BigDecimal((yearCtn2 - pre) / (float)stepYear * valf);
                        segVal = BigDecimal.valueOf(valf);
                        val += (yearCtn2 - pre) / (float)stepYear * valf;
                        id = ruleItemInfo.getId().toString();
                    }
                }
                if (genPiecewiseBO == null || piecewise == null) continue;
                GenPiecewiseBO.PiecewiseBO piecewiseBO = new GenPiecewiseBO.PiecewiseBO();
                piecewiseBO.setId(id);
                piecewiseBO.setNext(ruleItemInfo.getNext());
                piecewiseBO.setEqualNext(isEquals);
                piecewiseBO.setPiecewise(piecewise);
                piecewiseBO.setSegVal(segVal);
                genPiecewiseBO.getPiecewiseBOList().add(piecewiseBO);
            }
            if (genPiecewiseBO != null) {
                holidayLimitRuleVO.getGenHolidayLimitModel().setGenPiecewiseBO(genPiecewiseBO);
            }
        }
        return val;
    }

    private GenPiecewiseBO getGenPiecewiseBO(float yearCtn1, float yearCtn2, GenHolidayLimitRuleVO holidayLimitRuleVO) {
        GenPiecewiseBO genPiecewiseBO = null;
        ArrayList<GenPiecewiseBO.PiecewiseBO> piecewiseBOList = null;
        if (holidayLimitRuleVO != null && holidayLimitRuleVO.getGenHolidayLimitModel() != null && holidayLimitRuleVO.getGenHolidayLimitModel().getHolidayPolicyInfo() != null && holidayLimitRuleVO.getGenHolidayLimitModel().getHolidayPolicyInfo().isIsPiecewiseCal()) {
            genPiecewiseBO = new GenPiecewiseBO();
            genPiecewiseBO.setCycleBeginDate(holidayLimitRuleVO.getGenHolidayLimitModel().getCycleBeginDate());
            genPiecewiseBO.setYearCnt1(yearCtn1);
            genPiecewiseBO.setCycleEndDate(holidayLimitRuleVO.getGenHolidayLimitModel().getCycleEndDate());
            genPiecewiseBO.setYearCnt2(yearCtn2);
            genPiecewiseBO.setLeftDate(holidayLimitRuleVO.getGenHolidayLimitModel().getLeftEndDate());
            genPiecewiseBO.setConvertType(holidayLimitRuleVO.getConvertType());
            piecewiseBOList = new ArrayList<GenPiecewiseBO.PiecewiseBO>();
            genPiecewiseBO.setPiecewiseBOList(piecewiseBOList);
        }
        return genPiecewiseBO;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private float calNoneConvertStandardLimitByRule(float yearCtn1, float yearCtn2, int stepYear, HolidayRuleItemCollection ruleItemCollection, GenHolidayLimitRuleVO holidayLimitRuleVO, float minConvertUnit) {
        HolidayRuleItemInfo val1RuleItem = holidayLimitRuleVO.getVal1RuleItem();
        HolidayRuleItemInfo val2RuleItem = holidayLimitRuleVO.getVal2RuleItem();
        String val1RuleItemId = val1RuleItem == null ? "" : val1RuleItem.getId().toString();
        String val2RuleItemId = val2RuleItem == null ? "" : val2RuleItem.getId().toString();
        float val = 0.0f;
        float directLen = yearCtn2 - yearCtn1 + minConvertUnit;
        GenHolidayLimitModel genHolidayLimitModel = holidayLimitRuleVO.getGenHolidayLimitModel();
        HolidayPolicyInfo holidayPolicyInfo = holidayLimitRuleVO.getGenHolidayLimitModel().getHolidayPolicyInfo();
        if (holidayPolicyInfo != null && holidayPolicyInfo.getPeriodLengthUnit() == HolidayPeriodUniteEnum.month) {
            Calendar calendar = Calendar.getInstance();
            calendar.setTime(genHolidayLimitModel.getCycleDate());
            float maxMonthDayCnt = calendar.getActualMaximum(5);
            directLen = (float)Math.round(directLen * 365.0f) / maxMonthDayCnt;
        }
        if (val1RuleItemId.equals(val2RuleItemId)) {
            if (val1RuleItem == null) return val;
            if (val1RuleItem.getVal() == null) return val;
            float valf = val1RuleItem.getVal().floatValue();
            if (holidayLimitRuleVO.isLeftRecalculate()) {
                if (new BigDecimal(directLen).compareTo(BigDecimal.ZERO) != 0) return directLen / (float)stepYear * valf;
                logger.error((Object)"not discount,leave recalcute.directLen is zero.");
                if (holidayLimitRuleVO.getGenHolidayLimitModel() != null && holidayLimitRuleVO.getGenHolidayLimitModel().getLeftEndDate() != null && holidayLimitRuleVO.getGenHolidayLimitModel().getCycleEndDate() != null) {
                    Date leftDate = holidayLimitRuleVO.getGenHolidayLimitModel().getLeftEndDate();
                    Date cycleBeginDate = holidayLimitRuleVO.getGenHolidayLimitModel().getCycleBeginDate();
                    return (float)((leftDate.getTime() - cycleBeginDate.getTime()) / 86400000L) * 1.0f / 365.0f * valf;
                }
            } else if (genHolidayLimitModel.isChangeHrOrgUnitOld() && holidayLimitRuleVO.getGenHolidayLimitModel() != null && holidayLimitRuleVO.getGenHolidayLimitModel().getCycleBeginDate() != null && holidayLimitRuleVO.getGenHolidayLimitModel().getCycleEndDate() != null) {
                Date endDate = holidayLimitRuleVO.getGenHolidayLimitModel().getCycleEndDate();
                Date cycleBeginDate = holidayLimitRuleVO.getGenHolidayLimitModel().getCycleBeginDate();
                return (float)((endDate.getTime() - cycleBeginDate.getTime()) / 86400000L) * 1.0f / 365.0f * valf;
            }
            if (this.yearCtnFlag == 0.0f) {
                yearCtn1 = 0.0f;
                yearCtn2 = (float)this.yearCtn2Number;
            }
            if (yearCtn1 == 0.0f) {
                valf = yearCtn2 / (float)stepYear * valf;
            }
            if (!holidayLimitRuleVO.isCrossBUConvert()) return valf;
            return holidayLimitRuleVO.getCrossBU_ConvertVal() * valf;
        }
        GenPiecewiseBO genPiecewiseBO = this.getGenPiecewiseBO(yearCtn1, yearCtn2, holidayLimitRuleVO);
        ruleItemCollection.sort("val");
        for (int i = 0; i < ruleItemCollection.size(); ++i) {
            HolidayRuleItemInfo ruleItemInfo = ruleItemCollection.get(i);
            float pre = ruleItemInfo.getPre().floatValue();
            float next = ruleItemInfo.getNext().floatValue();
            float valf = ruleItemInfo.getVal().floatValue();
            String nextCmpType = ruleItemInfo.getNextCmpType();
            String preCmpType = ruleItemInfo.getPreCmpType();
            BigDecimal piecewise = null;
            BigDecimal segVal = null;
            boolean isEquals = false;
            String id = null;
            if (val1RuleItemId.equals(ruleItemInfo.getId().toString())) {
                if (yearCtn1 == 0.0f) {
                    piecewise = new BigDecimal(valf);
                    segVal = BigDecimal.valueOf(valf);
                    val += valf;
                    id = ruleItemInfo.getId().toString();
                } else if (nextCmpType.equals("<")) {
                    piecewise = new BigDecimal((next - yearCtn1) / (float)stepYear * valf);
                    segVal = BigDecimal.valueOf(valf);
                    val += (next - yearCtn1) / (float)stepYear * valf;
                    id = ruleItemInfo.getId().toString();
                } else {
                    piecewise = new BigDecimal((next - yearCtn1 + minConvertUnit) / (float)stepYear * valf);
                    segVal = BigDecimal.valueOf(valf);
                    isEquals = true;
                    val += (next - yearCtn1 + minConvertUnit) / (float)stepYear * valf;
                    id = ruleItemInfo.getId().toString();
                }
            } else if (yearCtn1 < pre && next < yearCtn2) {
                piecewise = new BigDecimal((next - pre) / (float)stepYear * valf);
                segVal = BigDecimal.valueOf(valf);
                val += (next - pre) / (float)stepYear * valf;
                id = ruleItemInfo.getId().toString();
            } else if (val2RuleItemId.equals(ruleItemInfo.getId().toString())) {
                if (preCmpType.equals(">=")) {
                    piecewise = new BigDecimal((yearCtn2 - pre + minConvertUnit) / (float)stepYear * valf);
                    segVal = BigDecimal.valueOf(valf);
                    isEquals = true;
                    val += (yearCtn2 - pre + minConvertUnit) / (float)stepYear * valf;
                    id = ruleItemInfo.getId().toString();
                } else {
                    piecewise = new BigDecimal((yearCtn2 - pre) / (float)stepYear * valf);
                    segVal = BigDecimal.valueOf(valf);
                    val += (yearCtn2 - pre) / (float)stepYear * valf;
                    id = ruleItemInfo.getId().toString();
                }
            }
            if (genPiecewiseBO == null || piecewise == null) continue;
            GenPiecewiseBO.PiecewiseBO piecewiseBO = new GenPiecewiseBO.PiecewiseBO();
            piecewiseBO.setId(id);
            piecewiseBO.setNext(ruleItemInfo.getNext());
            piecewiseBO.setEqualNext(isEquals);
            piecewiseBO.setPiecewise(piecewise);
            piecewiseBO.setSegVal(segVal);
            genPiecewiseBO.getPiecewiseBOList().add(piecewiseBO);
        }
        if (holidayLimitRuleVO.isCrossBUConvert()) {
            val = holidayLimitRuleVO.getCrossBU_ConvertVal() * val;
        }
        if (genPiecewiseBO == null) return val;
        holidayLimitRuleVO.getGenHolidayLimitModel().setGenPiecewiseBO(genPiecewiseBO);
        return val;
    }

    private HolidayPolicyInfo getMatchPolicy(HolidayTypeInfo holidayTypeInfo, HolidayPolicyCollection holidayPolicyCollection, HolidayPolicyInfo holidayPolicyInfo) {
        if (holidayTypeInfo == null) {
            return null;
        }
        if (holidayPolicyCollection != null && holidayPolicyCollection.size() > 0) {
            for (int i = 0; i < holidayPolicyCollection.size(); ++i) {
                HolidayPolicyInfo hpi = holidayPolicyCollection.get(i);
                if (!hpi.getHolidayType().getNumber().equals(holidayTypeInfo.getNumber())) continue;
                return hpi;
            }
        }
        if (holidayPolicyInfo != null && holidayTypeInfo.getNumber().equals(holidayPolicyInfo.getHolidayType().getNumber())) {
            return holidayPolicyInfo;
        }
        return null;
    }

    private Map getBeginEndDateStrDealByMonth(int monthCycleDate, int length, Date cycleDate, String cycleDateYearStr) {
        String beginDateStr = "";
        String endDateStr = "";
        HashMap<String, String> beginEndDateStrMap = new HashMap<String, String>();
        if (length == 1) {
            beginDateStr = HRTimeWebUtils.dateShortToString(HRTimeWebUtils.getMonthFirstDay(cycleDate));
            endDateStr = HRTimeWebUtils.dateShortToString(HRTimeWebUtils.getMonthLastDay(cycleDate));
        } else if (length == 2) {
            if (monthCycleDate % 2 == 0) {
                beginDateStr = HRTimeWebUtils.dateShortToString(HRTimeWebUtils.getMonthFirstDay(HRTimeWebUtils.addMonth(cycleDate, -1)));
                endDateStr = HRTimeWebUtils.dateShortToString(HRTimeWebUtils.getMonthLastDay(HRTimeWebUtils.addMonth(cycleDate, 0)));
            } else {
                beginDateStr = HRTimeWebUtils.dateShortToString(HRTimeWebUtils.getMonthFirstDay(HRTimeWebUtils.addMonth(cycleDate, 0)));
                endDateStr = HRTimeWebUtils.dateShortToString(HRTimeWebUtils.getMonthLastDay(HRTimeWebUtils.addMonth(cycleDate, 1)));
            }
        } else if (length == 3) {
            if (monthCycleDate % 3 == 0) {
                beginDateStr = HRTimeWebUtils.dateShortToString(HRTimeWebUtils.getMonthFirstDay(HRTimeWebUtils.addMonth(cycleDate, -2)));
                endDateStr = HRTimeWebUtils.dateShortToString(HRTimeWebUtils.getMonthLastDay(HRTimeWebUtils.addMonth(cycleDate, 0)));
            } else if (monthCycleDate % 3 == 1) {
                beginDateStr = HRTimeWebUtils.dateShortToString(HRTimeWebUtils.getMonthFirstDay(HRTimeWebUtils.addMonth(cycleDate, 0)));
                endDateStr = HRTimeWebUtils.dateShortToString(HRTimeWebUtils.getMonthLastDay(HRTimeWebUtils.addMonth(cycleDate, 2)));
            } else if (monthCycleDate % 3 == 2) {
                beginDateStr = HRTimeWebUtils.dateShortToString(HRTimeWebUtils.getMonthFirstDay(HRTimeWebUtils.addMonth(cycleDate, -1)));
                endDateStr = HRTimeWebUtils.dateShortToString(HRTimeWebUtils.getMonthLastDay(HRTimeWebUtils.addMonth(cycleDate, 1)));
            }
        } else if (length == 4) {
            if (monthCycleDate % 4 == 0) {
                beginDateStr = HRTimeWebUtils.dateShortToString(HRTimeWebUtils.getMonthFirstDay(HRTimeWebUtils.addMonth(cycleDate, -3)));
                endDateStr = HRTimeWebUtils.dateShortToString(HRTimeWebUtils.getMonthLastDay(HRTimeWebUtils.addMonth(cycleDate, 0)));
            } else if (monthCycleDate % 4 == 1) {
                beginDateStr = HRTimeWebUtils.dateShortToString(HRTimeWebUtils.getMonthFirstDay(HRTimeWebUtils.addMonth(cycleDate, 0)));
                endDateStr = HRTimeWebUtils.dateShortToString(HRTimeWebUtils.getMonthLastDay(HRTimeWebUtils.addMonth(cycleDate, 3)));
            } else if (monthCycleDate % 4 == 2) {
                beginDateStr = HRTimeWebUtils.dateShortToString(HRTimeWebUtils.getMonthFirstDay(HRTimeWebUtils.addMonth(cycleDate, -1)));
                endDateStr = HRTimeWebUtils.dateShortToString(HRTimeWebUtils.getMonthLastDay(HRTimeWebUtils.addMonth(cycleDate, 2)));
            } else if (monthCycleDate % 4 == 3) {
                beginDateStr = HRTimeWebUtils.dateShortToString(HRTimeWebUtils.getMonthFirstDay(HRTimeWebUtils.addMonth(cycleDate, -2)));
                endDateStr = HRTimeWebUtils.dateShortToString(HRTimeWebUtils.getMonthLastDay(HRTimeWebUtils.addMonth(cycleDate, 1)));
            }
        } else if (length == 6) {
            if (monthCycleDate % 6 == 0) {
                beginDateStr = HRTimeWebUtils.dateShortToString(HRTimeWebUtils.getMonthFirstDay(HRTimeWebUtils.addMonth(cycleDate, -5)));
                endDateStr = HRTimeWebUtils.dateShortToString(HRTimeWebUtils.getMonthLastDay(HRTimeWebUtils.addMonth(cycleDate, 0)));
            } else if (monthCycleDate % 6 == 1) {
                beginDateStr = HRTimeWebUtils.dateShortToString(HRTimeWebUtils.getMonthFirstDay(HRTimeWebUtils.addMonth(cycleDate, 0)));
                endDateStr = HRTimeWebUtils.dateShortToString(HRTimeWebUtils.getMonthLastDay(HRTimeWebUtils.addMonth(cycleDate, 5)));
            } else if (monthCycleDate % 6 == 2) {
                beginDateStr = HRTimeWebUtils.dateShortToString(HRTimeWebUtils.getMonthFirstDay(HRTimeWebUtils.addMonth(cycleDate, -1)));
                endDateStr = HRTimeWebUtils.dateShortToString(HRTimeWebUtils.getMonthLastDay(HRTimeWebUtils.addMonth(cycleDate, 4)));
            } else if (monthCycleDate % 6 == 3) {
                beginDateStr = HRTimeWebUtils.dateShortToString(HRTimeWebUtils.getMonthFirstDay(HRTimeWebUtils.addMonth(cycleDate, -2)));
                endDateStr = HRTimeWebUtils.dateShortToString(HRTimeWebUtils.getMonthLastDay(HRTimeWebUtils.addMonth(cycleDate, 3)));
            } else if (monthCycleDate % 6 == 4) {
                beginDateStr = HRTimeWebUtils.dateShortToString(HRTimeWebUtils.getMonthFirstDay(HRTimeWebUtils.addMonth(cycleDate, -3)));
                endDateStr = HRTimeWebUtils.dateShortToString(HRTimeWebUtils.getMonthLastDay(HRTimeWebUtils.addMonth(cycleDate, 2)));
            } else if (monthCycleDate % 6 == 5) {
                beginDateStr = HRTimeWebUtils.dateShortToString(HRTimeWebUtils.getMonthFirstDay(HRTimeWebUtils.addMonth(cycleDate, -4)));
                endDateStr = HRTimeWebUtils.dateShortToString(HRTimeWebUtils.getMonthLastDay(HRTimeWebUtils.addMonth(cycleDate, 1)));
            }
        } else {
            beginDateStr = cycleDateYearStr + "-01-01";
            endDateStr = new Integer(Integer.valueOf(cycleDateYearStr) + monthCycleDate / 12 - 1).toString() + "-12-31";
        }
        beginEndDateStrMap.put("beginDateStr", beginDateStr);
        beginEndDateStrMap.put("endDateStr", endDateStr);
        return beginEndDateStrMap;
    }

    private Boolean conditionDeal(Context ctx, HolidayRuleConditionCollection conditionColl, String personId) {
        Object value = null;
        FilterInfo filterInfo = new FilterInfo();
        if (conditionColl == null || conditionColl.size() == 0) {
            return true;
        }
        filterInfo.getFilterItems().add(new FilterItemInfo("person.id", (Object)personId, CompareType.EQUALS));
        for (int i = 0; i < conditionColl.size(); ++i) {
            CompareType tmpCompareType;
            CompareType compareType;
            String config = conditionColl.get(i).getConfig();
            if (config == null || config.equals("")) {
                System.out.println("conditionGroupColl config is null:" + personId);
                return false;
            }
            String prop_field = JSONObject.fromObject((Object)config).get("name").toString();
            String prop_op = JSONObject.fromObject((Object)config).get("compareType").toString();
            String prop_value = JSONObject.fromObject((Object)config).get("value").toString();
            String field_type = JSONObject.fromObject((Object)config).get("type").toString();
            try {
                value = GenHolidayLimitUtil.convertData(prop_value, field_type);
            }
            catch (Exception e) {
                e.printStackTrace();
                continue;
            }
            if (prop_field.equals("jobGrade.name")) {
                compareType = CompareType.getEnum((String)prop_op);
                if (value != null && value instanceof Set) {
                    if (compareType.equals((Object)CompareType.LIKE)) {
                        compareType = CompareType.INCLUDE;
                    } else if (compareType.equals((Object)CompareType.NOTLIKE)) {
                        compareType = CompareType.NOTINCLUDE;
                    }
                    value = "(" + AtsUtil.convertSetToString((Set)value) + ")";
                }
                if ((compareType.equals((Object)CompareType.LIKE) || compareType.equals((Object)CompareType.NOTLIKE)) && (field_type == null || field_type.equals("String"))) {
                    value = "'%" + value + "%'";
                }
                JobGradeCollection jobGradeColl = new JobGradeCollection();
                try {
                    jobGradeColl = JobGradeFactory.getLocalInstance((Context)ctx).getJobGradeCollection(" select number where name " + compareType + value);
                }
                catch (BOSException e) {
                    e.printStackTrace();
                }
                prop_field = "jobGrade.number";
                field_type = "String";
                prop_op = CompareType.INCLUDE.toString();
                prop_value = "";
                int len = jobGradeColl.size();
                for (int j = 0; j < len; ++j) {
                    prop_value = prop_value + jobGradeColl.get(j).getNumber();
                    if (j == len - 1) continue;
                    prop_value = prop_value + ",";
                }
            }
            try {
                value = GenHolidayLimitUtil.convertData(prop_value, field_type);
            }
            catch (Exception e) {
                e.printStackTrace();
                continue;
            }
            compareType = CompareType.getEnum((String)prop_op);
            if (value != null && value instanceof Set) {
                if (compareType.equals((Object)CompareType.LIKE)) {
                    compareType = CompareType.INCLUDE;
                } else if (compareType.equals((Object)CompareType.NOTLIKE)) {
                    compareType = CompareType.NOTINCLUDE;
                }
            }
            if ((compareType.equals((Object)CompareType.LIKE) || compareType.equals((Object)CompareType.NOTLIKE)) && (field_type == null || field_type.equals("String"))) {
                value = "%" + value + "%";
            }
            if ("enrollSource.name".equals(prop_field)) {
                tmpCompareType = CompareType.getEnum((String)prop_op);
                if (tmpCompareType.equals((Object)CompareType.NOTLIKE)) {
                    try {
                        FilterInfo isNullFilterInfo = new FilterInfo();
                        isNullFilterInfo.getFilterItems().add(new FilterItemInfo("enrollSource.name", null, CompareType.EQUALS));
                        FilterInfo likeFilter = new FilterInfo();
                        likeFilter.getFilterItems().add(new FilterItemInfo(prop_field, value, compareType));
                        likeFilter.mergeFilter(isNullFilterInfo, "OR");
                        filterInfo.mergeFilter(likeFilter, "AND");
                    }
                    catch (BOSException e) {
                        e.printStackTrace();
                    }
                    continue;
                }
                filterInfo.getFilterItems().add(new FilterItemInfo(prop_field, value, compareType));
                continue;
            }
            if ("wed.name".equals(prop_field)) {
                tmpCompareType = CompareType.getEnum((String)prop_op);
                if (tmpCompareType.equals((Object)CompareType.NOTLIKE)) {
                    try {
                        FilterInfo isNullFilterInfo = new FilterInfo();
                        isNullFilterInfo.getFilterItems().add(new FilterItemInfo("wed.name", null, CompareType.EQUALS));
                        FilterInfo likeFilter = new FilterInfo();
                        likeFilter.getFilterItems().add(new FilterItemInfo(prop_field, value, compareType));
                        likeFilter.mergeFilter(isNullFilterInfo, "OR");
                        filterInfo.mergeFilter(likeFilter, "AND");
                    }
                    catch (BOSException e) {
                        e.printStackTrace();
                    }
                    continue;
                }
                filterInfo.getFilterItems().add(new FilterItemInfo(prop_field, value, compareType));
                continue;
            }
            if ("contract.state".equals(prop_field)) {
                tmpCompareType = CompareType.getEnum((String)prop_op);
                if (tmpCompareType.equals((Object)CompareType.NOTEQUALS)) {
                    try {
                        FilterInfo isNullFilterInfo = new FilterInfo();
                        isNullFilterInfo.getFilterItems().add(new FilterItemInfo("contract.state", null, CompareType.EQUALS));
                        FilterInfo notEqualFilter = new FilterInfo();
                        notEqualFilter.getFilterItems().add(new FilterItemInfo(prop_field, value, compareType));
                        notEqualFilter.mergeFilter(isNullFilterInfo, "OR");
                        filterInfo.mergeFilter(notEqualFilter, "AND");
                    }
                    catch (BOSException e) {
                        e.printStackTrace();
                    }
                    continue;
                }
                filterInfo.getFilterItems().add(new FilterItemInfo(prop_field, value, compareType));
                continue;
            }
            filterInfo.getFilterItems().add(new FilterItemInfo(prop_field, value, compareType));
        }
        String selector = "person.id";
        SqlParam param = new SqlParam();
        Date effectDate = DateTimeUtils.truncateDate((Date)new Date());
        param.setFilterDate(effectDate);
        String[] columnModel = selector.split(",");
        String columnName2 = null;
        HashMap<String, String> map = new HashMap<String, String>();
        for (String columnName2 : columnModel) {
            map.put(columnName2, columnName2);
        }
        param.setSelectMapping(map);
        param.setFilterInfo(filterInfo);
        param.setScheme("001");
        param.setNeedDistinct(false);
        param.setHistoryMode(false);
        param.setRows(999999999);
        param.setPage(1);
        param.setNewSearch(true);
        param.setSupportQueryUuid(true);
        GridDataEntity gridData = null;
        try {
            String uipk = "com.kingdee.eas.basedata.person.app.Person.list";
            gridData = EmpQueryImpl.execQuery(ctx, uipk, param);
            if (gridData.getTotal() > 0L) {
                return true;
            }
        }
        catch (Exception e) {
            System.out.println("EmpQueryImpl.execQuery exception:" + personId);
            e.printStackTrace();
        }
        return false;
    }

    public float getValueAfterConvert(Context ctx, Date startDate, Date endDate, int convertType) {
        float value = 0.0f;
        Date calEndDate = endDate;
        try {
            int leapYearCount = this.isLeapYear(startDate, calEndDate);
            if ((double)convertType == 3.0) {
                double startYear = startDate.getYear();
                double endYear = calEndDate.getYear();
                value = (float)(endYear - startYear + 1.0);
            } else if ((double)convertType == 2.0) {
                double startYear = startDate.getYear();
                double endYear = calEndDate.getYear();
                double startMonth = startDate.getMonth();
                double endMonth = calEndDate.getMonth();
                BigDecimal bigDecimal = BigDecimal.valueOf(((endYear - startYear) * 12.0 + (endMonth - startMonth) + 1.0) / 12.0);
                value = bigDecimal.setScale(this.defaultDecimalPlacesCal, 4).floatValue();
            } else if ((double)convertType == 1.0) {
                long daysTimes = calEndDate.getTime() - startDate.getTime();
                value = new BigDecimal(daysTimes -= (long)(leapYearCount * 24 * 60 * 60 * 1000)).divide(new BigDecimal(31536000000L), this.defaultDecimalPlacesCal, 4).floatValue();
            } else if ((double)convertType == 4.0) {
                long daysTimes = calEndDate.getTime() - startDate.getTime();
                value = new BigDecimal(daysTimes -= (long)(leapYearCount * 24 * 60 * 60 * 1000)).divide(new BigDecimal(31536000000L), this.defaultDecimalPlacesCal, 4).floatValue();
            }
        }
        catch (Exception e) {
            return 0.0f;
        }
        return value < 0.0f ? 0.0f : value;
    }

    private Integer isLeapYear(Date startDate, Date endDate) {
        int endMonth;
        int statrDateYear = startDate.getYear() + 1900;
        int endDateYear = endDate.getYear() + 1900;
        int count = 0;
        if (statrDateYear == endDateYear) {
            if (statrDateYear % 4 == 0 && statrDateYear % 100 != 0 || statrDateYear % 400 == 0) {
                Calendar calendar = Calendar.getInstance();
                calendar.set(1, statrDateYear);
                calendar.set(2, 1);
                calendar.set(5, 27);
                calendar.set(10, 23);
                calendar.set(12, 59);
                calendar.set(13, 59);
                if (calendar.getTime().after(startDate) && calendar.getTime().before(endDate)) {
                    return 1;
                }
            }
            return 0;
        }
        for (int i = statrDateYear + 1; i < endDateYear; ++i) {
            if ((i % 4 != 0 || i % 100 == 0) && i % 400 != 0) continue;
            ++count;
        }
        if (statrDateYear % 4 == 0 && statrDateYear % 100 != 0 || statrDateYear % 400 == 0) {
            int month = startDate.getMonth() + 1;
            int day = startDate.getDate();
            if (month < 2 || month == 2 && day <= 29) {
                ++count;
            }
        }
        if ((endDateYear % 4 == 0 && endDateYear % 100 != 0 || endDateYear % 400 == 0) && (endMonth = startDate.getMonth() + 1) > 2) {
            ++count;
        }
        return count;
    }

    private float getMinConvertUnit(int convertType) {
        float minConvertUnit = 0.0f;
        switch (convertType) {
            case 1: {
                minConvertUnit = 0.002739726f;
                break;
            }
            case 2: {
                minConvertUnit = 0.083333336f;
                break;
            }
            case 3: {
                minConvertUnit = 1.0f;
            }
        }
        return minConvertUnit;
    }

    public void setHolidayLimitBeginDateAndEndDate(Context ctx, GenHolidayLimitModel genHolidayLimitModel, PersonPositionInfo ppi, Date cycleDate, String periodAccordType, HolidayPolicyInfo holidayPolicyInfo, HolidayRuleInfo holidayRuleInfo, EmpLaborRelationInfo laborInfo) {
        int stepYear = 1;
        String cycleDateStr = HRTimeWebUtils.dateShortToString(cycleDate);
        String cycleDateYearStr = cycleDateStr.substring(0, 4);
        Date beginDate = null;
        Date endDate = null;
        if (holidayPolicyInfo.isEnablePeriod()) {
            String cycleCustomValue;
            String beginDateStr = "";
            String endDateStr = "";
            if ("0".equals(periodAccordType)) {
                beginDateStr = cycleDateYearStr + "-01-01";
                endDateStr = new Integer(Integer.valueOf(cycleDateYearStr) + stepYear - 1).toString() + "-12-31";
            } else if ("1".equals(periodAccordType)) {
                Date jDate = null;
                if (laborInfo != null && laborInfo.getEnterDate() != null) {
                    jDate = laborInfo.getEnterDate();
                } else if (ppi.getJoinGroupDate() != null) {
                    jDate = ppi.getJoinGroupDate();
                } else if (ppi.getJoinDate() != null) {
                    jDate = ppi.getJoinDate();
                }
                if (jDate != null) {
                    Date jDate_1 = new Date(jDate.getTime() - 86400000L);
                    String tmpDtStr = cycleDateYearStr + HRTimeWebUtils.dateShortToString(jDate).substring(4);
                    if (HRTimeWebUtils.stringToShortDate(tmpDtStr).getTime() <= cycleDate.getTime()) {
                        beginDateStr = tmpDtStr;
                        if (HRTimeWebUtils.dateShortToString(jDate).substring(4).equals("-01-01")) {
                            endDateStr = new Integer(Integer.valueOf(cycleDateYearStr) + stepYear - 1).toString() + HRTimeWebUtils.dateShortToString(jDate_1).substring(4);
                        } else {
                            endDateStr = new Integer(Integer.valueOf(cycleDateYearStr) + stepYear).toString() + HRTimeWebUtils.dateShortToString(jDate_1).substring(4);
                            if (Integer.valueOf(endDateStr.substring(0, 4)) % 4 == 0 && HRTimeWebUtils.dateShortToString(jDate_1).substring(8).equals("28")) {
                                endDateStr = endDateStr.substring(0, 4) + "-02-29";
                            }
                        }
                    } else {
                        endDateStr = cycleDateYearStr + HRTimeWebUtils.dateShortToString(jDate_1).substring(4);
                        if (Integer.valueOf(cycleDateYearStr) % 4 == 0 && HRTimeWebUtils.dateShortToString(jDate_1).substring(8).equals("28")) {
                            endDateStr = cycleDateYearStr + "-02-29";
                        }
                        beginDateStr = new Integer(Integer.valueOf(cycleDateYearStr) - stepYear).toString() + HRTimeWebUtils.dateShortToString(jDate).substring(4);
                    }
                } else {
                    beginDateStr = cycleDateYearStr + "-01-01";
                    endDateStr = new Integer(Integer.valueOf(cycleDateYearStr) + stepYear - 1).toString() + "-12-31";
                }
            } else if ("2".equals(periodAccordType) && !StringUtils.isEmpty((String)(cycleCustomValue = holidayRuleInfo.getCycleTypeCustomValue())) && cycleCustomValue.length() == 10) {
                int length = holidayPolicyInfo.getPeriodLength().intValue();
                if (holidayPolicyInfo.getPeriodLengthUnit() == HolidayPeriodUniteEnum.year) {
                    Map beginEndDatestr = this.getBeginEndDateStrYearByCustom(length, cycleDate, cycleCustomValue);
                    beginDateStr = (String)beginEndDatestr.get("beginDateStr");
                    endDateStr = (String)beginEndDatestr.get("endDateStr");
                }
            }
            beginDate = HRTimeWebUtils.stringToShortDate(beginDateStr);
            endDate = HRTimeWebUtils.stringToShortDate(endDateStr);
        } else {
            beginDate = ppi.getJoinGroupDate();
            endDate = new Date(1099, 11, 31);
        }
        genHolidayLimitModel.setCycleBeginDate(beginDate);
        genHolidayLimitModel.setCycleEndDate(endDate);
        genHolidayLimitModel.setStepYear(stepYear);
        System.out.println("setHolidayLimitBeginDateAndEndDate : beginDate:" + AtsDateUtils.dateShortFormatToString(beginDate) + ",endDate:" + AtsDateUtils.dateShortFormatToString(endDate));
    }

    public void setParentalHolidayLimitBeginDateAndEndDate(Context ctx, GenHolidayLimitModel genHolidayLimitModel, PersonPositionInfo ppi, Date cycleDate, String periodAccordType, HolidayPolicyInfo holidayPolicyInfo, HolidayRuleInfo holidayRuleInfo, EmpLaborRelationInfo laborInfo, PersonOtherInfoInfo otherInfo, NextGenerationInfo nextGenerationInfo) {
        int stepYear = 1;
        if (holidayPolicyInfo.getPeriodLengthUnit() != null && HolidayPeriodUniteEnum.year.getValue() == holidayPolicyInfo.getPeriodLengthUnit().getValue() && holidayPolicyInfo.getPeriodLength() != null && holidayPolicyInfo.getPeriodLength().intValue() >= 1) {
            stepYear = holidayPolicyInfo.getPeriodLength().intValue();
        }
        String cycleDateStr = HRTimeWebUtils.dateShortToString(cycleDate);
        String cycleDateYearStr = cycleDateStr.substring(0, 4);
        Date beginDate = null;
        Date endDate = null;
        if (holidayPolicyInfo.isEnablePeriod()) {
            String cycleCustomValue;
            String beginDateStr = "";
            String endDateStr = "";
            if (String.valueOf(CycleTypeEnum.year.getValue()).equals(periodAccordType)) {
                beginDateStr = cycleDateYearStr + "-01-01";
                endDateStr = new Integer(Integer.valueOf(cycleDateYearStr) + stepYear - 1).toString() + "-12-31";
            } else if (String.valueOf(CycleTypeEnum.hireDate.getValue()).equals(periodAccordType)) {
                Date jDate = null;
                if (laborInfo != null && laborInfo.getEnterDate() != null) {
                    jDate = laborInfo.getEnterDate();
                } else if (ppi.getJoinGroupDate() != null) {
                    jDate = ppi.getJoinGroupDate();
                } else if (ppi.getJoinDate() != null) {
                    jDate = ppi.getJoinDate();
                }
                if (jDate != null) {
                    Date jDate_1 = new Date(jDate.getTime() - 86400000L);
                    String tmpDtStr = cycleDateYearStr + HRTimeWebUtils.dateShortToString(jDate).substring(4);
                    if (HRTimeWebUtils.stringToShortDate(tmpDtStr).getTime() <= cycleDate.getTime()) {
                        beginDateStr = tmpDtStr;
                        endDateStr = HRTimeWebUtils.dateShortToString(jDate).substring(4).equals("-01-01") ? new Integer(Integer.valueOf(cycleDateYearStr) + stepYear - 1).toString() + HRTimeWebUtils.dateShortToString(jDate_1).substring(4) : new Integer(Integer.valueOf(cycleDateYearStr) + stepYear).toString() + HRTimeWebUtils.dateShortToString(jDate_1).substring(4);
                    } else {
                        endDateStr = cycleDateYearStr + HRTimeWebUtils.dateShortToString(jDate_1).substring(4);
                        beginDateStr = new Integer(Integer.valueOf(cycleDateYearStr) - stepYear).toString() + HRTimeWebUtils.dateShortToString(jDate).substring(4);
                    }
                } else {
                    beginDateStr = cycleDateYearStr + "-01-01";
                    endDateStr = new Integer(Integer.valueOf(cycleDateYearStr) + stepYear - 1).toString() + "-12-31";
                }
            } else if (String.valueOf(CycleTypeEnum.custom.getValue()).equals(periodAccordType)) {
                String cycleCustomValue2 = holidayRuleInfo.getCycleTypeCustomValue();
                if (!StringUtils.isEmpty((String)cycleCustomValue2) && cycleCustomValue2.length() == 10) {
                    int length = holidayPolicyInfo.getPeriodLength().intValue();
                    if (holidayPolicyInfo.getPeriodLengthUnit() == HolidayPeriodUniteEnum.year) {
                        Map beginEndDatestr = this.getBeginEndDateStrYearByCustom(length, cycleDate, cycleCustomValue2);
                        beginDateStr = (String)beginEndDatestr.get("beginDateStr");
                        endDateStr = (String)beginEndDatestr.get("endDateStr");
                    }
                }
            } else if (String.valueOf(CycleTypeEnum.childBirthDate.getValue()).equals(periodAccordType)) {
                String cycleCustomValue3 = AtsDateUtils.dateShortToString(nextGenerationInfo.getBirthdayDate());
                if (!StringUtils.isEmpty((String)cycleCustomValue3) && cycleCustomValue3.length() == 10) {
                    int length = holidayPolicyInfo.getPeriodLength().intValue();
                    if (holidayPolicyInfo.getPeriodLengthUnit() == HolidayPeriodUniteEnum.year) {
                        Map beginEndDatestr = this.getBeginEndDateStrYearByCustom(length, cycleDate, cycleCustomValue3);
                        beginDateStr = (String)beginEndDatestr.get("beginDateStr");
                        endDateStr = (String)beginEndDatestr.get("endDateStr");
                    }
                }
            } else if (String.valueOf(CycleTypeEnum.marRegDate.getValue()).equals(periodAccordType) && otherInfo != null && otherInfo.getWedDate() != null && !StringUtils.isEmpty((String)(cycleCustomValue = AtsDateUtils.dateShortToString(otherInfo.getWedDate()))) && cycleCustomValue.length() == 10) {
                int length = holidayPolicyInfo.getPeriodLength().intValue();
                if (holidayPolicyInfo.getPeriodLengthUnit() == HolidayPeriodUniteEnum.year) {
                    Map beginEndDatestr = this.getBeginEndDateStrYearByCustom(length, cycleDate, cycleCustomValue);
                    beginDateStr = (String)beginEndDatestr.get("beginDateStr");
                    endDateStr = (String)beginEndDatestr.get("endDateStr");
                }
            }
            beginDate = HRTimeWebUtils.stringToShortDate(beginDateStr);
            endDate = HRTimeWebUtils.stringToShortDate(endDateStr);
        } else {
            beginDate = ppi.getJoinGroupDate();
            endDate = new Date(1099, 11, 31);
        }
        genHolidayLimitModel.setCycleBeginDate(beginDate);
        genHolidayLimitModel.setCycleEndDate(endDate);
        genHolidayLimitModel.setStepYear(stepYear);
        System.out.println("setHolidayLimitBeginDateAndEndDate : beginDate:" + AtsDateUtils.dateShortFormatToString(beginDate) + ",endDate:" + AtsDateUtils.dateShortFormatToString(endDate));
    }

    public void setOtherHolidayLimitBeginDateAndEndDate(Context ctx, GenHolidayLimitModel genHolidayLimitModel, PersonPositionInfo ppi, Date cycleDate, String periodAccordType, HolidayPolicyInfo holidayPolicyInfo, HolidayRuleInfo holidayRuleInfo, EmpLaborRelationInfo laborInfo, PersonOtherInfoInfo otherInfo) {
        int stepYear = 1;
        if (holidayPolicyInfo.getPeriodLengthUnit() != null && holidayPolicyInfo.getPeriodLength() != null && holidayPolicyInfo.getPeriodLength().intValue() >= 1) {
            stepYear = holidayPolicyInfo.getPeriodLength().intValue();
        }
        String cycleDateStr = HRTimeWebUtils.dateShortToString(cycleDate);
        String cycleDateYearStr = cycleDateStr.substring(0, 4);
        Date beginDate = null;
        Date endDate = null;
        if (holidayPolicyInfo.isEnablePeriod()) {
            String beginDateStr = "";
            String endDateStr = "";
            if ("0".equals(periodAccordType)) {
                String cycleCustomValue = cycleDateYearStr + "-01-01";
                int length = holidayPolicyInfo.getPeriodLength().intValue();
                if (holidayPolicyInfo.getPeriodLengthUnit() == HolidayPeriodUniteEnum.year) {
                    Map beginEndDatestr = this.getBeginEndDateStrYearByCustom(length, cycleDate, cycleCustomValue);
                    beginDateStr = (String)beginEndDatestr.get("beginDateStr");
                    endDateStr = (String)beginEndDatestr.get("endDateStr");
                } else if (holidayPolicyInfo.getPeriodLengthUnit() == HolidayPeriodUniteEnum.month) {
                    Map beginEndDatestr = this.getBeginEndDateStrMonthByCustom(length, cycleDate, cycleCustomValue);
                    beginDateStr = (String)beginEndDatestr.get("beginDateStr");
                    endDateStr = (String)beginEndDatestr.get("endDateStr");
                }
            } else if ("1".equals(periodAccordType)) {
                Date jDate = null;
                if (laborInfo != null && laborInfo.getEnterDate() != null) {
                    jDate = laborInfo.getEnterDate();
                }
                if (jDate != null) {
                    String cycleCustomValue = AtsDateUtils.dateShortToString(jDate);
                    int length = holidayPolicyInfo.getPeriodLength().intValue();
                    if (holidayPolicyInfo.getPeriodLengthUnit() == HolidayPeriodUniteEnum.year) {
                        Map beginEndDatestr = this.getBeginEndDateStrYearByCustom(length, cycleDate, cycleCustomValue);
                        beginDateStr = (String)beginEndDatestr.get("beginDateStr");
                        endDateStr = (String)beginEndDatestr.get("endDateStr");
                    } else if (holidayPolicyInfo.getPeriodLengthUnit() == HolidayPeriodUniteEnum.month) {
                        Map beginEndDatestr = this.getBeginEndDateStrMonthByCustom(length, cycleDate, cycleCustomValue);
                        beginDateStr = (String)beginEndDatestr.get("beginDateStr");
                        endDateStr = (String)beginEndDatestr.get("endDateStr");
                    }
                } else {
                    Calendar calendar = Calendar.getInstance();
                    calendar.setTime(cycleDate);
                    int cycleMonth = calendar.get(2) + 1;
                    String cycleMonthStr = cycleMonth > 9 ? cycleMonth + "" : "0" + cycleMonth;
                    String cycleCustomValue = cycleDateYearStr + "-" + cycleMonthStr + "-01";
                    int length = holidayPolicyInfo.getPeriodLength().intValue();
                    if (holidayPolicyInfo.getPeriodLengthUnit() == HolidayPeriodUniteEnum.year) {
                        Map beginEndDatestr = this.getBeginEndDateStrYearByCustom(length, cycleDate, cycleCustomValue);
                        beginDateStr = (String)beginEndDatestr.get("beginDateStr");
                        endDateStr = (String)beginEndDatestr.get("endDateStr");
                    } else if (holidayPolicyInfo.getPeriodLengthUnit() == HolidayPeriodUniteEnum.month) {
                        Map beginEndDatestr = this.getBeginEndDateStrMonthByCustom(length, cycleDate, cycleCustomValue);
                        beginDateStr = (String)beginEndDatestr.get("beginDateStr");
                        endDateStr = (String)beginEndDatestr.get("endDateStr");
                    }
                }
            } else if ("2".equals(periodAccordType) && !StringUtils.isEmpty((String)holidayRuleInfo.getCycleTypeCustomValue()) && holidayRuleInfo.getCycleTypeCustomValue().length() == 10) {
                String cycleCustomValue = holidayRuleInfo.getCycleTypeCustomValue();
                int length = holidayPolicyInfo.getPeriodLength().intValue();
                if (holidayPolicyInfo.getPeriodLengthUnit() == HolidayPeriodUniteEnum.year) {
                    Map beginEndDatestr = this.getBeginEndDateStrYearByCustom(length, cycleDate, cycleCustomValue);
                    beginDateStr = (String)beginEndDatestr.get("beginDateStr");
                    endDateStr = (String)beginEndDatestr.get("endDateStr");
                } else if (holidayPolicyInfo.getPeriodLengthUnit() == HolidayPeriodUniteEnum.month) {
                    Map beginEndDatestr = this.getBeginEndDateStrMonthByCustom(length, cycleDate, cycleCustomValue);
                    beginDateStr = (String)beginEndDatestr.get("beginDateStr");
                    endDateStr = (String)beginEndDatestr.get("endDateStr");
                }
            } else if (String.valueOf(4).equals(periodAccordType)) {
                String personid = ppi.getPerson().getId().toString();
                Date wedDate = null;
                try {
                    PersonOtherInfoInfo personOtherInfoInfo = PersonOtherInfoFactory.getLocalInstance((Context)ctx).getPersonOtherInfoInfo("where person.id ='" + personid + "'");
                    if (personOtherInfoInfo.getWedDate() != null) {
                        wedDate = personOtherInfoInfo.getWedDate();
                    }
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
                if (wedDate != null) {
                    String cycleCustomValue = AtsDateUtils.dateShortToString(wedDate);
                    int length = holidayPolicyInfo.getPeriodLength().intValue();
                    if (holidayPolicyInfo.getPeriodLengthUnit() == HolidayPeriodUniteEnum.year) {
                        Map beginEndDatestr = this.getBeginEndDateStrYearByCustom(length, cycleDate, cycleCustomValue);
                        beginDateStr = (String)beginEndDatestr.get("beginDateStr");
                        endDateStr = (String)beginEndDatestr.get("endDateStr");
                    } else if (holidayPolicyInfo.getPeriodLengthUnit() == HolidayPeriodUniteEnum.month) {
                        Map beginEndDatestr = this.getBeginEndDateStrMonthByCustom(length, cycleDate, cycleCustomValue);
                        beginDateStr = (String)beginEndDatestr.get("beginDateStr");
                        endDateStr = (String)beginEndDatestr.get("endDateStr");
                    }
                } else {
                    Calendar calendar = Calendar.getInstance();
                    calendar.setTime(cycleDate);
                    int cycleMonth = calendar.get(2) + 1;
                    String cycleMonthStr = cycleMonth > 9 ? cycleMonth + "" : "0" + cycleMonth;
                    String cycleCustomValue = cycleDateYearStr + "-" + cycleMonthStr + "-01";
                    int length = holidayPolicyInfo.getPeriodLength().intValue();
                    if (holidayPolicyInfo.getPeriodLengthUnit() == HolidayPeriodUniteEnum.year) {
                        Map beginEndDatestr = this.getBeginEndDateStrYearByCustom(length, cycleDate, cycleCustomValue);
                        beginDateStr = (String)beginEndDatestr.get("beginDateStr");
                        endDateStr = (String)beginEndDatestr.get("endDateStr");
                    } else if (holidayPolicyInfo.getPeriodLengthUnit() == HolidayPeriodUniteEnum.month) {
                        Map beginEndDatestr = this.getBeginEndDateStrMonthByCustom(length, cycleDate, cycleCustomValue);
                        beginDateStr = (String)beginEndDatestr.get("beginDateStr");
                        endDateStr = (String)beginEndDatestr.get("endDateStr");
                    }
                }
            }
            beginDate = HRTimeWebUtils.stringToShortDate(beginDateStr);
            endDate = HRTimeWebUtils.stringToShortDate(endDateStr);
        } else {
            Date cudate;
            beginDate = null != ppi.getJoinGroupDate() ? (laborInfo.getEnterDate() != null ? (laborInfo.getEnterDate().getTime() > ppi.getJoinGroupDate().getTime() ? laborInfo.getEnterDate() : ppi.getJoinGroupDate()) : ppi.getJoinGroupDate()) : (laborInfo != null && laborInfo.getEnterDate() != null ? laborInfo.getEnterDate() : (otherInfo != null && otherInfo.getJobStartDate() != null ? otherInfo.getJobStartDate() : (cudate = new Date())));
            endDate = new Date(8099, 11, 31);
        }
        genHolidayLimitModel.setCycleBeginDate(beginDate);
        genHolidayLimitModel.setCycleEndDate(endDate);
        genHolidayLimitModel.setStepYear(stepYear);
    }

    private GenHolidayLimitRuleVO setIsNeedConvertLimt(Context ctx, HolidayRuleInfo holidayRuleInfo, PersonPositionInfo ppi, GenHolidayLimitModel GenHolidayLimitModel2, EmpLaborRelationInfo laborInfo, NextGenerationInfo nextGenerationInfo) {
        GenHolidayLimitRuleVO holidayLimitRuleVO = new GenHolidayLimitRuleVO();
        Date beginDate = GenHolidayLimitModel2.getCycleBeginDate();
        Date endDate = GenHolidayLimitModel2.getCycleEndDate();
        holidayLimitRuleVO.setConvert(false);
        holidayLimitRuleVO.setCalcuteOurAgeStyle(holidayRuleInfo.getCalcuteOurAgeStyle().getValue());
        if (null != holidayRuleInfo.getConvertType()) {
            holidayLimitRuleVO.setConvertType(holidayRuleInfo.getConvertType().getValue());
            holidayLimitRuleVO.setConverWorkType(holidayRuleInfo.getConvertType().getValue());
            holidayLimitRuleVO.setConverServeType(holidayRuleInfo.getConvertType().getValue());
        }
        if (holidayRuleInfo.getHolidayRlStdType() != null) {
            Date serveStartDate = null;
            if (holidayLimitRuleVO.getCalcuteOurAgeStyle() == 0) {
                serveStartDate = ppi.getJoinGroupDate();
            } else if (holidayLimitRuleVO.getCalcuteOurAgeStyle() == 1) {
                serveStartDate = ppi.getJoinDate();
            } else if (holidayLimitRuleVO.getCalcuteOurAgeStyle() == 3) {
                serveStartDate = laborInfo.getActualFormalDate() != null ? laborInfo.getActualFormalDate() : laborInfo.getPlanFormalDate();
            } else if (holidayLimitRuleVO.getCalcuteOurAgeStyle() == 4) {
                serveStartDate = ppi.getJoinGroupDateCur();
            } else if (laborInfo != null) {
                serveStartDate = laborInfo.getEnterDate();
            }
            if (serveStartDate == null) {
                Date date = serveStartDate = ppi.getJoinDate() != null ? ppi.getJoinDate() : laborInfo.getEnterDate();
            }
            if (holidayRuleInfo.getCalcuteLimitType() != null && serveStartDate != null) {
                if (holidayRuleInfo.getCalcuteLimitType().getValue() == 1) {
                    if (beginDate.getTime() <= serveStartDate.getTime() && serveStartDate.getTime() <= endDate.getTime() && holidayRuleInfo.isIsFirstYearConvert()) {
                        holidayLimitRuleVO.setConvert(true);
                        int converType = null == holidayRuleInfo.getFirstYearConvertType() ? 1 : holidayRuleInfo.getFirstYearConvertType().getValue();
                        int n = converType = converType == 3 ? converType + 1 : converType;
                        if (converType == 4) {
                            holidayLimitRuleVO.setConvert(false);
                        }
                        holidayLimitRuleVO.setConvertType(converType);
                        if (holidayRuleInfo.getHolidayRlStdType() == HolidayRlStdTypeEnum.servingAge) {
                            holidayLimitRuleVO.setConverServeType(converType);
                        } else {
                            holidayLimitRuleVO.setConverWorkType(converType);
                        }
                        holidayLimitRuleVO.setServe_ConvertDate(serveStartDate);
                    }
                } else {
                    Date nextYearDate = HRTimeWebUtils.getNextYearDate(serveStartDate);
                    if (beginDate.getTime() <= nextYearDate.getTime() && nextYearDate.getTime() <= endDate.getTime() && holidayRuleInfo.isIsFirstYearConvert()) {
                        holidayLimitRuleVO.setConvert(true);
                        int converType = holidayRuleInfo.getFirstYearConvertType().getValue();
                        int n = converType = converType == 3 ? converType + 1 : converType;
                        if (converType == 4) {
                            holidayLimitRuleVO.setConvert(false);
                        }
                        holidayLimitRuleVO.setConvertType(converType);
                        holidayLimitRuleVO.setConverWorkType(converType);
                        holidayLimitRuleVO.setServe_ConvertDate(nextYearDate);
                    }
                }
            }
        }
        holidayLimitRuleVO.setCrossBUConvert(false);
        if (this.fileHisCollectionMap.get(ppi.getPerson().getId().toString()) != null && this.fileHisCollectionMap.get(ppi.getPerson().getId().toString()).size() > 0 && holidayRuleInfo.isIsCrossBUConvertByEffdt()) {
            AtsHolidayFileHisCollection coll = this.fileHisCollectionMap.get(ppi.getPerson().getId().toString());
            Date calDate = null;
            try {
                AtsHolidayFileHisCollection col = AtsHolidayFileHisFactory.getLocalInstance(ctx).getAtsHolidayFileHisCollection("select hrOrgUnit,effdt,leffdt where proposer.id='" + ppi.getPerson().getId().toString() + "'  order by leffdt  ");
                for (int i = 0; i < col.size(); ++i) {
                    int day;
                    Calendar dar;
                    String hrOrgUnit = col.get(i).getHrOrgUnit().getId().toString();
                    if (col.get(i).getLEFFDT().getTime() <= coll.get(0).getEFFDT().getTime() && col.get(i).getLEFFDT().getTime() >= beginDate.getTime()) {
                        if (hrOrgUnit.equals(coll.get(0).getHrOrgUnit().getId().toString())) continue;
                        dar = Calendar.getInstance();
                        dar.setTime(col.get(i).getLEFFDT());
                        day = dar.get(5);
                        dar.set(5, day + 1);
                        GenHolidayLimitModel2.setChangeHrOrgUnit(true);
                        calDate = dar.getTime();
                    }
                    if (col.get(i).getEFFDT().getTime() < coll.get(0).getEFFDT().getTime() || col.get(i).getEFFDT().getTime() > endDate.getTime() || hrOrgUnit.equals(coll.get(0).getHrOrgUnit().getId().toString())) continue;
                    dar = Calendar.getInstance();
                    dar.setTime(col.get(i).getEFFDT());
                    day = dar.get(5);
                    dar.set(5, day - 1);
                    GenHolidayLimitModel2.setCycleEndDate(dar.getTime());
                    GenHolidayLimitModel2.setChangeHrOrgUnitOld(true);
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            if (calDate != null && calDate.getTime() > GenHolidayLimitModel2.getCycleBeginDate().getTime() && calDate.getTime() <= GenHolidayLimitModel2.getCycleEndDate().getTime()) {
                float tempdown = (GenHolidayLimitModel2.getCycleEndDate().getTime() - GenHolidayLimitModel2.getCycleBeginDate().getTime()) / 86400000L;
                float tempup = (GenHolidayLimitModel2.getCycleEndDate().getTime() - calDate.getTime()) / 86400000L;
                float convertVal = (tempup + 1.0f) / (tempdown + 1.0f);
                GenHolidayLimitModel2.setEffectDate(calDate);
                holidayLimitRuleVO.setCrossBUConvert(true);
                holidayLimitRuleVO.setCrossBU_ConvertVal(convertVal);
            }
        }
        return holidayLimitRuleVO;
    }

    private void setHolidayLimitYearRange(Context ctx, GenHolidayLimitRuleVO holidayLimitRuleVO, PersonPositionInfo ppi, GenHolidayLimitModel GenHolidayLimitModel2, EmpLaborRelationInfo laborInfo, PersonOtherInfoInfo otherInfo, HolidayRuleInfo holidayRuleInfo, NextGenerationInfo nextGenerationInfo) {
        Date beginDate = GenHolidayLimitModel2.getCycleBeginDate();
        Date endDate = GenHolidayLimitModel2.getLeftEndDate();
        holidayLimitRuleVO.setLeftRecalculate(true);
        if (endDate == null) {
            endDate = GenHolidayLimitModel2.getCycleEndDate();
            holidayLimitRuleVO.setLeftRecalculate(false);
        }
        int stepYear = GenHolidayLimitModel2.getStepYear();
        Date currentDate = HRTimeWebUtils.stringToShortDate(HRTimeWebUtils.getCurentShortStringDate());
        Date jobStartDate = null;
        if (otherInfo != null) {
            jobStartDate = otherInfo.getJobStartDate();
        }
        float work_yearCtn1 = 0.0f;
        float work_yearCtn2 = 0.0f;
        float work_yearCtn3 = 0.0f;
        float convertCtn = 0.0f;
        float minWorkConvertUnit = 0.0f;
        if (jobStartDate != null && holidayLimitRuleVO.getConverWorkType() != 0) {
            int convertType = holidayLimitRuleVO.getConverWorkType();
            if (convertType == 3) {
                work_yearCtn1 = work_yearCtn2 = this.getValueAfterConvert(ctx, jobStartDate, endDate, convertType);
            } else {
                work_yearCtn1 = this.getValueAfterConvert(ctx, jobStartDate, beginDate, convertType);
                work_yearCtn2 = this.getValueAfterConvert(ctx, jobStartDate, endDate, convertType);
            }
            work_yearCtn3 = currentDate.getTime() >= endDate.getTime() ? this.getValueAfterConvert(ctx, jobStartDate, endDate, convertType) : this.getValueAfterConvert(ctx, jobStartDate, currentDate, convertType);
            if (holidayLimitRuleVO.getServe_ConvertDate() != null) {
                convertCtn = this.getValueAfterConvert(ctx, jobStartDate, holidayLimitRuleVO.getServe_ConvertDate(), convertType);
            }
            minWorkConvertUnit = this.getMinConvertUnit(convertType);
        }
        Date serveStartDate = null;
        if (holidayLimitRuleVO.getCalcuteOurAgeStyle() == 0) {
            serveStartDate = ppi.getJoinGroupDate();
        } else if (holidayLimitRuleVO.getCalcuteOurAgeStyle() == 1) {
            serveStartDate = ppi.getJoinDate();
        } else if (holidayLimitRuleVO.getCalcuteOurAgeStyle() == 3) {
            serveStartDate = laborInfo.getActualFormalDate() != null ? laborInfo.getActualFormalDate() : laborInfo.getPlanFormalDate();
        } else if (holidayLimitRuleVO.getCalcuteOurAgeStyle() == 4) {
            serveStartDate = ppi.getJoinGroupDateCur();
        } else if (laborInfo != null) {
            serveStartDate = laborInfo.getEnterDate();
        }
        if (serveStartDate == null) {
            serveStartDate = ppi.getJoinDate() != null ? ppi.getJoinDate() : (laborInfo != null ? laborInfo.getEnterDate() : null);
        }
        float serve_yearCtn1 = 0.0f;
        float serve_yearCtn2 = 0.0f;
        float serve_yearCtn3 = 0.0f;
        float minServeConvertUnit = 0.0f;
        if (serveStartDate != null && holidayLimitRuleVO.getConverServeType() != 0) {
            int convertType = holidayLimitRuleVO.getConverServeType();
            if (convertType == 3) {
                serve_yearCtn1 = serve_yearCtn2 = this.getValueAfterConvert(ctx, serveStartDate, endDate, convertType);
            } else {
                serve_yearCtn1 = this.getValueAfterConvert(ctx, serveStartDate, beginDate, convertType);
                serve_yearCtn2 = this.getValueAfterConvert(ctx, serveStartDate, endDate, convertType);
            }
            serve_yearCtn3 = currentDate.getTime() >= endDate.getTime() ? this.getValueAfterConvert(ctx, serveStartDate, endDate, convertType) : this.getValueAfterConvert(ctx, serveStartDate, currentDate, convertType);
            minServeConvertUnit = this.getMinConvertUnit(convertType);
        }
        if (holidayLimitRuleVO.getServe_ConvertDate() != null) {
            if (holidayRuleInfo.getHolidayRlStdType() == HolidayRlStdTypeEnum.childrenAge && nextGenerationInfo != null && nextGenerationInfo.getBirthdayDate() != null) {
                logger.error((Object)MessageFormat.format("-----childrenAge method.old convertCtn={0}", Float.valueOf(convertCtn)));
                convertCtn = this.getValueAfterConvert(ctx, nextGenerationInfo.getBirthdayDate(), holidayLimitRuleVO.getServe_ConvertDate(), holidayLimitRuleVO.getConvertType());
                logger.error((Object)MessageFormat.format("-----childrenAge method.new convertCtn={0}", Float.valueOf(convertCtn)));
            } else if (holidayRuleInfo.getHolidayRlStdType() == HolidayRlStdTypeEnum.MarriageAge && otherInfo == null && otherInfo.getWedDate() == null) {
                logger.error((Object)MessageFormat.format("-----MarriageAge method.old convertCtn={0}", Float.valueOf(convertCtn)));
                convertCtn = this.getValueAfterConvert(ctx, otherInfo.getWedDate(), holidayLimitRuleVO.getServe_ConvertDate(), holidayLimitRuleVO.getConvertType());
                logger.error((Object)MessageFormat.format("-----MarriageAge method.new convertCtn={0}", Float.valueOf(convertCtn)));
            }
        }
        List<Float> childrenYearCtnList = this.getYearCtn(ctx, holidayLimitRuleVO, nextGenerationInfo == null || nextGenerationInfo.getBirthdayDate() == null ? null : nextGenerationInfo.getBirthdayDate(), currentDate, beginDate, endDate, true);
        List<Float> wedYearCtnList = this.getYearCtn(ctx, holidayLimitRuleVO, otherInfo == null || otherInfo.getWedDate() == null ? null : otherInfo.getWedDate(), currentDate, beginDate, endDate, false);
        this.ppiAdjustGroupVal = holidayLimitRuleVO.getCalcuteOurAgeStyle() == 4 ? ppi.getAdjustGroupCurVal() : ppi.getAdjustGroupVal();
        this.ppiAdjustCoValue = ppi.getAdjustCoValue();
        this.otherInfoAdjustSerVal = otherInfo.getAdjustSerVal();
        holidayLimitRuleVO.setWork_yearCtn1(work_yearCtn1);
        holidayLimitRuleVO.setWork_yearCtn2(work_yearCtn2);
        holidayLimitRuleVO.setWork_yearCtn3(work_yearCtn3);
        holidayLimitRuleVO.setServe_yearCtn1(serve_yearCtn1);
        holidayLimitRuleVO.setServe_yearCtn2(serve_yearCtn2);
        holidayLimitRuleVO.setServe_yearCtn3(serve_yearCtn3);
        holidayLimitRuleVO.setServe_ConvertVal(convertCtn);
        holidayLimitRuleVO.setMinServeConvertUnit(minServeConvertUnit);
        holidayLimitRuleVO.setMinWorkConvertUnit(minWorkConvertUnit);
        holidayLimitRuleVO.setStepYear(stepYear);
        holidayLimitRuleVO.setChildYearCtn1(AtsCollectionUtile.isEmpty(childrenYearCtnList) ? -1.0f : childrenYearCtnList.get(0).floatValue());
        holidayLimitRuleVO.setChildYearCtn2(AtsCollectionUtile.isEmpty(childrenYearCtnList) ? -1.0f : childrenYearCtnList.get(1).floatValue());
        holidayLimitRuleVO.setChildYearCtn3(AtsCollectionUtile.isEmpty(childrenYearCtnList) ? -1.0f : childrenYearCtnList.get(2).floatValue());
        holidayLimitRuleVO.setMinChildConvertUnit(AtsCollectionUtile.isEmpty(childrenYearCtnList) ? -1.0f : childrenYearCtnList.get(3).floatValue());
        holidayLimitRuleVO.setWedYearCtn1(AtsCollectionUtile.isEmpty(wedYearCtnList) ? -1.0f : wedYearCtnList.get(0).floatValue());
        holidayLimitRuleVO.setWedYearCtn2(AtsCollectionUtile.isEmpty(wedYearCtnList) ? -1.0f : wedYearCtnList.get(1).floatValue());
        holidayLimitRuleVO.setWedYearCtn3(AtsCollectionUtile.isEmpty(wedYearCtnList) ? -1.0f : wedYearCtnList.get(2).floatValue());
        holidayLimitRuleVO.setMinWedConvertUnit(AtsCollectionUtile.isEmpty(wedYearCtnList) ? -1.0f : wedYearCtnList.get(3).floatValue());
    }

    public List<Float> getYearCtn(Context ctx, GenHolidayLimitRuleVO holidayLimitRuleVO, Date startDate, Date currentDate, Date beginDate, Date endDate, boolean isParentalLeave) {
        ArrayList<Float> yearCtnList = new ArrayList<Float>();
        if (startDate == null) {
            logger.error((Object)"startDate is null");
            return yearCtnList;
        }
        Float yearCtn1 = Float.valueOf(0.0f);
        Float yearCtn2 = Float.valueOf(0.0f);
        Float yearCtn3 = Float.valueOf(0.0f);
        Float minConvertUnit = Float.valueOf(0.0f);
        int convertType = holidayLimitRuleVO.getConvertType();
        if (convertType == 3) {
            yearCtn2 = Float.valueOf(this.getValueAfterConvert(ctx, startDate, endDate, convertType));
            logger.error((Object)("...........yearCtn2=" + yearCtn2));
            yearCtn1 = yearCtn2;
            if (isParentalLeave) {
                holidayLimitRuleVO.getGenHolidayLimitModel().setChildDateCtn1(endDate);
                holidayLimitRuleVO.getGenHolidayLimitModel().setChildDateCtn2(endDate);
            }
        } else {
            yearCtn1 = Float.valueOf(this.getValueAfterConvert(ctx, startDate, beginDate, convertType));
            logger.error((Object)("...........yearCtn1=" + yearCtn1));
            yearCtn2 = Float.valueOf(this.getValueAfterConvert(ctx, startDate, endDate, convertType));
            if (isParentalLeave) {
                holidayLimitRuleVO.getGenHolidayLimitModel().setChildDateCtn1(startDate.after(beginDate) ? startDate : beginDate);
                holidayLimitRuleVO.getGenHolidayLimitModel().setChildDateCtn2(endDate);
            }
        }
        if (currentDate.getTime() >= endDate.getTime()) {
            yearCtn3 = Float.valueOf(this.getValueAfterConvert(ctx, startDate, endDate, convertType));
            logger.error((Object)("...........yearCtn3=" + yearCtn3));
            if (isParentalLeave) {
                holidayLimitRuleVO.getGenHolidayLimitModel().setChildDateCtn3(endDate);
            }
        } else {
            yearCtn3 = Float.valueOf(this.getValueAfterConvert(ctx, startDate, currentDate, convertType));
            if (isParentalLeave) {
                holidayLimitRuleVO.getGenHolidayLimitModel().setChildDateCtn3(currentDate);
            }
            logger.error((Object)("...........yearCtn3=" + yearCtn3));
        }
        minConvertUnit = Float.valueOf(this.getMinConvertUnit(convertType));
        yearCtnList.add(yearCtn1);
        yearCtnList.add(yearCtn2);
        yearCtnList.add(yearCtn3);
        yearCtnList.add(minConvertUnit);
        return yearCtnList;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public GenHolidayLimitModel isValidFirstCalcuteLimit(HolidayRuleInfo holidayRuleInfo, PersonPositionInfo ppi, GenHolidayLimitModel GenHolidayLimitModel2, EmpLaborRelationInfo laborInfo) {
        if (holidayRuleInfo.getValueType().getValue() != 1 || holidayRuleInfo.getCalcuteLimitType() == null) return GenHolidayLimitModel2;
        Date serveStartDate = null;
        if (ppi.getJoinGroupDate() != null) {
            serveStartDate = ppi.getJoinGroupDate();
        } else if (laborInfo != null) {
            serveStartDate = laborInfo.getEnterDate();
        }
        if (holidayRuleInfo.getCalcuteLimitType().getValue() == 2) {
            if (serveStartDate == null) return null;
            Date nextYearDate = HRTimeWebUtils.getNextYearDate(serveStartDate);
            if (nextYearDate.getTime() <= GenHolidayLimitModel2.getCycleEndDate().getTime()) return GenHolidayLimitModel2;
            if (ppi.getJoinGroupDate() == null) {
                GenHolidayLimitModel2.setErrorType(1);
                return GenHolidayLimitModel2;
            } else {
                GenHolidayLimitModel2.setErrorType(2);
            }
            return GenHolidayLimitModel2;
        }
        if (serveStartDate == null) return null;
        if (serveStartDate.getTime() <= GenHolidayLimitModel2.getCycleEndDate().getTime()) return GenHolidayLimitModel2;
        if (ppi.getJoinGroupDate() == null) {
            GenHolidayLimitModel2.setErrorType(3);
            return GenHolidayLimitModel2;
        } else {
            GenHolidayLimitModel2.setErrorType(4);
        }
        return GenHolidayLimitModel2;
    }

    @Override
    public BigDecimal isGrantStandarLimit(Context ctx, BigDecimal standardLimit, HolidayPolicyInfo holidayPolicyInfo, GenHolidayLimitModel GenHolidayLimitModel2, PersonPositionInfo personPositionInfo, HolidayRuleInfo holidayRuleInfo, EmpLaborRelationInfo laborInfo, PersonOtherInfoInfo otherInfo) {
        Date calEndDate;
        BigDecimal standardVal;
        logger.error((Object)MessageFormat.format("isGrantStandarLimit method.standardLimit={0},GenHolidayLimitModel={1}", standardLimit, GenHolidayLimitModel2));
        if (holidayPolicyInfo.isIsPiecewiseCal() && GenHolidayLimitModel2.getGenPiecewiseBO() != null && (standardVal = GenPiecewiseManager.processPiecewiseCal(GenHolidayLimitModel2.getGenPiecewiseBO(), holidayPolicyInfo.getLimitGrantStyle())) != null) {
            return standardVal;
        }
        Date enterDate = null;
        HashMap<String, Object> param = new HashMap<String, Object>();
        param.put("holidayPolicyInfo", holidayPolicyInfo);
        if (holidayRuleInfo.getCalcuteOurAgeStyle() != null) {
            int calcuteOurAgeStyleValue = holidayRuleInfo.getCalcuteOurAgeStyle().getValue();
            enterDate = calcuteOurAgeStyleValue == 0 ? personPositionInfo.getJoinGroupDate() : (calcuteOurAgeStyleValue == 1 ? personPositionInfo.getJoinDate() : (calcuteOurAgeStyleValue == 3 ? laborInfo.getActualFormalDate() : (calcuteOurAgeStyleValue == 4 ? personPositionInfo.getJoinGroupDateCur() : laborInfo.getEnterDate())));
        }
        if (enterDate == null) {
            enterDate = personPositionInfo.getJoinDate() != null ? personPositionInfo.getJoinDate() : laborInfo.getEnterDate();
        }
        boolean isParentLeave = false;
        if (GenHolidayLimitModel2.getCalChildDateCtnBegin() != null && GenHolidayLimitModel2.getCalChildDateCtnEnd() != null) {
            isParentLeave = true;
        }
        Date calBeginDate = GenHolidayLimitModel2.getCalChildDateCtnBegin() == null ? GenHolidayLimitModel2.getCycleBeginDate() : GenHolidayLimitModel2.getCalChildDateCtnBegin();
        Date date = calEndDate = GenHolidayLimitModel2.getCalChildDateCtnEnd() == null ? GenHolidayLimitModel2.getCycleEndDate() : GenHolidayLimitModel2.getCalChildDateCtnEnd();
        if (holidayPolicyInfo.getLimitGrantStyle().getValue() != 1) {
            if (holidayPolicyInfo.getLimitGrantStyle().getValue() == 2) {
                int temp = 0;
                if (new Date().compareTo(GenHolidayLimitModel2.getCycleBeginDate()) != -1) {
                    temp = HRTimeWebUtils.getMonthsBetweenTwoDate(new Date(), calBeginDate);
                }
                int a = 0;
                int totalMonth = HRTimeWebUtils.getMonthsBetweenTwoDate(calEndDate, calBeginDate);
                int n = totalMonth = totalMonth > 12 ? 12 : totalMonth;
                a = isParentLeave ? (temp > totalMonth ? totalMonth : temp) : (temp > 12 ? 12 : temp);
                int b = HRTimeWebUtils.getMonthsBetweenTwoDate(calEndDate, enterDate);
                int n2 = b = b > 12 ? 12 : b;
                if (enterDate.getYear() == new Date().getYear()) {
                    a = HRTimeWebUtils.getMonthsBetweenTwoDate(new Date(), enterDate);
                } else {
                    b = isParentLeave ? totalMonth : 12;
                }
                if (b != 0) {
                    param.put("standardLimit", standardLimit.multiply(new BigDecimal((float)((double)a * 1.0 / (double)b > 1.0 ? 1.0 : (double)a * 1.0 / (double)b))));
                    standardLimit = new DecimalPlaceContext(this.strategy_1).precisionConvert(ctx, param);
                } else {
                    standardLimit = new BigDecimal(0);
                }
            } else {
                int temp = 0;
                if (new Date().compareTo(calBeginDate) != -1) {
                    temp = HRTimeWebUtils.getQuarterBetweenTwoDate(new Date(), calBeginDate);
                }
                int a = 0;
                int totalQUARTEROFYEAR = HRTimeWebUtils.getQuarterBetweenTwoDate(calEndDate, calBeginDate);
                int n = totalQUARTEROFYEAR = totalQUARTEROFYEAR > 4 ? 4 : totalQUARTEROFYEAR;
                a = isParentLeave ? (temp > totalQUARTEROFYEAR ? totalQUARTEROFYEAR : temp) : (temp > 4 ? 4 : temp);
                int b = HRTimeWebUtils.getQuarterBetweenTwoDate(calEndDate, enterDate);
                if (enterDate.getYear() == new Date().getYear()) {
                    a = HRTimeWebUtils.getQuarterBetweenTwoDate(new Date(), enterDate);
                } else {
                    b = isParentLeave ? totalQUARTEROFYEAR : 4;
                }
                if (b != 0) {
                    param.put("standardLimit", standardLimit.multiply(new BigDecimal((float)((double)a * 1.0 / (double)b > 1.0 ? 1.0 : (double)a * 1.0 / (double)b))));
                    standardLimit = new DecimalPlaceContext(this.strategy_1).precisionConvert(ctx, param);
                } else {
                    standardLimit = new BigDecimal(0);
                }
            }
        }
        return standardLimit;
    }

    @Override
    public BigDecimal isLeftRecalculate(BigDecimal standardLimit, HolidayRuleInfo holidayRuleInfo, PersonPositionInfo personPositionInfo, GenHolidayLimitModel GenHolidayLimitModel2, EmpLaborRelationInfo laborInfo, PersonOtherInfoInfo otherInfo) {
        Date cycleBeginDate = personPositionInfo.getEnterDate().compareTo(GenHolidayLimitModel2.getCycleBeginDate()) == 1 ? personPositionInfo.getEnterDate() : GenHolidayLimitModel2.getCycleBeginDate();
        Date leftDate = personPositionInfo.getLeftDate();
        Date cycleEndDate = GenHolidayLimitModel2.getCycleEndDate();
        ConvertTypeEnum convertType = holidayRuleInfo.getConvertType();
        if (convertType != null) {
            int convertTypevalue = convertType.getValue();
            if (convertTypevalue == 1) {
                int a = (int)HRTimeWebUtils.getDaysBetweenTwoDate(leftDate, cycleBeginDate);
                int b = (int)HRTimeWebUtils.getDaysBetweenTwoDate(cycleEndDate, cycleBeginDate);
                standardLimit = standardLimit.multiply(BigDecimal.valueOf((float)a / (float)b));
            } else if (convertTypevalue == 2) {
                int a = HRTimeWebUtils.getMonthsBetweenTwoDate(leftDate, cycleBeginDate);
                int b = HRTimeWebUtils.getMonthsBetweenTwoDate(cycleEndDate, cycleBeginDate);
                standardLimit = standardLimit.multiply(BigDecimal.valueOf((float)a / (float)b));
            }
        }
        return standardLimit;
    }

    public BigDecimal isTransferRecalculate(Context ctx, String hrOrgUnitId, BigDecimal standardLimit, HolidayRuleInfo holidayRuleInfo, PersonPositionInfo personPositionInfo, GenHolidayLimitModel GenHolidayLimitModel2, EmpLaborRelationInfo laborInfo, PersonOtherInfoInfo otherInfo) {
        Date cycleBeginDate = personPositionInfo.getEnterDate().compareTo(GenHolidayLimitModel2.getCycleBeginDate()) == 1 ? personPositionInfo.getEnterDate() : GenHolidayLimitModel2.getCycleBeginDate();
        Date cycleEndDate = GenHolidayLimitModel2.getCycleEndDate();
        AtsHolidayFileHisCollection atsHolidayFileHisCollection = new AtsHolidayFileHisCollection();
        try {
            atsHolidayFileHisCollection = AtsHolidayFileHisFactory.getLocalInstance(ctx).getAtsHolidayFileHisCollection("where proposerid = '" + otherInfo.getPerson().getId().toString() + "' order by effdt asc");
        }
        catch (BOSException e) {
            e.printStackTrace();
        }
        Date transferDate = cycleBeginDate;
        for (int i = 0; i < atsHolidayFileHisCollection.size(); ++i) {
            AtsHolidayFileHisInfo hisInfo = atsHolidayFileHisCollection.get(i);
            if (hisInfo.getEFFDT().getTime() < cycleBeginDate.getTime() || hisInfo.getEFFDT().getTime() > cycleEndDate.getTime() || hisInfo.getLEFFDT().getTime() < cycleBeginDate.getTime() || !hisInfo.getHrOrgUnit().getId().toString().equals(hrOrgUnitId)) continue;
            transferDate = hisInfo.getEFFDT();
        }
        ConvertTypeEnum convertType = holidayRuleInfo.getConvertType();
        if (convertType != null) {
            int convertTypevalue = convertType.getValue();
            if (convertTypevalue == 1) {
                int a = (int)HRTimeWebUtils.getDaysBetweenTwoDate(transferDate, cycleBeginDate);
                int b = (int)HRTimeWebUtils.getDaysBetweenTwoDate(cycleEndDate, cycleBeginDate);
                standardLimit = standardLimit.multiply(BigDecimal.valueOf((float)a / (float)b));
            } else if (convertTypevalue == 2) {
                int a = HRTimeWebUtils.getMonthsBetweenTwoDate(transferDate, cycleBeginDate);
                int b = HRTimeWebUtils.getMonthsBetweenTwoDate(cycleEndDate, cycleBeginDate);
                standardLimit = standardLimit.multiply(BigDecimal.valueOf((float)a / (float)b));
            }
        }
        return standardLimit;
    }

    private Map getBeginEndDateStrYearByCustom(int length, Date cycleDate, String cycleCustomValue) {
        int monthCycleYear;
        String beginDateStr = "";
        String endDateStr = "";
        int customYear = Integer.valueOf(cycleCustomValue.substring(0, 4));
        int customMonth = Integer.valueOf(cycleCustomValue.substring(5, 7));
        int customDay = Integer.valueOf(cycleCustomValue.substring(8, 10));
        String customDayStr = customDay > 9 ? customDay + "" : "0" + customDay;
        int customMonth_Day = Integer.valueOf(customMonth + "" + customDayStr);
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(cycleDate);
        String cycleDayStr = calendar.get(5) > 9 ? calendar.get(5) + "" : "0" + calendar.get(5);
        int cycleMonth_Day = Integer.valueOf(calendar.get(2) + 1 + cycleDayStr);
        int cycleYear = calendar.get(1);
        if (cycleDate.compareTo(AtsDateUtils.stringToShortDate(cycleCustomValue)) < 0) {
            if (cycleMonth_Day < customMonth_Day) {
                calendar.add(1, -1);
            }
            calendar.set(2, customMonth - 1);
            calendar.set(5, customDay);
            cycleYear = calendar.get(1);
            cycleDate = calendar.getTime();
            if ((customYear - cycleYear) % length == 0) {
                beginDateStr = HRTimeWebUtils.dateShortToString(cycleDate);
                endDateStr = HRTimeWebUtils.dateShortToString(GenHolidayLimitRuleImpl.getYearLastDay(cycleDate, length, -1));
            } else {
                monthCycleYear = calendar.get(1);
                beginDateStr = HRTimeWebUtils.dateShortToString(HRTimeWebUtils.addYear(cycleDate, (customYear - monthCycleYear) % length - length));
                endDateStr = HRTimeWebUtils.dateShortToString(GenHolidayLimitRuleImpl.getYearLastDay(HRTimeWebUtils.stringToShortDate(beginDateStr), length, -1));
            }
        } else {
            if (cycleMonth_Day < customMonth_Day) {
                calendar.add(1, -1);
            }
            calendar.set(2, customMonth - 1);
            calendar.set(5, customDay);
            cycleYear = calendar.get(1);
            cycleDate = calendar.getTime();
            if ((cycleYear - customYear) % length == 0) {
                beginDateStr = HRTimeWebUtils.dateShortToString(cycleDate);
                endDateStr = HRTimeWebUtils.dateShortToString(GenHolidayLimitRuleImpl.getYearLastDay(cycleDate, length, -1));
            } else {
                monthCycleYear = calendar.get(1);
                beginDateStr = HRTimeWebUtils.dateShortToString(HRTimeWebUtils.addYear(cycleDate, -(monthCycleYear - customYear) % length));
                endDateStr = HRTimeWebUtils.dateShortToString(GenHolidayLimitRuleImpl.getYearLastDay(HRTimeWebUtils.stringToShortDate(beginDateStr), length, -1));
            }
        }
        HashMap<String, String> beginEndDateStrMap = new HashMap<String, String>();
        beginEndDateStrMap.put("beginDateStr", beginDateStr);
        beginEndDateStrMap.put("endDateStr", endDateStr);
        return beginEndDateStrMap;
    }

    private Map getBeginEndDateStrMonthByCustom(int length, Date cycleDate, String cycleCustomValue) {
        String beginDateStr = "";
        String endDateStr = "";
        int customDay = Integer.parseInt(cycleCustomValue.substring(8, 10));
        int customMonth = Integer.parseInt(cycleCustomValue.substring(5, 7));
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(cycleDate);
        int cycleDay = calendar.get(5);
        if (cycleDay < customDay) {
            calendar.add(2, -1);
        }
        calendar.set(5, customDay);
        cycleDate = calendar.getTime();
        int cycleMonth = calendar.get(2) + 1;
        if (cycleMonth < customMonth) {
            if ((customMonth - cycleMonth) % length == 0) {
                beginDateStr = HRTimeWebUtils.dateShortToString(cycleDate);
                endDateStr = HRTimeWebUtils.dateShortToString(GenHolidayLimitRuleImpl.getMonthLastDay(cycleDate, length, -1));
            } else {
                beginDateStr = HRTimeWebUtils.dateShortToString(HRTimeWebUtils.addMonth(cycleDate, (customMonth - cycleMonth) % length - length));
                endDateStr = HRTimeWebUtils.dateShortToString(GenHolidayLimitRuleImpl.getMonthLastDay(HRTimeWebUtils.stringToShortDate(beginDateStr), length, -1));
            }
        } else if ((cycleMonth - customMonth) % length == 0) {
            beginDateStr = HRTimeWebUtils.dateShortToString(cycleDate);
            endDateStr = HRTimeWebUtils.dateShortToString(GenHolidayLimitRuleImpl.getMonthLastDay(cycleDate, length, -1));
        } else {
            beginDateStr = HRTimeWebUtils.dateShortToString(HRTimeWebUtils.addMonth(cycleDate, -(cycleMonth - customMonth) % length));
            endDateStr = HRTimeWebUtils.dateShortToString(GenHolidayLimitRuleImpl.getMonthLastDay(HRTimeWebUtils.stringToShortDate(beginDateStr), length, -1));
        }
        HashMap<String, String> beginEndDateStrMap = new HashMap<String, String>();
        beginEndDateStrMap.put("beginDateStr", beginDateStr);
        beginEndDateStrMap.put("endDateStr", endDateStr);
        return beginEndDateStrMap;
    }

    public static Date getMonthLastDay(Date date, int months, int days) {
        Calendar cal = Calendar.getInstance();
        cal.setTime(date);
        cal.add(2, months);
        cal.add(5, days);
        Date lastDate = cal.getTime();
        return lastDate;
    }

    public static Date getYearLastDay(Date date, int years, int days) {
        Calendar cal = Calendar.getInstance();
        cal.setTime(date);
        cal.add(1, years);
        cal.add(5, days);
        Date lastDate = cal.getTime();
        return lastDate;
    }
}

