/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.hr.ats.lightapp.util;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.basedata.person.PersonInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.hr.ats.AbstractAttendancePeriodInfo;
import com.kingdee.eas.hr.ats.AtsAttenceCycleResEnum;
import com.kingdee.eas.hr.ats.AtsAttenceResEnum;
import com.kingdee.eas.hr.ats.AtsFileResEnum;
import com.kingdee.eas.hr.ats.AtsHolidayFileCollection;
import com.kingdee.eas.hr.ats.AtsHolidayFileFactory;
import com.kingdee.eas.hr.ats.AtsHolidayResEnum;
import com.kingdee.eas.hr.ats.AtsLeaveBillEntryCollection;
import com.kingdee.eas.hr.ats.AtsLeaveBillEntryFactory;
import com.kingdee.eas.hr.ats.AtsLeaveBillEntryInfo;
import com.kingdee.eas.hr.ats.AtsLeaveBillFactory;
import com.kingdee.eas.hr.ats.AtsLeaveBillInfo;
import com.kingdee.eas.hr.ats.AtsLeaveBillResEnum;
import com.kingdee.eas.hr.ats.AttencePolicyInfo;
import com.kingdee.eas.hr.ats.AttendancePeriodCollection;
import com.kingdee.eas.hr.ats.AttendancePeriodFactory;
import com.kingdee.eas.hr.ats.AttendancePeriodInfo;
import com.kingdee.eas.hr.ats.CancelLeaveAmountUnitEnum;
import com.kingdee.eas.hr.ats.CancelLeaveBillCollection;
import com.kingdee.eas.hr.ats.CancelLeaveBillEntryInfo;
import com.kingdee.eas.hr.ats.CancelLeaveBillInfo;
import com.kingdee.eas.hr.ats.FillAmountUnitEnum;
import com.kingdee.eas.hr.ats.FillHolidayCycleTypeEnum;
import com.kingdee.eas.hr.ats.HolidayLimitCollection;
import com.kingdee.eas.hr.ats.HolidayLimitFactory;
import com.kingdee.eas.hr.ats.HolidayPolicyFactory;
import com.kingdee.eas.hr.ats.HolidayPolicyInfo;
import com.kingdee.eas.hr.ats.HolidayPolicySetFactory;
import com.kingdee.eas.hr.ats.HolidayPolicySetInfo;
import com.kingdee.eas.hr.ats.holidayLimit.CancelHolidayLimit.util.CelLeaveBillEditHolidayTypeUtil;
import com.kingdee.eas.hr.ats.lightapp.util.AtsWebUtils;
import com.kingdee.eas.hr.ats.lightapp.util.AttencePolicyFillHelper;
import com.kingdee.eas.hr.ats.lightapp.util.AttencePolicyFillUtil;
import com.kingdee.eas.hr.ats.lightapp.util.HRTimeWebUtils;
import com.kingdee.eas.hr.ats.lightapp.util.HolidayPolicyParameterUtil;
import com.kingdee.eas.hr.ats.lightapp.util.SHRBillUtil;
import com.kingdee.eas.hr.ats.util.AtsDateUtils;
import com.kingdee.eas.hr.ats.util.common.MLUtile;
import com.kingdee.eas.hr.emp.PersonPositionInfo;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.util.UuidException;
import java.math.BigDecimal;
import java.sql.SQLException;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.lang.StringUtils;

public class AtsCancelLeaveBillUtils {
    public Map<String, Object> getCancelLeaveBillInfoByPersonIdAndCancelLeaveTime(Context ctx, String personId, String beginTime, String endTime, String realLeaLength, String billId, String leaveBillEntryId) throws SQLException {
        HashMap<String, Object> res = new HashMap<String, Object>();
        String split = " ";
        if (beginTime.length() != 19) {
            beginTime = beginTime + ":00";
        }
        String begintime = AtsDateUtils.getFullTime(AtsDateUtils.getTimeFromLongString(beginTime));
        String begin_Time = AtsDateUtils.getDateFromLongString(beginTime) + split + begintime;
        if (endTime.length() != 19) {
            endTime = endTime + ":00";
        }
        String endtime = AtsDateUtils.getFullTime(AtsDateUtils.getTimeFromLongString(endTime));
        String end_Time = AtsDateUtils.getDateFromLongString(endTime) + split + endtime;
        Date beginDate = new Date();
        Date endDate = new Date();
        BigDecimal leaveLength = new BigDecimal(0);
        try {
            AtsLeaveBillEntryInfo leaveBillEntryInfo = AtsLeaveBillEntryFactory.getLocalInstance(ctx).getAtsLeaveBillEntryInfo(" where id='" + leaveBillEntryId + "' ");
            leaveLength = leaveBillEntryInfo.getLeaveLength();
            beginDate = AtsDateUtils.timestampToDate(leaveBillEntryInfo.getBeginTime());
            endDate = AtsDateUtils.timestampToDate(leaveBillEntryInfo.getEndTime());
        }
        catch (EASBizException e) {
            e.printStackTrace();
        }
        catch (BOSException e) {
            e.printStackTrace();
        }
        int isOverRange = 0;
        Date beginDateFront = AtsDateUtils.stringToLongDate(begin_Time);
        Date endDateFront = AtsDateUtils.stringToLongDate(end_Time);
        if (beginDateFront.getTime() < beginDate.getTime()) {
            isOverRange = 1;
        } else if (beginDateFront.getTime() > endDate.getTime()) {
            isOverRange = 2;
        } else if (endDateFront.getTime() < beginDate.getTime()) {
            isOverRange = 3;
        } else if (endDateFront.getTime() > endDate.getTime()) {
            isOverRange = 4;
        }
        String sql = "";
        if (StringUtils.isBlank((String)billId)) {
            sql = " select bill.fid,bill.fapplydate,bill.fbillstate,bill.fproposer,bill.fnumber,entry.FRealLeaBeginTime,entry.FRealLeaEndTime,entry.fpersonid  from T_HR_ATS_CanLeaveBill  bill left join T_HR_ATS_CanLeaveBillEntry entry  on  bill.fid = entry.fbillid  where   entry.fpersonid='" + personId + "'  and   bill.fbillstate != 4  order by bill.fapplydate desc ";
        }
        if (StringUtils.isNotBlank((String)billId)) {
            sql = " select bill.fid,bill.fapplydate,bill.fbillstate,bill.fproposer,bill.fnumber,entry.FRealLeaBeginTime,entry.FRealLeaEndTime,entry.fpersonid  from T_HR_ATS_CanLeaveBill  bill left join T_HR_ATS_CanLeaveBillEntry entry  on  bill.fid = entry.fbillid  where   entry.fpersonid='" + personId + "'  and   bill.fid !='" + billId + "'  and   bill.fbillstate != 4  order by bill.fapplydate desc ";
        }
        IRowSet row = null;
        try {
            row = DbUtil.executeQuery((Context)ctx, (String)sql);
        }
        catch (BOSException e) {
            e.printStackTrace();
        }
        CancelLeaveBillCollection cancelLeaveBillCollection = new CancelLeaveBillCollection();
        while (row.next()) {
            CancelLeaveBillInfo canInfo = new CancelLeaveBillInfo();
            canInfo.setId(BOSUuid.read((String)row.getString("FID")));
            PersonInfo pInfo = new PersonInfo();
            pInfo.setId(BOSUuid.read((String)row.getString("FPROPOSER")));
            canInfo.setProposer(pInfo);
            canInfo.setApplyDate(row.getDate("FAPPLYDATE"));
            canInfo.setNumber(row.getString("FNumber"));
            CancelLeaveBillEntryInfo entryInfo = new CancelLeaveBillEntryInfo();
            entryInfo.setRealLeaBeginTime(row.getTimestamp("FRealLeaBeginTime"));
            entryInfo.setRealLeaEndTime(row.getTimestamp("FRealLeaEndTime"));
            PersonInfo info = new PersonInfo();
            info.setId(BOSUuid.read((String)row.getString("FPersonID")));
            entryInfo.setPerson(info);
            canInfo.getEntries().add(entryInfo);
            cancelLeaveBillCollection.add(canInfo);
        }
        int sum = 0;
        String billNo = "";
        String personName = "";
        String realBeginDate = "";
        String realEndDate = "";
        if (cancelLeaveBillCollection.size() == 0) {
            // empty if block
        }
        if (cancelLeaveBillCollection.size() > 0) {
            String resValue = "0";
            int size = cancelLeaveBillCollection.size();
            for (int i = 0; i < size; ++i) {
                Date beginDate_DB = new Date();
                if (cancelLeaveBillCollection.get(i).getEntries().get(0).getRealLeaBeginTime() != null) {
                    beginDate_DB = HRTimeWebUtils.timestampToDate(cancelLeaveBillCollection.get(i).getEntries().get(0).getRealLeaBeginTime());
                }
                Date endDate_DB = new Date();
                if (cancelLeaveBillCollection.get(i).getEntries().get(0).getRealLeaEndTime() != null) {
                    endDate_DB = HRTimeWebUtils.timestampToDate(cancelLeaveBillCollection.get(i).getEntries().get(0).getRealLeaEndTime());
                }
                if (Long.parseLong(resValue = HRTimeWebUtils.getTimeCoincidence(HRTimeWebUtils.stringToLongDate(begin_Time), HRTimeWebUtils.stringToLongDate(end_Time), beginDate_DB, endDate_DB)) > 0L) {
                    ++sum;
                    billNo = cancelLeaveBillCollection.get(i).getNumber();
                    String personid = personId;
                    PersonPositionInfo positionInfo = SHRBillUtil.getAdminOrgUnit(personid, ctx);
                    personName = positionInfo.getPerson().getName();
                    realBeginDate = HRTimeWebUtils.dateLongToString(beginDate_DB);
                    realEndDate = HRTimeWebUtils.dateLongToString(endDate_DB);
                } else {
                    sum = Long.parseLong(resValue) == 0L ? (sum += 0) : -1;
                }
                if (sum > 0) break;
            }
        }
        Boolean exist = false;
        res.put("leaveBillExist", exist);
        res.put("addFlag", sum);
        res.put("billNo", billNo);
        res.put("personName", personName);
        res.put("realBeginDate", realBeginDate);
        res.put("realEndDate", realEndDate);
        res.put("isOverRange", isOverRange);
        res.put("collSize", cancelLeaveBillCollection.size());
        return res;
    }

    public Map<String, Object> validateIsCancelLeaveAction(String billId, Context ctx) throws EASBizException, BOSException {
        HashMap<String, Object> res = new HashMap<String, Object>();
        String errorString = "";
        AtsLeaveBillInfo leaveBillInfo = AtsLeaveBillFactory.getLocalInstance(ctx).getAtsLeaveBillInfo(" where id = '" + billId + "' ");
        String policyId = leaveBillInfo.getEntries().get(0).getPolicy().getId().toString();
        HolidayPolicyInfo policyInfo = HolidayPolicyFactory.getLocalInstance(ctx).getHolidayPolicyInfo(" where id = '" + policyId + "' ");
        String personId = leaveBillInfo.getEntries().get(0).getPerson().getId().toString();
        Calendar cal = Calendar.getInstance();
        Date applyDate = new Date();
        if (leaveBillInfo.getId() != null && AtsWebUtils.isInWorkFlow(ctx, leaveBillInfo.getId().toString())) {
            AtsLeaveBillInfo leaveBillInfoDB = leaveBillInfo;
            if (leaveBillInfo.getApplyDate() == null) {
                leaveBillInfoDB = AtsLeaveBillFactory.getLocalInstance(ctx).getAtsLeaveBillInfo((IObjectPK)new ObjectUuidPK(leaveBillInfo.getId().toString()));
            }
            applyDate = leaveBillInfoDB.getApplyDate();
            cal.setTime(leaveBillInfoDB.getApplyDate());
        }
        cal.setTime(HRTimeWebUtils.formatCalendar(cal));
        String holidayTypeId = policyInfo.getHolidayType().getId().toString();
        if (!HolidayPolicyParameterUtil.getIsCancelLeave(ctx, personId, holidayTypeId).booleanValue()) {
            errorString = MLUtile.getRes(AtsLeaveBillResEnum.TypeUnsupportCancelLeave, ctx) + "!";
        } else {
            Boolean isFillCanLeaveByTimeCtl = HolidayPolicyParameterUtil.getCanLeaveFillHolidayByTimeCtl(ctx, personId, holidayTypeId);
            Boolean isFillCanLeaveByCycleCtl = HolidayPolicyParameterUtil.getCanLeaveFillHolidayByCycleCtl(ctx, personId, holidayTypeId);
            if (isFillCanLeaveByTimeCtl.booleanValue()) {
                errorString = this.isOverTimeCancelLeaveLimitByTimeCtl(ctx, leaveBillInfo, holidayTypeId, personId, cal);
            }
            if (isFillCanLeaveByCycleCtl.booleanValue()) {
                errorString = this.isOverTimeCancelLeaveLimitByCycleCtl(ctx, leaveBillInfo, holidayTypeId, personId, applyDate);
            }
        }
        res.put("errorString", errorString);
        return res;
    }

    public String isOverTimeCancelLeaveLimitByCycleCtl(Context ctx, AtsLeaveBillInfo leaveBillInfo, String holidayTypeId, String personId, Date applyDate) throws EASBizException, BOSException {
        String errorString = "";
        FillHolidayCycleTypeEnum unit = HolidayPolicyParameterUtil.getCancelLeaveAmountUnitByCycleCtl(ctx, personId, holidayTypeId);
        int amount = HolidayPolicyParameterUtil.getCancelLeaveAmountByCycleCtl(ctx, personId, holidayTypeId);
        long endTimeLong = leaveBillInfo.getEntries().get(0).getEndTime().getTime();
        Calendar cal = Calendar.getInstance();
        if (unit == FillHolidayCycleTypeEnum.naturalMonth) {
            int dayOfMonth = cal.get(5);
            if (dayOfMonth <= amount) {
                cal.set(2, cal.get(2) - 1);
                Date preMonthFirstDay = HRTimeWebUtils.stringToShortDate(cal.get(1) + "-" + (cal.get(2) + 1) + "-01");
                if (endTimeLong < preMonthFirstDay.getTime()) {
                    errorString = MLUtile.getRes(AtsLeaveBillResEnum.OverTimeCancelLeaveLimit, ctx);
                }
            } else {
                Calendar curCal = Calendar.getInstance();
                Date curMonthFirstDay = HRTimeWebUtils.stringToShortDate(curCal.get(1) + "-" + (curCal.get(2) + 1) + "-01");
                if (endTimeLong < curMonthFirstDay.getTime()) {
                    errorString = MLUtile.getRes(AtsLeaveBillResEnum.OverTimeCancelLeaveLimit, ctx);
                }
            }
        } else if (unit == FillHolidayCycleTypeEnum.attendanceCycle && errorString.length() <= 0) {
            String attendanceCycleId = "";
            AttencePolicyInfo attencePolicyInfo = AttencePolicyFillHelper.getAttencePolicyInfo(ctx, personId, null);
            if (attencePolicyInfo == null) {
                errorString = MLUtile.getRes(AtsAttenceResEnum.LeakPolicyInfoToCompleteCheck, ctx);
                return errorString;
            }
            if (attencePolicyInfo != null && attencePolicyInfo.getAttenceCycle() != null) {
                attendanceCycleId = attencePolicyInfo.getAttenceCycle().getId().toString();
                FillAmountUnitEnum fillMonthAndDayCel = HolidayPolicyParameterUtil.getCancelLeaveByCycleCtlAndFillMonthAndDay(ctx, personId, holidayTypeId);
                if (fillMonthAndDayCel != FillAmountUnitEnum.mouthEndDay) {
                    AttendancePeriodInfo curPeriod;
                    AttendancePeriodCollection attendancePeriodCollection = null;
                    try {
                        attendancePeriodCollection = AttendancePeriodFactory.getLocalInstance(ctx).getAttendancePeriodCollection(" where group.id = '" + attendanceCycleId + "' order by endDate DESC");
                    }
                    catch (BOSException e) {
                        e.printStackTrace();
                    }
                    if (attendancePeriodCollection == null || attendancePeriodCollection.size() == 0) {
                        errorString = MLUtile.getRes(AtsAttenceCycleResEnum.LeakToCompleteAudit, ctx) + "!";
                        return errorString;
                    }
                    AbstractAttendancePeriodInfo prePeriod = null;
                    int preIndex = 0;
                    for (int j = 0; j < attendancePeriodCollection.size(); ++j) {
                        AttendancePeriodInfo attendancePeriodInfo = attendancePeriodCollection.get(j);
                        if (attendancePeriodInfo.getEndDate().getTime() > cal.getTime().getTime()) continue;
                        prePeriod = attendancePeriodInfo;
                        preIndex = j;
                        break;
                    }
                    AttendancePeriodInfo attendancePeriodInfo = curPeriod = preIndex - 1 >= 0 ? attendancePeriodCollection.get(preIndex - 1) : null;
                    if (prePeriod != null) {
                        Date currDate;
                        Date curPeriodStartDate;
                        Date startDate = prePeriod.getStartDate();
                        Date endDate = prePeriod.getEndDate();
                        Date addAfterDate = AtsDateUtils.dateAdd(endDate, 3, amount, false);
                        Date date = curPeriodStartDate = curPeriod != null ? curPeriod.getStartDate() : null;
                        if (curPeriod != null && addAfterDate.getTime() > curPeriod.getEndDate().getTime()) {
                            addAfterDate = curPeriod.getEndDate();
                        }
                        if ((currDate = HRTimeWebUtils.stringToShortDate(cal.get(1) + "-" + (cal.get(2) + 1) + "-" + cal.get(5))).getTime() > addAfterDate.getTime()) {
                            if (curPeriodStartDate != null && endTimeLong < curPeriodStartDate.getTime()) {
                                errorString = MLUtile.getRes(AtsLeaveBillResEnum.OverTimeCancelLeaveLimit, ctx);
                            }
                        } else if (endTimeLong < startDate.getTime()) {
                            errorString = MLUtile.getRes(AtsLeaveBillResEnum.OverTimeCancelLeaveLimit, ctx);
                        }
                    }
                } else if (!AttencePolicyFillUtil.validMonthlyStatementDateByAttencecycle(ctx, attendanceCycleId, amount, AtsDateUtils.dateShortToString(new Date(endTimeLong)), applyDate).booleanValue()) {
                    errorString = MLUtile.getRes(AtsLeaveBillResEnum.OverTimeFillLeaveLimit, ctx);
                }
            } else {
                int dayOfMonth = cal.get(5);
                if (dayOfMonth <= amount) {
                    cal.set(2, cal.get(2) - 1);
                    Date preMonthFirstDay = HRTimeWebUtils.stringToShortDate(cal.get(1) + "-" + (cal.get(2) + 1) + "-01");
                    if (endTimeLong < preMonthFirstDay.getTime()) {
                        errorString = MLUtile.getRes(AtsLeaveBillResEnum.OverTimeCancelLeaveLimit, ctx);
                    }
                } else {
                    Date curMonthFirstDay = HRTimeWebUtils.stringToShortDate(cal.get(1) + "-" + (cal.get(2) + 1) + "-01");
                    if (endTimeLong < curMonthFirstDay.getTime()) {
                        errorString = MLUtile.getRes(AtsLeaveBillResEnum.OverTimeCancelLeaveLimit, ctx);
                    }
                }
            }
        }
        return errorString;
    }

    public String isOverTimeCancelLeaveLimitByTimeCtl(Context ctx, AtsLeaveBillInfo leaveBillInfo, String holidayTypeId, String personId, Calendar cal) throws EASBizException, BOSException {
        String errorString = "";
        BigDecimal amount = HolidayPolicyParameterUtil.getCancelLeaveAmount(ctx, personId, holidayTypeId);
        CancelLeaveAmountUnitEnum unit = HolidayPolicyParameterUtil.getCancelLeaveAmountUnit(ctx, personId, holidayTypeId);
        long endTimeLong = leaveBillInfo.getEntries().get(0).getEndTime().getTime();
        if (amount != null && unit != null) {
            if (unit == CancelLeaveAmountUnitEnum.year) {
                cal.set(1, cal.get(1) - amount.intValue());
                if (endTimeLong < cal.getTime().getTime()) {
                    errorString = MLUtile.getRes(AtsLeaveBillResEnum.OverTimeCancelLeaveLimit, ctx);
                }
            } else if (unit == CancelLeaveAmountUnitEnum.month) {
                cal.set(2, cal.get(2) - amount.intValue());
                if (endTimeLong < cal.getTime().getTime()) {
                    errorString = MLUtile.getRes(AtsLeaveBillResEnum.OverTimeCancelLeaveLimit, ctx);
                }
            } else if (unit == CancelLeaveAmountUnitEnum.day) {
                cal.set(5, cal.get(5) - amount.intValue());
                if (endTimeLong < cal.getTime().getTime()) {
                    errorString = MLUtile.getRes(AtsLeaveBillResEnum.OverTimeCancelLeaveLimit, ctx);
                }
            }
        }
        return errorString;
    }

    public Map<String, Object> getSetIsCtrlHalfDayOffAction(String personId, Context ctx) throws BOSException, UuidException, SQLException, EASBizException {
        String errorMsg = "";
        HashMap<String, Object> res = new HashMap<String, Object>();
        AtsHolidayFileCollection atsHolidayFileColl = AtsHolidayFileFactory.getLocalInstance(ctx).getAtsHolidayFileCollection(" where proposer.id='" + personId + "' and attendFileState='1' ");
        if (atsHolidayFileColl.size() == 0) {
            errorMsg = MLUtile.getRes(AtsFileResEnum.NotExistHFile, ctx);
            res.put("errorMsg", errorMsg);
        } else if (atsHolidayFileColl.size() > 0 && atsHolidayFileColl.get(0).getHolidayPolicySet() == null) {
            errorMsg = MLUtile.getRes(AtsHolidayResEnum.PersonWithoutBuildHolidayPolicy, ctx);
            res.put("errorMsg", errorMsg);
        }
        if (errorMsg.length() <= 0) {
            HolidayPolicySetInfo holidayPolicySetInfo = HolidayPolicySetFactory.getLocalInstance(ctx).getHolidayPolicySetInfo(" where id='" + atsHolidayFileColl.get(0).getHolidayPolicySet().getId().toString() + "' ");
            res.put("isHalfDayOff", holidayPolicySetInfo.isIsHalfDayOff());
            res.put("amBeginTime", holidayPolicySetInfo.getAmStartWorkTime());
            res.put("amEndTime", holidayPolicySetInfo.getAmEndWorkTime());
            res.put("pmBeginTime", holidayPolicySetInfo.getPmStartWorkTime());
            res.put("pmEndTime", holidayPolicySetInfo.getPmEndWorkTime());
            if (holidayPolicySetInfo.isIsEditHolidayLength()) {
                res.put("editable", "true");
            } else {
                res.put("editable", "false");
            }
        }
        res.put("errorMsg", errorMsg);
        return res;
    }

    public static String validateIsHolidayLimit(Context ctx, CancelLeaveBillEntryInfo cancelLeaveBillEntryInfo, String personId, AtsLeaveBillEntryCollection leaveBillEntrycoll, String holidayTypeId) throws EASBizException, BOSException {
        String errorString = "";
        AtsLeaveBillEntryInfo leaveBillEntryInfo = leaveBillEntrycoll.get(0);
        String leaveBeginTime = HRTimeWebUtils.dateShortToString(leaveBillEntryInfo.getBeginTime());
        String leaveEndTime = HRTimeWebUtils.dateShortToString(leaveBillEntryInfo.getEndTime());
        BigDecimal realLeaLength = cancelLeaveBillEntryInfo.getRealLeaLength();
        Map<String, Object> map = CelLeaveBillEditHolidayTypeUtil.getHolidayPolicyInfo(ctx, personId, holidayTypeId, leaveBeginTime, leaveEndTime);
        errorString = (String)map.get("errorString");
        if (errorString != null && !errorString.isEmpty()) {
            return errorString;
        }
        HolidayPolicyInfo holidayPolicyInfo = (HolidayPolicyInfo)map.get("holidayPolicyInfo");
        boolean isCtrlLimit = holidayPolicyInfo.isIsCtrlLimit();
        if (isCtrlLimit && null != holidayPolicyInfo) {
            String billinfoid = leaveBillEntryInfo.getBill().getId().toString();
            AtsLeaveBillInfo billInfo = AtsLeaveBillFactory.getLocalInstance(ctx).getAtsLeaveBillInfo((IObjectPK)new ObjectUuidPK(billinfoid));
            String hrOrgUnitId = billInfo.getHrOrgUnit().getId().toString();
            HolidayLimitCollection holidayLimitCollection = HolidayLimitFactory.getLocalInstance(ctx).getHolidayLimitCollection(" where proposer='" + personId + "' and   holidayPolicy.holidayType='" + holidayTypeId + "'  and hrOrgUnit.id='" + hrOrgUnitId + "'   and cycleBeginDate <= {ts '" + leaveEndTime + "'} and delayDate >= {ts '" + leaveBeginTime + "'}");
            if (null == holidayLimitCollection || holidayLimitCollection.size() == 0) {
                errorString = MLUtile.getRes(AtsHolidayResEnum.NotExistsLimitRecord, ctx);
            } else {
                BigDecimal remainLimit = new BigDecimal(0);
                for (int i = 0; i < holidayLimitCollection.size(); ++i) {
                    remainLimit = remainLimit.add(holidayLimitCollection.get(i).getRemainLimit());
                }
                Boolean isOver = holidayPolicyInfo.isIsOver();
                realLeaLength = cancelLeaveBillEntryInfo.getRealLeaLength();
                if (remainLimit.compareTo(realLeaLength) == -1 && !isOver.booleanValue()) {
                    errorString = MLUtile.getRes(AtsHolidayResEnum.SaveFailForLeakRemainLimit, ctx);
                }
            }
        }
        return errorString;
    }
}

