/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.hr.ats.lightapp.util;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.hr.ats.AtsCommonResEnum;
import com.kingdee.eas.hr.ats.AtsLeaveBillEntryInfo;
import com.kingdee.eas.hr.ats.AtsLeaveBillInfo;
import com.kingdee.eas.hr.ats.AtsLeaveBillResEnum;
import com.kingdee.eas.hr.ats.ResourceEnum;
import com.kingdee.eas.hr.ats.lightapp.util.LanguageUtil;
import com.kingdee.eas.hr.ats.lightapp.util.TimeUtil;
import com.kingdee.eas.hr.ats.util.common.MLUtile;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.util.HashMap;
import java.util.Map;

public class AtsLeaveBillLimitMobile {
    public static Map<String, Object> validateLeaveBillDuplicate4Mobile(Context ctx, AtsLeaveBillInfo billInfo) throws BOSException, SQLException, EASBizException {
        HashMap<String, Object> ret = new HashMap<String, Object>();
        boolean isDuplicate = false;
        String msg = "";
        AtsLeaveBillEntryInfo entryInfo = billInfo.getEntries().get(0);
        String personId = billInfo.getProposer().getId().toString();
        Timestamp beginTime = entryInfo.getRealBeginTime();
        Timestamp endTime = entryInfo.getRealEndTime();
        String billId = billInfo.getId() == null ? "" : billInfo.getId().toString();
        String beginTimeStr = TimeUtil.dateLongToString(beginTime);
        String endTimeStr = TimeUtil.dateLongToString(endTime);
        String name = "fname_" + LanguageUtil.getType(ctx);
        String sql = "select bill.fid,bill.fapplydate,bill.fbillstate,bill.fproposer,bill.fnumber,type." + name + " typename,entry.fbegintime,entry.fendtime,entry.frealbegintime,entry.frealendtime,entry.fpersonid  from t_hr_ats_leavebill  bill left join t_hr_ats_leavebillentry entry  on  bill.fid = entry.fbillid  left join T_HR_ATS_HolidayPolicy policy on entry.FPolicyID=policy.fid  left join T_HR_ATS_HolidayType  type on policy.FHolidayTypeID=type.fid  where  entry.FPERSONID=?  and  entry.FRealBeginTime<=? and entry.FRealEndTime>=?   and  bill.fbillstate != 4  order by bill.fapplydate desc ";
        Object[] params = new Object[]{personId, TimeUtil.stringToTimestamp(endTimeStr), TimeUtil.stringToTimestamp(beginTimeStr)};
        StringBuilder infoSB = new StringBuilder();
        IRowSet row = DbUtil.executeQuery((Context)ctx, (String)sql, (Object[])params);
        while (row.next()) {
            String id = row.getString("fid");
            if (id == null || id.equals(billId)) continue;
            String applyDateStr = TimeUtil.dateShortToString(row.getDate("fapplydate"));
            String beginDateStr = TimeUtil.getDtAPMStr(ctx, row.getDate("frealbegintime"));
            String endDateStr = TimeUtil.getDtAPMStr(ctx, row.getDate("frealendtime"));
            String typeStr = row.getString("typename");
            infoSB.append(MLUtile.getRes((ResourceEnum)AtsLeaveBillResEnum.AppliedAlready, ctx, applyDateStr, beginDateStr, endDateStr, typeStr)).append(";");
            isDuplicate = true;
        }
        if (infoSB.length() > 0) {
            infoSB.append(MLUtile.getRes(AtsCommonResEnum.ForbidRepeatApply, ctx)).append("\uff01");
        }
        msg = infoSB.toString();
        ret.put("isDuplicate", isDuplicate);
        ret.put("msg", msg);
        return ret;
    }
}

