/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.hr.ats.sum.util;

import com.google.gson.Gson;
import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.query.server.PagingHelper;
import com.kingdee.bos.db.TempTablePool;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.SorterItemInfo;
import com.kingdee.eas.base.permission.PermItemURLInfo;
import com.kingdee.eas.basedata.org.AdminOrgUnitCollection;
import com.kingdee.eas.basedata.org.AdminOrgUnitFactory;
import com.kingdee.eas.basedata.org.AdminOrgUnitInfo;
import com.kingdee.eas.basedata.org.HROrgUnitCollection;
import com.kingdee.eas.basedata.org.HROrgUnitFactory;
import com.kingdee.eas.basedata.org.HROrgUnitInfo;
import com.kingdee.eas.basedata.person.PersonCollection;
import com.kingdee.eas.basedata.person.PersonFactory;
import com.kingdee.eas.basedata.person.PersonInfo;
import com.kingdee.eas.hr.ats.AtsAttenceCycleResEnum;
import com.kingdee.eas.hr.ats.AtsAttenceResEnum;
import com.kingdee.eas.hr.ats.AtsBillResEnum;
import com.kingdee.eas.hr.ats.AtsCalResEnum;
import com.kingdee.eas.hr.ats.AtsCommonResEnum;
import com.kingdee.eas.hr.ats.AtsDateCommonResEnum;
import com.kingdee.eas.hr.ats.AtsFileResEnum;
import com.kingdee.eas.hr.ats.AtsHolidayFileHisCollection;
import com.kingdee.eas.hr.ats.AtsHolidayFileHisFactory;
import com.kingdee.eas.hr.ats.AtsHolidayFileInfo;
import com.kingdee.eas.hr.ats.AtsOrgAuthResEnum;
import com.kingdee.eas.hr.ats.AtsUtil;
import com.kingdee.eas.hr.ats.AttenceProjectShowSequenceCollection;
import com.kingdee.eas.hr.ats.AttenceProjectShowSequenceFactory;
import com.kingdee.eas.hr.ats.AttenceProjectShowSequenceInfo;
import com.kingdee.eas.hr.ats.AttendanceFileHISCollection;
import com.kingdee.eas.hr.ats.AttendanceFileHISFactory;
import com.kingdee.eas.hr.ats.AttendanceFileInfo;
import com.kingdee.eas.hr.ats.AttendanceProjectCollection;
import com.kingdee.eas.hr.ats.AttendanceProjectFactory;
import com.kingdee.eas.hr.ats.AttendanceProjectInfo;
import com.kingdee.eas.hr.ats.ResourceEnum;
import com.kingdee.eas.hr.ats.app.formula.calculate.data.DAFactory;
import com.kingdee.eas.hr.ats.app.formula.calculate.data.DataAccess;
import com.kingdee.eas.hr.ats.app.formula.calculate.data.DataRow;
import com.kingdee.eas.hr.ats.app.formula.calculate.data.DataTable;
import com.kingdee.eas.hr.ats.app.formula.calculate.data.Tools;
import com.kingdee.eas.hr.ats.common.AtsTempTableUtil;
import com.kingdee.eas.hr.ats.decimalPlace.util.DecimalPlaceUtil;
import com.kingdee.eas.hr.ats.lightapp.util.BillBizUtil;
import com.kingdee.eas.hr.ats.sum.constants.AtsSumCallConstants;
import com.kingdee.eas.hr.ats.util.AtsBaseUtils;
import com.kingdee.eas.hr.ats.util.AtsDateUtils;
import com.kingdee.eas.hr.ats.util.AtsServerCalUtils;
import com.kingdee.eas.hr.ats.util.common.MLUtile;
import com.kingdee.eas.rpts.ctrlreport.osf.OSFExecutor;
import com.kingdee.eas.util.app.ContextUtil;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.shr.base.syssetting.api.bean.BatchMessageTipsBody;
import com.kingdee.shr.base.syssetting.api.bean.BatchMessageTipsHeader;
import com.kingdee.util.StringUtils;
import com.kingdee.util.UuidException;
import com.kingdee.util.db.SQLUtils;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.sql.Connection;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.Statement;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.servlet.http.HttpSession;
import org.apache.log4j.Logger;
import org.apache.poi.ss.usermodel.BorderStyle;
import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.ss.usermodel.CellStyle;
import org.apache.poi.ss.usermodel.FillPatternType;
import org.apache.poi.ss.usermodel.Font;
import org.apache.poi.ss.usermodel.HorizontalAlignment;
import org.apache.poi.ss.usermodel.IndexedColors;
import org.apache.poi.ss.usermodel.Row;
import org.apache.poi.ss.usermodel.Sheet;
import org.apache.poi.ss.usermodel.VerticalAlignment;
import org.apache.poi.ss.usermodel.Workbook;
import org.apache.poi.ss.util.CellRangeAddress;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public class AtsResultToSumHelper {
    private static Logger logger = Logger.getLogger(AtsResultToSumHelper.class);
    private static String[] sqlCheck = new String[]{"update", "delete", "insert", "alter", "drop", "truncate", "create"};

    public static String setAttencePanelTempTableSql(Context ctx, int totalCount, Map<String, String> filterItems, String field) throws Exception {
        int dbType = AtsBaseUtils.getDbType(ctx);
        String tempTableName = filterItems.get("tempTableName");
        if (StringUtils.isEmpty((String)tempTableName)) {
            return null;
        }
        int rows = Integer.parseInt(filterItems.get("rows"));
        int page = Integer.parseInt(filterItems.get("page"));
        int length = rows;
        if (page * rows > totalCount) {
            length = totalCount - (page - 1) * rows;
        }
        int start = (page - 1) * rows;
        int top = start + length;
        String sqlt = AtsResultToSumHelper.getAttencePanelQuerySql(top, field, tempTableName, filterItems);
        PagingHelper pageHelper = new PagingHelper();
        try {
            sqlt = pageHelper.getPagingSqlNoOptmize(dbType, sqlt, start, length);
        }
        catch (Exception e) {
            logger.error((Object)"RESULTTOSUM call setAttencePanelTempTableSql() error");
            e.printStackTrace();
            sqlt = pageHelper.getPagingSqlNoOptmize(dbType, sqlt, start, length);
        }
        return sqlt;
    }

    public static Map<String, Object> getAttencePanelGridData(Context ctx, Map<String, String> filterItems, String sqlt, int totalCount, List<LinkedHashMap<String, Object>> rowList) {
        int rows = Integer.parseInt(filterItems.get("rows"));
        int page = Integer.parseInt(filterItems.get("page"));
        String tempTableName = null;
        LinkedHashMap<String, Object> gridDataMap = new LinkedHashMap<String, Object>();
        try {
            IRowSet rowset = DbUtil.executeQuery((Context)ctx, (String)sqlt);
            StringBuffer hrOrgUnit = new StringBuffer();
            StringBuffer person = new StringBuffer();
            StringBuffer OrgUnit = new StringBuffer();
            ArrayList<Object[]> params = new ArrayList<Object[]>();
            while (rowset.next()) {
                LinkedHashMap<String, String> hm = new LinkedHashMap<String, String>();
                String hrorgunitid = rowset.getString("fhrorgunitid");
                String personId = rowset.getString("fproposerid");
                String adminOrgId = rowset.getString("fadminorgunitid");
                hrOrgUnit.append("'" + hrorgunitid + "',");
                person.append("'" + personId + "',");
                OrgUnit.append("'" + adminOrgId + "',");
                hm.put("hrOrgUnitId", hrorgunitid);
                hm.put("personId", personId);
                hm.put("adminOrgUnitId", adminOrgId);
                hm.put("key", hrorgunitid + personId + adminOrgId);
                rowList.add(hm);
                Object[] param = new Object[]{hrorgunitid, personId, adminOrgId};
                params.add(param);
            }
            AtsResultToSumHelper.getRowListPersonOrAdminOrg(ctx, hrOrgUnit, person, OrgUnit, rowList);
            if (totalCount % rows == 0) {
                gridDataMap.put("total", totalCount / rows);
            } else {
                gridDataMap.put("total", totalCount / rows + 1);
            }
            gridDataMap.put("page", page);
            gridDataMap.put("records", totalCount);
            gridDataMap.put("rows", rowList);
            if (null != rowList && rowList.size() > 0) {
                String tmpIndexSql;
                tempTableName = TempTablePool.getInstance((Context)ctx).createTempTable(" CREATE TABLE T_HR_ATS_RESULT_TEMPTABLE (fhrorgunitid VARCHAR(255),fproposerid VARCHAR(255),fadminorgunitid VARCHAR(255))");
                String tempSql = "insert into " + tempTableName + " values(?,?,?)";
                DbUtil.executeBatch((Context)ctx, (String)tempSql.toString(), params);
                gridDataMap.put("KEY_TEMPTABLENAME", tempTableName);
                String dbType = ContextUtil.getDbType((Context)ctx);
                if (!StringUtils.isEmpty((String)dbType) && (dbType.equalsIgnoreCase("Oracle") || dbType.startsWith("Oracle"))) {
                    tmpIndexSql = "CREATE  INDEX " + tempTableName + " ON " + tempTableName + " (fhrorgunitid,fproposerid,fadminorgunitid ASC) ;";
                    DbUtil.execute((Context)ctx, (String)tmpIndexSql.toString());
                } else {
                    tmpIndexSql = "CREATE  INDEX IX" + tempTableName + " ON " + tempTableName + " (fhrorgunitid,fproposerid,fadminorgunitid ASC) ;";
                    DbUtil.execute((Context)ctx, (String)tmpIndexSql.toString());
                }
            }
        }
        catch (Exception e) {
            try {
                TempTablePool.getInstance((Context)ctx).releaseTable(tempTableName);
            }
            catch (Exception e1) {
                e1.printStackTrace();
            }
            e.printStackTrace();
        }
        return gridDataMap;
    }

    public static String getAttencePanelQuerySql(int top, String field, String tempTableName, Map<String, String> filterItems) {
        StringBuffer sqlt = new StringBuffer();
        sqlt.append("SELECT TOP " + top + " " + field + "  from " + tempTableName + " temp \n");
        sqlt.append(AtsResultToSumHelper.getResultToSumOrderBySql(filterItems));
        return sqlt.toString();
    }

    public static String getResultToSumOrderBySql(Map<String, String> filterItems) {
        if (filterItems.get("sumType").equals("4")) {
            return " order by FProposerID,fhrorgunitid,fattadminorgunitid ";
        }
        if (!StringUtils.isEmpty((String)filterItems.get("sidx"))) {
            return " order by " + filterItems.get("sidx") + " " + filterItems.get("sord") + ",fhrorgunitid,fproposerid,fadminorgunitid ";
        }
        return " order by personNumber asc,fhrorgunitid,fadminorgunitid ";
    }

    public static List<Map<String, String>> getAttendanceProjectList(Context ctx, int type) {
        ArrayList<Map<String, String>> attendProjectList = new ArrayList<Map<String, String>>();
        AttendanceProjectCollection projectCol = null;
        StringBuffer oql = new StringBuffer();
        if (type == 2) {
            oql.append(" where enable=1 and itemType!=0 and isDisplay!=4 and projectCategory.id!=null order by columnNO");
        } else {
            oql.append(" where enable=1 and itemType!=1 and isDisplay!=4 and projectCategory.id!=null order by columnNO");
        }
        try {
            projectCol = AttendanceProjectFactory.getLocalInstance(ctx).getAttendanceProjectCollection(oql.toString());
        }
        catch (BOSException e) {
            e.printStackTrace();
        }
        if (null != projectCol) {
            for (int i = 0; i < projectCol.size(); ++i) {
                AttendanceProjectInfo projectInfo = projectCol.get(i);
                String colNo = "S" + projectInfo.getColumnNO();
                HashMap<String, String> attendProjcetMap = new HashMap<String, String>();
                attendProjcetMap.put("attendNo", colNo + "");
                attendProjcetMap.put("attendName", projectInfo.getName());
                attendProjcetMap.put("dataType", projectInfo.getDataType().getName());
                attendProjectList.add(attendProjcetMap);
            }
        }
        return attendProjectList;
    }

    public Map<String, Object> resultToSum(Context ctx, Map<String, String> filterItems, int totalCount) throws SQLException {
        return null;
    }

    public static BatchMessageTipsHeader getBatchMessageTips(Context ctx, String action, Map<String, Object> nameMap) {
        BatchMessageTipsHeader batchMessageTipsHeader = new BatchMessageTipsHeader();
        String message = action.equals("SUM_SALARY") ? MLUtile.getRes(AtsBillResEnum.TransferSalaryAfterSum, ctx) : MLUtile.getRes(AtsBillResEnum.Total, ctx);
        Map successMap = (Map)nameMap.get("SUCCESS_MAP");
        Map lockMap = (Map)nameMap.get("LOCK_MAP");
        Map auditedMap = (Map)nameMap.get("AUDITED_MAP");
        Map hasSalaryMap = (Map)nameMap.get("HASSALARY_MAP");
        int lockNameSize = 0;
        if (null != lockMap && (lockNameSize = lockMap.size()) > 0) {
            AtsResultToSumHelper.setBatchMessageTipsHeader(ctx, batchMessageTipsHeader, lockMap, null, Boolean.FALSE);
        }
        int auditedSize = 0;
        if (null != auditedMap && (auditedSize = auditedMap.size()) > 0) {
            AtsResultToSumHelper.setBatchMessageTipsHeader(ctx, batchMessageTipsHeader, auditedMap, MLUtile.getRes((ResourceEnum)AtsCalResEnum.HasAuditFail, ctx, message), Boolean.FALSE);
        }
        int hasSalarySize = 0;
        if (null != hasSalaryMap && (hasSalarySize = hasSalaryMap.size()) > 0) {
            AtsResultToSumHelper.setBatchMessageTipsHeader(ctx, batchMessageTipsHeader, hasSalaryMap, MLUtile.getRes((ResourceEnum)AtsAttenceResEnum.HasSalaryFail, ctx, message), Boolean.FALSE);
        }
        int successSize = 0;
        if (null != successMap) {
            successSize = successMap.size();
        }
        batchMessageTipsHeader.setFailureCount(lockNameSize + auditedSize + hasSalarySize);
        batchMessageTipsHeader.setSuccessCount(successSize);
        return batchMessageTipsHeader;
    }

    public static void setBatchMessageTipsHeader(Context ctx, BatchMessageTipsHeader batchMessageTipsHeader, Map<String, Object> map, String message, boolean tipsState) {
        BatchMessageTipsBody body = null;
        Set<Map.Entry<String, Object>> entrySet = map.entrySet();
        Iterator<Map.Entry<String, Object>> iter = entrySet.iterator();
        while (iter.hasNext()) {
            body = new BatchMessageTipsBody();
            Map.Entry<String, Object> entry = iter.next();
            body.setId(entry.getKey());
            body.setMuitTipsState(tipsState);
            body.setMuitTipsMessage(null == message ? (String)entry.getValue() : MLUtile.getRes((ResourceEnum)AtsFileResEnum.Person, ctx, "\u3010" + (String)entry.getValue() + "\u3011") + message);
            batchMessageTipsHeader.addResult(body);
        }
    }

    public static Map<String, String> getColumnMap(String selector) {
        LinkedHashMap<String, String> returnMap = new LinkedHashMap<String, String>();
        Gson gson = new Gson();
        List list = (List)gson.fromJson(selector, ArrayList.class);
        for (Map item : list) {
            String key1 = null;
            String value1 = null;
            String key1_places = null;
            String value1_places = null;
            String itemType = null;
            boolean isNeedSum = true;
            for (Map.Entry entry : item.entrySet()) {
                String key = (String)entry.getKey();
                String val = entry.getValue().toString();
                if ("dataColumnType".equals(key) && val.equalsIgnoreCase("Date")) {
                    isNeedSum = false;
                    break;
                }
                if ("key".equals(key)) {
                    key1 = val;
                    key1_places = val + "_DECIMALPLACES";
                }
                if ("dataColumnType".equals(key)) {
                    value1 = val;
                }
                if ("formatoptions".equals(key) && !StringUtils.isEmpty((String)val)) {
                    value1_places = val.substring(val.indexOf("decimalPlaces") + 14, val.indexOf("}")).trim();
                }
                if (!"itemType".equals(key)) continue;
                itemType = val;
            }
            if (!isNeedSum || key1 == null || !StringUtils.isEmpty(itemType) && (StringUtils.isEmpty(itemType) || !"2".equals(itemType))) continue;
            returnMap.put(key1, value1);
            if (key1_places == null || value1_places == null) continue;
            returnMap.put(key1_places, value1_places);
        }
        return returnMap;
    }

    public static String getSelector(Context ctx, String param) {
        StringBuilder atsSelector = new StringBuilder();
        try {
            EntityViewInfo evi = new EntityViewInfo();
            evi.getSorter().add(new SorterItemInfo("sortNo"));
            AttendanceProjectCollection atsItemColl = AttendanceProjectFactory.getLocalInstance(ctx).getAttendanceProjectCollection(evi);
            Iterator itr = atsItemColl.iterator();
            while (itr.hasNext()) {
                int isDisplay;
                AttendanceProjectInfo atsItem = (AttendanceProjectInfo)itr.next();
                boolean flag = false;
                boolean isHideForTemplate = false;
                int ItemType2 = atsItem.getItemType().getValue();
                int n = isDisplay = null == atsItem.getIsDisplay() ? 0 : atsItem.getIsDisplay().getValue();
                if ("summaryTitleView".equals(param)) {
                    flag = ItemType2 != 0 && atsItem.getEnable().getValue() == 1 && atsItem.getState().getValue() == 1;
                    boolean bl = isHideForTemplate = isDisplay != 2 && isDisplay != 3;
                }
                if (!flag) continue;
                atsSelector.append(",{");
                atsSelector.append("\"key\":\"");
                atsSelector.append("S" + atsItem.getColumnNO() + "\",");
                atsSelector.append("\"name\":\"");
                atsSelector.append(atsItem.getName() + "\",");
                atsSelector.append("\"itemType\":\"");
                atsSelector.append(atsItem.getItemType().getValue() + "\",");
                atsSelector.append("\"dataColumnType\":\"");
                atsSelector.append(atsItem.getDataType().getName() + "\",");
                if (atsItem.getDataType().getValue() == 2) {
                    atsSelector.append("\"formatter\":\"");
                    atsSelector.append("number\",");
                    atsSelector.append("\"formatoptions\":{\"defaulValue\":\"\",\"decimalPlaces\":" + atsItem.getDecimalDigit() + "},");
                }
                atsSelector.append("\"isHideForTemplate\":\"");
                atsSelector.append(isHideForTemplate + "\"");
                atsSelector.append("}");
            }
            StringBuilder preAtsSelector = new StringBuilder();
            if ("summaryTitleView".equals(param)) {
                preAtsSelector.append("{\"key\":\"FID\",\"name\":\"" + AtsSumCallConstants.resultFIDCN.getMessage() + "\",\"" + "dataColumnType" + "\":\"String\",\"" + "isHideForTemplate" + "\":\"false\"},");
                preAtsSelector.append("{\"key\":\"FproposerID\",\"name\":\"").append(MLUtile.getRes(AtsFileResEnum.PersonIsId, ctx)).append("\",\"dataColumnType\":\"String\",\"isHideForTemplate\":\"false\"} ,");
                preAtsSelector.append("{\"key\":\"FhrOrgUnitId\",\"name\":\"").append(MLUtile.getRes(AtsOrgAuthResEnum.HrAdminOrg, ctx)).append("\",\"dataColumnType\":\"String\",\"isHideForTemplate\":\"true\"} ,");
                preAtsSelector.append("{\"key\":\"FSalaryStatus\",\"name\":\"").append(MLUtile.getRes(AtsCommonResEnum.Status, ctx)).append("\",\"dataColumnType\":\"String\",\"isHideForTemplate\":\"true\"},");
                preAtsSelector.append("{\"key\":\"FadminOrgUnitId\",\"name\":\"").append(MLUtile.getRes(AtsFileResEnum.Department, ctx)).append("\",\"dataColumnType\":\"String\",\"isHideForTemplate\":\"false\"},");
            }
            preAtsSelector.append("{\"key\":\"personName\",\"name\":\"" + AtsSumCallConstants.personNameCN.getMessage() + "\",\"" + "dataColumnType" + "\":\"String\",\"" + "isHideForTemplate" + "\":\"false\"}");
            preAtsSelector.append(",{\"key\":\"personNumber\",\"name\":\"" + AtsSumCallConstants.personNumberCN.getMessage() + "\",\"" + "dataColumnType" + "\":\"String\",\"" + "isHideForTemplate" + "\":\"false\"}");
            preAtsSelector.append(",{\"key\":\"hrOrgName\",\"name\":\"" + AtsSumCallConstants.hrOrgNameCN.getMessage() + "\",\"" + "dataColumnType" + "\":\"String\",\"" + "isHideForTemplate" + "\":\"false\"}");
            preAtsSelector.append(",{\"key\":\"orgName\",\"name\":\"" + AtsSumCallConstants.orgNameCN.getMessage() + "\",\"" + "dataColumnType" + "\":\"String\",\"" + "isHideForTemplate" + "\":\"false\"}");
            preAtsSelector.append(",{\"key\":\"PositionName\",\"name\":\"" + AtsSumCallConstants.PositionNameCN.getMessage() + "\",\"" + "dataColumnType" + "\":\"String\",\"" + "isHideForTemplate" + "\":\"false\"}");
            preAtsSelector.append(",{\"key\":\"FSalaryPeriod\",\"name\":\"").append(MLUtile.getRes(AtsAttenceCycleResEnum.SalaryPeriod, ctx)).append("\",\"dataColumnType\":\"String\",\"isHideForTemplate\":\"false\"}");
            if ("detailTemplate".equals(param)) {
                preAtsSelector.append(",{\"key\":\"orgNumber\",\"name\":\"" + AtsSumCallConstants.orgNumberCN.getMessage() + "\",\"" + "dataColumnType" + "\":\"String\",\"" + "isHideForTemplate" + "\":\"false\"}");
                preAtsSelector.append(",{\"key\":\"PositionNumber\",\"name\":\"" + AtsSumCallConstants.PositionNumberCN.getMessage() + "\",\"" + "dataColumnType" + "\":\"String\",\"" + "isHideForTemplate" + "\":\"false\"}");
            }
            atsSelector.insert(0, preAtsSelector.toString());
            atsSelector.insert(0, "[");
            atsSelector.append("]");
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return atsSelector.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static List<String> getCellNameByTableName(Context ctx, String tableName, Map<String, String> map) {
        ArrayList<String> list = new ArrayList<String>();
        Statement sta = null;
        Connection con = null;
        try {
            String sql = "select TOP 1 * from " + tableName;
            IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)sql);
            ResultSetMetaData rsmd = rs.getMetaData();
            int count = rsmd.getColumnCount();
            HashSet<String> cellNameSet = new HashSet<String>();
            for (int i = 1; i <= count; ++i) {
                cellNameSet.add(rsmd.getColumnName(i).toLowerCase());
            }
            Set<String> columnSet = map.keySet();
            for (String column : columnSet) {
                if (!cellNameSet.contains(column.toLowerCase())) continue;
                list.add(column);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            SQLUtils.cleanup(sta);
            SQLUtils.cleanup(con);
        }
        return list;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static List<String> getCellNameByTableName(Context ctx, String tableName) {
        ArrayList<String> list = new ArrayList<String>();
        Statement sta = null;
        Connection con = null;
        try {
            String sql = "select TOP 1 * from " + tableName;
            IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)sql);
            ResultSetMetaData rsmd = rs.getMetaData();
            int count = rsmd.getColumnCount();
            HashSet<String> cellNameSet = new HashSet<String>();
            for (int i = 1; i <= count; ++i) {
                cellNameSet.add(rsmd.getColumnName(i).toUpperCase());
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            SQLUtils.cleanup(sta);
            SQLUtils.cleanup(con);
        }
        return list;
    }

    public static List<LinkedHashMap<String, Object>> getAllRecordUnLockPersonList(Context ctx, Map<String, Object> sumParams, IRowSet sumKeyRows) {
        String tempTableName = (String)sumParams.get("tempTableName");
        Map filterItems = (Map)sumParams.get("sumParams");
        ArrayList<LinkedHashMap<String, Object>> dataList = new ArrayList<LinkedHashMap<String, Object>>();
        HashMap<String, Object> lockMessageMap = new HashMap<String, Object>();
        try {
            HashSet<String> hr_person_OrgList = new HashSet<String>();
            HashSet<String> personIds = new HashSet<String>();
            while (sumKeyRows.next()) {
                String hrOrgUnitId = sumKeyRows.getString("fhrOrgUnitId");
                String personId = sumKeyRows.getString("fproposerid");
                String adminOrgUnit = null;
                try {
                    adminOrgUnit = sumKeyRows.getString("fadminorgunitid");
                }
                catch (Exception exception) {
                    // empty catch block
                }
                personIds.add(personId);
                String attadminOrgUnit = null;
                try {
                    attadminOrgUnit = sumKeyRows.getString("fattadminorgunitid");
                }
                catch (Exception exception) {
                    // empty catch block
                }
                if (null == adminOrgUnit) {
                    adminOrgUnit = attadminOrgUnit;
                }
                hr_person_OrgList.add(hrOrgUnitId + "_####_" + personId + "_####_" + adminOrgUnit + "_####_" + attadminOrgUnit);
            }
            HashMap<String, Object> lockMessage = new HashMap<String, Object>();
            List<String> personList = AtsResultToSumHelper.getSalaryLockStatePersonCol(ctx, filterItems, personIds, lockMessage, tempTableName);
            dataList = AtsResultToSumHelper.setPingPersonArrayList(ctx, personList, hr_person_OrgList, lockMessageMap, lockMessage, (String)filterItems.get("sumType"));
            sumParams.put("LOCK_MAP", lockMessageMap);
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
        return dataList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static ArrayList<LinkedHashMap<String, Object>> getSelectRecordUnLockPersonList(Context ctx, Map<String, Object> sumParams) {
        Map filterItems = (Map)sumParams.get("sumParams");
        ArrayList<LinkedHashMap<String, Object>> dataList = new ArrayList();
        HashMap<String, Object> lockMessageMap = new HashMap<String, Object>();
        HashSet<String> personIds = new HashSet<String>();
        HashSet<String> hr_person_OrgList = new HashSet<String>();
        ArrayList<Object[]> perAndOrgs = new ArrayList<Object[]>();
        try {
            JSONArray myJsonArray = new JSONArray((String)filterItems.get("personJson"));
            for (int i = 0; i < myJsonArray.length(); ++i) {
                JSONObject myjObject = myJsonArray.getJSONObject(i);
                String hrOrgUnitId = myjObject.getString("hrOrgUnitId");
                String personId = myjObject.getString("personId");
                String adminOrgUnit = myjObject.getString("adminOrgUnit");
                personIds.add(personId);
                String attadminOrgUnit = null;
                try {
                    attadminOrgUnit = myjObject.getString("fattadminorgunitid");
                }
                catch (Exception exception) {
                    // empty catch block
                }
                hr_person_OrgList.add(hrOrgUnitId + "_####_" + personId + "_####_" + adminOrgUnit + "_####_" + attadminOrgUnit);
                Object[] param = new Object[]{hrOrgUnitId, personId, adminOrgUnit};
                perAndOrgs.add(param);
            }
        }
        catch (JSONException e) {
            e.printStackTrace();
        }
        String tempTableName = null;
        try {
            tempTableName = AtsResultToSumHelper.createResultToSumTmpTable(ctx, perAndOrgs);
            HashMap<String, Object> lockMessage = new HashMap<String, Object>();
            List<String> personList = AtsResultToSumHelper.getSalaryLockStatePersonCol(ctx, filterItems, personIds, lockMessage, tempTableName);
            dataList = AtsResultToSumHelper.setPingPersonArrayList(ctx, personList, hr_person_OrgList, lockMessageMap, lockMessage, (String)filterItems.get("sumType"));
        }
        finally {
            TempTablePool.getInstance((Context)ctx).releaseTable(tempTableName);
        }
        sumParams.put("LOCK_MAP", lockMessageMap);
        return dataList;
    }

    public static String createResultToSumKeyTmpTable(Context ctx, List<LinkedHashMap<String, Object>> rowList) {
        List<Object[]> perAndOrgs = AtsResultToSumHelper.getCurrentAllKeyList(rowList);
        if (null != perAndOrgs && perAndOrgs.size() > 0) {
            return AtsResultToSumHelper.createResultToSumTmpTable(ctx, perAndOrgs);
        }
        return null;
    }

    public static List<Object[]> getCurrentAllKeyList(List<LinkedHashMap<String, Object>> rowList) {
        ArrayList<Object[]> perAndOrgs = new ArrayList<Object[]>();
        for (LinkedHashMap<String, Object> mapList : rowList) {
            Object[] param = new Object[]{(String)mapList.get("hrOrgUnitId"), (String)mapList.get("personId"), (String)mapList.get("adminOrgUnitId")};
            perAndOrgs.add(param);
        }
        return perAndOrgs;
    }

    public static String createResultToSumTmpTable(Context ctx, List<Object[]> perAndOrgs) {
        String tempTableName = null;
        try {
            tempTableName = TempTablePool.getInstance((Context)ctx).createTempTable(" CREATE TABLE T_HR_ATS_RESULTSUM_TEMP (fhrorgunitid VARCHAR(255),fproposerid VARCHAR(255),fadminorgunitid VARCHAR(255))");
            String tempSql = "insert into " + tempTableName + " values(?,?,?)";
            DbUtil.executeBatch((Context)ctx, (String)tempSql.toString(), perAndOrgs);
            String dbType = ContextUtil.getDbType((Context)ctx);
            if (!StringUtils.isEmpty((String)dbType) && (dbType.equalsIgnoreCase("Oracle") || dbType.startsWith("Oracle"))) {
                String tmpIndexSql = "CREATE  INDEX " + tempTableName + " ON " + tempTableName + " (fhrorgunitid,fproposerid,fadminorgunitid ASC) ;";
                DbUtil.execute((Context)ctx, (String)tmpIndexSql.toString());
            } else {
                String tmpIndexSql = "CREATE  INDEX IX" + tempTableName + " ON " + tempTableName + " (fhrorgunitid,fproposerid,fadminorgunitid ASC) ;";
                DbUtil.execute((Context)ctx, (String)tmpIndexSql.toString());
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return tempTableName;
    }

    public static Map<String, Object> getExistedSumRecordInfo(Context ctx, Map<String, Object> params, List<LinkedHashMap<String, Object>> rowList, String keyTmpTableName) {
        Map filterItems = (Map)params.get("sumParams");
        ArrayList temExistList = new ArrayList();
        HashMap<String, Object> existAttendRecord = new HashMap<String, Object>();
        try {
            String sql = AtsResultToSumHelper.getDynaAttendSumExistsSql((String)filterItems.get("beginDate"), (String)filterItems.get("endDate"), keyTmpTableName, filterItems, ctx);
            IRowSet rowSet = DbUtil.executeQuery((Context)ctx, (String)sql);
            while (rowSet.next()) {
                LinkedHashMap<String, String> map = new LinkedHashMap<String, String>();
                String hrOrgUnitId = rowSet.getString("fhrorgunitid");
                String personId = rowSet.getString("FPROPOSERID");
                String adminOrgUnitId = rowSet.getString("FAdminORGUNITID");
                String positionId = rowSet.getString("fpositionID");
                String periodId = rowSet.getString("FSalaryPeriod");
                String salaryStatus = rowSet.getString("FSalaryStatus");
                String fid = rowSet.getString("fid");
                if (periodId != null) {
                    map.put("salaryPeriodId", periodId);
                }
                String key = hrOrgUnitId + personId + adminOrgUnitId;
                map.put("hrOrgUnitId", hrOrgUnitId);
                map.put("personId", personId);
                map.put("adminOrgUnitId", adminOrgUnitId);
                map.put("fid", fid);
                map.put("fpositionID", positionId);
                map.put("salaryStatus", salaryStatus);
                map.put("key", key);
                existAttendRecord.put(key, salaryStatus);
                temExistList.add(map);
            }
            int size = rowList.size();
            int tempSize = temExistList.size();
            if (tempSize > 0) {
                block3: for (int i = 0; tempSize > i; ++i) {
                    LinkedHashMap tempexsitMap = (LinkedHashMap)temExistList.get(i);
                    String tempkey = (String)tempexsitMap.get("key");
                    for (int j = 0; size > j; ++j) {
                        Map exsitMap = rowList.get(j);
                        String key = (String)exsitMap.get("key");
                        if (!key.equals(tempkey)) continue;
                        tempexsitMap.put("orgName", exsitMap.get("orgName"));
                        tempexsitMap.put("hrOrgName", exsitMap.get("hrOrgName"));
                        tempexsitMap.put("personNumber", exsitMap.get("personNumber"));
                        tempexsitMap.put("personName", exsitMap.get("personName"));
                        rowList.set(j, tempexsitMap);
                        continue block3;
                    }
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return existAttendRecord;
    }

    public static void setGridAttendResultSumInfo(Context ctx, String keyTmpTableName, Map<String, Object> params, List<LinkedHashMap<String, Object>> rowList, Map<String, String> columnMap) {
        try {
            Map filterItems = (Map)params.get("sumParams");
            String beginDate = (String)filterItems.get("beginDate");
            String endDate = (String)filterItems.get("endDate");
            String attendPeriodId = (String)filterItems.get("attendPeriodId");
            String attendPeriodName = (String)filterItems.get("attendPeriodName");
            int sumSize = rowList.size();
            int decimalPlacesSystem = DecimalPlaceUtil.getDecimalPlaceSystem(ctx);
            IRowSet rowSet = AtsResultToSumHelper.getAttendDetailDataGrid(ctx, keyTmpTableName, beginDate, endDate, filterItems);
            for (int i = 0; i < sumSize; ++i) {
                Map rowListMap = rowList.get(i);
                String sumKey = (String)rowListMap.get("key");
                rowListMap.put("beginDate", beginDate);
                rowListMap.put("endDate", endDate);
                rowListMap.put("attendPeriodId", attendPeriodId);
                rowListMap.put("attendPeriodName", attendPeriodName);
                java.sql.Date maxDate = null;
                while (rowSet.next()) {
                    String positionId = rowSet.getString("fpositionID");
                    String currentKey = rowSet.getString("fatthrorgunitid") + rowSet.getString("fproposerid") + rowSet.getString("fadminorgunitid");
                    String resultId = rowSet.getString("FID");
                    java.sql.Date fattencedate = rowSet.getDate("fattencedate");
                    if (maxDate == null) {
                        maxDate = fattencedate;
                    }
                    try {
                        if (!currentKey.equals(sumKey)) continue;
                        if (rowListMap.get("fpositionID") == null) {
                            rowListMap.put("fpositionID", positionId);
                        } else if (fattencedate.compareTo(maxDate) > 0) {
                            rowListMap.put("fpositionID", positionId);
                            maxDate = fattencedate;
                        }
                        rowListMap.put("resultId", resultId);
                        AtsResultToSumHelper.setAttendResultSumData(ctx, rowSet, rowListMap, columnMap, decimalPlacesSystem);
                    }
                    catch (Exception e) {
                        logger.error((Object)("PAGE: RESULTTOSUM call setGridAttendResultSumInfo error,gather/gather to salary prepare detail data error,sumKey:" + sumKey));
                        e.printStackTrace();
                    }
                }
                rowSet.beforeFirst();
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static IRowSet getAttendDetailDataGrid(Context ctx, String keyTmpTableName, String beginDate, String endDate, Map<String, String> filterItems) {
        IRowSet rowSet = null;
        StringBuffer sb = new StringBuffer();
        sb.append(" select RESULT.* from T_HR_ATS_AttendanceResult RESULT   ");
        sb.append("  WHERE EXISTS (SELECT 1 FROM  " + keyTmpTableName + " ATS_TMP ");
        sb.append("  WHERE ATS_TMP.FHRORGUNITID = RESULT.FATTHRORGUNITID ");
        sb.append("  AND ATS_TMP.FPROPOSERID = RESULT.FPROPOSERID ");
        sb.append("  AND ATS_TMP.FADMINORGUNITID = RESULT.FADMINORGUNITID )");
        sb.append("  and RESULT.FATTENCEDATE >= {ts '" + beginDate + "' }");
        sb.append("  and RESULT.FATTENCEDATE <=  {ts '" + endDate + "' }");
        try {
            rowSet = DbUtil.executeQuery((Context)ctx, (String)sb.toString());
        }
        catch (Exception e) {
            logger.error((Object)("PAGE: RESULTTOSUM call getAttendDetailDataGrid error:" + sb.toString()));
            e.printStackTrace();
        }
        return rowSet;
    }

    public static void setAttendResultSumData(Context ctx, IRowSet rowSet, Map<String, Object> rowListMap, Map<String, String> columnMap, int decimalPlacesSystem) throws SQLException {
        for (String key : columnMap.keySet()) {
            String val = columnMap.get(key);
            if (val.equals("Int")) {
                int value = 0;
                if (rowListMap.get(key) != null) {
                    value = (Integer)rowListMap.get(key);
                }
                int tempVal = rowSet.getInt(key);
                rowListMap.put(key, value + tempVal);
                continue;
            }
            if (!val.equals("Float")) continue;
            float valueF = 0.0f;
            if (rowListMap.get(key) != null) {
                valueF = ((Float)rowListMap.get(key)).floatValue();
            }
            float tempValF = rowSet.getFloat(key);
            float valueRound = BigDecimal.valueOf(valueF + tempValF).setScale(decimalPlacesSystem, RoundingMode.HALF_UP).floatValue();
            rowListMap.put(key, Float.valueOf(valueRound));
        }
    }

    public static ArrayList<LinkedHashMap<String, Object>> setPingPersonArrayList(Context ctx, List<String> personList, Set<String> personAndOrgAdminList, Map<String, Object> lockMessageMap, Map<String, Object> lockMessage, String sumType) {
        StringBuffer person = new StringBuffer();
        StringBuffer OrgUnit = new StringBuffer();
        StringBuffer hrOrgUnit = new StringBuffer();
        ArrayList<LinkedHashMap<String, Object>> dataList = new ArrayList<LinkedHashMap<String, Object>>();
        Iterator<String> iter = personAndOrgAdminList.iterator();
        while (iter.hasNext()) {
            LinkedHashMap<String, String> hm = new LinkedHashMap<String, String>();
            String key = iter.next();
            String[] hr_per_admin = key.split("_####_");
            String hrOrgUnitId = hr_per_admin[0];
            String personId = hr_per_admin[1];
            String adminOrgUnitId = hr_per_admin[2];
            String attadminOrgUnitId = "";
            if (hr_per_admin.length == 4) {
                attadminOrgUnitId = hr_per_admin[3];
            }
            if (personList.contains(personId)) {
                hrOrgUnit.append("'" + hrOrgUnitId + "',");
                person.append("'" + personId + "',");
                OrgUnit.append("'" + adminOrgUnitId + "',");
                hm.put("hrOrgUnitId", hrOrgUnitId);
                hm.put("personId", personId);
                hm.put("adminOrgUnitId", adminOrgUnitId);
                hm.put("attadminOrgUnitId", attadminOrgUnitId);
                if (sumType.equals("4")) {
                    hm.put("key", hrOrgUnitId + personId + attadminOrgUnitId);
                } else {
                    hm.put("key", hrOrgUnitId + personId + adminOrgUnitId);
                }
                dataList.add(hm);
                continue;
            }
            if (null == lockMessage.get(personId)) continue;
            lockMessageMap.put(key, lockMessage.get(personId));
        }
        AtsResultToSumHelper.getRowListPersonOrAdminOrg(ctx, hrOrgUnit, person, OrgUnit, dataList);
        return dataList;
    }

    public static Map<String, Object> getPersonNameList(Context ctx, String personIdStrs) {
        HashMap<String, Object> personMap = new HashMap<String, Object>();
        StringBuffer oqlb = new StringBuffer();
        oqlb.append("select ");
        oqlb.append("id,");
        oqlb.append("number,");
        oqlb.append("name");
        oqlb.append(" where id in(" + personIdStrs + ")");
        PersonCollection col = null;
        try {
            col = PersonFactory.getLocalInstance((Context)ctx).getPersonCollection(oqlb.toString());
        }
        catch (BOSException e) {
            e.printStackTrace();
        }
        if (col == null || col.size() == 0) {
            return personMap;
        }
        for (int i = 0; i < col.size(); ++i) {
            PersonInfo personInfo = col.get(i);
            personMap.put(personInfo.getId().toString(), personInfo.getName());
        }
        return personMap;
    }

    public static Map<String, AttendanceFileInfo> getAttendanceFileInfoByPersonId(Context ctx, String personIds, Map<String, String> filterItems) {
        HashMap<String, AttendanceFileInfo> fileInfoMap = new HashMap<String, AttendanceFileInfo>();
        String beginDate = filterItems.get("beginDate");
        String endDate = filterItems.get("endDate");
        List<String> dateList = AtsDateUtils.getDateList(beginDate, endDate);
        try {
            String oql = " where proposer in(" + personIds + ")";
            oql = oql + " and  Effdt <= {ts '" + endDate + "'} and Leffdt >= {ts '" + beginDate + "'}   ";
            AttendanceFileHISCollection fileColl = AttendanceFileHISFactory.getLocalInstance(ctx).getAttendanceFileHISCollection(oql);
            String personId = null;
            AttendanceFileInfo fileInfo = null;
            String key = "";
            int size = fileColl.size();
            for (int i = 0; i < size; ++i) {
                fileInfo = BillBizUtil.convertHis2File(ctx, fileColl.get(i));
                personId = fileInfo.getProposer().getId().toString();
                for (String currentDate : dateList) {
                    Date date = AtsDateUtils.stringToShortDate(currentDate);
                    if (fileInfo.getEFFDT().getTime() > date.getTime() || fileInfo.getLEFFDT().getTime() < date.getTime()) continue;
                    key = personId + "_" + currentDate;
                    fileInfoMap.put(key, fileInfo);
                }
            }
        }
        catch (BOSException e) {
            e.printStackTrace();
        }
        return fileInfoMap;
    }

    public static Map<String, AtsHolidayFileInfo> getHolidayFileInfoByPersonId(Context ctx, String personIds, Map<String, String> filterItems) {
        HashMap<String, AtsHolidayFileInfo> fileInfoMap = new HashMap<String, AtsHolidayFileInfo>();
        String beginDate = filterItems.get("beginDate");
        String endDate = filterItems.get("endDate");
        List<String> dateList = AtsDateUtils.getDateList(beginDate, endDate);
        try {
            String oql = " where proposer in(" + personIds + ") ";
            oql = oql + " and  Effdt <= {ts '" + endDate + "'} and Leffdt >= {ts '" + beginDate + "'} ";
            AtsHolidayFileHisCollection fileColl = AtsHolidayFileHisFactory.getLocalInstance(ctx).getAtsHolidayFileHisCollection(oql);
            String personId = null;
            AtsHolidayFileInfo fileInfo = null;
            String key = "";
            int size = fileColl.size();
            for (int i = 0; i < size; ++i) {
                fileInfo = BillBizUtil.convertHis2File(ctx, fileColl.get(i));
                personId = fileInfo.getProposer().getId().toString();
                for (String currentDate : dateList) {
                    Date date = AtsDateUtils.stringToShortDate(currentDate);
                    if (fileInfo.getEFFDT() == null || fileInfo.getLEFFDT() == null || fileInfo.getEFFDT().getTime() > date.getTime() || fileInfo.getLEFFDT().getTime() < date.getTime()) continue;
                    key = personId + "_" + currentDate;
                    fileInfoMap.put(key, fileInfo);
                }
            }
        }
        catch (BOSException e) {
            e.printStackTrace();
        }
        return fileInfoMap;
    }

    public static Map<String, Object> getDynamicAttendanceResultSum(Context ctx, String selSql) throws BOSException, UuidException, SQLException {
        Tools.getInstance().setCtx(ctx);
        HashMap<String, Object> map = new HashMap<String, Object>();
        HashMap resMap = new HashMap();
        DataAccess DAC = DAFactory.getDataAccess();
        DataTable dt = DAC.getDataTable(selSql, "T_HR_ATS_AttendanceResultSum");
        ArrayList columns = dt.columns;
        DataRow rw = null;
        for (int index = 0; index < dt.rowCount(); ++index) {
            rw = dt.getRows(index);
            String personId = (String)rw.getValue("FProposerID");
            String key = personId;
            if (resMap.get(key) != null) {
                ((List)resMap.get(key)).add(rw);
                continue;
            }
            ArrayList<DataRow> rws = new ArrayList<DataRow>();
            rws.add(rw);
            resMap.put(key, rws);
        }
        map.put("columns", columns);
        map.put("datas", resMap);
        return map;
    }

    public static List<Map<String, Object>> getInitShowAttendanceTitle(Context ctx, int type) {
        PersonInfo personInfo = ContextUtil.getCurrentUserInfo((Context)ctx).getPerson();
        ArrayList<Map<String, Object>> attenceProjectShowSequenceInfoList = new ArrayList<Map<String, Object>>();
        if (personInfo != null) {
            StringBuffer oqlb = new StringBuffer();
            oqlb.append("select ");
            oqlb.append("id,");
            oqlb.append("attendanceProject.id,");
            oqlb.append("attendanceProject.name,");
            oqlb.append("attendanceProject.number,");
            oqlb.append("attendanceProject.columnNO,");
            oqlb.append("attendanceProject.dataType,");
            oqlb.append("Sequence");
            oqlb.append(" where proposer.id='");
            oqlb.append(personInfo.getId().toString());
            oqlb.append("'");
            oqlb.append(" and type=" + type + "");
            oqlb.append(" and attendanceProject.enable=1");
            String fiterSql = type == 1 ? " and attendanceProject.isDisplay in(1,3) " : " and attendanceProject.isDisplay in(2,3)";
            oqlb.append(fiterSql);
            if (type == 2) {
                oqlb.append(" and attendanceProject.dataType in(1,2)");
            }
            oqlb.append(" order by Sequence");
            AttenceProjectShowSequenceCollection coll = null;
            try {
                coll = AttenceProjectShowSequenceFactory.getLocalInstance(ctx).getAttenceProjectShowSequenceCollection(oqlb.toString());
            }
            catch (BOSException e) {
                e.printStackTrace();
            }
            if (coll == null || coll.size() == 0) {
                return attenceProjectShowSequenceInfoList;
            }
            for (int i = 0; i < coll.size(); ++i) {
                AttenceProjectShowSequenceInfo attenceProjectShowSequence = coll.get(i);
                HashMap<String, Object> attenceProjectShowSequenceInfoMap = new HashMap<String, Object>();
                attenceProjectShowSequenceInfoMap.put("id", attenceProjectShowSequence.getId().toString());
                attenceProjectShowSequenceInfoMap.put("attendId", attenceProjectShowSequence.getAttendanceProject().getId().toString());
                attenceProjectShowSequenceInfoMap.put("name", attenceProjectShowSequence.getAttendanceProject().getName());
                attenceProjectShowSequenceInfoMap.put("attendNumber", attenceProjectShowSequence.getAttendanceProject().getNumber());
                attenceProjectShowSequenceInfoMap.put("columnNO", Integer.toString(attenceProjectShowSequence.getAttendanceProject().getColumnNO()));
                attenceProjectShowSequenceInfoMap.put("typeValue", Integer.toString(attenceProjectShowSequence.getAttendanceProject().getDataType().getValue()));
                attenceProjectShowSequenceInfoMap.put("typeName", attenceProjectShowSequence.getAttendanceProject().getDataType().getName());
                attenceProjectShowSequenceInfoMap.put("Sequence", attenceProjectShowSequence.getSequence());
                attenceProjectShowSequenceInfoList.add(attenceProjectShowSequenceInfoMap);
            }
        }
        return attenceProjectShowSequenceInfoList;
    }

    public static List<String> getSalaryLockStatePersonCol(Context ctx, Map<String, String> filterItems, Set<String> personList, Map<String, Object> lockMessageMap, String tempTableName) {
        ArrayList<String> unLockPersonIds = new ArrayList<String>();
        try {
            ArrayList<String> lockPersonIdList = new ArrayList<String>();
            if (filterItems.get("salaryStatus") != null && !StringUtils.isEmpty((String)filterItems.get("salaryStatus")) && "1".equals(filterItems.get("salaryStatus"))) {
                HashMap<String, String> paraMap = new HashMap<String, String>();
                String personSql = AtsResultToSumHelper.getPersonAdminSqlByRecordId(personList, tempTableName);
                String[] attr = filterItems.get("attendPeriodName").split("-");
                paraMap.put("year", attr[0]);
                paraMap.put("month", attr[1]);
                paraMap.put("times", attr[2]);
                paraMap.put("personSql", personSql);
                paraMap.put("mod", "ats");
                Map map = (Map)OSFExecutor.executeOSF((Context)ctx, paraMap, (String)"getCmpLockDataJudge");
                Map pcTypeMap = (Map)map.get("pcType");
                Map fidTypeMap = (Map)map.get("fidType");
                if (null != pcTypeMap && pcTypeMap.size() > 0) {
                    for (Map.Entry entry : pcTypeMap.entrySet()) {
                        String key = ((String)entry.getKey()).split("_")[0];
                        lockPersonIdList.add(key);
                        String val = entry.getValue().toString();
                        if (val.equals("0")) {
                            unLockPersonIds.add(key);
                            continue;
                        }
                        lockMessageMap.put(key, val);
                    }
                }
            }
            if (personList.size() > 0) {
                for (String personIdKey : personList) {
                    if (lockPersonIdList.contains(personIdKey)) continue;
                    unLockPersonIds.add(personIdKey);
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return unLockPersonIds;
    }

    public static String getPersonAdminSqlByRecordId(Set<String> personIds, String tempTableName) {
        StringBuffer sb = new StringBuffer("");
        sb.append("");
        sb.append("SELECT ");
        sb.append("\t'000' as fid,RESULT_TMP.FProposerID AS personId, ");
        sb.append("\tCASE ");
        sb.append("\t WHEN T_ORG_Admin.FCompanyID IS NULL THEN ");
        sb.append("  RESULT_TMP.FAdminOrgUnitID ");
        sb.append("  ELSE ");
        sb.append("  T_ORG_Admin.FCompanyID ");
        sb.append(" END AS companyId ");
        sb.append("FROM " + tempTableName + " RESULT_TMP ");
        sb.append("LEFT JOIN T_ORG_Admin ON RESULT_TMP.FAdminOrgUnitID = T_ORG_Admin.FID ");
        sb.append("WHERE ");
        sb.append("RESULT_TMP.FPROPOSERID IN (").append(AtsUtil.convertSetToString(personIds) + ")");
        return sb.toString();
    }

    public static List<HashMap<String, String>> getAttendancePeriodList(Context ctx, String attendacePolicyId) {
        StringBuffer sb = new StringBuffer();
        ArrayList<HashMap<String, String>> listMap = new ArrayList<HashMap<String, String>>();
        try {
            if (!StringUtils.isEmpty((String)attendacePolicyId)) {
                sb.append("SELECT PE.FID,PE.FSTARTDATE,PE.FENDDATE,PE.FNAME" + MLUtile.getMlFlag(ctx) + " name FROM T_HR_ATS_ATTENCEPOLICY PO ").append("INNER JOIN T_HR_ATS_ATTENDANCEPERIOD PE ON PO.FATTENCECYCLEID  = PE.FGROUPID ").append("WHERE PO.FID = ? ");
                IRowSet iRowSet = DbUtil.executeQuery((Context)ctx, (String)sb.toString(), (Object[])new Object[]{attendacePolicyId});
                if (iRowSet.size() > 0) {
                    while (iRowSet.next()) {
                        HashMap<String, String> map = new HashMap<String, String>();
                        map.put("beginDate", iRowSet.getString("FSTARTDATE"));
                        map.put("endDate", iRowSet.getString("FENDDATE"));
                        map.put("name", iRowSet.getString("name"));
                        map.put("id", iRowSet.getString("FID"));
                        listMap.add(map);
                    }
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return listMap;
    }

    public static Map<String, Object> setAttenceResultGridDataMapNew(Context ctx, Map<String, String> filterItems, List<LinkedHashMap<String, Object>> rowList, int totalCount, String tempTableName) throws Exception {
        long startTime = System.currentTimeMillis();
        String sqlt = AtsResultToSumHelper.setAttencePanelTempTableSql(ctx, totalCount, filterItems, " * ");
        Map<String, Object> resultMap = AtsResultToSumHelper.getAttencePanelGridData(ctx, filterItems, sqlt, totalCount, rowList);
        logger.error((Object)("RESULT TO SUM gen tmp table cost: " + (System.currentTimeMillis() - startTime)));
        return resultMap;
    }

    public static String createResultToSumTempTable(Context ctx, Map<String, String> filterItems, HttpSession session) throws Exception {
        String sql = AtsResultToSumHelper.getAttendResultSumSql(ctx, filterItems);
        String tempTableName = AtsResultToSumHelper.getAttenceResultTempTable(ctx, filterItems, sql);
        filterItems.put("tempTableName", tempTableName);
        filterItems.put("resultToSumSQL", sql);
        AtsResultToSumHelper.setTmpTableToSession(filterItems, session);
        logger.error((Object)("RESULT TO SUM GROUP SQL:getGridResultToSumDataSql resultToSum dynamicSql: " + sql.toString()));
        return tempTableName;
    }

    public static String getAttendResultSumSql(Context ctx, Map<String, String> filterItems) throws Exception {
        String personJson;
        StringBuffer sumSql = new StringBuffer();
        sumSql.append(" SELECT FHIS.FHrOrgUnitID,FHIS.FAdminOrgUnitID,FHIS.FProposerID,person.FNumber as personNumber , person.FName" + MLUtile.getMlFlag(ctx) + " as personName ");
        sumSql.append(" FROM T_HR_ATS_AttendanceFileHIS FHIS ");
        sumSql.append(" INNER JOIN T_BD_Person person on FHIS.FProposerID = person.FID ");
        sumSql.append(" WHERE FHIS.FLEFFDT >= {ts '" + filterItems.get("beginDate") + "'}");
        sumSql.append(" AND FHIS.FEFFDT <= {ts '" + filterItems.get("endDate") + "'} ");
        String attendGroupSql = AtsServerCalUtils.getAttenceGroupSql(filterItems);
        if (!StringUtils.isEmpty((String)attendGroupSql)) {
            sumSql.append(attendGroupSql);
        }
        if (!(StringUtils.isEmpty((String)(personJson = filterItems.get("personJson"))) || "\"\"".equals(personJson) || "All".equalsIgnoreCase(personJson))) {
            Set<String> personKeys = AtsResultToSumHelper.getSelectPersonKey(personJson);
            sumSql.append(" and concat(FHIS.fhrOrgUnitId,concat(FHIS.fproposerid,FHIS.fadminorgunitid)) in (" + AtsUtil.convertSetToString(personKeys) + ")");
        } else {
            sumSql.append(AtsResultToSumHelper.getAttendResultSumWhereSql(ctx, filterItems));
            String customFilter = filterItems.get("customFilter");
            if (!StringUtils.isEmpty((String)customFilter)) {
                sumSql.append(customFilter);
            }
        }
        sumSql.append(" GROUP BY FHIS.FHrOrgUnitID,FHIS.FAdminOrgUnitID,FHIS.FProposerID,person.FNumber,person.FName" + MLUtile.getMlFlag(ctx));
        return sumSql.toString();
    }

    public static String getAttenceResultTempTable(Context ctx, Map<String, String> filterItems, String sql) {
        String tempTableName = null;
        try {
            String table_key;
            String staticTable = "PA2AtdcResultToSumQuery";
            if (!StringUtils.isEmpty((String)filterItems.get("SUM_SALARY"))) {
                staticTable = filterItems.get("SUM_SALARY").equals("SUM_CALCULATE") ? "PA2AtdcSumCalculateQuery" : (filterItems.get("SUM_SALARY").equals("SUM_CALCULATE_DYNA") ? "PA2AtdcSumCalculateDynaQuery" : "PA2AtdcResultToSumSalaryQuery");
            } else if (!StringUtils.isEmpty((String)filterItems.get("isAll")) && filterItems.get("isAll").equals("all")) {
                staticTable = "PA2AtdcResultToSumExportTmp";
            }
            String sessionId = filterItems.get("session");
            if (StringUtils.isEmpty((String)sessionId)) {
                sessionId = "backGround";
            }
            if (ctx.get((Object)(table_key = staticTable + "_" + sessionId)) != null) {
                tempTableName = (String)ctx.get((Object)table_key);
            }
            if (filterItems.get("refresh") == null || "true".equals(filterItems.get("refresh"))) {
                if (tempTableName != null) {
                    TempTablePool.getInstance((Context)ctx).releaseTable(tempTableName);
                }
                tempTableName = TempTablePool.getInstance((Context)ctx).createTempTableName();
                String tempSql = "select * into " + tempTableName + " from (" + sql + ") T ";
                DbUtil.execute((Context)ctx, (String)tempSql.toString());
                AtsResultToSumHelper.createSumIndex(ctx, tempTableName);
                ctx.put((Object)table_key, (Object)tempTableName);
            }
        }
        catch (Exception e) {
            AtsTempTableUtil.releaseTable(ctx, tempTableName);
            e.printStackTrace();
        }
        return tempTableName;
    }

    public static int getQueryTotalCount(Context ctx, String tempTableName) {
        int totalCount = 0;
        try {
            IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)("select count(*) from " + tempTableName + " temp "));
            while (rs.next()) {
                totalCount = rs.getInt(1);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return totalCount;
    }

    public static String getAttendResultSumWhereSql(Context ctx, Map<String, String> filterItems) {
        String attenceStatus;
        StringBuffer WhereSql = new StringBuffer();
        String filterItem = filterItems.get("filterItems");
        if (!StringUtils.isEmpty((String)filterItem)) {
            if (filterItem.indexOf("name") != -1) {
                filterItem = filterItem.replaceAll("name", "fname" + MLUtile.getMlFlag(ctx));
            }
            if (filterItem.indexOf("number") != -1) {
                filterItem = filterItem.replaceAll("number", "fnumber");
            }
            WhereSql.append(" and " + filterItem);
        }
        if (!StringUtils.isEmpty((String)(attenceStatus = filterItems.get("attenceStatus")))) {
            if (attenceStatus.equals("0")) {
                WhereSql.append("  AND not exists ");
                WhereSql.append("  ( select 1 from T_HR_ATS_AttendanceResult result ");
                WhereSql.append("     where FHIS.fhrorgunitid = result.fatthrorgunitid");
                WhereSql.append("     and FHIS.fproposerid = result.fproposerid");
                WhereSql.append("     and FHIS.fadminorgunitid = result.fadminorgunitid ");
                WhereSql.append("     and result.FATTENCEDATE >= {ts '" + filterItems.get("beginDate") + "'} ");
                WhereSql.append("     and result.FATTENCEDATE <= {ts '" + filterItems.get("endDate") + "'} ");
                WhereSql.append("  ) ");
            } else if (attenceStatus.equals("1")) {
                WhereSql.append("  AND exists ");
                WhereSql.append("  ( select 1 from T_HR_ATS_AttendanceResult result ");
                WhereSql.append("     where FHIS.fhrorgunitid = result.fatthrorgunitid");
                WhereSql.append("     and FHIS.fproposerid = result.fproposerid");
                WhereSql.append("     and FHIS.fadminorgunitid = result.fadminorgunitid ");
                WhereSql.append("     and result.fattencestatus in ( 1,4) ");
                WhereSql.append("     and result.FATTENCEDATE >= {ts '" + filterItems.get("beginDate") + "'} ");
                WhereSql.append("     and result.FATTENCEDATE <= {ts '" + filterItems.get("endDate") + "'} ");
                WhereSql.append("  ) ");
            } else if (attenceStatus.equals("2")) {
                WhereSql.append("  AND not exists ");
                WhereSql.append("  ( select 1 from T_HR_ATS_AttendanceResult result ");
                WhereSql.append("     where FHIS.fhrorgunitid = result.fatthrorgunitid");
                WhereSql.append("     and FHIS.fproposerid = result.fproposerid");
                WhereSql.append("     and FHIS.fadminorgunitid = result.fadminorgunitid ");
                WhereSql.append("     and result.fattencestatus in (1,4) ");
                WhereSql.append("     and result.FATTENCEDATE >= {ts '" + filterItems.get("beginDate") + "'} ");
                WhereSql.append("     and result.FATTENCEDATE <= {ts '" + filterItems.get("endDate") + "'} ");
                WhereSql.append("  ) ");
                WhereSql.append("  AND exists ");
                WhereSql.append("  ( select 1 from T_HR_ATS_AttendanceResult result ");
                WhereSql.append("     where FHIS.fhrorgunitid = result.fatthrorgunitid");
                WhereSql.append("     and FHIS.fproposerid = result.fproposerid");
                WhereSql.append("     and FHIS.fadminorgunitid = result.fadminorgunitid ");
                WhereSql.append("     and result.FATTENCEDATE >= {ts '" + filterItems.get("beginDate") + "'} ");
                WhereSql.append("     and result.FATTENCEDATE <= {ts '" + filterItems.get("endDate") + "'} ");
                WhereSql.append("  ) ");
            } else if (attenceStatus.equals("10")) {
                WhereSql.append("  AND exists ");
                WhereSql.append("  ( select 1 from T_HR_ATS_AttendanceReSumMd atsum ");
                WhereSql.append("     inner join T_HR_ATS_AttendancePeriod attPeriod ");
                WhereSql.append("     on  atsum.FAttendancePeriodID = attPeriod.fid ");
                WhereSql.append("     where atsum.fhrorgunitid = FHIS.fhrorgunitid ");
                WhereSql.append("     and atsum.fproposerid = FHIS.fproposerid");
                WhereSql.append("     and atsum.fadminorgunitid = FHIS.fadminorgunitid ");
                WhereSql.append("     and {ts '" + filterItems.get("beginDate") + "'} = attPeriod.Fstartdate");
                WhereSql.append("     and {ts '" + filterItems.get("endDate") + "'} = attPeriod.fendDate ");
                WhereSql.append("  ) ");
            } else if (attenceStatus.equals("15")) {
                WhereSql.append("  AND not exists ");
                WhereSql.append("  ( select 1 from T_HR_ATS_AttendanceResultSum atsum ");
                WhereSql.append("     inner join T_HR_ATS_AttendancePeriod attPeriod ");
                WhereSql.append("     on  atsum.FAttendancePeriodID = attPeriod.fid ");
                WhereSql.append("     where atsum.fhrorgunitid = FHIS.fhrorgunitid ");
                WhereSql.append("     and atsum.fproposerid = FHIS.fproposerid");
                WhereSql.append("     and atsum.fadminorgunitid = FHIS.fadminorgunitid ");
                WhereSql.append("     and {ts '" + filterItems.get("beginDate") + "'} = attPeriod.Fstartdate");
                WhereSql.append("     and {ts '" + filterItems.get("endDate") + "'} = attPeriod.fendDate ");
                WhereSql.append("  ) ");
            }
        }
        String orgTempTableName = filterItems.get("adminOrgTempTableName");
        String existsSql = AtsResultToSumHelper.getOrgWhereSql(filterItems, orgTempTableName);
        WhereSql.append(existsSql);
        return WhereSql.toString();
    }

    private static void createSumIndex(Context ctx, String tempTableName) {
        try {
            String dbType = ContextUtil.getDbType((Context)ctx);
            if (!StringUtils.isEmpty((String)dbType) && (dbType.equalsIgnoreCase("Oracle") || dbType.startsWith("Oracle"))) {
                DbUtil.execute((Context)ctx, (String)("CREATE  INDEX " + tempTableName + " ON " + tempTableName + " (fhrorgunitid,fproposerid,fadminorgunitid) ;"));
            } else {
                DbUtil.execute((Context)ctx, (String)("CREATE  INDEX IX" + tempTableName + " ON " + tempTableName + " (fhrorgunitid,fproposerid,fadminorgunitid) ;"));
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static void setTmpTableToSession(Map<String, String> filterItems, HttpSession session) {
        String sql = filterItems.get("resultToSumSQL");
        if (session != null) {
            String dynamicSql = "SELECT DISTINCT PERSON.FID AS FPROPOSERID " + sql.substring(sql.indexOf("FROM"), sql.indexOf("GROUP BY")) + " order by PERSON.FID asc";
            for (int i = 0; i < sqlCheck.length; ++i) {
                if (!dynamicSql.toLowerCase().contains(sqlCheck[i])) continue;
                logger.error((Object)"dynamicSql sql checkfalse");
                return;
            }
            session.setAttribute("atsResultSumDynamicSql", (Object)dynamicSql.toString());
        }
    }

    public static Set<String> getSelectPersonKey(String personJson) {
        HashSet<String> personKeys = new HashSet<String>();
        try {
            JSONArray myJsonArray = new JSONArray(personJson);
            for (int i = 0; i < myJsonArray.length(); ++i) {
                JSONObject myjObject = myJsonArray.getJSONObject(i);
                String per = myjObject.getString("personId");
                String adminOrgUnitId = myjObject.getString("adminOrgUnitId");
                String hrOrgUnitId = myjObject.getString("hrOrgUnitId");
                personKeys.add(hrOrgUnitId + per + adminOrgUnitId);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return personKeys;
    }

    public static void addHeadRow(Context ctx, Sheet wsheet, Workbook wbook, String showType, Map paramsMap) throws ParseException {
        String endDateStr;
        String row000 = "AttendanceResultInfo";
        String beginDateStr = (String)paramsMap.get("beginDate");
        ArrayList<String> list = AtsResultToSumHelper.getDefultColNameAction(ctx, showType, beginDateStr, endDateStr = (String)paramsMap.get("endDate"));
        int listSize = list != null ? list.size() : 0;
        for (int i = 0; i < listSize; ++i) {
            wsheet.setColumnWidth(i, 4000);
        }
        wsheet.createRow(0).createCell(0).setCellValue(row000);
        CellStyle head = wbook.createCellStyle();
        head.setAlignment(HorizontalAlignment.CENTER);
        head.setVerticalAlignment(VerticalAlignment.CENTER);
        head.setFillForegroundColor(IndexedColors.GREY_25_PERCENT.index);
        head.setFillPattern(FillPatternType.SOLID_FOREGROUND);
        head.setBorderRight(BorderStyle.THIN);
        head.setBorderBottom(BorderStyle.THIN);
        head.setBorderTop(BorderStyle.THIN);
        Font redFont = wbook.createFont();
        redFont.setColor(IndexedColors.BLACK.index);
        redFont.setItalic(true);
        head.setFont(redFont);
        wsheet.getRow(0).getCell(0).setCellStyle(head);
        wsheet.addMergedRegion(new CellRangeAddress(0, 0, 0, (int)((short)(listSize - 1))));
        Row rowTitle = wsheet.createRow(0);
        Cell cellTitle = rowTitle.createCell(0);
        cellTitle.setCellStyle(head);
        cellTitle.setCellValue(row000);
        Row row1 = wsheet.createRow(1);
        Cell cell = null;
        for (int i = 0; i < listSize; ++i) {
            cell = row1.createCell(i);
            cell.setCellStyle(head);
            cell.setCellValue(list.get(i));
        }
    }

    public static ArrayList<String> getDefultColNameAction(Context ctx, String showType, String beginDateStr, String endDateStr) throws ParseException {
        ArrayList<String> list = new ArrayList<String>();
        list.add(AtsSumCallConstants.personNameCN.getMessage());
        list.add(AtsSumCallConstants.personNumberCN.getMessage());
        list.add(AtsSumCallConstants.hrOrgNameCN.getMessage());
        list.add(AtsSumCallConstants.companyNameCN.getMessage());
        list.add(AtsSumCallConstants.departmentNameCN.getMessage());
        SimpleDateFormat weekSDF = new SimpleDateFormat("yyyy-MM-dd");
        Date beginDate = weekSDF.parse(beginDateStr);
        Date endDate = weekSDF.parse(endDateStr);
        List<Map<String, Object>> listMap = AtsResultToSumHelper.getInitShowAttendanceTitle(ctx, 2);
        for (int i = 0; i < listMap.size(); ++i) {
            Map<String, Object> map = listMap.get(i);
            list.add(String.valueOf(map.get("name")));
        }
        Calendar calendar = Calendar.getInstance();
        while (beginDate.getTime() <= endDate.getTime()) {
            String strDate = AtsDateUtils.dateShortToString(beginDate);
            weekSDF.applyPattern("E");
            calendar.setTime(beginDate);
            String weekName = AtsResultToSumHelper.getWeekName(ctx, calendar.get(7));
            beginDate.setTime(beginDate.getTime() + 86400000L);
            list.add(strDate + "(" + weekName + ")");
        }
        return list;
    }

    public static void setBiggerGrayCellStyle(Font font, CellStyle biggerGrayCellStyle) {
        biggerGrayCellStyle.setAlignment(HorizontalAlignment.CENTER);
        biggerGrayCellStyle.setVerticalAlignment(VerticalAlignment.CENTER);
        biggerGrayCellStyle.setFillForegroundColor(IndexedColors.GREY_50_PERCENT.index);
        biggerGrayCellStyle.setFillPattern(FillPatternType.SOLID_FOREGROUND);
        biggerGrayCellStyle.setBorderRight(BorderStyle.THIN);
        biggerGrayCellStyle.setBorderBottom(BorderStyle.THIN);
        biggerGrayCellStyle.setBorderTop(BorderStyle.THIN);
        biggerGrayCellStyle.setFont(font);
    }

    public static void setGrayCellStyle(Font font, CellStyle grayCellStyle) {
        grayCellStyle.setAlignment(HorizontalAlignment.CENTER);
        grayCellStyle.setVerticalAlignment(VerticalAlignment.CENTER);
        grayCellStyle.setFillForegroundColor(IndexedColors.GREY_25_PERCENT.index);
        grayCellStyle.setFillPattern(FillPatternType.SOLID_FOREGROUND);
        grayCellStyle.setBorderRight(BorderStyle.THIN);
        grayCellStyle.setBorderBottom(BorderStyle.THIN);
        grayCellStyle.setBorderTop(BorderStyle.THIN);
        grayCellStyle.setFont(font);
    }

    public static void setNormCellStyle(Font font, CellStyle normCellStyle) {
        normCellStyle.setAlignment(HorizontalAlignment.CENTER);
        normCellStyle.setVerticalAlignment(VerticalAlignment.CENTER);
        normCellStyle.setFillForegroundColor(IndexedColors.WHITE.index);
        normCellStyle.setFillPattern(FillPatternType.SOLID_FOREGROUND);
        normCellStyle.setBorderRight(BorderStyle.THIN);
        normCellStyle.setBorderBottom(BorderStyle.THIN);
        normCellStyle.setBorderTop(BorderStyle.THIN);
        normCellStyle.setFont(font);
    }

    public static List<Map<String, Object>> assembleGridByDate(Map<String, Object> listMap, Set<String> timeOriginalSets) {
        ArrayList<Map<String, Object>> rowDataList = new ArrayList<Map<String, Object>>();
        if (listMap == null || listMap.isEmpty()) {
            return rowDataList;
        }
        LinkedHashMap<String, String> dataMap = null;
        for (Map.Entry<String, Object> entry : listMap.entrySet()) {
            HashSet<String> timeSets = new HashSet<String>();
            timeSets.addAll(timeOriginalSets);
            String key = entry.getKey();
            if (!key.equals("rows")) continue;
            List listValue = (List)entry.getValue();
            for (Map map : listValue) {
                timeSets.removeAll(map.keySet());
                dataMap = new LinkedHashMap<String, String>();
                dataMap.put("key", key);
                dataMap.putAll(map);
                if (!timeSets.isEmpty()) {
                    for (String timeTemp : timeSets) {
                        dataMap.put(timeTemp, "");
                    }
                }
                rowDataList.add(dataMap);
            }
        }
        return rowDataList;
    }

    public static void getButtonNameByPermItem(List<String> permList, PermItemURLInfo permItemURLInfo) {
        String url = permItemURLInfo.getUrl();
        if (!StringUtils.isEmpty((String)url)) {
            String[] uri;
            url = url.substring(url.indexOf("?") + 1);
            for (String param : uri = url.split("#")) {
                if (!param.split("=")[0].equalsIgnoreCase("method")) continue;
                permList.add(param.split("=")[1]);
                break;
            }
        }
    }

    public static String getDynaAttendSumExistsSql(String beginDate, String endDate, String keyTmpTableName, Map<String, String> filterItems, Context ctx) {
        String isMulattendPeriod = filterItems.get("isMulattendPeriod");
        String attendPeriodNameSet = filterItems.get("attendPeriodNameSet");
        StringBuffer sb = new StringBuffer();
        sb.append(" select resultSum.FPROPOSERID,resultSum.FADMINORGUNITID");
        sb.append(" ,resultSum.FSalaryStatus,resultSum.fpositionID");
        sb.append(",resultSum.fhrorgunitid,resultSum.FSalaryPeriod,resultSum.fid ");
        sb.append(" from T_HR_ATS_AttendanceResultSum resultSum ");
        sb.append(" INNER JOIN " + keyTmpTableName + " ATS_TMP ON ATS_TMP.fhrorgunitid = resultSum.fhrorgunitid AND ATS_TMP.fproposerid = resultSum.fproposerid AND ATS_TMP.fadminorgunitid = resultSum.fadminorgunitid ");
        sb.append(" inner JOIN T_HR_ATS_AttendancePeriod as period ON period.fid = resultSum.fattendanceperiodid  ");
        if (StringUtils.isEmpty((String)isMulattendPeriod) || StringUtils.isEmpty((String)attendPeriodNameSet)) {
            sb.append(" where period.FStartDate = {ts '" + beginDate + "'}");
            sb.append(" and period.FEndDate = {ts '" + endDate + "'}");
        } else if ("true".equalsIgnoreCase(isMulattendPeriod)) {
            sb.append(" where period.fname").append(MLUtile.getMlFlag(ctx)).append(" in ( ").append(attendPeriodNameSet).append(" )");
        } else {
            sb.append(" where period.fname").append(MLUtile.getMlFlag(ctx)).append(" = ").append(attendPeriodNameSet);
        }
        return sb.toString();
    }

    public static String getAdminOrgPermNewSql(String tempTableName, String isdefaultManage) {
        String existsSql = null;
        existsSql = " AND EXISTS ( (SELECT 1 FROM " + tempTableName + " rangeTmp where rangeTmp.FID = FHIS.FADMINORGUNITID)   UNION ALL (SELECT 1 FROM " + tempTableName + " rangeTmp2 WHERE rangeTmp2.FID = FHIS.FATTADMINORGUNITID )) ";
        return existsSql.toString();
    }

    public static String getWeekName(Context ctx, int day) {
        String week = "";
        switch (day) {
            case 1: {
                week = MLUtile.getRes(AtsDateCommonResEnum.Sunday, ctx);
                break;
            }
            case 2: {
                week = MLUtile.getRes(AtsDateCommonResEnum.Monday, ctx);
                break;
            }
            case 3: {
                week = MLUtile.getRes(AtsDateCommonResEnum.Tuesday, ctx);
                break;
            }
            case 4: {
                week = MLUtile.getRes(AtsDateCommonResEnum.Wednesday, ctx);
                break;
            }
            case 5: {
                week = MLUtile.getRes(AtsDateCommonResEnum.Thursday, ctx);
                break;
            }
            case 6: {
                week = MLUtile.getRes(AtsDateCommonResEnum.Friday, ctx);
                break;
            }
            case 7: {
                week = MLUtile.getRes(AtsDateCommonResEnum.Saturday, ctx);
            }
        }
        return week;
    }

    public static void getRowListPersonOrAdminOrg(Context ctx, StringBuffer hrOrgUnit, StringBuffer person, StringBuffer OrgUnit, List<LinkedHashMap<String, Object>> dataList) {
        Map<String, String> hrOrgUnitMap = null;
        Map<String, PersonInfo> personMap = null;
        Map<String, String> orgUnitMap = null;
        if (person.length() > 0) {
            hrOrgUnit.deleteCharAt(hrOrgUnit.length() - 1);
            person.deleteCharAt(person.length() - 1);
            OrgUnit.deleteCharAt(OrgUnit.length() - 1);
            hrOrgUnitMap = AtsResultToSumHelper.getHrOrgUnitMap(ctx, hrOrgUnit.toString());
            personMap = AtsResultToSumHelper.getPersonMap(ctx, person.toString());
            orgUnitMap = AtsResultToSumHelper.getAdminOrgUnitMap(ctx, OrgUnit.toString());
        }
        for (int i = 0; i < dataList.size(); ++i) {
            LinkedHashMap<String, Object> map = dataList.get(i);
            PersonInfo personInfo = personMap != null ? (PersonInfo)personMap.get(map.get("personId")) : null;
            map.put("orgName", orgUnitMap == null ? "" : orgUnitMap.get(map.get("adminOrgUnitId")));
            map.put("companyName", orgUnitMap == null ? "" : orgUnitMap.get(map.get("adminOrgUnitId") + "_" + "companyName"));
            map.put("departmentName", orgUnitMap == null ? "" : orgUnitMap.get(map.get("adminOrgUnitId") + "_" + "departmentName"));
            map.put("personNumber", personInfo != null ? personInfo.getNumber() : "");
            map.put("personName", personInfo != null ? personInfo.getName() : "");
            map.put("hrOrgName", hrOrgUnitMap == null ? "" : hrOrgUnitMap.get(map.get("hrOrgUnitId")));
        }
    }

    public static Map<String, String> getHrOrgUnitMap(Context ctx, String hrOrgUnit) {
        StringBuffer oqlb = new StringBuffer();
        oqlb.append("select ");
        oqlb.append("id,");
        oqlb.append("name,");
        oqlb.append("displayName");
        oqlb.append(" where id in(" + hrOrgUnit + ")");
        HashMap<String, String> hrOrgUnitMap = new HashMap<String, String>();
        HROrgUnitCollection col = null;
        try {
            col = HROrgUnitFactory.getLocalInstance((Context)ctx).getHROrgUnitCollection(oqlb.toString());
        }
        catch (BOSException e) {
            e.printStackTrace();
        }
        if (col == null || col.size() == 0) {
            return hrOrgUnitMap;
        }
        for (int i = 0; i < col.size(); ++i) {
            HROrgUnitInfo hrOrgUnitInfo = col.get(i);
            hrOrgUnitMap.put(hrOrgUnitInfo.getId().toString(), hrOrgUnitInfo.getName());
        }
        return hrOrgUnitMap;
    }

    public static Map<String, String> getAdminOrgUnitMap(Context ctx, String adminOrgUnit) {
        StringBuffer oqlb = new StringBuffer();
        oqlb.append("select ");
        oqlb.append("id,");
        oqlb.append("displayName,");
        oqlb.append("company.name,");
        oqlb.append("department.name");
        oqlb.append(" where id in(" + adminOrgUnit + ")");
        HashMap<String, String> orgUnitMap = new HashMap<String, String>();
        AdminOrgUnitCollection col = null;
        try {
            col = AdminOrgUnitFactory.getLocalInstance((Context)ctx).getAdminOrgUnitCollection(oqlb.toString());
        }
        catch (BOSException e) {
            e.printStackTrace();
        }
        if (col == null || col.size() == 0) {
            return orgUnitMap;
        }
        for (int i = 0; i < col.size(); ++i) {
            AdminOrgUnitInfo adminOrgUnitInfo = col.get(i);
            orgUnitMap.put(adminOrgUnitInfo.getId().toString(), adminOrgUnitInfo.getDisplayName());
            if (adminOrgUnitInfo.getCompany() != null) {
                orgUnitMap.put(adminOrgUnitInfo.getId().toString() + "_" + "companyName", adminOrgUnitInfo.getCompany().getName());
            }
            if (adminOrgUnitInfo.getDepartment() == null) continue;
            orgUnitMap.put(adminOrgUnitInfo.getId().toString() + "_" + "departmentName", adminOrgUnitInfo.getDepartment().getName());
        }
        return orgUnitMap;
    }

    public static Map<String, PersonInfo> getPersonMap(Context ctx, String person) {
        HashMap<String, PersonInfo> personMap = new HashMap<String, PersonInfo>();
        StringBuffer oqlb = new StringBuffer();
        oqlb.append("select ");
        oqlb.append("id,");
        oqlb.append("number,");
        oqlb.append("name");
        oqlb.append(" where id in(" + person + ")");
        PersonCollection col = null;
        try {
            col = PersonFactory.getLocalInstance((Context)ctx).getPersonCollection(oqlb.toString());
        }
        catch (BOSException e) {
            e.printStackTrace();
        }
        if (col == null || col.size() == 0) {
            return personMap;
        }
        for (int i = 0; i < col.size(); ++i) {
            PersonInfo personInfo = col.get(i);
            personMap.put(personInfo.getId().toString(), personInfo);
        }
        return personMap;
    }

    public static void releaseSumTempTable(Context ctx, Map<String, Object> sumParams) {
        try {
            if (null != sumParams && !StringUtils.isEmpty((String)((String)sumParams.get("adminOrgTempTableName")))) {
                TempTablePool.getInstance((Context)ctx).releaseTable((String)sumParams.get("adminOrgTempTableName"));
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static IRowSet getDetailDataGrid(Context ctx, String keyPerAndOrgTmpTable, String beginDate, String endDate, String summarySql, String detailSql) {
        IRowSet rowSet = null;
        try {
            StringBuffer sb = new StringBuffer();
            sb.append(" select RESULT.fatthrorgunitid fhrorgunitid,RESULT.fproposerid,RESULT.fadminorgunitid," + detailSql + " ");
            if (!StringUtils.isEmpty((String)summarySql)) {
                sb.append("," + summarySql + "");
            }
            sb.append("  FROM T_HR_ATS_AttendanceResult RESULT ");
            sb.append("  INNER JOIN " + keyPerAndOrgTmpTable + " ATS_TMP ON ATS_TMP.fhrorgunitid = RESULT.fatthrorgunitid AND ATS_TMP.fproposerid = RESULT.fproposerid AND ATS_TMP.fadminorgunitid = RESULT.fadminorgunitid ");
            sb.append("  WHERE FATTENCEDATE >= {ts'" + beginDate + "'}");
            sb.append("  AND FATTENCEDATE <={ts'" + endDate + "'}");
            rowSet = DbUtil.executeQuery((Context)ctx, (String)sb.toString());
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return rowSet;
    }

    public static String getOrgWhereSql(Map<String, String> filterItems, String orgTempTableName) {
        String isDefaultManage = filterItems.get("isDefaultManage");
        StringBuffer existsSql = new StringBuffer();
        if (!StringUtils.isEmpty((String)filterItems.get("hrOrgUnitId"))) {
            if (!filterItems.get("hrOrgUnitId").contains(",")) {
                existsSql.append(" and FHIS.FHrOrgUnitID = " + filterItems.get("hrOrgUnitId"));
            } else {
                existsSql.append(" and FHIS.FHrOrgUnitID in (" + filterItems.get("hrOrgUnitId") + ")");
            }
        }
        if (!StringUtils.isEmpty((String)filterItems.get("attendPolicyId"))) {
            existsSql.append(" AND FHIS.FattencePolicyId = '" + filterItems.get("attendPolicyId") + "'");
        }
        if (!StringUtils.isEmpty((String)isDefaultManage) && (isDefaultManage.equalsIgnoreCase("adminOrgInner") || isDefaultManage.equalsIgnoreCase("adminOrgTeam"))) {
            existsSql.append(" AND EXISTS  (SELECT 1 FROM " + orgTempTableName + " rangeTmp where rangeTmp.FID = FHIS.FADMINORGUNITID)  ");
            existsSql.append(" AND FHIS.FisDefaultManage = 1 ");
        } else if (!StringUtils.isEmpty((String)isDefaultManage) && isDefaultManage.equalsIgnoreCase("adminOrgOuter")) {
            existsSql.append(" AND FHIS.FisDefaultManage = 0 ");
        } else {
            existsSql.append(" AND EXISTS ( (SELECT 1 FROM " + orgTempTableName + " rangeTmp where rangeTmp.FID = FHIS.FADMINORGUNITID)   UNION ALL (SELECT 1 FROM " + orgTempTableName + " rangeTmp2 WHERE rangeTmp2.FID = FHIS.FATTADMINORGUNITID )) ");
        }
        return existsSql.toString();
    }
}

