/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.hr.ats.syn.punchcard;

import com.kingdee.bos.Context;
import com.kingdee.eas.hr.ats.AtsBillResEnum;
import com.kingdee.eas.hr.ats.AtsCludHubResEnum;
import com.kingdee.eas.hr.ats.AtsFileResEnum;
import com.kingdee.eas.hr.ats.util.common.AtsCommonUtile;
import com.kingdee.eas.hr.ats.util.common.MLUtile;
import com.kingdee.eas.hr.ats.vo.common.AtsErrorMsg;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import java.util.ArrayList;
import org.apache.commons.lang.StringUtils;

public class PunchcardSynValidator
extends AtsErrorMsg {
    private String personIds;

    public boolean validate() {
        return this.validateRepeatePerson() && this.validateNoOpenIDPerson();
    }

    private boolean validateRepeatePerson() {
        ArrayList<String> params = new ArrayList<String>();
        StringBuffer sql = new StringBuffer();
        sql.append(" SELECT Fpersonid, Fxtid,Fname" + MLUtile.getMlFlag(this.ctx) + " name,Fnumber FROM t_pm_easxtusermap ");
        sql.append(" LEFT JOIN t_bd_person ON t_pm_easxtusermap.Fpersonid = t_bd_person.fid ");
        sql.append(" WHERE Fpersonid IN (");
        sql.append(" SELECT Fpersonid FROM t_pm_easxtusermap GROUP BY Fpersonid ");
        sql.append(" HAVING COUNT (Fpersonid) > 1 ");
        if (StringUtils.isNotBlank((String)this.personIds)) {
            String[] personIdArr = this.personIds.split(",");
            sql.append(" and Fpersonid IN (");
            for (int i = 0; i < personIdArr.length; ++i) {
                if (i > 0) {
                    sql.append(",");
                }
                sql.append("?");
                params.add(personIdArr[i]);
            }
            sql.append(") ");
        }
        sql.append(" ) ORDER BY Fpersonid ");
        StringBuffer message = new StringBuffer();
        try {
            IRowSet rowSet = DbUtil.executeQuery((Context)this.ctx, (String)sql.toString(), (Object[])params.toArray());
            while (rowSet.next()) {
                message.append(rowSet.getString("name")).append("[openID:").append(rowSet.getString("Fxtid")).append(",").append(MLUtile.getRes(AtsFileResEnum.PersonNum, this.ctx)).append(":").append(rowSet.getString("Fnumber")).append("]\t");
            }
            if (message.length() > 0) {
                message.insert(0, MLUtile.getRes(AtsBillResEnum.RepeatEmployeeSyncTable, this.ctx));
                message.append(MLUtile.getRes(AtsCludHubResEnum.item2, this.ctx)).append("\r\n");
            }
        }
        catch (Exception e) {
            message.append(" validateRepeatePerson error:").append(AtsCommonUtile.getExciptionInfo(e));
            e.printStackTrace();
        }
        if (message.length() > 0) {
            this.add(message.toString());
        }
        return message.length() == 0;
    }

    private boolean validateNoOpenIDPerson() {
        StringBuffer sql = new StringBuffer();
        sql.append(" select person.fid,person.Fname" + MLUtile.getMlFlag(this.ctx) + " name,person.Fnumber from t_hr_ats_attendancefile attfile");
        sql.append(" LEFT JOIN t_bd_person person ON person.fid = attfile.FPROPOSERID ");
        sql.append(" where attfile.FLEFFDT >= Now() ");
        sql.append(" and not EXISTS (SELECT 1 FROM t_pm_easxtusermap WHERE attfile.FPROPOSERID = t_pm_easxtusermap.Fpersonid ) ");
        if (StringUtils.isNotBlank((String)this.personIds)) {
            sql.append(" and attfile.FPROPOSERID in ('").append(this.personIds.replaceAll(",", "','")).append("') ");
        }
        StringBuffer message = new StringBuffer();
        try {
            IRowSet rowSet = DbUtil.executeQuery((Context)this.ctx, (String)sql.toString());
            while (rowSet.next()) {
                message.append(rowSet.getString("name")).append("[").append(MLUtile.getRes(AtsFileResEnum.PersonNum, this.ctx)).append(":").append(rowSet.getString("Fnumber")).append("]\t");
            }
            if (message.length() > 0) {
                message.insert(0, MLUtile.getRes(AtsBillResEnum.NoEmployeeSyncTable, this.ctx));
                message.append("\r\n").append(MLUtile.getRes(AtsCludHubResEnum.item1, this.ctx)).append("\r\n");
            }
        }
        catch (Exception e) {
            message.append(" validateNoOpenIDPerson error:").append(e.getMessage());
            e.printStackTrace();
        }
        if (message.length() > 0) {
            this.add(message.toString());
        }
        return message.length() == 0;
    }

    public String getPersonIds() {
        return this.personIds;
    }

    public void setPersonIds(String personIds) {
        this.personIds = personIds;
    }
}

