/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.hr.ats.syn.synch;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectCollection;
import com.kingdee.bos.metadata.data.SortType;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.entity.SorterItemCollection;
import com.kingdee.bos.metadata.entity.SorterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.basedata.org.AdminOrgUnitInfo;
import com.kingdee.eas.basedata.org.HROrgUnitInfo;
import com.kingdee.eas.basedata.person.PersonCollection;
import com.kingdee.eas.basedata.person.PersonFactory;
import com.kingdee.eas.basedata.person.PersonInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.framework.CoreBaseCollection;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.hr.ats.AttendanceFileInfo;
import com.kingdee.eas.hr.ats.AuditOpinionEnum;
import com.kingdee.eas.hr.ats.PunchCardRecordInfo;
import com.kingdee.eas.hr.ats.SignRecordInfo;
import com.kingdee.eas.hr.ats.atsTimer.AtsTimeTask;
import com.kingdee.eas.hr.ats.atsTimer.AtsTimer;
import com.kingdee.eas.hr.ats.syn.synch.PunchCardSynEnv;
import com.kingdee.eas.hr.ats.syn.synch.PunchCardSynUtile;
import com.kingdee.eas.hr.ats.util.common.AtsCollectionUtile;
import com.kingdee.eas.hr.ats.util.common.AtsLog;
import com.kingdee.eas.hr.ats.util.common.ConfigAts;
import com.kingdee.eas.hr.ats.util.common.MLUtile;
import com.kingdee.eas.hr.emp.PersonPositionCollection;
import com.kingdee.eas.hr.emp.PersonPositionFactory;
import com.kingdee.eas.hr.emp.PersonPositionInfo;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.util.enums.IntEnum;
import com.kingdee.util.enums.StringEnum;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TimerTask;
import net.sf.json.JSONObject;
import org.apache.commons.lang.StringUtils;

public class SynHelper {
    public static final long DAY_LONG = 86400000L;

    public static Map<String, PersonInfo> GetAllPersonInfo(Context ctx, Set<String> personIds) {
        StringBuffer sql = new StringBuffer("select id,number");
        if (personIds != null && personIds.size() > 0) {
            sql.append(" where id in ").append(AtsCollectionUtile.joinForSqlWithBrackets(personIds));
        }
        sql.append(" order by number ascend,effdt ascend");
        try {
            PersonCollection pCollection = PersonFactory.getLocalInstance((Context)ctx).getPersonCollection(sql.toString());
            HashMap<String, PersonInfo> pMap = new HashMap<String, PersonInfo>();
            for (int i = 0; i < pCollection.size(); ++i) {
                pMap.put(pCollection.get(i).getNumber() == null ? "" : pCollection.get(i).getNumber().toString(), pCollection.get(i));
            }
            return pMap;
        }
        catch (Exception e) {
            AtsLog.getPunchcardCloudLog().error((Object)e);
            return null;
        }
    }

    public static Map<String, PersonPositionInfo> GetAllPersonPositionInfo(Context ctx, Set<String> personIds) {
        EntityViewInfo evi = new EntityViewInfo();
        evi.getSelector().add(new SelectorItemInfo("id"));
        evi.getSelector().add(new SelectorItemInfo("person.id"));
        evi.getSelector().add(new SelectorItemInfo("person.number"));
        evi.getSelector().add(new SelectorItemInfo("person.name"));
        evi.getSelector().add(new SelectorItemInfo("personDep.id"));
        evi.getSelector().add(new SelectorItemInfo("personDep.number"));
        evi.getSelector().add(new SelectorItemInfo("personDep.name"));
        evi.getSelector().add(new SelectorItemInfo("primaryPosition.id"));
        evi.getSelector().add(new SelectorItemInfo("primaryPosition.number"));
        evi.getSelector().add(new SelectorItemInfo("primaryPosition.name"));
        evi.getSelector().add(new SelectorItemInfo("hrOrgUnit.id"));
        evi.getSelector().add(new SelectorItemInfo("hrOrgUnit.number"));
        evi.getSelector().add(new SelectorItemInfo("hrOrgUnit.name"));
        SorterItemCollection sortColl = new SorterItemCollection();
        SorterItemInfo sEFFDT = new SorterItemInfo("EFFDT");
        sEFFDT.setSortType(SortType.ASCEND);
        sortColl.add(sEFFDT);
        evi.setSorter(sortColl);
        if (personIds != null && personIds.size() > 0) {
            FilterInfo filter = new FilterInfo();
            filter.getFilterItems().add(new FilterItemInfo("person.id", personIds, CompareType.INCLUDE));
            evi.setFilter(filter);
        }
        try {
            PersonPositionCollection ppCollection = PersonPositionFactory.getLocalInstance((Context)ctx).getPersonPositionCollection(evi);
            HashMap<String, PersonPositionInfo> ppMap = new HashMap<String, PersonPositionInfo>();
            for (int i = 0; i < ppCollection.size(); ++i) {
                ppMap.put(ppCollection.get(i).getPerson().getId() == null ? "" : ppCollection.get(i).getPerson().getId().toString(), ppCollection.get(i));
            }
            return ppMap;
        }
        catch (Exception e) {
            AtsLog.getPunchcardCloudLog().error((Object)e);
            return null;
        }
    }

    public static Map<String, PersonInfo> GetAllOpenID2Person(Context ctx, Set<String> personIds) {
        HashMap<String, PersonInfo> map = new HashMap<String, PersonInfo>();
        String sql = " select t_pm_easxtusermap.fpersonid,t_pm_easxtusermap.fxtid,T_BD_Person.FNumber as fnumber,T_BD_Person.fname" + MLUtile.getMlFlag(ctx) + " as fname from t_pm_easxtusermap inner join T_BD_Person on t_pm_easxtusermap.fpersonid=T_BD_Person.fid ";
        if (!AtsCollectionUtile.isEmpty(personIds)) {
            sql = sql + "where t_pm_easxtusermap.fpersonid in " + AtsCollectionUtile.joinForSqlWithBrackets(personIds);
        }
        try {
            IRowSet rowSet = DbUtil.executeQuery((Context)ctx, (String)sql);
            while (rowSet.next()) {
                String fid = rowSet.getString("fpersonid");
                if (StringUtils.isEmpty((String)fid)) continue;
                PersonInfo personInfo = new PersonInfo();
                personInfo.setId(BOSUuid.read((String)fid));
                personInfo.setName(rowSet.getString("fname"));
                personInfo.setNumber(rowSet.getString("fnumber"));
                map.put(rowSet.getString("fxtid"), personInfo);
            }
        }
        catch (Exception e) {
            AtsLog.getPunchcardCloudLog().error((Object)e);
        }
        return map;
    }

    public static Map<String, String> GetPerson2OpenId(Context ctx, String ids, boolean idIsPersonId) {
        HashMap<String, String> map = new HashMap<String, String>();
        String sql = " select t_pm_easxtusermap.fpersonid,t_pm_easxtusermap.fxtid  from t_pm_easxtusermap  where FIsDelete != 1 ";
        if (StringUtils.isNotBlank((String)ids)) {
            sql = sql + " and " + (idIsPersonId ? "t_pm_easxtusermap.fpersonid" : "t_pm_easxtusermap.fxtid") + " in ('" + ids.replaceAll(",", "','") + "')";
        }
        try {
            IRowSet rowSet = DbUtil.executeQuery((Context)ctx, (String)sql);
            while (rowSet.next()) {
                String fid = rowSet.getString("fpersonid");
                if (StringUtils.isEmpty((String)fid)) continue;
                map.put(fid, rowSet.getString("fxtid"));
            }
        }
        catch (Exception e) {
            AtsLog.getPunchcardCloudLog().error((Object)e);
        }
        return map;
    }

    public static Map<String, AttendanceFileInfo> GetAllOpenID2AttendanceFile(Context ctx, Set<String> personIds) {
        HashMap<String, AttendanceFileInfo> map = new HashMap<String, AttendanceFileInfo>();
        String sql = " select t_pm_easxtusermap.fpersonid,t_pm_easxtusermap.fxtid,T_HR_ATS_AttendanceFile.FAdminOrgUnitId AS FAdminOrgUnitId, T_HR_ATS_AttendanceFile.FAttAdminOrgUnitId AS FAttAdminOrgUnitId,T_HR_ATS_AttendanceFile.FHrOrgUnitId AS FHrOrgUnitId, T_HR_ATS_AttendanceFile.FAttendanceNum as FAttendanceNum  from t_pm_easxtusermap inner join T_HR_ATS_AttendanceFile on t_pm_easxtusermap.fpersonid=T_HR_ATS_AttendanceFile.fproposerid ";
        if (!AtsCollectionUtile.isEmpty(personIds)) {
            sql = sql + "where t_pm_easxtusermap.fpersonid in " + AtsCollectionUtile.joinForSqlWithBrackets(personIds);
        }
        try {
            IRowSet rowSet = DbUtil.executeQuery((Context)ctx, (String)sql);
            while (rowSet.next()) {
                String fid = rowSet.getString("fpersonid");
                if (StringUtils.isEmpty((String)fid)) continue;
                AttendanceFileInfo attendanceFileInfo = new AttendanceFileInfo();
                attendanceFileInfo.setAttendanceNum(rowSet.getString("FAttendanceNum"));
                if (!StringUtils.isEmpty((String)rowSet.getString("FAdminOrgUnitId"))) {
                    AdminOrgUnitInfo adminOrgUnitInfo = new AdminOrgUnitInfo();
                    adminOrgUnitInfo.setId(BOSUuid.read((String)rowSet.getString("FAdminOrgUnitId")));
                    attendanceFileInfo.setAdminOrgUnit(adminOrgUnitInfo);
                }
                if (!StringUtils.isEmpty((String)rowSet.getString("FAttAdminOrgUnitId"))) {
                    AdminOrgUnitInfo attAdminOrgUnitInfo = new AdminOrgUnitInfo();
                    attAdminOrgUnitInfo.setId(BOSUuid.read((String)rowSet.getString("FAttAdminOrgUnitId")));
                    attendanceFileInfo.setAttAdminOrgUnit(attAdminOrgUnitInfo);
                }
                if (!StringUtils.isEmpty((String)rowSet.getString("FHrOrgUnitId"))) {
                    HROrgUnitInfo hrOrgUnitInfo = new HROrgUnitInfo();
                    hrOrgUnitInfo.setId(BOSUuid.read((String)rowSet.getString("FHrOrgUnitId")));
                    attendanceFileInfo.setHrOrgUnit(hrOrgUnitInfo);
                }
                map.put(rowSet.getString("fxtid"), attendanceFileInfo);
            }
        }
        catch (Exception e) {
            AtsLog.getPunchcardCloudLog().error((Object)e);
        }
        return map;
    }

    public static List<EntityViewInfo> getSelectViewList(PunchCardSynEnv punchCardSynEnv, boolean calSignRange) {
        CoreBaseCollection colls;
        ArrayList<EntityViewInfo> viewList = new ArrayList<EntityViewInfo>();
        CoreBaseCollection coreBaseCollection = colls = calSignRange ? punchCardSynEnv.getSignRcdColl() : punchCardSynEnv.getPunchCardColl();
        if (colls.size() == 0) {
            return viewList;
        }
        Date maxTime = null;
        Date minTime = null;
        String preHour = ConfigAts.getPropertyFromConfig("punchcard_query_exist_pre_hour");
        long preTime = (StringUtils.isBlank((String)preHour) ? 72 : Integer.valueOf(preHour)) * 60 * 60 * 1000;
        Timestamp sigleQueryStartTime = new Timestamp(punchCardSynEnv.getWorkDateFrom().getTime() - preTime);
        CoreBaseCollection rangeColls = new CoreBaseCollection();
        for (int i = 0; i < colls.size(); ++i) {
            Date curTime = SynHelper.getDateFromP(colls.get(i), calSignRange);
            if (curTime.before(sigleQueryStartTime)) {
                viewList.add(SynHelper.getCompareView(colls.get(i), curTime, curTime, calSignRange));
                continue;
            }
            maxTime = maxTime == null || curTime.after(maxTime) ? curTime : maxTime;
            minTime = minTime == null || curTime.before(minTime) ? curTime : minTime;
            rangeColls.add(colls.get(i));
        }
        if (rangeColls.size() > 0) {
            viewList.add(SynHelper.getCompareView(rangeColls, minTime, maxTime, calSignRange));
        }
        return viewList;
    }

    public static EntityViewInfo getCompareView(Object rangeColls, Date minTime, Date maxTime, boolean calSignRange) {
        CoreBaseCollection baseCollection;
        Timestamp start = new Timestamp(minTime.getTime() - 1000L);
        Timestamp end = new Timestamp(maxTime.getTime() + 1000L);
        if (!(rangeColls instanceof IObjectCollection)) {
            baseCollection = new CoreBaseCollection();
            baseCollection.add((CoreBaseInfo)rangeColls);
        } else {
            baseCollection = (CoreBaseCollection)rangeColls;
        }
        if (calSignRange) {
            return SynHelper.getCompareSignView(baseCollection, start, end);
        }
        return SynHelper.getComparePunchcardView(baseCollection, start, end);
    }

    public static CoreBaseCollection getExistData(PunchCardSynEnv punchCardSynEnv, boolean calSignRange) throws BOSException {
        List<EntityViewInfo> viewList = SynHelper.getSelectViewList(punchCardSynEnv, calSignRange);
        CoreBaseCollection coll = new CoreBaseCollection();
        Object iCoreBase = calSignRange ? punchCardSynEnv.getSignRecord() : punchCardSynEnv.getPunchCardRecord();
        for (EntityViewInfo evi : viewList) {
            coll.addCollection(iCoreBase.getCollection(evi));
        }
        return coll;
    }

    public static Date getDateFromP(CoreBaseInfo coreBaseInfo, boolean calSignRange) {
        return calSignRange ? ((SignRecordInfo)coreBaseInfo).getSignTime() : ((PunchCardRecordInfo)coreBaseInfo).getPunchCardTime();
    }

    public static void compareSignRcdColl(PunchCardSynEnv punchCardSynEnv) {
        CoreBaseCollection signRecordCollection;
        if (punchCardSynEnv.getSignRcdColl() == null || punchCardSynEnv.getSignRcdColl().size() == 0) {
            return;
        }
        try {
            signRecordCollection = SynHelper.getExistData(punchCardSynEnv, true);
        }
        catch (BOSException e) {
            AtsLog.getPunchcardCloudLog().error((Object)e);
            return;
        }
        Iterator iterator = punchCardSynEnv.getSignRcdColl().iterator();
        CoreBaseCollection addColl = punchCardSynEnv.getSignAdd();
        CoreBaseCollection updateColl = punchCardSynEnv.getSignUpdate();
        while (iterator.hasNext()) {
            SignRecordInfo signRecordInfo = (SignRecordInfo)iterator.next();
            int index = signRecordCollection.indexOf((CoreBaseInfo)signRecordInfo);
            if (index == -1) {
                if (addColl.contains((CoreBaseInfo)signRecordInfo)) continue;
                addColl.add((CoreBaseInfo)signRecordInfo);
                continue;
            }
            boolean needUpdate = false;
            SignRecordInfo dbRecord = (SignRecordInfo)signRecordCollection.get(index);
            if (AuditOpinionEnum.unaudited.equals((Object)dbRecord.getAuditOpinion()) && !AuditOpinionEnum.unaudited.equals((Object)signRecordInfo.getAuditOpinion())) {
                dbRecord.setAuditOpinion(signRecordInfo.getAuditOpinion());
                needUpdate = true;
            }
            if (signRecordInfo.getComprehensiveType() != null && !signRecordInfo.getComprehensiveType().equals((Object)dbRecord.getComprehensiveType())) {
                dbRecord.setComprehensiveType(signRecordInfo.getComprehensiveType());
                needUpdate = true;
            }
            if (signRecordInfo.getCardState() != null && !signRecordInfo.getCardState().equals((Object)dbRecord.getCardState())) {
                dbRecord.setCardState(signRecordInfo.getCardState());
                needUpdate = true;
            }
            if (!needUpdate || updateColl.contains((CoreBaseInfo)dbRecord)) continue;
            updateColl.add((CoreBaseInfo)dbRecord);
        }
    }

    public static void comparePunchcardColl(PunchCardSynEnv punchCardSynEnv) {
        if (punchCardSynEnv.getPunchCardColl() == null || punchCardSynEnv.getPunchCardColl().size() == 0) {
            return;
        }
        CoreBaseCollection punchcardCollection = null;
        try {
            punchcardCollection = SynHelper.getExistData(punchCardSynEnv, false);
        }
        catch (BOSException e) {
            AtsLog.getPunchcardCloudLog().error((Object)e);
            return;
        }
        Iterator iterator = punchCardSynEnv.getPunchCardColl().iterator();
        CoreBaseCollection addColl = punchCardSynEnv.getPunchcardAdd();
        CoreBaseCollection updateColl = punchCardSynEnv.getPunchcardUpdate();
        while (iterator.hasNext()) {
            PunchCardRecordInfo punchCardRecordInfo = (PunchCardRecordInfo)iterator.next();
            int index = punchcardCollection.indexOf((CoreBaseInfo)punchCardRecordInfo);
            if (index == -1) {
                if (addColl.contains((CoreBaseInfo)punchCardRecordInfo)) continue;
                addColl.add((CoreBaseInfo)punchCardRecordInfo);
                continue;
            }
            boolean needUpdate = false;
            PunchCardRecordInfo dbRecord = (PunchCardRecordInfo)punchcardCollection.get(index);
            if (punchCardRecordInfo.getComprehensiveType() != null && dbRecord.getComprehensiveType() != punchCardRecordInfo.getComprehensiveType()) {
                dbRecord.setComprehensiveType(punchCardRecordInfo.getComprehensiveType());
                needUpdate = true;
            }
            if (punchCardRecordInfo.getPunchCardState() != null && !punchCardRecordInfo.getPunchCardState().equals((Object)dbRecord.getPunchCardState())) {
                dbRecord.setPunchCardState(punchCardRecordInfo.getPunchCardState());
                needUpdate = true;
            }
            if (!needUpdate || updateColl.contains((CoreBaseInfo)dbRecord)) continue;
            updateColl.add((CoreBaseInfo)dbRecord);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void updatePunchcardData(PunchCardSynEnv punchCardSynEnv) {
        CoreBaseCollection colls = punchCardSynEnv.getPunchcardUpdate();
        ArrayList<Object[]> updateParams = new ArrayList<Object[]>(colls.size());
        for (int i = 0; i < colls.size(); ++i) {
            Object[] param = new Object[3];
            PunchCardRecordInfo punchCardRecordInfo = (PunchCardRecordInfo)colls.get(i);
            param[0] = SynHelper.getEnumVal(punchCardRecordInfo.getComprehensiveType());
            param[1] = SynHelper.getEnumVal(punchCardRecordInfo.getPunchCardState());
            param[2] = punchCardRecordInfo.getId().toString();
            updateParams.add(param);
        }
        try {
            if (!AtsCollectionUtile.isEmpty((IObjectCollection)punchCardSynEnv.getPunchcardAdd())) {
                AtsLog.getPunchcardCloudLog().info((Object)"PunchcardAdd");
                AtsLog.getPunchcardCloudLog().info((Object)punchCardSynEnv.getPunchcardAdd());
                punchCardSynEnv.getPunchCardRecord().save(punchCardSynEnv.getPunchcardAdd());
            }
            if (updateParams.size() > 0) {
                AtsTimer.addTask((TimerTask)new AtsTimeTask<List<Object[]>>(punchCardSynEnv.getCtx(), updateParams){

                    @Override
                    protected void process() throws Exception {
                        DbUtil.executeBatch((Context)this.ctx, (String)"update T_HR_ATS_PunchCardRecord set fcomprehensiveType=? ,fpunchCardState=? where fid=?", (List)((List)this.dataObj));
                    }
                }, 0L);
            }
            punchCardSynEnv.addPunchcardAddSize(punchCardSynEnv.getPunchcardAdd().size());
            punchCardSynEnv.addPunchcardUpdateSize(updateParams.size());
        }
        catch (BOSException e) {
            AtsLog.getPunchcardCloudLog().error((Object)e);
        }
        catch (EASBizException e) {
            AtsLog.getPunchcardCloudLog().error((Object)e);
        }
        finally {
            punchCardSynEnv.getPunchcardAdd().clear();
            punchCardSynEnv.getPunchcardUpdate().clear();
            punchCardSynEnv.getPunchCardColl().clear();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void updateSignRecData(PunchCardSynEnv punchCardSynEnv) {
        CoreBaseCollection colls = punchCardSynEnv.getSignUpdate();
        ArrayList<Object[]> updateParams = new ArrayList<Object[]>(colls.size());
        for (int i = 0; i < colls.size(); ++i) {
            Object[] param = new Object[4];
            SignRecordInfo signRecordInfo = (SignRecordInfo)colls.get(i);
            param[0] = SynHelper.getEnumVal(signRecordInfo.getComprehensiveType());
            param[1] = SynHelper.getEnumVal(signRecordInfo.getCardState());
            param[2] = SynHelper.getEnumVal(signRecordInfo.getAuditOpinion());
            param[3] = signRecordInfo.getId().toString();
            updateParams.add(param);
        }
        try {
            if (!AtsCollectionUtile.isEmpty((IObjectCollection)punchCardSynEnv.getSignAdd())) {
                punchCardSynEnv.getSignRecord().save(punchCardSynEnv.getSignAdd());
            }
            if (updateParams.size() > 0) {
                AtsTimer.addTask((TimerTask)new AtsTimeTask<List<Object[]>>(punchCardSynEnv.getCtx(), updateParams){

                    @Override
                    protected void process() throws Exception {
                        DbUtil.executeBatch((Context)this.ctx, (String)"update t_hr_signrecord set fcomprehensiveType=? ,fcardState=?, fauditOpinion=? where fid=?", (List)((List)this.dataObj));
                    }
                }, 0L);
            }
            punchCardSynEnv.addSignAddSize(punchCardSynEnv.getSignAdd().size());
            punchCardSynEnv.addSignUpdateSize(updateParams.size());
        }
        catch (BOSException e) {
            AtsLog.getPunchcardCloudLog().error((Object)e);
        }
        catch (EASBizException e) {
            AtsLog.getPunchcardCloudLog().error((Object)e);
        }
        finally {
            punchCardSynEnv.getSignAdd().clear();
            punchCardSynEnv.getSignUpdate().clear();
            punchCardSynEnv.getSignRcdColl().clear();
        }
    }

    public static Object getEnumVal(IntEnum enumObj) {
        return enumObj == null ? "" : Integer.valueOf(enumObj.getValue());
    }

    public static Object getEnumVal(StringEnum enumObj) {
        return enumObj == null ? "" : enumObj.getValue();
    }

    public static EntityViewInfo getComparePunchcardView(CoreBaseCollection punchcardColl, Timestamp beginDate, Timestamp endDate) {
        HashSet<String> pidSet = new HashSet<String>();
        Iterator iterator = punchcardColl.iterator();
        boolean havePersonNull = false;
        while (iterator.hasNext()) {
            PunchCardRecordInfo punchCardRecordInfo = (PunchCardRecordInfo)iterator.next();
            if (punchCardRecordInfo.getProposer() != null && punchCardRecordInfo.getProposer().getId() != null) {
                pidSet.add(punchCardRecordInfo.getProposer().getId().toString());
                continue;
            }
            havePersonNull = true;
        }
        EntityViewInfo evi = new EntityViewInfo();
        evi.getSelector().add(new SelectorItemInfo("id"));
        evi.getSelector().add(new SelectorItemInfo("punchCardTime"));
        evi.getSelector().add(new SelectorItemInfo("proposer.id"));
        evi.getSelector().add(new SelectorItemInfo("comprehensiveType"));
        evi.getSelector().add(new SelectorItemInfo("equipmentNum"));
        evi.getSelector().add(new SelectorItemInfo("attendanceNum"));
        evi.getSelector().add(new SelectorItemInfo("punchCardState"));
        FilterInfo fi = new FilterInfo();
        if (pidSet.isEmpty() && havePersonNull) {
            fi.getFilterItems().add(new FilterItemInfo("proposer.id", null, CompareType.EQUALS));
        } else if (!pidSet.isEmpty() && !havePersonNull) {
            fi.getFilterItems().add(new FilterItemInfo("proposer.id", pidSet, CompareType.INCLUDE));
        } else if (!pidSet.isEmpty() && havePersonNull) {
            fi.getFilterItems().add(new FilterItemInfo("proposer.id", pidSet, CompareType.INCLUDE));
            FilterInfo fi2 = new FilterInfo();
            fi2.getFilterItems().add(new FilterItemInfo("proposer.id", null, CompareType.EQUALS));
            try {
                fi.mergeFilter(fi2, "OR");
            }
            catch (BOSException e) {
                AtsLog.getPunchcardCloudLog().error((Object)e);
            }
        } else {
            return null;
        }
        FilterInfo fi3 = new FilterInfo();
        HashSet<String> synPunchCardSource = new HashSet<String>(2);
        synPunchCardSource.add("0");
        synPunchCardSource.add("2");
        synPunchCardSource.add("3");
        synPunchCardSource.add("4");
        synPunchCardSource.add("5");
        fi3.getFilterItems().add(new FilterItemInfo("punchCardSource", synPunchCardSource, CompareType.NOTINCLUDE));
        fi3.getFilterItems().add(new FilterItemInfo("punchCardTime", (Object)beginDate, CompareType.GREATER_EQUALS));
        fi3.getFilterItems().add(new FilterItemInfo("punchCardTime", (Object)endDate, CompareType.LESS_EQUALS));
        try {
            fi.mergeFilter(fi3, "AND");
        }
        catch (BOSException e) {
            AtsLog.getPunchcardCloudLog().error((Object)e);
        }
        evi.setFilter(fi);
        return evi;
    }

    public static EntityViewInfo getCompareSignView(CoreBaseCollection signRcdColl, Timestamp beginDate, Timestamp endDate) {
        HashSet<String> pidSet = new HashSet<String>();
        Iterator iterator = signRcdColl.iterator();
        boolean havePersonNull = false;
        while (iterator.hasNext()) {
            SignRecordInfo signRecordInfo = (SignRecordInfo)iterator.next();
            if (signRecordInfo.getPerson() != null && signRecordInfo.getPerson().getId() != null) {
                pidSet.add(signRecordInfo.getPerson().getId().toString());
                continue;
            }
            havePersonNull = true;
        }
        EntityViewInfo evi = new EntityViewInfo();
        evi.getSelector().add(new SelectorItemInfo("id"));
        evi.getSelector().add(new SelectorItemInfo("signTime"));
        evi.getSelector().add(new SelectorItemInfo("person.id"));
        evi.getSelector().add(new SelectorItemInfo("auditOpinion"));
        evi.getSelector().add(new SelectorItemInfo("cardState"));
        evi.getSelector().add(new SelectorItemInfo("comprehensiveType"));
        FilterInfo fi = new FilterInfo();
        if (pidSet.isEmpty() && havePersonNull) {
            fi.getFilterItems().add(new FilterItemInfo("person.id", null, CompareType.EQUALS));
        } else if (!pidSet.isEmpty() && !havePersonNull) {
            fi.getFilterItems().add(new FilterItemInfo("person.id", pidSet, CompareType.INCLUDE));
        } else if (!pidSet.isEmpty() && havePersonNull) {
            fi.getFilterItems().add(new FilterItemInfo("person.id", pidSet, CompareType.INCLUDE));
            FilterInfo fi2 = new FilterInfo();
            fi2.getFilterItems().add(new FilterItemInfo("person.id", null, CompareType.EQUALS));
            try {
                fi.mergeFilter(fi2, "OR");
            }
            catch (BOSException e) {
                AtsLog.getPunchcardCloudLog().error((Object)e);
            }
        } else {
            return null;
        }
        FilterInfo fi3 = new FilterInfo();
        fi3.getFilterItems().add(new FilterItemInfo("signTime", (Object)beginDate, CompareType.GREATER_EQUALS));
        fi3.getFilterItems().add(new FilterItemInfo("signTime", (Object)endDate, CompareType.LESS_EQUALS));
        try {
            fi.mergeFilter(fi3, "AND");
        }
        catch (BOSException e) {
            AtsLog.getPunchcardCloudLog().error((Object)e);
        }
        evi.setFilter(fi);
        return evi;
    }

    public static PunchCardRecordInfo assemblePunchCardRecordInfo(JSONObject json, PunchCardSynEnv punchCardSynEnv) {
        return PunchCardSynUtile.assemblePunchCardRecordInfo(json, punchCardSynEnv.getOpenapikey(), punchCardSynEnv.getWorkDateTo(), punchCardSynEnv.getPpMap(), punchCardSynEnv.getAllOpenID2PersonMap(), punchCardSynEnv.getAllOpenID2AttFileMap(), punchCardSynEnv.getpMap());
    }

    public static SignRecordInfo assembleSignRecordInfo(JSONObject json, PunchCardSynEnv punchCardSynEnv) {
        SignRecordInfo info = PunchCardSynUtile.assembleSignRecordInfo(json, punchCardSynEnv.getOpenapikey(), punchCardSynEnv.getPpMap(), punchCardSynEnv.getAllOpenID2PersonMap(), punchCardSynEnv.getAllOpenID2AttFileMap());
        return info;
    }
}

