/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.hr.ats.util;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.AbstractObjectCollection;
import com.kingdee.bos.dao.IObjectCollection;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.data.SortType;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.entity.SorterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.basedata.org.AdminOrgUnitInfo;
import com.kingdee.eas.basedata.org.HROrgUnitInfo;
import com.kingdee.eas.basedata.org.PositionInfo;
import com.kingdee.eas.basedata.person.PersonInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.hr.ats.AtsShiftCollection;
import com.kingdee.eas.hr.ats.AtsShiftElasticDirection;
import com.kingdee.eas.hr.ats.AtsShiftElasticType;
import com.kingdee.eas.hr.ats.AtsShiftFactory;
import com.kingdee.eas.hr.ats.AtsShiftInfo;
import com.kingdee.eas.hr.ats.AtsShiftItemCollection;
import com.kingdee.eas.hr.ats.AtsShiftItemInfo;
import com.kingdee.eas.hr.ats.AtsShiftPriorityType;
import com.kingdee.eas.hr.ats.AtsShiftTypeInfo;
import com.kingdee.eas.hr.ats.AtsUtil;
import com.kingdee.eas.hr.ats.AttencePolicyInfo;
import com.kingdee.eas.hr.ats.AttendFileStateEnum;
import com.kingdee.eas.hr.ats.AttendanceFileHISCollection;
import com.kingdee.eas.hr.ats.AttendanceFileHISFactory;
import com.kingdee.eas.hr.ats.AttendanceFileHISInfo;
import com.kingdee.eas.hr.ats.AttendanceFileInfo;
import com.kingdee.eas.hr.ats.AttendanceTypeEnum;
import com.kingdee.eas.hr.ats.CardRuleInfo;
import com.kingdee.eas.hr.ats.DayTypeEnum;
import com.kingdee.eas.hr.ats.OverTimeCompensInfo;
import com.kingdee.eas.hr.ats.ScheduleShiftCollection;
import com.kingdee.eas.hr.ats.ScheduleShiftFactory;
import com.kingdee.eas.hr.ats.ScheduleShiftInfo;
import com.kingdee.eas.hr.ats.ScheduleShiftItemCollection;
import com.kingdee.eas.hr.ats.ScheduleShiftItemInfo;
import com.kingdee.eas.hr.ats.SegIsPunchCardEnum;
import com.kingdee.eas.hr.ats.SegmentEnum;
import com.kingdee.eas.hr.ats.SegmentUnitEnum;
import com.kingdee.eas.hr.ats.WorkCalendarItemCollection;
import com.kingdee.eas.hr.ats.WorkCalendarItemFactory;
import com.kingdee.eas.hr.ats.bizmanage.MessageConfirm.Util.AtsIntelligentUtil;
import com.kingdee.eas.hr.ats.helper.ScheduleShiftItemHelper;
import com.kingdee.eas.hr.ats.holidayLimit.generate.util.HRTimeWebUtils;
import com.kingdee.eas.hr.ats.util.AtsDateUtils;
import com.kingdee.eas.hr.ats.util.FetchCardUtil;
import com.kingdee.eas.hr.ats.util.common.AtsCollectionUtile;
import com.kingdee.eas.hr.ats.util.common.AtsCommonUtile;
import com.kingdee.eas.hr.ats.util.common.CoreBaseUtile;
import com.kingdee.eas.hr.ats.util.common.DbUtile;
import com.kingdee.eas.hr.ats.util.common.MLUtile;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import java.sql.Date;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;

public class AtsScheduleShiftUtil {
    private static Logger logger = Logger.getLogger(AtsScheduleShiftUtil.class);

    public static ScheduleShiftInfo getScheduleShiftByPriority(Context ctx, String personId, String date) {
        AttencePolicyInfo attencePolicyInfo;
        AttendanceFileHISInfo atsFileInfo;
        if (!StringUtils.isEmpty((String)date) && date.length() > 10) {
            date = date.substring(0, 10);
        }
        if (null == (atsFileInfo = AtsScheduleShiftUtil.getAttendanceFileHisInfo(ctx, personId, date)) || null == atsFileInfo.getIsAttendance()) {
            return null;
        }
        ScheduleShiftInfo scheduleShiftInfo = null;
        Map<String, ScheduleShiftInfo> shiftPersonMap = AtsScheduleShiftUtil.getScheduleShiftForPersonByOql(ctx, personId, date, date);
        Map<String, ScheduleShiftInfo> shiftAdminOrgMap = AtsScheduleShiftUtil.getScheduleShiftForAdminOrg(ctx, personId, date, date);
        Map<String, ScheduleShiftInfo> shiftGroupMap = AtsScheduleShiftUtil.getScheduleShiftForGroup(ctx, personId, date, date);
        if ((shiftPersonMap != null || shiftAdminOrgMap != null || shiftGroupMap != null) && null != (attencePolicyInfo = atsFileInfo.getAttencePolicy())) {
            scheduleShiftInfo = AtsScheduleShiftUtil.getScheduleShiftList(shiftPersonMap, shiftAdminOrgMap, shiftGroupMap, attencePolicyInfo, AtsScheduleShiftUtil.getKey(personId, date));
        }
        return scheduleShiftInfo;
    }

    public static ScheduleShiftInfo getScheduleShiftByPriority(Context ctx, String personId, java.util.Date date) {
        SimpleDateFormat format = new SimpleDateFormat("yyyy-MM-dd");
        return AtsScheduleShiftUtil.getScheduleShiftByPriority(ctx, personId, format.format(date));
    }

    public static List<ScheduleShiftInfo> getScheduleShiftListByPriority(Context ctx, String personIds, String date) {
        if (!StringUtils.isEmpty((String)date) && date.length() > 10) {
            date = date.substring(0, 10);
        }
        Map<String, AttendanceFileInfo> fileInfoObject = AtsScheduleShiftUtil.getAttendanceFileInfoByPersonId(ctx, personIds, date, date);
        return AtsScheduleShiftUtil.getScheduleShiftList(ctx, fileInfoObject, personIds, date, date);
    }

    public static Map<String, ScheduleShiftInfo> getScheduleShiftByPriority(Context ctx, String personIds, String beginDate, String endDate) {
        if (!StringUtils.isEmpty((String)beginDate) && beginDate.length() > 10) {
            beginDate = beginDate.substring(0, 10);
        }
        if (!StringUtils.isEmpty((String)endDate) && endDate.length() > 10) {
            endDate = endDate.substring(0, 10);
        }
        Map<String, AttendanceFileInfo> fileInfoObject = AtsScheduleShiftUtil.getAttendanceFileInfoByPersonId(ctx, personIds, beginDate, endDate);
        return AtsScheduleShiftUtil.getScheduleShiftByPriority(ctx, fileInfoObject, personIds, beginDate, endDate);
    }

    public static ScheduleShiftCollection getScheduleShiftCollByPriority(Context ctx, String personIds, String beginDate, String endDate) {
        if (!StringUtils.isEmpty((String)beginDate) && beginDate.length() > 10) {
            beginDate = beginDate.substring(0, 10);
        }
        if (!StringUtils.isEmpty((String)endDate) && endDate.length() > 10) {
            endDate = endDate.substring(0, 10);
        }
        Map<String, AttendanceFileInfo> fileInfoObject = AtsScheduleShiftUtil.getAttendanceFileInfoByPersonId(ctx, personIds, beginDate, endDate);
        return AtsScheduleShiftUtil.getScheduleShiftColl(ctx, fileInfoObject, personIds, beginDate, endDate);
    }

    public static List<ScheduleShiftInfo> getScheduleShiftListByPriority(Context ctx, String personIds, String beginDate, String endDate) {
        if (!StringUtils.isEmpty((String)beginDate) && beginDate.length() > 10) {
            beginDate = beginDate.substring(0, 10);
        }
        if (!StringUtils.isEmpty((String)endDate) && endDate.length() > 10) {
            endDate = endDate.substring(0, 10);
        }
        Map<String, AttendanceFileInfo> fileInfoObject = AtsScheduleShiftUtil.getAttendanceFileInfoByPersonId(ctx, personIds, beginDate, endDate);
        return AtsScheduleShiftUtil.getScheduleShiftList(ctx, fileInfoObject, personIds, beginDate, endDate);
    }

    public static Map<String, ScheduleShiftInfo> getScheduleShiftByPriority(Context ctx, Map<String, AttendanceFileInfo> atsFileHisMap, String personIds, String beginDate, String endDate) {
        HashMap<String, ScheduleShiftInfo> retMap = null;
        if (null == atsFileHisMap || atsFileHisMap.size() == 0) {
            return retMap;
        }
        if (!StringUtils.isEmpty((String)beginDate) && beginDate.length() > 10) {
            beginDate = beginDate.substring(0, 10);
        }
        if (!StringUtils.isEmpty((String)endDate) && endDate.length() > 10) {
            endDate = endDate.substring(0, 10);
        }
        Map<String, ScheduleShiftInfo> shiftPersonMap = AtsScheduleShiftUtil.getScheduleShiftForPersonByOql(ctx, personIds, beginDate, endDate);
        Map<String, ScheduleShiftInfo> shiftAdminOrgMap = AtsScheduleShiftUtil.getScheduleShiftForAdminOrg(ctx, personIds, beginDate, endDate);
        Map<String, ScheduleShiftInfo> shiftGroupMap = AtsScheduleShiftUtil.getScheduleShiftForGroup(ctx, personIds, beginDate, endDate);
        if (shiftPersonMap == null && shiftAdminOrgMap == null && shiftGroupMap == null) {
            return retMap;
        }
        retMap = new HashMap<String, ScheduleShiftInfo>();
        for (Map.Entry<String, AttendanceFileInfo> atsFileEntry : atsFileHisMap.entrySet()) {
            ScheduleShiftInfo scheduleShiftInfo = null;
            String key = atsFileEntry.getKey();
            AttendanceFileInfo atsFileInfo = atsFileEntry.getValue();
            if (atsFileInfo == null || null == atsFileInfo.getIsAttendance()) continue;
            AttencePolicyInfo attencePolicyInfo = atsFileInfo.getAttencePolicy();
            if (null != attencePolicyInfo) {
                scheduleShiftInfo = AtsScheduleShiftUtil.getScheduleShiftList(shiftPersonMap, shiftAdminOrgMap, shiftGroupMap, attencePolicyInfo, key);
            }
            if (null == scheduleShiftInfo) continue;
            retMap.put(key, scheduleShiftInfo);
        }
        return retMap;
    }

    public static Map<String, List<ScheduleShiftInfo>> getScheduleShiftMapByPriority(Context ctx, Map<String, AttendanceFileInfo> atsFileHisMap, String personIds, String beginDate, String endDate) {
        HashMap<String, List<ScheduleShiftInfo>> retMap = null;
        if (null == atsFileHisMap || atsFileHisMap.size() <= 0) {
            return retMap;
        }
        if (!StringUtils.isEmpty((String)beginDate) && beginDate.length() > 10) {
            beginDate = beginDate.substring(0, 10);
        }
        if (!StringUtils.isEmpty((String)endDate) && endDate.length() > 10) {
            endDate = endDate.substring(0, 10);
        }
        Map<String, ScheduleShiftInfo> shiftPersonMap = AtsScheduleShiftUtil.getScheduleShiftForPersonByOql(ctx, personIds, beginDate, endDate);
        Map<String, ScheduleShiftInfo> shiftAdminOrgMap = AtsScheduleShiftUtil.getScheduleShiftForAdminOrg(ctx, personIds, beginDate, endDate);
        Map<String, ScheduleShiftInfo> shiftGroupMap = AtsScheduleShiftUtil.getScheduleShiftForGroup(ctx, personIds, beginDate, endDate);
        if (shiftPersonMap == null && shiftAdminOrgMap == null && shiftGroupMap == null) {
            return retMap;
        }
        AttendanceFileInfo atsFileInfo = null;
        AttencePolicyInfo attencePolicyInfo = null;
        retMap = new HashMap<String, List<ScheduleShiftInfo>>();
        ScheduleShiftInfo scheduleShiftInfo = null;
        ArrayList<ScheduleShiftInfo> scheduleShiftList = null;
        for (Map.Entry<String, AttendanceFileInfo> atsFileEntry : atsFileHisMap.entrySet()) {
            String key = atsFileEntry.getKey();
            atsFileInfo = atsFileEntry.getValue();
            if (atsFileInfo == null || null == atsFileInfo.getIsAttendance()) continue;
            if (atsFileInfo.getIsAttendance().getValue().equals("1")) {
                attencePolicyInfo = atsFileInfo.getAttencePolicy();
                if (null != attencePolicyInfo) {
                    scheduleShiftInfo = AtsScheduleShiftUtil.getScheduleShiftList(shiftPersonMap, shiftAdminOrgMap, shiftGroupMap, attencePolicyInfo, key);
                }
            } else {
                ScheduleShiftInfo scheduleShiftInfo2 = scheduleShiftInfo = null != shiftPersonMap ? shiftPersonMap.get(key) : null;
            }
            if (null == scheduleShiftInfo) continue;
            scheduleShiftList = new ArrayList<ScheduleShiftInfo>();
            scheduleShiftList.add(scheduleShiftInfo);
            retMap.put(key, scheduleShiftList);
        }
        return retMap;
    }

    public static Map<String, List<ScheduleShiftInfo>> getScheduleShiftByAttdCal(Context ctx, Map<String, AttendanceFileInfo> atsFileHisMap, String personIds, String beginDate, String endDate, Map<Object, Object> globalMap) {
        HashMap<String, List<ScheduleShiftInfo>> retMap = null;
        if (null == atsFileHisMap || atsFileHisMap.size() <= 0) {
            return retMap;
        }
        Boolean isExistAdminOrgSchedule = true;
        Boolean isExistAttdGroupSchedule = true;
        if (null != globalMap) {
            isExistAdminOrgSchedule = (Boolean)globalMap.get("isExistAdminOrgSchedule");
            isExistAttdGroupSchedule = (Boolean)globalMap.get("isExistAttdGroupSchedule");
        }
        if (!StringUtils.isEmpty((String)beginDate) && beginDate.length() > 10) {
            beginDate = beginDate.substring(0, 10);
        }
        if (!StringUtils.isEmpty((String)endDate) && endDate.length() > 10) {
            endDate = endDate.substring(0, 10);
        }
        Map<String, ScheduleShiftInfo> shiftPersonMap = AtsScheduleShiftUtil.getScheduleShiftForPersonByOql(ctx, personIds, beginDate, endDate);
        Map<String, ScheduleShiftInfo> shiftAdminOrgMap = null;
        if (null == isExistAdminOrgSchedule || isExistAdminOrgSchedule.booleanValue()) {
            shiftAdminOrgMap = AtsScheduleShiftUtil.getScheduleShiftForAdminOrg(ctx, personIds, beginDate, endDate);
        }
        Map<String, ScheduleShiftInfo> shiftGroupMap = null;
        if (null == isExistAttdGroupSchedule || isExistAttdGroupSchedule.booleanValue()) {
            shiftGroupMap = AtsScheduleShiftUtil.getScheduleShiftForGroup(ctx, personIds, beginDate, endDate);
        }
        if (shiftPersonMap == null && shiftAdminOrgMap == null && shiftGroupMap == null) {
            return retMap;
        }
        AttendanceFileInfo atsFileInfo = null;
        AttencePolicyInfo attencePolicyInfo = null;
        retMap = new HashMap<String, List<ScheduleShiftInfo>>();
        ScheduleShiftInfo scheduleShiftInfo = null;
        ArrayList<ScheduleShiftInfo> scheduleShiftList = null;
        for (Map.Entry<String, AttendanceFileInfo> atsFileEntry : atsFileHisMap.entrySet()) {
            String key = atsFileEntry.getKey();
            atsFileInfo = atsFileEntry.getValue();
            if (atsFileInfo == null || null == atsFileInfo.getIsAttendance()) continue;
            attencePolicyInfo = atsFileInfo.getAttencePolicy();
            if (null != attencePolicyInfo) {
                scheduleShiftInfo = AtsScheduleShiftUtil.getScheduleShiftList(shiftPersonMap, shiftAdminOrgMap, shiftGroupMap, attencePolicyInfo, key);
            }
            if (null == scheduleShiftInfo) continue;
            scheduleShiftList = new ArrayList<ScheduleShiftInfo>();
            scheduleShiftList.add(scheduleShiftInfo);
            retMap.put(key, scheduleShiftList);
        }
        return retMap;
    }

    public static Map<String, List<ScheduleShiftInfo>> getScheduleShiftMapByPriority(Context ctx, String personIds, String beginDate, String endDate) {
        if (!StringUtils.isEmpty((String)beginDate) && beginDate.length() > 10) {
            beginDate = beginDate.substring(0, 10);
        }
        if (!StringUtils.isEmpty((String)endDate) && endDate.length() > 10) {
            endDate = endDate.substring(0, 10);
        }
        Map<String, AttendanceFileInfo> fileInfoObject = AtsScheduleShiftUtil.getAttendanceFileInfoByPersonId(ctx, personIds, beginDate, endDate);
        return AtsScheduleShiftUtil.getScheduleShiftMapByPriority(ctx, fileInfoObject, personIds, beginDate, endDate);
    }

    public static void getAllScheduleShiftMapByPriority(Map<Object, Object> globalMap, Context ctx, String personIds, String beginDate, String endDate) {
        if (!StringUtils.isEmpty((String)beginDate) && beginDate.length() > 10) {
            beginDate = beginDate.substring(0, 10);
        }
        if (!StringUtils.isEmpty((String)endDate) && endDate.length() > 10) {
            endDate = endDate.substring(0, 10);
        }
        Map<String, AttendanceFileInfo> fileInfoObject = AtsScheduleShiftUtil.getAllAttFileInfoByPersonId(ctx, personIds, beginDate, endDate);
        AtsScheduleShiftUtil.getScheduleShiftMapByPriorityNew(globalMap, ctx, fileInfoObject, personIds, beginDate, endDate);
    }

    public static void getScheduleShiftMapByPriorityNew(Map<Object, Object> globalMap, Context ctx, Map<String, AttendanceFileInfo> atsFileHisMap, String personIds, String beginDate, String endDate) {
        if (AtsCollectionUtile.isEmpty(globalMap)) {
            return;
        }
        if (null == atsFileHisMap || atsFileHisMap.size() <= 0) {
            return;
        }
        if (!StringUtils.isEmpty((String)beginDate) && beginDate.length() > 10) {
            beginDate = beginDate.substring(0, 10);
        }
        if (!StringUtils.isEmpty((String)endDate) && endDate.length() > 10) {
            endDate = endDate.substring(0, 10);
        }
        Map<String, ScheduleShiftInfo> shiftPersonMap = AtsScheduleShiftUtil.getScheduleShiftForPersonByOql(ctx, personIds, beginDate, endDate);
        Map<String, ScheduleShiftInfo> shiftAdminOrgMap = AtsScheduleShiftUtil.getScheduleShiftForAdminOrg(ctx, personIds, beginDate, endDate);
        Map<String, ScheduleShiftInfo> shiftGroupMap = AtsScheduleShiftUtil.getScheduleShiftForGroup(ctx, personIds, beginDate, endDate);
        if (shiftPersonMap == null && shiftAdminOrgMap == null && shiftGroupMap == null) {
            return;
        }
        HashMap retMap = null;
        HashMap allRetMap = null;
        AttendanceFileInfo atsFileInfo = null;
        AttencePolicyInfo attencePolicyInfo = null;
        retMap = new HashMap();
        allRetMap = new HashMap();
        ScheduleShiftInfo scheduleShiftInfo = null;
        ArrayList<ScheduleShiftInfo> scheduleShiftList = null;
        ArrayList<ScheduleShiftInfo> allScheduleShiftList = null;
        for (Map.Entry<String, AttendanceFileInfo> atsFileEntry : atsFileHisMap.entrySet()) {
            String key = atsFileEntry.getKey();
            atsFileInfo = atsFileEntry.getValue();
            if (atsFileInfo == null || null == atsFileInfo.getIsAttendance() || null == atsFileInfo.getAttendFileState()) continue;
            if (atsFileInfo.getIsAttendance().getValue().equals("1")) {
                attencePolicyInfo = atsFileInfo.getAttencePolicy();
                if (null != attencePolicyInfo) {
                    scheduleShiftInfo = AtsScheduleShiftUtil.getScheduleShiftList(shiftPersonMap, shiftAdminOrgMap, shiftGroupMap, attencePolicyInfo, key);
                }
            } else {
                ScheduleShiftInfo scheduleShiftInfo2 = scheduleShiftInfo = null != shiftPersonMap ? shiftPersonMap.get(key) : null;
            }
            if (atsFileInfo.getAttendFileState() == AttendFileStateEnum.enable && null != scheduleShiftInfo) {
                scheduleShiftList = new ArrayList<ScheduleShiftInfo>();
                scheduleShiftList.add(scheduleShiftInfo);
                retMap.put(key, scheduleShiftList);
            }
            if (null == scheduleShiftInfo) continue;
            allScheduleShiftList = new ArrayList<ScheduleShiftInfo>();
            allScheduleShiftList.add(scheduleShiftInfo);
            allRetMap.put(key, scheduleShiftList);
        }
        globalMap.put("T_HR_ATS_ScheduleShift", retMap);
        globalMap.put("ALL_T_HR_ATS_ScheduleShift", allRetMap);
    }

    private static List<ScheduleShiftInfo> getScheduleShiftList(Context ctx, Map<String, AttendanceFileInfo> atsFileHisMap, String personIds, String beginDate, String endDate) {
        ArrayList<ScheduleShiftInfo> retValue = null;
        if (null == atsFileHisMap || atsFileHisMap.size() <= 0) {
            return retValue;
        }
        Map<String, ScheduleShiftInfo> shiftPersonMap = AtsScheduleShiftUtil.getScheduleShiftForPersonByOql(ctx, personIds, beginDate, endDate);
        Map<String, ScheduleShiftInfo> shiftAdminOrgMap = AtsScheduleShiftUtil.getScheduleShiftForAdminOrg(ctx, personIds, beginDate, endDate);
        Map<String, ScheduleShiftInfo> shiftGroupMap = AtsScheduleShiftUtil.getScheduleShiftForGroup(ctx, personIds, beginDate, endDate);
        if (shiftPersonMap == null && shiftAdminOrgMap == null && shiftGroupMap == null) {
            return retValue;
        }
        AttencePolicyInfo attencePolicyInfo = null;
        retValue = new ArrayList<ScheduleShiftInfo>();
        ScheduleShiftInfo scheduleShiftInfo = null;
        AttendanceFileInfo atsFile = null;
        Boolean isEnableATS_MDKPB = null;
        for (Map.Entry<String, AttendanceFileInfo> atsFileEntry : atsFileHisMap.entrySet()) {
            String key = atsFileEntry.getKey();
            atsFile = atsFileEntry.getValue();
            if (null == atsFile || null == atsFile.getIsAttendance()) continue;
            if (atsFile.getIsAttendance().getValue().equals("1")) {
                attencePolicyInfo = atsFile.getAttencePolicy();
                if (attencePolicyInfo != null) {
                    scheduleShiftInfo = AtsScheduleShiftUtil.getScheduleShiftList(shiftPersonMap, shiftAdminOrgMap, shiftGroupMap, attencePolicyInfo, key);
                }
            } else if (null != shiftPersonMap && null != shiftPersonMap.get(key)) {
                if (null == isEnableATS_MDKPB) {
                    isEnableATS_MDKPB = AtsIntelligentUtil.isEnableATS_MDKPB(ctx);
                }
                if (isEnableATS_MDKPB.booleanValue()) {
                    scheduleShiftInfo = shiftPersonMap.get(key);
                }
            }
            if (null == scheduleShiftInfo) continue;
            retValue.add(scheduleShiftInfo);
        }
        return retValue;
    }

    private static ScheduleShiftCollection getScheduleShiftColl(Context ctx, Map<String, AttendanceFileInfo> atsFileHisMap, String personIds, String beginDate, String endDate) {
        ScheduleShiftCollection retValue = null;
        if (null == atsFileHisMap || atsFileHisMap.size() <= 0) {
            return retValue;
        }
        Map<String, ScheduleShiftInfo> shiftPersonMap = AtsScheduleShiftUtil.getScheduleShiftForPersonByOql(ctx, personIds, beginDate, endDate);
        Map<String, ScheduleShiftInfo> shiftAdminOrgMap = AtsScheduleShiftUtil.getScheduleShiftForAdminOrg(ctx, personIds, beginDate, endDate);
        Map<String, ScheduleShiftInfo> shiftGroupMap = AtsScheduleShiftUtil.getScheduleShiftForGroup(ctx, personIds, beginDate, endDate);
        if (shiftPersonMap == null && shiftAdminOrgMap == null && shiftGroupMap == null) {
            return retValue;
        }
        AttencePolicyInfo attencePolicyInfo = null;
        retValue = new ScheduleShiftCollection();
        ScheduleShiftInfo scheduleShiftInfo = null;
        AttendanceFileInfo atsFile = null;
        Boolean isEnableATS_MDKPB = null;
        for (Map.Entry<String, AttendanceFileInfo> atsFileEntry : atsFileHisMap.entrySet()) {
            String key = atsFileEntry.getKey();
            atsFile = atsFileEntry.getValue();
            if (null == atsFile || null == atsFile.getIsAttendance()) continue;
            if (atsFile.getIsAttendance().getValue().equals("1")) {
                attencePolicyInfo = atsFile.getAttencePolicy();
                if (null != attencePolicyInfo) {
                    scheduleShiftInfo = AtsScheduleShiftUtil.getScheduleShiftList(shiftPersonMap, shiftAdminOrgMap, shiftGroupMap, attencePolicyInfo, key);
                }
            } else if (null != shiftPersonMap && null != shiftPersonMap.get(key)) {
                if (null == isEnableATS_MDKPB) {
                    isEnableATS_MDKPB = AtsIntelligentUtil.isEnableATS_MDKPB(ctx);
                }
                if (isEnableATS_MDKPB.booleanValue()) {
                    scheduleShiftInfo = shiftPersonMap.get(key);
                }
            }
            if (null == scheduleShiftInfo) continue;
            retValue.add(scheduleShiftInfo);
        }
        return retValue;
    }

    private static ScheduleShiftInfo getScheduleShiftList(Map<String, ScheduleShiftInfo> shiftPersonMap, Map<String, ScheduleShiftInfo> shiftAdminOrgMap, Map<String, ScheduleShiftInfo> shiftGroupMap, AttencePolicyInfo attencePolicyInfo, String key) {
        ScheduleShiftInfo scheduleShiftInfo = null;
        if (null != attencePolicyInfo) {
            AtsShiftPriorityType thirdShiftPriority;
            AtsShiftPriorityType secondShiftPriority;
            AtsShiftPriorityType firstShiftPriority = attencePolicyInfo.getFirstShiftPriority();
            if (null != firstShiftPriority) {
                if ("1".equals(firstShiftPriority.getValue())) {
                    scheduleShiftInfo = null == shiftPersonMap ? null : shiftPersonMap.get(key);
                } else if ("2".equals(firstShiftPriority.getValue())) {
                    scheduleShiftInfo = null == shiftGroupMap ? null : shiftGroupMap.get(key);
                } else if ("3".equals(firstShiftPriority.getValue())) {
                    ScheduleShiftInfo scheduleShiftInfo2 = scheduleShiftInfo = null == shiftAdminOrgMap ? null : shiftAdminOrgMap.get(key);
                }
            }
            if (null == scheduleShiftInfo && null != (secondShiftPriority = attencePolicyInfo.getSecondShiftPriority())) {
                if ("1".equals(secondShiftPriority.getValue())) {
                    scheduleShiftInfo = null == shiftPersonMap ? null : shiftPersonMap.get(key);
                } else if ("2".equals(secondShiftPriority.getValue())) {
                    scheduleShiftInfo = null == shiftGroupMap ? null : shiftGroupMap.get(key);
                } else if ("3".equals(secondShiftPriority.getValue())) {
                    ScheduleShiftInfo scheduleShiftInfo3 = scheduleShiftInfo = null == shiftAdminOrgMap ? null : shiftAdminOrgMap.get(key);
                }
            }
            if (null == scheduleShiftInfo && null != (thirdShiftPriority = attencePolicyInfo.getThirdShiftPriority())) {
                if ("1".equals(thirdShiftPriority.getValue())) {
                    scheduleShiftInfo = null == shiftPersonMap ? null : shiftPersonMap.get(key);
                } else if ("2".equals(thirdShiftPriority.getValue())) {
                    scheduleShiftInfo = null == shiftGroupMap ? null : shiftGroupMap.get(key);
                } else if ("3".equals(thirdShiftPriority.getValue())) {
                    ScheduleShiftInfo scheduleShiftInfo4 = scheduleShiftInfo = null == shiftAdminOrgMap ? null : shiftAdminOrgMap.get(key);
                }
            }
        }
        if (null == scheduleShiftInfo) {
            ScheduleShiftInfo scheduleShiftInfo5 = scheduleShiftInfo = null == shiftPersonMap ? null : shiftPersonMap.get(key);
            if (null == scheduleShiftInfo) {
                ScheduleShiftInfo scheduleShiftInfo6 = scheduleShiftInfo = null == shiftGroupMap ? null : shiftGroupMap.get(key);
            }
            if (null == scheduleShiftInfo) {
                scheduleShiftInfo = null == shiftAdminOrgMap ? null : shiftAdminOrgMap.get(key);
            }
        }
        return scheduleShiftInfo;
    }

    private static Map<String, ScheduleShiftInfo> getScheduleShiftForPerson(Context ctx, String personIds, String beginDate, String endDate) {
        HashMap<String, ScheduleShiftInfo> resMap = new HashMap<String, ScheduleShiftInfo>();
        StringBuffer personOql = new StringBuffer();
        personOql.append(" select id,attendDate,standardHour,dayType,isHalfDay,attendPolicy.id,defaultShift.id,defaultShift.name,defaultShift.simpleName,cardRule.id,cardRule.startNum,cardRule.endNum, ").append(" otCompens.id,shiftType.id, proposer.id,adminOrgUnit.id,position.id,hrOrgUnit.id,").append(" isElastic,elasticType,elasticDirection,elasticValue, ").append(" items.id,items.segmentInRest,items.segment,items.preTime, ").append(" items.preDateTime,items.preTimeDayType,items.restPreTime,items.restNextTime,items.restPreDateTime,items.restNextDateTime, ").append(" items.preFloatAdjusted,items.preIsPunchCard,items.nextTime,items.nextDateTime,items.nextTimeDayType,items.nextFloatAdjusted, ").append(" items.nextIsPunchCard,items.attendanceType,  ").append(" matchDaytype,matchShift.id,matchShift.standardHour,matchShift.isHalfDay,matchShift.name,matchShift.simpleName,matchShift.otCompens.id,matchShift.shiftType.id, ").append(" matchShift.cardRule.id,matchShift.cardRule.startNum,matchShift.cardRule.endNum, ").append(" matchShift.isElastic, matchShift.elasticType, matchShift.elasticDirection, matchShift.elasticValue ").append(" where 1=1  ");
        if (personIds.split(",").length == 1) {
            if (!personIds.contains("'")) {
                personIds = "'" + personIds + "'";
            }
            personOql.append(" and proposer = " + personIds + " ");
        } else {
            if (!personIds.contains("'")) {
                personIds = AtsUtil.getStrFromStringArr(personIds.split(","));
            }
            personOql.append(" and proposer in (" + personIds + ") ");
        }
        if (beginDate.equals(endDate)) {
            if (beginDate.contains("'")) {
                personOql.append(" and attendDate = {TS " + beginDate + "} ");
            } else {
                personOql.append(" and attendDate = {TS '" + beginDate + "'} ");
            }
        } else if (beginDate.contains("'")) {
            personOql.append(" and attendDate >= {TS " + beginDate + "} and  attendDate <= {TS " + endDate + "}");
        } else {
            personOql.append(" and attendDate >= {TS '" + beginDate + "'} and  attendDate <= {TS '" + endDate + "'}");
        }
        personOql.append(" order by attendDate, items.segment asc  ");
        ScheduleShiftCollection personColl = null;
        try {
            personColl = ScheduleShiftFactory.getLocalInstance(ctx).getScheduleShiftCollection(personOql.toString());
            if (null != personColl) {
                ScheduleShiftInfo scheduleShiftInfo = null;
                int size = personColl.size();
                for (int j = 0; j < size; ++j) {
                    scheduleShiftInfo = personColl.get(j);
                    java.util.Date attendDate = scheduleShiftInfo.getAttendDate();
                    String personid = scheduleShiftInfo.getProposer().getId().toString();
                    String attendDateStr = AtsDateUtils.dateShortToString(attendDate);
                    String key = AtsScheduleShiftUtil.getKey(personid, attendDateStr);
                    if (null == scheduleShiftInfo.getDefaultShift() && scheduleShiftInfo.getDayType().getValue() == 0) {
                        AtsScheduleShiftUtil.setMatchShift(ctx, scheduleShiftInfo, attendDate, attendDateStr);
                    }
                    resMap.put(key, scheduleShiftInfo);
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return resMap;
    }

    public static Map<String, ScheduleShiftInfo> getScheduleShiftForPersonByOql(Context ctx, String personIds, String beginDate, String endDate) {
        HashMap<String, ScheduleShiftInfo> resMap = null;
        try {
            EntityViewInfo evi = new EntityViewInfo();
            evi.setSelector(AtsScheduleShiftUtil.getScheduleShiftSelector());
            FilterInfo fi = new FilterInfo();
            personIds = personIds.replaceAll("'", "");
            beginDate = beginDate.replaceAll("'", "");
            endDate = endDate.replaceAll("'", "");
            if (personIds.split(",").length == 1) {
                fi.getFilterItems().add(new FilterItemInfo("proposer.id", (Object)personIds, CompareType.EQUALS));
            } else {
                fi.getFilterItems().add(new FilterItemInfo("proposer.id", AtsUtil.getSetFromStringArr(personIds.split(",")), CompareType.INCLUDE));
            }
            if (beginDate.equals(endDate)) {
                fi.getFilterItems().add(new FilterItemInfo("attendDate", (Object)new Date(AtsDateUtils.stringToShortDate(beginDate).getTime()), CompareType.EQUALS));
            } else {
                fi.getFilterItems().add(new FilterItemInfo("attendDate", (Object)beginDate, CompareType.GREATER_EQUALS));
                fi.getFilterItems().add(new FilterItemInfo("attendDate", (Object)endDate, CompareType.LESS_EQUALS));
            }
            evi.setFilter(fi);
            HashMap<ScheduleShiftInfo, String> matchShiftMap = new HashMap<ScheduleShiftInfo, String>();
            HashSet<String> matchShiftIds = new HashSet<String>();
            ScheduleShiftCollection personColl = ScheduleShiftFactory.getLocalInstance(ctx).getScheduleShiftCollection(evi);
            if (null != personColl) {
                resMap = new HashMap<String, ScheduleShiftInfo>();
                ScheduleShiftInfo scheduleShiftInfo = null;
                int size = personColl.size();
                for (int j = 0; j < size; ++j) {
                    scheduleShiftInfo = personColl.get(j);
                    java.util.Date attendDate = scheduleShiftInfo.getAttendDate();
                    String personid = scheduleShiftInfo.getProposer().getId().toString();
                    String attendDateStr = AtsDateUtils.dateShortToString(attendDate);
                    String key = AtsScheduleShiftUtil.getKey(personid, attendDateStr);
                    try {
                        if (null == scheduleShiftInfo.getDefaultShift() && scheduleShiftInfo.getDayType().getValue() == 0) {
                            scheduleShiftInfo.setDayType(scheduleShiftInfo.getMatchDaytype());
                            if (null != scheduleShiftInfo.getMatchShift() && scheduleShiftInfo.getMatchShift().getId() != null) {
                                matchShiftMap.put(scheduleShiftInfo, scheduleShiftInfo.getMatchShift().getId().toString());
                                matchShiftIds.add(scheduleShiftInfo.getMatchShift().getId().toString());
                            }
                        }
                        if (null != scheduleShiftInfo.getItems() && scheduleShiftInfo.getItems().size() > 0) {
                            scheduleShiftInfo.getItems().sort("segment");
                        }
                        resMap.put(key, scheduleShiftInfo);
                        continue;
                    }
                    catch (Exception e) {
                        logger.error((Object)("wrap person schedule info fail prsonID_date:" + key));
                        e.printStackTrace();
                    }
                }
            }
            AtsScheduleShiftUtil.setMatchShift(ctx, matchShiftMap, matchShiftIds);
        }
        catch (Exception e) {
            logger.error((Object)("query staff schedule info faile\uff01personIds:" + personIds + ",beginDate:" + beginDate + ",endDate" + endDate));
            e.printStackTrace();
        }
        return resMap;
    }

    public static Map<String, ScheduleShiftInfo> getScheduleShiftForGroup(Context ctx, String personIds, String beginDate, String endDate) {
        StringBuffer groupShiftSql = new StringBuffer();
        groupShiftSql.append(" SELECT TMP.*,FILEHIS.FATTADMINORGUNITID AS FADMINORGUNITID , FILEHIS.FPOSITIONID, FILEHIS.FHRORGUNITID FROM ( ").append(" SELECT SHIFTORG.FID ID,DATESET.FDATE AS attendDate, ").append(" MASTER_TABLE.FPROPOSERID , ").append(" SHIFTORG.FDAYTYPE AS dayType,SHIFTORG.FstandardHour standardHour,SHIFTORG.FDefaultShiftID,atsShift.FName" + MLUtile.getMlFlag(ctx) + " defaultShiftName,atsShift.FSimpleName simpleName,atsShift.Fnumber shiftNumber,SHIFTORG.FCardRuleID,").append(" SHIFTORG.FOtCompensID,SHIFTORG.FShiftTypeID,SHIFTORG.FisElastic,SHIFTORG.FelasticType,atsShift.FisHalfDay,").append(" SHIFTORG.FelasticDirection,SHIFTORG.FelasticValue,SHIFTORG.FHRORGUNITID, ").append(" SHIFTORGITEM.FID AS SHIFTORGITEMID,SHIFTORGITEM.FSHIFTITEMID AS SHIFTITEMID,SHIFTORGITEM.FSegmentInRest,SHIFTORGITEM.FSegment,SHIFTORGITEM.FPreTime, ").append(" SHIFTORGITEM.FPreDateTime,SHIFTORGITEM.FPreTimeDayType,SHIFTORGITEM.FRestPreTime , SHIFTORGITEM.FRestNextTime,SHIFTORGITEM.FRestPreDateTime, SHIFTORGITEM.FRestNextDateTime, ").append(" SHIFTORGITEM.FpreFloatAdjusted,SHIFTORGITEM.FpreIsPunchCard,SHIFTORGITEM.FnextTime,SHIFTORGITEM.FnextDateTime,SHIFTORGITEM.FnextTimeDayType,SHIFTORGITEM.FnextFloatAdjusted, ").append(" SHIFTORGITEM.FnextIsPunchCard,SHIFTORGITEM.FattendanceType, ").append(" cardRule.FStartNum startNum,cardRule.FEndNum endNum ").append(" FROM T_HR_ATS_DATESET DATESET ").append(" INNER JOIN T_HR_ATS_AttenceGroupItem MASTER_TABLE ON  DATESET.FDATE >= MASTER_TABLE.FSTARTTIME AND DATESET.FDATE <= MASTER_TABLE.FENDTIME ").append(" INNER JOIN  T_ATS_AttendanceGroupShift SHIFTORG ON DATESET.FDATE = SHIFTORG.FATTENDDATE AND MASTER_TABLE.FGROUPID  = SHIFTORG.FAttenceGroupID ").append(" LEFT JOIN T_HR_ATS_Shift atsShift on SHIFTORG.FDefaultShiftID = atsShift.FID ").append(" LEFT JOIN  T_ATS_AttendanceGroupShiftItem SHIFTORGITEM ON SHIFTORGITEM.FGroupID = SHIFTORG.FID ").append(" LEFT JOIN T_HR_ATS_CardRule cardRule on SHIFTORG.FCardRuleID = cardRule.FID WHERE 1=1 ");
        ArrayList<Object> params = new ArrayList<Object>();
        personIds = personIds.replaceAll("'", "");
        beginDate = beginDate.replaceAll("'", "");
        endDate = endDate.replaceAll("'", "");
        if (personIds.split(",").length == 1) {
            groupShiftSql.append(" AND MASTER_TABLE.FPROPOSERID  = ? ");
            params.add(personIds);
        } else {
            groupShiftSql.append(" AND MASTER_TABLE.FPROPOSERID  IN ( ");
            String[] personParam = personIds.split(",");
            for (int i = 0; i < personParam.length; ++i) {
                if (i > 0) {
                    groupShiftSql.append(",");
                }
                groupShiftSql.append("?");
                params.add(personParam[i]);
            }
            groupShiftSql.append(")");
        }
        if (beginDate.equals(endDate)) {
            groupShiftSql.append(" and DATESET.FDATE = ? ");
            params.add(new Timestamp(AtsDateUtils.stringToShortDate(beginDate).getTime()));
        } else {
            groupShiftSql.append(" and DATESET.FDATE >= ? and  DATESET.FDATE <= ? ");
            params.add(new Timestamp(AtsDateUtils.stringToShortDate(beginDate).getTime()));
            params.add(new Timestamp(AtsDateUtils.stringToShortDate(endDate).getTime()));
        }
        groupShiftSql.append(" ) TMP INner join T_HR_ATS_ATTENDANCEFILEHIS FILEHIS ").append(" ON  TMP.attendDate >= FILEHIS.FEFFDT AND TMP.attendDate <= FILEHIS.FLEFFDT AND TMP.FPROPOSERID = FILEHIS.FPROPOSERID and TMP.FHRORGUNITID= FILEHIS.FHRORGUNITID ");
        Map<String, ScheduleShiftInfo> resMap = AtsScheduleShiftUtil.getAtsShiftData(ctx, groupShiftSql, params.toArray());
        return resMap;
    }

    public static Map<String, ScheduleShiftInfo> getScheduleShiftForAdminOrg(Context ctx, String personIds, String beginDate, String endDate) {
        StringBuffer orgShiftOql = new StringBuffer();
        orgShiftOql.append(" SELECT SHIFTORG.FID ID,DATESET.FDATE AS attendDate,SHIFTORG.FDAYTYPE AS dayType, ").append(" MASTER_TABLE.FPROPOSERID , MASTER_TABLE.FATTADMINORGUNITID AS FADMINORGUNITID , MASTER_TABLE.FPOSITIONID, MASTER_TABLE.FHRORGUNITID, ").append(" SHIFTORG.FstandardHour standardHour,SHIFTORG.FAtsShiftID FDefaultShiftID,atsShift.FName" + MLUtile.getMlFlag(ctx) + " defaultShiftName,atsShift.FSimpleName simpleName,atsShift.Fnumber shiftNumber,SHIFTORG.FCardRuleID, ").append(" SHIFTORG.FOtCompensID,SHIFTORG.FShiftTypeID,SHIFTORG.FisElastic,SHIFTORG.FelasticType ,SHIFTORG.FelasticDirection,SHIFTORG.FelasticValue,SHIFTORG.FisHalfDay, ").append(" SHIFTORGITEM.FID AS SHIFTORGITEMID,SHIFTORGITEM.FSHIFTITEMID AS SHIFTITEMID,SHIFTORGITEM.FSegmentInRest,SHIFTORGITEM.FSegment,SHIFTORGITEM.FPreTime, ").append(" SHIFTORGITEM.FPreDateTime,SHIFTORGITEM.FPreTimeDayType,SHIFTORGITEM.FRestPreTime , SHIFTORGITEM.FRestNextTime,SHIFTORGITEM.FRestPreDateTime,").append(" SHIFTORGITEM.FRestNextDateTime,SHIFTORGITEM.FpreFloatAdjusted,SHIFTORGITEM.FpreIsPunchCard,SHIFTORGITEM.FnextTime,SHIFTORGITEM.FnextDateTime, ").append(" SHIFTORGITEM.FnextTimeDayType,SHIFTORGITEM.FnextFloatAdjusted,SHIFTORGITEM.FnextIsPunchCard,SHIFTORGITEM.FattendanceType, ").append(" cardRule.FStartNum startNum,cardRule.FEndNum endNum ").append(" FROM T_HR_ATS_DATESET DATESET ").append(" INNER JOIN T_HR_ATS_ATTENDANCEFILEHIS MASTER_TABLE ON  DATESET.FDATE >= MASTER_TABLE.FEFFDT AND DATESET.FDATE <= MASTER_TABLE.FLEFFDT ").append(" INNER JOIN  T_ATS_AtsShiftAdminOrg SHIFTORG ON DATESET.FDATE = SHIFTORG.FAttendDate AND MASTER_TABLE.FADMINORGUNITID = SHIFTORG.FADMINORGUNITID ").append(" LEFT JOIN T_HR_ATS_Shift atsShift on SHIFTORG.FAtsShiftID = atsShift.FID ").append(" LEFT JOIN  T_HR_ATS_AtsShiftAdminOrgItem SHIFTORGITEM ON SHIFTORGITEM.FGroupID = SHIFTORG.FID ").append(" LEFT JOIN T_HR_ATS_CardRule cardRule on SHIFTORG.FCardRuleID = cardRule.FID WHERE 1=1 ");
        ArrayList<Object> params = new ArrayList<Object>();
        personIds = personIds.replaceAll("'", "");
        beginDate = beginDate.replaceAll("'", "");
        endDate = endDate.replaceAll("'", "");
        if (personIds.split(",").length == 1) {
            orgShiftOql.append(" AND MASTER_TABLE.FPROPOSERID  = ? ");
            params.add(personIds);
        } else {
            orgShiftOql.append(" AND MASTER_TABLE.FPROPOSERID  IN ( ");
            String[] personParam = personIds.split(",");
            for (int i = 0; i < personParam.length; ++i) {
                if (i > 0) {
                    orgShiftOql.append(",");
                }
                orgShiftOql.append("?");
                params.add(personParam[i]);
            }
            orgShiftOql.append(")");
        }
        if (beginDate.equals(endDate)) {
            orgShiftOql.append(" and DATESET.FDATE = ? ");
            params.add(new Timestamp(AtsDateUtils.stringToShortDate(beginDate).getTime()));
        } else {
            orgShiftOql.append(" and DATESET.FDATE >= ? and  DATESET.FDATE <= ? ");
            params.add(new Timestamp(AtsDateUtils.stringToShortDate(beginDate).getTime()));
            params.add(new Timestamp(AtsDateUtils.stringToShortDate(endDate).getTime()));
        }
        Map<String, ScheduleShiftInfo> resMap = AtsScheduleShiftUtil.getAtsShiftData(ctx, orgShiftOql, params.toArray());
        return resMap;
    }

    private static Map<String, ScheduleShiftInfo> getAtsShiftData(Context ctx, StringBuffer sql, Object[] params) {
        IRowSet rs = null;
        HashMap<String, ScheduleShiftInfo> shiftMap = null;
        try {
            rs = DbUtil.executeQuery((Context)ctx, (String)sql.toString(), (Object[])params);
            if (rs != null) {
                shiftMap = new HashMap<String, ScheduleShiftInfo>();
                ScheduleShiftInfo scheduleShiftInfo = null;
                while (rs.next()) {
                    String key = AtsScheduleShiftUtil.getKey(rs.getString("FPROPOSERID"), AtsDateUtils.dateShortToString(rs.getDate("attendDate")));
                    scheduleShiftInfo = (ScheduleShiftInfo)shiftMap.get(key);
                    try {
                        if (null == scheduleShiftInfo) {
                            scheduleShiftInfo = AtsScheduleShiftUtil.setScheduleShiftInfo(rs);
                        }
                        if (StringUtils.isNotEmpty((String)rs.getString("FDefaultShiftID"))) {
                            scheduleShiftInfo.getItems().add(AtsScheduleShiftUtil.getScheduleShiftItem(rs));
                            scheduleShiftInfo.getItems().sort("segment");
                        } else {
                            scheduleShiftInfo.setDefaultShift(null);
                        }
                        if (shiftMap.containsKey(key)) continue;
                        if (null != scheduleShiftInfo.getItems() && scheduleShiftInfo.getItems().size() > 0) {
                            scheduleShiftInfo.getItems().sort("segment");
                        }
                        shiftMap.put(key, scheduleShiftInfo);
                    }
                    catch (Exception e) {
                        logger.error((Object)("wrap shift item info fail\uff01person ID_date:" + key + ",query sql:" + sql + "params:" + params));
                        e.printStackTrace();
                    }
                }
            }
        }
        catch (Exception e) {
            logger.error((Object)("query shedule info fail\uff01query sql:" + sql + "params:" + params));
            e.printStackTrace();
        }
        return shiftMap;
    }

    private static SelectorItemCollection getScheduleShiftSelector() {
        SelectorItemCollection selectColl = new SelectorItemCollection();
        selectColl.add(new SelectorItemInfo("id"));
        selectColl.add(new SelectorItemInfo("attendDate"));
        selectColl.add(new SelectorItemInfo("standardHour"));
        selectColl.add(new SelectorItemInfo("dayType"));
        selectColl.add(new SelectorItemInfo("isHalfDay"));
        selectColl.add(new SelectorItemInfo("isElastic"));
        selectColl.add(new SelectorItemInfo("elasticType"));
        selectColl.add(new SelectorItemInfo("elasticDirection"));
        selectColl.add(new SelectorItemInfo("elasticValue"));
        selectColl.add(new SelectorItemInfo("matchDaytype"));
        selectColl.add(new SelectorItemInfo("matchShift.id"));
        selectColl.add(new SelectorItemInfo("attendPolicy.id"));
        selectColl.add(new SelectorItemInfo("defaultShift.id"));
        selectColl.add(new SelectorItemInfo("defaultShift.name"));
        selectColl.add(new SelectorItemInfo("defaultShift.number"));
        selectColl.add(new SelectorItemInfo("defaultShift.simpleName"));
        selectColl.add(new SelectorItemInfo("cardRule.id"));
        selectColl.add(new SelectorItemInfo("cardRule.startNum"));
        selectColl.add(new SelectorItemInfo("cardRule.endNum"));
        selectColl.add(new SelectorItemInfo("otCompens.id"));
        selectColl.add(new SelectorItemInfo("shiftType.id"));
        selectColl.add(new SelectorItemInfo("proposer.id"));
        selectColl.add(new SelectorItemInfo("adminOrgUnit.id"));
        selectColl.add(new SelectorItemInfo("position.id"));
        selectColl.add(new SelectorItemInfo("hrOrgUnit.id"));
        selectColl.add(new SelectorItemInfo("items.id"));
        selectColl.add(new SelectorItemInfo("items.segmentInRest"));
        selectColl.add(new SelectorItemInfo("items.segment"));
        selectColl.add(new SelectorItemInfo("items.preTime"));
        selectColl.add(new SelectorItemInfo("items.preDateTime"));
        selectColl.add(new SelectorItemInfo("items.preTimeDayType"));
        selectColl.add(new SelectorItemInfo("items.restPreTime"));
        selectColl.add(new SelectorItemInfo("items.restNextTime"));
        selectColl.add(new SelectorItemInfo("items.restPreDateTime"));
        selectColl.add(new SelectorItemInfo("items.restNextDateTime"));
        selectColl.add(new SelectorItemInfo("items.preFloatAdjusted"));
        selectColl.add(new SelectorItemInfo("items.preIsPunchCard"));
        selectColl.add(new SelectorItemInfo("items.nextTime"));
        selectColl.add(new SelectorItemInfo("items.nextDateTime"));
        selectColl.add(new SelectorItemInfo("items.nextTimeDayType"));
        selectColl.add(new SelectorItemInfo("items.nextFloatAdjusted"));
        selectColl.add(new SelectorItemInfo("items.nextIsPunchCard"));
        selectColl.add(new SelectorItemInfo("items.attendanceType"));
        selectColl.add(new SelectorItemInfo("items.attAdminOrgUnit.id"));
        selectColl.add(new SelectorItemInfo("items.attAdminOrgUnit.name"));
        selectColl.add(new SelectorItemInfo("items.itemSrcType"));
        return selectColl;
    }

    private static ScheduleShiftInfo setScheduleShiftInfo(IRowSet rs) {
        ScheduleShiftInfo scheduleShiftInfo = null;
        try {
            scheduleShiftInfo = new ScheduleShiftInfo();
            scheduleShiftInfo.setAttendDate(rs.getDate("attendDate"));
            scheduleShiftInfo.setStandardHour(rs.getBigDecimal("standardHour"));
            if (StringUtils.isNotEmpty((String)rs.getString("dayType"))) {
                scheduleShiftInfo.setDayType(DayTypeEnum.getEnum(rs.getInt("dayType")));
            }
            CardRuleInfo cardRuleInfo = new CardRuleInfo();
            if (StringUtils.isNotEmpty((String)rs.getString("FCardRuleID"))) {
                cardRuleInfo.setId(BOSUuid.read((String)rs.getString("FCardRuleID")));
            }
            cardRuleInfo.setStartNum(rs.getBigDecimal("startNum"));
            cardRuleInfo.setEndNum(rs.getBigDecimal("endNum"));
            scheduleShiftInfo.setCardRule(cardRuleInfo);
            OverTimeCompensInfo otCompensInfo = new OverTimeCompensInfo();
            if (StringUtils.isNotEmpty((String)rs.getString("FOtCompensID"))) {
                otCompensInfo.setId(BOSUuid.read((String)rs.getString("FOtCompensID")));
            }
            scheduleShiftInfo.setOtCompens(otCompensInfo);
            AtsShiftTypeInfo atsShiftTypeInfo = new AtsShiftTypeInfo();
            if (StringUtils.isNotEmpty((String)rs.getString("FShiftTypeID"))) {
                atsShiftTypeInfo.setId(BOSUuid.read((String)rs.getString("FShiftTypeID")));
            }
            scheduleShiftInfo.setShiftType(atsShiftTypeInfo);
            PersonInfo personInfo = new PersonInfo();
            if (StringUtils.isNotEmpty((String)rs.getString("FPROPOSERID"))) {
                personInfo.setId(BOSUuid.read((String)rs.getString("FPROPOSERID")));
            }
            scheduleShiftInfo.setProposer(personInfo);
            AdminOrgUnitInfo adminOrgUnit = new AdminOrgUnitInfo();
            if (StringUtils.isNotEmpty((String)rs.getString("FADMINORGUNITID"))) {
                adminOrgUnit.setId(BOSUuid.read((String)rs.getString("FADMINORGUNITID")));
            }
            scheduleShiftInfo.setAdminOrgUnit(adminOrgUnit);
            PositionInfo positionInfo = new PositionInfo();
            if (StringUtils.isNotEmpty((String)rs.getString("FPOSITIONID"))) {
                positionInfo.setId(BOSUuid.read((String)rs.getString("FPOSITIONID")));
            }
            scheduleShiftInfo.setPosition(positionInfo);
            HROrgUnitInfo hrOrgUnit = new HROrgUnitInfo();
            if (StringUtils.isNotEmpty((String)rs.getString("FHRORGUNITID"))) {
                hrOrgUnit.setId(BOSUuid.read((String)rs.getString("FHRORGUNITID")));
            }
            scheduleShiftInfo.setHrOrgUnit(hrOrgUnit);
            scheduleShiftInfo.setIsHalfDay(rs.getBoolean("FisHalfDay"));
            AtsShiftInfo atsShiftInfo = new AtsShiftInfo();
            if (StringUtils.isNotEmpty((String)rs.getString("FDefaultShiftID"))) {
                atsShiftInfo.setId(BOSUuid.read((String)rs.getString("FDefaultShiftID")));
            }
            atsShiftInfo.setName(rs.getString("defaultShiftName"));
            atsShiftInfo.setSimpleName(rs.getString("simpleName"));
            atsShiftInfo.setNumber(rs.getString("shiftNumber"));
            scheduleShiftInfo.setDefaultShift(atsShiftInfo);
            scheduleShiftInfo.setIsElastic(rs.getBoolean("FisElastic"));
            if (StringUtils.isNotEmpty((String)rs.getString("FelasticType"))) {
                scheduleShiftInfo.setElasticType(AtsShiftElasticType.getEnum(rs.getInt("FelasticType")));
            }
            if (StringUtils.isNotEmpty((String)rs.getString("FelasticDirection"))) {
                scheduleShiftInfo.setElasticDirection(AtsShiftElasticDirection.getEnum(rs.getInt("FelasticDirection")));
            }
            scheduleShiftInfo.setElasticValue(rs.getBigDecimal("FelasticValue"));
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return scheduleShiftInfo;
    }

    private static ScheduleShiftItemInfo getScheduleShiftItem(IRowSet rs) throws SQLException {
        ScheduleShiftItemInfo scheduleShiftItem = null;
        try {
            scheduleShiftItem = new ScheduleShiftItemInfo();
            if (StringUtils.isNotEmpty((String)rs.getString("SHIFTORGITEMID"))) {
                scheduleShiftItem.setId(BOSUuid.read((String)rs.getString("SHIFTORGITEMID")));
                AtsShiftItemInfo atsShiftItemInfo = new AtsShiftItemInfo();
                if (StringUtils.isNotEmpty((String)rs.getString("SHIFTITEMID"))) {
                    atsShiftItemInfo.setId(BOSUuid.read((String)rs.getString("SHIFTITEMID")));
                }
                scheduleShiftItem.setShiftItem(atsShiftItemInfo);
            }
            scheduleShiftItem.setSegmentInRest(rs.getBigDecimal("FSegmentInRest"));
            scheduleShiftItem.setPreTime(rs.getString("FPreTime"));
            scheduleShiftItem.setPreDateTime(rs.getTimestamp("FPreDateTime"));
            scheduleShiftItem.setRestPreTime(rs.getString("FRestPreTime"));
            scheduleShiftItem.setRestNextTime(rs.getString("FRestNextTime"));
            scheduleShiftItem.setRestPreDateTime(rs.getTimestamp("FRestPreDateTime"));
            scheduleShiftItem.setRestNextDateTime(rs.getTimestamp("FRestNextDateTime"));
            scheduleShiftItem.setPreFloatAdjusted(rs.getBigDecimal("FpreFloatAdjusted"));
            scheduleShiftItem.setNextTime(rs.getString("FnextTime"));
            scheduleShiftItem.setNextDateTime(rs.getTimestamp("FnextDateTime"));
            if (StringUtils.isNotEmpty((String)rs.getString("FSegment"))) {
                scheduleShiftItem.setSegment(SegmentEnum.getEnum(rs.getString("FSegment")));
            }
            if (StringUtils.isNotEmpty((String)rs.getString("FPreTimeDayType"))) {
                scheduleShiftItem.setPreTimeDayType(SegmentUnitEnum.getEnum(rs.getInt("FPreTimeDayType")));
            }
            if (StringUtils.isNotEmpty((String)rs.getString("FpreIsPunchCard"))) {
                scheduleShiftItem.setPreIsPunchCard(SegIsPunchCardEnum.getEnum(rs.getString("FpreIsPunchCard")));
            }
            if (StringUtils.isNotEmpty((String)rs.getString("FnextTimeDayType"))) {
                scheduleShiftItem.setNextTimeDayType(SegmentUnitEnum.getEnum(rs.getInt("FnextTimeDayType")));
            }
            scheduleShiftItem.setNextFloatAdjusted(rs.getBigDecimal("FnextFloatAdjusted"));
            if (StringUtils.isNotEmpty((String)rs.getString("FnextIsPunchCard"))) {
                scheduleShiftItem.setNextIsPunchCard(SegIsPunchCardEnum.getEnum(rs.getString("FnextIsPunchCard")));
            }
            if (StringUtils.isNotEmpty((String)rs.getString("FattendanceType"))) {
                scheduleShiftItem.setAttendanceType(AttendanceTypeEnum.getEnum(rs.getString("FattendanceType")));
            }
        }
        catch (Exception e) {
            logger.error((Object)"wrap shift item info fail\uff01");
            e.printStackTrace();
        }
        return scheduleShiftItem;
    }

    private static void setMatchShift(Context ctx, Map<ScheduleShiftInfo, String> matchShiftMap, Set<String> matchShiftIds) {
        try {
            if (!matchShiftIds.isEmpty()) {
                EntityViewInfo evi = new EntityViewInfo();
                evi.setSelector(AtsScheduleShiftUtil.getMatchShiftSelector());
                FilterInfo fi = new FilterInfo();
                fi.getFilterItems().add(new FilterItemInfo("id", matchShiftIds, CompareType.INCLUDE));
                evi.setFilter(fi);
                SorterItemInfo segmentSort = new SorterItemInfo("items.segment");
                segmentSort.setSortType(SortType.ASCEND);
                evi.getSorter().add(segmentSort);
                AtsShiftCollection atsShiftColl = AtsShiftFactory.getLocalInstance(ctx).getAtsShiftCollection(evi);
                HashMap<String, AtsShiftInfo> matchShiftItemMap = new HashMap<String, AtsShiftInfo>();
                int size = atsShiftColl.size();
                for (int i = 0; i < size; ++i) {
                    AtsShiftInfo matchShift = atsShiftColl.get(i);
                    if (matchShift == null || null == matchShift.getId()) continue;
                    matchShiftItemMap.put(matchShift.getId().toString(), matchShift);
                }
                for (Map.Entry<ScheduleShiftInfo, String> entry : matchShiftMap.entrySet()) {
                    String matchShiftId = entry.getValue();
                    ScheduleShiftInfo scheduleShiftInfo = entry.getKey();
                    AtsShiftInfo matchShift = (AtsShiftInfo)matchShiftItemMap.get(matchShiftId);
                    if (null == matchShift) continue;
                    AtsScheduleShiftUtil.setMatchShiftInfo(scheduleShiftInfo, matchShift);
                    java.util.Date attendDate = scheduleShiftInfo.getAttendDate();
                    ScheduleShiftItemCollection scheduleColl = null;
                    AtsShiftItemCollection atsShiftItemColl = matchShift.getItems();
                    if (atsShiftItemColl == null || atsShiftItemColl.size() <= 0) continue;
                    ScheduleShiftItemInfo shiftItem = null;
                    AtsShiftItemInfo atsShiftItem = null;
                    scheduleColl = new ScheduleShiftItemCollection();
                    Calendar atdtNextDayCal = Calendar.getInstance();
                    atdtNextDayCal.setTimeInMillis(attendDate.getTime() + 86400000L);
                    String atdtNextDayStr = AtsDateUtils.dateShortToString(atdtNextDayCal.getTime());
                    Calendar atdtPreDayCal = Calendar.getInstance();
                    atdtPreDayCal.setTimeInMillis(attendDate.getTime() - 86400000L);
                    String atdtPreDayStr = AtsDateUtils.dateShortToString(atdtPreDayCal.getTime());
                    for (int k = 0; k < atsShiftItemColl.size(); ++k) {
                        atsShiftItem = atsShiftItemColl.get(k);
                        shiftItem = AtsScheduleShiftUtil.getScheduleShiftItem(atsShiftItem, AtsDateUtils.dateShortToString(attendDate), atdtNextDayStr, atdtPreDayStr);
                        scheduleColl.add(shiftItem);
                    }
                    if (null != scheduleColl && scheduleColl.size() > 0) {
                        scheduleColl.sort("segment");
                    }
                    scheduleShiftInfo.put("items", (Object)scheduleColl);
                }
            }
        }
        catch (Exception e) {
            logger.error((Object)("wrap person schedule info fail setMatchShift:" + matchShiftMap.toString()));
            e.printStackTrace();
        }
    }

    private static void setMatchShift(Context ctx, ScheduleShiftInfo scheduleShiftInfo, java.util.Date attendDate, String attendDateStr) {
        try {
            scheduleShiftInfo.setDayType(scheduleShiftInfo.getMatchDaytype());
            if (scheduleShiftInfo.getDayType() != null && null != scheduleShiftInfo.getMatchShift() && scheduleShiftInfo.getMatchShift().getId() != null) {
                EntityViewInfo evi = new EntityViewInfo();
                evi.setSelector(AtsScheduleShiftUtil.getMatchShiftSelector());
                FilterInfo fi = new FilterInfo();
                fi.getFilterItems().add(new FilterItemInfo("id", (Object)scheduleShiftInfo.getMatchShift().getId().toString(), CompareType.EQUALS));
                evi.setFilter(fi);
                SorterItemInfo segmentSort = new SorterItemInfo("items.segment");
                segmentSort.setSortType(SortType.ASCEND);
                evi.getSorter().add(segmentSort);
                AtsShiftCollection atsShiftCollection = AtsShiftFactory.getLocalInstance(ctx).getAtsShiftCollection(evi);
                AtsShiftInfo matchShift = atsShiftCollection.get(0);
                if (matchShift != null) {
                    AtsScheduleShiftUtil.setMatchShiftInfo(scheduleShiftInfo, matchShift);
                    ScheduleShiftItemCollection scheduleColl = null;
                    AtsShiftItemCollection atsShiftItemColl = matchShift.getItems();
                    if (atsShiftItemColl != null && atsShiftItemColl.size() > 0) {
                        ScheduleShiftItemInfo shiftItem = null;
                        AtsShiftItemInfo atsShiftItem = null;
                        scheduleColl = new ScheduleShiftItemCollection();
                        Calendar atdtNextDayCal = Calendar.getInstance();
                        atdtNextDayCal.setTimeInMillis(attendDate.getTime() + 86400000L);
                        String atdtNextDayStr = AtsDateUtils.dateShortToString(atdtNextDayCal.getTime());
                        Calendar atdtPreDayCal = Calendar.getInstance();
                        atdtPreDayCal.setTimeInMillis(attendDate.getTime() - 86400000L);
                        String atdtPreDayStr = AtsDateUtils.dateShortToString(atdtPreDayCal.getTime());
                        for (int k = 0; k < atsShiftItemColl.size(); ++k) {
                            atsShiftItem = atsShiftItemColl.get(k);
                            shiftItem = AtsScheduleShiftUtil.getScheduleShiftItem(atsShiftItem, attendDateStr, atdtNextDayStr, atdtPreDayStr);
                            scheduleColl.add(shiftItem);
                        }
                        scheduleShiftInfo.put("items", (Object)scheduleColl);
                    }
                }
            }
        }
        catch (Exception e) {
            logger.error((Object)("wrap person schedule info fail prsonID_date:" + scheduleShiftInfo.getProposer().getId().toString() + "_" + attendDateStr));
            e.printStackTrace();
        }
    }

    private static void setMatchShiftInfo(ScheduleShiftInfo scheduleShiftInfo, AtsShiftInfo matchShift) {
        scheduleShiftInfo.setDefaultShift(matchShift);
        scheduleShiftInfo.setIsElastic(matchShift.isIsElastic());
        scheduleShiftInfo.setElasticType(matchShift.getElasticType());
        scheduleShiftInfo.setElasticDirection(matchShift.getElasticDirection());
        scheduleShiftInfo.setElasticValue(matchShift.getElasticValue());
        scheduleShiftInfo.setElasticValue(matchShift.getElasticValue());
        scheduleShiftInfo.setElasticValue(matchShift.getElasticValue());
        scheduleShiftInfo.setStandardHour(matchShift.getStandardHour());
        scheduleShiftInfo.setIsHalfDay(matchShift.isIsHalfDay());
        scheduleShiftInfo.setOtCompens(matchShift.getOtCompens());
        scheduleShiftInfo.setShiftType(matchShift.getShiftType());
        scheduleShiftInfo.setCardRule(matchShift.getCardRule());
    }

    private static SelectorItemCollection getMatchShiftSelector() {
        SelectorItemCollection itemCollSelector = new SelectorItemCollection();
        itemCollSelector.add(new SelectorItemInfo("id"));
        itemCollSelector.add(new SelectorItemInfo("standardHour"));
        itemCollSelector.add(new SelectorItemInfo("isHalfDay"));
        itemCollSelector.add(new SelectorItemInfo("name"));
        itemCollSelector.add(new SelectorItemInfo("number"));
        itemCollSelector.add(new SelectorItemInfo("simpleName"));
        itemCollSelector.add(new SelectorItemInfo("otCompens.id"));
        itemCollSelector.add(new SelectorItemInfo("shiftType.id"));
        itemCollSelector.add(new SelectorItemInfo("cardRule.id"));
        itemCollSelector.add(new SelectorItemInfo("cardRule.startNum"));
        itemCollSelector.add(new SelectorItemInfo("cardRule.endNum"));
        itemCollSelector.add(new SelectorItemInfo("isElastic"));
        itemCollSelector.add(new SelectorItemInfo("elasticType"));
        itemCollSelector.add(new SelectorItemInfo("elasticDirection"));
        itemCollSelector.add(new SelectorItemInfo("elasticValue"));
        itemCollSelector.add(new SelectorItemInfo("items.id"));
        itemCollSelector.add(new SelectorItemInfo("items.segmentInRest"));
        itemCollSelector.add(new SelectorItemInfo("items.segment"));
        itemCollSelector.add(new SelectorItemInfo("items.preTime"));
        itemCollSelector.add(new SelectorItemInfo("items.preDateTime"));
        itemCollSelector.add(new SelectorItemInfo("items.preTimeDayType"));
        itemCollSelector.add(new SelectorItemInfo("items.restPreTime"));
        itemCollSelector.add(new SelectorItemInfo("items.restNextTime"));
        itemCollSelector.add(new SelectorItemInfo("items.restPreDateTime"));
        itemCollSelector.add(new SelectorItemInfo("items.restNextDateTime"));
        itemCollSelector.add(new SelectorItemInfo("items.preFloatAdjusted"));
        itemCollSelector.add(new SelectorItemInfo("items.preIsPunchCard"));
        itemCollSelector.add(new SelectorItemInfo("items.nextTime"));
        itemCollSelector.add(new SelectorItemInfo("items.nextDateTime"));
        itemCollSelector.add(new SelectorItemInfo("items.nextTimeDayType"));
        itemCollSelector.add(new SelectorItemInfo("items.nextFloatAdjusted"));
        itemCollSelector.add(new SelectorItemInfo("items.nextIsPunchCard"));
        itemCollSelector.add(new SelectorItemInfo("items.attendanceType"));
        return itemCollSelector;
    }

    private static ScheduleShiftItemInfo getScheduleShiftItem(AtsShiftItemInfo atsShiftItem, String attendDateStr, String atdtNextDayStr, String atdtPreDayStr) {
        ScheduleShiftItemInfo shiftItem = new ScheduleShiftItemInfo();
        shiftItem.setSegmentInRest(atsShiftItem.getSegmentInRest());
        shiftItem.setSegment(atsShiftItem.getSegment());
        shiftItem.setPreTime(atsShiftItem.getPreTime());
        shiftItem.setPreTimeDayType(atsShiftItem.getPreTimeDayType());
        shiftItem.setRestPreTime(atsShiftItem.getRestPreTime());
        shiftItem.setNextTime(atsShiftItem.getNextTime());
        shiftItem.setNextTimeDayType(atsShiftItem.getNextTimeDayType());
        shiftItem.setRestNextTime(atsShiftItem.getRestNextTime());
        String preDateTimeStr = ScheduleShiftItemHelper.getRealTimeByType(atsShiftItem.getPreTimeDayType().getValue(), attendDateStr, atdtPreDayStr, atdtNextDayStr, atsShiftItem.getPreTime());
        shiftItem.setPreDateTime(AtsDateUtils.stringToTimestamp(preDateTimeStr));
        String nextDateTimeStr = ScheduleShiftItemHelper.getRealTimeByType(atsShiftItem.getNextTimeDayType().getValue(), attendDateStr, atdtPreDayStr, atdtNextDayStr, atsShiftItem.getNextTime());
        shiftItem.setNextDateTime(AtsDateUtils.stringToTimestamp(nextDateTimeStr));
        if (!StringUtils.isEmpty((String)atsShiftItem.getRestPreTime()) && !StringUtils.isEmpty((String)atsShiftItem.getRestNextTime())) {
            shiftItem.setRestPreDateTime(AtsDateUtils.stringToTimestamp(ScheduleShiftItemHelper.getRealRestTime(atsShiftItem.getPreTime(), atsShiftItem.getPreTimeDayType().getValue(), atsShiftItem.getRestPreTime(), atsShiftItem.getRestNextTime(), attendDateStr, atdtPreDayStr, atdtNextDayStr, "restPreTime")));
            shiftItem.setRestNextDateTime(AtsDateUtils.stringToTimestamp(ScheduleShiftItemHelper.getRealRestTime(atsShiftItem.getPreTime(), atsShiftItem.getPreTimeDayType().getValue(), atsShiftItem.getRestPreTime(), atsShiftItem.getRestNextTime(), attendDateStr, atdtPreDayStr, atdtNextDayStr, "restNextTime")));
        }
        shiftItem.setPreFloatAdjusted(atsShiftItem.getPreFloatAdjusted());
        shiftItem.setPreIsPunchCard(atsShiftItem.getPreIsPunchCard());
        shiftItem.setNextFloatAdjusted(atsShiftItem.getNextFloatAdjusted());
        shiftItem.setNextIsPunchCard(atsShiftItem.getNextIsPunchCard());
        shiftItem.setAttendanceType(atsShiftItem.getAttendanceType());
        return shiftItem;
    }

    private static AttendanceFileHISInfo getAttendanceFileHisInfo(Context ctx, String personIds, String date) {
        try {
            StringBuffer oql = new StringBuffer("select id,isAttendance,attencePolicy.id,attencePolicy.firstShiftPriority,attencePolicy.secondShiftPriority,attencePolicy.thirdShiftPriority ");
            if (personIds.split(",").length == 1) {
                if (!personIds.contains("'")) {
                    personIds = "'" + personIds + "'";
                }
                oql.append(" where proposer = " + personIds + " ");
            } else {
                if (!personIds.contains("'")) {
                    personIds = AtsUtil.getStrFromStringArr(personIds.split(","));
                }
                oql.append(" where proposer in (" + personIds + ") ");
            }
            oql.append(" and effdt <= {TS '" + date + "'} and leffdt >= {TS '" + date + "'} and attendFileState='1'");
            AttendanceFileHISCollection coll = AttendanceFileHISFactory.getLocalInstance(ctx).getAttendanceFileHISCollection(oql.toString());
            int i = 0;
            int size = coll.size();
            if (i < size) {
                return coll.get(0);
            }
        }
        catch (BOSException e) {
            e.printStackTrace();
        }
        return null;
    }

    public static Map<String, AttendanceFileInfo> getAttendanceFileInfoByPersonIds(Context ctx, String personId, String beginDate, String endDate) {
        if (!StringUtils.isEmpty((String)beginDate) && beginDate.length() > 10) {
            beginDate = beginDate.substring(0, 10);
        }
        if (!StringUtils.isEmpty((String)endDate) && endDate.length() > 10) {
            endDate = endDate.substring(0, 10);
        }
        return AtsScheduleShiftUtil.getAttendanceFileInfoByPersonId(ctx, personId, beginDate, endDate);
    }

    public static Map<String, AtsShiftInfo> getScheduleShiftListByAttendanceFile(Context ctx, Map<String, AttendanceFileInfo> attendanceFiles) {
        HashMap<String, AtsShiftInfo> atsShiftInfoMap = new HashMap<String, AtsShiftInfo>();
        Set<Map.Entry<String, AttendanceFileInfo>> entries = attendanceFiles.entrySet();
        HashSet<String> shiftIds = new HashSet<String>();
        for (Map.Entry<String, AttendanceFileInfo> entry : entries) {
            shiftIds.add(entry.getValue().getAtsShift().getId().toString());
        }
        if (shiftIds.size() <= 0) {
            return atsShiftInfoMap;
        }
        try {
            AtsShiftCollection atsShiftCollection = AtsShiftFactory.getLocalInstance(ctx).getAtsShiftCollection("where id in (" + AtsCollectionUtile.joinForSql(shiftIds) + ")");
            block3: for (Map.Entry<String, AttendanceFileInfo> entry : entries) {
                String atsShiftId = entry.getValue().getAtsShift().getId().toString();
                for (int index = 0; index < atsShiftCollection.size(); ++index) {
                    AtsShiftInfo atsShiftInfo = atsShiftCollection.get(index);
                    if (!atsShiftInfo.getId().toString().equalsIgnoreCase(atsShiftId)) continue;
                    atsShiftInfoMap.put(entry.getKey(), atsShiftInfo);
                    continue block3;
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return atsShiftInfoMap;
    }

    public static Map<String, AtsShiftInfo> getScheduleShiftListByAttendanceFileByHisFile(Context ctx, Map<String, AttendanceFileHISInfo> attendanceFiles) {
        HashMap<String, AtsShiftInfo> atsShiftInfoMap = new HashMap<String, AtsShiftInfo>();
        Set<Map.Entry<String, AttendanceFileHISInfo>> entries = attendanceFiles.entrySet();
        HashSet<String> shiftIds = new HashSet<String>();
        for (Map.Entry<String, AttendanceFileHISInfo> entry : entries) {
            shiftIds.add(entry.getValue().getAtsShift().getId().toString());
        }
        if (shiftIds.size() <= 0) {
            return atsShiftInfoMap;
        }
        try {
            AtsShiftCollection atsShiftCollection = AtsShiftFactory.getLocalInstance(ctx).getAtsShiftCollection("where id in (" + AtsCollectionUtile.joinForSql(shiftIds) + ")");
            block3: for (Map.Entry<String, AttendanceFileHISInfo> entry : entries) {
                String atsShiftId = entry.getValue().getAtsShift().getId().toString();
                for (int index = 0; index < atsShiftCollection.size(); ++index) {
                    AtsShiftInfo atsShiftInfo = atsShiftCollection.get(index);
                    if (!atsShiftInfo.getId().toString().equalsIgnoreCase(atsShiftId)) continue;
                    atsShiftInfoMap.put(entry.getKey(), atsShiftInfo);
                    continue block3;
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return atsShiftInfoMap;
    }

    public static Map<String, ScheduleShiftInfo> getScheduleShiftByAtsShift(Context ctx, Map<String, AttendanceFileInfo> attendanceFiles, Map<String, AtsShiftInfo> atsShiftInfoMap) {
        HashMap<String, ScheduleShiftInfo> infoHashMap = new HashMap<String, ScheduleShiftInfo>();
        Iterator<Map.Entry<String, AtsShiftInfo>> iterator = atsShiftInfoMap.entrySet().iterator();
        while (iterator.hasNext()) {
            try {
                Map.Entry<String, AtsShiftInfo> next = iterator.next();
                String key = next.getKey();
                String[] split = key.split("_");
                AtsShiftInfo value = next.getValue();
                AttendanceFileInfo fileInfo = attendanceFiles.get(key);
                infoHashMap.put(key, AtsScheduleShiftUtil.createScheduleShiftInfo(ctx, split[1], value, fileInfo));
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return infoHashMap;
    }

    public static Map<String, ScheduleShiftInfo> getDefaultScheduleMap(Context ctx, String personIds, String beginDate, String endDate) {
        Map<String, AttendanceFileInfo> attendanceFiles = AtsScheduleShiftUtil.getAttendanceFileInfoByPersonIds(ctx, personIds, beginDate, endDate);
        Map<String, AtsShiftInfo> atsShiftInfoMap = AtsScheduleShiftUtil.getScheduleShiftListByAttendanceFile(ctx, attendanceFiles);
        Map<String, ScheduleShiftInfo> scheduleShiftByAtsShift = AtsScheduleShiftUtil.getScheduleShiftByAtsShift(ctx, attendanceFiles, atsShiftInfoMap);
        return scheduleShiftByAtsShift;
    }

    public static ScheduleShiftInfo getDefaultSchedule(Context ctx, String personId, String attendDate) {
        Map<String, AtsShiftInfo> atsShiftInfoMap;
        Map<String, AttendanceFileInfo> attendanceFiles = AtsScheduleShiftUtil.getAttendanceFileInfoByPersonIds(ctx, personId, attendDate, attendDate);
        Map<String, ScheduleShiftInfo> scheduleShiftByAtsShift = AtsScheduleShiftUtil.getScheduleShiftByAtsShift(ctx, attendanceFiles, atsShiftInfoMap = AtsScheduleShiftUtil.getScheduleShiftListByAttendanceFile(ctx, attendanceFiles));
        if (AtsCollectionUtile.isEmpty(scheduleShiftByAtsShift)) {
            return null;
        }
        return scheduleShiftByAtsShift.values().iterator().next();
    }

    public static List<ScheduleShiftInfo> getDefaultSchedule(Context ctx, String personId, String beginDate, String endDate) {
        Map<String, AtsShiftInfo> atsShiftInfoMap;
        Map<String, AttendanceFileInfo> attendanceFiles = AtsScheduleShiftUtil.getAttendanceFileInfoByPersonIds(ctx, personId, beginDate, endDate);
        Map<String, ScheduleShiftInfo> scheduleShiftByAtsShift = AtsScheduleShiftUtil.getScheduleShiftByAtsShift(ctx, attendanceFiles, atsShiftInfoMap = AtsScheduleShiftUtil.getScheduleShiftListByAttendanceFile(ctx, attendanceFiles));
        if (AtsCollectionUtile.isEmpty(scheduleShiftByAtsShift)) {
            return Collections.emptyList();
        }
        return new ArrayList<ScheduleShiftInfo>(scheduleShiftByAtsShift.values());
    }

    public static ScheduleShiftItemCollection getScheduleItemsWithDefault(Context ctx, ScheduleShiftInfo scheduleShiftInfo) {
        if (!AtsCollectionUtile.isEmpty((IObjectCollection)scheduleShiftInfo.getItems())) {
            return scheduleShiftInfo.getItems();
        }
        return (scheduleShiftInfo = AtsScheduleShiftUtil.getDefaultSchedule(ctx, CoreBaseUtile.getId(scheduleShiftInfo.getProposer()), HRTimeWebUtils.dateShortToString(scheduleShiftInfo.getAttendDate()))) == null ? null : scheduleShiftInfo.getItems();
    }

    public static Map<String, ScheduleShiftInfo> getScheduleShiftByAtsShiftByHisInfo(Context ctx, Map<String, AttendanceFileHISInfo> attendanceFiles, Map<String, AtsShiftInfo> atsShiftInfoMap) {
        HashMap<String, ScheduleShiftInfo> infoHashMap = new HashMap<String, ScheduleShiftInfo>();
        Iterator<Map.Entry<String, AtsShiftInfo>> iterator = atsShiftInfoMap.entrySet().iterator();
        while (iterator.hasNext()) {
            try {
                Map.Entry<String, AtsShiftInfo> next = iterator.next();
                String key = next.getKey();
                String[] split = key.split("_");
                AtsShiftInfo value = next.getValue();
                AttendanceFileHISInfo fileInfo = attendanceFiles.get(key);
                infoHashMap.put(key, AtsScheduleShiftUtil.createScheduleShiftInfo(ctx, split[1], value, fileInfo.getCalendar().getId().toString()));
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return infoHashMap;
    }

    private static ScheduleShiftInfo createScheduleShiftInfo(Context ctx, String date, AtsShiftInfo atsShiftInfo, AttendanceFileInfo fileInfo) throws BOSException, EASBizException {
        return AtsScheduleShiftUtil.createScheduleShiftInfo(ctx, date, atsShiftInfo, fileInfo.getCalendar().getId().toString());
    }

    private static ScheduleShiftInfo createScheduleShiftInfo(Context ctx, String date, AtsShiftInfo atsShiftInfo, String calendarId) throws BOSException, EASBizException {
        ScheduleShiftInfo shiftInfo = new ScheduleShiftInfo();
        WorkCalendarItemCollection workCalendarItemCollection = WorkCalendarItemFactory.getLocalInstance(ctx).getWorkCalendarItemCollection("where CalendarGroup = '" + calendarId + "' and Date = '" + date + "'");
        shiftInfo.setDayType(workCalendarItemCollection.get(0).getDayType());
        shiftInfo.setCardRule(atsShiftInfo.getCardRule());
        shiftInfo.setDefaultShift(atsShiftInfo);
        AtsShiftItemCollection atsItems = atsShiftInfo.getItems();
        if (atsItems == null || atsItems.size() == 0) {
            return shiftInfo;
        }
        java.util.Date shiftDate = AtsDateUtils.stringToShortDate(date);
        String nextDay = AtsDateUtils.getNextDay(date);
        String preDay = AtsDateUtils.getPreDay(date);
        shiftInfo.setAttendDate(shiftDate);
        String preTimeStr = "";
        String preDateTimeStr = "";
        String nextTimeStr = "";
        String nextDateTimeStr = "";
        String restPreTime = "";
        for (int index = 0; index < atsItems.size(); ++index) {
            ScheduleShiftItemInfo scheduleShiftItemInfo = new ScheduleShiftItemInfo();
            AtsShiftItemInfo atsShiftItemInfo = atsItems.get(index);
            preTimeStr = atsShiftItemInfo.getPreTime();
            int preTimeValue = atsShiftItemInfo.getPreTimeDayType().getValue();
            preDateTimeStr = ScheduleShiftItemHelper.getRealTimeByType(preTimeValue, date, preDay, nextDay, preTimeStr);
            int nextTimeValue = atsShiftItemInfo.getNextTimeDayType().getValue();
            nextTimeStr = atsShiftItemInfo.getNextTime();
            nextDateTimeStr = ScheduleShiftItemHelper.getRealTimeByType(nextTimeValue, date, preDay, nextDay, nextTimeStr);
            restPreTime = atsShiftItemInfo.getRestPreTime();
            String restNextTime = atsShiftItemInfo.getRestNextTime();
            String restPreDateTimeStr = "";
            String restNextDateTimeStr = "";
            if (!StringUtils.isEmpty((String)restPreTime) && !StringUtils.isEmpty((String)restNextTime)) {
                restPreDateTimeStr = ScheduleShiftItemHelper.getRealRestTime(preTimeStr, preTimeValue, restPreTime, restNextTime, date, preDay, nextDay, "restPreTime");
                restNextDateTimeStr = ScheduleShiftItemHelper.getRealRestTime(preTimeStr, preTimeValue, restPreTime, restNextTime, date, preDay, nextDay, "restNextTime");
            }
            scheduleShiftItemInfo.setSegment(atsShiftItemInfo.getSegment());
            scheduleShiftItemInfo.setPreTime(atsShiftItemInfo.getPreTime());
            scheduleShiftItemInfo.setPreFloatAdjusted(atsShiftItemInfo.getPreFloatAdjusted());
            scheduleShiftItemInfo.setPreUnit(atsShiftItemInfo.getPreUnit());
            scheduleShiftItemInfo.setPreIsPunchCard(atsShiftItemInfo.getPreIsPunchCard());
            scheduleShiftItemInfo.setNextTime(atsShiftItemInfo.getNextTime());
            scheduleShiftItemInfo.setNextFloatAdjusted(atsShiftItemInfo.getNextFloatAdjusted());
            scheduleShiftItemInfo.setNextUnit(atsShiftItemInfo.getNextUnit());
            scheduleShiftItemInfo.setNextIsPunchCard(atsShiftItemInfo.getNextIsPunchCard());
            scheduleShiftItemInfo.setSegmentInRest(atsShiftItemInfo.getSegmentInRest());
            scheduleShiftItemInfo.setAttendanceType(atsShiftItemInfo.getAttendanceType());
            scheduleShiftItemInfo.setPreTimeDayType(atsShiftItemInfo.getPreTimeDayType());
            scheduleShiftItemInfo.setNextTimeDayType(atsShiftItemInfo.getNextTimeDayType());
            if (StringUtils.isNotEmpty((String)preDateTimeStr)) {
                scheduleShiftItemInfo.setPreDateTime(AtsCommonUtile.toTimestamp(preDateTimeStr));
            }
            if (StringUtils.isNotEmpty((String)nextDateTimeStr)) {
                scheduleShiftItemInfo.setNextDateTime(AtsCommonUtile.toTimestamp(nextDateTimeStr));
            }
            scheduleShiftItemInfo.setRestPreTime(restPreTime);
            scheduleShiftItemInfo.setRestNextTime(restNextTime);
            if (StringUtils.isNotEmpty((String)restPreDateTimeStr)) {
                scheduleShiftItemInfo.setRestPreDateTime(AtsCommonUtile.toTimestamp(restPreDateTimeStr));
            }
            if (StringUtils.isNotEmpty((String)restNextDateTimeStr)) {
                scheduleShiftItemInfo.setRestNextDateTime(AtsCommonUtile.toTimestamp(restNextDateTimeStr));
            }
            shiftInfo.getItems().add(scheduleShiftItemInfo);
        }
        return shiftInfo;
    }

    public static ScheduleShiftInfo getScheduleShiftInfo(Context ctx, String personId, String date) {
        Map<String, AtsShiftInfo> atsShiftInfoMap;
        ScheduleShiftInfo shiftInfo;
        List<ScheduleShiftInfo> scheduleShiftInfoList = AtsScheduleShiftUtil.getScheduleShiftListByPriority(ctx, personId, date, date);
        if (scheduleShiftInfoList != null && scheduleShiftInfoList.size() > 0 && (shiftInfo = scheduleShiftInfoList.get(0)).getItems() != null && shiftInfo.getItems().size() > 0) {
            return shiftInfo;
        }
        Map<String, AttendanceFileInfo> attendanceFiles = AtsScheduleShiftUtil.getAttendanceFileInfoByPersonIds(ctx, personId, date, date);
        Map<String, ScheduleShiftInfo> scheduleShiftByAtsShift = AtsScheduleShiftUtil.getScheduleShiftByAtsShift(ctx, attendanceFiles, atsShiftInfoMap = AtsScheduleShiftUtil.getScheduleShiftListByAttendanceFile(ctx, attendanceFiles));
        Iterator<Map.Entry<String, ScheduleShiftInfo>> iterator = scheduleShiftByAtsShift.entrySet().iterator();
        if (iterator.hasNext()) {
            return iterator.next().getValue();
        }
        return null;
    }

    private static Map<String, AttendanceFileInfo> getAttendanceFileInfoByPersonId(Context ctx, String personIds, String beginDate, String endDate) {
        HashMap<String, AttendanceFileInfo> returnMap = new HashMap<String, AttendanceFileInfo>();
        try {
            StringBuffer sb = new StringBuffer();
            sb.append(" select *,attencePolicy.id,attencePolicy.firstShiftPriority,attencePolicy.secondShiftPriority,attencePolicy.thirdShiftPriority ");
            if (personIds.split(",").length == 1) {
                if (!personIds.contains("'")) {
                    personIds = "'" + personIds + "'";
                }
                sb.append(" where proposer = " + personIds + " ");
            } else {
                if (!personIds.contains("'")) {
                    personIds = AtsUtil.getStrFromStringArr(personIds.split(","));
                }
                sb.append(" where proposer in (" + personIds + ") ");
            }
            sb.append(" and  attendFileState = '1' ");
            if (beginDate.contains("'")) {
                sb.append(" and  Effdt <= {ts " + endDate + "} and Leffdt >= {ts " + beginDate + "}");
            } else {
                sb.append(" and  Effdt <= {ts '" + endDate + "'} and Leffdt >= {ts '" + beginDate + "'}");
            }
            sb.append("  order by  attendanceNum  ");
            AttendanceFileHISCollection fileColl = AttendanceFileHISFactory.getLocalInstance(ctx).getAttendanceFileHISCollection(sb.toString());
            if (null == fileColl || fileColl.size() <= 0) {
                return returnMap;
            }
            for (String currentDate : AtsDateUtils.getDateList(beginDate, endDate)) {
                int size = fileColl.size();
                for (int i = 0; i < size; ++i) {
                    AttendanceFileHISInfo hisInfo = fileColl.get(i);
                    if (hisInfo.getEFFDT() == null || hisInfo.getLEFFDT() == null) continue;
                    java.util.Date date = AtsDateUtils.stringToShortDate(currentDate);
                    if (hisInfo.getEFFDT().getTime() > date.getTime() || hisInfo.getLEFFDT().getTime() < date.getTime()) continue;
                    String personId = hisInfo.getProposer().getId().toString();
                    returnMap.put(AtsScheduleShiftUtil.getKey(personId, currentDate), AtsScheduleShiftUtil.convertHis2File(hisInfo));
                }
            }
        }
        catch (BOSException e) {
            e.printStackTrace();
        }
        return returnMap;
    }

    private static Map<String, AttendanceFileInfo> getAllAttFileInfoByPersonId(Context ctx, String personIds, String beginDate, String endDate) {
        HashMap<String, AttendanceFileInfo> returnMap = new HashMap<String, AttendanceFileInfo>();
        try {
            StringBuffer sb = new StringBuffer();
            sb.append(" select *,attencePolicy.id,attencePolicy.firstShiftPriority,attencePolicy.secondShiftPriority,attencePolicy.thirdShiftPriority ");
            if (personIds.split(",").length == 1) {
                if (!personIds.contains("'")) {
                    personIds = "'" + personIds + "'";
                }
                sb.append(" where proposer = " + personIds + " ");
            } else {
                if (!personIds.contains("'")) {
                    personIds = AtsUtil.getStrFromStringArr(personIds.split(","));
                }
                sb.append(" where proposer in (" + personIds + ") ");
            }
            if (beginDate.contains("'")) {
                sb.append(" and  Effdt <= {ts " + endDate + "} and Leffdt >= {ts " + beginDate + "}");
            } else {
                sb.append(" and  Effdt <= {ts '" + endDate + "'} and Leffdt >= {ts '" + beginDate + "'}");
            }
            sb.append("  order by  attendanceNum  ");
            AttendanceFileHISCollection fileColl = AttendanceFileHISFactory.getLocalInstance(ctx).getAttendanceFileHISCollection(sb.toString());
            if (null == fileColl || fileColl.size() <= 0) {
                return returnMap;
            }
            for (String currentDate : AtsDateUtils.getDateList(beginDate, endDate)) {
                int size = fileColl.size();
                for (int i = 0; i < size; ++i) {
                    AttendanceFileHISInfo hisInfo = fileColl.get(i);
                    if (hisInfo.getEFFDT() == null || hisInfo.getLEFFDT() == null) continue;
                    java.util.Date date = AtsDateUtils.stringToShortDate(currentDate);
                    if (hisInfo.getEFFDT().getTime() > date.getTime() || hisInfo.getLEFFDT().getTime() < date.getTime()) continue;
                    String personId = hisInfo.getProposer().getId().toString();
                    returnMap.put(AtsScheduleShiftUtil.getKey(personId, currentDate), AtsScheduleShiftUtil.convertHis2File(hisInfo));
                }
            }
        }
        catch (BOSException e) {
            e.printStackTrace();
        }
        return returnMap;
    }

    private static AttendanceFileInfo convertHis2File(AttendanceFileHISInfo hisInfo) {
        AttendanceFileInfo fileInfo = new AttendanceFileInfo();
        fileInfo.setAttendanceNum(hisInfo.getAttendanceNum());
        fileInfo.setIsAttendance(hisInfo.getIsAttendance());
        fileInfo.setAttendFileState(hisInfo.getAttendFileState());
        fileInfo.setRemark(hisInfo.getRemark());
        fileInfo.setAttendCenter(hisInfo.getAttendCenter());
        fileInfo.setAttencePolicy(hisInfo.getAttencePolicy());
        fileInfo.setHolidayPolicySet(hisInfo.getHolidayPolicySet());
        fileInfo.setAtsShift(hisInfo.getAtsShift());
        fileInfo.setFileType(hisInfo.getFileType());
        fileInfo.setIsAutoShift(hisInfo.getIsAutoShift());
        fileInfo.setProposer(hisInfo.getProposer());
        fileInfo.setHrOrgUnit(hisInfo.getHrOrgUnit());
        fileInfo.setPosition(hisInfo.getPosition());
        fileInfo.setAttPosition(hisInfo.getAttPosition());
        fileInfo.setAdminOrgUnit(hisInfo.getAdminOrgUnit());
        fileInfo.setAttAdminOrgUnit(hisInfo.getAttAdminOrgUnit());
        fileInfo.setIsDefaultManage(hisInfo.isIsDefaultManage());
        fileInfo.setManageRelation(hisInfo.getManageRelation());
        fileInfo.setEFFDT(hisInfo.getEFFDT());
        fileInfo.setLEFFDT(hisInfo.getLEFFDT());
        fileInfo.setCalendar(hisInfo.getCalendar());
        fileInfo.setAttendFileState(hisInfo.getAttendFileState());
        return fileInfo;
    }

    public static String getKey(String personId, String attendDateStr) {
        return personId + "_" + attendDateStr;
    }

    public static ScheduleShiftInfo getScheduleShiftByDefault(Context ctx, String personId, String date) {
        Map<String, ScheduleShiftInfo> shiftPersonMap;
        if (!StringUtils.isEmpty((String)date) && date.length() > 10) {
            date = date.substring(0, 10);
        }
        if ((shiftPersonMap = AtsScheduleShiftUtil.getScheduleShiftForPersonByOql(ctx, personId, date, date)) != null) {
            return shiftPersonMap.get(AtsScheduleShiftUtil.getKey(personId, date));
        }
        return null;
    }

    public static Map<String, ScheduleShiftInfo> getScheduleShiftByDefault(Context ctx, String personIds, String beginDate, String endDate) {
        if (!StringUtils.isEmpty((String)beginDate) && beginDate.length() > 10) {
            beginDate = beginDate.substring(0, 10);
        }
        if (!StringUtils.isEmpty((String)endDate) && endDate.length() > 10) {
            endDate = endDate.substring(0, 10);
        }
        Map<String, ScheduleShiftInfo> shiftPersonMap = AtsScheduleShiftUtil.getScheduleShiftForPersonByOql(ctx, personIds, beginDate, endDate);
        return shiftPersonMap;
    }

    public static Boolean needCalAttendCalculateJob(Context ctx, String begin_time, String end_time, String personId) {
        Boolean isNeedCallAttendCalculateJob = false;
        logger.error((Object)("Call needCalAttendCalculateJob with personId:" + personId + ",begin_time:" + begin_time));
        try {
            String shiftTime;
            ScheduleShiftInfo scheduleshiftinfo = AtsScheduleShiftUtil.getScheduleShiftByPriority(ctx, personId, begin_time);
            AbstractObjectCollection items = null;
            if (null != scheduleshiftinfo && scheduleshiftinfo.getDefaultShift() != null) {
                items = scheduleshiftinfo.getItems();
            } else {
                String key;
                AttendanceFileInfo attendanceFileInfo;
                String shiftId = "";
                String beginDateStr = AtsDateUtils.getDateFromLongString(begin_time);
                Map<String, AttendanceFileInfo> attendanceFileInfoMap = AtsScheduleShiftUtil.getAttendanceFileInfoByPersonIds(ctx, personId, beginDateStr, beginDateStr);
                if (attendanceFileInfoMap != null && null != (attendanceFileInfo = attendanceFileInfoMap.get(key = personId + "_" + beginDateStr)) && null != attendanceFileInfo.getAtsShift()) {
                    shiftId = attendanceFileInfo.getAtsShift().getId().toString();
                    AtsShiftInfo atsShiftInfo = AtsShiftFactory.getLocalInstance(ctx).getAtsShiftInfo((IObjectPK)new ObjectUuidPK(shiftId));
                    if (null != atsShiftInfo) {
                        items = atsShiftInfo.getItems();
                    }
                }
            }
            if (null != items && items.size() > 0 && null != (shiftTime = AtsScheduleShiftUtil.getShiftTime(items, begin_time)) && shiftTime.length() > 0 && AtsDateUtils.stringToLongDate(shiftTime).getTime() < System.currentTimeMillis()) {
                isNeedCallAttendCalculateJob = true;
            }
        }
        catch (Exception e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
        }
        logger.error((Object)("Call needCalAttendCalculateJob with personId:" + personId + ",begin_time:" + begin_time + ",result :" + isNeedCallAttendCalculateJob));
        return isNeedCallAttendCalculateJob;
    }

    private static String getShiftTime(AbstractObjectCollection items, String begin_time) {
        String shiftTime = "";
        int segment = -1;
        int maxSegmentSeq = -1;
        String nextTime = "";
        String dayType = "";
        if (items instanceof ScheduleShiftItemCollection) {
            ScheduleShiftItemCollection scheduleItems = (ScheduleShiftItemCollection)items;
            for (int j = 0; j < scheduleItems.size(); ++j) {
                int tempSegment = Integer.parseInt(scheduleItems.get(j).getSegment().getValue());
                if (tempSegment <= segment) continue;
                segment = tempSegment;
                maxSegmentSeq = j;
            }
            if (maxSegmentSeq > -1) {
                ScheduleShiftItemInfo lastItem = scheduleItems.get(maxSegmentSeq);
                nextTime = AtsDateUtils.getFullTime(lastItem.getNextTime());
                dayType = String.valueOf(lastItem.getNextTimeDayType().getValue());
            }
        } else {
            AtsShiftItemCollection atsItems = (AtsShiftItemCollection)items;
            for (int j = 0; j < atsItems.size(); ++j) {
                int tempSegment = Integer.parseInt(atsItems.get(j).getSegment().getValue());
                if (tempSegment <= segment) continue;
                segment = tempSegment;
                maxSegmentSeq = j;
            }
            if (maxSegmentSeq > -1) {
                AtsShiftItemInfo lastItem = atsItems.get(maxSegmentSeq);
                nextTime = AtsDateUtils.getFullTime(lastItem.getNextTime());
                dayType = String.valueOf(lastItem.getNextTimeDayType().getValue());
            }
        }
        if (null != nextTime && nextTime.length() > 0 && null != dayType && dayType.length() > 0) {
            shiftTime = FetchCardUtil.timeToDateByDayType(nextTime, dayType, AtsDateUtils.getDateFromLongString(begin_time));
        }
        return shiftTime;
    }

    public static Map<String, Map<String, ScheduleShiftInfo>> getAllScheduleShiftByPerson(Context ctx, String personIds, String beginDate, String endDate) {
        HashMap<String, Map<String, ScheduleShiftInfo>> result = new HashMap<String, Map<String, ScheduleShiftInfo>>();
        if (StringUtils.isEmpty((String)personIds)) {
            return result;
        }
        Map<String, ScheduleShiftInfo> shiftCalculateMap = AtsScheduleShiftUtil.getScheduleShiftCalculate(ctx, personIds, beginDate, endDate);
        Map<String, ScheduleShiftInfo> shiftPersonMap = AtsScheduleShiftUtil.getScheduleShiftForPersonByOql(ctx, personIds, beginDate, endDate);
        Map<String, ScheduleShiftInfo> shiftGroupMap = AtsScheduleShiftUtil.getScheduleShiftForGroup(ctx, personIds, beginDate, endDate);
        Map<String, ScheduleShiftInfo> shiftAdminOrgMap = AtsScheduleShiftUtil.getScheduleShiftForAdminOrg(ctx, personIds, beginDate, endDate);
        String[] personIdss = personIds.split(",");
        List<String> dateList = AtsDateUtils.getDateList(beginDate, endDate);
        for (String personId : personIdss) {
            for (String date : dateList) {
                String key = personId + "_" + date;
                HashMap<String, ScheduleShiftInfo> tmp = new HashMap<String, ScheduleShiftInfo>();
                if (null != shiftCalculateMap) {
                    tmp.put("shiftCalculateMap", shiftCalculateMap.get(key));
                }
                if (null != shiftPersonMap) {
                    tmp.put("shiftPersonMap", shiftPersonMap.get(key));
                }
                if (null != shiftGroupMap) {
                    tmp.put("shiftGroupMap", shiftGroupMap.get(key));
                }
                if (null != shiftAdminOrgMap) {
                    tmp.put("shiftAdminOrgMap", shiftAdminOrgMap.get(key));
                }
                result.put(key, tmp);
            }
        }
        return result;
    }

    private static Map<String, ScheduleShiftInfo> getScheduleShiftCalculate(Context ctx, String personIds, String beginDate, String endDate) {
        HashMap<String, ScheduleShiftInfo> resMap = new HashMap<String, ScheduleShiftInfo>();
        try {
            personIds = personIds.replaceAll("'", "");
            personIds = "'" + personIds.replaceAll(",", "','") + "'";
            beginDate = beginDate.replaceAll("'", "");
            endDate = endDate.replaceAll("'", "");
            String sql = "select FProposerId, FAttenceDate, fAdminOrgUnitId, FID, FHrOrgUnitId, S66  from t_hr_ats_attendanceResult  where FProposerId in (" + personIds + ")  and FAttenceDate >= {ts '" + beginDate + "'}  and FAttenceDate <= {ts '" + endDate + "'} ";
            Object[] param = new Object[]{personIds, beginDate, endDate};
            IRowSet iRowSet = DbUtile.executeQuery(ctx, sql);
            while (iRowSet.next()) {
                String personid = iRowSet.getString("FProposerId");
                Date attendDate = iRowSet.getDate("FAttenceDate");
                String fAdminOrgUnitId = iRowSet.getString("fAdminOrgUnitId");
                String fid = iRowSet.getString("FID");
                String fHrOrgUnitId = iRowSet.getString("FHrOrgUnitId");
                String shiftInfoStr = iRowSet.getString("S66");
                String attendDateStr = AtsDateUtils.dateShortToString(attendDate);
                String key = personid + "_" + attendDateStr;
                try {
                    ScheduleShiftInfo scheduleShiftInfo = new ScheduleShiftInfo();
                    PersonInfo personInfo = new PersonInfo();
                    personInfo.setId(BOSUuid.read((String)personid));
                    scheduleShiftInfo.setProposer(personInfo);
                    scheduleShiftInfo.setAttendDate(attendDate);
                    scheduleShiftInfo.setDefaultShift(AtsScheduleShiftUtil.getAtsShiftInfoForAttendanceResult(shiftInfoStr));
                    scheduleShiftInfo.setDayType(AtsScheduleShiftUtil.getAtsDayTypeForAttendanceResult(ctx, shiftInfoStr));
                    resMap.put(key, scheduleShiftInfo);
                }
                catch (Exception e) {
                    logger.error((Object)("combine person scheduleshift error\uff01person id_date:" + key));
                    e.printStackTrace();
                }
            }
        }
        catch (Exception e) {
            logger.error((Object)("select person shcduleshift error \uff01personIds:" + personIds + ",beginDate:" + beginDate + ",endDate" + endDate));
            e.printStackTrace();
        }
        return resMap;
    }

    private static DayTypeEnum getAtsDayTypeForAttendanceResult(Context ctx, String shiftInfoStr) {
        if (StringUtils.isEmpty((String)shiftInfoStr)) {
            return DayTypeEnum.workDay;
        }
        String[] split = shiftInfoStr.split("\\|");
        if (split.length <= 0) {
            return DayTypeEnum.workDay;
        }
        shiftInfoStr = split[0];
        DayTypeEnum result = DayTypeEnum.workDay;
        if (shiftInfoStr.contains(DayTypeEnum.restDay.getAlias(ctx.getLocale()))) {
            result = DayTypeEnum.restDay;
        } else if (shiftInfoStr.contains(DayTypeEnum.legalHoliday.getAlias(ctx.getLocale()))) {
            result = DayTypeEnum.legalHoliday;
        } else if (shiftInfoStr.contains(DayTypeEnum.workDay.getAlias(ctx.getLocale()))) {
            result = DayTypeEnum.workDay;
        }
        return result;
    }

    private static AtsShiftInfo getAtsShiftInfoForAttendanceResult(String shiftInfo) {
        AtsShiftInfo atsShiftInfo = new AtsShiftInfo();
        if (StringUtils.isEmpty((String)shiftInfo)) {
            atsShiftInfo.setName("");
            return atsShiftInfo;
        }
        String[] split = shiftInfo.split("\\|");
        if (split.length > 1) {
            atsShiftInfo.setName(split[1]);
        }
        return atsShiftInfo;
    }
}

