/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.hr.ats.util;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectCollection;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.data.SortType;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.entity.SorterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.basedata.person.PersonCollection;
import com.kingdee.eas.basedata.person.PersonInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.framework.CoreBaseCollection;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.hr.ats.AbstractScheduleShiftInfo;
import com.kingdee.eas.hr.ats.AtsAcrossStoreSopportFactory;
import com.kingdee.eas.hr.ats.AtsAcrossStoreSopportInfo;
import com.kingdee.eas.hr.ats.AtsAcrossStoreSptEntryInfo;
import com.kingdee.eas.hr.ats.AtsAcrossStoreSptsInfo;
import com.kingdee.eas.hr.ats.AtsShiftCollection;
import com.kingdee.eas.hr.ats.AtsShiftFactory;
import com.kingdee.eas.hr.ats.AtsShiftInfo;
import com.kingdee.eas.hr.ats.AtsUtil;
import com.kingdee.eas.hr.ats.AttendanceFileCollection;
import com.kingdee.eas.hr.ats.AttendanceFileFactory;
import com.kingdee.eas.hr.ats.AttendanceFileInfo;
import com.kingdee.eas.hr.ats.AttendanceTypeEnum;
import com.kingdee.eas.hr.ats.DayTypeEnum;
import com.kingdee.eas.hr.ats.ScheduleShiftCollection;
import com.kingdee.eas.hr.ats.ScheduleShiftFactory;
import com.kingdee.eas.hr.ats.ScheduleShiftHisCollection;
import com.kingdee.eas.hr.ats.ScheduleShiftHisFactory;
import com.kingdee.eas.hr.ats.ScheduleShiftHisInfo;
import com.kingdee.eas.hr.ats.ScheduleShiftInfo;
import com.kingdee.eas.hr.ats.ScheduleShiftItemCollection;
import com.kingdee.eas.hr.ats.ScheduleShiftItemFactory;
import com.kingdee.eas.hr.ats.ScheduleShiftItemHisCollection;
import com.kingdee.eas.hr.ats.ScheduleShiftItemHisInfo;
import com.kingdee.eas.hr.ats.ScheduleShiftItemInfo;
import com.kingdee.eas.hr.ats.SchlShiftSrcTypeEnum;
import com.kingdee.eas.hr.ats.SegIsPunchCardEnum;
import com.kingdee.eas.hr.ats.SegmentEnum;
import com.kingdee.eas.hr.ats.SegmentUnitEnum;
import com.kingdee.eas.hr.ats.WorkCalendarItemCollection;
import com.kingdee.eas.hr.ats.WorkCalendarItemFactory;
import com.kingdee.eas.hr.ats.WorkCalendarItemInfo;
import com.kingdee.eas.hr.ats.calcutePrepareData.AtsPrepareDataHelper;
import com.kingdee.eas.hr.ats.dataLog.util.DataLogsRecordUtil;
import com.kingdee.eas.hr.ats.util.AtsAcrossStoreRptUtils;
import com.kingdee.eas.hr.ats.util.AtsDateUtils;
import com.kingdee.eas.hr.ats.util.AtsScheduleShiftUtil;
import com.kingdee.eas.hr.ats.util.AtsServerUtils;
import com.kingdee.eas.hr.ats.util.AtsViewUtile;
import com.kingdee.eas.hr.ats.util.common.AtsCollectionUtile;
import com.kingdee.eas.hr.ats.util.person.AtsPersonUtils;
import com.kingdee.eas.hr.ats.workShift.save.BaseSaveShift;
import com.kingdee.eas.util.app.DbUtil;
import java.math.BigDecimal;
import java.sql.Date;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import org.apache.commons.lang.StringUtils;
import org.springframework.beans.BeanUtils;

public class AtsStoreToScheduleShiftUtil {
    public static int ItemSrcType = 1;

    public static void dealStoreToScheduleShift(Context ctx, AtsAcrossStoreSopportInfo billInfo) throws BOSException, EASBizException {
        AtsStoreToScheduleShiftUtil.dealStoreToScheduleShift(ctx, billInfo.getId().toString());
    }

    public static void dealStoreToScheduleShift(Context ctx, String billId) throws BOSException, EASBizException {
        AtsAcrossStoreSopportInfo billInfo = AtsAcrossStoreSopportFactory.getLocalInstance(ctx).getAtsAcrossStoreSopportInfo("where id = '" + billId + "'");
        if (AtsCollectionUtile.isEmpty((IObjectCollection)billInfo.getSpts())) {
            return;
        }
        HashMap<String, AtsShiftInfo> entriesShift = new HashMap<String, AtsShiftInfo>();
        HashSet<String> shiftset = new HashSet<String>();
        if (billInfo.isSupportType()) {
            for (int i = 0; i < billInfo.getEntries().size(); ++i) {
                entriesShift.put(billInfo.getEntries().get(i).getId().toString(), billInfo.getEntries().get(i).getScheduleShift());
                shiftset.add(billInfo.getEntries().get(i).getScheduleShift().getId().toString());
            }
        }
        HashSet<String> personIds = new HashSet<String>();
        for (int i = 0; i < billInfo.getSpts().size(); ++i) {
            if (billInfo == null || billInfo.getSpts().get(i).getPerson() == null) continue;
            personIds.add(billInfo.getSpts().get(i).getPerson().getId().toString());
        }
        EntityViewInfo evi = AtsViewUtile.getViewByFilter("id", shiftset, CompareType.getEnum((String)"in"));
        AtsShiftCollection atsShiftCollection = AtsShiftFactory.getLocalInstance(ctx).getAtsShiftCollection(evi);
        Iterator atsShift = atsShiftCollection.iterator();
        HashMap<String, AtsShiftInfo> stringAtsShiftMap = new HashMap<String, AtsShiftInfo>();
        while (atsShift.hasNext()) {
            AtsShiftInfo atsShiftInfo = (AtsShiftInfo)atsShift.next();
            stringAtsShiftMap.put(atsShiftInfo.getId().toString(), atsShiftInfo);
        }
        PersonCollection personByIds = AtsPersonUtils.getPersonByIds(ctx, AtsUtil.convertSetToString(personIds).replaceAll("'", ""));
        Iterator iterator = personByIds.iterator();
        HashMap<String, PersonInfo> stringPersonMap = new HashMap<String, PersonInfo>();
        while (iterator.hasNext()) {
            PersonInfo personInfo = (PersonInfo)iterator.next();
            stringPersonMap.put(personInfo.getId().toString(), personInfo);
        }
        HashMap<String, ScheduleShiftInfo> scheduleLog = new HashMap<String, ScheduleShiftInfo>();
        Map<String, java.util.Date> minStartTimeAndMaxEndTime = AtsAcrossStoreRptUtils.getMinStartTimeAndMaxEndTime(ctx, billInfo);
        Map<String, ScheduleShiftInfo> existSchedules = AtsScheduleShiftUtil.getScheduleShiftForPersonByOql(ctx, AtsUtil.convertSetToString(personIds), AtsDateUtils.dateShortToString(minStartTimeAndMaxEndTime.get("startDate")), AtsDateUtils.dateShortToString(minStartTimeAndMaxEndTime.get("endDate")));
        Map<String, AttendanceFileInfo> atsFileHisMap = AtsStoreToScheduleShiftUtil.getAttendanceFileInfoByPersonId(ctx, AtsUtil.convertSetToString(personIds));
        Map<String, DayTypeEnum> attendanceDateWorkCalendar = AtsStoreToScheduleShiftUtil.getAttendanceDateWorkCalendar(ctx, personIds.toString(), atsFileHisMap, AtsDateUtils.dateShortToString(minStartTimeAndMaxEndTime.get("startDate")), AtsDateUtils.dateShortToString(minStartTimeAndMaxEndTime.get("endDate")));
        ScheduleShiftCollection schedules = new ScheduleShiftCollection();
        HashMap<String, java.util.Date> clearscheduleShift = new HashMap<String, java.util.Date>();
        if (billInfo.isSupportType()) {
            for (int i = 0; i < billInfo.getSpts().size(); ++i) {
                AbstractScheduleShiftInfo scheduleShiftInfo;
                DayTypeEnum dayType = null;
                AbstractScheduleShiftInfo abstractScheduleShiftInfo = scheduleShiftInfo = existSchedules != null ? existSchedules.get(AtsScheduleShiftUtil.getKey(billInfo.getSpts().get(i).getPerson().getId().toString(), AtsDateUtils.dateShortToString(billInfo.getSpts().get(i).getAttendanceDate()))) : null;
                if (null != scheduleShiftInfo) {
                    dayType = scheduleShiftInfo.getDayType();
                    scheduleShiftInfo.setAttendFile(atsFileHisMap.get(billInfo.getSpts().get(i).getPerson().getId().toString()));
                }
                scheduleLog.put(AtsScheduleShiftUtil.getKey(billInfo.getSpts().get(i).getPerson().getId().toString(), AtsDateUtils.dateShortToString(billInfo.getSpts().get(i).getAttendanceDate())), (ScheduleShiftInfo)scheduleShiftInfo);
                ScheduleShiftInfo newShedule = new ScheduleShiftInfo();
                newShedule.setAttendDate(billInfo.getSpts().get(i).getAttendanceDate());
                newShedule.setProposer((PersonInfo)stringPersonMap.get(billInfo.getSpts().get(i).getPerson().getId().toString()));
                for (SegmentEnum segmentEnum : new SegmentEnum[]{SegmentEnum.firtSegment, SegmentEnum.secondSegment, SegmentEnum.thirdSegment}) {
                    ScheduleShiftItemInfo scheduleShiftItemInfo = new ScheduleShiftItemInfo();
                    scheduleShiftItemInfo.setSegment(segmentEnum);
                    scheduleShiftItemInfo.setAttAdminOrgUnit(billInfo.getAdminOrg());
                    newShedule.getItems().add(scheduleShiftItemInfo);
                }
                if (dayType == null) {
                    newShedule.setDayType(attendanceDateWorkCalendar.get(AtsScheduleShiftUtil.getKey(billInfo.getSpts().get(i).getPerson().getId().toString(), AtsDateUtils.dateShortToString(billInfo.getSpts().get(i).getAttendanceDate()))));
                } else {
                    newShedule.setDayType(dayType);
                }
                newShedule.setDefaultShift((AtsShiftInfo)stringAtsShiftMap.get(((AtsShiftInfo)entriesShift.get(billInfo.getSpts().get(i).getEntryBill().getId().toString())).getId().toString()));
                if (null != scheduleShiftInfo) {
                    clearscheduleShift.put(billInfo.getSpts().get(i).getPerson().getId().toString(), billInfo.getSpts().get(i).getAttendanceDate());
                }
                schedules.add(newShedule);
            }
            AtsStoreToScheduleShiftUtil.clearScheduleShiftFromHis(ctx, clearscheduleShift, existSchedules);
            BaseSaveShift baseSaveShift = BaseSaveShift.getAutoInstance(ctx, "");
            baseSaveShift.setDefaultAdvcValue(4);
            baseSaveShift.setCtx(ctx);
            baseSaveShift.setDefaultScheduleSrcType(SchlShiftSrcTypeEnum.storeSchShift);
            baseSaveShift.save(schedules);
            AtsStoreToScheduleShiftUtil.scheduleShiftToSaveLog(ctx, scheduleLog, billInfo);
        } else {
            AtsStoreToScheduleShiftUtil.dealStoreToScheduleShiftNotAllDay(ctx, billInfo);
        }
    }

    public static Map<String, DayTypeEnum> getAttendanceDateWorkCalendar(Context ctx, String toString, Map<String, AttendanceFileInfo> atsFileHisMap, String beginDate, String endDate) {
        Iterator<Map.Entry<String, AttendanceFileInfo>> iterator = atsFileHisMap.entrySet().iterator();
        HashMap<String, DayTypeEnum> stringDayTypeEnumHashMap = new HashMap<String, DayTypeEnum>();
        HashSet<String> calendarGroups = new HashSet<String>();
        while (iterator.hasNext()) {
            Map.Entry<String, AttendanceFileInfo> next = iterator.next();
            if (null == next.getValue().getCalendar()) continue;
            calendarGroups.add(next.getValue().getCalendar().getId().toString());
        }
        try {
            WorkCalendarItemCollection workCalendarItemCollection = WorkCalendarItemFactory.getLocalInstance(ctx).getWorkCalendarItemCollection(" where date>='" + beginDate + "' and date<='" + endDate + "' and calendarGroup.id in (" + AtsUtil.convertSetToString(calendarGroups) + ")");
            for (int i = 0; i < workCalendarItemCollection.size(); ++i) {
                WorkCalendarItemInfo workCalendarItemInfo = workCalendarItemCollection.get(i);
                workCalendarItemInfo.getDate();
                for (Map.Entry<String, AttendanceFileInfo> hisinfo : atsFileHisMap.entrySet()) {
                    if (!hisinfo.getValue().getCalendar().getId().equals((Object)workCalendarItemInfo.getCalendarGroup().getId())) continue;
                    stringDayTypeEnumHashMap.put(AtsScheduleShiftUtil.getKey(hisinfo.getValue().getProposer().getId().toString(), AtsDateUtils.dateShortToString(workCalendarItemInfo.getDate())), workCalendarItemInfo.getDayType());
                }
            }
        }
        catch (BOSException e) {
            e.printStackTrace();
        }
        return stringDayTypeEnumHashMap;
    }

    private static Map<String, AttendanceFileInfo> getAttendanceFileInfoByPersonId(Context ctx, String personId) {
        AttendanceFileCollection attendanceFileColl = new AttendanceFileCollection();
        HashMap<String, AttendanceFileInfo> fileInfoMap = new HashMap<String, AttendanceFileInfo>();
        try {
            attendanceFileColl = AttendanceFileFactory.getLocalInstance(ctx).getAttendanceFileCollection(" where proposer.id  in (" + personId + ") and attendFileState='1' ");
        }
        catch (BOSException e) {
            e.printStackTrace();
        }
        AttendanceFileInfo fileInfo = null;
        String key = null;
        int size = attendanceFileColl.size();
        for (int i = 0; i < size; ++i) {
            fileInfo = attendanceFileColl.get(i);
            key = personId = fileInfo.getProposer().getId().toString();
            if (fileInfo.getEFFDT() == null || fileInfo.getLEFFDT() == null) continue;
            fileInfoMap.put(key, fileInfo);
        }
        return fileInfoMap;
    }

    public static void dealStoreToScheduleShiftNotAllDay(Context ctx, AtsAcrossStoreSopportInfo billInfo) throws BOSException, EASBizException {
        HashMap<String, ScheduleShiftInfo> scheduleLog = new HashMap<String, ScheduleShiftInfo>();
        HashMap<String, AtsAcrossStoreSptEntryInfo> stringAtsAcrossStoreSptEntryInfoHashMap = new HashMap<String, AtsAcrossStoreSptEntryInfo>();
        for (int i = 0; i < billInfo.getEntries().size(); ++i) {
            stringAtsAcrossStoreSptEntryInfoHashMap.put(billInfo.getEntries().get(i).getId().toString(), billInfo.getEntries().get(i));
        }
        HashSet<String> personids = new HashSet<String>();
        for (int i = 0; i < billInfo.getSpts().size(); ++i) {
            if (null == billInfo.getSpts().get(i).getPerson()) continue;
            personids.add(billInfo.getSpts().get(i).getPerson().getId().toString());
        }
        HashMap<String, ScheduleShiftInfo> stringScheduleShiftInfoHashMap = new HashMap<String, ScheduleShiftInfo>();
        Map<String, java.util.Date> minStartTimeAndMaxEndTime = AtsAcrossStoreRptUtils.getMinStartTimeAndMaxEndTime(ctx, billInfo);
        Map<String, ScheduleShiftInfo> scheduleShiftForPersonByAttendanceFile = AtsStoreToScheduleShiftUtil.getScheduleShiftForPersonByAttendanceFile(ctx, AtsUtil.convertSetToString(personids), AtsDateUtils.dateShortToString(minStartTimeAndMaxEndTime.get("startDate")), AtsDateUtils.dateShortToString(minStartTimeAndMaxEndTime.get("endDate")));
        Map<String, ScheduleShiftInfo> existSchedules = AtsScheduleShiftUtil.getScheduleShiftForPersonByOql(ctx, AtsUtil.convertSetToString(personids), AtsDateUtils.dateShortToString(minStartTimeAndMaxEndTime.get("startDate")), AtsDateUtils.dateShortToString(minStartTimeAndMaxEndTime.get("endDate")));
        CoreBaseCollection coreBaseCollection = new CoreBaseCollection();
        for (int i = 0; i < billInfo.getSpts().size(); ++i) {
            ScheduleShiftInfo scheduleShiftInfo;
            ScheduleShiftInfo scheduleShiftInfo2 = scheduleShiftInfo = stringScheduleShiftInfoHashMap != null ? (ScheduleShiftInfo)stringScheduleShiftInfoHashMap.get(AtsScheduleShiftUtil.getKey(billInfo.getSpts().get(i).getPerson().getId().toString(), AtsDateUtils.dateShortToString(billInfo.getSpts().get(i).getAttendanceDate()))) : null;
            if (scheduleShiftInfo == null) {
                ScheduleShiftInfo scheduleShiftInfo3 = scheduleShiftInfo = existSchedules != null ? existSchedules.get(AtsScheduleShiftUtil.getKey(billInfo.getSpts().get(i).getPerson().getId().toString(), AtsDateUtils.dateShortToString(billInfo.getSpts().get(i).getAttendanceDate()))) : null;
            }
            if (scheduleShiftInfo != null && existSchedules != null && existSchedules.get(AtsScheduleShiftUtil.getKey(billInfo.getSpts().get(i).getPerson().getId().toString(), AtsDateUtils.dateShortToString(billInfo.getSpts().get(i).getAttendanceDate()))) != null) {
                ScheduleShiftInfo scheduleShiftlog = (ScheduleShiftInfo)scheduleShiftInfo.clone();
                scheduleLog.put(AtsScheduleShiftUtil.getKey(billInfo.getSpts().get(i).getPerson().getId().toString(), AtsDateUtils.dateShortToString(billInfo.getSpts().get(i).getAttendanceDate())), scheduleShiftlog);
            }
            if (scheduleShiftInfo != null) {
                scheduleShiftInfo = AtsStoreToScheduleShiftUtil.updateScheduleShiftItemBySpts(ctx, billInfo.getSpts().get(i), scheduleShiftInfo, billInfo);
            } else {
                scheduleShiftInfo = scheduleShiftForPersonByAttendanceFile.get(AtsScheduleShiftUtil.getKey(billInfo.getSpts().get(i).getPerson().getId().toString(), AtsDateUtils.dateShortToString(billInfo.getSpts().get(i).getAttendanceDate())));
                if (scheduleShiftInfo != null) {
                    scheduleShiftInfo = AtsStoreToScheduleShiftUtil.addNewScheduleShiftItemBySpts(ctx, billInfo.getSpts().get(i), scheduleShiftInfo, billInfo);
                }
            }
            if (scheduleShiftInfo != null) {
                scheduleShiftInfo.setSrcType(SchlShiftSrcTypeEnum.storeSchShift);
            }
            stringScheduleShiftInfoHashMap.put(AtsScheduleShiftUtil.getKey(billInfo.getSpts().get(i).getPerson().getId().toString(), AtsDateUtils.dateShortToString(billInfo.getSpts().get(i).getAttendanceDate())), scheduleShiftInfo);
        }
        if (null != stringScheduleShiftInfoHashMap) {
            for (Map.Entry next : stringScheduleShiftInfoHashMap.entrySet()) {
                coreBaseCollection.add((CoreBaseInfo)next.getValue());
            }
        }
        AtsStoreToScheduleShiftUtil.scheduleShiftToSaveLog(ctx, scheduleLog, billInfo);
        ScheduleShiftFactory.getLocalInstance(ctx).saveBatchData(coreBaseCollection);
    }

    public static ScheduleShiftInfo addNewScheduleShiftItemBySpts(Context ctx, AtsAcrossStoreSptsInfo sptsInfo, ScheduleShiftInfo scheduleShiftInfo, AtsAcrossStoreSopportInfo billInfo) {
        ScheduleShiftItemCollection items = scheduleShiftInfo.getItems();
        Iterator iterator = items.iterator();
        ScheduleShiftItemCollection scheduleShiftItemCollection = new ScheduleShiftItemCollection();
        HashMap<String, AtsAcrossStoreSptEntryInfo> stringAtsAcrossStoreSptEntryInfoHashMap = new HashMap<String, AtsAcrossStoreSptEntryInfo>();
        for (int i = 0; i < billInfo.getEntries().size(); ++i) {
            stringAtsAcrossStoreSptEntryInfoHashMap.put(billInfo.getEntries().get(i).getId().toString(), billInfo.getEntries().get(i));
        }
        AtsAcrossStoreSptEntryInfo atsAcrossStoreSptEntryInfo = (AtsAcrossStoreSptEntryInfo)stringAtsAcrossStoreSptEntryInfoHashMap.get(sptsInfo.getEntryBill().getId().toString());
        atsAcrossStoreSptEntryInfo = AtsStoreToScheduleShiftUtil.formatTimeAcrossStoreSpts(ctx, sptsInfo, atsAcrossStoreSptEntryInfo);
        if (iterator.hasNext()) {
            ScheduleShiftItemInfo scheduleShiftItemInfo = (ScheduleShiftItemInfo)iterator.next();
            scheduleShiftItemInfo.setAttAdminOrgUnit(billInfo.getAdminOrg());
            scheduleShiftItemInfo.setPreDateTime(atsAcrossStoreSptEntryInfo.getOnWorkTime());
            scheduleShiftItemInfo.setNextDateTime(atsAcrossStoreSptEntryInfo.getOffWorkTime());
            scheduleShiftItemInfo.setNextTimeDayType(atsAcrossStoreSptEntryInfo.getOffWorkDayType());
            scheduleShiftItemInfo.setPreTimeDayType(atsAcrossStoreSptEntryInfo.getOnWorkDayType());
            scheduleShiftItemInfo.setPreTime(AtsDateUtils.getHourMinFromString(AtsDateUtils.timestampToString(atsAcrossStoreSptEntryInfo.getOnWorkTime())));
            scheduleShiftItemInfo.setNextTime(AtsDateUtils.getHourMinFromString(AtsDateUtils.timestampToString(atsAcrossStoreSptEntryInfo.getOffWorkTime())));
            if (StringUtils.isNotEmpty((String)AtsDateUtils.timestampToString(atsAcrossStoreSptEntryInfo.getRestNextDateTime()))) {
                scheduleShiftItemInfo.setRestNextTime(AtsDateUtils.getHourMinFromString(AtsDateUtils.timestampToString(atsAcrossStoreSptEntryInfo.getRestNextDateTime())));
            } else {
                scheduleShiftItemInfo.setRestNextTime(null);
            }
            if (StringUtils.isNotEmpty((String)AtsDateUtils.timestampToString(atsAcrossStoreSptEntryInfo.getRestPreDateTime()))) {
                scheduleShiftItemInfo.setRestPreTime(AtsDateUtils.getHourMinFromString(AtsDateUtils.timestampToString(atsAcrossStoreSptEntryInfo.getRestPreDateTime())));
            } else {
                scheduleShiftItemInfo.setRestPreTime(null);
            }
            scheduleShiftItemInfo.setRestNextDateTime(atsAcrossStoreSptEntryInfo.getRestNextDateTime());
            scheduleShiftItemInfo.setRestPreDateTime(atsAcrossStoreSptEntryInfo.getRestPreDateTime());
            scheduleShiftItemInfo.setSegmentInRest(atsAcrossStoreSptEntryInfo.getSegmentInRest());
            scheduleShiftItemInfo.setPreIsPunchCard(SegIsPunchCardEnum.yes);
            scheduleShiftItemInfo.setNextIsPunchCard(SegIsPunchCardEnum.yes);
            scheduleShiftItemInfo.setItemSrcType(ItemSrcType);
            scheduleShiftItemCollection.add(scheduleShiftItemInfo);
        }
        BigDecimal restime = BigDecimal.ZERO;
        BigDecimal workTime = BigDecimal.ZERO;
        workTime = BigDecimal.valueOf(AtsDateUtils.getTwoTimeDiffHours(AtsDateUtils.dateLongToString(atsAcrossStoreSptEntryInfo.getOnWorkTime()), AtsDateUtils.dateLongToString(atsAcrossStoreSptEntryInfo.getOffWorkTime())));
        if (null != atsAcrossStoreSptEntryInfo.getRestPreDateTime() || null != atsAcrossStoreSptEntryInfo.getRestNextDateTime()) {
            restime = BigDecimal.valueOf(AtsDateUtils.getTwoTimeDiffHours(AtsDateUtils.timestampToString(atsAcrossStoreSptEntryInfo.getRestPreDateTime()), AtsDateUtils.timestampToString(atsAcrossStoreSptEntryInfo.getRestNextDateTime())));
        }
        workTime = workTime.subtract(restime);
        scheduleShiftInfo.getItems().clear();
        scheduleShiftInfo.getItems().addCollection(scheduleShiftItemCollection);
        return scheduleShiftInfo;
    }

    public static ScheduleShiftInfo updateScheduleShiftItemBySpts(Context ctx, AtsAcrossStoreSptsInfo sptsInfo, ScheduleShiftInfo scheduleShiftInfo, AtsAcrossStoreSopportInfo billInfo) {
        ScheduleShiftItemCollection items = scheduleShiftInfo.getItems();
        Iterator iterator = items.iterator();
        HashMap<String, AtsAcrossStoreSptEntryInfo> stringAtsAcrossStoreSptEntryInfoHashMap = new HashMap<String, AtsAcrossStoreSptEntryInfo>();
        for (int i = 0; i < billInfo.getEntries().size(); ++i) {
            stringAtsAcrossStoreSptEntryInfoHashMap.put(billInfo.getEntries().get(i).getId().toString(), billInfo.getEntries().get(i));
        }
        AtsAcrossStoreSptEntryInfo atsAcrossStoreSptEntryInfo = (AtsAcrossStoreSptEntryInfo)stringAtsAcrossStoreSptEntryInfoHashMap.get(sptsInfo.getEntryBill().getId().toString());
        atsAcrossStoreSptEntryInfo = AtsStoreToScheduleShiftUtil.formatTimeAcrossStoreSpts(ctx, sptsInfo, atsAcrossStoreSptEntryInfo);
        ScheduleShiftItemCollection scheduleShiftItemCollection = new ScheduleShiftItemCollection();
        boolean createNewItem = false;
        while (iterator.hasNext()) {
            ScheduleShiftItemInfo newItem;
            ScheduleShiftItemInfo scheduleShiftItemInfo = (ScheduleShiftItemInfo)iterator.next();
            Timestamp preDateTime = scheduleShiftItemInfo.getPreDateTime();
            Timestamp nextDateTime = scheduleShiftItemInfo.getNextDateTime();
            boolean needCover = false;
            if (preDateTime.before(atsAcrossStoreSptEntryInfo.getOnWorkTime()) && nextDateTime.after(atsAcrossStoreSptEntryInfo.getOnWorkTime())) {
                needCover = true;
                if (!createNewItem) {
                    newItem = AtsStoreToScheduleShiftUtil.createNewItemByscheduleShiftItem(ctx, scheduleShiftItemInfo, atsAcrossStoreSptEntryInfo, billInfo, null);
                    scheduleShiftItemCollection.add(newItem);
                    createNewItem = true;
                }
            }
            if (!preDateTime.before(atsAcrossStoreSptEntryInfo.getOnWorkTime()) && !nextDateTime.after(atsAcrossStoreSptEntryInfo.getOffWorkTime())) {
                needCover = true;
                if (!createNewItem) {
                    newItem = AtsStoreToScheduleShiftUtil.createNewItemByscheduleShiftItem(ctx, scheduleShiftItemInfo, atsAcrossStoreSptEntryInfo, billInfo, null);
                    scheduleShiftItemCollection.add(newItem);
                    createNewItem = true;
                }
            }
            if (nextDateTime.after(atsAcrossStoreSptEntryInfo.getOffWorkTime()) && preDateTime.before(atsAcrossStoreSptEntryInfo.getOffWorkTime())) {
                needCover = true;
                if (!createNewItem) {
                    newItem = AtsStoreToScheduleShiftUtil.createNewItemByscheduleShiftItem(ctx, scheduleShiftItemInfo, atsAcrossStoreSptEntryInfo, billInfo, null);
                    scheduleShiftItemCollection.add(newItem);
                    createNewItem = true;
                }
            }
            if (preDateTime.before(atsAcrossStoreSptEntryInfo.getEndDate()) && nextDateTime.after(atsAcrossStoreSptEntryInfo.getEndDate())) {
                needCover = true;
                if (!createNewItem) {
                    newItem = AtsStoreToScheduleShiftUtil.createNewItemByscheduleShiftItem(ctx, scheduleShiftItemInfo, atsAcrossStoreSptEntryInfo, billInfo, null);
                    scheduleShiftItemCollection.add(newItem);
                    createNewItem = true;
                }
            }
            if (preDateTime.compareTo(atsAcrossStoreSptEntryInfo.getOffWorkTime()) != -1 && !createNewItem) {
                newItem = AtsStoreToScheduleShiftUtil.createNewItemByscheduleShiftItem(ctx, scheduleShiftItemInfo, atsAcrossStoreSptEntryInfo, billInfo, null);
                scheduleShiftItemCollection.add(newItem);
                createNewItem = true;
            }
            if (nextDateTime.compareTo(atsAcrossStoreSptEntryInfo.getOnWorkTime()) != 1 && !createNewItem && !iterator.hasNext()) {
                newItem = AtsStoreToScheduleShiftUtil.createNewItemByscheduleShiftItem(ctx, scheduleShiftItemInfo, atsAcrossStoreSptEntryInfo, billInfo, null);
                scheduleShiftItemCollection.add(newItem);
                createNewItem = true;
            }
            if (needCover) continue;
            scheduleShiftItemCollection.add(scheduleShiftItemInfo);
        }
        if (!scheduleShiftItemCollection.isEmpty()) {
            for (int i = 0; i < scheduleShiftItemCollection.size(); ++i) {
                scheduleShiftItemCollection.get(i).setSegment(SegmentEnum.getEnum(String.valueOf(String.valueOf(i + 1))));
            }
        }
        if (!scheduleShiftItemCollection.isEmpty()) {
            for (int i = 0; i < scheduleShiftItemCollection.size(); ++i) {
                for (int j = 0; j < scheduleShiftItemCollection.size(); ++j) {
                    ScheduleShiftItemInfo scheduleShiftItemInfo = scheduleShiftItemCollection.get(i);
                    ScheduleShiftItemInfo scheduleShiftItemInfo1 = scheduleShiftItemCollection.get(j);
                    int temp = Integer.valueOf(scheduleShiftItemInfo.getSegment().getValue());
                    if (!scheduleShiftItemInfo1.getPreDateTime().before(scheduleShiftItemInfo.getPreDateTime()) || scheduleShiftItemInfo1.getSegment().compareTo((Object)scheduleShiftItemInfo.getSegment()) <= -1) continue;
                    scheduleShiftItemCollection.get(i).setSegment(scheduleShiftItemCollection.get(j).getSegment());
                    scheduleShiftItemCollection.get(j).setSegment(SegmentEnum.getEnum(String.valueOf(temp)));
                }
            }
        }
        if (items.isEmpty()) {
            ScheduleShiftItemInfo scheduleShiftItemInfo = new ScheduleShiftItemInfo();
            scheduleShiftItemInfo.setAttAdminOrgUnit(billInfo.getAdminOrg());
            scheduleShiftItemInfo.setPreDateTime(atsAcrossStoreSptEntryInfo.getOnWorkTime());
            scheduleShiftItemInfo.setNextDateTime(atsAcrossStoreSptEntryInfo.getOffWorkTime());
            scheduleShiftItemInfo.setNextTimeDayType(atsAcrossStoreSptEntryInfo.getOffWorkDayType());
            scheduleShiftItemInfo.setPreTimeDayType(atsAcrossStoreSptEntryInfo.getOnWorkDayType());
            scheduleShiftItemInfo.setPreTime(AtsDateUtils.getHourMinFromString(AtsDateUtils.timestampToString(atsAcrossStoreSptEntryInfo.getOnWorkTime())));
            scheduleShiftItemInfo.setNextTime(AtsDateUtils.getHourMinFromString(AtsDateUtils.timestampToString(atsAcrossStoreSptEntryInfo.getOffWorkTime())));
            if (StringUtils.isNotEmpty((String)AtsDateUtils.timestampToString(atsAcrossStoreSptEntryInfo.getRestNextDateTime()))) {
                scheduleShiftItemInfo.setRestNextTime(AtsDateUtils.getHourMinFromString(AtsDateUtils.timestampToString(atsAcrossStoreSptEntryInfo.getRestNextDateTime())));
            } else {
                scheduleShiftItemInfo.setRestNextTime(null);
            }
            if (StringUtils.isNotEmpty((String)AtsDateUtils.timestampToString(atsAcrossStoreSptEntryInfo.getRestPreDateTime()))) {
                scheduleShiftItemInfo.setRestPreTime(AtsDateUtils.getHourMinFromString(AtsDateUtils.timestampToString(atsAcrossStoreSptEntryInfo.getRestPreDateTime())));
            } else {
                scheduleShiftItemInfo.setRestPreTime(null);
            }
            scheduleShiftItemInfo.setRestNextDateTime(atsAcrossStoreSptEntryInfo.getRestNextDateTime());
            scheduleShiftItemInfo.setRestPreDateTime(atsAcrossStoreSptEntryInfo.getRestPreDateTime());
            scheduleShiftItemInfo.setSegmentInRest(atsAcrossStoreSptEntryInfo.getSegmentInRest());
            scheduleShiftItemInfo.setPreIsPunchCard(SegIsPunchCardEnum.yes);
            scheduleShiftItemInfo.setNextIsPunchCard(SegIsPunchCardEnum.yes);
            scheduleShiftItemInfo.setItemSrcType(ItemSrcType);
            scheduleShiftItemInfo.setSegment(SegmentEnum.firtSegment);
            scheduleShiftItemInfo.setPreFloatAdjusted(BigDecimal.ZERO);
            scheduleShiftItemInfo.setNextFloatAdjusted(BigDecimal.ZERO);
            scheduleShiftItemInfo.setAttendanceType(AttendanceTypeEnum.normalAttance);
            scheduleShiftItemCollection.add(scheduleShiftItemInfo);
        }
        scheduleShiftInfo.getItems().clear();
        scheduleShiftInfo.getItems().addCollection(scheduleShiftItemCollection);
        return scheduleShiftInfo;
    }

    public static AtsAcrossStoreSptEntryInfo formatTimeAcrossStoreSpts(Context ctx, AtsAcrossStoreSptsInfo sptsInfo, AtsAcrossStoreSptEntryInfo atsAcrossStoreSptEntryInfo) {
        Timestamp offWorkTime = atsAcrossStoreSptEntryInfo.getOffWorkTime();
        Timestamp onWorkTime = atsAcrossStoreSptEntryInfo.getOnWorkTime();
        java.util.Date attendanceDate = sptsInfo.getAttendanceDate();
        String onWorkTimeHour = AtsDateUtils.getHourMinFromString(AtsDateUtils.timestampToString(onWorkTime));
        String offWorkTimeHour = AtsDateUtils.getHourMinFromString(AtsDateUtils.timestampToString(offWorkTime));
        String attendancedate = AtsDateUtils.dateShortToString(attendanceDate);
        SegmentUnitEnum onWorkDayType = atsAcrossStoreSptEntryInfo.getOnWorkDayType();
        SegmentUnitEnum offWorkDayType = atsAcrossStoreSptEntryInfo.getOffWorkDayType();
        atsAcrossStoreSptEntryInfo.setOnWorkTime(AtsDateUtils.stringToTimestamp(AtsDateUtils.getNextDay(attendancedate, onWorkDayType.getValue() - 1) + " " + onWorkTimeHour + ":00"));
        atsAcrossStoreSptEntryInfo.setOffWorkTime(AtsDateUtils.stringToTimestamp(AtsDateUtils.getNextDay(attendancedate, offWorkDayType.getValue() - 1) + " " + offWorkTimeHour + ":00"));
        return atsAcrossStoreSptEntryInfo;
    }

    private static ScheduleShiftItemInfo createNewItemByscheduleShiftItem(Context ctx, ScheduleShiftItemInfo scheduleShiftItemInfo, AtsAcrossStoreSptEntryInfo atsAcrossStoreSptEntryInfo, AtsAcrossStoreSopportInfo billInfo, SegmentEnum segment) {
        ScheduleShiftItemInfo scheduleShiftItem = new ScheduleShiftItemInfo();
        scheduleShiftItem.setAttAdminOrgUnit(billInfo.getAdminOrg());
        scheduleShiftItem.setPreDateTime(atsAcrossStoreSptEntryInfo.getOnWorkTime());
        scheduleShiftItem.setNextDateTime(atsAcrossStoreSptEntryInfo.getOffWorkTime());
        scheduleShiftItem.setPreTime(AtsDateUtils.getHourMinFromString(AtsDateUtils.timestampToString(atsAcrossStoreSptEntryInfo.getOnWorkTime())));
        scheduleShiftItem.setNextTime(AtsDateUtils.getHourMinFromString(AtsDateUtils.timestampToString(atsAcrossStoreSptEntryInfo.getOffWorkTime())));
        if (StringUtils.isNotEmpty((String)AtsDateUtils.timestampToString(atsAcrossStoreSptEntryInfo.getRestNextDateTime()))) {
            scheduleShiftItem.setRestNextTime(AtsDateUtils.getHourMinFromString(AtsDateUtils.timestampToString(atsAcrossStoreSptEntryInfo.getRestNextDateTime())));
        }
        if (StringUtils.isNotEmpty((String)AtsDateUtils.timestampToString(atsAcrossStoreSptEntryInfo.getRestPreDateTime()))) {
            scheduleShiftItem.setRestPreTime(AtsDateUtils.getHourMinFromString(AtsDateUtils.timestampToString(atsAcrossStoreSptEntryInfo.getRestPreDateTime())));
        }
        scheduleShiftItem.setRestNextDateTime(atsAcrossStoreSptEntryInfo.getRestNextDateTime());
        scheduleShiftItem.setRestPreDateTime(atsAcrossStoreSptEntryInfo.getRestPreDateTime());
        scheduleShiftItem.setSegmentInRest(atsAcrossStoreSptEntryInfo.getSegmentInRest());
        scheduleShiftItem.setPreIsPunchCard(SegIsPunchCardEnum.yes);
        scheduleShiftItem.setNextIsPunchCard(SegIsPunchCardEnum.yes);
        scheduleShiftItem.setPreTimeDayType(atsAcrossStoreSptEntryInfo.getOnWorkDayType());
        scheduleShiftItem.setNextTimeDayType(atsAcrossStoreSptEntryInfo.getOffWorkDayType());
        scheduleShiftItem.setSegment(segment);
        scheduleShiftItem.setId(BOSUuid.create((String)"4ECBA044"));
        scheduleShiftItem.setGroup(scheduleShiftItemInfo.getGroup());
        scheduleShiftItem.setPreFloatAdjusted(scheduleShiftItemInfo.getPreFloatAdjusted());
        scheduleShiftItem.setNextFloatAdjusted(scheduleShiftItemInfo.getNextFloatAdjusted());
        scheduleShiftItem.setAttendanceType(scheduleShiftItemInfo.getAttendanceType());
        scheduleShiftItem.setItemSrcType(ItemSrcType);
        return scheduleShiftItem;
    }

    public static Map<String, ScheduleShiftInfo> getScheduleShiftForPersonByAttendanceFile(Context ctx, String personIds, String beginDate, String endDate) {
        if (StringUtils.isEmpty((String)personIds)) {
            return new HashMap<String, ScheduleShiftInfo>();
        }
        if (!StringUtils.isEmpty((String)beginDate) && beginDate.length() > 10) {
            beginDate = beginDate.substring(0, 10);
        }
        if (!StringUtils.isEmpty((String)endDate) && endDate.length() > 10) {
            endDate = endDate.substring(0, 10);
        }
        Map<String, AttendanceFileInfo> atsFileHisMap = AtsServerUtils.getAttendanceFileInfoByPersonId(ctx, personIds, beginDate, endDate);
        Map<String, AttendanceFileInfo> attendanceFileInfosByPersonIds = null;
        HashMap<String, ScheduleShiftInfo> stringScheduleShiftInfoHashMap = new HashMap<String, ScheduleShiftInfo>();
        try {
            attendanceFileInfosByPersonIds = AtsPrepareDataHelper.getAttendanceFileInfosByPersonIds(ctx, personIds);
        }
        catch (BOSException e) {
            e.printStackTrace();
        }
        catch (SQLException throwables) {
            throwables.printStackTrace();
        }
        if (attendanceFileInfosByPersonIds == null) {
            return stringScheduleShiftInfoHashMap;
        }
        Map<String, AtsShiftInfo> scheduleShiftListByAttendanceFile = AtsScheduleShiftUtil.getScheduleShiftListByAttendanceFile(ctx, atsFileHisMap);
        Map<String, ScheduleShiftInfo> scheduleShiftByAtsShift = AtsScheduleShiftUtil.getScheduleShiftByAtsShift(ctx, atsFileHisMap, scheduleShiftListByAttendanceFile);
        Map<String, DayTypeEnum> attendanceDateWorkCalendar = AtsStoreToScheduleShiftUtil.getAttendanceDateWorkCalendar(ctx, personIds, atsFileHisMap, beginDate, endDate);
        for (Map.Entry<String, ScheduleShiftInfo> scheduleShiftInfoEntry : scheduleShiftByAtsShift.entrySet()) {
            AttendanceFileInfo attendanceFileInfo = atsFileHisMap.get(scheduleShiftInfoEntry.getKey());
            scheduleShiftInfoEntry.getValue().setProposer(attendanceFileInfo.getProposer());
            scheduleShiftInfoEntry.getValue().setAdminOrgUnit(attendanceFileInfo.getAdminOrgUnit());
            scheduleShiftInfoEntry.getValue().setHrOrgUnit(attendanceFileInfo.getHrOrgUnit());
            scheduleShiftInfoEntry.getValue().setSrcType(SchlShiftSrcTypeEnum.storeSchShift);
            scheduleShiftInfoEntry.getValue().setAttendFile(attendanceFileInfosByPersonIds.get(attendanceFileInfo.getProposer().getId().toString()));
            scheduleShiftInfoEntry.getValue().setAttendPolicy(attendanceFileInfo.getAttencePolicy());
            scheduleShiftInfoEntry.getValue().setStandardHour(scheduleShiftInfoEntry.getValue().getDefaultShift().getStandardHour());
            scheduleShiftInfoEntry.getValue().setOtCompens(scheduleShiftInfoEntry.getValue().getDefaultShift().getOtCompens());
            scheduleShiftInfoEntry.getValue().setDayType(attendanceDateWorkCalendar.get(scheduleShiftInfoEntry.getKey()));
            stringScheduleShiftInfoHashMap.put(scheduleShiftInfoEntry.getKey(), scheduleShiftInfoEntry.getValue());
        }
        return stringScheduleShiftInfoHashMap;
    }

    public static void againApproveScheduleFromLog(Context ctx, String billId) throws BOSException, EASBizException {
        AtsAcrossStoreSopportInfo billInfo = AtsAcrossStoreSopportFactory.getLocalInstance(ctx).getAtsAcrossStoreSopportInfo("where id = '" + billId + "'");
        if (AtsCollectionUtile.isEmpty((IObjectCollection)billInfo.getSpts())) {
            return;
        }
        HashSet<String> personids = new HashSet<String>();
        for (int i = 0; i < billInfo.getSpts().size(); ++i) {
            if (null == billInfo.getSpts().get(i).getPerson()) continue;
            personids.add(billInfo.getSpts().get(i).getPerson().getId().toString());
        }
        Map<String, java.util.Date> minStartTimeAndMaxEndTime = AtsAcrossStoreRptUtils.getMinStartTimeAndMaxEndTime(ctx, billInfo);
        Map<String, ScheduleShiftHisInfo> stringScheduleShiftHisInfoMap = AtsStoreToScheduleShiftUtil.getScheduleShiftHisForPersonByOql(ctx, AtsUtil.convertSetToString(personids), AtsDateUtils.dateShortToString(minStartTimeAndMaxEndTime.get("startDate")), AtsDateUtils.dateShortToString(minStartTimeAndMaxEndTime.get("endDate")), billId);
        Map<String, ScheduleShiftInfo> existSchedules = AtsScheduleShiftUtil.getScheduleShiftForPersonByOql(ctx, AtsUtil.convertSetToString(personids), AtsDateUtils.dateShortToString(minStartTimeAndMaxEndTime.get("startDate")), AtsDateUtils.dateShortToString(minStartTimeAndMaxEndTime.get("endDate")));
        ScheduleShiftHisCollection scheduleShiftHisCollection = new ScheduleShiftHisCollection();
        CoreBaseCollection coreBaseCollection = new CoreBaseCollection();
        HashMap<String, java.util.Date> noscheduleShift = new HashMap<String, java.util.Date>();
        for (int i = 0; i < billInfo.getSpts().size(); ++i) {
            ScheduleShiftInfo scheduleShiftInfo = null != existSchedules ? existSchedules.get(AtsScheduleShiftUtil.getKey(billInfo.getSpts().get(i).getPerson().getId().toString(), AtsDateUtils.dateShortToString(billInfo.getSpts().get(i).getAttendanceDate()))) : null;
            ScheduleShiftHisInfo scheduleShiftHisInfo = stringScheduleShiftHisInfoMap.get(AtsScheduleShiftUtil.getKey(billInfo.getSpts().get(i).getPerson().getId().toString(), AtsDateUtils.dateShortToString(billInfo.getSpts().get(i).getAttendanceDate())));
            if (null != scheduleShiftInfo) {
                coreBaseCollection.add((CoreBaseInfo)scheduleShiftInfo);
            }
            if (null != scheduleShiftHisInfo) {
                scheduleShiftHisCollection.add(scheduleShiftHisInfo);
                continue;
            }
            noscheduleShift.put(billInfo.getSpts().get(i).getPerson().getId().toString() + "_" + AtsDateUtils.dateShortToString(billInfo.getSpts().get(i).getAttendanceDate()), billInfo.getSpts().get(i).getAttendanceDate());
        }
        AtsStoreToScheduleShiftUtil.clearScheduleShiftFromHis(ctx, noscheduleShift, existSchedules);
        AtsStoreToScheduleShiftUtil.updateScheduleFromHis(ctx, scheduleShiftHisCollection, coreBaseCollection);
        ScheduleShiftHisFactory.getLocalInstance(ctx).delete("where scheduleShift in ('" + billInfo.getId().toString() + "')");
    }

    private static void clearScheduleShiftFromHis(Context ctx, HashMap<String, java.util.Date> noscheduleShift, Map existSchedules) {
        if (noscheduleShift.isEmpty()) {
            return;
        }
        Iterator<Map.Entry<String, java.util.Date>> iterator = noscheduleShift.entrySet().iterator();
        StringBuffer idSql = new StringBuffer();
        while (iterator.hasNext()) {
            Map.Entry<String, java.util.Date> next = iterator.next();
            ScheduleShiftInfo scheduleShiftInfo = (ScheduleShiftInfo)existSchedules.get(next.getKey());
            if (null == scheduleShiftInfo || null == scheduleShiftInfo.getId()) continue;
            idSql.append("'");
            idSql.append(scheduleShiftInfo.getId().toString());
            idSql.append("'");
            if (!iterator.hasNext()) continue;
            idSql.append(",");
        }
        try {
            ScheduleShiftCollection scheduleShiftCollection = ScheduleShiftFactory.getLocalInstance(ctx).getScheduleShiftCollection("select *, items.* where id in ( " + idSql.toString() + ")");
            if (scheduleShiftCollection != null && scheduleShiftCollection.size() > 0) {
                for (int i = 0; i < scheduleShiftCollection.size(); ++i) {
                    ScheduleShiftInfo scheduleShiftInfo = scheduleShiftCollection.get(i);
                    DataLogsRecordUtil.scheduleShiftDeleteLog(scheduleShiftInfo, ctx);
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        try {
            if (StringUtils.isNotEmpty((String)idSql.toString())) {
                DbUtil.execute((Context)ctx, (String)("delete from t_hr_ats_scheduleshiftitem where fgroupid in (" + idSql.toString() + ")"));
                DbUtil.execute((Context)ctx, (String)("delete from t_hr_ats_scheduleshift where fid in (" + idSql.toString() + ")"));
            }
        }
        catch (BOSException e) {
            e.printStackTrace();
        }
    }

    private static void updateScheduleFromHis(Context ctx, ScheduleShiftHisCollection scheduleShiftHisCollection, CoreBaseCollection coreBaseCollection) {
        if (scheduleShiftHisCollection.isEmpty()) {
            return;
        }
        if (!coreBaseCollection.isEmpty()) {
            ObjectUuidPK[] pks = new ObjectUuidPK[coreBaseCollection.size()];
            for (int index = 0; index < coreBaseCollection.size(); ++index) {
                pks[index] = new ObjectUuidPK(coreBaseCollection.get(index).getId());
            }
            try {
                ScheduleShiftFactory.getLocalInstance(ctx).deleteBatchData((IObjectPK[])pks);
            }
            catch (BOSException e) {
                e.printStackTrace();
            }
            catch (EASBizException e) {
                e.printStackTrace();
            }
        }
        Iterator iterator = scheduleShiftHisCollection.iterator();
        CoreBaseCollection scheduleShift = new CoreBaseCollection();
        CoreBaseCollection scheduleShiftItem = new CoreBaseCollection();
        while (iterator.hasNext()) {
            ScheduleShiftHisInfo scheduleShiftHisInfo = (ScheduleShiftHisInfo)iterator.next();
            ScheduleShiftInfo scheduleShiftInfo = new ScheduleShiftInfo();
            BeanUtils.copyProperties((Object)scheduleShiftHisInfo, (Object)scheduleShiftInfo);
            scheduleShiftInfo.setId(BOSUuid.create((String)"AE85E191"));
            ScheduleShiftItemHisCollection items = scheduleShiftHisInfo.getItems();
            Iterator iterators = items.iterator();
            scheduleShiftInfo.getItems().clear();
            while (iterators.hasNext()) {
                ScheduleShiftItemHisInfo scheduleShiftItemHisInfo = (ScheduleShiftItemHisInfo)iterators.next();
                ScheduleShiftItemInfo scheduleShiftItemInfo = new ScheduleShiftItemInfo();
                BeanUtils.copyProperties((Object)scheduleShiftItemHisInfo, (Object)scheduleShiftItemInfo);
                scheduleShiftItemInfo.setGroup(scheduleShiftInfo);
                scheduleShiftItem.add((CoreBaseInfo)scheduleShiftItemInfo);
            }
            scheduleShift.add((CoreBaseInfo)scheduleShiftInfo);
        }
        try {
            ScheduleShiftFactory.getLocalInstance(ctx).saveBatchData(scheduleShift);
            ScheduleShiftItemFactory.getLocalInstance(ctx).saveBatchData(scheduleShiftItem);
        }
        catch (BOSException e) {
            e.printStackTrace();
        }
        catch (EASBizException e) {
            e.printStackTrace();
        }
    }

    private static Map<String, ScheduleShiftHisInfo> getScheduleShiftHisForPersonByOql(Context ctx, String personIds, String beginDate, String endDate, String billId) {
        HashMap<String, ScheduleShiftHisInfo> resMap = new HashMap<String, ScheduleShiftHisInfo>();
        if (StringUtils.isEmpty((String)personIds)) {
            return resMap;
        }
        try {
            EntityViewInfo evi = new EntityViewInfo();
            evi.setSelector(AtsStoreToScheduleShiftUtil.getScheduleShiftSelector());
            FilterInfo fi = new FilterInfo();
            personIds = personIds.replaceAll("'", "");
            beginDate = beginDate.replaceAll("'", "");
            endDate = endDate.replaceAll("'", "");
            if (personIds.split(",").length == 1) {
                fi.getFilterItems().add(new FilterItemInfo("proposer.id", (Object)personIds, CompareType.EQUALS));
            } else {
                fi.getFilterItems().add(new FilterItemInfo("proposer.id", AtsUtil.getSetFromStringArr(personIds.split(",")), CompareType.INCLUDE));
            }
            if (beginDate.equals(endDate)) {
                fi.getFilterItems().add(new FilterItemInfo("attendDate", (Object)new Date(AtsDateUtils.stringToShortDate(beginDate).getTime()), CompareType.EQUALS));
            } else {
                fi.getFilterItems().add(new FilterItemInfo("attendDate", (Object)beginDate, CompareType.GREATER_EQUALS));
                fi.getFilterItems().add(new FilterItemInfo("attendDate", (Object)endDate, CompareType.LESS_EQUALS));
            }
            fi.getFilterItems().add(new FilterItemInfo("scheduleShift", (Object)billId, CompareType.EQUALS));
            evi.setFilter(fi);
            SorterItemInfo dateSort = new SorterItemInfo("attendDate");
            dateSort.setSortType(SortType.ASCEND);
            evi.getSorter().add(dateSort);
            SorterItemInfo segmentSort = new SorterItemInfo("items.segment");
            segmentSort.setSortType(SortType.ASCEND);
            evi.getSorter().add(segmentSort);
            ScheduleShiftHisCollection personColl = ScheduleShiftHisFactory.getLocalInstance(ctx).getScheduleShiftHisCollection(evi);
            if (null != personColl) {
                resMap = new HashMap();
                ScheduleShiftHisInfo scheduleShiftHisInfo = null;
                int size = personColl.size();
                for (int j = 0; j < size; ++j) {
                    scheduleShiftHisInfo = personColl.get(j);
                    java.util.Date attendDate = scheduleShiftHisInfo.getAttendDate();
                    String personid = scheduleShiftHisInfo.getProposer().getId().toString();
                    String attendDateStr = AtsDateUtils.dateShortToString(attendDate);
                    String key = AtsScheduleShiftUtil.getKey(personid, attendDateStr);
                    resMap.put(key, scheduleShiftHisInfo);
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return resMap;
    }

    private static SelectorItemCollection getScheduleShiftSelector() {
        SelectorItemCollection selectColl = new SelectorItemCollection();
        selectColl.add(new SelectorItemInfo("id"));
        selectColl.add(new SelectorItemInfo("attendDate"));
        selectColl.add(new SelectorItemInfo("standardHour"));
        selectColl.add(new SelectorItemInfo("dayType"));
        selectColl.add(new SelectorItemInfo("isHalfDay"));
        selectColl.add(new SelectorItemInfo("isElastic"));
        selectColl.add(new SelectorItemInfo("elasticType"));
        selectColl.add(new SelectorItemInfo("elasticDirection"));
        selectColl.add(new SelectorItemInfo("elasticValue"));
        selectColl.add(new SelectorItemInfo("matchDaytype"));
        selectColl.add(new SelectorItemInfo("matchShift.id"));
        selectColl.add(new SelectorItemInfo("attendPolicy.id"));
        selectColl.add(new SelectorItemInfo("attendFile.id"));
        selectColl.add(new SelectorItemInfo("lastUpdateTime"));
        selectColl.add(new SelectorItemInfo("defaultShift.id"));
        selectColl.add(new SelectorItemInfo("defaultShift.name"));
        selectColl.add(new SelectorItemInfo("defaultShift.number"));
        selectColl.add(new SelectorItemInfo("defaultShift.simpleName"));
        selectColl.add(new SelectorItemInfo("cardRule.id"));
        selectColl.add(new SelectorItemInfo("cardRule.startNum"));
        selectColl.add(new SelectorItemInfo("cardRule.endNum"));
        selectColl.add(new SelectorItemInfo("otCompens.id"));
        selectColl.add(new SelectorItemInfo("shiftType.id"));
        selectColl.add(new SelectorItemInfo("proposer.id"));
        selectColl.add(new SelectorItemInfo("adminOrgUnit.id"));
        selectColl.add(new SelectorItemInfo("position.id"));
        selectColl.add(new SelectorItemInfo("hrOrgUnit.id"));
        selectColl.add(new SelectorItemInfo("items.id"));
        selectColl.add(new SelectorItemInfo("items.attAdminOrgUnit.id"));
        selectColl.add(new SelectorItemInfo("items.attAdminOrgUnit.name"));
        selectColl.add(new SelectorItemInfo("items.segmentInRest"));
        selectColl.add(new SelectorItemInfo("items.segment"));
        selectColl.add(new SelectorItemInfo("items.preTime"));
        selectColl.add(new SelectorItemInfo("items.preDateTime"));
        selectColl.add(new SelectorItemInfo("items.preTimeDayType"));
        selectColl.add(new SelectorItemInfo("items.restPreTime"));
        selectColl.add(new SelectorItemInfo("items.restNextTime"));
        selectColl.add(new SelectorItemInfo("items.restPreDateTime"));
        selectColl.add(new SelectorItemInfo("items.restNextDateTime"));
        selectColl.add(new SelectorItemInfo("items.preFloatAdjusted"));
        selectColl.add(new SelectorItemInfo("items.preIsPunchCard"));
        selectColl.add(new SelectorItemInfo("items.nextTime"));
        selectColl.add(new SelectorItemInfo("items.nextDateTime"));
        selectColl.add(new SelectorItemInfo("items.nextTimeDayType"));
        selectColl.add(new SelectorItemInfo("items.nextFloatAdjusted"));
        selectColl.add(new SelectorItemInfo("items.nextIsPunchCard"));
        selectColl.add(new SelectorItemInfo("items.attendanceType"));
        selectColl.add(new SelectorItemInfo("items.attAdminOrgUnit.id"));
        selectColl.add(new SelectorItemInfo("items.itemsrctype"));
        return selectColl;
    }

    private static void scheduleShiftToSaveLog(Context ctx, HashMap<String, ScheduleShiftInfo> scheduleLog, AtsAcrossStoreSopportInfo billInfo) {
        CoreBaseCollection coreBaseCollection = new CoreBaseCollection();
        Iterator<Map.Entry<String, ScheduleShiftInfo>> iterator = scheduleLog.entrySet().iterator();
        StringBuffer osql = new StringBuffer();
        HashSet<String> personids = new HashSet<String>();
        for (int i = 0; i < billInfo.getSpts().size(); ++i) {
            if (null == billInfo.getSpts().get(i).getPerson()) continue;
            personids.add(billInfo.getSpts().get(i).getPerson().getId().toString());
        }
        Map<String, AttendanceFileInfo> atsFileHisMap = AtsStoreToScheduleShiftUtil.getAttendanceFileInfoByPersonId(ctx, AtsUtil.convertSetToString(personids));
        while (iterator.hasNext()) {
            Map.Entry<String, ScheduleShiftInfo> scheduleShiftInfoEntry = iterator.next();
            if (scheduleShiftInfoEntry.getValue() != null) {
                ScheduleShiftInfo scheduleShiftInfo = scheduleShiftInfoEntry.getValue();
                ScheduleShiftHisInfo scheduleShiftHisInfo = new ScheduleShiftHisInfo();
                BeanUtils.copyProperties((Object)scheduleShiftInfo, (Object)scheduleShiftHisInfo);
                scheduleShiftHisInfo.setId(BOSUuid.create((String)"6DE58441"));
                scheduleShiftHisInfo.setScheduleShift(billInfo.getId().toString());
                osql.append("'").append(scheduleShiftInfo.getId().toString()).append("'");
                if (iterator.hasNext()) {
                    osql.append(",");
                }
                ScheduleShiftItemCollection items = scheduleShiftInfo.getItems();
                ScheduleShiftItemHisCollection scheduleShiftItemHisCollection = new ScheduleShiftItemHisCollection();
                Iterator iterators = items.iterator();
                while (iterators.hasNext()) {
                    ScheduleShiftItemInfo scheduleShiftItemInfo = (ScheduleShiftItemInfo)iterators.next();
                    ScheduleShiftItemHisInfo scheduleShiftItemHisInfo = new ScheduleShiftItemHisInfo();
                    BeanUtils.copyProperties((Object)scheduleShiftItemInfo, (Object)scheduleShiftItemHisInfo);
                    scheduleShiftItemHisInfo.setId(null);
                    scheduleShiftItemHisInfo.setGroup(scheduleShiftHisInfo);
                    scheduleShiftItemHisCollection.add(scheduleShiftItemHisInfo);
                }
                scheduleShiftHisInfo.getItems().clear();
                scheduleShiftHisInfo.setAttendFile(atsFileHisMap.get(scheduleShiftHisInfo.getProposer().getId().toString()));
                scheduleShiftHisInfo.getItems().addCollection(scheduleShiftItemHisCollection);
                scheduleShiftHisInfo.setLastUpdateTime(new Timestamp(System.currentTimeMillis()));
                coreBaseCollection.add((CoreBaseInfo)scheduleShiftHisInfo);
            }
            try {
                ScheduleShiftHisFactory.getLocalInstance(ctx).saveBatchData(coreBaseCollection);
            }
            catch (BOSException e) {
                e.printStackTrace();
            }
            catch (EASBizException e) {
                e.printStackTrace();
            }
        }
    }
}

