/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.hr.ats.util;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.eas.basedata.person.PersonInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.framework.CoreBaseCollection;
import com.kingdee.eas.hr.ats.AtsLeaveBillEntryCollection;
import com.kingdee.eas.hr.ats.AtsLeaveBillEntryFactory;
import com.kingdee.eas.hr.ats.AtsLeaveBillEntryInfo;
import com.kingdee.eas.hr.ats.AtsLeaveBillFactory;
import com.kingdee.eas.hr.ats.AtsLeaveBillInfo;
import com.kingdee.eas.hr.ats.AtsOverTimeBillEntryCollection;
import com.kingdee.eas.hr.ats.AtsOverTimeBillFactory;
import com.kingdee.eas.hr.ats.AtsOverTimeBillInfo;
import com.kingdee.eas.hr.ats.AtsShiftFactory;
import com.kingdee.eas.hr.ats.AtsShiftInfo;
import com.kingdee.eas.hr.ats.AtsShiftItemCollection;
import com.kingdee.eas.hr.ats.AtsTripBillEntryCollection;
import com.kingdee.eas.hr.ats.AtsTripBillEntryFactory;
import com.kingdee.eas.hr.ats.AtsTripBillEntryInfo;
import com.kingdee.eas.hr.ats.AtsTripBillFactory;
import com.kingdee.eas.hr.ats.AtsTripBillInfo;
import com.kingdee.eas.hr.ats.AtsUtil;
import com.kingdee.eas.hr.ats.AttendFileStateEnum;
import com.kingdee.eas.hr.ats.AttendanceFileCollection;
import com.kingdee.eas.hr.ats.AttendanceFileFactory;
import com.kingdee.eas.hr.ats.AttendanceFileHISCollection;
import com.kingdee.eas.hr.ats.AttendanceFileHISFactory;
import com.kingdee.eas.hr.ats.AttendanceFileHISInfo;
import com.kingdee.eas.hr.ats.AttendanceFileInfo;
import com.kingdee.eas.hr.ats.CanTripBillEntryCollection;
import com.kingdee.eas.hr.ats.CanTripBillEntryInfo;
import com.kingdee.eas.hr.ats.CanTripBillFactory;
import com.kingdee.eas.hr.ats.CanTripBillInfo;
import com.kingdee.eas.hr.ats.CancelLeaveBillEntryCollection;
import com.kingdee.eas.hr.ats.CancelLeaveBillFactory;
import com.kingdee.eas.hr.ats.CancelLeaveBillInfo;
import com.kingdee.eas.hr.ats.CardRuleFactory;
import com.kingdee.eas.hr.ats.CardRuleInfo;
import com.kingdee.eas.hr.ats.FillSignCardEntryInfo;
import com.kingdee.eas.hr.ats.FillSignCardFactory;
import com.kingdee.eas.hr.ats.FillSignCardInfo;
import com.kingdee.eas.hr.ats.PunchCardRecordInfo;
import com.kingdee.eas.hr.ats.ScheduleShiftFactory;
import com.kingdee.eas.hr.ats.ScheduleShiftInfo;
import com.kingdee.eas.hr.ats.ScheduleShiftItemCollection;
import com.kingdee.eas.hr.ats.util.AtsDateUtils;
import com.kingdee.eas.hr.ats.util.AtsServerCalUtils;
import com.kingdee.eas.hr.ats.util.AtsServerCardRuleUtils;
import com.kingdee.eas.hr.ats.util.AtsWaitCalBatchThread;
import com.kingdee.eas.hr.ats.util.common.AtsCollectionUtile;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.util.UuidException;
import java.math.BigDecimal;
import java.sql.Date;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.lang3.StringUtils;

public class AtsWaitCalUtil {
    public static void updateHasCal2WaitCal(Context ctx, String personId, String attendanceDate) {
        StringBuilder updateSQL = new StringBuilder();
        Timestamp timestamp = AtsDateUtils.stringShortToTimestamp(attendanceDate);
        updateSQL.append(" update  T_HR_ATS_AttendanceResult  set FAttenceStatus = ? ");
        updateSQL.append("  where FProposerID= ?  and FAttenceDate= ?  and FAttenceStatus = ?");
        try {
            DbUtil.execute((Context)ctx, (String)updateSQL.toString(), (Object[])new Object[]{4, personId, timestamp, 1});
        }
        catch (BOSException e) {
            e.printStackTrace();
        }
    }

    public static void updateHasCal2WaitCalImport(Context ctx, List<ArrayList<Object[]>> listParams) {
        StringBuilder updateSQL = new StringBuilder();
        updateSQL.append(" update  T_HR_ATS_AttendanceResult  set FAttenceStatus ='4' ");
        updateSQL.append("  where FProposerID= ?  and FAttenceDate= ?  and FAttenceStatus ='1' ");
        List params = listParams.get(0);
        for (Object[] param : params) {
            param[1] = new Date(AtsDateUtils.stringToShortDate((String)param[1]).getTime());
        }
        try {
            DbUtil.executeBatch((Context)ctx, (String)updateSQL.toString(), (List)params);
        }
        catch (BOSException e) {
            e.printStackTrace();
        }
    }

    public static void updateHasCal2WaitCal(Context ctx, String personId, String beginDate, String endDate) {
        StringBuilder updateSQL = new StringBuilder();
        updateSQL.append(" update  T_HR_ATS_AttendanceResult  set FAttenceStatus ='4' ");
        updateSQL.append("  where FProposerID='" + personId + "' and FAttenceDate >= { ts'" + beginDate + " 00:00:00'}  and FAttenceDate <= { ts'" + endDate + " 00:00:00'}  and FAttenceStatus ='" + 1 + "' ");
        try {
            DbUtil.execute((Context)ctx, (String)updateSQL.toString());
        }
        catch (BOSException e) {
            e.printStackTrace();
        }
    }

    public static void updateBatchHasCal2WaitCal(Context ctx, Map<String, List<String>> personsAndDates) {
        AtsUtil.ATS_THREADPOOL.submit(new AtsWaitCalBatchThread(ctx, personsAndDates));
    }

    public static boolean isHasCal(Context ctx, String personId, String attendanceDate) {
        boolean boo = false;
        StringBuilder sql = new StringBuilder();
        sql.append("select FAttenceStatus from T_HR_ATS_AttendanceResult ").append("  where FProposerID='" + personId + "' and FAttenceDate= { ts'" + attendanceDate + " 00:00:00'}  and FAttenceStatus ='" + 1 + "' ");
        try {
            IRowSet rowSet = DbUtil.executeQuery((Context)ctx, (String)sql.toString());
            while (rowSet.next()) {
                if (rowSet.getInt(0) != 1) continue;
                boo = true;
            }
        }
        catch (BOSException e) {
            e.printStackTrace();
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
        return boo;
    }

    public static void atsBillWaitCal(Context ctx, String billId) {
        try {
            String sqltrip = " select * from  T_HR_ATS_TripBill where Fid = '" + billId + "' ";
            IRowSet rowtrip = null;
            rowtrip = DbUtil.executeQuery((Context)ctx, (String)sqltrip);
            if (rowtrip.size() != 0) {
                AtsTripBillInfo tripInfo = AtsTripBillFactory.getLocalInstance(ctx).getAtsTripBillInfo(" where id='" + billId + "'");
                AtsWaitCalUtil.atsTBWaitCal(ctx, tripInfo);
                return;
            }
            String sqlleave = " select * from  T_HR_ATS_LeaveBill where Fid = '" + billId + "' ";
            IRowSet rowleave = null;
            rowleave = DbUtil.executeQuery((Context)ctx, (String)sqlleave);
            if (rowleave.size() != 0) {
                AtsLeaveBillInfo leaveInfo = AtsLeaveBillFactory.getLocalInstance(ctx).getAtsLeaveBillInfo(" where id='" + billId + "'");
                AtsWaitCalUtil.atsLBWaitCal(ctx, leaveInfo);
                return;
            }
            String sqlcanleave = " select * from  T_HR_ATS_CanLeaveBill where Fid = '" + billId + "' ";
            IRowSet rowcanleave = null;
            rowcanleave = DbUtil.executeQuery((Context)ctx, (String)sqlcanleave);
            if (rowcanleave.size() != 0) {
                CancelLeaveBillInfo cancelleaveInfo = CancelLeaveBillFactory.getLocalInstance(ctx).getCancelLeaveBillInfo(" where id='" + billId + "'");
                AtsWaitCalUtil.atsCBWaitCal(ctx, cancelleaveInfo);
                return;
            }
            String sqlovertime = " select * from  T_HR_ATS_OverTimeBill where Fid = '" + billId + "' ";
            IRowSet rowovertime = null;
            rowovertime = DbUtil.executeQuery((Context)ctx, (String)sqlovertime);
            if (rowovertime.size() != 0) {
                AtsOverTimeBillInfo overTimeBillInfo = AtsOverTimeBillFactory.getLocalInstance(ctx).getAtsOverTimeBillInfo(" where id='" + billId + "'");
                AtsWaitCalUtil.atsOTBWaitCal(ctx, overTimeBillInfo);
                return;
            }
            String sqlfill = " select * from  T_HR_ATS_FillSignCard where Fid = '" + billId + "' ";
            IRowSet rowfill = null;
            rowfill = DbUtil.executeQuery((Context)ctx, (String)sqlfill);
            if (rowfill.size() != 0) {
                FillSignCardInfo fillInfo = FillSignCardFactory.getLocalInstance(ctx).getFillSignCardInfo(" where id='" + billId + "'");
                AtsWaitCalUtil.atsFSCWaitCal(ctx, fillInfo);
                return;
            }
            String sqlCanTrip = " select * from  T_ATS_CanTripBill where Fid = '" + billId + "' ";
            IRowSet rowCanTrip = null;
            rowCanTrip = DbUtil.executeQuery((Context)ctx, (String)sqlCanTrip);
            if (rowCanTrip.size() != 0) {
                CanTripBillInfo canTripBillInfo = CanTripBillFactory.getLocalInstance(ctx).getCanTripBillInfo((IObjectPK)new ObjectUuidPK(billId));
                AtsWaitCalUtil.atsCanTripBillWaitCal(ctx, canTripBillInfo);
                return;
            }
        }
        catch (BOSException e) {
            e.printStackTrace();
        }
        catch (EASBizException e) {
            e.printStackTrace();
        }
    }

    public static List<ArrayList<Object[]>> atsLBWaitCalImport(Context ctx, AtsLeaveBillInfo billInfo) {
        ArrayList<ArrayList<Object[]>> listParams = new ArrayList<ArrayList<Object[]>>();
        List<Object> personlistParams = new ArrayList();
        AtsLeaveBillEntryCollection entrysInfo = billInfo.getEntries();
        for (int i = 0; i < entrysInfo.size(); ++i) {
            String personId = entrysInfo.get(i).getPerson().getId().toString();
            String beginTime = AtsDateUtils.timestampToString(billInfo.getEntries().get(i).getRealBeginTime());
            String endTime = AtsDateUtils.timestampToString(billInfo.getEntries().get(i).getRealEndTime());
            personlistParams = AtsWaitCalUtil.entrysWaitCalImport(ctx, beginTime, endTime, personId);
            listParams.addAll(personlistParams);
        }
        return listParams;
    }

    public static void atsLBWaitCal(Context ctx, AtsLeaveBillInfo billInfo) {
        AtsLeaveBillEntryCollection entrysInfo = billInfo.getEntries();
        for (int i = 0; i < entrysInfo.size(); ++i) {
            String personId = entrysInfo.get(i).getPerson().getId().toString();
            String beginTime = AtsDateUtils.timestampToString(billInfo.getEntries().get(i).getRealBeginTime());
            String endTime = AtsDateUtils.timestampToString(billInfo.getEntries().get(i).getRealEndTime());
            AtsWaitCalUtil.entrysWaitCal(ctx, beginTime, endTime, personId);
        }
    }

    public static void atsOTBWaitCal(Context ctx, AtsOverTimeBillInfo billInfo) {
        AtsOverTimeBillEntryCollection entrysInfo = billInfo.getEntries();
        String currDate = AtsDateUtils.dateShortToString(new java.util.Date());
        for (int i = 0; i < entrysInfo.size(); ++i) {
            String personId = entrysInfo.get(i).getPerson().getId().toString();
            String otDate = AtsDateUtils.dateShortToString(billInfo.getEntries().get(i).getOtDate());
            if (currDate.compareTo(otDate) < 0) {
                return;
            }
            AtsWaitCalUtil.updateHasCal2WaitCal(ctx, personId, otDate);
        }
    }

    public static void atsOTBWaitCal(Context ctx, AtsOverTimeBillInfo billInfo, Map<String, List<String>> personsAndDates) {
        List<Object> dateList = null;
        AtsOverTimeBillEntryCollection entrysInfo = billInfo.getEntries();
        String currDate = AtsDateUtils.dateShortToString(new java.util.Date());
        for (int i = 0; i < entrysInfo.size(); ++i) {
            String personId = entrysInfo.get(i).getPerson().getId().toString();
            String otDate = AtsDateUtils.dateShortToString(billInfo.getEntries().get(i).getOtDate());
            if (currDate.compareTo(otDate) < 0) {
                return;
            }
            if (personsAndDates.get(personId) == null) {
                dateList = new ArrayList<String>();
                dateList.add(otDate);
                personsAndDates.put(personId, dateList);
                continue;
            }
            dateList = personsAndDates.get(personId);
            if (dateList.contains(otDate)) continue;
            dateList.add(otDate);
            personsAndDates.put(personId, dateList);
        }
    }

    public static void atsTBWaitCal(Context ctx, AtsTripBillInfo billInfo) {
        AtsTripBillEntryCollection entrysInfo = billInfo.getEntries();
        for (int i = 0; i < entrysInfo.size(); ++i) {
            String personId = entrysInfo.get(i).getPerson().getId().toString();
            String beginTime = AtsDateUtils.timestampToString(billInfo.getEntries().get(i).getTripStartTime());
            String endTime = AtsDateUtils.timestampToString(billInfo.getEntries().get(i).getTripEndTime());
            AtsWaitCalUtil.entrysWaitCal(ctx, beginTime, endTime, personId);
        }
    }

    public static void atsTBWaitCal(Context ctx, AtsTripBillInfo billInfo, Map<String, List<String>> personsAndDates) {
        AtsTripBillEntryCollection entrysInfo = billInfo.getEntries();
        for (int i = 0; i < entrysInfo.size(); ++i) {
            String personId = entrysInfo.get(i).getPerson().getId().toString();
            String beginTime = AtsDateUtils.timestampToString(billInfo.getEntries().get(i).getTripStartTime());
            String endTime = AtsDateUtils.timestampToString(billInfo.getEntries().get(i).getTripEndTime());
            AtsWaitCalUtil.entrysWaitCal(ctx, beginTime, endTime, personId, personsAndDates);
        }
    }

    public static void atsCBWaitCal(Context ctx, CancelLeaveBillInfo billInfo) {
        try {
            CancelLeaveBillEntryCollection entrysInfo = billInfo.getEntries();
            for (int i = 0; i < entrysInfo.size(); ++i) {
                String personId = entrysInfo.get(i).getPerson().getId().toString();
                String beginTime = AtsDateUtils.timestampToString(billInfo.getEntries().get(i).getRealLeaBeginTime());
                String endTime = AtsDateUtils.timestampToString(billInfo.getEntries().get(i).getRealLeaEndTime());
                AtsLeaveBillEntryInfo atsLeaveBillInfo = entrysInfo.get(i).getLeaveEntryBill();
                if (atsLeaveBillInfo.getId() == null) continue;
                AtsLeaveBillEntryCollection atsLeaveBillEntryInfos = AtsLeaveBillEntryFactory.getLocalInstance(ctx).getAtsLeaveBillEntryCollection("where id = '" + atsLeaveBillInfo.getId().toString() + "'");
                for (int j = 0; j < atsLeaveBillEntryInfos.size(); ++j) {
                    if (!personId.equals(atsLeaveBillEntryInfos.get(j).getPerson().getId().toString())) continue;
                    String leaveBillBeginTime = AtsDateUtils.timestampToString(atsLeaveBillEntryInfos.get(j).getBeginTime());
                    String leaveBillEndTime = AtsDateUtils.timestampToString(atsLeaveBillEntryInfos.get(j).getEndTime());
                    if (leaveBillBeginTime.compareTo(beginTime) < 0) {
                        AtsWaitCalUtil.entrysWaitCal(ctx, leaveBillBeginTime, beginTime, personId);
                    }
                    if (leaveBillEndTime.compareTo(endTime) <= 0) continue;
                    AtsWaitCalUtil.entrysWaitCal(ctx, endTime, leaveBillEndTime, personId);
                }
            }
        }
        catch (BOSException e) {
            e.printStackTrace();
        }
    }

    public static void atsCanTripBillWaitCal(Context ctx, CanTripBillInfo billInfo) {
        try {
            CanTripBillEntryCollection entrysInfo = billInfo.getEntries();
            for (int i = 0; i < entrysInfo.size(); ++i) {
                CanTripBillEntryInfo canTripBillEntryInfo = entrysInfo.get(i);
                PersonInfo tmpPerson = canTripBillEntryInfo.getPerson();
                String personId = tmpPerson != null && tmpPerson.getId() != null ? tmpPerson.getId().toString() : "";
                String beginTime = AtsDateUtils.timestampToString(canTripBillEntryInfo.getRealStartTime());
                String endTime = AtsDateUtils.timestampToString(canTripBillEntryInfo.getRealEndTime());
                AtsTripBillEntryInfo atsTripBillInfo = canTripBillEntryInfo.getTripEntryBill();
                String tripBillId = atsTripBillInfo != null && atsTripBillInfo.getId() != null ? atsTripBillInfo.getId().toString() : "";
                AtsTripBillEntryCollection atsTripBillEntryCollection = AtsTripBillEntryFactory.getLocalInstance(ctx).getAtsTripBillEntryCollection("where bill.id = '" + tripBillId + "'");
                for (int j = 0; j < atsTripBillEntryCollection.size(); ++j) {
                    AtsTripBillEntryInfo atsTripBillEntryInfo = atsTripBillEntryCollection.get(j);
                    String tmpPersonId = atsTripBillEntryCollection.get(j).getPerson().getId().toString();
                    if (!personId.equals(tmpPersonId)) continue;
                    String tripBillBeginTime = AtsDateUtils.timestampToString(atsTripBillEntryInfo.getTripStartTime());
                    String tripBillEndTime = AtsDateUtils.timestampToString(atsTripBillEntryInfo.getTripEndTime());
                    String beginDateStr = beginTime;
                    String endDateStr = endTime;
                    if (beginTime.compareTo(tripBillBeginTime) >= 0 && beginTime.compareTo(tripBillEndTime) <= 0) {
                        beginDateStr = tripBillBeginTime;
                    }
                    if (endTime.compareTo(tripBillBeginTime) >= 0 && endTime.compareTo(tripBillEndTime) <= 0) {
                        endDateStr = tripBillEndTime;
                    }
                    if (beginTime.compareTo(tripBillBeginTime) <= 0 && endTime.compareTo(tripBillEndTime) >= 0) {
                        beginDateStr = beginTime;
                        endDateStr = endTime;
                    }
                    AtsWaitCalUtil.entrysWaitCal(ctx, beginDateStr, endDateStr, tmpPersonId);
                }
            }
        }
        catch (BOSException e) {
            e.printStackTrace();
        }
    }

    public static void atsFSCWaitCal(Context ctx, FillSignCardInfo billInfo) {
        for (int i = 0; i < billInfo.getEntries().size(); ++i) {
            String personId = billInfo.getEntries().get(i).getPerson().getId().toString();
            String attDate = billInfo.getEntries().get(i).getAttendDate().toString();
            Timestamp fillCardTime = billInfo.getEntries().get(i).getFillCardTime();
            AtsWaitCalUtil.cardWaitCal(ctx, fillCardTime, attDate, personId);
        }
    }

    public static void atsFSCWaitCal(Context ctx, CoreBaseCollection insertColls, Map<String, List<String>> personsAndDates) {
        for (int j = 0; j < insertColls.size(); ++j) {
            FillSignCardInfo billInfo = (FillSignCardInfo)insertColls.get(j);
            for (int i = 0; i < billInfo.getEntries().size(); ++i) {
                String personId = billInfo.getEntries().get(i).getPerson().getId().toString();
                String attDate = billInfo.getEntries().get(i).getAttendDate().toString();
                Timestamp fillCardTime = billInfo.getEntries().get(i).getFillCardTime();
                AtsWaitCalUtil.cardWaitCal(ctx, fillCardTime, attDate, personId, personsAndDates);
            }
        }
    }

    public static void atsPCRWaitCal(Context ctx, PunchCardRecordInfo billInfo) {
        String personId = billInfo.getProposer().getId().toString();
        String attDate = AtsDateUtils.dateShortToString(billInfo.getPunchCardDate());
        Timestamp punchCardTime = billInfo.getPunchCardTime();
        AtsWaitCalUtil.cardWaitCal(ctx, punchCardTime, attDate, personId);
    }

    public static void atsPCRBatchWaitCal(Context ctx, Set<PunchCardRecordInfo> set) {
        try {
            ArrayList<String> dateList = new ArrayList<String>(100);
            HashSet<String> personIDSet = new HashSet<String>();
            String tempPersonId = null;
            for (PunchCardRecordInfo info : set) {
                dateList.add(AtsDateUtils.dateShortToString(info.getPunchCardDate()));
                tempPersonId = info.getProposer() != null && info.getProposer().getId() != null ? info.getProposer().getId().toString() : "";
                if (!StringUtils.isNotEmpty((CharSequence)tempPersonId)) continue;
                personIDSet.add(tempPersonId);
            }
            String personIds = AtsUtil.convertSetToString(personIDSet);
            String maxDate = AtsWaitCalUtil.getMaxData(dateList);
            String minDate = AtsWaitCalUtil.getMinData(dateList);
            String beginDate = AtsDateUtils.getPreDay(minDate);
            String endDate = AtsDateUtils.getNextDay(maxDate);
            Map<String, AttendanceFileInfo> fileInfoObject = AtsWaitCalUtil.getAttendanceFileInfoByPersonIdV2(ctx, personIds, beginDate, endDate);
            Map<String, List<ScheduleShiftInfo>> shiftItemMap = AtsServerCardRuleUtils.getScheduleShiftMainInfosForCardRuleV2(ctx, personIds, beginDate, endDate);
            Map<String, CardRuleInfo> cardRuleSingleInfoMap = AtsServerCalUtils.getAllCardRuleSingleInfos(ctx);
            HashMap<String, List<String>> personsAndDates = new HashMap<String, List<String>>();
            for (PunchCardRecordInfo info : set) {
                String personId = info != null && info.getProposer() != null && info.getProposer().getId() != null ? info.getProposer().getId().toString() : "";
                if (!StringUtils.isNotEmpty((CharSequence)personId)) continue;
                String attDate = info != null ? AtsDateUtils.dateShortToString(info.getPunchCardDate()) : null;
                Timestamp punchCardTime = info != null ? info.getPunchCardTime() : null;
                AtsWaitCalUtil.cardBatchWaitCal(ctx, punchCardTime, attDate, personId, personsAndDates, fileInfoObject, shiftItemMap, cardRuleSingleInfoMap);
            }
            AtsWaitCalUtil.updateBatchHasCal2WaitCal(ctx, personsAndDates);
        }
        catch (BOSException e) {
            e.printStackTrace();
        }
        catch (UuidException e) {
            e.printStackTrace();
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
    }

    public static void atsFSCEntryWaitCal(Context ctx, FillSignCardEntryInfo billInfo) {
        String personId = billInfo.getPerson().getId().toString();
        String attDate = billInfo.getAttendDate().toString();
        Timestamp fillCardTime = billInfo.getFillCardTime();
        AtsWaitCalUtil.cardWaitCal(ctx, fillCardTime, attDate, personId);
    }

    public static void atsScheduleShitSetWaitCal(Context ctx, Set<ScheduleShiftInfo> set) {
        try {
            String currDate = AtsDateUtils.dateShortToString(new java.util.Date());
            HashMap<String, List<String>> personsAndDates = new HashMap<String, List<String>>();
            List<String> dateList = null;
            for (ScheduleShiftInfo scheduleShiftInfo : set) {
                if (scheduleShiftInfo.getAttendDate() == null || scheduleShiftInfo.getProposer() == null) {
                    if (scheduleShiftInfo.getId() == null) continue;
                    scheduleShiftInfo = ScheduleShiftFactory.getLocalInstance(ctx).getScheduleShiftInfo((IObjectPK)new ObjectUuidPK(scheduleShiftInfo.getId().toString()));
                }
                String personId = scheduleShiftInfo.getProposer().getId().toString();
                String attDate = AtsDateUtils.dateShortToString(scheduleShiftInfo.getAttendDate());
                if (currDate.compareTo(attDate) < 0) continue;
                if (personsAndDates.get(personId) == null) {
                    dateList = new ArrayList<String>();
                    dateList.add(attDate);
                    personsAndDates.put(personId, dateList);
                    continue;
                }
                dateList = (List)personsAndDates.get(personId);
                dateList.add(attDate);
                personsAndDates.put(personId, dateList);
            }
            AtsWaitCalUtil.updateBatchHasCal2WaitCal(ctx, personsAndDates);
        }
        catch (EASBizException e) {
            e.printStackTrace();
        }
        catch (BOSException e) {
            e.printStackTrace();
        }
    }

    public static void atsScheduleShitCollWaitCal(Context ctx, CoreBaseCollection coll) {
        try {
            String currDate = AtsDateUtils.dateShortToString(new java.util.Date());
            HashMap<String, List<String>> personsAndDates = new HashMap<String, List<String>>();
            List<String> dateList = null;
            for (int i = 0; i < coll.size(); ++i) {
                ScheduleShiftInfo scheduleShiftInfo = (ScheduleShiftInfo)coll.get(i);
                if (scheduleShiftInfo.getAttendDate() == null || scheduleShiftInfo.getProposer() == null) {
                    if (scheduleShiftInfo.getId() == null) continue;
                    scheduleShiftInfo = ScheduleShiftFactory.getLocalInstance(ctx).getScheduleShiftInfo((IObjectPK)new ObjectUuidPK(scheduleShiftInfo.getId().toString()));
                }
                String personId = scheduleShiftInfo.getProposer().getId().toString();
                String attDate = AtsDateUtils.dateShortToString(scheduleShiftInfo.getAttendDate());
                if (currDate.compareTo(attDate) < 0) continue;
                if (personsAndDates.get(personId) == null) {
                    dateList = new ArrayList<String>();
                    dateList.add(attDate);
                    personsAndDates.put(personId, dateList);
                    continue;
                }
                dateList = (List)personsAndDates.get(personId);
                dateList.add(attDate);
                personsAndDates.put(personId, dateList);
            }
            AtsWaitCalUtil.updateBatchHasCal2WaitCal(ctx, personsAndDates);
        }
        catch (EASBizException e) {
            e.printStackTrace();
        }
        catch (BOSException e) {
            e.printStackTrace();
        }
    }

    public static void atsCardRuleWaitCal(Context ctx, CardRuleInfo cardRuleInfo) {
        try {
            String currDate = AtsDateUtils.dateShortToString(new java.util.Date());
            String cardRuleId = cardRuleInfo.getId().toString();
            String sql = "select ss.FID,ss.FProposerID,ss.FAttendDate from  T_HR_ATS_ScheduleShift as ss  left join T_HR_ATS_AttendanceResult as ar  on ss.FproposerID = ar.FproposerID and  ss.FAttendDate = ar.FAttenceDate where ar.FattenceStatus = 1 and ss.FCardRuleID = '" + cardRuleId + "'";
            IRowSet row = null;
            row = DbUtil.executeQuery((Context)ctx, (String)sql.toString());
            List<String> dateList = null;
            HashMap<String, List<String>> personsAndDates = new HashMap<String, List<String>>();
            while (row.next()) {
                String personId = row.getString("FProposerID");
                String attDate = AtsDateUtils.dateShortToString(row.getDate("FAttendDate"));
                if (currDate.compareTo(attDate) < 0) continue;
                if (personsAndDates.get(personId) == null) {
                    dateList = new ArrayList<String>();
                    dateList.add(attDate);
                    personsAndDates.put(personId, dateList);
                    continue;
                }
                dateList = (List)personsAndDates.get(personId);
                dateList.add(attDate);
                personsAndDates.put(personId, dateList);
            }
            AtsWaitCalUtil.updateBatchHasCal2WaitCal(ctx, personsAndDates);
        }
        catch (BOSException e) {
            e.printStackTrace();
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
    }

    public static AtsShiftInfo shiftInfoGet(Context ctx, ScheduleShiftInfo scheduleshiftinfo, AttendanceFileInfo attendanceFileInfo) {
        String shiftId = "";
        shiftId = scheduleshiftinfo.getDefaultShift() != null ? scheduleshiftinfo.getDefaultShift().getId().toString() : attendanceFileInfo.getAtsShift().getId().toString();
        AtsShiftInfo shiftInfo = null;
        try {
            shiftInfo = AtsShiftFactory.getLocalInstance(ctx).getAtsShiftInfo((IObjectPK)new ObjectUuidPK(shiftId));
        }
        catch (EASBizException e) {
            e.printStackTrace();
        }
        catch (BOSException e) {
            e.printStackTrace();
        }
        if (shiftInfo != null) {
            AtsShiftItemCollection shiftColl = shiftInfo.getItems();
            ScheduleShiftItemCollection scheduleColl = new ScheduleShiftItemCollection();
            if (scheduleshiftinfo != null) {
                scheduleColl = scheduleshiftinfo.getItems();
            }
            if (shiftColl.size() == scheduleColl.size()) {
                for (int j = 0; j < scheduleColl.size(); ++j) {
                    shiftColl.get(j).setPreTime(scheduleColl.get(j).getPreTime());
                    shiftColl.get(j).setNextTime(scheduleColl.get(j).getNextTime());
                    shiftColl.get(j).setPreIsPunchCard(scheduleColl.get(j).getPreIsPunchCard());
                    shiftColl.get(j).setNextIsPunchCard(scheduleColl.get(j).getNextIsPunchCard());
                    shiftColl.get(j).setPreTimeDayType(scheduleColl.get(j).getPreTimeDayType());
                    shiftColl.get(j).setNextTimeDayType(scheduleColl.get(j).getNextTimeDayType());
                    shiftColl.get(j).setSegment(scheduleColl.get(j).getSegment());
                    shiftColl.get(j).setPreFloatAdjusted(scheduleColl.get(j).getPreFloatAdjusted());
                    shiftColl.get(j).setNextFloatAdjusted(scheduleColl.get(j).getNextFloatAdjusted());
                    shiftColl.get(j).setRestPreTime(scheduleColl.get(j).getRestPreTime());
                    shiftColl.get(j).setRestNextTime(scheduleColl.get(j).getRestNextTime());
                    shiftColl.get(j).setSegmentInRest(scheduleColl.get(j).getSegmentInRest());
                    shiftColl.get(j).setAttendanceType(scheduleColl.get(j).getAttendanceType());
                }
            }
        }
        return shiftInfo;
    }

    public static void cardWaitCal(Context ctx, Timestamp cardTime, String attDate, String personId, Map<String, List<String>> personsAndDates) {
        List<Object> dateList = null;
        String temp_personId = "'" + personId + "'";
        String beginDate = AtsDateUtils.getPreDay(attDate);
        String endDate = AtsDateUtils.getNextDay(attDate);
        String currDate = AtsDateUtils.dateShortToString(new java.util.Date());
        try {
            if (currDate.compareTo(beginDate) < 0) {
                return;
            }
            Map<String, List<ScheduleShiftInfo>> shiftItemMap = AtsServerCardRuleUtils.getScheduleShiftMainInfosForCardRuleV2(ctx, temp_personId, beginDate, endDate);
            Map<String, AttendanceFileInfo> fileInfoObject = AtsWaitCalUtil.getAttendanceFileInfoByPersonId(ctx, temp_personId, beginDate, endDate);
            for (Map.Entry<String, List<ScheduleShiftInfo>> entry : shiftItemMap.entrySet()) {
                if (entry.getValue().size() < 0) continue;
                ScheduleShiftInfo scheduleShiftInfo = entry.getValue().get(0);
                String shiftDate = AtsDateUtils.dateShortToString(scheduleShiftInfo.getAttendDate());
                AttendanceFileInfo attendanceFileInfo = fileInfoObject.get(personId + "_" + shiftDate);
                CardRuleInfo cardRuleInfo = null;
                AtsShiftInfo shiftInfo = null;
                if (scheduleShiftInfo.getCardRule() == null) {
                    return;
                }
                String cardRuleId = scheduleShiftInfo.getCardRule().getId().toString();
                cardRuleInfo = CardRuleFactory.getLocalInstance(ctx).getCardRuleInfo((IObjectPK)new ObjectUuidPK(cardRuleId));
                if (scheduleShiftInfo != null && attendanceFileInfo != null) {
                    shiftInfo = AtsWaitCalUtil.shiftInfoGet(ctx, scheduleShiftInfo, attendanceFileInfo);
                }
                String shiftOnWorkTime = AtsWaitCalUtil.getShiftStartTime(shiftInfo, shiftDate);
                String shiftOffWorkTime = AtsWaitCalUtil.getShiftEndTime(shiftInfo, shiftDate);
                BigDecimal startNum = new BigDecimal("0.00");
                BigDecimal endNum = new BigDecimal("0.00");
                if (cardRuleInfo != null) {
                    startNum = cardRuleInfo.getStartNum();
                    endNum = cardRuleInfo.getEndNum();
                }
                String startTime = AtsWaitCalUtil.hourExtend(shiftOnWorkTime, startNum.multiply(new BigDecimal("-1")));
                String endTime = AtsWaitCalUtil.hourExtend(shiftOffWorkTime, endNum);
                if (cardTime.getTime() < AtsDateUtils.stringToTimestamp(startTime).getTime() || cardTime.getTime() > AtsDateUtils.stringToTimestamp(endTime).getTime()) continue;
                if (personsAndDates.get(personId) == null) {
                    dateList = new ArrayList<String>();
                    dateList.add(attDate);
                    personsAndDates.put(personId, dateList);
                    continue;
                }
                dateList = personsAndDates.get(personId);
                if (dateList.contains(attDate)) continue;
                dateList.add(attDate);
                personsAndDates.put(personId, dateList);
            }
        }
        catch (UuidException e) {
            e.printStackTrace();
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
        catch (EASBizException e) {
            e.printStackTrace();
        }
        catch (BOSException e) {
            e.printStackTrace();
        }
    }

    public static void cardWaitCal(Context ctx, Timestamp cardTime, String attDate, String personId) {
        String temp_personId = "'" + personId + "'";
        String beginDate = AtsDateUtils.getPreDay(attDate);
        String endDate = AtsDateUtils.getNextDay(attDate);
        String currDate = AtsDateUtils.dateShortToString(new java.util.Date());
        try {
            if (currDate.compareTo(beginDate) < 0) {
                return;
            }
            Map<String, List<ScheduleShiftInfo>> shiftItemMap = AtsServerCardRuleUtils.getScheduleShiftMainInfosForCardRuleV2(ctx, temp_personId, beginDate, endDate);
            Map<String, AttendanceFileInfo> fileInfoObject = AtsWaitCalUtil.getAttendanceFileInfoByPersonId(ctx, temp_personId, beginDate, endDate);
            if (shiftItemMap != null) {
                for (Map.Entry<String, List<ScheduleShiftInfo>> entry : shiftItemMap.entrySet()) {
                    if (entry.getValue().size() < 0) continue;
                    ScheduleShiftInfo scheduleShiftInfo = entry.getValue().get(0);
                    String shiftDate = AtsDateUtils.dateShortToString(scheduleShiftInfo.getAttendDate());
                    AttendanceFileInfo attendanceFileInfo = fileInfoObject.get(personId + "_" + shiftDate);
                    CardRuleInfo cardRuleInfo = null;
                    AtsShiftInfo shiftInfo = null;
                    if (scheduleShiftInfo.getCardRule() == null) {
                        return;
                    }
                    String cardRuleId = scheduleShiftInfo.getCardRule().getId().toString();
                    cardRuleInfo = CardRuleFactory.getLocalInstance(ctx).getCardRuleInfo((IObjectPK)new ObjectUuidPK(cardRuleId));
                    if (scheduleShiftInfo != null && attendanceFileInfo != null) {
                        shiftInfo = AtsWaitCalUtil.shiftInfoGet(ctx, scheduleShiftInfo, attendanceFileInfo);
                    }
                    String shiftOnWorkTime = AtsWaitCalUtil.getShiftStartTime(shiftInfo, shiftDate);
                    String shiftOffWorkTime = AtsWaitCalUtil.getShiftEndTime(shiftInfo, shiftDate);
                    BigDecimal startNum = new BigDecimal("0.00");
                    BigDecimal endNum = new BigDecimal("0.00");
                    if (cardRuleInfo != null) {
                        startNum = cardRuleInfo.getStartNum();
                        endNum = cardRuleInfo.getEndNum();
                    }
                    String startTime = AtsWaitCalUtil.hourExtend(shiftOnWorkTime, startNum.multiply(new BigDecimal("-1")));
                    String endTime = AtsWaitCalUtil.hourExtend(shiftOffWorkTime, endNum);
                    if (cardTime.getTime() < AtsDateUtils.stringToTimestamp(startTime).getTime() || cardTime.getTime() > AtsDateUtils.stringToTimestamp(endTime).getTime()) continue;
                    AtsWaitCalUtil.updateHasCal2WaitCal(ctx, personId, shiftDate);
                }
            }
        }
        catch (UuidException e) {
            e.printStackTrace();
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
        catch (EASBizException e) {
            e.printStackTrace();
        }
        catch (BOSException e) {
            e.printStackTrace();
        }
    }

    public static void cardBatchWaitCal(Context ctx, Timestamp cardTime, String attDate, String personId, Map<String, List<String>> personsAndDates, Map<String, AttendanceFileInfo> fileInfoObject, Map<String, List<ScheduleShiftInfo>> shiftItemMap, Map<String, CardRuleInfo> cardRuleSingleInfoMap) {
        String temp_personId = "'" + personId + "'";
        String beginDate = AtsDateUtils.getPreDay(attDate);
        String endDate = AtsDateUtils.getNextDay(attDate);
        String currDate = AtsDateUtils.dateShortToString(new java.util.Date());
        List<Object> dateList = null;
        if (currDate.compareTo(beginDate) < 0 || AtsCollectionUtile.isEmpty(shiftItemMap)) {
            return;
        }
        for (Map.Entry<String, List<ScheduleShiftInfo>> entry : shiftItemMap.entrySet()) {
            if (!personId.equals(entry.getKey().split("_")[0]) || entry.getValue().size() < 0) continue;
            ScheduleShiftInfo scheduleShiftInfo = entry.getValue().get(0);
            String shiftDate = AtsDateUtils.dateShortToString(scheduleShiftInfo.getAttendDate());
            AttendanceFileInfo attendanceFileInfo = fileInfoObject.get(personId + "_" + shiftDate);
            CardRuleInfo cardRuleInfo = null;
            AtsShiftInfo shiftInfo = null;
            if (scheduleShiftInfo.getCardRule() == null) {
                return;
            }
            String cardRuleId = scheduleShiftInfo.getCardRule().getId().toString();
            cardRuleInfo = cardRuleSingleInfoMap.get(cardRuleId);
            if (scheduleShiftInfo != null && attendanceFileInfo != null) {
                shiftInfo = AtsWaitCalUtil.shiftInfoGet(ctx, scheduleShiftInfo, attendanceFileInfo);
            }
            String shiftOnWorkTime = AtsWaitCalUtil.getShiftStartTime(shiftInfo, shiftDate);
            String shiftOffWorkTime = AtsWaitCalUtil.getShiftEndTime(shiftInfo, shiftDate);
            BigDecimal startNum = new BigDecimal("0.00");
            BigDecimal endNum = new BigDecimal("0.00");
            if (cardRuleInfo != null) {
                startNum = cardRuleInfo.getStartNum();
                endNum = cardRuleInfo.getEndNum();
            }
            String startTime = AtsWaitCalUtil.hourExtend(shiftOnWorkTime, startNum.multiply(new BigDecimal("-1")));
            String endTime = AtsWaitCalUtil.hourExtend(shiftOffWorkTime, endNum);
            if (cardTime.getTime() < AtsDateUtils.stringToTimestamp(startTime).getTime() || cardTime.getTime() > AtsDateUtils.stringToTimestamp(endTime).getTime()) continue;
            if (personsAndDates.get(personId) == null) {
                dateList = new ArrayList<String>();
                dateList.add(attDate);
                personsAndDates.put(personId, dateList);
                continue;
            }
            dateList = personsAndDates.get(personId);
            if (dateList.contains(attDate)) continue;
            dateList.add(attDate);
            personsAndDates.put(personId, dateList);
        }
    }

    public static List<ArrayList<Object[]>> entrysWaitCalImport(Context ctx, String beginTime, String endTime, String personId) {
        ArrayList<Object[]> personAndDate = new ArrayList<Object[]>();
        ArrayList<ArrayList<Object[]>> listParams = new ArrayList<ArrayList<Object[]>>();
        try {
            Object[] params = new Object[2];
            String currDate = AtsDateUtils.dateShortToString(new java.util.Date());
            String temp_personId = "'" + personId + "'";
            String beginDate = AtsDateUtils.getDateFromLongString(beginTime);
            String endDate = AtsDateUtils.getDateFromLongString(endTime);
            String shiftBeginDate = AtsDateUtils.getPreDay(beginDate);
            String shiftEndDate = AtsDateUtils.getNextDay(endDate);
            if (currDate.compareTo(shiftBeginDate) < 0) {
                return listParams;
            }
            if (currDate.compareTo(shiftBeginDate) >= 0 && currDate.compareTo(endDate) < 0) {
                endDate = currDate;
                shiftEndDate = currDate;
            }
            List<String> affectDateList = AtsDateUtils.getDateList(AtsDateUtils.getNextDay(beginDate), AtsDateUtils.getPreDay(endDate));
            ArrayList<String> mayAffectDateList = new ArrayList<String>();
            mayAffectDateList.add(shiftBeginDate);
            if (beginDate.equals(endDate)) {
                mayAffectDateList.add(beginDate);
            } else {
                mayAffectDateList.add(beginDate);
                mayAffectDateList.add(endDate);
            }
            if (!shiftEndDate.equals(endDate)) {
                mayAffectDateList.add(shiftEndDate);
            }
            Map<String, List<ScheduleShiftInfo>> shiftItemMap1 = AtsServerCardRuleUtils.getScheduleShiftMainInfosForCardRuleV2(ctx, temp_personId, shiftBeginDate, beginDate);
            Map<String, List<ScheduleShiftInfo>> shiftItemMap2 = AtsServerCardRuleUtils.getScheduleShiftMainInfosForCardRuleV2(ctx, temp_personId, endDate, shiftEndDate);
            HashMap<String, List<ScheduleShiftInfo>> shiftItemMap = new HashMap<String, List<ScheduleShiftInfo>>();
            shiftItemMap.putAll(shiftItemMap1);
            shiftItemMap.putAll(shiftItemMap2);
            Map<String, AttendanceFileInfo> fileInfoObject = AtsWaitCalUtil.getAttendanceFileInfoByPersonId(ctx, temp_personId, shiftBeginDate, shiftEndDate);
            for (String date : affectDateList) {
                params[0] = personId;
                params[1] = date;
                personAndDate.add(params);
                listParams.add(personAndDate);
            }
            for (String date : mayAffectDateList) {
                String shiftOffWorkTime;
                String shiftOnWorkTime;
                String key = personId + "_" + date;
                AttendanceFileInfo attendanceFileInfo = fileInfoObject.get(key);
                if (attendanceFileInfo == null) continue;
                if (attendanceFileInfo.getIsAttendance().getValue() == "0") {
                    if (attendanceFileInfo.getAtsShift() == null) continue;
                    String atsShiftId = attendanceFileInfo.getAtsShift().getId().toString();
                    AtsShiftInfo atsShiftInfo = AtsShiftFactory.getLocalInstance(ctx).getAtsShiftInfo((IObjectPK)new ObjectUuidPK(atsShiftId));
                    if (atsShiftInfo == null) continue;
                    shiftOnWorkTime = AtsWaitCalUtil.getShiftStartTime(atsShiftInfo, date);
                    shiftOffWorkTime = AtsWaitCalUtil.getShiftEndTime(atsShiftInfo, date);
                    if (shiftOnWorkTime.compareTo(endTime) >= 0 || shiftOffWorkTime.compareTo(beginTime) <= 0) continue;
                    params[0] = personId;
                    params[1] = date;
                    personAndDate.add(params);
                    listParams.add(personAndDate);
                    continue;
                }
                if (attendanceFileInfo.getIsAttendance().getValue() != "1" || shiftItemMap.get(key) == null || ((List)shiftItemMap.get(key)).size() <= 0) continue;
                AtsShiftInfo shiftInfo = null;
                ScheduleShiftInfo scheduleShiftInfo = (ScheduleShiftInfo)((List)shiftItemMap.get(key)).get(0);
                if (scheduleShiftInfo != null && attendanceFileInfo != null) {
                    shiftInfo = AtsWaitCalUtil.shiftInfoGet(ctx, scheduleShiftInfo, attendanceFileInfo);
                }
                if (shiftInfo == null) continue;
                shiftOnWorkTime = AtsWaitCalUtil.getShiftStartTime(shiftInfo, date);
                shiftOffWorkTime = AtsWaitCalUtil.getShiftEndTime(shiftInfo, date);
                if (shiftOnWorkTime.compareTo(endTime) >= 0 || shiftOffWorkTime.compareTo(beginTime) <= 0) continue;
                params[0] = personId;
                params[1] = date;
                personAndDate.add(params);
                listParams.add(personAndDate);
            }
            return listParams;
        }
        catch (BOSException e) {
            e.printStackTrace();
        }
        catch (UuidException e) {
            e.printStackTrace();
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
        catch (EASBizException e) {
            e.printStackTrace();
        }
        return listParams;
    }

    public static void entrysWaitCal(Context ctx, String beginTime, String endTime, String personId) {
        try {
            String currDate = AtsDateUtils.dateShortToString(new java.util.Date());
            String temp_personId = "'" + personId + "'";
            String beginDate = AtsDateUtils.getDateFromLongString(beginTime);
            String endDate = AtsDateUtils.getDateFromLongString(endTime);
            String shiftBeginDate = AtsDateUtils.getPreDay(beginDate);
            String shiftEndDate = AtsDateUtils.getNextDay(endDate);
            if (currDate.compareTo(shiftBeginDate) < 0) {
                return;
            }
            if (currDate.compareTo(shiftBeginDate) >= 0 && currDate.compareTo(endDate) < 0) {
                endDate = currDate;
                shiftEndDate = currDate;
            }
            List<String> affectDateList = AtsDateUtils.getDateList(AtsDateUtils.getNextDay(beginDate), AtsDateUtils.getPreDay(endDate));
            ArrayList<String> mayAffectDateList = new ArrayList<String>();
            mayAffectDateList.add(shiftBeginDate);
            if (beginDate.equals(endDate)) {
                mayAffectDateList.add(beginDate);
            } else {
                mayAffectDateList.add(beginDate);
                mayAffectDateList.add(endDate);
            }
            if (!shiftEndDate.equals(endDate)) {
                mayAffectDateList.add(shiftEndDate);
            }
            Map<String, List<ScheduleShiftInfo>> shiftItemMap1 = AtsServerCardRuleUtils.getScheduleShiftMainInfosForCardRuleV2(ctx, temp_personId, shiftBeginDate, beginDate);
            Map<String, List<ScheduleShiftInfo>> shiftItemMap2 = AtsServerCardRuleUtils.getScheduleShiftMainInfosForCardRuleV2(ctx, temp_personId, endDate, shiftEndDate);
            HashMap<String, List<ScheduleShiftInfo>> shiftItemMap = new HashMap<String, List<ScheduleShiftInfo>>();
            if (null != shiftItemMap1) {
                shiftItemMap.putAll(shiftItemMap1);
            }
            if (null != shiftItemMap2) {
                shiftItemMap.putAll(shiftItemMap2);
            }
            Map<String, AttendanceFileInfo> fileInfoObject = AtsWaitCalUtil.getAttendanceFileInfoByPersonId(ctx, temp_personId, shiftBeginDate, shiftEndDate);
            for (String date : affectDateList) {
                AtsWaitCalUtil.updateHasCal2WaitCal(ctx, personId, date);
            }
            for (String date : mayAffectDateList) {
                String shiftOffWorkTime;
                String shiftOnWorkTime;
                String key = personId + "_" + date;
                AttendanceFileInfo attendanceFileInfo = fileInfoObject.get(key);
                if (attendanceFileInfo == null) continue;
                if (attendanceFileInfo.getIsAttendance().getValue() == "0") {
                    if (attendanceFileInfo.getAtsShift() == null) continue;
                    String atsShiftId = attendanceFileInfo.getAtsShift().getId().toString();
                    AtsShiftInfo atsShiftInfo = AtsShiftFactory.getLocalInstance(ctx).getAtsShiftInfo((IObjectPK)new ObjectUuidPK(atsShiftId));
                    if (atsShiftInfo == null) continue;
                    shiftOnWorkTime = AtsWaitCalUtil.getShiftStartTime(atsShiftInfo, date);
                    shiftOffWorkTime = AtsWaitCalUtil.getShiftEndTime(atsShiftInfo, date);
                    if (shiftOnWorkTime.compareTo(endTime) >= 0 || shiftOffWorkTime.compareTo(beginTime) <= 0) continue;
                    AtsWaitCalUtil.updateHasCal2WaitCal(ctx, personId, date);
                    continue;
                }
                if (attendanceFileInfo.getIsAttendance().getValue() != "1" || shiftItemMap.get(key) == null || ((List)shiftItemMap.get(key)).size() <= 0) continue;
                AtsShiftInfo shiftInfo = null;
                ScheduleShiftInfo scheduleShiftInfo = (ScheduleShiftInfo)((List)shiftItemMap.get(key)).get(0);
                if (scheduleShiftInfo != null && attendanceFileInfo != null) {
                    shiftInfo = AtsWaitCalUtil.shiftInfoGet(ctx, scheduleShiftInfo, attendanceFileInfo);
                }
                if (shiftInfo == null) continue;
                shiftOnWorkTime = AtsWaitCalUtil.getShiftStartTime(shiftInfo, date);
                shiftOffWorkTime = AtsWaitCalUtil.getShiftEndTime(shiftInfo, date);
                if (shiftOnWorkTime.compareTo(endTime) >= 0 || shiftOffWorkTime.compareTo(beginTime) <= 0) continue;
                AtsWaitCalUtil.updateHasCal2WaitCal(ctx, personId, date);
            }
        }
        catch (BOSException e) {
            e.printStackTrace();
        }
        catch (UuidException e) {
            e.printStackTrace();
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
        catch (EASBizException e) {
            e.printStackTrace();
        }
    }

    public static void entrysWaitCal(Context ctx, String beginTime, String endTime, String personId, Map<String, List<String>> personsAndDates) {
        try {
            String currDate = AtsDateUtils.dateShortToString(new java.util.Date());
            String temp_personId = "'" + personId + "'";
            String beginDate = AtsDateUtils.getDateFromLongString(beginTime);
            String endDate = AtsDateUtils.getDateFromLongString(endTime);
            String shiftBeginDate = AtsDateUtils.getPreDay(beginDate);
            String shiftEndDate = AtsDateUtils.getNextDay(endDate);
            if (currDate.compareTo(shiftBeginDate) < 0) {
                return;
            }
            if (currDate.compareTo(shiftBeginDate) >= 0 && currDate.compareTo(endDate) < 0) {
                endDate = currDate;
                shiftEndDate = currDate;
            }
            List<String> affectDateList = AtsDateUtils.getDateList(AtsDateUtils.getNextDay(beginDate), AtsDateUtils.getPreDay(endDate));
            ArrayList<String> mayAffectDateList = new ArrayList<String>();
            mayAffectDateList.add(shiftBeginDate);
            if (beginDate.equals(endDate)) {
                mayAffectDateList.add(beginDate);
            } else {
                mayAffectDateList.add(beginDate);
                mayAffectDateList.add(endDate);
            }
            if (!shiftEndDate.equals(endDate)) {
                mayAffectDateList.add(shiftEndDate);
            }
            Map<String, List<ScheduleShiftInfo>> shiftItemMap1 = AtsServerCardRuleUtils.getScheduleShiftMainInfosForCardRuleV2(ctx, temp_personId, shiftBeginDate, beginDate);
            Map<String, List<ScheduleShiftInfo>> shiftItemMap2 = AtsServerCardRuleUtils.getScheduleShiftMainInfosForCardRuleV2(ctx, temp_personId, endDate, shiftEndDate);
            HashMap<String, List<ScheduleShiftInfo>> shiftItemMap = new HashMap<String, List<ScheduleShiftInfo>>();
            shiftItemMap.putAll(shiftItemMap1);
            shiftItemMap.putAll(shiftItemMap2);
            Map<String, AttendanceFileInfo> fileInfoObject = AtsWaitCalUtil.getAttendanceFileInfoByPersonId(ctx, temp_personId, shiftBeginDate, shiftEndDate);
            List<Object> dateList = null;
            for (String date : affectDateList) {
                if (personsAndDates.get(personId) == null) {
                    dateList = new ArrayList<String>();
                    dateList.add(date);
                    personsAndDates.put(personId, dateList);
                    continue;
                }
                dateList = personsAndDates.get(personId);
                if (dateList.contains(date)) continue;
                dateList.add(date);
                personsAndDates.put(personId, dateList);
            }
            for (String date : mayAffectDateList) {
                String shiftOffWorkTime;
                String shiftOnWorkTime;
                String key = personId + "_" + date;
                AttendanceFileInfo attendanceFileInfo = fileInfoObject.get(key);
                if (attendanceFileInfo == null) continue;
                if (attendanceFileInfo.getIsAttendance().getValue() == "0") {
                    if (attendanceFileInfo.getAtsShift() == null) continue;
                    String atsShiftId = attendanceFileInfo.getAtsShift().getId().toString();
                    AtsShiftInfo atsShiftInfo = AtsShiftFactory.getLocalInstance(ctx).getAtsShiftInfo((IObjectPK)new ObjectUuidPK(atsShiftId));
                    if (atsShiftInfo == null) continue;
                    shiftOnWorkTime = AtsWaitCalUtil.getShiftStartTime(atsShiftInfo, date);
                    shiftOffWorkTime = AtsWaitCalUtil.getShiftEndTime(atsShiftInfo, date);
                    if (shiftOnWorkTime.compareTo(endTime) >= 0 || shiftOffWorkTime.compareTo(beginTime) <= 0) continue;
                    if (personsAndDates.get(personId) == null) {
                        dateList = new ArrayList();
                        dateList.add(date);
                        personsAndDates.put(personId, dateList);
                        continue;
                    }
                    dateList = personsAndDates.get(personId);
                    if (dateList.contains(date)) continue;
                    dateList.add(date);
                    personsAndDates.put(personId, dateList);
                    continue;
                }
                if (attendanceFileInfo.getIsAttendance().getValue() != "1" || shiftItemMap.get(key) == null || ((List)shiftItemMap.get(key)).size() <= 0) continue;
                AtsShiftInfo shiftInfo = null;
                ScheduleShiftInfo scheduleShiftInfo = (ScheduleShiftInfo)((List)shiftItemMap.get(key)).get(0);
                if (scheduleShiftInfo != null && attendanceFileInfo != null) {
                    shiftInfo = AtsWaitCalUtil.shiftInfoGet(ctx, scheduleShiftInfo, attendanceFileInfo);
                }
                if (shiftInfo == null) continue;
                shiftOnWorkTime = AtsWaitCalUtil.getShiftStartTime(shiftInfo, date);
                shiftOffWorkTime = AtsWaitCalUtil.getShiftEndTime(shiftInfo, date);
                if (shiftOnWorkTime.compareTo(endTime) >= 0 || shiftOffWorkTime.compareTo(beginTime) <= 0) continue;
                if (personsAndDates.get(personId) == null) {
                    dateList = new ArrayList();
                    dateList.add(date);
                    personsAndDates.put(personId, dateList);
                    continue;
                }
                dateList = personsAndDates.get(personId);
                if (dateList.contains(date)) continue;
                dateList.add(date);
                personsAndDates.put(personId, dateList);
            }
        }
        catch (BOSException e) {
            e.printStackTrace();
        }
        catch (UuidException e) {
            e.printStackTrace();
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
        catch (EASBizException e) {
            e.printStackTrace();
        }
    }

    public static Map<String, AttendanceFileInfo> getAttendanceFileInfoByPersonIdV2(Context ctx, String personIds, String beginDate, String endDate) {
        HashMap<String, AttendanceFileInfo> fileInfoMap = new HashMap<String, AttendanceFileInfo>();
        List<String> dateList = AtsDateUtils.getDateList(beginDate, endDate);
        try {
            String oql = " where proposer in(" + personIds + ") and attendFileState = '" + "1" + "'  order by  attendanceNum ";
            AttendanceFileCollection fileColl = AttendanceFileFactory.getLocalInstance(ctx).getAttendanceFileCollection(oql);
            int size = fileColl.size();
            for (int i = 0; i < size; ++i) {
                String personId = fileColl.get(i).getProposer().getId().toString();
                for (String currentDate : dateList) {
                    String key = personId + "_" + currentDate;
                    fileInfoMap.put(key, fileColl.get(i));
                }
            }
        }
        catch (BOSException e) {
            e.printStackTrace();
        }
        return fileInfoMap;
    }

    public static String getShiftStartTime(AtsShiftInfo shiftInfo, String date) {
        String startTime = "";
        if (shiftInfo != null) {
            AtsShiftItemCollection shiftItemColl = shiftInfo.getItems();
            for (int j = 0; j < shiftItemColl.size(); ++j) {
                int segmentValue = Integer.parseInt(shiftItemColl.get(j).getSegment().getValue());
                if (segmentValue != 1) continue;
                String preTime = AtsDateUtils.getFullTime(shiftItemColl.get(j).getPreTime());
                String dayType = String.valueOf(shiftItemColl.get(j).getPreTimeDayType().getValue());
                startTime = AtsWaitCalUtil.timeToDateByDayType(preTime, dayType, date);
            }
        }
        return startTime;
    }

    public static String getShiftEndTime(AtsShiftInfo shiftInfo, String date) {
        String endTime = "";
        if (shiftInfo != null) {
            AtsShiftItemCollection shiftItemColl = shiftInfo.getItems();
            for (int j = 0; j < shiftItemColl.size(); ++j) {
                int segmentValue = Integer.parseInt(shiftItemColl.get(j).getSegment().getValue());
                if (segmentValue != shiftItemColl.size()) continue;
                String nextTime = AtsDateUtils.getFullTime(shiftItemColl.get(j).getNextTime());
                String dayType = String.valueOf(shiftItemColl.get(j).getNextTimeDayType().getValue());
                endTime = AtsWaitCalUtil.timeToDateByDayType(nextTime, dayType, date);
            }
        }
        return endTime;
    }

    public static String hourExtend(String date, BigDecimal num) {
        long hourMs = 3600000L;
        java.util.Date dt = AtsDateUtils.stringToLongDate(date);
        String str = AtsDateUtils.dateLongToString(new java.util.Date(dt.getTime() + num.multiply(new BigDecimal(hourMs)).longValue()));
        return str;
    }

    public static String timeToDateByDayType(String time, String dayType, String attDate) {
        String date = "";
        long dayMs = 86400000L;
        java.util.Date tempDate = AtsDateUtils.stringToShortDate(attDate);
        if (dayType.equals("0")) {
            date = AtsDateUtils.dateShortToString(new java.util.Date(tempDate.getTime() - dayMs)) + " " + time;
        } else if (dayType.equals("1")) {
            date = attDate + " " + time;
        } else if (dayType.equals("2")) {
            date = AtsDateUtils.dateShortToString(new java.util.Date(tempDate.getTime() + dayMs)) + " " + time;
        }
        return date;
    }

    public static String getMaxData(List<String> list) {
        if (list.size() > 0) {
            long min = AtsDateUtils.stringToShortDate(list.get(0)).getTime();
            String maxObject = list.get(0);
            for (int i = 1; i < list.size(); ++i) {
                long list_value = AtsDateUtils.stringToShortDate(list.get(i)).getTime();
                if (list_value <= min) continue;
                long temp = 0L;
                temp = min;
                min = list_value;
                maxObject = list.get(i);
                list_value = temp;
            }
            return maxObject;
        }
        return null;
    }

    public static String getMinData(List<String> list) {
        if (list.size() > 0) {
            long min = AtsDateUtils.stringToShortDate(list.get(0)).getTime();
            String minObject = list.get(0);
            for (int i = 1; i < list.size(); ++i) {
                long list_value = AtsDateUtils.stringToShortDate(list.get(i)).getTime();
                if (list_value >= min) continue;
                long temp = 0L;
                temp = min;
                min = list_value;
                minObject = list.get(i);
                list_value = temp;
            }
            return minObject;
        }
        return null;
    }

    public static Map<String, AttendanceFileInfo> getAttendanceFileInfoByPersonId(Context ctx, String personIds, String beginDate, String endDate) {
        HashMap<String, AttendanceFileInfo> fileInfoMap = new HashMap<String, AttendanceFileInfo>();
        List<String> dateList = AtsDateUtils.getDateList(beginDate, endDate);
        try {
            String oql = " where proposer in(" + personIds + ") and attendFileState = '" + "1" + "'  where FEffdt <= {ts '" + endDate + "'} and FLeffdt >= {ts '" + beginDate + "'}order by  attendanceNum ";
            AttendanceFileHISCollection fileColl = AttendanceFileHISFactory.getLocalInstance(ctx).getAttendanceFileHISCollection(oql);
            String personId = null;
            String key = null;
            AttendanceFileInfo fileInfo = null;
            AttendanceFileHISInfo hisInfo = null;
            for (String currentDate : dateList) {
                int size = fileColl.size();
                for (int i = 0; i < size; ++i) {
                    hisInfo = fileColl.get(i);
                    personId = hisInfo.getProposer().getId().toString();
                    key = personId + "_" + currentDate;
                    java.util.Date date = AtsDateUtils.stringToShortDate(currentDate);
                    if (hisInfo.getEFFDT() == null || hisInfo.getLEFFDT() == null || hisInfo.getEFFDT().getTime() > date.getTime() || hisInfo.getLEFFDT().getTime() < date.getTime()) continue;
                    fileInfo = AtsWaitCalUtil.convertHis2File(hisInfo);
                    fileInfoMap.put(key, fileInfo);
                }
            }
        }
        catch (BOSException e) {
            e.printStackTrace();
        }
        return fileInfoMap;
    }

    public static AttendanceFileInfo convertHis2File(AttendanceFileHISInfo hisInfo) {
        AttendanceFileInfo fileInfo = new AttendanceFileInfo();
        fileInfo.setAttendanceNum(hisInfo.getAttendanceNum());
        fileInfo.setIsAttendance(hisInfo.getIsAttendance());
        fileInfo.setAttendFileState(hisInfo.getAttendFileState());
        fileInfo.setRemark(hisInfo.getRemark());
        fileInfo.setAttendCenter(hisInfo.getAttendCenter());
        fileInfo.setAttencePolicy(hisInfo.getAttencePolicy());
        fileInfo.setHolidayPolicySet(hisInfo.getHolidayPolicySet());
        fileInfo.setAtsShift(hisInfo.getAtsShift());
        fileInfo.setFileType(hisInfo.getFileType());
        fileInfo.setIsAutoShift(hisInfo.getIsAutoShift());
        fileInfo.setProposer(hisInfo.getProposer());
        fileInfo.setHrOrgUnit(hisInfo.getHrOrgUnit());
        fileInfo.setPosition(hisInfo.getPosition());
        fileInfo.setAdminOrgUnit(hisInfo.getAdminOrgUnit());
        fileInfo.setEFFDT(hisInfo.getEFFDT());
        fileInfo.setLEFFDT(hisInfo.getLEFFDT());
        fileInfo.setAttendFileState(AttendFileStateEnum.enable);
        return fileInfo;
    }

    public static String requireRealityAttDate(Context ctx, Timestamp cardTime, String attDate, String personId) {
        String temp_personId = "'" + personId + "'";
        String beginDate = AtsDateUtils.getPreDay(attDate);
        String endDate = AtsDateUtils.getNextDay(attDate);
        String currDate = AtsDateUtils.dateShortToString(new java.util.Date());
        try {
            if (currDate.compareTo(beginDate) < 0) {
                return null;
            }
            Map<String, List<ScheduleShiftInfo>> shiftItemMap = AtsServerCardRuleUtils.getScheduleShiftMainInfosForCardRuleV2(ctx, temp_personId, beginDate, endDate);
            Map<String, AttendanceFileInfo> fileInfoObject = AtsWaitCalUtil.getAttendanceFileInfoByPersonId(ctx, temp_personId, beginDate, endDate);
            if (shiftItemMap != null) {
                for (Map.Entry<String, List<ScheduleShiftInfo>> entry : shiftItemMap.entrySet()) {
                    if (entry.getValue().size() < 0) continue;
                    ScheduleShiftInfo scheduleShiftInfo = entry.getValue().get(0);
                    String shiftDate = AtsDateUtils.dateShortToString(scheduleShiftInfo.getAttendDate());
                    String shiftLongDate = AtsDateUtils.dateLongToString(scheduleShiftInfo.getAttendDate());
                    AttendanceFileInfo attendanceFileInfo = fileInfoObject.get(personId + "_" + shiftDate);
                    CardRuleInfo cardRuleInfo = null;
                    AtsShiftInfo shiftInfo = null;
                    if (scheduleShiftInfo.getCardRule() == null) {
                        return null;
                    }
                    String cardRuleId = scheduleShiftInfo.getCardRule().getId().toString();
                    cardRuleInfo = CardRuleFactory.getLocalInstance(ctx).getCardRuleInfo((IObjectPK)new ObjectUuidPK(cardRuleId));
                    if (scheduleShiftInfo != null && attendanceFileInfo != null) {
                        shiftInfo = AtsWaitCalUtil.shiftInfoGet(ctx, scheduleShiftInfo, attendanceFileInfo);
                    }
                    String shiftOnWorkTime = AtsWaitCalUtil.getShiftStartTime(shiftInfo, shiftDate);
                    String shiftOffWorkTime = AtsWaitCalUtil.getShiftEndTime(shiftInfo, shiftDate);
                    BigDecimal startNum = new BigDecimal("0.00");
                    BigDecimal endNum = new BigDecimal("0.00");
                    if (cardRuleInfo != null) {
                        startNum = cardRuleInfo.getStartNum();
                        endNum = cardRuleInfo.getEndNum();
                    }
                    String startTime = AtsWaitCalUtil.hourExtend(shiftOnWorkTime, startNum.multiply(new BigDecimal("-1")));
                    String endTime = AtsWaitCalUtil.hourExtend(shiftOffWorkTime, endNum);
                    if (cardTime.getTime() < AtsDateUtils.stringToTimestamp(startTime).getTime() || cardTime.getTime() > AtsDateUtils.stringToTimestamp(endTime).getTime()) continue;
                    return shiftLongDate;
                }
            }
        }
        catch (UuidException e) {
            e.printStackTrace();
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
        catch (EASBizException e) {
            e.printStackTrace();
        }
        catch (BOSException e) {
            e.printStackTrace();
        }
        return null;
    }
}

