/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.hr.ats.util;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.basedata.person.PersonInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.framework.CoreBaseCollection;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.hr.ats.AtsCommonResEnum;
import com.kingdee.eas.hr.ats.AtsStaticResourceBizException;
import com.kingdee.eas.hr.ats.AttendLogType;
import com.kingdee.eas.hr.ats.AttendanceFileInfo;
import com.kingdee.eas.hr.ats.AttendanceLogCollection;
import com.kingdee.eas.hr.ats.AttendanceLogEntryCollection;
import com.kingdee.eas.hr.ats.AttendanceLogEntryFactory;
import com.kingdee.eas.hr.ats.AttendanceLogEntryInfo;
import com.kingdee.eas.hr.ats.AttendanceLogFactory;
import com.kingdee.eas.hr.ats.AttendanceLogInfo;
import com.kingdee.eas.hr.ats.util.AtsBaseUtils;
import com.kingdee.eas.hr.ats.util.AtsDateUtils;
import com.kingdee.eas.hr.ats.util.common.MLUtile;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import java.math.BigDecimal;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;

public class LoggerAtsJobInst {
    public static final String JOBINSTID = "jobInstId";
    public static final AtsStaticResourceBizException excepMsg = new AtsStaticResourceBizException(AtsStaticResourceBizException.NOSCHEDULESHIFTINFO);
    public static final AtsStaticResourceBizException attfileno = new AtsStaticResourceBizException(AtsStaticResourceBizException.PERSONWITHOUTEFFECTEMPLOYFILE);
    public static final AtsStaticResourceBizException hasLeft = new AtsStaticResourceBizException(AtsStaticResourceBizException.RETIREDORDIMISSIONPERSON);
    public static final AtsStaticResourceBizException attpolicyno = new AtsStaticResourceBizException(AtsStaticResourceBizException.PERSONWITHOUTATTENDANCEPOLICY);
    public static final AtsStaticResourceBizException schedulerepeat = new AtsStaticResourceBizException(AtsStaticResourceBizException.REPEATORWRONGSCHEDULESHIFT);
    private static Logger logger = Logger.getLogger(LoggerAtsJobInst.class);
    private static LoggerAtsJobInst atsJobInst = null;

    private LoggerAtsJobInst() {
    }

    public static void operatorAttendanceLogInfo(Context ctx, AttendanceLogCollection logCollection) {
        if (atsJobInst == null) {
            atsJobInst = new LoggerAtsJobInst();
        }
        atsJobInst.insertAttendLogInfo(ctx, logCollection);
    }

    private void insertAttendLogInfo(Context ctx, AttendanceLogCollection logCollection) {
        String jobInstId = (String)ctx.get((Object)JOBINSTID);
        if (logCollection.size() == 0) {
            return;
        }
        CoreBaseCollection coreInsertColl = new CoreBaseCollection();
        CoreBaseCollection coreUpdateColl = new CoreBaseCollection();
        try {
            int size = logCollection.size();
            for (int i = 0; i < size; ++i) {
                String jobid;
                AttendanceLogInfo loginfo = logCollection.get(i);
                Date attendDate = new Date();
                if (loginfo.getEntries() != null && loginfo.getEntries().get(0) != null) {
                    attendDate = loginfo.getEntries().get(0).getAttendDate();
                }
                String personid = null;
                if (loginfo.getEntries() != null && loginfo.getEntries().get(0) != null && loginfo.getEntries().get(0).getPerson() != null) {
                    personid = loginfo.getEntries().get(0).getPerson().getId().toString();
                }
                if ((jobid = loginfo.getJobid()) != null) {
                    logger.error((Object)(" ================ insertAttendLogInfo isexist  jobid ====== '" + jobid + "'"));
                    boolean isexist = AttendanceLogFactory.getLocalInstance(ctx).exists(" where jobid ='" + jobid + "' ");
                    if (isexist) {
                        AttendanceLogInfo existsLog = AttendanceLogFactory.getLocalInstance(ctx).getAttendanceLogInfo(" where jobid ='" + jobid + "' ");
                        AttendanceLogEntryCollection existsLogEntry = existsLog.getEntries();
                        loginfo.getEntries().addCollection(existsLogEntry);
                        AttendanceLogInfo info = loginfo;
                        info.setId(existsLog.getId());
                        coreUpdateColl.add((CoreBaseInfo)info);
                    } else {
                        AttendanceLogInfo info = loginfo;
                        coreInsertColl.add((CoreBaseInfo)info);
                    }
                }
                AttendanceLogFactory.getLocalInstance(ctx).updateBatchData(coreUpdateColl);
                AttendanceLogFactory.getLocalInstance(ctx).addnewBatchData(coreInsertColl);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static void operatorAttendanceLogInfoCal(final Context ctx, final AttendanceLogCollection logCollection) {
        if (atsJobInst == null) {
            atsJobInst = new LoggerAtsJobInst();
        }
        Thread thread = new Thread(new Runnable(){

            @Override
            public void run() {
                try {
                    atsJobInst;
                    LoggerAtsJobInst.insertAttendLogInfoCal(ctx, logCollection);
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        });
        thread.start();
    }

    public static void insertAttendLogInfoCal(Context ctx, AttendanceLogCollection logCollection) {
        if (logCollection.size() == 0) {
            return;
        }
        CoreBaseCollection coreInsertColl = new CoreBaseCollection();
        CoreBaseCollection coreUpdateColl = new CoreBaseCollection();
        try {
            int size = logCollection.size();
            for (int i = 0; i < size; ++i) {
                AttendanceLogInfo loginfo;
                AttendanceLogInfo info = loginfo = logCollection.get(i);
                String jobid = loginfo.getJobid();
                if (jobid == null) continue;
                AttendanceLogCollection coll = AttendanceLogFactory.getLocalInstance(ctx).getAttendanceLogCollection(" where jobid ='" + jobid + "' ");
                if (coll.size() > 0) {
                    return;
                }
                coreInsertColl.add((CoreBaseInfo)info);
            }
            AttendanceLogFactory.getLocalInstance(ctx).addnewBatchData(coreInsertColl);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static void updateAttendLogInfo(Context ctx, AttendanceLogInfo logInfo) {
        String jobInstId = (String)ctx.get((Object)JOBINSTID);
        try {
            if (StringUtils.isNotBlank((String)jobInstId)) {
                String updateSql = "update T_HR_ATS_AttendanceLog set FCalStatus = '2' where FJobid = ?";
                logger.error((Object)("============= updateAttendLogInfo  jobid =========== '" + jobInstId + "'"));
                Object[] params = new Object[]{jobInstId};
                logger.error((Object)("============= AttendanceLogInfo updateAttendLogInfo  updateSql  =========== '" + updateSql + "'"));
                DbUtil.execute((Context)ctx, (String)updateSql, (Object[])params);
                AttendanceLogInfo dbinfo = AttendanceLogFactory.getLocalInstance(ctx).getAttendanceLogInfo(" where jobid='" + jobInstId + "' ");
                int state = dbinfo.getCalStatus().getValue();
                if (state == 2 && dbinfo.getCostTime() != null) {
                    long costtime = dbinfo.getCostTime().longValue();
                    String updatesql = " update T_HR_ATS_AttendanceLog set FremainTime = '0', FcostSumTime='" + costtime + "'   where FJobid =  '" + jobInstId + "' ";
                    logger.error((Object)("============= updateAttendLogInfo  updatesql =========== '" + updatesql + "'"));
                    DbUtil.execute((Context)ctx, (String)updatesql);
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static void updateAttendanceLogCostTimeInfo(final Context ctx, final Map<String, Object> paraMap) {
        if (atsJobInst == null) {
            atsJobInst = new LoggerAtsJobInst();
        }
        Thread thread = new Thread(new Runnable(){

            @Override
            public void run() {
                try {
                    atsJobInst;
                    LoggerAtsJobInst.updateAttendLogCostTimeInfo(ctx, paraMap);
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        });
        thread.start();
    }

    public static void updateAttendLogCostTimeInfo(Context ctx, Map<String, Object> paraMap) {
        String jobInstId = (String)ctx.get((Object)JOBINSTID);
        int calPersonSize = 0;
        long costTime = 0L;
        long costSumTime = 0L;
        long remainTime = 0L;
        if (paraMap.get("calPersonSize") != null) {
            calPersonSize = (Integer)paraMap.get("calPersonSize");
        }
        if (paraMap.get("costSumTime") != null) {
            costSumTime = (Long)paraMap.get("costSumTime");
        }
        if (paraMap.get("costTime") != null) {
            costTime = (Long)paraMap.get("costTime");
        }
        if (paraMap.get("remainTime") != null) {
            remainTime = (Long)paraMap.get("remainTime");
        }
        try {
            if (StringUtils.isNotBlank((String)jobInstId)) {
                String updateSql = "";
                if (paraMap.get("updateCostSumTime") != null) {
                    boolean updateCostSumTime = (Boolean)paraMap.get("updateCostSumTime");
                    if (updateCostSumTime) {
                        updateSql = "update T_HR_ATS_AttendanceLog set FCalPersonSize = '" + calPersonSize + "',FCostSumTime='" + costSumTime + "'   ,FCostTime='" + costTime + "', FRemainTime='" + remainTime + "' ,fcalstatus='1'  where FJobid = '" + jobInstId + "' ";
                    }
                } else {
                    updateSql = "update T_HR_ATS_AttendanceLog set FCalPersonSize = '" + calPersonSize + "'  ,FCostTime='" + costTime + "', FRemainTime='" + remainTime + "' ,fcalstatus='1'  where FJobid = '" + jobInstId + "' ";
                }
                Object[] params = new Object[]{jobInstId};
                if (StringUtils.isNotBlank((String)updateSql)) {
                    DbUtil.execute((Context)ctx, (String)updateSql);
                }
            }
        }
        catch (BOSException e) {
            e.printStackTrace();
        }
    }

    public static AttendanceLogInfo setAttendanceLogInfo(Map<String, Object> paraMap) {
        AttendanceLogInfo logInfo = new AttendanceLogInfo();
        AttendanceLogEntryInfo entryInfo = new AttendanceLogEntryInfo();
        String jobid = null;
        if (paraMap.get("jobid") != null) {
            jobid = (String)paraMap.get("jobid");
        }
        int logType = 1;
        if (paraMap.get("logType") != null) {
            logType = (Integer)paraMap.get("logType");
        }
        int sumPerson = 0;
        if (paraMap.get("sumPerson") != null) {
            sumPerson = (Integer)paraMap.get("sumPerson");
            logInfo.setSumPerson(BigDecimal.valueOf(sumPerson));
        }
        int sumDays = 0;
        if (paraMap.get("sumDays") != null) {
            sumDays = (Integer)paraMap.get("sumDays");
            logInfo.setSumDays(BigDecimal.valueOf(sumDays));
        }
        int sucessTimes = 0;
        if (paraMap.get("sucessTimes") != null) {
            sucessTimes = (Integer)paraMap.get("sucessTimes");
            logInfo.setSucessTimes(BigDecimal.valueOf(sucessTimes));
        }
        int failTimes = 0;
        if (paraMap.get("failTimes") != null) {
            failTimes = (Integer)paraMap.get("failTimes");
            logInfo.setFailTimes(BigDecimal.valueOf(failTimes));
        }
        Date attendDate = new Date();
        if (paraMap.get("attendDate") != null) {
            attendDate = (Date)paraMap.get("attendDate");
            entryInfo.setAttendDate(attendDate);
        }
        String excepNumber = null;
        if (paraMap.get("excepNumber") != null) {
            excepNumber = (String)paraMap.get("excepNumber");
            entryInfo.setExcepNumber(excepNumber);
        }
        String excepMsg = null;
        if (paraMap.get("excepMsg") != null) {
            excepMsg = (String)paraMap.get("excepMsg");
            entryInfo.setExcepMsg(excepMsg);
        }
        String personid = null;
        if (paraMap.get("personid") != null) {
            personid = (String)paraMap.get("personid");
            PersonInfo pinfo = new PersonInfo();
            if (personid != null) {
                pinfo.setId(BOSUuid.read((String)personid));
                entryInfo.setPerson(pinfo);
            }
        }
        int calPersonSize = 0;
        if (paraMap.get("calPersonSize") != null) {
            calPersonSize = (Integer)paraMap.get("calPersonSize");
            logInfo.setCalPersonSize(BigDecimal.valueOf(calPersonSize));
        }
        long costSumTime = 0L;
        if (paraMap.get("costSumTime") != null) {
            costSumTime = (Long)paraMap.get("costSumTime");
            logInfo.setCostSumTime(BigDecimal.valueOf(costSumTime));
        }
        long costTime = 0L;
        if (paraMap.get("costTime") != null) {
            costTime = (Long)paraMap.get("costTime");
            logInfo.setCostTime(BigDecimal.valueOf(costTime));
        }
        long remainTime = 0L;
        if (paraMap.get("remainTime") != null) {
            remainTime = (Long)paraMap.get("remainTime");
            logInfo.setRemainTime(BigDecimal.valueOf(remainTime));
        }
        logInfo.setJobid(jobid);
        logInfo.setLogType(AttendLogType.getEnum(logType));
        if (paraMap.get("attendDate") != null || personid != null) {
            logInfo.getEntries().add(entryInfo);
        }
        return logInfo;
    }

    public static AttendanceLogInfo setAttendanceLogInfocal(Map<String, Object> paraMap) {
        AttendanceLogInfo logInfo = new AttendanceLogInfo();
        String jobid = null;
        if (paraMap.get("jobid") != null) {
            jobid = (String)paraMap.get("jobid");
        }
        if (paraMap.get("sucessTimes") != null) {
            int sucessTimes = (Integer)paraMap.get("sucessTimes");
            logInfo.setSucessTimes(new BigDecimal(sucessTimes));
        }
        if (paraMap.get("failTimes") != null) {
            int failTimes = (Integer)paraMap.get("failTimes");
            logInfo.setFailTimes(new BigDecimal(failTimes));
        }
        if (paraMap.get("sumPerson") != null) {
            int sumPerson = (Integer)paraMap.get("sumPerson");
            logInfo.setSumPerson(new BigDecimal(sumPerson));
        }
        if (paraMap.get("sumDays") != null) {
            int sumDays = (Integer)paraMap.get("sumDays");
            logInfo.setSumDays(new BigDecimal(sumDays));
        }
        logInfo.setJobid(jobid);
        logInfo.setLogType(AttendLogType.attendManage);
        return logInfo;
    }

    public static AttendanceLogInfo setAttendanceLogInfoInner(Map<String, Object> paraMap) {
        AttendanceLogInfo logInfo = new AttendanceLogInfo();
        String jobid = null;
        if (paraMap.get("jobid") != null) {
            jobid = (String)paraMap.get("jobid");
        }
        int sucessTimes = 0;
        if (paraMap.get("sucessTimes") != null) {
            sucessTimes = (Integer)paraMap.get("sucessTimes");
        }
        int failTimes = 0;
        if (paraMap.get("failTimes") != null) {
            failTimes = (Integer)paraMap.get("failTimes");
        }
        Date attendDate = new Date();
        if (paraMap.get("attendDate") != null) {
            attendDate = (Date)paraMap.get("attendDate");
        }
        String excepNumber = null;
        if (paraMap.get("excepNumber") != null) {
            excepNumber = (String)paraMap.get("excepNumber");
        }
        String excepMsg = null;
        if (paraMap.get("excepMsg") != null) {
            excepMsg = (String)paraMap.get("excepMsg");
        }
        String personid = null;
        if (paraMap.get("personid") != null) {
            personid = (String)paraMap.get("personid");
        }
        logInfo.setJobid(jobid);
        logInfo.setSucessTimes(BigDecimal.valueOf(sucessTimes));
        logInfo.setFailTimes(BigDecimal.valueOf(failTimes));
        logInfo.setLogType(AttendLogType.attendManage);
        AttendanceLogEntryInfo entryInfo = new AttendanceLogEntryInfo();
        entryInfo.setAttendDate(attendDate);
        entryInfo.setExcepNumber(excepNumber);
        entryInfo.setExcepMsg(excepMsg);
        PersonInfo pinfo = new PersonInfo();
        if (personid != null) {
            pinfo.setId(BOSUuid.read((String)personid));
        }
        entryInfo.setPerson(pinfo);
        if (paraMap.get("attendDate") != null && personid != null) {
            logInfo.getEntries().add(entryInfo);
        }
        return logInfo;
    }

    public static void collectionExceptionInfo(final Context ctx, final String exceptionInfo) {
        if (atsJobInst == null) {
            atsJobInst = new LoggerAtsJobInst();
        }
        Thread thread = new Thread(new Runnable(){

            @Override
            public void run() {
                try {
                    atsJobInst.insertExceptionInfo(ctx, exceptionInfo);
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        });
        thread.start();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void insertExceptionInfo(Context ctx, String exceptionInfo) {
        String jobInstId = (String)ctx.get((Object)JOBINSTID);
        if (org.apache.commons.lang3.StringUtils.isEmpty((CharSequence)exceptionInfo)) {
            return;
        }
        try {
            StringBuffer addExceptionInfo = new StringBuffer();
            String querySql = "select flocalExplain from T_JOB_INST where fjobInstId = ?";
            Object[] params = new Object[]{jobInstId};
            IRowSet rowSet = DbUtil.executeQuery((Context)ctx, (String)querySql, (Object[])params);
            if (rowSet != null) {
                while (rowSet.next()) {
                    addExceptionInfo.append(rowSet.getString("flocalExplain") + exceptionInfo);
                }
            }
            String updateSql = "update T_JOB_INST set flocalExplain = ? where fjobInstId = ?";
            params = new Object[]{addExceptionInfo.toString(), jobInstId};
            DbUtil.execute((Context)ctx, (String)updateSql, (Object[])params);
        }
        catch (SQLException e) {
            com.kingdee.bos.ctrl.kdf.data.logging.Logger.error((Throwable)e, (String)(MLUtile.getRes(AtsCommonResEnum.SaveError, ctx) + "\uff01"));
        }
        catch (BOSException e) {
            e.printStackTrace();
        }
    }

    public static void updateAttendanceLogTimesInfo(final Context ctx, final AttendanceLogCollection logColl) {
        if (atsJobInst == null) {
            atsJobInst = new LoggerAtsJobInst();
        }
        Thread thread = new Thread(new Runnable(){

            @Override
            public void run() {
                try {
                    atsJobInst.updateAttendLogTimesInfo(ctx, logColl);
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        });
        thread.start();
    }

    private void updateAttendLogTimesInfo(Context ctx, AttendanceLogCollection logColl) {
        if (logColl.size() == 0) {
            return;
        }
        CoreBaseCollection coreInsertColl = new CoreBaseCollection();
        CoreBaseCollection coreUpdateColl = new CoreBaseCollection();
        try {
            int size = logColl.size();
            for (int i = 0; i < size; ++i) {
                boolean isexist;
                AttendanceLogInfo loginfo;
                AttendanceLogInfo info = loginfo = logColl.get(i);
                Date attendDate = new Date();
                if (loginfo.getEntries() != null && loginfo.getEntries().get(0) != null) {
                    attendDate = loginfo.getEntries().get(0).getAttendDate();
                }
                String personid = null;
                if (loginfo.getEntries() != null && loginfo.getEntries().get(0) != null && loginfo.getEntries().get(0).getPerson() != null) {
                    personid = loginfo.getEntries().get(0).getPerson().getId().toString();
                }
                if (attendDate == null || personid == null) {
                    String jobid = loginfo.getJobid();
                    if (jobid == null) continue;
                    isexist = AttendanceLogFactory.getLocalInstance(ctx).exists(" where jobid ='" + jobid + "' ");
                    if (isexist) {
                        coreUpdateColl.add((CoreBaseInfo)info);
                        continue;
                    }
                    coreInsertColl.add((CoreBaseInfo)info);
                    continue;
                }
                String attenddate = AtsDateUtils.dateShortToString(attendDate);
                isexist = AttendanceLogEntryFactory.getLocalInstance(ctx).exists(" where person ='" + personid + "' and attendDate='" + attenddate + "' ");
                if (isexist) {
                    coreUpdateColl.add((CoreBaseInfo)info);
                    continue;
                }
                coreInsertColl.add((CoreBaseInfo)info);
            }
            AttendanceLogFactory.getLocalInstance(ctx).updateBatchData(coreUpdateColl);
            AttendanceLogFactory.getLocalInstance(ctx).addnewBatchData(coreInsertColl);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static void updateAttendLogTimesInfoSQL(Context ctx, AttendanceLogCollection logColl, Map<Object, Object> globalMap) {
        if (logColl.size() == 0) {
            return;
        }
        try {
            ArrayList<CharSequence> batchSqlList = new ArrayList<CharSequence>(1000);
            String jobid = null;
            if (ctx != null && ctx.get((Object)JOBINSTID) != null) {
                jobid = (String)ctx.get((Object)JOBINSTID);
            }
            if (jobid != null) {
                int i;
                boolean existRecord = AttendanceLogFactory.getLocalInstance(ctx).exists(" where jobid = '" + jobid + "' ");
                if (!existRecord && logColl.size() > 0) {
                    AttendanceLogFactory.getLocalInstance(ctx).addnew(logColl.get(0));
                }
                AttendanceLogInfo reLogInfo = AttendanceLogFactory.getLocalInstance(ctx).getAttendanceLogInfo(" where jobid = '" + jobid + "' ");
                String fmainid = reLogInfo.getId().toString();
                String personIds = (String)globalMap.get("personIds");
                String beginDate = (String)globalMap.get("beginDate");
                String endDate = (String)globalMap.get("endDate");
                String oql = " where group='" + fmainid + "' and attenddate >= '" + beginDate + "' and attenddate <= '" + endDate + "'  and person in( " + personIds + " )  ";
                AttendanceLogEntryCollection entryColl = AttendanceLogEntryFactory.getLocalInstance(ctx).getAttendanceLogEntryCollection(oql);
                HashMap<String, AttendanceLogEntryInfo> entryMap = new HashMap<String, AttendanceLogEntryInfo>();
                int size = entryColl.size();
                for (i = 0; i < size; ++i) {
                    AttendanceLogEntryInfo entryInfo = entryColl.get(i);
                    String attendDate = AtsDateUtils.dateLongToString(entryInfo.getAttendDate());
                    String attdateshort = AtsDateUtils.getDateFromLongString(attendDate);
                    String personid = entryInfo.getPerson().getId().toString();
                    String key = fmainid + "_" + personid + "_" + attdateshort;
                    entryMap.put(key, entryInfo);
                }
                for (i = 0; i < logColl.size(); ++i) {
                    AttendanceLogInfo logInfo = logColl.get(i);
                    BigDecimal successTimes = logInfo.getSucessTimes();
                    BigDecimal failTimes = logInfo.getFailTimes();
                    String updateMainSql = " update t_hr_Ats_attendancelog set fsucessperson='" + successTimes + "',failperson='" + failTimes + "'  where fjobid='" + jobid + "'  ";
                    AttendanceLogEntryInfo entryInfo = logInfo.getEntries().get(0);
                    String attendDate = AtsDateUtils.dateLongToString(entryInfo.getAttendDate());
                    String attdateshort = AtsDateUtils.getDateFromLongString(attendDate);
                    String personid = entryInfo.getPerson().getId().toString();
                    String message = entryInfo.getExcepMsg();
                    String key = fmainid + "_" + personid + "_" + attdateshort;
                    AttendanceLogEntryInfo entryinfo = (AttendanceLogEntryInfo)entryMap.get(key);
                    if (entryinfo == null) {
                        AttendanceLogEntryInfo entry = new AttendanceLogEntryInfo();
                        AttendanceLogInfo maininfo = new AttendanceLogInfo();
                        maininfo.setId(BOSUuid.read((String)fmainid));
                        entry.setGroup(maininfo);
                        entry.setAttendDate(entryInfo.getAttendDate());
                        PersonInfo pInfo = new PersonInfo();
                        if (personid != null) {
                            pInfo.setId(BOSUuid.read((String)personid));
                        }
                        entry.setPerson(pInfo);
                        entry.setExcepMsg(message);
                        AttendanceLogEntryFactory.getLocalInstance(ctx).addnew(entry);
                    } else {
                        StringBuffer updateEntrySql = new StringBuffer();
                        updateEntrySql.append("   update t_hr_Ats_attendancelogentry set  ");
                        updateEntrySql.append("   fExcepMsg=  '" + message + "'   ");
                        updateEntrySql.append("   where fgroupid='" + fmainid + "' and fattendDate= {ts '" + attendDate + "'} and fpersonid='" + personid + "' ");
                        batchSqlList.add(updateEntrySql);
                    }
                    batchSqlList.add(updateMainSql);
                }
                if (batchSqlList.size() > 0) {
                    AtsBaseUtils utils = new AtsBaseUtils();
                    System.out.println("~~~~~~~~~~ begin to update t_hr_ats_attendancelogentry .");
                    utils.executeBatch(ctx, batchSqlList);
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static void updateAttendLogEntryInfoSQL(Context ctx, Map<String, Object> paramap, Map<Object, Object> globalMap) {
        List personIdsList = (List)globalMap.get("personIdsList");
        List dayList = (List)globalMap.get("dayList");
        if (personIdsList.size() == 0 || dayList.size() == 0) {
            return;
        }
        try {
            String jobid = (String)paramap.get("jobid");
            if (jobid == null) {
                return;
            }
            AttendanceLogInfo reLogInfo = AttendanceLogFactory.getLocalInstance(ctx).getAttendanceLogInfo(" where jobid = '" + jobid + "' ");
            String fmainid = reLogInfo.getId().toString();
            ArrayList<StringBuffer> batchSqlList = new ArrayList<StringBuffer>(1000);
            for (int i = 0; i < personIdsList.size(); ++i) {
                String personid = (String)personIdsList.get(i);
                Map attendanceFileInfoMap = (Map)globalMap.get("attendanceFileInfoMap");
                AttendanceFileInfo attFilefo = (AttendanceFileInfo)attendanceFileInfoMap.get(personid);
                int isCardAttend = 1;
                if (attFilefo != null && attFilefo.getIsAttendance() != null) {
                    isCardAttend = Integer.parseInt(attFilefo.getIsAttendance().getValue());
                }
                if (isCardAttend == 0) continue;
                for (int j = 0; j < dayList.size(); ++j) {
                    String attdateshort = (String)dayList.get(j);
                    String oql = " where group='" + fmainid + "' and attenddate = '" + attdateshort + "' and person='" + personid + "' ";
                    AttendanceLogEntryCollection entryColl = AttendanceLogEntryFactory.getLocalInstance(ctx).getAttendanceLogEntryCollection(oql);
                    if (entryColl.size() == 0) {
                        AttendanceLogEntryInfo entry = new AttendanceLogEntryInfo();
                        AttendanceLogInfo maininfo = new AttendanceLogInfo();
                        maininfo.setId(BOSUuid.read((String)fmainid));
                        entry.setGroup(maininfo);
                        entry.setAttendDate(AtsDateUtils.stringToShortDate(attdateshort));
                        PersonInfo pInfo = new PersonInfo();
                        if (personid != null) {
                            pInfo.setId(BOSUuid.read((String)personid));
                        }
                        entry.setPerson(pInfo);
                        entry.setExcepMsg(excepMsg.getMessage());
                        AttendanceLogEntryFactory.getLocalInstance(ctx).addnew(entry);
                        continue;
                    }
                    StringBuffer updateEntrySql = new StringBuffer();
                    updateEntrySql.append("   update t_hr_Ats_attendancelogentry set  ");
                    updateEntrySql.append("   fExcepMsg=  '" + excepMsg.getMessage() + "'   ");
                    updateEntrySql.append("   where fgroupid='" + fmainid + "' and fattendDate= {ts '" + attdateshort + "'} and fpersonid='" + personid + "'  ");
                    batchSqlList.add(updateEntrySql);
                }
            }
            AtsBaseUtils utils = new AtsBaseUtils();
            utils.executeBatch(ctx, batchSqlList);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static void updateAttendanceLogById(Context ctx, AttendanceLogInfo info) throws EASBizException, BOSException {
        ArrayList<String> batchSqlList = new ArrayList<String>();
        if (info.getJobid() != null && info.getCostSumTime() != null && info.getCostTime() != null) {
            String updateMainSql = " update t_hr_Ats_attendancelog set   fcostSumTime='" + info.getCostSumTime() + "'  ,fcostTime='" + info.getCostTime() + "'  where fjobid='" + info.getJobid() + "'  ";
            batchSqlList.add(updateMainSql);
        }
        AtsBaseUtils utils = new AtsBaseUtils();
        utils.executeBatch(ctx, batchSqlList);
    }

    public static void operatorAttendanceLogInfoSQL(Context ctx, AttendanceLogCollection logColl) throws EASBizException, BOSException {
        if (logColl.size() == 0) {
            return;
        }
        ArrayList<String> batchSqlList = new ArrayList<String>(1000);
        for (int i = 0; i < logColl.size(); ++i) {
            AttendanceLogInfo logInfo = logColl.get(i);
            String jobid = logInfo.getJobid();
            BigDecimal successTimes = logInfo.getSucessTimes();
            BigDecimal failTimes = logInfo.getFailTimes();
            BigDecimal sumperson = logInfo.getSumPerson();
            BigDecimal sumdays = logInfo.getSumDays();
            BigDecimal calPersonSize = logInfo.getCalPersonSize();
            BigDecimal costSumTime = logInfo.getCostSumTime();
            BigDecimal costTime = logInfo.getCostTime();
            BigDecimal remainTime = logInfo.getRemainTime();
            String updateMainSql = " update t_hr_Ats_attendancelog set   fsumPerson ='" + sumperson + "' , fsumdays ='" + sumdays + "'  ,fsucessperson='" + successTimes + "',failperson='" + failTimes + "'  ,fcalPersonSize='" + calPersonSize + "',fcostSumTime='" + costSumTime + "'  ,fcostTime='" + costTime + "',fremainTime='" + remainTime + "'  ,flogtype='1'   where fjobid='" + jobid + "'  ";
            batchSqlList.add(updateMainSql);
        }
        AtsBaseUtils utils = new AtsBaseUtils();
        utils.executeBatch(ctx, batchSqlList);
    }

    public static void updateAttendanceLogInfoSQL(Context ctx, Map<String, Object> paraMap) throws EASBizException, BOSException {
        if (paraMap.isEmpty()) {
            return;
        }
        ArrayList<String> batchSqlList = new ArrayList<String>(1000);
        String jobid = "";
        if (paraMap.get("jobid") != null) {
            jobid = (String)paraMap.get("jobid");
        }
        BigDecimal calPersonSize = new BigDecimal((Integer)paraMap.get("calPersonSize"));
        BigDecimal costSumTime = new BigDecimal((Long)paraMap.get("costSumTime"));
        BigDecimal costTime = new BigDecimal((Long)paraMap.get("costTime"));
        BigDecimal remainTime = new BigDecimal((Long)paraMap.get("remainTime"));
        String updateMainSql = " update t_hr_Ats_attendancelog set   fcalPersonSize='" + calPersonSize + "',fcostSumTime='" + costSumTime + "'  ,fcostTime='" + costTime + "',fremainTime='" + remainTime + "'  ,flogtype='1' ,fcalstatus='1'   where fjobid='" + jobid + "'  ";
        batchSqlList.add(updateMainSql);
        AtsBaseUtils utils = new AtsBaseUtils();
        utils.executeBatch(ctx, batchSqlList);
    }
}

