/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.hr.ats.util.common;

import com.kingdee.bos.Context;
import com.kingdee.bos.dao.query.server.PagingHelper;
import com.kingdee.eas.hr.ats.util.common.AtsLog;
import com.kingdee.eas.hr.ats.util.common.AtsSqlUtile;
import com.kingdee.eas.hr.ats.util.common.ConfigAts;
import com.kingdee.eas.hr.ats.util.common.tempTableUtile;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang.StringUtils;

public abstract class AbstractPagingProcessor<R> {
    protected PagingHelper pagingHelper;
    protected String sql;
    protected String oldSql;
    protected Context ctx;
    protected Object outData;
    protected int length = 500;
    protected int start = 0;
    protected boolean throwException = true;
    protected boolean useTempTable;
    protected String tempTableName;
    protected String sortExpression;
    protected boolean collectAllData = false;
    protected List<R> curPageData;
    protected List<R> allPageData;

    public AbstractPagingProcessor() {
        boolean noThrow = "false".equalsIgnoreCase(ConfigAts.getPropertyFromConfig("pagingProcessor.throwException"));
        this.throwException = !noThrow;
    }

    public AbstractPagingProcessor(String sql, Context ctx) {
        this();
        this.sql = sql;
        this.ctx = ctx;
    }

    public AbstractPagingProcessor<R> process() {
        if (StringUtils.isEmpty((String)this.sql)) {
            return this;
        }
        System.out.println("the control person ot sql is  : " + this.sql);
        this.beforeProcess();
        this.initDataContainer();
        try {
            while (true) {
                this.beforeQuery();
                IRowSet rs = DbUtil.executeQuery((Context)this.ctx, (String)this.pagingHelper.getPagingSqlNoOptmize(this.ctx, this.sql, this.start, this.length));
                this.aftertExecQuery(this.ctx, rs);
                this.afterGetAllRow(this.ctx, this.curPageData);
                if (this.curPageData == null || this.curPageData.size() < this.length) break;
                this.start += this.length;
            }
            this.afterGetAllData(this.ctx, this.allPageData);
        }
        catch (Exception e) {
            if (this.isThrowException()) {
                throw new RuntimeException(e.getMessage(), e);
            }
            AtsLog.getLog().error((Object)e);
        }
        finally {
            this.afterProcess();
        }
        return this;
    }

    protected void beforeQuery() {
        if (this.curPageData != null) {
            this.curPageData.clear();
        }
    }

    protected void afterProcess() {
        if (this.useTempTable && this.tempTableName != null) {
            tempTableUtile.releaseTable(this.ctx, this.tempTableName);
        }
    }

    protected void beforeProcess() {
        this.oldSql = this.sql;
        this.start = this.start < 0 ? 0 : this.start;
        this.length = this.length > 0 ? this.length : 1;
        this.sortExpression = AtsSqlUtile.getSortExpression(this.sql);
        if (this.useTempTable) {
            this.sql = this.oldSql.replace(this.sortExpression, "");
            try {
                this.tempTableName = tempTableUtile.createTable(this.ctx, this.sql);
                this.sql = "select * from " + this.tempTableName;
            }
            catch (Exception e) {
                AtsLog.getLog().error((Object)e);
            }
        }
        if (!AtsSqlUtile.hasSortExpression(this.sql)) {
            this.sql = this.sql + this.sortExpression;
        }
    }

    protected void initDataContainer() {
        this.curPageData = this.curPageData == null ? new ArrayList() : this.curPageData;
        this.allPageData = this.allPageData == null ? new ArrayList() : this.allPageData;
        this.pagingHelper = this.pagingHelper == null ? new PagingHelper() : this.pagingHelper;
    }

    protected void aftertExecQuery(Context ctx, IRowSet rs) throws SQLException {
        Object curRowData = null;
        while (rs.next()) {
            try {
                curRowData = this.assembleRow(rs);
            }
            catch (Exception e) {
                AtsLog.getLog().error((Object)e);
            }
            if (this.curPageData == null || !this.afterGetrow(ctx, this.curPageData, curRowData).validateRowData(curRowData)) continue;
            this.curPageData.add(curRowData);
            if (!this.collectAllData) continue;
            this.allPageData.add(curRowData);
        }
    }

    protected abstract R assembleRow(IRowSet var1) throws SQLException;

    protected boolean validateRowData(R curRowData) {
        return true;
    }

    protected void afterGetAllRow(Context ctx, List<R> rows) {
    }

    protected AbstractPagingProcessor<R> afterGetrow(Context ctx, List<R> rows, R curRowData) {
        return this;
    }

    protected void afterGetAllData(Context ctx, List<R> allData) {
    }

    public String getSql() {
        return this.sql;
    }

    public AbstractPagingProcessor<R> setSql(String sql) {
        this.sql = sql;
        return this;
    }

    public Context getCtx() {
        return this.ctx;
    }

    public AbstractPagingProcessor<R> setCtx(Context ctx) {
        this.ctx = ctx;
        return this;
    }

    public Object getOutData() {
        return this.outData;
    }

    public AbstractPagingProcessor<R> setOutData(Object outData) {
        this.outData = outData;
        return this;
    }

    public boolean isCollectAllData() {
        return this.collectAllData;
    }

    public AbstractPagingProcessor<R> setCollectAllData(boolean collectAllData) {
        this.collectAllData = collectAllData;
        return this;
    }

    public boolean isUseTempTable() {
        return this.useTempTable;
    }

    public AbstractPagingProcessor<R> setUseTempTable(boolean useTempTable) {
        this.useTempTable = useTempTable;
        return this;
    }

    public int getLength() {
        return this.length;
    }

    public AbstractPagingProcessor<R> setLength(int length) {
        this.length = length;
        return this;
    }

    public int getStart() {
        return this.start;
    }

    public AbstractPagingProcessor<R> setStart(int start) {
        this.start = start;
        return this;
    }

    public List<R> getAllPageData() {
        return this.allPageData;
    }

    public AbstractPagingProcessor<R> setAllPageData(List<R> allPageData) {
        this.allPageData = allPageData;
        return this;
    }

    public List<R> getCurPageData() {
        return this.curPageData;
    }

    public AbstractPagingProcessor<R> setCurPageData(List<R> curPageData) {
        this.curPageData = curPageData;
        return this;
    }

    public String getOldSql() {
        return this.oldSql;
    }

    public AbstractPagingProcessor<R> setOldSql(String oldSql) {
        this.oldSql = oldSql;
        return this;
    }

    public String getTempTableName() {
        return this.tempTableName;
    }

    public AbstractPagingProcessor<R> setTempTableName(String tempTableName) {
        this.tempTableName = tempTableName;
        return this;
    }

    public String getSortExpression() {
        return this.sortExpression;
    }

    public AbstractPagingProcessor<R> setSortExpression(String sordExpression) {
        this.sortExpression = sordExpression;
        return this;
    }

    public boolean isThrowException() {
        return this.throwException;
    }

    public AbstractPagingProcessor<R> setThrowException(boolean throwException) {
        this.throwException = throwException;
        return this;
    }
}

