/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.hr.ats.util.common;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectCollection;
import com.kingdee.bos.metadata.data.ColumnInfo;
import com.kingdee.bos.metadata.data.SQLType;
import com.kingdee.bos.metadata.entity.EntityObjectInfo;
import com.kingdee.bos.metadata.entity.LinkPropertyInfo;
import com.kingdee.bos.metadata.entity.PropertyCollection;
import com.kingdee.bos.metadata.entity.PropertyInfo;
import com.kingdee.bos.metadata.entity.RelationshipInfo;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.base.permission.UserInfo;
import com.kingdee.eas.basedata.org.CtrlUnitInfo;
import com.kingdee.eas.basedata.org.OrgType;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.hr.ats.util.common.AtsCollectionUtile;
import com.kingdee.eas.hr.ats.util.common.AtsCommonUtile;
import com.kingdee.eas.hr.ats.util.common.AtsConstants;
import com.kingdee.eas.hr.ats.util.common.AtsEntityUtile;
import com.kingdee.eas.hr.ats.util.common.AtsLog;
import com.kingdee.eas.hr.ats.util.common.DbUtile;
import com.kingdee.eas.hr.ats.util.common.MLUtile;
import com.kingdee.eas.hr.ats.vo.common.Dependency;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.lang.StringUtils;

public class DataSaver
extends Dependency
implements Cloneable {
    private List<? extends CoreBaseInfo> allNeedSavedData;
    private EntityObjectInfo entity;
    private boolean ignoreNullVal = false;
    private boolean saveEntry = false;
    private boolean initialized = false;
    private Map<String, List<CoreBaseInfo>> entryCollectionMap;
    private Set<String> properties = new HashSet<String>();
    private HashMap<String, SQLType> dataType;
    private Set<String> ignoreProperties = new HashSet<String>();
    private Set<String> ignorePropertiesWhenUpdate = new HashSet<String>(6);
    private Map<String, ColumnInfo> property2Column;
    private Map<String, DataSaver> entryDataSavers;
    private Map<String, String> enTryPropertyMap;
    private HashMap<String, Object> coreBaseDefaultValus = new HashMap(10);
    private List<Object[]> insertParams = new ArrayList<Object[]>();
    private List<Object[]> updateParams = new ArrayList<Object[]>();
    private int batchMount = AtsConstants.SIZE_COMMON_BATCH;
    private String insertSql;
    private String updateSql;

    public DataSaver() {
    }

    public DataSaver(Context ctx) {
        super(ctx);
    }

    public <V extends CoreBaseInfo> void save(V coreBaseInfo) throws BOSException {
        this.save(Collections.singletonList(coreBaseInfo));
    }

    public <V extends IObjectCollection> void save(V collection) throws BOSException {
        this.save(AtsCollectionUtile.toList(collection, CoreBaseInfo.class));
    }

    public <V extends IObjectCollection> void save(List<? extends CoreBaseInfo> list) throws BOSException {
        long curTime = System.currentTimeMillis();
        this.allNeedSavedData = list;
        if (list == null || list.size() == 0) {
            return;
        }
        if (this.ctx == null) {
            throw new BOSException("ctx_is_null");
        }
        if (!this.initialized) {
            this.initData(list.get(0));
            this.initialized = true;
        }
        Iterator<List<? extends CoreBaseInfo>> it = AtsCollectionUtile.group(list, this.batchMount).iterator();
        while (it.hasNext()) {
            this.reset();
            List<CoreBaseInfo> curList = it.next();
            this.beforSave(curList);
            this.updateSqlParams(curList);
            this.saveInsertData();
            this.saveUpdateData();
            this.afterSave(curList);
        }
        this.saveEntry();
        this.onSaveComplete();
        this.allNeedSavedData = null;
        this.reset();
        AtsLog.getLog().info((Object)("dataSaver total_time:" + (System.currentTimeMillis() - curTime)));
    }

    protected void saveEntry() throws BOSException {
        if (!this.saveEntry || this.entryCollectionMap.isEmpty()) {
            return;
        }
        for (String entryName : this.entryCollectionMap.keySet()) {
            if (this.entryCollectionMap.get(entryName) == null || this.entryCollectionMap.get(entryName).size() <= 0) continue;
            this.entryDataSavers = this.entryDataSavers != null ? this.entryDataSavers : new HashMap(this.entryCollectionMap.size());
            DataSaver entryDataSaver = this.entryDataSavers.get(entryName);
            if (entryDataSaver == null) {
                entryDataSaver = new DataSaver(this.ctx).setSaveEntry(this.saveEntry).setBatchMount(this.batchMount).setIgnoreNullVal(this.ignoreNullVal);
                this.entryDataSavers.put(entryName, entryDataSaver);
            }
            this.beforSaveEntry();
            entryDataSaver.save(this.entryCollectionMap.get(entryName));
            this.afterSaveEntry();
            this.entryCollectionMap.get(entryName).clear();
        }
    }

    protected void beforSaveEntry() {
    }

    protected void afterSaveEntry() {
    }

    protected void beforSave(List<CoreBaseInfo> curList) {
    }

    protected void afterSave(List<CoreBaseInfo> curList) {
    }

    protected void onSaveComplete() throws BOSException {
    }

    protected void processEntryObj(CoreBaseInfo coreBase) {
        if (coreBase == null || this.enTryPropertyMap.isEmpty()) {
            return;
        }
        for (Map.Entry<String, String> entrySet : this.enTryPropertyMap.entrySet()) {
            IObjectCollection entryObj;
            if (!(coreBase.get(entrySet.getKey()) instanceof IObjectCollection) || (entryObj = (IObjectCollection)coreBase.get(entrySet.getKey())) == null || entryObj.size() == 0) continue;
            if (!this.saveEntry) {
                Iterator it = entryObj.iterator();
                while (it.hasNext()) {
                    ((CoreBaseInfo)it.next()).put(entrySet.getValue(), (Object)coreBase);
                }
                continue;
            }
            List<CoreBaseInfo> entryCollection = this.entryCollectionMap.get(entrySet.getKey());
            if (entryCollection == null) {
                entryCollection = new ArrayList<CoreBaseInfo>(entryObj.size());
                this.entryCollectionMap.put(entrySet.getKey(), entryCollection);
            }
            for (CoreBaseInfo entryCoreBaseInfo : entryObj) {
                entryCoreBaseInfo.put(entrySet.getValue(), (Object)coreBase);
                entryCollection.add(entryCoreBaseInfo);
            }
        }
    }

    protected void updateSqlParams(List<CoreBaseInfo> collection) {
        int propertyCount = this.property2Column.size() + 1;
        for (int i = 0; i < collection.size(); ++i) {
            Object[] param;
            CoreBaseInfo coreBase = collection.get(i);
            boolean isInsertOperation = coreBase.getId() == null;
            if (isInsertOperation) {
                param = new Object[propertyCount];
                coreBase.setId(BOSUuid.create((BOSObjectType)coreBase.getBOSType()));
                this.insertParams.add(param);
            } else {
                param = new Object[propertyCount - this.ignorePropertiesWhenUpdate.size()];
                this.updateParams.add(param);
            }
            this.improveCoreBaseInfo(coreBase, isInsertOperation);
            int proInd = 0;
            for (String propertyName : this.property2Column.keySet()) {
                if (!isInsertOperation && this.ignorePropertiesWhenUpdate.contains(propertyName)) continue;
                param[proInd] = AtsCommonUtile.getValFromCoreBase(coreBase, propertyName);
                param[proInd] = param[proInd] == null ? this.dataType.get(propertyName) : param[proInd];
                ++proInd;
            }
            param[param.length - 1] = coreBase.getId().toString();
            this.processEntryObj(coreBase);
        }
    }

    protected void improveCoreBaseInfo(CoreBaseInfo coreBase, boolean isInsertOperation) {
        if (this.coreBaseDefaultValus == null) {
            return;
        }
        for (String key : this.coreBaseDefaultValus.keySet()) {
            if (!isInsertOperation && this.ignorePropertiesWhenUpdate.contains(key)) continue;
            coreBase.put(key, this.coreBaseDefaultValus.get(key));
        }
    }

    private void initData(CoreBaseInfo coreBase) throws BOSException {
        long curTime = System.currentTimeMillis();
        if (coreBase == null) {
            throw new BOSException("first_element_is_null coreBaseInfo");
        }
        this.entity = AtsEntityUtile.getEntityObj(this.ctx, coreBase);
        if (this.entity.getTable() == null || StringUtils.isBlank((String)this.entity.getTable().getName())) {
            throw new BOSException("DataSaver init failure,entity is:" + this.entity + "table is :" + this.entity.getTable().getName());
        }
        this.initProperties();
        this.updateIgnorePropertyFromCoreBase(coreBase);
        for (String property : new HashSet<String>(this.property2Column.keySet())) {
            if (!this.ignoreProperties.contains(property) || this.properties.contains(property)) continue;
            this.property2Column.remove(property);
        }
        this.initIgnoreUpdatePro();
        this.initCoreBaseDefaultValus();
        this.property2Column.remove("id");
        this.entryCollectionMap = this.saveEntry ? new HashMap(this.enTryPropertyMap.size()) : null;
        this.initDataInner();
        AtsLog.getLog().info((Object)("dataSaver initData time:" + (System.currentTimeMillis() - curTime)));
    }

    private void initProperties() {
        if (this.entity == null) {
            return;
        }
        PropertyCollection propertis = this.entity.getPropertiesRuntime();
        this.property2Column = new HashMap<String, ColumnInfo>(propertis.size());
        this.enTryPropertyMap = new HashMap<String, String>(4);
        this.dataType = new HashMap(propertis.size());
        for (int i = 0; i < propertis.size(); ++i) {
            PropertyInfo propertyInfo = propertis.get(i);
            ColumnInfo colInfo = propertyInfo.getMappingField();
            if (colInfo == null && propertyInfo instanceof LinkPropertyInfo) {
                RelationshipInfo relationshipInfo = ((LinkPropertyInfo)propertyInfo).getRelationship();
                PropertyInfo entryPropertyInfo = relationshipInfo.isClient(this.entity) ? relationshipInfo.getSupplierProperty() : relationshipInfo.getClientProperty();
                this.enTryPropertyMap.put(propertis.get(i).getName(), entryPropertyInfo.getName());
                continue;
            }
            this.property2Column.put(propertis.get(i).getName(), colInfo);
            this.dataType.put(propertis.get(i).getName(), colInfo == null ? null : colInfo.getTypeName());
        }
    }

    private String getColumnName(ColumnInfo colInfo) {
        String colName = colInfo.getName();
        if (colInfo.isMultilingual()) {
            colName = colName + MLUtile.getMlFlag(this.ctx);
        }
        return colName;
    }

    protected void initIgnoreUpdatePro() {
        this.ignorePropertiesWhenUpdate.add("creator");
        this.ignorePropertiesWhenUpdate.add("createTime");
        this.ignorePropertiesWhenUpdate.add("CU");
        this.ignorePropertiesWhenUpdate.retainAll(this.property2Column.keySet());
    }

    protected void reset() {
        this.insertParams.clear();
        this.updateParams.clear();
    }

    protected void initCoreBaseDefaultValus() {
        String cu;
        if (this.coreBaseDefaultValus == null) {
            this.coreBaseDefaultValus = new HashMap(5);
        }
        Timestamp curTime = new Timestamp(System.currentTimeMillis());
        UserInfo currentUserInfo = (UserInfo)this.ctx.get((Object)"UserInfo");
        CtrlUnitInfo cuInfo = (CtrlUnitInfo)this.ctx.get((Object)OrgType.ControlUnit);
        String string = cu = cuInfo != null && cuInfo.getId() != null ? cuInfo.getId().toString() : "";
        if (!this.coreBaseDefaultValus.containsKey("creator") && this.property2Column.containsKey("creator")) {
            this.coreBaseDefaultValus.put("creator", currentUserInfo);
        }
        if (!this.coreBaseDefaultValus.containsKey("createTime") && this.property2Column.containsKey("createTime")) {
            this.coreBaseDefaultValus.put("createTime", curTime);
        }
        if (!this.coreBaseDefaultValus.containsKey("lastUpdateUser") && this.property2Column.containsKey("lastUpdateUser")) {
            this.coreBaseDefaultValus.put("lastUpdateUser", currentUserInfo);
        }
        if (!this.coreBaseDefaultValus.containsKey("lastUpdateTime") && this.property2Column.containsKey("lastUpdateTime")) {
            this.coreBaseDefaultValus.put("lastUpdateTime", curTime);
        }
        if (!this.coreBaseDefaultValus.containsKey("CU") && this.property2Column.containsKey("CU")) {
            this.coreBaseDefaultValus.put("CU", cu);
        }
    }

    protected void updateIgnorePropertyFromCoreBase(CoreBaseInfo coreBase) {
        if (!this.ignoreNullVal) {
            return;
        }
        for (String property : this.property2Column.keySet()) {
            if (coreBase.get(property) != null || this.properties.contains(property)) continue;
            this.ignoreProperties.add(property);
        }
    }

    protected void initDataInner() {
    }

    protected void saveUpdateData() throws BOSException {
        if (this.updateParams.size() > 0) {
            long curTime = System.currentTimeMillis();
            if (this.updateSql == null) {
                this.initUpdateSql();
            }
            DbUtile.executeBatch(this.ctx, this.updateSql, this.updateParams);
            AtsLog.getLog().info((Object)("dataSaver saveUpdateData time:" + (System.currentTimeMillis() - curTime)));
        }
    }

    protected void initUpdateSql() {
        StringBuffer updateSqlSbf = new StringBuffer("update ").append(this.entity.getTable().getName()).append(" set ");
        for (String name : this.property2Column.keySet()) {
            if (this.ignorePropertiesWhenUpdate.contains(name)) continue;
            updateSqlSbf.append(this.getColumnName(this.property2Column.get(name))).append("=?,");
        }
        updateSqlSbf.setLength(updateSqlSbf.length() - 1);
        this.updateSql = updateSqlSbf.append(" where fid= ? ").toString();
    }

    protected void initInsertSql() {
        StringBuffer insertSqlSbf = new StringBuffer("insert into ").append(this.entity.getTable().getName()).append(" (");
        StringBuffer questionSql = new StringBuffer(") values (");
        for (String name : this.property2Column.keySet()) {
            insertSqlSbf.append(this.getColumnName(this.property2Column.get(name))).append(",");
            questionSql.append("?,");
        }
        this.insertSql = insertSqlSbf.append("fid").append(questionSql).append("?)").toString();
    }

    protected void saveInsertData() throws BOSException {
        if (this.insertParams.size() > 0) {
            long curTime = System.currentTimeMillis();
            if (this.insertSql == null) {
                this.initInsertSql();
            }
            DbUtile.executeBatch(this.ctx, this.insertSql, this.insertParams);
            AtsLog.getLog().info((Object)("dataSaver saveInsertData time:" + (System.currentTimeMillis() - curTime)));
        }
    }

    public boolean isIgnoreNullVal() {
        return this.ignoreNullVal;
    }

    public DataSaver setIgnoreNullVal(boolean ignoreNullVal) {
        this.ignoreNullVal = ignoreNullVal;
        return this;
    }

    public EntityObjectInfo getEntity() {
        return this.entity;
    }

    public DataSaver setEntity(EntityObjectInfo entity) {
        this.entity = entity;
        return this;
    }

    public Set<String> getProperties() {
        return this.properties;
    }

    public DataSaver setProperties(Set<String> properties) {
        this.properties = properties;
        return this;
    }

    public Set<String> getIgnoreProperties() {
        return this.ignoreProperties;
    }

    public DataSaver setIgnoreProperties(Set<String> ignoreProperties) {
        this.ignoreProperties = ignoreProperties;
        return this;
    }

    public Set<String> getIgnorePropertiesWhenUpdate() {
        return this.ignorePropertiesWhenUpdate;
    }

    public DataSaver setIgnorePropertiesWhenUpdate(Set<String> ignorePropertiesWhenUpdate) {
        this.ignorePropertiesWhenUpdate = ignorePropertiesWhenUpdate;
        return this;
    }

    public Map<String, ColumnInfo> getProperty2Column() {
        return this.property2Column;
    }

    public DataSaver setProperty2Column(Map<String, ColumnInfo> property2Column) {
        this.property2Column = property2Column;
        return this;
    }

    public HashMap<String, Object> getCoreBaseDefaultValus() {
        return this.coreBaseDefaultValus;
    }

    public DataSaver setCoreBaseDefaultValus(HashMap<String, Object> coreBaseDefaultValus) {
        this.coreBaseDefaultValus = coreBaseDefaultValus;
        return this;
    }

    public List<Object[]> getInsertParams() {
        return this.insertParams;
    }

    public DataSaver setInsertParams(List<Object[]> insertParams) {
        this.insertParams = insertParams;
        return this;
    }

    public List<Object[]> getUpdateParams() {
        return this.updateParams;
    }

    public DataSaver setUpdateParams(List<Object[]> updateParams) {
        this.updateParams = updateParams;
        return this;
    }

    public DataSaver addIgnoreUpdateProperTy(String property) {
        this.getIgnorePropertiesWhenUpdate().add(property);
        return this;
    }

    public DataSaver removeIgnoreUpdateProperTy(String property) {
        this.getIgnorePropertiesWhenUpdate().remove(property);
        return this;
    }

    public DataSaver addProperty(String property) {
        this.getProperties().add(property);
        return this;
    }

    public DataSaver removeProperty(String property) {
        this.getProperties().remove(property);
        return this;
    }

    public DataSaver addIgnoreProperty(String property) {
        this.getIgnoreProperties().add(property);
        return this;
    }

    public DataSaver removeIgnoreProperty(String property) {
        this.getIgnoreProperties().remove(property);
        return this;
    }

    public DataSaver addCoreBaseDefaultProperty(String key, String value) {
        this.getCoreBaseDefaultValus().put(key, value);
        return this;
    }

    public DataSaver removeCoreBaseDefaultProperty(String key) {
        this.getCoreBaseDefaultValus().remove(key);
        return this;
    }

    public boolean isSaveEntry() {
        return this.saveEntry;
    }

    public DataSaver setSaveEntry(boolean saveEntry) {
        this.saveEntry = saveEntry;
        return this;
    }

    public Map<String, DataSaver> getEntryDataSavers() {
        return this.entryDataSavers;
    }

    public void setEntryDataSavers(Map<String, DataSaver> entryDataSavers) {
        this.entryDataSavers = entryDataSavers;
    }

    public Map<String, String> getEnTryPropertyMap() {
        return this.enTryPropertyMap;
    }

    public void setEnTryPropertyMap(Map<String, String> enTryPropertyMap) {
        this.enTryPropertyMap = enTryPropertyMap;
    }

    public int getBatchMount() {
        return this.batchMount;
    }

    public DataSaver setBatchMount(int batchMount) {
        this.batchMount = batchMount;
        return this;
    }

    public String getInsertSql() {
        return this.insertSql;
    }

    public DataSaver setInsertSql(String insertSql) {
        this.insertSql = insertSql;
        return this;
    }

    public String getUpdateSql() {
        return this.updateSql;
    }

    public DataSaver setUpdateSql(String updateSql) {
        this.updateSql = updateSql;
        return this;
    }

    public boolean isInitialized() {
        return this.initialized;
    }

    public void setInitialized(boolean initialized) {
        this.initialized = initialized;
    }

    public List<? extends CoreBaseInfo> getAllNeedSavedData() {
        return this.allNeedSavedData;
    }

    public DataSaver setAllNeedSavedData(List<? extends CoreBaseInfo> allNeedSavedData) {
        this.allNeedSavedData = allNeedSavedData;
        return this;
    }

    @Override
    public DataSaver setDependency(Object dependency) {
        super.setDependency(dependency);
        return this;
    }

    @Override
    public DataSaver setCtx(Context ctx) {
        super.setCtx(ctx);
        return this;
    }

    protected DataSaver clone() throws CloneNotSupportedException {
        DataSaver dataSaver = (DataSaver)super.clone();
        dataSaver.setInitialized(false);
        dataSaver.setInsertParams(new ArrayList<Object[]>());
        dataSaver.setUpdateParams(new ArrayList<Object[]>());
        dataSaver.setInsertSql(null);
        dataSaver.setUpdateSql(null);
        dataSaver.setAllNeedSavedData(null);
        return dataSaver;
    }

    public String toString() {
        return "DataSaver [entity=" + this.entity + ", ignoreNullVal=" + this.ignoreNullVal + ", entryMap=" + this.entryCollectionMap + ", properties=" + this.properties + ", ignoreProperties=" + this.ignoreProperties + ", ignorePropertiesWhenUpdate=" + this.ignorePropertiesWhenUpdate + ", batchMount=" + this.batchMount + "]";
    }
}

