/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.hr.ats.util.common;

import com.kingdee.eas.hr.ats.util.common.AtsCollectionUtile;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public abstract class GroupProcessor<T, V> {
    private Map<Object, List<T>> groupedParam = new HashMap<Object, List<T>>();
    private Collection<T> needGroupParam;

    public void groupAndProcess(Collection<T> needGroupParam, V outerParams) throws Exception {
        this.needGroupParam = needGroupParam;
        this.doGroup();
        for (Map.Entry<Object, List<T>> entry : this.groupedParam.entrySet()) {
            this.process(entry.getKey(), entry.getValue(), outerParams);
        }
    }

    private void doGroup() {
        if (!AtsCollectionUtile.isEmpty(this.needGroupParam)) {
            int i = 0;
            for (T current : this.needGroupParam) {
                Object groupFlag = this.groupFn(i, current);
                List<T> temp = this.groupedParam.get(groupFlag);
                if (temp == null) {
                    temp = new ArrayList<T>();
                    this.groupedParam.put(groupFlag, temp);
                }
                temp.add(current);
                ++i;
            }
        }
    }

    protected abstract Object groupFn(int var1, T var2);

    protected abstract Object process(Object var1, List<T> var2, V var3) throws Exception;

    public Map<Object, List<T>> getGroupedParam() {
        return this.groupedParam;
    }

    public void setGroupedParam(Map<Object, List<T>> groupedParam) {
        this.groupedParam = groupedParam;
    }

    public Collection<T> getNeedGroupParam() {
        return this.needGroupParam;
    }

    public void setNeedGroupParam(Collection<T> needGroupParam) {
        this.needGroupParam = needGroupParam;
    }
}

