/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.hr.ats.util.common;

import com.kingdee.eas.hr.ats.util.common.AtsLog;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.Closeable;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Reader;
import java.io.Writer;
import java.text.SimpleDateFormat;
import java.util.Calendar;

public abstract class StreamUtile {
    public static void close(Reader reader) {
        StreamUtile.close((Closeable)reader);
    }

    public static void close(Writer writer) {
        StreamUtile.close((Closeable)writer);
    }

    public static void close(InputStream inputStream) {
        StreamUtile.close((Closeable)inputStream);
    }

    public static void close(OutputStream outputStream) {
        StreamUtile.close((Closeable)outputStream);
    }

    public static void close(Closeable ioStream) {
        if (ioStream == null) {
            return;
        }
        try {
            ioStream.close();
        }
        catch (IOException e) {
            AtsLog.getLog().error((Object)e);
        }
    }

    public static boolean deleteFile(String file) throws IOException {
        return StreamUtile.deleteFile(new File(file));
    }

    public static boolean deleteFile(File file) throws IOException {
        boolean result = true;
        if (!file.exists()) {
            return result;
        }
        if (!file.isDirectory()) {
            return file.delete();
        }
        for (File curFile : file.listFiles()) {
            result = result && StreamUtile.deleteFile(curFile.getAbsolutePath());
        }
        result = result && file.delete();
        return result;
    }

    public static boolean emptyFile(String file, boolean needBake) throws IOException {
        return StreamUtile.emptyFile(new File(file), needBake);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean emptyFile(File file, boolean needBake) throws IOException {
        if (file.exists()) {
            FileOutputStream fos = null;
            BufferedReader reader = null;
            BufferedWriter writer = null;
            FileReader fileReader = null;
            try {
                if (needBake) {
                    String line;
                    fileReader = new FileReader(file);
                    reader = new BufferedReader(fileReader);
                    String bakFile = file.getAbsolutePath() + "_";
                    bakFile = bakFile + new SimpleDateFormat("yyMMddhhmmss").format(Calendar.getInstance().getTime());
                    bakFile = bakFile + ".bak";
                    writer = new BufferedWriter(new FileWriter(bakFile));
                    while ((line = reader.readLine()) != null) {
                        writer.write(line);
                        writer.write("\r\n");
                    }
                }
                fos = new FileOutputStream(file);
                fos.write("".getBytes());
            }
            catch (Throwable throwable) {
                StreamUtile.close(fileReader);
                StreamUtile.close(fos);
                StreamUtile.close(reader);
                StreamUtile.close(writer);
                throw throwable;
            }
            StreamUtile.close(fileReader);
            StreamUtile.close(fos);
            StreamUtile.close(reader);
            StreamUtile.close(writer);
        }
        return true;
    }

    public static String getFileContent(String file) {
        return StreamUtile.getFileContent(new File(file));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String getFileContent(File file) {
        if (file == null || !file.exists()) {
            return "";
        }
        BufferedReader bufferedReader = null;
        StringBuffer content = new StringBuffer();
        try {
            String line;
            bufferedReader = new BufferedReader(new FileReader(file));
            while ((line = bufferedReader.readLine()) != null) {
                content.append(line).append("\r\n");
            }
        }
        catch (FileNotFoundException e1) {
            e1.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        finally {
            if (bufferedReader != null) {
                try {
                    bufferedReader.close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        }
        return content.toString();
    }
}

