/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.hr.ats.util.common;

import com.kingdee.bos.Context;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.base.permission.UserInfo;
import com.kingdee.eas.basedata.person.PersonInfo;
import com.kingdee.eas.hr.ats.util.common.AtsCommonUtile;
import com.kingdee.eas.hr.ats.util.common.AtsContextUtile;
import com.kingdee.eas.hr.ats.util.common.EncodingUtile;
import com.kingdee.eas.hr.ats.util.common.NormalMessageConfigUtil;
import com.kingdee.eas.hr.base.HRCommonException;
import com.kingdee.shr.base.syssetting.cloud.factory.impl.HttpPostMessageFactoryImpl;
import com.kingdee.shr.base.syssetting.util.CloudHubUtil;
import com.kingdee.shr.base.syssetting.util.SHRSyssettingUtil;
import com.kingdee.util.ConfigurationItem;
import com.kingdee.util.XMLConfiguration;
import java.io.File;
import java.util.HashMap;
import java.util.Map;
import net.sf.json.JSONObject;
import org.apache.commons.lang3.StringUtils;
import org.apache.log4j.Logger;

public class YZJMsgPusher {
    private static Logger logger = Logger.getLogger(YZJMsgPusher.class);
    private static XMLConfiguration configuration = null;
    private String pushConfigName;
    private String link;
    private String targetId;
    private Context ctx = AtsContextUtile.getCtx();
    private Map<String, Object> params = new HashMap<String, Object>();
    private String msgBody;

    public void postMessage() throws Exception {
        this.init();
        if (StringUtils.isEmpty((CharSequence)this.link)) {
            logger.error((Object)"YZJMsgPusher link is empty\uff01");
            return;
        }
        StringBuffer url = new StringBuffer();
        url.append(this.link);
        for (String param : this.params.keySet()) {
            url.append('&').append(param).append('=').append(EncodingUtile.encodeURIComponent(this.params.get(param)));
        }
        HashMap<String, Object> dataMap = new HashMap<String, Object>();
        dataMap.put("url", url.toString());
        dataMap.put("text", this.msgBody);
        JSONObject allData = NormalMessageConfigUtil.convertInfoToMap(this.ctx, this.targetId, dataMap, "01");
        logger.info((Object)allData);
        String dataStr = new String(allData.toString().getBytes(), "UTF-8");
        new HttpPostMessageFactoryImpl().getHttpPostMessageProvider().postMessage(dataStr);
    }

    protected void init() throws HRCommonException {
        this.loadConfig();
        this.initTarget();
        this.initLink();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void loadConfig() {
        if (configuration != null) return;
        Class<YZJMsgPusher> clazz = YZJMsgPusher.class;
        synchronized (YZJMsgPusher.class) {
            String propertiesPath = SHRSyssettingUtil.getProperitesPath();
            String fileName = propertiesPath + File.separator + "XTServiceConfig.xml";
            File configFile = new File(fileName);
            if (!configFile.exists()) {
                throw new RuntimeException("cann't find the config file!");
            }
            configuration = XMLConfiguration.getInstance((File)configFile);
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return;
        }
    }

    protected void initLink() throws HRCommonException {
        Map configs;
        ConfigurationItem configurationItem = configuration.getConfigItemByPath("EmployeeSelfService/" + this.pushConfigName);
        Map map = configs = configurationItem == null ? null : configurationItem.getProperties();
        if (StringUtils.isNotBlank((CharSequence)this.link) || configs == null) {
            return;
        }
        StringBuffer url = new StringBuffer();
        url.append(AtsCommonUtile.getFromMap(configs, (Object)"host", "http://mbos.kdeascloud.com"));
        url.append('/').append(AtsCommonUtile.getFromMap(configs, (Object)"page", "mbos/page/loadPage"));
        url.append("?storeEid=").append(AtsCommonUtile.getFromMap(configs, (Object)"storeEid", "4000148"));
        url.append("&appid=").append(AtsCommonUtile.getFromMap(configs, (Object)"appId", "10036"));
        url.append("&path=").append(AtsCommonUtile.getFromMap(configs, (Object)"path", "4000148"));
        String eid = "";
        try {
            eid = CloudHubUtil.getIntegrationEid((Context)this.ctx);
        }
        catch (Exception e) {
            logger.info((Object)("eid not config:" + e.getMessage()), (Throwable)e);
            configurationItem = configuration.getConfigItemByPath("EmployeeSelfService/DayDayAttendanceTo");
            eid = configurationItem.getProperty("no");
        }
        url.append("&eid=").append(eid);
        this.link = url.toString();
    }

    protected void initTarget() throws HRCommonException {
        if (!BOSUuid.isValid((String)this.targetId, (boolean)true)) {
            return;
        }
        try {
            BOSObjectType bosType = BOSUuid.read((String)this.targetId).getType();
            if (new UserInfo().getBOSType().equals((Object)bosType)) {
                this.targetId = NormalMessageConfigUtil.getOpenIdByUserId(this.ctx, this.targetId);
            } else if (new PersonInfo().getBOSType().equals((Object)bosType)) {
                this.targetId = NormalMessageConfigUtil.getOpenIdByPersonId(this.ctx, this.targetId);
            }
        }
        catch (Exception e) {
            throw new HRCommonException(HRCommonException.EXCEPTION_MSG, (Throwable)e, new Object[]{e.getMessage()});
        }
    }

    public YZJMsgPusher addParam(String name, Object paramVal) {
        this.params.put(name, paramVal);
        return this;
    }

    public YZJMsgPusher removeParam(String name) {
        this.params.remove(name);
        return this;
    }

    public Map<String, Object> getParams() {
        return this.params;
    }

    public YZJMsgPusher setParams(Map<String, Object> params) {
        this.params = params;
        return this;
    }

    public String getTargetId() {
        return this.targetId;
    }

    public YZJMsgPusher setTargetId(String targetId) {
        this.targetId = targetId;
        return this;
    }

    public Context getCtx() {
        return this.ctx;
    }

    public YZJMsgPusher setCtx(Context ctx) {
        this.ctx = ctx;
        return this;
    }

    public String getMsgBody() {
        return this.msgBody;
    }

    public YZJMsgPusher setMsgBody(String msgBody) {
        this.msgBody = msgBody;
        return this;
    }

    public static XMLConfiguration getConfiguration() {
        return configuration;
    }

    public static void setConfiguration(XMLConfiguration configuration) {
        YZJMsgPusher.configuration = configuration;
    }

    public String getPushConfigName() {
        return this.pushConfigName;
    }

    public YZJMsgPusher setPushConfigName(String pushConfigName) {
        this.pushConfigName = pushConfigName;
        return this;
    }

    public String getLink() {
        return this.link;
    }

    public YZJMsgPusher setLink(String link) {
        this.link = link;
        return this;
    }
}

