/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.hr.ats.workShift.arrange;

import com.kingdee.bos.Context;
import com.kingdee.eas.hr.ats.DayTypeEnum;
import com.kingdee.eas.hr.ats.ScheduleShiftInfo;
import com.kingdee.eas.hr.ats.vo.common.RangeMap;
import com.kingdee.eas.hr.ats.workShift.arrange.BaseArrangeShift;
import java.util.Date;
import org.apache.commons.lang3.StringUtils;

public class ArrangeShiftByShift
extends BaseArrangeShift {
    private String atsShiftId;
    private RangeMap<Date, ScheduleShiftInfo> appointedScheduleShift;

    public ArrangeShiftByShift() {
    }

    public ArrangeShiftByShift(Context ctx) {
        super(ctx);
    }

    @Override
    public void holidayProcss() {
        if (StringUtils.isEmpty((CharSequence)this.holidayArrange.getValue())) {
            this.arrangeProcess();
        } else {
            this.holidayArrangeWay();
        }
    }

    @Override
    public void weekendProcess() {
        if (StringUtils.isEmpty((CharSequence)this.restdayArrange.getValue())) {
            this.arrangeProcess();
        } else {
            this.restdayProcessWay();
        }
    }

    @Override
    public void workDayProcess() {
        this.arrangeProcess();
    }

    protected void holidayArrangeWay() {
        ScheduleShiftInfo defaultSchedule = this.appointedScheduleShift.get(this.currentShiftDate);
        switch (this.holidayArrange.getValue()) {
            case "1": {
                this.curentArrangingSchedule.setDefaultShift(null);
                break;
            }
            case "2": {
                if (defaultSchedule == null) break;
                this.curentArrangingSchedule.setDefaultShift(defaultSchedule.getDefaultShift());
                break;
            }
            default: {
                this.arrangeProcess();
            }
        }
    }

    protected void restdayProcessWay() {
        ScheduleShiftInfo defaultSchedule = this.appointedScheduleShift.get(this.currentShiftDate);
        switch (this.restdayArrange.getValue()) {
            case "1": {
                this.curentArrangingSchedule.setDefaultShift(null);
                break;
            }
            case "2": {
                if (defaultSchedule == null) break;
                this.curentArrangingSchedule.setDefaultShift(defaultSchedule.getDefaultShift());
                break;
            }
            default: {
                this.arrangeProcess();
            }
        }
    }

    protected void arrangeProcess() {
        ScheduleShiftInfo defaultSchedule = this.appointedScheduleShift.get(this.currentShiftDate);
        if (defaultSchedule != null && this.curentArrangingSchedule.getDayType() == DayTypeEnum.workDay) {
            this.curentArrangingSchedule.setDefaultShift(defaultSchedule.getDefaultShift());
        } else {
            this.curentArrangingSchedule.setDefaultShift(null);
        }
    }

    public RangeMap<Date, ScheduleShiftInfo> getAppointedScheduleShift() {
        return this.appointedScheduleShift;
    }

    public void setAppointedScheduleShift(RangeMap<Date, ScheduleShiftInfo> appointedScheduleShift) {
        this.appointedScheduleShift = appointedScheduleShift;
    }

    public String getAtsShiftId() {
        return this.atsShiftId;
    }

    public void setAtsShiftId(String atsShiftId) {
        this.atsShiftId = atsShiftId;
    }

    @Override
    protected Object clone() throws CloneNotSupportedException {
        return super.clone();
    }

    public String toString() {
        return "ArrangeShiftByShift [atsShiftId=" + this.atsShiftId + ", appointedScheduleShift=" + this.appointedScheduleShift + ", personInfo=" + this.personInfo + ", beginDate=" + this.beginDate + ", endDate=" + this.endDate + ", currentShiftDate=" + this.currentShiftDate + ", operationType=" + (Object)((Object)this.operationType) + ", arrangeWay=" + (Object)((Object)this.arrangeWay) + ", holidayProcessWay=" + (Object)((Object)this.holidayProcessWay) + ", arrangeState=" + (Object)((Object)this.arrangeState) + ", continueArrangeShift=" + this.continueArrangeShift + ", curentArrangingSchedule=" + this.curentArrangingSchedule + ", holidayMap=" + this.holidayMap + ", errorMsg=" + this.errorMsg + ", ctx=" + this.ctx + "]";
    }
}

