/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.hr.ats.workShift.plan.autoSchedule;

import com.alibaba.fastjson.JSONObject;
import com.kingdee.bos.Context;
import com.kingdee.bos.bsf.service.classloader.MsfClassLoaderFactory;
import com.kingdee.eas.hr.ats.EArrangeWay;
import com.kingdee.eas.hr.ats.ECalendarType;
import com.kingdee.eas.hr.ats.util.common.AtsCommonUtile;
import com.kingdee.eas.hr.ats.util.common.AtsLog;
import com.kingdee.eas.hr.ats.vo.common.AtsCtx;
import com.kingdee.eas.hr.ats.workShift.arrange.ArrangeShiftByCopy;
import com.kingdee.eas.hr.ats.workShift.arrange.ArrangeShiftByShift;
import com.kingdee.eas.hr.ats.workShift.arrange.ArrangeShiftByTurns;
import com.kingdee.eas.hr.ats.workShift.arrange.ArrangeShiftByUserDefined;
import com.kingdee.eas.hr.ats.workShift.arrange.BaseArrangeShift;
import com.kingdee.eas.hr.ats.workShift.plan.IScheduleAnalysor;
import com.kingdee.eas.hr.ats.workShift.plan.autoSchedule.AutoScheduleUtile;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.util.Arrays;
import java.util.Calendar;
import java.util.List;
import org.apache.commons.lang.StringUtils;

public class BaseScheduleParamAnalysor
extends AtsCtx
implements IScheduleAnalysor {
    protected JSONObject scheduleParams;
    protected Calendar taskStartTime;
    protected String arrangeShiftClass;
    protected boolean satisfyScheduleCondition = true;
    protected BaseArrangeShift analyzeResults;
    protected boolean ignoreExecuteDate;
    protected int frontDay;

    public BaseScheduleParamAnalysor() {
    }

    public BaseScheduleParamAnalysor(JSONObject scheduleParams, Calendar taskStartTime, boolean ignoreExecuteDate, int frontDay) {
        this.scheduleParams = scheduleParams;
        this.taskStartTime = Calendar.getInstance();
        this.ignoreExecuteDate = ignoreExecuteDate;
        this.frontDay = frontDay;
    }

    protected void beforeAnalyze() {
        if (this.scheduleParams == null) {
            this.setSatisfyScheduleCondition(false);
            return;
        }
        if (this.scheduleParams.containsKey((Object)"arrangeClass")) {
            this.arrangeShiftClass = this.scheduleParams.getString("arrangeClass");
        }
    }

    @Override
    public void analyze() {
        this.beforeAnalyze();
        if (!this.ignoreExecuteDate && !this.varifyExcuteDate()) {
            AtsLog.getWSLog().error((Object)("not statisfy schedul condition\uff0cignoreExecuteDate=" + this.ignoreExecuteDate + "scheduleParams=" + this.scheduleParams));
            this.setSatisfyScheduleCondition(false);
            return;
        }
        this.createArrangeResultObj();
        if (this.analyzeResults != null) {
            this.buildArrangShiftWay();
            this.completeScheduleDate();
            if (this.analyzeResults.getBeginDate().after(this.analyzeResults.getEndDate())) {
                AtsLog.getWSLog().error((Object)("beginDate can not later endDate\uff0cbeginDate = currentDate - frontDate;  beginDate=" + this.analyzeResults.getBeginDate() + "endDate=" + this.analyzeResults.getEndDate()));
                this.setSatisfyScheduleCondition(false);
                return;
            }
            this.completeSpecificShiftParams();
        }
    }

    protected boolean varifyExcuteDate() {
        boolean result = false;
        if (!this.scheduleParams.containsKey((Object)"excuteDay") || StringUtils.isEmpty((String)this.scheduleParams.getString("excuteDay"))) {
            return true;
        }
        List<String> excuteDay = Arrays.asList(this.scheduleParams.getString("excuteDay").split(","));
        String scheduleDate = this.scheduleParams.getString("scheduleDate");
        ECalendarType type = ECalendarType.month;
        if (scheduleDate.contains("_")) {
            String executeDayType = scheduleDate.split("_")[1];
            type = ECalendarType.getEnum(executeDayType);
        }
        switch (type.getValue()) {
            case 3: {
                result = excuteDay.contains(String.valueOf(this.taskStartTime.get(5)));
                break;
            }
            case 2: {
                int curDay = this.taskStartTime.get(7) - 1;
                result = excuteDay.contains(String.valueOf(curDay == 0 ? 7 : curDay));
                break;
            }
            case 1: {
                result = true;
                break;
            }
        }
        return result && AutoScheduleUtile.validateTimeShiftDate(this.scheduleParams, this.frontDay, this.taskStartTime.getTime());
    }

    protected void createArrangeResultObj() {
        if (StringUtils.isNotEmpty((String)this.arrangeShiftClass)) {
            try {
                Class baseArrangeClass = MsfClassLoaderFactory.forName((String)this.arrangeShiftClass);
                baseArrangeClass.asSubclass(BaseArrangeShift.class);
                Constructor constructor = baseArrangeClass.getConstructor(Context.class);
                this.analyzeResults = (BaseArrangeShift)constructor.newInstance(this.ctx);
            }
            catch (InstantiationException e) {
                e.printStackTrace();
            }
            catch (IllegalAccessException e) {
                e.printStackTrace();
            }
            catch (ClassNotFoundException e) {
                e.printStackTrace();
            }
            catch (NoSuchMethodException e) {
                e.printStackTrace();
            }
            catch (InvocationTargetException e) {
                e.printStackTrace();
            }
        }
    }

    protected void buildArrangShiftWay() {
        Class<?> arrangeShiftClass = this.analyzeResults.getClass();
        this.preSetArrangeShiftWay(arrangeShiftClass);
        if (this.scheduleParams.containsKey((Object)"arrangeWay")) {
            switch (this.scheduleParams.getIntValue("arrangeWay")) {
                case 3: {
                    this.analyzeResults.setArrangeWay(EArrangeWay.arrangeByAppointShift);
                    break;
                }
                case 1: {
                    this.analyzeResults.setArrangeWay(EArrangeWay.arrangeByTurn);
                    break;
                }
                case 4: 
                case 5: {
                    this.analyzeResults.setArrangeWay(EArrangeWay.arrangeByCopySelf);
                    break;
                }
                case 6: {
                    this.analyzeResults.setArrangeWay(EArrangeWay.arrangeByUserDefined);
                    break;
                }
            }
        }
    }

    protected void preSetArrangeShiftWay(Class<?> arrangeShiftClass) {
        BaseArrangeShift analyzeResults = this.getAnalyzeResults();
        if (ArrangeShiftByTurns.class.isAssignableFrom(arrangeShiftClass)) {
            analyzeResults.setArrangeWay(EArrangeWay.arrangeByTurn);
        } else if (ArrangeShiftByCopy.class.isAssignableFrom(arrangeShiftClass)) {
            analyzeResults.setArrangeWay(EArrangeWay.arrangeByCopySelf);
        } else if (ArrangeShiftByShift.class.isAssignableFrom(arrangeShiftClass)) {
            analyzeResults.setArrangeWay(EArrangeWay.arrangeByAppointShift);
        } else if (ArrangeShiftByUserDefined.class.isAssignableFrom(arrangeShiftClass)) {
            analyzeResults.setArrangeWay(EArrangeWay.arrangeByUserDefined);
        }
    }

    protected void completeScheduleDate() {
        if (ArrangeShiftByCopy.class.isAssignableFrom(this.analyzeResults.getClass())) {
            this.analyzeResults.setEndDate(AtsCommonUtile.analyzeEndDate(this.taskStartTime.getTime(), this.scheduleParams.getString("scheduleDate")));
            this.analyzeResults.setBeginDate(AtsCommonUtile.analyzeStartDate(this.taskStartTime.getTime(), this.scheduleParams.getString("scheduleDate")));
        } else {
            this.analyzeResults.setBeginDate(AutoScheduleUtile.getTimeShiftBeginDate(this.scheduleParams, this.frontDay, this.taskStartTime.getTime()));
            this.analyzeResults.setEndDate(AutoScheduleUtile.getTimeShiftEndDate(this.scheduleParams, this.taskStartTime.getTime()));
        }
    }

    protected void completeSpecificShiftParams() {
        switch (this.analyzeResults.getArrangeWay().getValue()) {
            case 3: {
                this.completeShiftParam();
                break;
            }
            case 1: {
                this.completeTurnShiftParam();
                break;
            }
            case 4: 
            case 5: {
                this.completeCopyParam();
                break;
            }
            case 6: {
                this.completeUserDefinedParam();
                break;
            }
        }
    }

    protected void completeShiftParam() {
    }

    protected void completeTurnShiftParam() {
    }

    protected void completeCopyParam() {
    }

    protected void completeUserDefinedParam() {
    }

    public Calendar getTaskStartTime() {
        return this.taskStartTime;
    }

    public void setTaskStartTime(Calendar taskStartTime) {
        this.taskStartTime = taskStartTime;
    }

    public boolean isSatisfyScheduleCondition() {
        return this.satisfyScheduleCondition;
    }

    public void setSatisfyScheduleCondition(boolean satisfyScheduleCondition) {
        this.satisfyScheduleCondition = satisfyScheduleCondition;
    }

    public JSONObject getScheduleParams() {
        return this.scheduleParams;
    }

    public void setScheduleParams(JSONObject scheduleParams) {
        this.scheduleParams = scheduleParams;
    }

    public BaseArrangeShift getAnalyzeResults() {
        return this.analyzeResults;
    }

    public void setAnalyzeResults(BaseArrangeShift analyzeResults) {
        this.analyzeResults = analyzeResults;
    }

    public String getArrangeShiftClass() {
        return this.arrangeShiftClass;
    }

    public void setArrangeShiftClass(String arrangeShiftClass) {
        this.arrangeShiftClass = arrangeShiftClass;
    }

    public boolean isIgnoreExecuteDate() {
        return this.ignoreExecuteDate;
    }

    public void setIgnoreExecuteDate(boolean ignoreExecuteDate) {
        this.ignoreExecuteDate = ignoreExecuteDate;
    }

    public int getFrontDay() {
        return this.frontDay;
    }

    public void setFrontDay(int frontDay) {
        this.frontDay = frontDay;
    }

    @Override
    public boolean hasNext() {
        return false;
    }

    @Override
    public IScheduleAnalysor next() {
        return null;
    }

    public String toString() {
        return "BaseScheduleParamAnalysor [scheduleParams=" + this.scheduleParams + ", taskStartTime=" + this.taskStartTime + ", arrangeShiftClass=" + this.arrangeShiftClass + ", satisfyScheduleCondition=" + this.satisfyScheduleCondition + ", analyzeResults=" + this.analyzeResults + ", ignoreExecuteDate=" + this.ignoreExecuteDate + ", frontDay=" + this.frontDay + ", ctx=" + this.ctx + "]";
    }
}

