/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.hr.ats.workShift.plan.matchSchedule;

import com.kingdee.eas.hr.ats.AtsLeaveBillEntryInfo;
import com.kingdee.eas.hr.ats.AtsOverTimeBillEntryInfo;
import com.kingdee.eas.hr.ats.AtsScheduleIntelInfo;
import com.kingdee.eas.hr.ats.AtsShiftInfo;
import com.kingdee.eas.hr.ats.AtsTripBillEntryInfo;
import com.kingdee.eas.hr.ats.ScheduleShiftInfo;
import com.kingdee.eas.hr.ats.util.common.AtsCommonUtile;
import com.kingdee.eas.hr.ats.vo.common.AtsCtx;
import com.kingdee.eas.hr.ats.vo.common.RangeMap;
import com.kingdee.eas.hr.ats.workShift.arrange.ArrangeShiftUtile;
import com.kingdee.eas.hr.ats.workShift.plan.matchSchedule.BaseMatchRuleAnalysor;
import com.kingdee.eas.hr.ats.workShift.plan.matchSchedule.MatchScheduleUtile;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.Map;

public class MatchDataInfo
extends AtsCtx {
    private Date beginDate;
    private Date endDate;
    private AtsScheduleIntelInfo matchPlan;
    private Collection<String> personNums;
    private Map<String, List<AtsShiftInfo>> shifts;
    private Map<String, Map<String, List<Date>>> punchcards;
    private Map<String, List<AtsOverTimeBillEntryInfo>> OTBill;
    private Map<String, List<AtsTripBillEntryInfo>> tripBill;
    private Map<String, List<AtsLeaveBillEntryInfo>> leaveBill;
    private Map<String, Map<String, Integer>> holidayMap;
    private BaseMatchRuleAnalysor matchAnalysor;
    private Map<String, RangeMap<Date, ScheduleShiftInfo>> scheduleMap;

    public Map<String, RangeMap<Date, ScheduleShiftInfo>> getScheduleMap() {
        return this.scheduleMap;
    }

    public void setScheduleMap(Map<String, RangeMap<Date, ScheduleShiftInfo>> scheduleMap) {
        this.scheduleMap = scheduleMap;
    }

    public void init() {
        String hrOrgId = this.matchPlan.getAtsScheduleIntelSet().getHrOrgUnit().getId().toString();
        this.punchcards = MatchScheduleUtile.getPunchCards(this.ctx, this.personNums, this.beginDate, this.endDate);
        this.OTBill = MatchScheduleUtile.getOverTimeBills(this.ctx, this.personNums, this.beginDate, this.endDate, hrOrgId);
        this.tripBill = MatchScheduleUtile.getTripBills(this.ctx, this.personNums, this.beginDate, this.endDate, hrOrgId);
        this.leaveBill = MatchScheduleUtile.getLeaveBills(this.ctx, this.personNums, this.beginDate, this.endDate);
        this.holidayMap = ArrangeShiftUtile.getPersonHoliday(this.ctx, this.personNums, AtsCommonUtile.getDateFormat().format(this.beginDate), AtsCommonUtile.getDateFormat().format(this.endDate));
    }

    public Collection<String> getPersonNums() {
        return this.personNums;
    }

    public void setPersonNums(Collection<String> personNums) {
        this.personNums = personNums;
    }

    public Map<String, List<AtsShiftInfo>> getShifts() {
        return this.shifts;
    }

    public void setShifts(Map<String, List<AtsShiftInfo>> shifts) {
        this.shifts = shifts;
    }

    public Map<String, Map<String, List<Date>>> getPunchcards() {
        return this.punchcards;
    }

    public void setPunchcards(Map<String, Map<String, List<Date>>> punchcards) {
        this.punchcards = punchcards;
    }

    public Map<String, List<AtsOverTimeBillEntryInfo>> getOTBill() {
        return this.OTBill;
    }

    public void setOTBill(Map<String, List<AtsOverTimeBillEntryInfo>> oTBill) {
        this.OTBill = oTBill;
    }

    public Map<String, List<AtsTripBillEntryInfo>> getTripBill() {
        return this.tripBill;
    }

    public void setTripBill(Map<String, List<AtsTripBillEntryInfo>> tripBill) {
        this.tripBill = tripBill;
    }

    public Map<String, List<AtsLeaveBillEntryInfo>> getLeaveBill() {
        return this.leaveBill;
    }

    public void setLeaveBill(Map<String, List<AtsLeaveBillEntryInfo>> leaveBill) {
        this.leaveBill = leaveBill;
    }

    public Map<String, Map<String, Integer>> getHolidayMap() {
        return this.holidayMap;
    }

    public void setHolidayMap(Map<String, Map<String, Integer>> holidayMap) {
        this.holidayMap = holidayMap;
    }

    public BaseMatchRuleAnalysor getMatchAnalysor() {
        return this.matchAnalysor;
    }

    public void setMatchAnalysor(BaseMatchRuleAnalysor matchAnalysor) {
        this.matchAnalysor = matchAnalysor;
    }

    public Date getBeginDate() {
        return this.beginDate;
    }

    public void setBeginDate(Date beginDate) {
        this.beginDate = beginDate;
    }

    public Date getEndDate() {
        return this.endDate;
    }

    public void setEndDate(Date endDate) {
        this.endDate = endDate;
    }

    public AtsScheduleIntelInfo getMatchPlan() {
        return this.matchPlan;
    }

    public void setMatchPlan(AtsScheduleIntelInfo matchPlan) {
        this.matchPlan = matchPlan;
    }

    public String toString() {
        return "MatchDataInfo [beginDate=" + this.beginDate + ", endDate=" + this.endDate + ", matchPlan=" + this.matchPlan + ", personNums=" + this.personNums + ", shifts=" + this.shifts + ", punchcards=" + this.punchcards + ", OTBill=" + this.OTBill + ", tripBill=" + this.tripBill + ", leaveBill=" + this.leaveBill + ", holidayMap=" + this.holidayMap + ", matchAnalysor=" + this.matchAnalysor + "]";
    }
}

