/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.shr.baseconfig.app.util;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.shr.base.syssetting.util.LocaleUtils;
import com.kingdee.shr.baseconfig.QueryConfigInfo;
import com.kingdee.shr.baseconfig.StructureConfigInfo;
import com.kingdee.util.StringUtils;
import java.sql.SQLException;
import java.text.MessageFormat;
import java.util.HashMap;
import java.util.Map;
import org.apache.log4j.Logger;

public final class StructureConfigUtil {
    private static Logger logger = Logger.getLogger((String)"com.kingdee.shr.baseconfig.app.util.StructureConfigUtil");
    public static final String LONG_CLIENT_NUMBER = "longClientNumber";
    public static final String LONG_ALIAS = "longAlias";
    public static final String LONG_NAME = "longName";

    public static Map<String, Map<String, String>> getStructureConfigInfoByLevel(Context ctx) throws BOSException {
        HashMap<String, Map<String, String>> result = new HashMap<String, Map<String, String>>();
        Map<String, Map<String, String>> coll = StructureConfigUtil.getStructureConfigCollection(ctx);
        HashMap<String, String> fullLongClientNumber = new HashMap<String, String>(coll.size());
        HashMap<String, String> fullLongAlias = new HashMap<String, String>(coll.size());
        Map<String, String> info = null;
        HashMap<String, String> map = null;
        for (String key : coll.keySet()) {
            info = coll.get(key);
            map = new HashMap<String, String>(2);
            map.put(LONG_CLIENT_NUMBER, StructureConfigUtil.getFullName(info.get("id"), fullLongClientNumber, coll, LONG_CLIENT_NUMBER, 0));
            map.put(LONG_ALIAS, StructureConfigUtil.getFullName(info.get("id"), fullLongAlias, coll, LONG_ALIAS, 0));
            result.put(info.get("id"), map);
        }
        return result;
    }

    private static Map<String, Map<String, String>> getStructureConfigCollection(Context ctx) throws BOSException {
        HashMap<String, Map<String, String>> outMap = new HashMap<String, Map<String, String>>();
        String shortCode = LocaleUtils.getShortCode((Context)ctx);
        String sql = MessageFormat.format("SELECT FID, FALIAS_{0} FALIAS, FCLIENTNUMBER, FPARENTID  FROM T_HR_StructureConfig", shortCode);
        IRowSet rs = StructureConfigUtil.query(ctx, sql);
        try {
            while (rs.next()) {
                HashMap<String, String> map = new HashMap<String, String>();
                map.put("id", rs.getString("FID"));
                map.put("parent", rs.getString("FPARENTID"));
                map.put(LONG_ALIAS, rs.getString("FALIAS"));
                map.put(LONG_CLIENT_NUMBER, rs.getString("FCLIENTNUMBER"));
                outMap.put(rs.getString("FID"), map);
            }
        }
        catch (SQLException e) {
            e.printStackTrace();
            throw new BOSException((Throwable)e);
        }
        return outMap;
    }

    private static IRowSet query(Context ctx, String sql) throws BOSException {
        IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)sql);
        return rs;
    }

    public static Map<String, String> getStructureConfigInfoByModel(Context ctx, StructureConfigInfo model) throws BOSException {
        Map<String, Map<String, String>> coll = StructureConfigUtil.getStructureConfigInfoByLevel(ctx);
        return coll.get(model.getId().toString());
    }

    public static Map<String, String> getStructureConfigInfoByModel(Context ctx, String structureConfigSchemeInfoId) throws BOSException {
        Map<String, Map<String, String>> coll = StructureConfigUtil.getStructureConfigInfoByLevel(ctx);
        StringBuffer sb = new StringBuffer();
        String l = LocaleUtils.getShortCode((Context)ctx);
        sb.append("SELECT").append(" scc.fid qcffid").append(" ,scc.fname_").append(l).append(" qcffalias").append(" ,sc.fid scfid").append(" ,sc.falias_").append(l).append(" scfalias").append(" ,sc.fclientNumber").append(" ,sc.FPARENTID").append(" from T_HR_StructureConfigScheme scs").append(" inner join T_HR_StructureConfig sc on scs.FID = sc.FSchemeID").append(" inner join T_HR_StructureConfigColumns scc on scc.FStructureConfigID = sc.FID").append(" where scs.FID  = '").append(structureConfigSchemeInfoId).append("'");
        IRowSet rs = StructureConfigUtil.query(ctx, sb.toString());
        HashMap<String, String> map = new HashMap<String, String>();
        try {
            while (rs.next()) {
                map.put(rs.getString("qcffid"), coll.get(rs.getString("scfid")).get(LONG_ALIAS) + "_" + rs.getString("scfalias"));
            }
        }
        catch (SQLException e) {
            e.printStackTrace();
            throw new BOSException((Throwable)e);
        }
        return map;
    }

    public static Map<String, String> getStructureConfigInfoByModel(Context ctx, QueryConfigInfo queryConfigInfo) throws BOSException {
        Map<String, Map<String, String>> coll = StructureConfigUtil.getStructureConfigInfoByLevel(ctx);
        String l = LocaleUtils.getShortCode((Context)ctx);
        StringBuffer sb = new StringBuffer();
        sb.append("SELECT").append(" qcf.fid qcffid").append(" ,qcf.falias_").append(l).append(" qcffalias").append(" ,sc.fid scfid").append(" ,sc.falias_").append(l).append(" scfalias").append(" ,sc.fclientNumber").append(" ,sc.FPARENTID").append(" FROM T_HR_QueryConfig qc").append(" inner join T_HR_QueryConfigField qcf on qc.FID = qcf.FParentID").append(" inner join T_HR_StructureConfigColumns scc on qcf.FFactFieldID = scc.FID").append(" inner join T_HR_StructureConfig sc on sc.FID = scc.FStructureConfigID").append(" where qc.FID  = '").append(queryConfigInfo.getId().toString()).append("'");
        IRowSet rs = StructureConfigUtil.query(ctx, sb.toString());
        HashMap<String, String> map = new HashMap<String, String>();
        try {
            while (rs.next()) {
                map.put(rs.getString("qcffid"), coll.get(rs.getString("scfid")).get(LONG_ALIAS) + "_" + rs.getString("qcffalias"));
            }
        }
        catch (SQLException e) {
            e.printStackTrace();
            throw new BOSException((Throwable)e);
        }
        return map;
    }

    private static String getFullName(String id, Map<String, String> result, Map<String, Map<String, String>> coll, String feild, int count) {
        if (result.containsKey(id)) {
            return result.get(id);
        }
        String fullName = "";
        Map<String, String> map = coll.get(id);
        if (null == map) {
            result.put(id, fullName);
            logger.error((Object)("Feild\uff1a" + feild + ",id:" + id));
            return fullName;
        }
        fullName = LONG_CLIENT_NUMBER.equals(feild) ? map.get(LONG_CLIENT_NUMBER) : map.get(LONG_ALIAS);
        int i = count + 1;
        if (i > 30) {
            return fullName;
        }
        if (!StringUtils.isEmpty((String)map.get("parent")) && !map.get("parent").equals(map.get("id"))) {
            fullName = StructureConfigUtil.getFullName(map.get("parent"), result, coll, feild, i) + "!" + fullName;
        }
        if (i > 30) {
            logger.error((Object)("count\uff1a" + i + ",fullName:" + fullName));
        }
        result.put(id, fullName);
        return fullName;
    }
}

