/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.shr.base.bizmanage.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.db.TempTablePool;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.basedata.org.AdminOrgUnitCollection;
import com.kingdee.eas.basedata.org.AdminOrgUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.shr.base.bizmanage.AdminOrgBUConfirmCollection;
import com.kingdee.shr.base.bizmanage.AdminOrgBUConfirmFactory;
import com.kingdee.shr.base.bizmanage.AdminOrgBUConfirmInfo;
import com.kingdee.shr.base.bizmanage.AdminOrgChangeMsgCollection;
import com.kingdee.shr.base.bizmanage.AdminOrgChangeMsgFactory;
import com.kingdee.shr.base.bizmanage.AdminOrgChangeMsgInfo;
import com.kingdee.shr.base.bizmanage.BizManageMessageFacadeFactory;
import com.kingdee.shr.base.bizmanage.BizManageTypeInfo;
import com.kingdee.shr.base.bizmanage.DataSource;
import com.kingdee.shr.base.bizmanage.ISHRBizManageMsgManage;
import com.kingdee.shr.base.bizmanage.ModifyTypeEnum;
import com.kingdee.shr.base.bizmanage.PersonBURelaConfirmCollection;
import com.kingdee.shr.base.bizmanage.PersonBURelaConfirmFactory;
import com.kingdee.shr.base.bizmanage.PersonChangeMsgCollection;
import com.kingdee.shr.base.bizmanage.PersonChangeMsgFactory;
import com.kingdee.shr.base.bizmanage.PersonChangeMsgInfo;
import com.kingdee.shr.base.bizmanage.SHRBizManageMsgManageFactory;
import com.kingdee.shr.base.bizmanage.app.AbstractBizManageMessageFacadeControllerBean;
import com.kingdee.shr.base.bizmanage.constant.BizManageMsgConstants;
import com.kingdee.shr.base.bizmanage.constant.CommonConstants;
import com.kingdee.shr.base.bizmanage.log.BizManageLoggerUtil;
import com.kingdee.shr.base.bizmanage.util.SHRBizManageCommonTool;
import com.kingdee.shr.base.bizmanage.util.SHRBizManageHelpUtil;
import com.kingdee.shr.base.bizmanage.util.SHRBizManageMessageUtil;
import com.kingdee.shr.base.syssetting.app.filter.HRFilterUtils;
import com.kingdee.shr.base.syssetting.util.DateUtils;
import com.kingdee.util.StringUtils;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.log4j.Logger;

public class BizManageMessageFacadeControllerBean
extends AbstractBizManageMessageFacadeControllerBean {
    private static Logger logger = BizManageLoggerUtil.getLogger();

    @Override
    protected void _dealAdminOrgChangeBizMessage(Context ctx) throws BOSException, EASBizException {
        AdminOrgChangeMsgCollection newColl = SHRBizManageMessageUtil.getNotDealedNewAdminOrgChangeMsgColltion(ctx);
        AdminOrgChangeMsgCollection modifiedColl = SHRBizManageMessageUtil.getNotDealedModifiedAdminOrgChangeMsgColltion(ctx);
        Set<String> newAdminOrgChangeMsgSet = this.getNewAdminOrgChangeMsgSet(newColl);
        this.newAdminOrgChangeMsgProcesser(ctx, newColl);
        this.modifiedAdminOrgChangeMsgProcesser(ctx, modifiedColl, newAdminOrgChangeMsgSet);
    }

    @Override
    protected void _dealPersonChangeBizMessage(Context ctx) throws BOSException, EASBizException {
        PersonChangeMsgCollection personMsgColl = SHRBizManageMessageUtil.getNotDealedNewPersonChangeMsgColltion(ctx);
        this.sHRBizManageMsgManageCoreProcesserOfPerson(ctx, personMsgColl, "false");
    }

    @Override
    protected void _dealAdminOrgComfirmMessage(Context ctx) throws BOSException, EASBizException {
        List<String> bizManageTypeIdList = SHRBizManageCommonTool.getEnableBizManageTypeIdListForOrg(ctx);
        for (String bizManageTypeId : bizManageTypeIdList) {
            AdminOrgBUConfirmCollection coll = SHRBizManageMessageUtil.getNotDealedAdminOrgBUConfirmMsgCollection(ctx, bizManageTypeId);
            if (coll.size() <= 0) continue;
            ISHRBizManageMsgManage instance = SHRBizManageMsgManageFactory.getInstance(ctx, bizManageTypeId, 1);
            instance.addEnableAdminOrgManageInfo(ctx, coll);
        }
    }

    @Override
    protected void _dealPersonComfirmMessage(Context ctx) throws BOSException, EASBizException {
        List<String> bizManageTypeIdList = SHRBizManageCommonTool.getEnableBizManageTypeIdList(ctx);
        for (String bizManageTypeId : bizManageTypeIdList) {
            try {
                Context copyCtx = this.copyCtx(ctx);
                if (bizManageTypeId.equals(CommonConstants.BIZMANAGETYPE_ATS01) || bizManageTypeId.equals(CommonConstants.BIZMANAGETYPE_ATS02) || bizManageTypeId.equals(CommonConstants.BIZMANAGETYPE_CMP01) || bizManageTypeId.equals(CommonConstants.BIZMANAGETYPE_CMP02) || bizManageTypeId.equals(CommonConstants.BIZMANAGETYPE_CMP03) || bizManageTypeId.equals(CommonConstants.BIZMANAGETYPE_PERF)) {
                    ISHRBizManageMsgManage instance = SHRBizManageMsgManageFactory.getInstance(ctx, bizManageTypeId, 0);
                    ArrayList<String> list = new ArrayList<String>();
                    instance.addInitFileEnablePersonManageInfo(ctx, list);
                } else if (!bizManageTypeId.equals(CommonConstants.BIZMANAGETYPE_EMP01)) {
                    BizManageMessageFacadeFactory.getLocalInstance(copyCtx).dealPersonComfirmMessageByBizManageType(bizManageTypeId, true);
                }
                copyCtx = this.copyCtx(ctx);
                BizManageMessageFacadeFactory.getLocalInstance(copyCtx).dealPersonComfirmMessageByBizManageType(bizManageTypeId, false);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    private Context copyCtx(Context ctx) {
        if (null == ctx) {
            return ctx;
        }
        Context copyCtx = new Context(ctx.getCaller(), ctx.getSolution(), ctx.getAIS(), ctx.getOriginLocale(), ctx.getContextID());
        copyCtx.setUserName(ctx.getUserName());
        copyCtx.setClientHostIP(ctx.getClientHostIP());
        copyCtx.setClientHostName(ctx.getClientHostName());
        copyCtx.setReadAIS(ctx.getReadAIS());
        copyCtx.setLocale(ctx.getLocale());
        Set userDefineFieldKeySet = ctx.getUserDefineFieldKeySet();
        for (Object key : userDefineFieldKeySet) {
            copyCtx.put(key, ctx.get(key));
        }
        return copyCtx;
    }

    private void newAdminOrgChangeMsgProcesser(Context ctx, AdminOrgChangeMsgCollection newColl) throws BOSException, EASBizException {
        HashMap<String, Object> param = new HashMap<String, Object>();
        param.put(BizManageMsgConstants.PARAM_ADMINORG_MODIFYTYPE, "1");
        param.put(BizManageMsgConstants.PARAM_ADMINORG_MSGCOLL, (Object)newColl);
        this.sHRBizManageMsgManageCoreProcesserOfAdminOrg(ctx, param);
    }

    private void modifiedAdminOrgChangeMsgProcesser(Context ctx, AdminOrgChangeMsgCollection modifiedColl, Set<String> newAdminOrgChangeMsgSet) throws BOSException, EASBizException {
        HashMap<String, Object> param = new HashMap<String, Object>();
        param.put(BizManageMsgConstants.PARAM_ADMINORG_MODIFYTYPE, "2");
        for (int i = 0; i < modifiedColl.size(); ++i) {
            AdminOrgChangeMsgInfo item = modifiedColl.get(i);
            AdminOrgUnitCollection lowerAdminOrgColl = SHRBizManageMessageUtil.getLowerLevelAdminOrgUnitCollection(ctx, item.getAdminOrg());
            this.adminOrgUnitCollectionFilter(ctx, lowerAdminOrgColl, newAdminOrgChangeMsgSet);
            AdminOrgChangeMsgCollection msgColl = this.lowerLevelAdminOrgChangeMsgBuilder(ctx, item, lowerAdminOrgColl);
            param.put(BizManageMsgConstants.PARAM_ADMINORG_MSGCOLL, (Object)msgColl);
            this.sHRBizManageMsgManageCoreProcesserOfAdminOrg(ctx, param);
        }
    }

    private Set<String> getNewAdminOrgChangeMsgSet(AdminOrgChangeMsgCollection coll) {
        HashSet<String> newAdminOrgChangeMsgSet = new HashSet<String>();
        for (int i = 0; i < coll.size(); ++i) {
            newAdminOrgChangeMsgSet.add(coll.get(i).getId().toString());
        }
        return newAdminOrgChangeMsgSet;
    }

    private void adminOrgUnitCollectionFilter(Context ctx, AdminOrgUnitCollection coll, Set<String> newAdminOrgChangeMsgSet) throws BOSException {
        for (int i = 0; i < coll.size(); ++i) {
            AdminOrgUnitInfo item = coll.get(i);
            String adminOrgId = item.getId().toString();
            if (newAdminOrgChangeMsgSet.contains(adminOrgId)) {
                coll.remove(item);
                --i;
                continue;
            }
            if (SHRBizManageMessageUtil.isExistsEnableAdminOrgBURelation(ctx, adminOrgId)) continue;
            coll.remove(item);
        }
    }

    private AdminOrgChangeMsgCollection lowerLevelAdminOrgChangeMsgBuilder(Context ctx, AdminOrgChangeMsgInfo rootInfo, AdminOrgUnitCollection lowerAdminOrgColl) throws BOSException {
        AdminOrgChangeMsgCollection coll = new AdminOrgChangeMsgCollection();
        coll.add(rootInfo);
        String description = rootInfo.getDescription();
        Date newChangeDate = rootInfo.getNewChangeDate();
        BOSUuid id = rootInfo.getId();
        for (int i = 0; i < lowerAdminOrgColl.size(); ++i) {
            AdminOrgChangeMsgInfo tempInfo = new AdminOrgChangeMsgInfo();
            AdminOrgUnitInfo itemInfo = lowerAdminOrgColl.get(i);
            tempInfo.setId(BOSUuid.create((String)"AA46B03B"));
            tempInfo.setAdminOrg(itemInfo.getId().toString());
            tempInfo.setDescription(description);
            tempInfo.setNewChangeDate(newChangeDate);
            Date oldChangeDate = SHRBizManageMessageUtil.getAdminOrgUnitOldChangeDate(ctx, itemInfo.getId().toString(), newChangeDate);
            tempInfo.setOldChangeDate(oldChangeDate);
            coll.add(tempInfo);
        }
        return coll;
    }

    private void sHRBizManageMsgManageCoreProcesserOfAdminOrg(Context ctx, Map<String, Object> param) throws EASBizException, BOSException {
        List<String> bizManageTypeIdList = SHRBizManageCommonTool.getEnableBizManageTypeIdListForOrg(ctx);
        for (String bizManageTypeId : bizManageTypeIdList) {
            ISHRBizManageMsgManage instance = SHRBizManageMsgManageFactory.getInstance(ctx, bizManageTypeId, 1);
            instance.addAdminOrgChangeMsgByBizType(ctx, param);
        }
    }

    @Override
    protected void _dealPersonComfirmMessageByBizManageType(Context ctx, String bizManageTypeId, boolean isEmpInit) throws BOSException, EASBizException {
        BizManageTypeInfo bizTypeInfo = SHRBizManageCommonTool.getPersonBizManageTypeInfo(ctx, bizManageTypeId);
        if (bizTypeInfo.isState()) {
            if (isEmpInit) {
                this.batchDealPersonComfirmMessageByBizManageType(ctx, bizManageTypeId, true);
            } else if (bizTypeInfo.isUseDefault()) {
                this.batchDealPersonComfirmMessageByBizManageType(ctx, bizManageTypeId, false);
            }
        }
    }

    private void batchDealPersonInitComfirmMessageByBizManageType(Context ctx, String bizManageTypeId) throws EASBizException, BOSException {
        String sql = "select top 5000 fid from T_HR_PersonBURelaConfirm where FIsEmpInit=1 and fDealState=0 and FBizManageTypeID=? ";
        IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)sql, (Object[])new String[]{bizManageTypeId});
        HashMap<String, Object> param = new HashMap<String, Object>();
        String tempTblName = null;
        try {
            if (rs.next()) {
                tempTblName = TempTablePool.getInstance((Context)ctx).createTempTable("create table T_HR_PERSONCONFIRMMSGTMPTBL (FID varchar(44))");
                StringBuffer insertSqlBuf = new StringBuffer();
                insertSqlBuf.append("insert into ").append(tempTblName).append("(FID) ").append(sql);
                DbUtil.execute((Context)ctx, (String)insertSqlBuf.toString(), (Object[])new String[]{bizManageTypeId});
                param.put(BizManageMsgConstants.PARAM_PERSON_INIT_CONFIRM_MSGTBL_NAME, tempTblName);
                ISHRBizManageMsgManage instance = SHRBizManageMsgManageFactory.getInstance(ctx, bizManageTypeId, 0);
                instance.batchAddEnablePersonInitManageInfo(ctx, param);
            }
        }
        catch (Exception e) {
            throw new BOSException((Throwable)e);
        }
        finally {
            if (!StringUtils.isEmpty(tempTblName)) {
                TempTablePool.getInstance((Context)ctx).releaseTable(tempTblName);
            }
        }
    }

    private void batchDealPersonComfirmMessageByBizManageType(Context ctx, String bizManageTypeId, boolean isEmpInit) throws EASBizException, BOSException {
        ISHRBizManageMsgManage instance = SHRBizManageMsgManageFactory.getInstance(ctx, bizManageTypeId, 0);
        String sql = "SELECT TOP 500 FID FROM T_HR_PersonBURelaConfirm temp1 WHERE FIsEmpInit=? AND FDealState=0 AND FBizManageTypeID=? AND FIsAlreadyDeal = 0  AND fisalreadyloop=0  AND fAffairActionOperate IS NOT NULL";
        if (bizManageTypeId.equals(CommonConstants.BIZMANAGETYPE_CMP01) || bizManageTypeId.equals(CommonConstants.BIZMANAGETYPE_CMP02) || bizManageTypeId.equals(CommonConstants.BIZMANAGETYPE_CMP03)) {
            sql = sql + " and FBizDefineType NOT IN (11,4,6,8)";
            sql = sql + " and FAffairActionOperate NOT IN (20,70)";
            sql = sql + " and FDefaultHrOrgUnitID IN " + SHRBizManageCommonTool.list2SQLinclude(SHRBizManageHelpUtil.getParamHrOrgUnitListByBizManage(ctx, bizManageTypeId));
            sql = sql + " and FNewEmpOrgRelationID IN (SELECT FID FROM T_HR_EmpOrgRelation WHERE FAssignType = 1)";
            sql = sql + " and (FAffairActionReasonID IN (SELECT FID FROM T_HR_AffairActionReason WHERE FLONGNUMBER LIKE '03%' OR  FLONGNUMBER LIKE '01%') OR FAffairActionReasonID IS NULL)";
        }
        sql = sql + " and not exists (select fid from T_HR_PersonBURelaConfirm  temp2  where  temp2.fpersonid=temp1.fpersonid   AND FDealState=0 AND FIsAlreadyDeal = 0 and fisalreadyloop=0 and FBizManageTypeID='" + bizManageTypeId + "' )    order by fchangeDate,fcreateTime,FbizDefineEntrySeq";
        int isEmpInitVal = isEmpInit ? 1 : 0;
        IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)sql, (Object[])new Object[]{isEmpInitVal, bizManageTypeId});
        ArrayList<String> allIdList = new ArrayList<String>();
        try {
            while (rs.next()) {
                allIdList.add(rs.getString(1));
            }
        }
        catch (SQLException e) {
            throw new BOSException((Throwable)e);
        }
        if (allIdList.size() == 0) {
            String sqlnext = "SELECT TOP 500 FID FROM T_HR_PersonBURelaConfirm WHERE FIsEmpInit=? AND FDealState=0 AND FBizManageTypeID=? AND FIsAlreadyDeal = 0  AND fisalreadyloop=1 AND fAffairActionOperate IS NOT NULL";
            if (bizManageTypeId.equals(CommonConstants.BIZMANAGETYPE_CMP01) || bizManageTypeId.equals(CommonConstants.BIZMANAGETYPE_CMP02) || bizManageTypeId.equals(CommonConstants.BIZMANAGETYPE_CMP03)) {
                sqlnext = sqlnext + " and FBizDefineType NOT IN (11,4,6,8)";
                sqlnext = sqlnext + " and FAffairActionOperate NOT IN (20,70)";
                sqlnext = sqlnext + " and FDefaultHrOrgUnitID IN " + SHRBizManageCommonTool.list2SQLinclude(SHRBizManageHelpUtil.getParamHrOrgUnitListByBizManage(ctx, bizManageTypeId));
                sqlnext = sqlnext + " and FNewEmpOrgRelationID IN (SELECT FID FROM T_HR_EmpOrgRelation WHERE FAssignType = 1)";
                sqlnext = sqlnext + " and (FAffairActionReasonID IN (SELECT FID FROM T_HR_AffairActionReason WHERE FLONGNUMBER LIKE '03%' OR  FLONGNUMBER LIKE '01%') OR FAffairActionReasonID IS NULL)";
            }
            sqlnext = sqlnext + " order by fchangeDate,fcreateTime,FbizDefineEntrySeq";
            IRowSet rsnext = DbUtil.executeQuery((Context)ctx, (String)sqlnext, (Object[])new Object[]{isEmpInitVal, bizManageTypeId});
            try {
                while (rsnext.next()) {
                    allIdList.add(rsnext.getString(1));
                }
            }
            catch (SQLException e) {
                throw new BOSException((Throwable)e);
            }
        }
        if (allIdList.size() > 0 && isEmpInit) {
            int commit_count = 250;
            int initCount = 0;
            String idString = "";
            ArrayList<String> list = new ArrayList<String>();
            int size = allIdList.size();
            for (int i = 0; i < size; ++i) {
                idString = idString + ",'" + (String)allIdList.get(i) + "'";
                list.add((String)allIdList.get(i));
                if (++initCount < commit_count) continue;
                String insertSql = this.getInitPersonInsertSql(ctx, bizManageTypeId, idString.substring(1));
                DbUtil.execute((Context)ctx, (String)insertSql);
                instance.addInitFileEnablePersonManageInfo(ctx, list);
                DbUtil.execute((Context)ctx, (String)("UPDATE T_HR_PersonBURelaConfirm SET FDealState = 1 WHERE FID IN (" + idString.substring(1) + ")"));
                initCount = 0;
                idString = "";
                list = new ArrayList();
            }
            if (initCount > 0 && !idString.equals("")) {
                String insertSql = this.getInitPersonInsertSql(ctx, bizManageTypeId, idString.substring(1));
                DbUtil.execute((Context)ctx, (String)insertSql);
                instance.addInitFileEnablePersonManageInfo(ctx, list);
                DbUtil.execute((Context)ctx, (String)("UPDATE T_HR_PersonBURelaConfirm SET FDealState = 1 WHERE FID IN (" + idString.substring(1) + ")"));
            }
        } else if (allIdList.size() > 0) {
            PersonBURelaConfirmCollection coll;
            int commit_count = 250;
            ArrayList<String> batchIdList = new ArrayList<String>();
            int initCount = 0;
            int size = allIdList.size();
            for (int i = 0; i < size; ++i) {
                if (initCount >= commit_count) {
                    PersonBURelaConfirmCollection coll2 = SHRBizManageMessageUtil.getNotDealedPersonBUConfirmMsgCollection(ctx, bizManageTypeId, isEmpInit, batchIdList);
                    if (coll2.size() > 0) {
                        instance.addEnablePersonManageInfo(ctx, coll2);
                    }
                    initCount = 0;
                    batchIdList = new ArrayList();
                }
                batchIdList.add((String)allIdList.get(i));
                ++initCount;
            }
            if (initCount > 0 && (coll = SHRBizManageMessageUtil.getNotDealedPersonBUConfirmMsgCollection(ctx, bizManageTypeId, isEmpInit, batchIdList)).size() > 0) {
                instance.addEnablePersonManageInfo(ctx, coll);
            }
        }
    }

    public String getInitPersonInsertSql(Context ctx, String bizManageTypeId, String idSet) throws BOSException, EASBizException {
        String userId = HRFilterUtils.getCurrentUserId((Context)ctx);
        Date date = new Date();
        SimpleDateFormat formatter = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        String dateString = formatter.format(date);
        String insertSql = "insert into T_HR_PersonBURelation(FPersonID, FEmpOrgRelationID, FEmpPostExpHisID, FBizManageTypeID, FHrOrgUnitID, FBeginDate, FEndDate, FState, FItemState, FVersion, FUseDefault, FEFFDT, FComfirmMsgId, FCreatorID, FCreateTime, FLastUpdateUserID, FLastUpdateTime, FControlUnitID, FID, FIsEmpInit, FDataSource) SELECT FPersonID,FNewEmpOrgRelationID,FNewEmpPostExpHisID,'" + bizManageTypeId + "',FNewHrOrgUnitID,FCreateTime,null,1,2,null,1,FChangeDate,FID,'" + userId + "',{ts'" + dateString + "'},'" + userId + "',{ts'" + dateString + "'},'00000000-0000-0000-0000-000000000000CCE7AED4',newbosid('9F35F085'),1,1 FROM T_HR_PersonBURelaConfirm WHERE FID IN (" + idSet + ")";
        return insertSql;
    }

    @Override
    protected void _addDefaultBURelationForNewAdminOrg(Context ctx, AdminOrgUnitInfo adminOrgInfo) throws BOSException, EASBizException {
        String adminOrgId = adminOrgInfo.getId().toString();
        AdminOrgChangeMsgInfo orgChangeMsgInfo = new AdminOrgChangeMsgInfo();
        orgChangeMsgInfo.setAdminOrg(adminOrgId);
        orgChangeMsgInfo.setNewParent(adminOrgInfo.getParent().getId().toString());
        orgChangeMsgInfo.setNewChangeDate(adminOrgInfo.getEFFDT());
        orgChangeMsgInfo.setDealState(true);
        orgChangeMsgInfo.setModifyType(ModifyTypeEnum.ADDNEW);
        IObjectPK msgId = AdminOrgChangeMsgFactory.getLocalInstance(ctx).addnew((CoreBaseInfo)orgChangeMsgInfo);
        orgChangeMsgInfo.setId(BOSUuid.read((String)msgId.toString()));
        AdminOrgChangeMsgCollection newColl = new AdminOrgChangeMsgCollection();
        newColl.add(orgChangeMsgInfo);
        this.newAdminOrgChangeMsgProcesser(ctx, newColl);
        AdminOrgBUConfirmCollection coll = AdminOrgBUConfirmFactory.getLocalInstance(ctx).getAdminOrgBUConfirmCollection("where adminOrg.id = '" + adminOrgId + "'");
        List<String> bizManageTypeIdList = SHRBizManageCommonTool.getEnableBizManageTypeIdListForOrg(ctx);
        ISHRBizManageMsgManage instance = null;
        for (String bizManageTypeId : bizManageTypeIdList) {
            int size = coll.size();
            for (int i = 0; i < size; ++i) {
                AdminOrgBUConfirmInfo adminOrgBUConfirmInfo = coll.get(i);
                if (!bizManageTypeId.equals(adminOrgBUConfirmInfo.getBizManageType().getId().toString())) continue;
                instance = SHRBizManageMsgManageFactory.getInstance(ctx, bizManageTypeId, 1);
                AdminOrgBUConfirmCollection confirmColl = new AdminOrgBUConfirmCollection();
                adminOrgBUConfirmInfo.setDataSource(DataSource.ChangeOperation);
                confirmColl.add(adminOrgBUConfirmInfo);
                instance.addEnableAdminOrgManageInfo(ctx, confirmColl);
            }
        }
    }

    @Override
    protected void _addDefaultBURelationForNewPerson(Context ctx, PersonChangeMsgInfo personChangeMsgInfo) throws BOSException, EASBizException {
        String isSupplementBill = "false";
        if ("true".equals(personChangeMsgInfo.get("isSupplementBill"))) {
            isSupplementBill = "true";
        }
        personChangeMsgInfo.setDealState(true);
        IObjectPK objectPK = PersonChangeMsgFactory.getLocalInstance(ctx).addnew((CoreBaseInfo)personChangeMsgInfo);
        String oql = "select * where id='" + objectPK + "'";
        PersonChangeMsgCollection personMsgColl = PersonChangeMsgFactory.getLocalInstance(ctx).getPersonChangeMsgCollection(oql);
        this.sHRBizManageMsgManageCoreProcesserOfPerson(ctx, personMsgColl, isSupplementBill);
        DbUtil.execute((Context)ctx, (String)("UPDATE T_HR_PersonChangeMsg SET fDealState = 1 WHERE FID = '" + objectPK.toString() + "'"));
        StringBuffer oqlStrBuffer = new StringBuffer();
        oqlStrBuffer.append("select *,oldEmpOrgRelation.*,newEmpOrgRelation.* where bizManageType.id='").append("SGuJm3nXW0GshQfKRXenomWJ1dE=").append("'").append(" and person.id='").append(personChangeMsgInfo.getPerson()).append("'").append(" and confirmState=0");
        PersonBURelaConfirmCollection confirmColl = PersonBURelaConfirmFactory.getLocalInstance(ctx).getPersonBURelaConfirmCollection(oqlStrBuffer.toString());
        if (confirmColl.size() > 0) {
            ISHRBizManageMsgManage instance = SHRBizManageMsgManageFactory.getInstance(ctx, "SGuJm3nXW0GshQfKRXenomWJ1dE=", 0);
            instance.addEnablePersonManageInfo(ctx, confirmColl);
        }
    }

    private void sHRBizManageMsgManageCoreProcesserOfPerson(Context ctx, PersonChangeMsgCollection personMsgColl, String isSupplementBill) throws BOSException, EASBizException {
        HashMap<String, Object> param = new HashMap<String, Object>();
        param.put(BizManageMsgConstants.PARAM_PERSON_MSGCOLL, (Object)personMsgColl);
        param.put(BizManageMsgConstants.IS_SUPPLEMENT_BILL, isSupplementBill);
        if (personMsgColl.size() > 0) {
            List<String> bizManageTypeIdList = SHRBizManageCommonTool.getEnableBizManageTypeIdList(ctx);
            for (String bizManageTypeId : bizManageTypeIdList) {
                ISHRBizManageMsgManage instance = SHRBizManageMsgManageFactory.getInstance(ctx, bizManageTypeId, 0);
                instance.addPersonChangeMsgByBizType(ctx, param);
            }
        }
    }

    @Override
    protected void _synAdminAndPersonDataToHisTable(Context ctx) throws BOSException, EASBizException {
        this.synAdminOrgBUConfirmToHis(ctx);
        this.synAdminOrgBURelationToHis(ctx);
        this.synPersonBUConfirmToHis(ctx);
        this.synPersonBURelationToHis(ctx);
    }

    private void synAdminOrgBUConfirmToHis(Context ctx) throws BOSException, EASBizException {
        String insertSql = "insert into T_HR_AdminOrgBUConfirmHIS(FID,FHistoryRelateID,FAdminOrgID, FBizManageTypeID, FOldManageHrOrgID,FNewManageHrOrgID, FOldChangeDate, FNewChangeDate, FConfirmState, FChangeMsgId,FDescription_l1, FDescription_l2, FDescription_l3, FCreatorID, FCreateTime,FLastUpdateUserID, FLastUpdateTime, FControlUnitID, FDataSource) SELECT newbosid('52E0467B'),FID,FAdminOrgID, FBizManageTypeID, FOldManageHrOrgID, FNewManageHrOrgID, FOldChangeDate, FNewChangeDate, FConfirmState, FChangeMsgId, FDescription_l1, FDescription_l2, FDescription_l3, FCreatorID, FCreateTime, FLastUpdateUserID, FLastUpdateTime, FControlUnitID, FDataSource FROM T_HR_AdminOrgBUConfirm BUCONFIRM WHERE  NOT EXISTS (SELECT 1 FROM T_HR_AdminOrgBUConfirmHIS WHERE FHistoryRelateID=BUCONFIRM.FID)";
        DbUtil.execute((Context)ctx, (String)insertSql);
        String deleteSql = "DELETE FROM T_HR_AdminOrgBUConfirm WHERE FID IN (SELECT FHistoryRelateID FROM T_HR_AdminOrgBUConfirmHIS) AND FConfirmState = 1";
        DbUtil.execute((Context)ctx, (String)deleteSql);
        String updateSql = "UPDATE T_HR_AdminOrgBUConfirmHIS t0 SET  (FAdminOrgID, FBizManageTypeID, FOldManageHrOrgID, FNewManageHrOrgID, FOldChangeDate, FNewChangeDate, FConfirmState, FChangeMsgId, FDescription_l1, FDescription_l2, FDescription_l3, FDataSource, FCreatorID, FCreateTime, FLastUpdateUserID, FLastUpdateTime, FControlUnitID) =  (SELECT FAdminOrgID, FBizManageTypeID, FOldManageHrOrgID, FNewManageHrOrgID, FOldChangeDate, FNewChangeDate, FConfirmState, FChangeMsgId, FDescription_l1, FDescription_l2, FDescription_l3, FDataSource, FCreatorID, FCreateTime, FLastUpdateUserID, FLastUpdateTime, FControlUnitID FROM T_HR_AdminOrgBUConfirm t1 WHERE t0.FHistoryRelateID = t1.FID AND t0.FConfirmState <> t1.FConfirmState)";
        DbUtil.execute((Context)ctx, (String)updateSql);
    }

    private void synAdminOrgBURelationToHis(Context ctx) throws BOSException, EASBizException {
        String insertSql = "insert into T_HR_AdminOrgBURelationHIS(FID,FHistoryRelateID,FAdminOrgID, FBizManageTypeID, FManageHrOrgID,FBeginDate, FEndDate, FState, FIsDefaultManage, FDescription_l1,FDescription_l2, FDescription_l3, FCreatorID, FCreateTime, FLastUpdateUserID,FLastUpdateTime, FControlUnitID, FCOMFIRMMSGID, FEFFDT,FDataSource) SELECT newbosid('C16BAE5C'),FID,FAdminOrgID, FBizManageTypeID, FManageHrOrgID, FBeginDate, FEndDate, FState, FIsDefaultManage, FDescription_l1, FDescription_l2, FDescription_l3, FCreatorID, FCreateTime, FLastUpdateUserID, FLastUpdateTime, FControlUnitID, FCOMFIRMMSGID, FEFFDT,FDataSource FROM T_HR_AdminOrgBURelation BURELATION WHERE  NOT EXISTS (SELECT 1 FROM T_HR_AdminOrgBURelationHIS WHERE FHistoryRelateID=BURELATION.FID)";
        DbUtil.execute((Context)ctx, (String)insertSql);
        List<String> bizManageTypeIdList = SHRBizManageCommonTool.getEnableBizManageTypeIdListForOrg(ctx);
        for (String bizManageTypeId : bizManageTypeIdList) {
            StringBuffer deleteSql = new StringBuffer();
            deleteSql.append(" DELETE FROM T_HR_AdminOrgBURelation WHERE FID IN (SELECT FHistoryRelateID FROM T_HR_AdminOrgBURelationHIS) AND FState = 2 ");
            deleteSql.append(" AND FBIZMANAGETYPEID = ? ");
            deleteSql.append(" and fid not in ( ");
            deleteSql.append(" select a.fid from t_hr_adminorgburelation a ");
            deleteSql.append(" where a.fid = ( select top 1 b.fid  from t_hr_adminorgburelation b where a.FADMINORGID = b.FADMINORGID and b.FBIZMANAGETYPEID = ? order by b.FCREATETIME desc) ");
            deleteSql.append(" and a.FBIZMANAGETYPEID = ? ");
            deleteSql.append(" and a.fadminorgid in (select FADMINORGID  from t_hr_adminorgburelation where FBIZMANAGETYPEID = ? group by FADMINORGID having count(*) > 1) ");
            deleteSql.append(" ) ");
            deleteSql.append(" and fadminorgid in (select FADMINORGID  from t_hr_adminorgburelation where FBIZMANAGETYPEID = ? group by FADMINORGID having count(*) > 1) ");
            DbUtil.execute((Context)ctx, (String)deleteSql.toString(), (Object[])new Object[]{bizManageTypeId, bizManageTypeId, bizManageTypeId, bizManageTypeId, bizManageTypeId});
        }
        String updateSql = "UPDATE T_HR_AdminOrgBURelationHIS t0 SET  (FAdminOrgID, FBizManageTypeID, FManageHrOrgID, FBeginDate, FEndDate, FState, FIsDefaultManage, FComfirmMsgId, FEFFDT, FDescription_l1, FDescription_l2, FDescription_l3, FCreatorID, FCreateTime, FLastUpdateUserID, FLastUpdateTime, FControlUnitID,FDataSource) =  (SELECT FAdminOrgID, FBizManageTypeID, FManageHrOrgID, FBeginDate, FEndDate, FState, FIsDefaultManage, FComfirmMsgId, FEFFDT, FDescription_l1, FDescription_l2, FDescription_l3, FCreatorID, FCreateTime, FLastUpdateUserID, FLastUpdateTime, FControlUnitID,FDataSource  FROM T_HR_AdminOrgBURelation t1 WHERE t0.FHistoryRelateID = t1.FID AND t0.FState <> t1.FState)";
        DbUtil.execute((Context)ctx, (String)updateSql);
    }

    private void synPersonBUConfirmToHis(Context ctx) throws BOSException, EASBizException {
        String insertSql = "insert into T_HR_PersonBURelaConfirmHIS(FID,FHistoryRelateID,FPersonID, FHRBizDefineID, FBizDefineType, FChangeDate, FOldEmpOrgRelationID, FOldEmpPostExpHisID, FNewEmpOrgRelationID, FNewEmpPostExpHisID, FCurEmpOrgRelationID, FBizManageTypeID, FOldHrOrgUnitID, FNewHrOrgUnitID, FDefaultHrOrgUnitID, FAffairActionReasonID, FAffairActionTransId, FDealState, FChangeMsgId, FbizDefineEntrySeq, FVersion, FCreatorID, FCreateTime, FLastUpdateUserID, FLastUpdateTime, FControlUnitID, FAffairActionOperate, FIsEmpInit, FDataSource,FIsPositive,FIsSupplementBill,FUndoPosStartDate,FIsAlreadyDeal) SELECT newbosid('701C1F8F'),FID,FPersonID, FHRBizDefineID, FBizDefineType, FChangeDate, FOldEmpOrgRelationID, FOldEmpPostExpHisID, FNewEmpOrgRelationID, FNewEmpPostExpHisID, FCurEmpOrgRelationID, FBizManageTypeID, FOldHrOrgUnitID, FNewHrOrgUnitID, FDefaultHrOrgUnitID, FAffairActionReasonID, FAffairActionTransId, FDealState, FChangeMsgId, FbizDefineEntrySeq, FVersion,  FCreatorID, FCreateTime, FLastUpdateUserID, FLastUpdateTime, FControlUnitID, FAffairActionOperate, FIsEmpInit, FDataSource,FIsPositive,FIsSupplementBill,FUndoPosStartDate,FIsAlreadyDeal FROM T_HR_PersonBURelaConfirm CONFIRM WHERE  NOT EXISTS (SELECT 1 FROM T_HR_PersonBURelaConfirmHIS WHERE FHistoryRelateID=CONFIRM.FID)  and FChangeDate < {ts'" + this.getTime() + "'}";
        DbUtil.execute((Context)ctx, (String)insertSql);
        String deleteSql = "DELETE FROM T_HR_PersonBURelaConfirm WHERE FID IN (SELECT FHistoryRelateID FROM T_HR_PersonBURelaConfirmHIS) AND FDealState IN (1,2)";
        DbUtil.execute((Context)ctx, (String)deleteSql);
        String updateSql = "UPDATE T_HR_PersonBURelaConfirmHIS t0 SET  (FPersonID, FHRBizDefineID, FBizDefineType,FChangeDate, FOldEmpOrgRelationID, FOldEmpPostExpHisID, FNewEmpOrgRelationID, FNewEmpPostExpHisID, FCurEmpOrgRelationID, FBizManageTypeID, FOldHrOrgUnitID, FNewHrOrgUnitID, FDefaultHrOrgUnitID, FAffairActionReasonID, FAffairActionTransId, FDealState, FChangeMsgId, FbizDefineEntrySeq, FVersion, FCreatorID, FCreateTime, FLastUpdateUserID, FLastUpdateTime, FControlUnitID, FAffairActionOperate, FIsEmpInit, FDataSource,FIsPositive,FIsSupplementBill,FUndoPosStartDate,FIsAlreadyDeal) =  (SELECT FPersonID, FHRBizDefineID, FBizDefineType,FChangeDate, FOldEmpOrgRelationID, FOldEmpPostExpHisID, FNewEmpOrgRelationID, FNewEmpPostExpHisID, FCurEmpOrgRelationID, FBizManageTypeID, FOldHrOrgUnitID, FNewHrOrgUnitID, FDefaultHrOrgUnitID, FAffairActionReasonID, FAffairActionTransId, FDealState, FChangeMsgId, FbizDefineEntrySeq, FVersion, FCreatorID, FCreateTime, FLastUpdateUserID, FLastUpdateTime, FControlUnitID, FAffairActionOperate, FIsEmpInit, FDataSource,FIsPositive,FIsSupplementBill,FUndoPosStartDate,FIsAlreadyDeal FROM T_HR_PersonBURelaConfirm t1 WHERE t0.FHistoryRelateID = t1.FID AND t0.FDealState <> t1.FDealState)";
        DbUtil.execute((Context)ctx, (String)updateSql);
    }

    private void synPersonBURelationToHis(Context ctx) throws BOSException, EASBizException {
        String insertSql = "insert into T_HR_PersonBURelationHIS(FID,FHistoryRelateID,FPersonID, FEmpOrgRelationID, FEmpPostExpHisID, FBizManageTypeID, FHrOrgUnitID, FBeginDate, FEndDate, FState, FItemState, FVersion, FUseDefault, FEFFDT, FComfirmMsgId, FCreatorID, FCreateTime, FLastUpdateUserID, FLastUpdateTime, FControlUnitID, FIsEmpInit, FDataSource,FDESCRIPTION_L1,FDESCRIPTION_L2,FDESCRIPTION_L3) SELECT newbosid('9F35F085'),FID,FPersonID, FEmpOrgRelationID, FEmpPostExpHisID, FBizManageTypeID, FHrOrgUnitID, FBeginDate, FEndDate, FState, FItemState, FVersion, FUseDefault, FEFFDT, FComfirmMsgId, FCreatorID, FCreateTime, FLastUpdateUserID, FLastUpdateTime, FControlUnitID, FIsEmpInit, FDataSource,FDESCRIPTION_L1,FDESCRIPTION_L2,FDESCRIPTION_L3 FROM T_HR_PersonBURelation BURELATION WHERE  NOT EXISTS (SELECT 1 FROM T_HR_PersonBURelationHIS WHERE FHistoryRelateID=BURELATION.FID)";
        DbUtil.execute((Context)ctx, (String)insertSql);
        List<String> bizManageTypeIdList = SHRBizManageCommonTool.getEnableBizManageTypeIdList(ctx);
        for (String bizManageTypeId : bizManageTypeIdList) {
            StringBuffer deleteSql = new StringBuffer();
            deleteSql.append(" DELETE FROM T_HR_PersonBURelation WHERE FID IN (SELECT FHistoryRelateID FROM T_HR_PersonBURelationHIS) AND FState = 2 ");
            deleteSql.append(" AND FBIZMANAGETYPEID = ? ");
            deleteSql.append(" and fid not in ( ");
            deleteSql.append(" select a.fid from T_HR_PersonBuRelation a  ");
            deleteSql.append(" where a.fid = ( select top 1 b.fid  from T_HR_PersonBuRelation b where a.FPersonId = b.FPersonId and b.FBIZMANAGETYPEID = ? order by b.FCREATETIME desc) ");
            deleteSql.append(" and a.FBIZMANAGETYPEID = ? ");
            deleteSql.append(" and a.FPersonId in (select FPersonId  from T_HR_PersonBuRelation where FBIZMANAGETYPEID = ? group by FPersonId having count(*) > 1) ");
            deleteSql.append(" ) ");
            deleteSql.append(" and FPersonId in (select FPersonId  from T_HR_PersonBuRelation where FBIZMANAGETYPEID = ? group by FPersonId having count(*) > 1) ");
            DbUtil.execute((Context)ctx, (String)deleteSql.toString(), (Object[])new Object[]{bizManageTypeId, bizManageTypeId, bizManageTypeId, bizManageTypeId, bizManageTypeId});
        }
        String updateSql = "UPDATE T_HR_PersonBURelationHIS t0 SET  (FPersonID, FEmpOrgRelationID, FEmpPostExpHisID, FBizManageTypeID, FHrOrgUnitID, FBeginDate, FEndDate, FState, FItemState, FVersion, FUseDefault, FEFFDT, FComfirmMsgId, FCreatorID, FCreateTime, FLastUpdateUserID, FLastUpdateTime, FControlUnitID, FIsEmpInit, FDataSource,FDESCRIPTION_L1,FDESCRIPTION_L2,FDESCRIPTION_L3) = (SELECT FPersonID, FEmpOrgRelationID, FEmpPostExpHisID, FBizManageTypeID, FHrOrgUnitID, FBeginDate, FEndDate, FState, FItemState, FVersion, FUseDefault, FEFFDT, FComfirmMsgId, FCreatorID, FCreateTime, FLastUpdateUserID, FLastUpdateTime, FControlUnitID, FIsEmpInit, FDataSource,FDESCRIPTION_L1,FDESCRIPTION_L2,FDESCRIPTION_L3 FROM T_HR_PersonBURelation t1 WHERE t0.FHistoryRelateID = t1.FID AND t0.FState <> t1.FState)";
        DbUtil.execute((Context)ctx, (String)updateSql);
    }

    public static void movePersonBuRHisToPersonBuR(Context ctx, List<String> empRelaIdList, String bizManageTypeId) throws BOSException, EASBizException {
        String getPersonIDSql = "SELECT FPersonID FROM T_HR_EmpOrgRelation WHERE FID IN " + SHRBizManageCommonTool.list2SQLinclude(empRelaIdList);
        String insertSql = "insert into T_HR_PersonBURelation(FID,FPersonID, FEmpOrgRelationID, FEmpPostExpHisID, FBizManageTypeID, FHrOrgUnitID, FBeginDate, FEndDate, FState, FItemState, FVersion, FUseDefault, FEFFDT, FComfirmMsgId, FCreatorID, FCreateTime, FLastUpdateUserID, FLastUpdateTime, FControlUnitID, FIsEmpInit, FDataSource,FDESCRIPTION_L1,FDESCRIPTION_L2,FDESCRIPTION_L3) SELECT FHistoryRelateID,FPersonID, FEmpOrgRelationID, FEmpPostExpHisID, FBizManageTypeID, FHrOrgUnitID, FBeginDate, FEndDate, FState, FItemState, FVersion, FUseDefault, FEFFDT, FComfirmMsgId, FCreatorID, FCreateTime, FLastUpdateUserID, FLastUpdateTime, FControlUnitID, FIsEmpInit, FDataSource,FDESCRIPTION_L1,FDESCRIPTION_L2,FDESCRIPTION_L3 FROM T_HR_PersonBURelationHIS WHERE FHistoryRelateID NOT IN (SELECT FID FROM T_HR_PersonBURelation) AND FPersonID IN (" + getPersonIDSql + ")";
        if (!bizManageTypeId.equals("")) {
            insertSql = insertSql + "AND FBizManageTypeID = '" + bizManageTypeId + "'";
        }
        DbUtil.execute((Context)ctx, (String)insertSql);
    }

    public static void moveAdminBuRHisToAdminBuR(Context ctx, List<String> adminList, String bizManageTypeId) throws BOSException, EASBizException {
        String insertSql = "insert into T_HR_AdminOrgBURelation(FID,FAdminOrgID, FBizManageTypeID, FManageHrOrgID,FBeginDate, FEndDate, FState, FIsDefaultManage, FDescription_l1,FDescription_l2, FDescription_l3, FCreatorID, FCreateTime, FLastUpdateUserID,FLastUpdateTime, FControlUnitID, FCOMFIRMMSGID, FEFFDT,FDataSource) SELECT FHistoryRelateID,FAdminOrgID, FBizManageTypeID, FManageHrOrgID, FBeginDate, FEndDate, FState, FIsDefaultManage, FDescription_l1, FDescription_l2, FDescription_l3, FCreatorID, FCreateTime, FLastUpdateUserID, FLastUpdateTime, FControlUnitID, FCOMFIRMMSGID, FEFFDT,FDataSource FROM T_HR_AdminOrgBURelationHIS WHERE FHistoryRelateID NOT IN (SELECT FID FROM T_HR_AdminOrgBURelation) AND FAdminOrgID IN " + SHRBizManageCommonTool.list2SQLinclude(adminList);
        if (!bizManageTypeId.equals("")) {
            insertSql = insertSql + "AND FBizManageTypeID = '" + bizManageTypeId + "'";
        }
        DbUtil.execute((Context)ctx, (String)insertSql);
    }

    protected String getTime() {
        Calendar ca = Calendar.getInstance();
        ca.setTime(new Date());
        ca.add(2, -6);
        Timestamp timestamp = new Timestamp(ca.getTime().getTime());
        return DateUtils.paseTimestamp2String((Timestamp)timestamp, (String)"yyyy-MM-dd HH:mm:ss");
    }
}

