/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.shr.base.bizmanage.util;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.base.permission.UserInfo;
import com.kingdee.eas.basedata.org.HROrgUnitInfo;
import com.kingdee.eas.basedata.org.PositionCollection;
import com.kingdee.eas.basedata.org.PositionFactory;
import com.kingdee.eas.basedata.org.PositionInfo;
import com.kingdee.eas.basedata.person.PersonInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.hr.base.EmpPosOrgRelationInfo;
import com.kingdee.eas.hr.base.EmpPostExperienceHisInfo;
import com.kingdee.eas.util.app.ContextUtil;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.shr.base.bizmanage.BizManageState;
import com.kingdee.shr.base.bizmanage.BizManageTypeInfo;
import com.kingdee.shr.base.bizmanage.BizmanageBizException;
import com.kingdee.shr.base.bizmanage.PersonBURelationInfo;
import com.kingdee.shr.base.bizmanage.PersonBizManageFacadeFactory;
import com.kingdee.shr.base.bizmanage.SHRBizManageException;
import com.kingdee.shr.base.bizmanage.util.SHRBizManageCommonTool;
import com.kingdee.shr.base.bizmanage.util.SHRBizManageHelpUtil;
import com.kingdee.util.StringUtils;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;

public class SHRBizManageToOutInterfaceUtil {
    public static void personBillEntryToBizManage(Context ctx, String personID, String positionID, HashMap<String, String> bizManageMap, Date effDate) throws BOSException, EASBizException {
        try {
            PersonBURelationInfo tempInfo = new PersonBURelationInfo();
            if (StringUtils.isEmpty((String)personID)) {
                throw new SHRBizManageException(BizmanageBizException.EXCEPTION60);
            }
            if (StringUtils.isEmpty((String)positionID)) {
                throw new SHRBizManageException(BizmanageBizException.EXCEPTION61);
            }
            if (effDate == null) {
                effDate = new Date();
            }
            UserInfo currentUser = ContextUtil.getCurrentUserInfo((Context)ctx);
            Date now = new Date();
            PersonInfo personInfo = new PersonInfo();
            personInfo.setId(BOSUuid.read((String)personID));
            EmpPosOrgRelationInfo empPosOrgRelationInfo = new EmpPosOrgRelationInfo();
            String empOrgRelationID = SHRBizManageToOutInterfaceUtil.getEmpPosOrgRelationID(ctx, personID, positionID);
            empPosOrgRelationInfo.setId(BOSUuid.read((String)empOrgRelationID));
            EmpPostExperienceHisInfo empPostExperienceHisInfo = new EmpPostExperienceHisInfo();
            empPostExperienceHisInfo.setId(BOSUuid.read((String)SHRBizManageToOutInterfaceUtil.getEmpPostExpHisID(ctx, personID, positionID)));
            tempInfo.setPerson(personInfo);
            tempInfo.setEmpOrgRelation(empPosOrgRelationInfo);
            tempInfo.setEmpPostExpHis(empPostExperienceHisInfo);
            tempInfo.setState(BizManageState.New);
            tempInfo.setCreator(currentUser);
            tempInfo.setLastUpdateUser(currentUser);
            tempInfo.setLastUpdateTime(new Timestamp(now.getTime()));
            tempInfo.setCreateTime(new Timestamp(now.getTime()));
            tempInfo.setEFFDT(effDate);
            PositionInfo positionInfo = new PositionInfo();
            PositionCollection positionColl = PositionFactory.getLocalInstance((Context)ctx).getPositionCollection("select adminOrgUnit where id = '" + positionID + "'");
            if (positionColl.size() > 0) {
                positionInfo = positionColl.get(0);
            }
            List<String> bizManageTypeIdList = SHRBizManageCommonTool.getEnableBizManageTypeIdList(ctx);
            String hrOrgUnitID = "";
            HROrgUnitInfo hrOrgUnitInfo = new HROrgUnitInfo();
            for (String bizManageTypeId : bizManageTypeIdList) {
                if (bizManageMap.get(bizManageTypeId) != null) {
                    hrOrgUnitID = bizManageMap.get(bizManageTypeId);
                    hrOrgUnitInfo.setId(BOSUuid.read((String)hrOrgUnitID));
                } else {
                    hrOrgUnitInfo = SHRBizManageCommonTool.getDefaultManageOrg(ctx, positionInfo.getAdminOrgUnit().getId().toString(), bizManageTypeId);
                }
                PersonBURelationInfo personBuInfo = (PersonBURelationInfo)tempInfo.clone();
                BizManageTypeInfo BizManageTypeInfo2 = new BizManageTypeInfo();
                BizManageTypeInfo2.setId(BOSUuid.read((String)bizManageTypeId));
                personBuInfo.setBizManageType(BizManageTypeInfo2);
                personBuInfo.setHrOrgUnit(hrOrgUnitInfo);
                personBuInfo.setUseDefault(SHRBizManageHelpUtil.isPerosnBuRelationDefault(ctx, bizManageTypeId, empOrgRelationID, hrOrgUnitID));
                ArrayList<PersonBURelationInfo> resList = new ArrayList<PersonBURelationInfo>();
                resList.add(personBuInfo);
                IObjectPK[] pks = PersonBizManageFacadeFactory.getLocalInstance(ctx).batchAddNewPersonBizManage(resList);
                ArrayList<String> list = new ArrayList<String>();
                for (IObjectPK i : pks) {
                    list.add(i.toString());
                }
                PersonBizManageFacadeFactory.getLocalInstance(ctx).batchSubmitAndReceivePersonBizManage(list);
            }
        }
        catch (SQLException e) {
            e.printStackTrace();
            throw new BOSException((Throwable)e);
        }
    }

    private static String getEmpPosOrgRelationID(Context ctx, String personID, String positionID) throws BOSException, SQLException {
        String query = "SELECT FID FROM T_HR_EmpOrgRelation WHERE FPersonID = '" + personID + "' AND FPositionID = '" + positionID + "' AND FLEFFDT = {TS '2199-12-31'}";
        IRowSet ir = DbUtil.executeQuery((Context)ctx, (String)query);
        if (ir.size() > 0) {
            ir.next();
            return ir.getString("FID");
        }
        return null;
    }

    private static String getEmpPostExpHisID(Context ctx, String personID, String positionID) throws BOSException, SQLException {
        String query = "SELECT FID FROM T_HR_EmpPostExperienceHis WHERE FPersonID = '" + personID + "' AND FPositionID = '" + positionID + "' AND FLEFFDT = {TS '2199-12-31'}";
        IRowSet ir = DbUtil.executeQuery((Context)ctx, (String)query);
        if (ir.size() > 0) {
            ir.next();
            return ir.getString("FID");
        }
        return null;
    }
}

