/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.shr.certificationservice.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.IMetaDataLoader;
import com.kingdee.bos.metadata.MetaDataLoaderFactory;
import com.kingdee.bos.metadata.data.SortType;
import com.kingdee.bos.metadata.entity.EntityObjectInfo;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.entity.SorterItemCollection;
import com.kingdee.bos.metadata.entity.SorterItemInfo;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.base.multiapprove.ApproveResult;
import com.kingdee.eas.base.multiapprove.IMultiApprove;
import com.kingdee.eas.base.multiapprove.MultiApproveFactory;
import com.kingdee.eas.base.multiapprove.MultiApproveInfo;
import com.kingdee.eas.basedata.person.PersonInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.hr.affair.IResignBizBillEntry;
import com.kingdee.eas.hr.affair.ResignBizBillEntryCollection;
import com.kingdee.eas.hr.affair.ResignBizBillEntryFactory;
import com.kingdee.eas.hr.affair.ResignBizBillEntryInfo;
import com.kingdee.eas.hr.base.ApproveTypeEnum;
import com.kingdee.eas.hr.base.HRBillBaseInfo;
import com.kingdee.eas.hr.base.HRBillStateEnum;
import com.kingdee.eas.hr.base.app.BillExtendBeanProcess;
import com.kingdee.eas.hr.base.app.HRBillBeanBizFactory;
import com.kingdee.eas.hr.base.app.IHRBillBizBean;
import com.kingdee.eas.hr.base.app.PlugInBeanFactory;
import com.kingdee.eas.hr.base.app.PlugInBeanProxy;
import com.kingdee.eas.hr.base.util.IReflectMethod;
import com.kingdee.eas.util.ResourceBase;
import com.kingdee.shr.certificationservice.CertificationException;
import com.kingdee.shr.certificationservice.CertificationTempletCollection;
import com.kingdee.shr.certificationservice.CertificationTempletFactory;
import com.kingdee.shr.certificationservice.CertificationTempletInfo;
import com.kingdee.shr.certificationservice.HRCertificationBillFactory;
import com.kingdee.shr.certificationservice.HRCertificationBillInfo;
import com.kingdee.shr.certificationservice.HRCertificationBillTypeFactory;
import com.kingdee.shr.certificationservice.HRCertificationBillTypeInfo;
import com.kingdee.shr.certificationservice.HRCertificationExtendFactory;
import com.kingdee.shr.certificationservice.HRCertificationExtendInfo;
import com.kingdee.shr.certificationservice.app.AbstractHRCertificationBillControllerBean;
import com.kingdee.shr.certificationservice.app.CertificateBillSource;
import com.kingdee.shr.certificationservice.app.CertificateBillType;
import com.kingdee.shr.certificationservice.util.FieldValueRelationUtil;
import com.kingdee.util.StringUtils;
import java.util.Locale;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HRCertificationBillControllerBean
extends AbstractHRCertificationBillControllerBean {
    private static final Logger logger = LoggerFactory.getLogger(HRCertificationBillControllerBean.class);

    protected IObjectPK _save(Context ctx, IObjectValue model) throws BOSException, EASBizException {
        HRCertificationBillInfo billInfo = (HRCertificationBillInfo)model;
        IObjectPK _save = super._save(ctx, model);
        this._afterSave(ctx, billInfo);
        return _save;
    }

    protected void _submit(Context ctx, IObjectPK pk, IObjectValue model) throws BOSException, EASBizException {
        HRCertificationBillInfo billInfo = (HRCertificationBillInfo)model;
        this.checkModel(ctx, billInfo);
        super._submit(ctx, pk, model);
    }

    protected void checkModel(Context ctx, HRCertificationBillInfo billInfo) throws BOSException, EASBizException {
        if (!billInfo.isIsSpecial()) {
            String certificationBillTypeId = billInfo.getCertificationBillType() == null ? "" : billInfo.getCertificationBillType().getId().toString();
            this.checkCertificationBillType(ctx, certificationBillTypeId);
        }
    }

    private void checkCertificationBillType(Context ctx, String certificationBillTypeId) throws EASBizException, BOSException {
        if (StringUtils.isEmpty((String)certificationBillTypeId)) {
            throw new CertificationException(CertificationException.NO_TEMPLATE);
        }
        CertificationTempletCollection coll = CertificationTempletFactory.getLocalInstance(ctx).getCertificationTempletCollection("where certificationBillType = '" + certificationBillTypeId + "' and state=1");
        if (coll.size() == 0) {
            throw new CertificationException(CertificationException.NO_TEMPLATE);
        }
        if (coll.size() > 1) {
            throw new CertificationException(CertificationException.MUCH_TEMPLATE);
        }
        CertificationTempletInfo certificationTempletInfo = coll.get(0);
        if (StringUtils.isEmpty((String)certificationTempletInfo.getConfig())) {
            throw new CertificationException(CertificationException.NO_MATCH_FIELD);
        }
    }

    @Override
    protected void _update(Context ctx, IObjectPK pk, IObjectValue model) throws BOSException, EASBizException {
        HRCertificationBillInfo billInfo = (HRCertificationBillInfo)model;
        HRCertificationExtendInfo extendinfo = billInfo.getExtendinfo();
        HRCertificationBillInfo oldBillInfo = HRCertificationBillFactory.getLocalInstance(ctx).getHRCertificationBillInfo((IObjectPK)new ObjectUuidPK(model.getString("id")));
        HRCertificationExtendInfo oldExtendInfo = oldBillInfo.getExtendinfo();
        if (oldExtendInfo != null && extendinfo != null) {
            oldExtendInfo.setIncomeType(extendinfo.getIncomeType());
            oldExtendInfo.setExpectedIncome(extendinfo.getExpectedIncome());
            ObjectUuidPK pkExt = new ObjectUuidPK(oldExtendInfo.getId().toString());
            HRCertificationExtendFactory.getLocalInstance(ctx).save((IObjectPK)pkExt, oldExtendInfo);
        } else if (oldExtendInfo == null && extendinfo != null) {
            IObjectPK pkExt = HRCertificationExtendFactory.getLocalInstance(ctx).save(extendinfo);
            extendinfo.setId(BOSUuid.read((String)pkExt.toString()));
            billInfo.setExtendinfo(extendinfo);
        }
        super._update(ctx, pk, (IObjectValue)billInfo);
    }

    @Override
    protected IObjectPK _addnew(Context ctx, IObjectValue model) throws BOSException, EASBizException {
        HRCertificationBillInfo billInfo = (HRCertificationBillInfo)model;
        HRCertificationExtendInfo extendinfo = billInfo.getExtendinfo();
        if (StringUtils.isEmpty((String)model.getString("id")) && extendinfo != null) {
            String extendinfoPK = HRCertificationExtendFactory.getLocalInstance(ctx).save(extendinfo).toString();
            extendinfo.setId(BOSUuid.read((String)extendinfoPK));
            billInfo.setExtendinfo(extendinfo);
        }
        return super._addnew(ctx, (IObjectValue)billInfo);
    }

    protected void _auditEntryEffect(Context ctx, BOSUuid billID) throws BOSException, EASBizException {
        if (billID == null) {
            return;
        }
        HRBillBaseInfo model = this.getHRBillBaseInfo(ctx, (IObjectPK)new ObjectUuidPK(billID));
        Object entry = null;
        String billField = this.getBillField();
        IHRBillBizBean bizBean = null;
        bizBean = this.initBizBean(ctx, bizBean);
        this.updateBillState(ctx, billID, HRBillStateEnum.AUDITED);
        if (bizBean != null) {
            bizBean._setBillState(ctx, billID, HRBillStateEnum.AUDITED);
        }
        if (ApproveTypeEnum.DIRECT.equals((Object)model.getApproveType())) {
            this.saveMultiApproveInfo(ctx, billID);
        }
    }

    protected IHRBillBizBean initBizBean(Context ctx, IHRBillBizBean bizBean) throws BOSException, EASBizException {
        if (bizBean == null && (bizBean = this.getBizBean()) != null) {
            BillExtendBeanProcess billExtend = BillExtendBeanProcess.getInstance((String)bizBean.getExtendBillName(ctx));
            PlugInBeanProxy plugIn = null;
            IMetaDataLoader loader = MetaDataLoaderFactory.getLocalMetaDataLoader((Context)ctx);
            EntityObjectInfo entity = loader.getEntity(this.getBOSType());
            if (entity != null) {
                String fullName = entity.getFullName();
                try {
                    plugIn = PlugInBeanFactory.getPlugIn((Context)ctx, (String)fullName);
                }
                catch (Exception e) {
                    throw new BOSException("PlugInBean Get Error:" + e.getMessage(), e.getCause());
                }
            }
            IReflectMethod[] decorators = null;
            if (plugIn != null && billExtend != null) {
                decorators = new IReflectMethod[]{plugIn, billExtend};
            } else if (billExtend != null) {
                decorators = new IReflectMethod[]{billExtend};
            } else if (plugIn != null) {
                decorators = new IReflectMethod[]{plugIn};
            }
            if (decorators != null) {
                try {
                    bizBean = new HRBillBeanBizFactory(bizBean).getBizProxy(decorators);
                }
                catch (Throwable e) {
                    throw new BOSException("bizBean:" + bizBean.getExtendBillName(ctx) + ";plugin:" + plugIn, e);
                }
            }
        }
        return bizBean;
    }

    protected void saveMultiApproveInfo(Context ctx, BOSUuid billId) throws BOSException, EASBizException {
        IMultiApprove im = MultiApproveFactory.getLocalInstance((Context)ctx);
        MultiApproveInfo info = new MultiApproveInfo();
        info.setIsPass(ApproveResult.PASS);
        info.setOpinion(ResourceBase.getString((String)"com.kingdee.eas.hr.base.BASEAutoGenerateResource", (String)"0_HRBillBaseControllerBean", (Locale)ctx.getLocale()));
        info.setBillId(billId);
        info.setBosTypeStr(billId.getType().toString());
        im.addnew((CoreBaseInfo)info);
    }

    protected IObjectPK _submit(Context ctx, IObjectValue model) throws BOSException, EASBizException {
        HRCertificationBillTypeInfo billTypeInfo;
        HRCertificationBillInfo billInfo = (HRCertificationBillInfo)model;
        HRCertificationExtendInfo extendinfo = billInfo.getExtendinfo();
        if (StringUtils.isEmpty((String)model.getString("id"))) {
            if (extendinfo != null) {
                String extendinfoPK = HRCertificationExtendFactory.getLocalInstance(ctx).addnew(extendinfo).toString();
                extendinfo.setId(BOSUuid.read((String)extendinfoPK));
                billInfo.setExtendinfo(extendinfo);
            }
        } else {
            IObjectPK pk;
            HRCertificationBillInfo oldBillInfo = HRCertificationBillFactory.getLocalInstance(ctx).getHRCertificationBillInfo((IObjectPK)new ObjectUuidPK(model.getString("id")));
            HRCertificationExtendInfo oldExtendInfo = oldBillInfo.getExtendinfo();
            if (oldExtendInfo != null && extendinfo != null) {
                oldExtendInfo.setIncomeType(extendinfo.getIncomeType());
                oldExtendInfo.setExpectedIncome(extendinfo.getExpectedIncome());
                pk = new ObjectUuidPK(oldExtendInfo.getId().toString());
                HRCertificationExtendFactory.getLocalInstance(ctx).update(pk, oldExtendInfo);
            } else if (oldExtendInfo == null && extendinfo != null) {
                pk = HRCertificationExtendFactory.getLocalInstance(ctx).addnew(extendinfo);
                extendinfo.setId(BOSUuid.read((String)pk.toString()));
                billInfo.setExtendinfo(extendinfo);
            }
        }
        IObjectPK pk = super._submit(ctx, (IObjectValue)billInfo);
        billInfo.setId(BOSUuid.read((String)pk.toString()));
        if (billInfo.getCertificationBillType() != null && (billTypeInfo = HRCertificationBillTypeFactory.getLocalInstance(ctx).getHRCertificationBillTypeInfo((IObjectPK)new ObjectUuidPK(BOSUuid.read((String)billInfo.getCertificationBillType().getId().toString())))).getBillType().equals((Object)CertificateBillType.Income)) {
            String billTypeId = billInfo.getCertificationBillType().getId().toString();
            CertificationTempletCollection templetCollection = CertificationTempletFactory.getLocalInstance(ctx).getCertificationTempletCollection("where certificationBillType = '" + billTypeId + "' and state=1");
            if (templetCollection.size() == 0) {
                logger.error("no matched certification template");
            } else if (templetCollection.size() == 1) {
                String configStr = templetCollection.get(0).getConfig();
                PersonInfo person = billInfo.getPerson();
                if (person != null) {
                    FieldValueRelationUtil.fillValue(ctx, configStr, person.getId().toString(), billInfo.getId().toString());
                } else {
                    logger.error("no person with the certification");
                }
            } else if (templetCollection.size() > 1) {
                logger.error("so much certification template with the one");
            }
        }
        return pk;
    }

    protected void _check(Context ctx, IObjectPK pk, IObjectValue model) throws BOSException, EASBizException {
        super._check(ctx, pk, model);
    }

    protected void _afterSave(Context ctx, HRCertificationBillInfo billInfo) throws BOSException, EASBizException {
        this._updateResignBillEntry(ctx, billInfo);
    }

    protected void _updateResignBillEntry(Context ctx, HRCertificationBillInfo billInfo) throws BOSException, EASBizException {
        logger.error("HRCertificationBillControllerBean._updateResignBillEntry ...start  ");
        try {
            HRCertificationBillTypeInfo certificationBillType = billInfo.getCertificationBillType();
            CertificateBillType billType = certificationBillType.getBillType();
            if (billType == null) {
                certificationBillType = HRCertificationBillTypeFactory.getLocalInstance(ctx).getHRCertificationBillTypeInfo((IObjectPK)new ObjectUuidPK(certificationBillType.getId()));
                billType = certificationBillType.getBillType();
            }
            if (CertificateBillSource.CertificateEmp.equals((Object)billInfo.getBillSource()) && CertificateBillType.Resign.equals((Object)billType)) {
                String resignBillId = billInfo.getString("resignBillId");
                EntityViewInfo view = new EntityViewInfo();
                FilterInfo filter = new FilterInfo();
                String personId = billInfo.getPerson().getId().toString();
                logger.error("_updateResignBillEntry personid  " + personId + " : " + resignBillId);
                if (StringUtils.isEmpty((String)resignBillId)) {
                    filter.getFilterItems().add(new FilterItemInfo("person.id", (Object)personId));
                } else {
                    filter.getFilterItems().add(new FilterItemInfo("bill.id", (Object)resignBillId));
                }
                SorterItemCollection sorter = new SorterItemCollection();
                SorterItemInfo sorterItemInfo = new SorterItemInfo("bill.createTime");
                sorterItemInfo.setSortType(SortType.DESCEND);
                sorter.add(sorterItemInfo);
                filter.getFilterItems().add(new FilterItemInfo("bill.billState", (Object)3));
                view.setFilter(filter);
                view.setSorter(sorter);
                SelectorItemCollection selector = new SelectorItemCollection();
                selector.add(new SelectorItemInfo("id"));
                view.setSelector(selector);
                IResignBizBillEntry iResignBizBillEntry = ResignBizBillEntryFactory.getLocalInstance((Context)ctx);
                ResignBizBillEntryCollection resignBizBillEntryCollection = iResignBizBillEntry.getResignBizBillEntryCollection(view);
                if (resignBizBillEntryCollection != null && resignBizBillEntryCollection.size() > 0) {
                    ResignBizBillEntryInfo resignBillEntryInfo = resignBizBillEntryCollection.get(0);
                    logger.error("_updateResignBillEntry resignBillEntryInfo  " + resignBillEntryInfo.getId().toString());
                    resignBillEntryInfo.setCertBill(billInfo);
                    selector.clear();
                    selector.add(new SelectorItemInfo("certBill"));
                    iResignBizBillEntry.updatePartial((CoreBaseInfo)resignBillEntryInfo, selector);
                }
            }
        }
        catch (Exception e) {
            logger.error(e.getMessage(), (Throwable)e);
        }
    }
}

